// <auto-generated />

using System;
using System.Reflection;
using System.Resources;
using System.Threading;
using Microsoft.EntityFrameworkCore.Diagnostics;
using Microsoft.EntityFrameworkCore.Internal;
using Microsoft.Extensions.Logging;

#nullable enable

namespace Microsoft.EntityFrameworkCore.Diagnostics
{
    /// <summary>
    ///     <para>
    ///         String resources used in EF exceptions, etc.
    ///     </para>
    ///     <para>
    ///         These strings are exposed publicly for use by database providers and extensions.
    ///         It is unusual for application code to need these strings.
    ///     </para>
    /// </summary>
    public static class CoreStrings
    {
        private static readonly ResourceManager _resourceManager
            = new ResourceManager("Microsoft.EntityFrameworkCore.Properties.CoreStrings", typeof(CoreStrings).Assembly);

        /// <summary>
        ///     The corresponding CLR type for entity type '{entityType}' cannot be instantiated, and there is no derived entity type in the model that corresponds to a concrete CLR type.
        /// </summary>
        public static string AbstractLeafEntityType(object? entityType)
            => string.Format(
                GetString("AbstractLeafEntityType", nameof(entityType)),
                entityType);

        /// <summary>
        ///     Cannot add type '{typeName}' to the model as it is a dynamically-generated proxy type.
        /// </summary>
        public static string AddingProxyTypeAsEntityType(object? typeName)
            => string.Format(
                GetString("AddingProxyTypeAsEntityType", nameof(typeName)),
                typeName);

        /// <summary>
        ///     The entity type '{entityType}' uses a shared type and the supplied entity is currently referenced from several owner entities. To access the entry for a particular reference, call '{targetEntryCall}' on the owner entry.
        /// </summary>
        public static string AmbiguousDependentEntity(object? entityType, object? targetEntryCall)
            => string.Format(
                GetString("AmbiguousDependentEntity", nameof(entityType), nameof(targetEntryCall)),
                entityType, targetEntryCall);

        /// <summary>
        ///     The foreign key {foreignKeyProperties} on entity type '{entityType}' cannot be configured as having a required dependent since the dependent side cannot be determined. To identify the dependent side of the relationship, configure the foreign key property in 'OnModelCreating'. See https://go.microsoft.com/fwlink/?LinkId=724062 for more details.
        /// </summary>
        public static string AmbiguousEndRequiredDependent(object? foreignKeyProperties, object? entityType)
            => string.Format(
                GetString("AmbiguousEndRequiredDependent", nameof(foreignKeyProperties), nameof(entityType)),
                foreignKeyProperties, entityType);

        /// <summary>
        ///     The navigation '{entityType}.{navigation}' cannot be configured as required since the dependent side of the underlying foreign key {foreignKeyProperties} cannot be determined. To identify the dependent side of the relationship, configure the foreign key property in 'OnModelCreating'. See https://go.microsoft.com/fwlink/?LinkId=724062 for more details.
        /// </summary>
        public static string AmbiguousEndRequiredDependentNavigation(object? entityType, object? navigation, object? foreignKeyProperties)
            => string.Format(
                GetString("AmbiguousEndRequiredDependentNavigation", nameof(entityType), nameof(navigation), nameof(foreignKeyProperties)),
                entityType, navigation, foreignKeyProperties);

        /// <summary>
        ///     The foreign key {foreignKeyProperties} on entity type '{entityType}' cannot be inverted to entity type '{principalEntityType}' since it was configured as required before the dependent side was configured. Configure the foreign key property or the principal key before configuring the foreign key as required. See https://go.microsoft.com/fwlink/?LinkId=724062 for more details.
        /// </summary>
        public static string AmbiguousEndRequiredInverted(object? foreignKeyProperties, object? entityType, object? principalEntityType)
            => string.Format(
                GetString("AmbiguousEndRequiredInverted", nameof(foreignKeyProperties), nameof(entityType), nameof(principalEntityType)),
                foreignKeyProperties, entityType, principalEntityType);

        /// <summary>
        ///     Both relationships between '{firstDependentToPrincipalNavigationSpecification}' and '{firstPrincipalToDependentNavigationSpecification}' and between '{secondDependentToPrincipalNavigationSpecification}' and '{secondPrincipalToDependentNavigationSpecification}' could use {foreignKeyProperties} as the foreign key. To resolve this, configure the foreign key properties explicitly in 'OnModelCreating' on at least one of the relationships.
        /// </summary>
        public static string AmbiguousForeignKeyPropertyCandidates(object? firstDependentToPrincipalNavigationSpecification, object? firstPrincipalToDependentNavigationSpecification, object? secondDependentToPrincipalNavigationSpecification, object? secondPrincipalToDependentNavigationSpecification, object? foreignKeyProperties)
            => string.Format(
                GetString("AmbiguousForeignKeyPropertyCandidates", nameof(firstDependentToPrincipalNavigationSpecification), nameof(firstPrincipalToDependentNavigationSpecification), nameof(secondDependentToPrincipalNavigationSpecification), nameof(secondPrincipalToDependentNavigationSpecification), nameof(foreignKeyProperties)),
                firstDependentToPrincipalNavigationSpecification, firstPrincipalToDependentNavigationSpecification, secondDependentToPrincipalNavigationSpecification, secondPrincipalToDependentNavigationSpecification, foreignKeyProperties);

        /// <summary>
        ///     The dependent side could not be determined for the one-to-one relationship between '{dependentToPrincipalNavigationSpecification}' and '{principalToDependentNavigationSpecification}'. To identify the dependent side of the relationship, configure the foreign key property. If these navigations should not be part of the same relationship, configure them independently via separate method chains in 'OnModelCreating'. See https://go.microsoft.com/fwlink/?LinkId=724062 for more details.
        /// </summary>
        public static string AmbiguousOneToOneRelationship(object? dependentToPrincipalNavigationSpecification, object? principalToDependentNavigationSpecification)
            => string.Format(
                GetString("AmbiguousOneToOneRelationship", nameof(dependentToPrincipalNavigationSpecification), nameof(principalToDependentNavigationSpecification)),
                dependentToPrincipalNavigationSpecification, principalToDependentNavigationSpecification);

        /// <summary>
        ///     Unable to determine the owner for the relationship between '{entityTypeNavigationSpecification}' and '{otherEntityType}' as both types have been marked as owned. Either manually configure the ownership, or ignore the corresponding navigations using the [NotMapped] attribute or by using 'EntityTypeBuilder.Ignore' in 'OnModelCreating'. See https://aka.ms/efcore-docs-owned for more information and examples.
        /// </summary>
        public static string AmbiguousOwnedNavigation(object? entityTypeNavigationSpecification, object? otherEntityType)
            => string.Format(
                GetString("AmbiguousOwnedNavigation", nameof(entityTypeNavigationSpecification), nameof(otherEntityType)),
                entityTypeNavigationSpecification, otherEntityType);

        /// <summary>
        ///     The shared type entity type '{entityType}' cannot be added to the model because its name is the same as the CLR type name. This usually indicates an error, either add it as a non-shared entity type or choose a different name.
        /// </summary>
        public static string AmbiguousSharedTypeEntityTypeName(object? entityType)
            => string.Format(
                GetString("AmbiguousSharedTypeEntityTypeName", nameof(entityType)),
                entityType);

        /// <summary>
        ///     The annotation '{annotation}' was not found. Ensure that the annotation has been added to the object {annotatable}
        /// </summary>
        public static string AnnotationNotFound(object? annotation, object? annotatable)
            => string.Format(
                GetString("AnnotationNotFound", nameof(annotation), nameof(annotatable)),
                annotation, annotatable);

        /// <summary>
        ///     Cannot apply both anonymous and named query filters simultaneously. Please specify either an anonymous filter or one or more named filters.
        /// </summary>
        public static string AnonymousAndNamedFiltersCombined
            => GetString("AnonymousAndNamedFiltersCombined");

        /// <summary>
        ///     The '{parameter}' value passed to '{methodName}' must be a constant.
        /// </summary>
        public static string ArgumentNotConstant(object? parameter, object? methodName)
            => string.Format(
                GetString("ArgumentNotConstant", nameof(parameter), nameof(methodName)),
                parameter, methodName);

        /// <summary>
        ///     The property '{property}' of the argument '{argument}' cannot be null.
        /// </summary>
        public static string ArgumentPropertyNull(object? property, object? argument)
            => string.Format(
                GetString("ArgumentPropertyNull", nameof(property), nameof(argument)),
                property, argument);

        /// <summary>
        ///     The [{attribute}] attribute may only be specified on entity type properties. Remove the attribute from '{type}.{propertyName}'.
        /// </summary>
        public static string AttributeNotOnEntityTypeProperty(object? attribute, object? type, object? propertyName)
            => string.Format(
                GetString("AttributeNotOnEntityTypeProperty", nameof(attribute), nameof(type), nameof(propertyName)),
                attribute, type, propertyName);

        /// <summary>
        ///     Cycle detected while auto-including navigations: {cycleNavigations}. To fix this issue, either don't configure at least one navigation in the cycle as auto included in 'OnModelCreating' or call 'IgnoreAutoInclude' method on the query.
        /// </summary>
        public static string AutoIncludeNavigationCycle(object? cycleNavigations)
            => string.Format(
                GetString("AutoIncludeNavigationCycle", nameof(cycleNavigations)),
                cycleNavigations);

        /// <summary>
        ///     Cannot set backing field '{field}' for the indexer property '{entityType}.{property}'. Ensure no backing fields are specified for indexer properties.
        /// </summary>
        public static string BackingFieldOnIndexer(object? field, object? entityType, object? property)
            => string.Format(
                GetString("BackingFieldOnIndexer", nameof(field), nameof(entityType), nameof(property)),
                field, entityType, property);

        /// <summary>
        ///     The specified field '{field}' of type '{fieldType}' cannot be used for the property '{entityType}.{property}' of type '{propertyType}'. Only backing fields of types that are compatible with the property type can be used.
        /// </summary>
        public static string BadBackingFieldType(object? field, object? fieldType, object? entityType, object? property, object? propertyType)
            => string.Format(
                GetString("BadBackingFieldType", nameof(field), nameof(fieldType), nameof(entityType), nameof(property), nameof(propertyType)),
                field, fieldType, entityType, property, propertyType);

        /// <summary>
        ///     The service dependencies type '{dependenciesType}' has been registered incorrectly in the service collection. Service dependencies types must only be registered by Entity Framework or database providers.
        /// </summary>
        public static string BadDependencyRegistration(object? dependenciesType)
            => string.Format(
                GetString("BadDependencyRegistration", nameof(dependenciesType)),
                dependenciesType);

        /// <summary>
        ///     The value '{enumValue}' could not be parsed as a value of enum {enumType}.
        /// </summary>
        public static string BadEnumValue(object? enumValue, object? enumType)
            => string.Format(
                GetString("BadEnumValue", nameof(enumValue), nameof(enumType)),
                enumValue, enumType);

        /// <summary>
        ///     The filter expression '{filter}' cannot be specified for entity type '{entityType}'. A filter may only be applied to the root entity type '{rootType}'.
        /// </summary>
        public static string BadFilterDerivedType(object? filter, object? entityType, object? rootType)
            => string.Format(
                GetString("BadFilterDerivedType", nameof(filter), nameof(entityType), nameof(rootType)),
                filter, entityType, rootType);

        /// <summary>
        ///     The filter expression '{filter}' specified for entity type '{entityType}' is invalid. The expression must accept a single parameter of type '{clrType}' and return bool.
        /// </summary>
        public static string BadFilterExpression(object? filter, object? entityType, object? clrType)
            => string.Format(
                GetString("BadFilterExpression", nameof(filter), nameof(entityType), nameof(clrType)),
                filter, entityType, clrType);

        /// <summary>
        ///     The filter expression '{filter}' cannot be specified for owned entity type '{entityType}'. A filter may only be applied to an entity type that is not owned. See https://aka.ms/efcore-docs-owned for more information and examples.
        /// </summary>
        public static string BadFilterOwnedType(object? filter, object? entityType)
            => string.Format(
                GetString("BadFilterOwnedType", nameof(filter), nameof(entityType)),
                filter, entityType);

        /// <summary>
        ///     The type '{givenType}' cannot be used as a 'JsonValueReaderWriter' because it does not inherit from the generic 'JsonValueReaderWriter&lt;TValue&gt;'. Make sure to inherit json reader/writers from 'JsonValueReaderWriter&lt;TValue&gt;'.
        /// </summary>
        public static string BadJsonValueReaderWriterType(object? givenType)
            => string.Format(
                GetString("BadJsonValueReaderWriterType", nameof(givenType)),
                givenType);

        /// <summary>
        ///     The type '{givenType}' cannot be used as a primitive collection because it is not an array and does not implement '{listType}'. Collections of primitive types must be arrays or ordered lists.
        /// </summary>
        public static string BadListType(object? givenType, object? listType)
            => string.Format(
                GetString("BadListType", nameof(givenType), nameof(listType)),
                givenType, listType);

        /// <summary>
        ///     The type '{givenType}' cannot be used as a value comparer because it does not inherit from '{expectedType}'. Make sure to inherit value comparers from '{expectedType}'.
        /// </summary>
        public static string BadValueComparerType(object? givenType, object? expectedType)
            => string.Format(
                GetString("BadValueComparerType", nameof(givenType), nameof(expectedType)),
                givenType, expectedType);

        /// <summary>
        ///     The type '{givenType}' cannot be used as a value converter because it does not inherit from '{expectedType}'. Make sure to inherit value converters from '{expectedType}'.
        /// </summary>
        public static string BadValueConverterType(object? givenType, object? expectedType)
            => string.Format(
                GetString("BadValueConverterType", nameof(givenType), nameof(expectedType)),
                givenType, expectedType);

        /// <summary>
        ///     The type '{givenType}' cannot be used as a value generator because it does not inherit from '{expectedType}'. Make sure to inherit value generators from '{expectedType}'.
        /// </summary>
        public static string BadValueGeneratorType(object? givenType, object? expectedType)
            => string.Format(
                GetString("BadValueGeneratorType", nameof(givenType), nameof(expectedType)),
                givenType, expectedType);

        /// <summary>
        ///     The property '{1_entityType}.{0_property}' cannot be marked as nullable/optional because the type of the property is '{propertyType}' which is not a nullable type. Any property can be marked as non-nullable/required, but only properties of nullable types can be marked as nullable/optional.
        /// </summary>
        public static string CannotBeNullable(object? property, object? entityType, object? propertyType)
            => string.Format(
                GetString("CannotBeNullable", "0_property", "1_entityType", nameof(propertyType)),
                property, entityType, propertyType);

        /// <summary>
        ///     The element type of property '{entityType}.{property}' cannot be marked as nullable/optional because the type of the element is '{elementType}' which is not a nullable type. Any element type can be marked as non-nullable/required, but only elements of nullable types can be marked as nullable/optional.
        /// </summary>
        public static string CannotBeNullableElement(object? entityType, object? property, object? elementType)
            => string.Format(
                GetString("CannotBeNullableElement", nameof(entityType), nameof(property), nameof(elementType)),
                entityType, property, elementType);

        /// <summary>
        ///     The property '{1_entityType}.{0_property}' cannot be marked as nullable/optional because the property is a part of a key. Any property can be marked as non-nullable/required, but only properties of nullable types and which are not part of a key can be marked as nullable/optional.
        /// </summary>
        public static string CannotBeNullablePK(object? property, object? entityType)
            => string.Format(
                GetString("CannotBeNullablePK", "0_property", "1_entityType"),
                property, entityType);

        /// <summary>
        ///     Cannot convert string value '{value}' from the database to any value in the mapped '{enumType}' enum.
        /// </summary>
        public static string CannotConvertEnumValue(object? value, object? enumType)
            => string.Format(
                GetString("CannotConvertEnumValue", nameof(value), nameof(enumType)),
                value, enumType);

        /// <summary>
        ///     Unable to convert a queryable method to an enumerable method. This is likely an issue in Entity Framework, please file an issue at https://go.microsoft.com/fwlink/?linkid=2142044.
        /// </summary>
        public static string CannotConvertQueryableToEnumerableMethod
            => GetString("CannotConvertQueryableToEnumerableMethod");

        /// <summary>
        ///     Cannot create an instance of reader/writer type '{readerWriterType}'. Ensure that the type can be instantiated and has a public parameterless constructor, or has a public static 'Instance' field returning the singleton instance to use.
        /// </summary>
        public static string CannotCreateJsonValueReaderWriter(object? readerWriterType)
            => string.Format(
                GetString("CannotCreateJsonValueReaderWriter", nameof(readerWriterType)),
                readerWriterType);

        /// <summary>
        ///     Cannot create an instance of value comparer type '{generatorType}'. Ensure that the type can be instantiated and has a parameterless constructor, or use the overload of '{method}' that accepts a delegate.
        /// </summary>
        public static string CannotCreateValueComparer(object? generatorType, object? method)
            => string.Format(
                GetString("CannotCreateValueComparer", nameof(generatorType), nameof(method)),
                generatorType, method);

        /// <summary>
        ///     Cannot create an instance of value converter type '{generatorType}'. Ensure that the type can be instantiated and has a parameterless constructor, or use the overload of '{method}' that accepts a delegate.
        /// </summary>
        public static string CannotCreateValueConverter(object? generatorType, object? method)
            => string.Format(
                GetString("CannotCreateValueConverter", nameof(generatorType), nameof(method)),
                generatorType, method);

        /// <summary>
        ///     Cannot create an instance of value generator type '{generatorType}'. Ensure that the type can be instantiated and has a parameterless constructor, or use the overload of '{method}' that accepts a delegate.
        /// </summary>
        public static string CannotCreateValueGenerator(object? generatorType, object? method)
            => string.Format(
                GetString("CannotCreateValueGenerator", nameof(generatorType), nameof(method)),
                generatorType, method);

        /// <summary>
        ///     The navigation '{1_entityType}.{0_navigation}' cannot be loaded because one or more of the key or foreign key properties are shadow properties and the entity is not being tracked. Relationships using shadow values can only be loaded for tracked entities.
        /// </summary>
        public static string CannotLoadDetachedShadow(object? navigation, object? entityType)
            => string.Format(
                GetString("CannotLoadDetachedShadow", "0_navigation", "1_entityType"),
                navigation, entityType);

        /// <summary>
        ///     The type '{type}' cannot be marked as a non-shared type since a shared type entity type with this CLR type exists in the model.
        /// </summary>
        public static string CannotMarkNonShared(object? type)
            => string.Format(
                GetString("CannotMarkNonShared", nameof(type)),
                type);

        /// <summary>
        ///     The type '{type}' cannot be marked as a shared type since an entity type with the same CLR type already exists in the model.
        /// </summary>
        public static string CannotMarkShared(object? type)
            => string.Format(
                GetString("CannotMarkShared", nameof(type)),
                type);

        /// <summary>
        ///     Unable to create an instance of entity type '{entityType}' because it is abstract. Consider making it non-abstract or mapping at least one derived type.
        /// </summary>
        public static string CannotMaterializeAbstractType(object? entityType)
            => string.Format(
                GetString("CannotMaterializeAbstractType", nameof(entityType)),
                entityType);

        /// <summary>
        ///     Navigation '{1_entityType}.{0_navigationName}' was not found. Please add the navigation to the entity type using HasOne, HasMany, or OwnsOne/OwnsMany methods before configuring it.
        /// </summary>
        public static string CanOnlyConfigureExistingNavigations(object? navigationName, object? entityType)
            => string.Format(
                GetString("CanOnlyConfigureExistingNavigations", "0_navigationName", "1_entityType"),
                navigationName, entityType);

        /// <summary>
        ///     The entity type '{entityType}' is configured to use the '{changeTrackingStrategy}' change tracking strategy, but does not implement the required '{notificationInterface}' interface. Implement '{notificationInterface}' on '{entityType}' or use a different change tracking strategy.
        /// </summary>
        public static string ChangeTrackingInterfaceMissing(object? entityType, object? changeTrackingStrategy, object? notificationInterface)
            => string.Format(
                GetString("ChangeTrackingInterfaceMissing", nameof(entityType), nameof(changeTrackingStrategy), nameof(notificationInterface)),
                entityType, changeTrackingStrategy, notificationInterface);

        /// <summary>
        ///     Unable to save changes because a circular dependency was detected in the data to be saved: '{cycle}'.
        /// </summary>
        public static string CircularDependency(object? cycle)
            => string.Format(
                GetString("CircularDependency", nameof(cycle)),
                cycle);

        /// <summary>
        ///     The entity type '{entityType}' cannot inherit from '{baseEntityType}' because '{baseEntityType}' is a descendant of '{entityType}'. Review your model configuration.
        /// </summary>
        public static string CircularInheritance(object? entityType, object? baseEntityType)
            => string.Format(
                GetString("CircularInheritance", nameof(entityType), nameof(baseEntityType)),
                entityType, baseEntityType);

        /// <summary>
        ///     The shared-type entity type '{entityType}' cannot be added because the model already contains an entity type with the same name, but with a different CLR type '{otherClrType}'. Ensure all entity type names are unique.
        /// </summary>
        public static string ClashingMismatchedSharedType(object? entityType, object? otherClrType)
            => string.Format(
                GetString("ClashingMismatchedSharedType", nameof(entityType), nameof(otherClrType)),
                entityType, otherClrType);

        /// <summary>
        ///     An entity type named '{ownedTypeName}' has already been added to the model. Use a different name when configuring the ownership '{ownerEntityType}.{navigation}' in 'OnModelCreating'. See https://aka.ms/efcore-docs-owned for more information and examples.
        /// </summary>
        public static string ClashingNamedOwnedType(object? ownedTypeName, object? ownerEntityType, object? navigation)
            => string.Format(
                GetString("ClashingNamedOwnedType", nameof(ownedTypeName), nameof(ownerEntityType), nameof(navigation)),
                ownedTypeName, ownerEntityType, navigation);

        /// <summary>
        ///     The entity type '{entityType}' cannot be marked as owned because the derived entity type '{derivedType}' has been configured as non-owned. Either don't configure '{derivedType}' as non-owned, or call 'HasBaseType(null)' for it in 'OnModelCreating'. See https://aka.ms/efcore-docs-owned for more information and examples.
        /// </summary>
        public static string ClashingNonOwnedDerivedEntityType(object? entityType, object? derivedType)
            => string.Format(
                GetString("ClashingNonOwnedDerivedEntityType", nameof(entityType), nameof(derivedType)),
                entityType, derivedType);

        /// <summary>
        ///     The entity type '{entityType}' cannot be configured as owned because it has already been configured as a non-owned. If the entity type should be owned remove the 'Entity&lt;{entityType}&gt;()' call if possible, or otherwise remove the entity type from the model by calling 'Ignore'. See https://aka.ms/efcore-docs-owned for more information and examples.
        /// </summary>
        public static string ClashingNonOwnedEntityType(object? entityType)
            => string.Format(
                GetString("ClashingNonOwnedEntityType", nameof(entityType)),
                entityType);

        /// <summary>
        ///     The shared-type entity type '{entityType}' with CLR type '{type}' cannot be added to the model because a non-shared entity type with the same CLR type already exists.
        /// </summary>
        public static string ClashingNonSharedType(object? entityType, object? type)
            => string.Format(
                GetString("ClashingNonSharedType", nameof(entityType), nameof(type)),
                entityType, type);

        /// <summary>
        ///     The entity type '{entityType}' cannot be marked as non-owned because the derived entity type '{derivedType}' has been configured as owned. Either don't configure '{derivedType}' as owned, or call 'HasBaseType(null)' for it in 'OnModelCreating'. See https://aka.ms/efcore-docs-owned for more information and examples.
        /// </summary>
        public static string ClashingOwnedDerivedEntityType(object? entityType, object? derivedType)
            => string.Format(
                GetString("ClashingOwnedDerivedEntityType", nameof(entityType), nameof(derivedType)),
                entityType, derivedType);

        /// <summary>
        ///     The entity type '{entityType}' cannot be configured as non-owned because it has already been configured as owned. Use the nested builder in 'OwnsOne' or 'OwnsMany' on the owner entity type builder to further configure this type. If the entity type shouldn't be owned and you are unable to remove the 'OwnsOne' or 'OwnsMany' call you can remove the entity type from the model by calling 'Ignore'. See https://aka.ms/efcore-docs-owned for more information and examples.
        /// </summary>
        public static string ClashingOwnedEntityType(object? entityType)
            => string.Format(
                GetString("ClashingOwnedEntityType", nameof(entityType)),
                entityType);

        /// <summary>
        ///     The entity type '{entityType}' cannot be added to the model because its CLR type has been configured as a shared type.
        /// </summary>
        public static string ClashingSharedType(object? entityType)
            => string.Format(
                GetString("ClashingSharedType", nameof(entityType)),
                entityType);

        /// <summary>
        ///     The client projection contains a reference to a constant expression of '{constantType}' which is being passed as an argument to the method '{methodName}'. This could potentially cause a memory leak; consider assigning this constant to a local variable and using the variable in the query instead. See https://go.microsoft.com/fwlink/?linkid=2103067 for more information and examples.
        /// </summary>
        public static string ClientProjectionCapturingConstantInMethodArgument(object? constantType, object? methodName)
            => string.Format(
                GetString("ClientProjectionCapturingConstantInMethodArgument", nameof(constantType), nameof(methodName)),
                constantType, methodName);

        /// <summary>
        ///     The client projection contains a reference to a constant expression of '{constantType}' through the instance method '{methodName}'. This could potentially cause a memory leak; consider making the method static so that it does not capture constant in the instance. See https://go.microsoft.com/fwlink/?linkid=2103067 for more information and examples.
        /// </summary>
        public static string ClientProjectionCapturingConstantInMethodInstance(object? constantType, object? methodName)
            => string.Format(
                GetString("ClientProjectionCapturingConstantInMethodInstance", nameof(constantType), nameof(methodName)),
                constantType, methodName);

        /// <summary>
        ///     The client projection contains a reference to a constant expression of '{constantType}'. This could potentially cause a memory leak; consider assigning this constant to a local variable and using the variable in the query instead. See https://go.microsoft.com/fwlink/?linkid=2103067 for more information and examples.
        /// </summary>
        public static string ClientProjectionCapturingConstantInTree(object? constantType)
            => string.Format(
                GetString("ClientProjectionCapturingConstantInTree", nameof(constantType)),
                constantType);

        /// <summary>
        ///     The property '{1_entityType}.{0_property}' is being accessed using '{collectionMethod}', but is defined in the model as a non-collection, reference navigation. Use '{referenceMethod}' to access reference navigations.
        /// </summary>
        public static string CollectionIsReference(object? property, object? entityType, object? collectionMethod, object? referenceMethod)
            => string.Format(
                GetString("CollectionIsReference", "0_property", "1_entityType", nameof(collectionMethod), nameof(referenceMethod)),
                property, entityType, collectionMethod, referenceMethod);

        /// <summary>
        ///     The comparer for type '{type}' cannot be used for '{entityType}.{propertyName}' because its type is '{propertyType}'.
        /// </summary>
        public static string ComparerPropertyMismatch(object? type, object? entityType, object? propertyName, object? propertyType)
            => string.Format(
                GetString("ComparerPropertyMismatch", nameof(type), nameof(entityType), nameof(propertyName), nameof(propertyType)),
                type, entityType, propertyName, propertyType);

        /// <summary>
        ///     The comparer for element type '{type}' cannot be used for '{entityType}.{propertyName}' because its element type is '{elementType}'.
        /// </summary>
        public static string ComparerPropertyMismatchElement(object? type, object? entityType, object? propertyName, object? elementType)
            => string.Format(
                GetString("ComparerPropertyMismatchElement", nameof(type), nameof(entityType), nameof(propertyName), nameof(elementType)),
                type, entityType, propertyName, elementType);

        /// <summary>
        ///     More than a single DbContextModelAttribute was found in the assembly '{assemblyName}' corresponding to the context type '{contextType}'
        /// </summary>
        public static string CompiledModelDuplicateAttribute(object? assemblyName, object? contextType)
            => string.Format(
                GetString("CompiledModelDuplicateAttribute", nameof(assemblyName), nameof(contextType)),
                assemblyName, contextType);

        /// <summary>
        ///     The type mapping used is incompatible with a compiled model. The mapping type must have a 'public static readonly {typeMapping} {typeMapping}.Default' property.
        /// </summary>
        public static string CompiledModelIncompatibleTypeMapping(object? typeMapping)
            => string.Format(
                GetString("CompiledModelIncompatibleTypeMapping", nameof(typeMapping)),
                typeMapping);

        /// <summary>
        ///     '{modelType}' must declare a static property named 'Instance' that returns 'IModel'.
        /// </summary>
        public static string CompiledModelMissingInstance(object? modelType)
            => string.Format(
                GetString("CompiledModelMissingInstance", nameof(modelType)),
                modelType);

        /// <summary>
        ///     The compiled query '{queryExpression}' was executed with a different model than it was compiled against. Compiled queries can only be used with a single model.
        /// </summary>
        public static string CompiledQueryDifferentModel(object? queryExpression)
            => string.Format(
                GetString("CompiledQueryDifferentModel", nameof(queryExpression)),
                queryExpression);

        /// <summary>
        ///     The complex entry at ordinal '{ordinal}' for the collection '{declaringType}.{collection}' cannot be accessed as the containing entry is in the deleted state.
        /// </summary>
        public static string ComplexCollectionEntryDeletedEntity(object? ordinal, object? declaringType, object? collection)
            => string.Format(
                GetString("ComplexCollectionEntryDeletedEntity", nameof(ordinal), nameof(declaringType), nameof(collection)),
                ordinal, declaringType, collection);

        /// <summary>
        ///     Cannot change the state of an element of the '{property}' complex collection directly from Deleted to Added or vice versa. First mark it as Unchanged.
        /// </summary>
        public static string ComplexCollectionEntryInvalidStateChange(object? property)
            => string.Format(
                GetString("ComplexCollectionEntryInvalidStateChange", nameof(property)),
                property);

        /// <summary>
        ///     Complex entry ordinal '{ordinal}' is invalid for the collection '{declaringType}.{collection}' as it's outside of the collection of length '{count}'.
        /// </summary>
        public static string ComplexCollectionEntryOrdinalInvalid(object? ordinal, object? declaringType, object? collection, object? count)
            => string.Format(
                GetString("ComplexCollectionEntryOrdinalInvalid", nameof(ordinal), nameof(declaringType), nameof(collection), nameof(count)),
                ordinal, declaringType, collection, count);

        /// <summary>
        ///     Cannot change the ordinal of an entry of the  '{collectionDeclaringType}.{collection}' complex collection unless it's detached or deleted.
        /// </summary>
        public static string ComplexCollectionEntryOrdinalReadOnly(object? collectionDeclaringType, object? collection)
            => string.Format(
                GetString("ComplexCollectionEntryOrdinalReadOnly", nameof(collectionDeclaringType), nameof(collection)),
                collectionDeclaringType, collection);

        /// <summary>
        ///     The original entries cannot be accessed for the complex type collection '{declaringType}.{collection}' as it was originally 'null'.
        /// </summary>
        public static string ComplexCollectionEntryOriginalNull(object? declaringType, object? collection)
            => string.Format(
                GetString("ComplexCollectionEntryOriginalNull", nameof(declaringType), nameof(collection)),
                declaringType, collection);

        /// <summary>
        ///     Complex entry original ordinal '{ordinal}' is invalid for property '{declaringType}.{collection}' as it's outside of the collection of length '{count}'.
        /// </summary>
        public static string ComplexCollectionEntryOriginalOrdinalInvalid(object? ordinal, object? declaringType, object? collection, object? count)
            => string.Format(
                GetString("ComplexCollectionEntryOriginalOrdinalInvalid", nameof(ordinal), nameof(declaringType), nameof(collection), nameof(count)),
                ordinal, declaringType, collection, count);

        /// <summary>
        ///     Cannot change the original ordinal of an entry of the '{collectionDeclaringType}.{collection}' complex collection unless it's detached or added.
        /// </summary>
        public static string ComplexCollectionEntryOriginalOrdinalReadOnly(object? collectionDeclaringType, object? collection)
            => string.Format(
                GetString("ComplexCollectionEntryOriginalOrdinalReadOnly", nameof(collectionDeclaringType), nameof(collection)),
                collectionDeclaringType, collection);

        /// <summary>
        ///     The property '{entityType}.{property}' is being accessed using '{collectionMethod}', but is defined in the model as a non-collection complex property. Use '{referenceMethod}' to access non-collection complex properties.
        /// </summary>
        public static string ComplexCollectionIsReference(object? entityType, object? property, object? collectionMethod, object? referenceMethod)
            => string.Format(
                GetString("ComplexCollectionIsReference", nameof(entityType), nameof(property), nameof(collectionMethod), nameof(referenceMethod)),
                entityType, property, collectionMethod, referenceMethod);

        /// <summary>
        ///     The ordinals specified for the move operation are invalid: from '{fromOrdinal}' to '{toOrdinal}'. The collection only has '{count}' entries.
        /// </summary>
        public static string ComplexCollectionMoveInvalidOrdinals(object? fromOrdinal, object? toOrdinal, object? count)
            => string.Format(
                GetString("ComplexCollectionMoveInvalidOrdinals", nameof(fromOrdinal), nameof(toOrdinal), nameof(count)),
                fromOrdinal, toOrdinal, count);

        /// <summary>
        ///     The complex type collection '{entityType}.{collection}' must be initialized to a non-null value before the elements can be accessed.
        /// </summary>
        public static string ComplexCollectionNotInitialized(object? entityType, object? collection)
            => string.Format(
                GetString("ComplexCollectionNotInitialized", nameof(entityType), nameof(collection)),
                entityType, collection);

        /// <summary>
        ///     The value for the property '{complexType}.{property}' cannot be set, because it's on the complex type collection element '{collectionDeclaringType}.{collection}[{ordinal}]' that contains a null value.
        /// </summary>
        public static string ComplexCollectionNullElementSetter(object? complexType, object? property, object? collectionDeclaringType, object? collection, object? ordinal)
            => string.Format(
                GetString("ComplexCollectionNullElementSetter", nameof(complexType), nameof(property), nameof(collectionDeclaringType), nameof(collection), nameof(ordinal)),
                complexType, property, collectionDeclaringType, collection, ordinal);

        /// <summary>
        ///     The complex entry at the original ordinal '{ordinal}' for the collection '{declaringType}.{collection}' cannot be accessed as the containing entry is in the added state.
        /// </summary>
        public static string ComplexCollectionOriginalEntryAddedEntity(object? ordinal, object? declaringType, object? collection)
            => string.Format(
                GetString("ComplexCollectionOriginalEntryAddedEntity", nameof(ordinal), nameof(declaringType), nameof(collection)),
                ordinal, declaringType, collection);

        /// <summary>
        ///     The value for complex collection property '{property}' must be a list of dictionaries, but it was '{typeName}'.
        /// </summary>
        public static string ComplexCollectionValueNotDictionaryList(object? property, object? typeName)
            => string.Format(
                GetString("ComplexCollectionValueNotDictionaryList", nameof(property), nameof(typeName)),
                property, typeName);

        /// <summary>
        ///     The collection complex property '{property}' cannot be added to the type '{type}' because its CLR type '{clrType}' does not implement 'IEnumerable&lt;{targetType}&gt;'. Collection complex property must implement IEnumerable&lt;&gt; of the complex type.
        /// </summary>
        public static string ComplexCollectionWrongClrType(object? property, object? type, object? clrType, object? targetType)
            => string.Format(
                GetString("ComplexCollectionWrongClrType", nameof(property), nameof(type), nameof(clrType), nameof(targetType)),
                property, type, clrType, targetType);

        /// <summary>
        ///     Adding the complex property '{type}.{property}' as an indexer property isn't supported. See https://github.com/dotnet/efcore/issues/31244 for more information.
        /// </summary>
        public static string ComplexPropertyIndexer(object? type, object? property)
            => string.Format(
                GetString("ComplexPropertyIndexer", nameof(type), nameof(property)),
                type, property);

        /// <summary>
        ///     The complex property '{type}.{property}' is not a collection. Only complex collection properties can be used here.
        /// </summary>
        public static string ComplexPropertyNotCollection(object? type, object? property)
            => string.Format(
                GetString("ComplexPropertyNotCollection", nameof(type), nameof(property)),
                type, property);

        /// <summary>
        ///     The complex property '{type}.{property}' could not be found. Ensure that the property exists and has been included in the model as a complex property.
        /// </summary>
        public static string ComplexPropertyNotFound(object? type, object? property)
            => string.Format(
                GetString("ComplexPropertyNotFound", nameof(type), nameof(property)),
                type, property);

        /// <summary>
        ///     Configuring the complex property '{type}.{property}' in shadow state isn't supported.  See https://github.com/dotnet/efcore/issues/31243 for more information.
        /// </summary>
        public static string ComplexPropertyShadow(object? type, object? property)
            => string.Format(
                GetString("ComplexPropertyShadow", nameof(type), nameof(property)),
                type, property);

        /// <summary>
        ///     The value for complex property '{property}' must be a 'Dictionary&lt;string, object&gt;', but it was '{typeName}'.
        /// </summary>
        public static string ComplexPropertyValueNotDictionary(object? property, object? typeName)
            => string.Format(
                GetString("ComplexPropertyValueNotDictionary", nameof(property), nameof(typeName)),
                property, typeName);

        /// <summary>
        ///     The value for complex collection property '{property}' must be a '{clrType}', but it was '{typeName}'.
        /// </summary>
        public static string ComplexPropertyValueNotList(object? property, object? clrType, object? typeName)
            => string.Format(
                GetString("ComplexPropertyValueNotList", nameof(property), nameof(clrType), nameof(typeName)),
                property, clrType, typeName);

        /// <summary>
        ///     The complex property '{property}' cannot be added to the type '{type}' because its CLR type '{clrType}' does not match the expected CLR type '{targetType}'.
        /// </summary>
        public static string ComplexPropertyWrongClrType(object? property, object? type, object? clrType, object? targetType)
            => string.Format(
                GetString("ComplexPropertyWrongClrType", nameof(property), nameof(type), nameof(clrType), nameof(targetType)),
                property, type, clrType, targetType);

        /// <summary>
        ///     The property '{entityType}.{property}' is being accessed using the '{referenceMethod}' method, but is defined in the model as a collection complex property. Use the '{collectionMethod}' method to access collection complex properties.
        /// </summary>
        public static string ComplexReferenceIsCollection(object? entityType, object? property, object? referenceMethod, object? collectionMethod)
            => string.Format(
                GetString("ComplexReferenceIsCollection", nameof(entityType), nameof(property), nameof(referenceMethod), nameof(collectionMethod)),
                entityType, property, referenceMethod, collectionMethod);

        /// <summary>
        ///     Complex type '{complexType}' uses change tracking strategy '{changeTrackingStrategy}', but complex types with notification change tracking are not supported. See https://github.com/dotnet/efcore/issues/36175 for more information.
        /// </summary>
        public static string ComplexTypeNotificationChangeTracking(object? complexType, object? changeTrackingStrategy)
            => string.Format(
                GetString("ComplexTypeNotificationChangeTracking", nameof(complexType), nameof(changeTrackingStrategy)),
                complexType, changeTrackingStrategy);

        /// <summary>
        ///     The shadow property '{complexType}.{property}' cannot be configured on the complex type '{complexType}'. Shadow properties are not supported on complex types. See https://github.com/dotnet/efcore/issues/35613 for more information.
        /// </summary>
        public static string ComplexTypeShadowProperty(object? complexType, object? property)
            => string.Format(
                GetString("ComplexTypeShadowProperty", nameof(complexType), nameof(property)),
                complexType, property);

        /// <summary>
        ///     '{service}' doesn't currently support complex types.
        /// </summary>
        public static string ComplexTypesNotSupported(object? service)
            => string.Format(
                GetString("ComplexTypesNotSupported", nameof(service)),
                service);

        /// <summary>
        ///     The complex type collection '{type}.{property}' cannot be configured because complex value type collections are not supported. See https://github.com/dotnet/efcore/issues/31411 for more information.
        /// </summary>
        public static string ComplexValueTypeCollection(object? type, object? property)
            => string.Format(
                GetString("ComplexValueTypeCollection", nameof(type), nameof(property)),
                type, property);

        /// <summary>
        ///     The shadow property '{type}.{property}' cannot be configured on the value type complex type '{type}'. Shadow properties are not supported on value type complex types. See https://github.com/dotnet/efcore/issues/35337 for more information.
        /// </summary>
        public static string ComplexValueTypeShadowProperty(object? type, object? property)
            => string.Format(
                GetString("ComplexValueTypeShadowProperty", nameof(type), nameof(property)),
                type, property);

        /// <summary>
        ///     There are multiple properties with the [ForeignKey] attribute pointing to navigation '{1_entityType}.{0_navigation}'. To define a composite foreign key using data annotations, use the [ForeignKey] attribute on the navigation.
        /// </summary>
        public static string CompositeFkOnProperty(object? navigation, object? entityType)
            => string.Format(
                GetString("CompositeFkOnProperty", "0_navigation", "1_entityType"),
                navigation, entityType);

        /// <summary>
        ///     The entity type '{entityType}' has multiple properties with the [Key] attribute. Composite primary keys can be configured by placing the [PrimaryKey] attribute on the entity type class, or by using 'HasKey' in 'OnModelCreating'.
        /// </summary>
        public static string CompositePKWithDataAnnotation(object? entityType)
            => string.Format(
                GetString("CompositePKWithDataAnnotation", nameof(entityType)),
                entityType);

        /// <summary>
        ///     A second operation was started on this context instance before a previous operation completed. This is usually caused by different threads concurrently using the same instance of DbContext. For more information on how to avoid threading issues with DbContext, see https://go.microsoft.com/fwlink/?linkid=2097913.
        /// </summary>
        public static string ConcurrentMethodInvocation
            => GetString("ConcurrentMethodInvocation");

        /// <summary>
        ///     Property '{1_entityType}.{0_property}' matches both '{field1}' and '{field2}' by convention. Explicitly specify the backing field to use with 'HasField' in 'OnModelCreating'.
        /// </summary>
        public static string ConflictingBackingFields(object? property, object? entityType, object? field1, object? field2)
            => string.Format(
                GetString("ConflictingBackingFields", "0_property", "1_entityType", nameof(field1), nameof(field2)),
                property, entityType, field1, field2);

        /// <summary>
        ///     The member '{type}.{property}' cannot use field '{field}' because it is already used by '{conflictingType}.{conflictingProperty}'.
        /// </summary>
        public static string ConflictingFieldProperty(object? type, object? property, object? field, object? conflictingType, object? conflictingProperty)
            => string.Format(
                GetString("ConflictingFieldProperty", nameof(type), nameof(property), nameof(field), nameof(conflictingType), nameof(conflictingProperty)),
                type, property, field, conflictingType, conflictingProperty);

        /// <summary>
        ///     There are multiple [ForeignKey] attributes which are pointing to same set of properties '{propertyList}' on entity type '{entityType}' and targeting the principal entity type '{principalEntityType}'.
        /// </summary>
        public static string ConflictingForeignKeyAttributes(object? propertyList, object? entityType, object? principalEntityType)
            => string.Format(
                GetString("ConflictingForeignKeyAttributes", nameof(propertyList), nameof(entityType), nameof(principalEntityType)),
                propertyList, entityType, principalEntityType);

        /// <summary>
        ///     The entity type '{entity}' has both [Keyless] and [PrimaryKey] attributes; one must be removed.
        /// </summary>
        public static string ConflictingKeylessAndPrimaryKeyAttributes(object? entity)
            => string.Format(
                GetString("ConflictingKeylessAndPrimaryKeyAttributes", nameof(entity)),
                entity);

        /// <summary>
        ///     The property or navigation '{member}' cannot be added to the '{type}' type because a property or navigation with the same name already exists on the '{conflictingType}' type.
        /// </summary>
        public static string ConflictingPropertyOrNavigation(object? member, object? type, object? conflictingType)
            => string.Format(
                GetString("ConflictingPropertyOrNavigation", nameof(member), nameof(type), nameof(conflictingType)),
                member, type, conflictingType);

        /// <summary>
        ///     The property '{entityType}.{property}' participates in several relationship chains that have conflicting conversions: '{valueConversion}' and '{conflictingValueConversion}'.
        /// </summary>
        public static string ConflictingRelationshipConversions(object? entityType, object? property, object? valueConversion, object? conflictingValueConversion)
            => string.Format(
                GetString("ConflictingRelationshipConversions", nameof(entityType), nameof(property), nameof(valueConversion), nameof(conflictingValueConversion)),
                entityType, property, valueConversion, conflictingValueConversion);

        /// <summary>
        ///     Cannot create a relationship between '{newPrincipalNavigationSpecification}' and '{newDependentNavigationSpecification}' because a relationship already exists between '{existingPrincipalNavigationSpecification}' and '{existingDependentNavigationSpecification}'. Navigations can only participate in a single relationship. If you want to override an existing relationship call 'Ignore' on the navigation '{newDependentNavigationSpecification}' first in 'OnModelCreating'.
        /// </summary>
        public static string ConflictingRelationshipNavigation(object? newPrincipalNavigationSpecification, object? newDependentNavigationSpecification, object? existingPrincipalNavigationSpecification, object? existingDependentNavigationSpecification)
            => string.Format(
                GetString("ConflictingRelationshipNavigation", nameof(newPrincipalNavigationSpecification), nameof(newDependentNavigationSpecification), nameof(existingPrincipalNavigationSpecification), nameof(existingDependentNavigationSpecification)),
                newPrincipalNavigationSpecification, newDependentNavigationSpecification, existingPrincipalNavigationSpecification, existingDependentNavigationSpecification);

        /// <summary>
        ///     Cannot bind '{failedBinds}' in '{parameters}'
        /// </summary>
        public static string ConstructorBindingFailed(object? failedBinds, object? parameters)
            => string.Format(
                GetString("ConstructorBindingFailed", nameof(failedBinds), nameof(parameters)),
                failedBinds, parameters);

        /// <summary>
        ///     The constructors '{firstConstructor}' and '{secondConstructor}' have the same number of parameters, and can both be used by Entity Framework. The constructor to be used must be configured in 'OnModelCreating'.
        /// </summary>
        public static string ConstructorConflict(object? firstConstructor, object? secondConstructor)
            => string.Format(
                GetString("ConstructorConflict", nameof(firstConstructor), nameof(secondConstructor)),
                firstConstructor, secondConstructor);

        /// <summary>
        ///     No suitable constructor was found for the type '{type}'. The following constructors had parameters that could not be bound to properties of the type: {constructors}Note that only mapped properties can be bound to constructor parameters. Navigations to related entities, including references to owned types, cannot be bound.
        /// </summary>
        public static string ConstructorNotFound(object? type, object? constructors)
            => string.Format(
                GetString("ConstructorNotFound", nameof(type), nameof(constructors)),
                type, constructors);

        /// <summary>
        ///     Cannot access a disposed context instance. A common cause of this error is disposing a context instance that was resolved from dependency injection and then later trying to use the same context instance elsewhere in your application. This may occur if you are calling 'Dispose' on the context instance, or wrapping it in a using statement. If you are using dependency injection, you should let the dependency injection container take care of disposing context instances.
        /// </summary>
        public static string ContextDisposed
            => GetString("ContextDisposed");

        /// <summary>
        ///     The convention invocations have reached the recursion limit. This is likely an issue in Entity Framework, please file an issue at https://go.microsoft.com/fwlink/?linkid=2142044.
        /// </summary>
        public static string ConventionsInfiniteLoop
            => GetString("ConventionsInfiniteLoop");

        /// <summary>
        ///     The value converter '{converter}' cannot be used with type '{type}'. This converter can only be used with {allowed}.
        /// </summary>
        public static string ConverterBadType(object? converter, object? type, object? allowed)
            => string.Format(
                GetString("ConverterBadType", nameof(converter), nameof(type), nameof(allowed)),
                converter, type, allowed);

        /// <summary>
        ///     Converter for model type '{converterType}' cannot be used for '{entityType}.{propertyName}' because its type is '{propertyType}'.
        /// </summary>
        public static string ConverterPropertyMismatch(object? converterType, object? entityType, object? propertyName, object? propertyType)
            => string.Format(
                GetString("ConverterPropertyMismatch", nameof(converterType), nameof(entityType), nameof(propertyName), nameof(propertyType)),
                converterType, entityType, propertyName, propertyType);

        /// <summary>
        ///     Converter for element type '{converterType}' cannot be used for '{entityType}.{propertyName}' because its element type is '{elementType}'.
        /// </summary>
        public static string ConverterPropertyMismatchElement(object? converterType, object? entityType, object? propertyName, object? elementType)
            => string.Format(
                GetString("ConverterPropertyMismatchElement", nameof(converterType), nameof(entityType), nameof(propertyName), nameof(elementType)),
                converterType, entityType, propertyName, elementType);

        /// <summary>
        ///     Cannot compose converter from '{typeOneIn}' to '{typeOneOut}' with converter from '{typeTwoIn}' to '{typeTwoOut}' because the output type of the first converter doesn't match the input type of the second converter.
        /// </summary>
        public static string ConvertersCannotBeComposed(object? typeOneIn, object? typeOneOut, object? typeTwoIn, object? typeTwoOut)
            => string.Format(
                GetString("ConvertersCannotBeComposed", nameof(typeOneIn), nameof(typeOneOut), nameof(typeTwoIn), nameof(typeTwoOut)),
                typeOneIn, typeOneOut, typeTwoIn, typeTwoOut);

        /// <summary>
        ///     Data binding directly to 'DbSet.Local' is not supported since it does not provide a stable ordering. For WPF, bind to 'DbSet.Local.ToObservableCollection'. For WinForms, bind to 'DbSet.Local.ToBindingList'. For ASP.NET WebForms, bind to 'DbSet.ToList' or use Model Binding.
        /// </summary>
        public static string DataBindingToLocalWithIListSource
            => GetString("DataBindingToLocalWithIListSource");

        /// <summary>
        ///     Data binding directly to a store query is not supported. Instead populate a DbSet with data, for example by calling 'Load' on the DbSet, and then bind to local data to avoid sending a query to the database each time the databound control iterates the data. For WPF, bind to 'DbSet.Local.ToObservableCollection'. For WinForms, bind to 'DbSet.Local.ToBindingList'. For ASP.NET WebForms, bind to 'DbSet.ToList' or use Model Binding.
        /// </summary>
        public static string DataBindingWithIListSource
            => GetString("DataBindingWithIListSource");

        /// <summary>
        ///     'AddDbContext' was called with configuration, but the context type '{contextType}' only declares a parameterless constructor. This means that the configuration passed to 'AddDbContext' will never be used. If configuration is passed to 'AddDbContext', then '{contextType}' should declare a constructor that accepts a DbContextOptions&lt;{contextType}&gt; and must pass it to the base constructor for DbContext.
        /// </summary>
        public static string DbContextMissingConstructor(object? contextType)
            => string.Format(
                GetString("DbContextMissingConstructor", nameof(contextType)),
                contextType);

        /// <summary>
        ///     Cannot create DbSet for entity type '{entityType}' since it is of type '{entityClrType}' but the generic type provided is of type '{genericType}'.
        /// </summary>
        public static string DbSetIncorrectGenericType(object? entityType, object? entityClrType, object? genericType)
            => string.Format(
                GetString("DbSetIncorrectGenericType", nameof(entityType), nameof(entityClrType), nameof(genericType)),
                entityType, entityClrType, genericType);

        /// <summary>
        ///     Debug view threw {message}. Please report this at https://github.com/dotnet/efcore
        /// </summary>
        public static string DebugViewError(object? message)
            => string.Format(
                GetString("DebugViewError", nameof(message)),
                message);

        /// <summary>
        ///     Error creating query expression: {message}.
        /// </summary>
        public static string DebugViewQueryExpressionError(object? message)
            => string.Format(
                GetString("DebugViewQueryExpressionError", nameof(message)),
                message);

        /// <summary>
        ///     Error creating query string: {message}.
        /// </summary>
        public static string DebugViewQueryStringError(object? message)
            => string.Format(
                GetString("DebugViewQueryStringError", nameof(message)),
                message);

        /// <summary>
        ///     The EF.Default&lt;T&gt; property may only be used within Entity Framework ExecuteUpdate method.
        /// </summary>
        public static string DefaultMethodInvoked
            => GetString("DefaultMethodInvoked");

        /// <summary>
        ///     The [DeleteBehavior] attribute may only be specified on navigation properties, and is not supported on properties making up the foreign key. Remove the attribute from '{type}.{propertyName}'.
        /// </summary>
        public static string DeleteBehaviorAttributeNotOnNavigationProperty(object? type, object? propertyName)
            => string.Format(
                GetString("DeleteBehaviorAttributeNotOnNavigationProperty", nameof(type), nameof(propertyName)),
                type, propertyName);

        /// <summary>
        ///     The [DeleteBehavior] attribute may only be specified on the dependent side of the relationship. Remove the attribute from '{entityType}.{navigationName}'.
        /// </summary>
        public static string DeleteBehaviorAttributeOnPrincipalProperty(object? entityType, object? navigationName)
            => string.Format(
                GetString("DeleteBehaviorAttributeOnPrincipalProperty", nameof(entityType), nameof(navigationName)),
                entityType, navigationName);

        /// <summary>
        ///     You are configuring a relationship between '{dependentEntityType}' and '{principalEntityType}' but have specified a foreign key on '{entityType}'. The foreign key must be defined on a type that is part of the relationship.
        /// </summary>
        public static string DependentEntityTypeNotInRelationship(object? dependentEntityType, object? principalEntityType, object? entityType)
            => string.Format(
                GetString("DependentEntityTypeNotInRelationship", nameof(dependentEntityType), nameof(principalEntityType), nameof(entityType)),
                dependentEntityType, principalEntityType, entityType);

        /// <summary>
        ///     Unable to set a base type for entity type '{entityType}' because it has been configured as keyless. For more information on keyless entity types, see https://go.microsoft.com/fwlink/?linkid=2141943.
        /// </summary>
        public static string DerivedEntityCannotBeKeyless(object? entityType)
            => string.Format(
                GetString("DerivedEntityCannotBeKeyless", nameof(entityType)),
                entityType);

        /// <summary>
        ///     Unable to set a base type for entity type '{entityType}' because it has one or more keys defined. Only root types can have keys.
        /// </summary>
        public static string DerivedEntityCannotHaveKeys(object? entityType)
            => string.Format(
                GetString("DerivedEntityCannotHaveKeys", nameof(entityType)),
                entityType);

        /// <summary>
        ///     Unable to set '{baseEntityType}' as the base type for entity type '{derivedEntityType}' because '{ownedEntityType}' is configured as owned, while '{nonOwnedEntityType}' is non-owned. All entity types in a hierarchy need to have the same ownership status. See https://aka.ms/efcore-docs-owned for more information and examples.
        /// </summary>
        public static string DerivedEntityOwnershipMismatch(object? baseEntityType, object? derivedEntityType, object? ownedEntityType, object? nonOwnedEntityType)
            => string.Format(
                GetString("DerivedEntityOwnershipMismatch", nameof(baseEntityType), nameof(derivedEntityType), nameof(ownedEntityType), nameof(nonOwnedEntityType)),
                baseEntityType, derivedEntityType, ownedEntityType, nonOwnedEntityType);

        /// <summary>
        ///     '{derivedType}' cannot be configured as keyless because it is a derived type; the root type '{rootType}' must be configured as keyless instead. If you did not intend for '{rootType}' to be included in the model, ensure that it is not referenced by a DbSet property on your context, referenced in a configuration call to ModelBuilder in 'OnModelCreating', or referenced from a navigation on a type that is included in the model. For more information on keyless entity types, see https://go.microsoft.com/fwlink/?linkid=2141943.
        /// </summary>
        public static string DerivedEntityTypeHasNoKey(object? derivedType, object? rootType)
            => string.Format(
                GetString("DerivedEntityTypeHasNoKey", nameof(derivedType), nameof(rootType)),
                derivedType, rootType);

        /// <summary>
        ///     A key cannot be configured on '{derivedType}' because it is a derived type. The key must be configured on the root type '{rootType}'. If you did not intend for '{rootType}' to be included in the model, ensure that it is not referenced by a DbSet property on your context, referenced in a configuration call to ModelBuilder, or referenced from a navigation on a type that is included in the model.
        /// </summary>
        public static string DerivedEntityTypeKey(object? derivedType, object? rootType)
            => string.Format(
                GetString("DerivedEntityTypeKey", nameof(derivedType), nameof(rootType)),
                derivedType, rootType);

        /// <summary>
        ///     The entity type '{entityType}' cannot have a defining query because it is derived from '{baseType}'. Only base entity types can have a defining query.
        /// </summary>
        public static string DerivedTypeDefiningQuery(object? entityType, object? baseType)
            => string.Format(
                GetString("DerivedTypeDefiningQuery", nameof(entityType), nameof(baseType)),
                entityType, baseType);

        /// <summary>
        ///     Cannot configure the discriminator value for entity type '{entityType}' because it doesn't derive from '{rootEntityType}'.
        /// </summary>
        public static string DiscriminatorEntityTypeNotDerived(object? entityType, object? rootEntityType)
            => string.Format(
                GetString("DiscriminatorEntityTypeNotDerived", nameof(entityType), nameof(rootEntityType)),
                entityType, rootEntityType);

        /// <summary>
        ///     A discriminator property cannot be set for the entity type '{entityType}' because it is not the root of an inheritance hierarchy.
        /// </summary>
        public static string DiscriminatorPropertyMustBeOnRoot(object? entityType)
            => string.Format(
                GetString("DiscriminatorPropertyMustBeOnRoot", nameof(entityType)),
                entityType);

        /// <summary>
        ///     A discriminator property cannot be set for the type '{type}' because '{containingType}' is a complex collection.
        /// </summary>
        public static string DiscriminatorPropertyNotAllowedOnComplexCollection(object? type, object? containingType)
            => string.Format(
                GetString("DiscriminatorPropertyNotAllowedOnComplexCollection", nameof(type), nameof(containingType)),
                type, containingType);

        /// <summary>
        ///     Unable to set property '{property}' as a discriminator for entity type '{entityType}' because it is not a property of '{entityType}'.
        /// </summary>
        public static string DiscriminatorPropertyNotFound(object? property, object? entityType)
            => string.Format(
                GetString("DiscriminatorPropertyNotFound", nameof(property), nameof(entityType)),
                property, entityType);

        /// <summary>
        ///     The discriminator value '{value}' for the entity type '{entityType}' cannot be set because it is not assignable to the discriminator property of type '{discriminatorType}'.
        /// </summary>
        public static string DiscriminatorValueIncompatible(object? value, object? entityType, object? discriminatorType)
            => string.Format(
                GetString("DiscriminatorValueIncompatible", nameof(value), nameof(entityType), nameof(discriminatorType)),
                value, entityType, discriminatorType);

        /// <summary>
        ///     The annotation '{annotation}' cannot be added because an annotation with the same name already exists on the object {annotatable}
        /// </summary>
        public static string DuplicateAnnotation(object? annotation, object? annotatable)
            => string.Format(
                GetString("DuplicateAnnotation", nameof(annotation), nameof(annotatable)),
                annotation, annotatable);

        /// <summary>
        ///     The complex type '{complexType}' cannot be added to the model because a complex type with the same name already exists.
        /// </summary>
        public static string DuplicateComplexType(object? complexType)
            => string.Format(
                GetString("DuplicateComplexType", nameof(complexType)),
                complexType);

        /// <summary>
        ///     The discriminator value for '{entityType1}' is '{discriminatorValue}' which is the same for '{entityType2}'. Every concrete entity type in the hierarchy must have a unique discriminator value.
        /// </summary>
        public static string DuplicateDiscriminatorValue(object? entityType1, object? discriminatorValue, object? entityType2)
            => string.Format(
                GetString("DuplicateDiscriminatorValue", nameof(entityType1), nameof(discriminatorValue), nameof(entityType2)),
                entityType1, discriminatorValue, entityType2);

        /// <summary>
        ///     The entity type '{entityType}' cannot be added to the model because an entity type with the same name already exists.
        /// </summary>
        public static string DuplicateEntityType(object? entityType)
            => string.Format(
                GetString("DuplicateEntityType", nameof(entityType)),
                entityType);

        /// <summary>
        ///     The foreign key {foreignKeyProperties} cannot be added to the entity type '{entityType}' because a foreign key on the same properties already exists on entity type '{duplicateEntityType}' and also targets the key {keyProperties} on '{principalType}'.
        /// </summary>
        public static string DuplicateForeignKey(object? foreignKeyProperties, object? entityType, object? duplicateEntityType, object? keyProperties, object? principalType)
            => string.Format(
                GetString("DuplicateForeignKey", nameof(foreignKeyProperties), nameof(entityType), nameof(duplicateEntityType), nameof(keyProperties), nameof(principalType)),
                foreignKeyProperties, entityType, duplicateEntityType, keyProperties, principalType);

        /// <summary>
        ///     The index {indexProperties} cannot be added to the entity type '{entityType}' because an unnamed index on the same properties already exists on entity type '{duplicateEntityType}'. Consider adding a name for one of the indexes in 'OnModelCreating'.
        /// </summary>
        public static string DuplicateIndex(object? indexProperties, object? entityType, object? duplicateEntityType)
            => string.Format(
                GetString("DuplicateIndex", nameof(indexProperties), nameof(entityType), nameof(duplicateEntityType)),
                indexProperties, entityType, duplicateEntityType);

        /// <summary>
        ///     The key {keyProperties} cannot be added to the entity type '{entityType}' because a key on the same properties already exists on entity type '{duplicateEntityType}'.
        /// </summary>
        public static string DuplicateKey(object? keyProperties, object? entityType, object? duplicateEntityType)
            => string.Format(
                GetString("DuplicateKey", nameof(keyProperties), nameof(entityType), nameof(duplicateEntityType)),
                keyProperties, entityType, duplicateEntityType);

        /// <summary>
        ///     The index named '{indexName}' defined on properties {indexProperties} cannot be added to the entity type '{entityType}' because an index with the same name already exists on entity type '{duplicateEntityType}'.
        /// </summary>
        public static string DuplicateNamedIndex(object? indexName, object? indexProperties, object? entityType, object? duplicateEntityType)
            => string.Format(
                GetString("DuplicateNamedIndex", nameof(indexName), nameof(indexProperties), nameof(entityType), nameof(duplicateEntityType)),
                indexName, indexProperties, entityType, duplicateEntityType);

        /// <summary>
        ///     The type '{entityType}' cannot have base type '{baseType}' because the properties '{derivedPropertyType}.{derivedProperty}' and '{basePropertyType}.{baseProperty}' are in conflict.
        /// </summary>
        public static string DuplicatePropertiesOnBase(object? entityType, object? baseType, object? derivedPropertyType, object? derivedProperty, object? basePropertyType, object? baseProperty)
            => string.Format(
                GetString("DuplicatePropertiesOnBase", nameof(entityType), nameof(baseType), nameof(derivedPropertyType), nameof(derivedProperty), nameof(basePropertyType), nameof(baseProperty)),
                entityType, baseType, derivedPropertyType, derivedProperty, basePropertyType, baseProperty);

        /// <summary>
        ///     The properties {propertyList} cannot be used for a foreign key, because they contain a duplicate: '{property}'.
        /// </summary>
        public static string DuplicatePropertyInForeignKey(object? propertyList, object? property)
            => string.Format(
                GetString("DuplicatePropertyInForeignKey", nameof(propertyList), nameof(property)),
                propertyList, property);

        /// <summary>
        ///     The properties {propertyList} cannot be used for an index, because they contain a duplicate: '{property}'.
        /// </summary>
        public static string DuplicatePropertyInIndex(object? propertyList, object? property)
            => string.Format(
                GetString("DuplicatePropertyInIndex", nameof(propertyList), nameof(property)),
                propertyList, property);

        /// <summary>
        ///     The properties {propertyList} cannot be used for a key, because they contain a duplicate: '{property}'.
        /// </summary>
        public static string DuplicatePropertyInKey(object? propertyList, object? property)
            => string.Format(
                GetString("DuplicatePropertyInKey", nameof(propertyList), nameof(property)),
                propertyList, property);

        /// <summary>
        ///     The trigger '{trigger}' cannot be added to the entity type '{entityType}' because another trigger with the same name already exists on entity type '{conflictingEntityType}'.
        /// </summary>
        public static string DuplicateTrigger(object? trigger, object? entityType, object? conflictingEntityType)
            => string.Format(
                GetString("DuplicateTrigger", nameof(trigger), nameof(entityType), nameof(conflictingEntityType)),
                trigger, entityType, conflictingEntityType);

        /// <summary>
        ///     The EF.Constant&lt;T&gt; method may only be used within Entity Framework LINQ queries.
        /// </summary>
        public static string EFConstantInvoked
            => GetString("EFConstantInvoked");

        /// <summary>
        ///     'EF.Constant()' isn't supported by your provider.
        /// </summary>
        public static string EFConstantNotSupported
            => GetString("EFConstantNotSupported");

        /// <summary>
        ///     The EF.Constant&lt;T&gt; method is not supported when using precompiled queries.
        /// </summary>
        public static string EFConstantNotSupportedInPrecompiledQueries
            => GetString("EFConstantNotSupportedInPrecompiledQueries");

        /// <summary>
        ///     The {methodName} method may only be used with an argument that can be evaluated client-side and does not contain any reference to database-side entities.
        /// </summary>
        public static string EFMethodWithNonEvaluatableArgument(object? methodName)
            => string.Format(
                GetString("EFMethodWithNonEvaluatableArgument", nameof(methodName)),
                methodName);

        /// <summary>
        ///     The EF.Parameter&lt;T&gt; method may only be used within Entity Framework LINQ queries.
        /// </summary>
        public static string EFParameterInvoked
            => GetString("EFParameterInvoked");

        /// <summary>
        ///     Complex type '{complexType}' has no properties defined. Configure at least one property or don't include this type in the model.
        /// </summary>
        public static string EmptyComplexType(object? complexType)
            => string.Format(
                GetString("EmptyComplexType", nameof(complexType)),
                complexType);

        /// <summary>
        ///     The empty string is not valid JSON.
        /// </summary>
        public static string EmptyJsonString
            => GetString("EmptyJsonString");

        /// <summary>
        ///     Cannot translate '{comparisonOperator}' on a subquery expression of entity type '{entityType}' because it has a composite primary key. See https://go.microsoft.com/fwlink/?linkid=2141942 for information on how to rewrite your query.
        /// </summary>
        public static string EntityEqualityOnCompositeKeyEntitySubqueryNotSupported(object? comparisonOperator, object? entityType)
            => string.Format(
                GetString("EntityEqualityOnCompositeKeyEntitySubqueryNotSupported", nameof(comparisonOperator), nameof(entityType)),
                comparisonOperator, entityType);

        /// <summary>
        ///     Cannot translate the '{comparisonOperator}' on an expression of entity type '{entityType}' because it is a keyless entity. Consider using entity properties instead. For more information on keyless entity types, see https://go.microsoft.com/fwlink/?linkid=2141943.
        /// </summary>
        public static string EntityEqualityOnKeylessEntityNotSupported(object? comparisonOperator, object? entityType)
            => string.Format(
                GetString("EntityEqualityOnKeylessEntityNotSupported", nameof(comparisonOperator), nameof(entityType)),
                comparisonOperator, entityType);

        /// <summary>
        ///     The entity type '{entityType}' requires a primary key to be defined. If you intended to use a keyless entity type, call 'HasNoKey' in 'OnModelCreating'. For more information on keyless entity types, see https://go.microsoft.com/fwlink/?linkid=2141943.
        /// </summary>
        public static string EntityRequiresKey(object? entityType)
            => string.Format(
                GetString("EntityRequiresKey", nameof(entityType)),
                entityType);

        /// <summary>
        ///     The entity type '{entityType}' cannot be removed because '{derivedEntityType}' is derived from it. Before the entity type can be removed, all derived entity types must be removed or configured to use a different base entity type.
        /// </summary>
        public static string EntityTypeInUseByDerived(object? entityType, object? derivedEntityType)
            => string.Format(
                GetString("EntityTypeInUseByDerived", nameof(entityType), nameof(derivedEntityType)),
                entityType, derivedEntityType);

        /// <summary>
        ///     The entity type '{entityType}' cannot be removed because it is being referenced by foreign key {foreignKeyProperties} on '{referencingEntityType}'. Before the entity type can be removed, all referencing foreign keys must be removed.
        /// </summary>
        public static string EntityTypeInUseByReferencingForeignKey(object? entityType, object? foreignKeyProperties, object? referencingEntityType)
            => string.Format(
                GetString("EntityTypeInUseByReferencingForeignKey", nameof(entityType), nameof(foreignKeyProperties), nameof(referencingEntityType)),
                entityType, foreignKeyProperties, referencingEntityType);

        /// <summary>
        ///     The entity type '{entityType}' cannot be removed because it is being referenced by the skip navigation '{skipNavigation}' on '{referencingEntityType}'. Before the entity type can be removed, all referencing skip navigations must be removed.
        /// </summary>
        public static string EntityTypeInUseByReferencingSkipNavigation(object? entityType, object? skipNavigation, object? referencingEntityType)
            => string.Format(
                GetString("EntityTypeInUseByReferencingSkipNavigation", nameof(entityType), nameof(skipNavigation), nameof(referencingEntityType)),
                entityType, skipNavigation, referencingEntityType);

        /// <summary>
        ///     The entity types '{firstEntityType}' and '{secondEntityType}' do not belong to the same model.
        /// </summary>
        public static string EntityTypeModelMismatch(object? firstEntityType, object? secondEntityType)
            => string.Format(
                GetString("EntityTypeModelMismatch", nameof(firstEntityType), nameof(secondEntityType)),
                firstEntityType, secondEntityType);

        /// <summary>
        ///     The entity type '{entityType}' was not found. Ensure that the entity type has been added to the model.
        /// </summary>
        public static string EntityTypeNotFound(object? entityType)
            => string.Format(
                GetString("EntityTypeNotFound", nameof(entityType)),
                entityType);

        /// <summary>
        ///     The specified entity type '{entityType}' is invalid. It must be the dependent entity type '{dependentType}', the principal entity type '{principalType}' or an entity type derived from one of them.
        /// </summary>
        public static string EntityTypeNotInRelationship(object? entityType, object? dependentType, object? principalType)
            => string.Format(
                GetString("EntityTypeNotInRelationship", nameof(entityType), nameof(dependentType), nameof(principalType)),
                entityType, dependentType, principalType);

        /// <summary>
        ///     The specified entity type '{entityType}' is invalid. It must be either the dependent entity type '{dependentType}' or the principal entity type '{principalType}'.
        /// </summary>
        public static string EntityTypeNotInRelationshipStrict(object? entityType, object? dependentType, object? principalType)
            => string.Format(
                GetString("EntityTypeNotInRelationshipStrict", nameof(entityType), nameof(dependentType), nameof(principalType)),
                entityType, dependentType, principalType);

        /// <summary>
        ///     The provided entity types '{invalidDependentType}' and '{invalidPrincipalType}' are invalid. Specify '{dependentType}' and '{principalType}', or entity types in the same hierarchy.
        /// </summary>
        public static string EntityTypesNotInRelationship(object? invalidDependentType, object? invalidPrincipalType, object? dependentType, object? principalType)
            => string.Format(
                GetString("EntityTypesNotInRelationship", nameof(invalidDependentType), nameof(invalidPrincipalType), nameof(dependentType), nameof(principalType)),
                invalidDependentType, invalidPrincipalType, dependentType, principalType);

        /// <summary>
        ///     This enumerator cannot be reset.
        /// </summary>
        public static string EnumerableResetNotSupported
            => GetString("EnumerableResetNotSupported");

        /// <summary>
        ///     Cannot use multiple context instances within a single query execution. Ensure the query uses a single context instance.
        /// </summary>
        public static string ErrorInvalidQueryable
            => GetString("ErrorInvalidQueryable");

        /// <summary>
        ///     An error occurred while reading a database value for property '{entityType}.{property}'. The expected type was '{expectedType}' but the actual value was of type '{actualType}'.
        /// </summary>
        public static string ErrorMaterializingPropertyInvalidCast(object? entityType, object? property, object? expectedType, object? actualType)
            => string.Format(
                GetString("ErrorMaterializingPropertyInvalidCast", nameof(entityType), nameof(property), nameof(expectedType), nameof(actualType)),
                entityType, property, expectedType, actualType);

        /// <summary>
        ///     The methods '{methodName}' and '{asyncMethodName}' are not supported by the current database provider. Please contact the publisher of the database provider for more information. 
        /// </summary>
        public static string ExecuteQueriesNotSupported(object? methodName, object? asyncMethodName)
            => string.Format(
                GetString("ExecuteQueriesNotSupported", nameof(methodName), nameof(asyncMethodName)),
                methodName, asyncMethodName);

        /// <summary>
        ///     The configured execution strategy '{strategy}' does not support user-initiated transactions. Use the execution strategy returned by '{getExecutionStrategyMethod}' to execute all the operations in the transaction as a retriable unit.
        /// </summary>
        public static string ExecutionStrategyExistingTransaction(object? strategy, object? getExecutionStrategyMethod)
            => string.Format(
                GetString("ExecutionStrategyExistingTransaction", nameof(strategy), nameof(getExecutionStrategyMethod)),
                strategy, getExecutionStrategyMethod);

        /// <summary>
        ///     An exception was thrown while attempting to evaluate a LINQ query parameter expression. See the inner exception for more information. To show additional information call 'DbContextOptionsBuilder.EnableSensitiveDataLogging'.
        /// </summary>
        public static string ExpressionParameterizationException
            => GetString("ExpressionParameterizationException");

        /// <summary>
        ///     An exception was thrown while attempting to evaluate the LINQ query parameter expression '{expression}'. See the inner exception for more information.
        /// </summary>
        public static string ExpressionParameterizationExceptionSensitive(object? expression)
            => string.Format(
                GetString("ExpressionParameterizationExceptionSensitive", nameof(expression)),
                expression);

        /// <summary>
        ///     The specified field '{field}' cannot be used for the property '{entityType}.{property}' because it does not match the property name. Entity type properties that aren't associated with a CLR property must match the field name exactly.
        /// </summary>
        public static string FieldNameMismatch(object? field, object? entityType, object? property)
            => string.Format(
                GetString("FieldNameMismatch", nameof(field), nameof(entityType), nameof(property)),
                field, entityType, property);

        /// <summary>
        ///     Entity type '{entityType}' is defined with a single key property, but {valuesCount} values were passed to the 'Find' method.
        /// </summary>
        public static string FindNotCompositeKey(object? entityType, object? valuesCount)
            => string.Format(
                GetString("FindNotCompositeKey", nameof(entityType), nameof(valuesCount)),
                entityType, valuesCount);

        /// <summary>
        ///     Entity type '{entityType}' is defined with a {propertiesCount}-part composite key, but {valuesCount} values were passed to the 'Find' method.
        /// </summary>
        public static string FindValueCountMismatch(object? entityType, object? propertiesCount, object? valuesCount)
            => string.Format(
                GetString("FindValueCountMismatch", nameof(entityType), nameof(propertiesCount), nameof(valuesCount)),
                entityType, propertiesCount, valuesCount);

        /// <summary>
        ///     The key value at position {index} of the call to 'DbSet&lt;{entityType}&gt;.Find' was of type '{valueType}', which does not match the property type of '{propertyType}'.
        /// </summary>
        public static string FindValueTypeMismatch(object? index, object? entityType, object? valueType, object? propertyType)
            => string.Format(
                GetString("FindValueTypeMismatch", nameof(index), nameof(entityType), nameof(valueType), nameof(propertyType)),
                index, entityType, valueType, propertyType);

        /// <summary>
        ///     {values} value(s) were passed to the 'FindEntry' or 'GetEntries' method for {properties} properties. The number of values must match the number of properties.
        /// </summary>
        public static string FindWrongCount(object? values, object? properties)
            => string.Format(
                GetString("FindWrongCount", nameof(values), nameof(properties)),
                values, properties);

        /// <summary>
        ///     The 'FindEntry' or 'GetEntries' method was passed a '{valueType}' value for the '{propertyName}' property, when a '{propertyType}' value was expected.
        /// </summary>
        public static string FindWrongType(object? valueType, object? propertyName, object? propertyType)
            => string.Format(
                GetString("FindWrongType", nameof(valueType), nameof(propertyName), nameof(propertyType)),
                valueType, propertyName, propertyType);

        /// <summary>
        ///     The [ForeignKey] attribute for the navigation '{navigation}' cannot be specified on the entity type '{principalType}' since it represents a one-to-many relationship. Move the [ForeignKey] attribute to a property on '{dependentType}'.
        /// </summary>
        public static string FkAttributeOnNonUniquePrincipal(object? navigation, object? principalType, object? dependentType)
            => string.Format(
                GetString("FkAttributeOnNonUniquePrincipal", nameof(navigation), nameof(principalType), nameof(dependentType)),
                navigation, principalType, dependentType);

        /// <summary>
        ///     The [ForeignKey] attributes on property '{property}' and navigation '{navigation}' in entity type '{entityType}' do not point at each other. Make sure the value of the [ForeignKey] attribute on the property matches the navigation name, and the value of the [ForeignKey] attribute on the navigation matches the foreign key property name or remove one of them.
        /// </summary>
        public static string FkAttributeOnPropertyNavigationMismatch(object? property, object? navigation, object? entityType)
            => string.Format(
                GetString("FkAttributeOnPropertyNavigationMismatch", nameof(property), nameof(navigation), nameof(entityType)),
                property, navigation, entityType);

        /// <summary>
        ///     The [ForeignKey] attribute cannot be specified on the skip navigation '{entityType}'.'{navigation}'. Configure the foreign key properties in 'OnModelCreating' instead.
        /// </summary>
        public static string FkAttributeOnSkipNavigation(object? entityType, object? navigation)
            => string.Format(
                GetString("FkAttributeOnSkipNavigation", nameof(entityType), nameof(navigation)),
                entityType, navigation);

        /// <summary>
        ///     The number of properties specified for the foreign key {foreignKeyProperties} on entity type '{dependentType}' does not match the number of properties in the principal key {principalKeyProperties} on entity type '{principalType}'.
        /// </summary>
        public static string ForeignKeyCountMismatch(object? foreignKeyProperties, object? dependentType, object? principalKeyProperties, object? principalType)
            => string.Format(
                GetString("ForeignKeyCountMismatch", nameof(foreignKeyProperties), nameof(dependentType), nameof(principalKeyProperties), nameof(principalType)),
                foreignKeyProperties, dependentType, principalKeyProperties, principalType);

        /// <summary>
        ///     Cannot remove the foreign key {foreignKeyProperties} from entity type '{entityType}' because it is referenced by a skip navigation '{navigation}' on entity type '{navigationEntityType}'. All referencing skip navigations must be removed before the referenced foreign key can be removed.
        /// </summary>
        public static string ForeignKeyInUseSkipNavigation(object? foreignKeyProperties, object? entityType, object? navigation, object? navigationEntityType)
            => string.Format(
                GetString("ForeignKeyInUseSkipNavigation", nameof(foreignKeyProperties), nameof(entityType), nameof(navigation), nameof(navigationEntityType)),
                foreignKeyProperties, entityType, navigation, navigationEntityType);

        /// <summary>
        ///     The specified foreign key properties {foreignKeyProperties} are not declared on the entity type '{entityType}'. Ensure that foreign key properties are declared on the target entity type.
        /// </summary>
        public static string ForeignKeyPropertiesWrongEntity(object? foreignKeyProperties, object? entityType)
            => string.Format(
                GetString("ForeignKeyPropertiesWrongEntity", nameof(foreignKeyProperties), nameof(entityType)),
                foreignKeyProperties, entityType);

        /// <summary>
        ///     The property '{property}' cannot be part of a foreign key on '{entityType}' because it has a store-generated value and is contained in the key {keyProperties} defined on a base entity type '{baseEntityType}'. Configure '{property}' with 'ValueGeneratedNever' or define the foreign key on '{entityType}' instead.
        /// </summary>
        public static string ForeignKeyPropertyInKey(object? property, object? entityType, object? keyProperties, object? baseEntityType)
            => string.Format(
                GetString("ForeignKeyPropertyInKey", nameof(property), nameof(entityType), nameof(keyProperties), nameof(baseEntityType)),
                property, entityType, keyProperties, baseEntityType);

        /// <summary>
        ///     The provided principal key {principalKeyProperties} is not a key on the entity type '{principalEntityType}'. Provide a key that's defined on the principal entity type.
        /// </summary>
        public static string ForeignKeyReferencedEntityKeyMismatch(object? principalKeyProperties, object? principalEntityType)
            => string.Format(
                GetString("ForeignKeyReferencedEntityKeyMismatch", nameof(principalKeyProperties), nameof(principalEntityType)),
                principalKeyProperties, principalEntityType);

        /// <summary>
        ///     The types of the properties specified for the foreign key {foreignKeyProperties} on entity type '{dependentType}' do not match the types of the properties in the principal key {principalKeyProperties} on entity type '{principalType}'. Provide properties that use the same types in the same order.
        /// </summary>
        public static string ForeignKeyTypeMismatch(object? foreignKeyProperties, object? dependentType, object? principalKeyProperties, object? principalType)
            => string.Format(
                GetString("ForeignKeyTypeMismatch", nameof(foreignKeyProperties), nameof(dependentType), nameof(principalKeyProperties), nameof(principalType)),
                foreignKeyProperties, dependentType, principalKeyProperties, principalType);

        /// <summary>
        ///     The foreign key {foreignKeyProperties} targeting the key {keyProperties} on '{principalType}' cannot be removed from the entity type '{entityType}' because it is defined on the entity type '{otherEntityType}'.
        /// </summary>
        public static string ForeignKeyWrongType(object? foreignKeyProperties, object? keyProperties, object? principalType, object? entityType, object? otherEntityType)
            => string.Format(
                GetString("ForeignKeyWrongType", nameof(foreignKeyProperties), nameof(keyProperties), nameof(principalType), nameof(entityType), nameof(otherEntityType)),
                foreignKeyProperties, keyProperties, principalType, entityType, otherEntityType);

        /// <summary>
        ///     The entity type '{entityType}' is configured to use the '{changeTrackingStrategy}' change tracking strategy when full change tracking notifications are required. Use 'ModelBuilder.HasChangeTrackingStrategy' in 'OnModelCreating' to configure all entity types in the model to use the '{fullStrategy}' or '{fullPlusStrategy}' strategy.
        /// </summary>
        public static string FullChangeTrackingRequired(object? entityType, object? changeTrackingStrategy, object? fullStrategy, object? fullPlusStrategy)
            => string.Format(
                GetString("FullChangeTrackingRequired", nameof(entityType), nameof(changeTrackingStrategy), nameof(fullStrategy), nameof(fullPlusStrategy)),
                entityType, changeTrackingStrategy, fullStrategy, fullPlusStrategy);

        /// <summary>
        ///     The '{methodName}' method is not supported because the query has switched to client-evaluation. This usually happens when the arguments to the method cannot be translated to server. Rewrite the query to avoid client evaluation of arguments so that method can be translated to server.
        /// </summary>
        public static string FunctionOnClient(object? methodName)
            => string.Format(
                GetString("FunctionOnClient", nameof(methodName)),
                methodName);

        /// <summary>
        ///     The provided edge cannot be added because the graph does not contain the vertex '{vertex}'.
        /// </summary>
        public static string GraphDoesNotContainVertex(object? vertex)
            => string.Format(
                GetString("GraphDoesNotContainVertex", nameof(vertex)),
                vertex);

        /// <summary>
        ///     The block size used for Hi-Lo value generation is not positive. The Hi-Lo generator is usually backed by a SQL sequence and this means that the sequence increment must be positive.
        /// </summary>
        public static string HiLoBadBlockSize
            => GetString("HiLoBadBlockSize");

        /// <summary>
        ///     A relationship cycle involving the primary keys of the following entity types was detected: '{entityType}'. This would prevent any entity from being inserted without violating the store constraints. Review the foreign keys defined on the primary keys and either remove or use other properties for at least one of them.
        /// </summary>
        public static string IdentifyingRelationshipCycle(object? entityType)
            => string.Format(
                GetString("IdentifyingRelationshipCycle", nameof(entityType)),
                entityType);

        /// <summary>
        ///     The instance of entity type '{entityType}' cannot be tracked because another instance with the same key value for {keyProperties} is already being tracked. When attaching existing entities, ensure that only one entity instance with a given key value is attached. Consider using 'DbContextOptionsBuilder.EnableSensitiveDataLogging' to see the conflicting key values.
        /// </summary>
        public static string IdentityConflict(object? entityType, object? keyProperties)
            => string.Format(
                GetString("IdentityConflict", nameof(entityType), nameof(keyProperties)),
                entityType, keyProperties);

        /// <summary>
        ///     The instance of entity type '{entityType}' cannot be tracked because another instance with the same key value for {keyProperties} is already being tracked. When replacing owned entities, modify the properties without changing the instance or detach the previous owned entity entry first. Consider using 'DbContextOptionsBuilder.EnableSensitiveDataLogging' to see the conflicting key values.
        /// </summary>
        public static string IdentityConflictOwned(object? entityType, object? keyProperties)
            => string.Format(
                GetString("IdentityConflictOwned", nameof(entityType), nameof(keyProperties)),
                entityType, keyProperties);

        /// <summary>
        ///     The instance of entity type '{entityType}' cannot be tracked because another instance with the key value '{keyValue}' is already being tracked. When replacing owned entities, modify the properties without changing the instance or detach the previous owned entity entry first.
        /// </summary>
        public static string IdentityConflictOwnedSensitive(object? entityType, object? keyValue)
            => string.Format(
                GetString("IdentityConflictOwnedSensitive", nameof(entityType), nameof(keyValue)),
                entityType, keyValue);

        /// <summary>
        ///     The instance of entity type '{entityType}' cannot be tracked because another instance with the key value '{keyValue}' is already being tracked. When attaching existing entities, ensure that only one entity instance with a given key value is attached.
        /// </summary>
        public static string IdentityConflictSensitive(object? entityType, object? keyValue)
            => string.Format(
                GetString("IdentityConflictSensitive", nameof(entityType), nameof(keyValue)),
                entityType, keyValue);

        /// <summary>
        ///     The implementation type for the registration of the '{service}' service could not be determined. Specific implementation types must be used for services that expect multiple registrations so as to avoid duplicates.
        /// </summary>
        public static string ImplementationTypeRequired(object? service)
            => string.Format(
                GetString("ImplementationTypeRequired", nameof(service)),
                service);

        /// <summary>
        ///     The 'Include' operation with argument '{expression}' is not supported on entity type '{entityType}' because it has a defining query.
        /// </summary>
        [Obsolete]
        public static string IncludeOnEntityWithDefiningQueryNotSupported(object? expression, object? entityType)
            => string.Format(
                GetString("IncludeOnEntityWithDefiningQueryNotSupported", nameof(expression), nameof(entityType)),
                expression, entityType);

        /// <summary>
        ///     Cannot apply the 'Include' operation with argument '{expression}'. Either the source is not a queryable of a known entity type or 'Include' has been applied after 'Select' method which projects a different entity type through navigation. Consider applying 'Include' before 'Select' method call.
        /// </summary>
        public static string IncludeOnNonEntity(object? expression)
            => string.Format(
                GetString("IncludeOnNonEntity", nameof(expression)),
                expression);

        /// <summary>
        ///     The Include path '{navigationName}-&gt;{inverseNavigationName}' results in a cycle. Cycles are not allowed in no-tracking queries; either use a tracking query or remove the cycle.
        /// </summary>
        public static string IncludeWithCycle(object? navigationName, object? inverseNavigationName)
            => string.Format(
                GetString("IncludeWithCycle", nameof(navigationName), nameof(inverseNavigationName)),
                navigationName, inverseNavigationName);

        /// <summary>
        ///     The sentinel value '{sentinel}' is not assignable to the property '{entityType}.{property}' of type '{type}'.
        /// </summary>
        public static string IncompatibleSentinelValue(object? sentinel, object? entityType, object? property, object? type)
            => string.Format(
                GetString("IncompatibleSentinelValue", nameof(sentinel), nameof(entityType), nameof(property), nameof(type)),
                sentinel, entityType, property, type);

        /// <summary>
        ///     Incompatible sources used for set operation.
        /// </summary>
        public static string IncompatibleSourcesForSetOperation
            => GetString("IncompatibleSourcesForSetOperation");

        /// <summary>
        ///     The entity type '{entityType}' is configured as derived from '{baseEntityType}', however according to the hierarchy of the corresponding CLR types it should derive from '{clrBaseEntityType}'. Configure '{entityType}' having either '{baseEntityType}' or 'null' as the base type.
        /// </summary>
        public static string InconsistentInheritance(object? entityType, object? baseEntityType, object? clrBaseEntityType)
            => string.Format(
                GetString("InconsistentInheritance", nameof(entityType), nameof(baseEntityType), nameof(clrBaseEntityType)),
                entityType, baseEntityType, clrBaseEntityType);

        /// <summary>
        ///     '{method}' was invoked with {argumentCount} arguments, but has {parameterCount} parameters.
        /// </summary>
        public static string IncorrectNumberOfArguments(object? method, object? argumentCount, object? parameterCount)
            => string.Format(
                GetString("IncorrectNumberOfArguments", nameof(method), nameof(argumentCount), nameof(parameterCount)),
                method, argumentCount, parameterCount);

        /// <summary>
        ///     The specified index properties {indexProperties} are not declared on the entity type '{entityType}'. Ensure that index properties are declared on the target entity type.
        /// </summary>
        public static string IndexPropertiesWrongEntity(object? indexProperties, object? entityType)
            => string.Format(
                GetString("IndexPropertiesWrongEntity", nameof(indexProperties), nameof(entityType)),
                indexProperties, entityType);

        /// <summary>
        ///     The index {index} cannot be removed from the entity type '{entityType}' because it is defined on the entity type '{otherEntityType}'.
        /// </summary>
        public static string IndexWrongType(object? index, object? entityType, object? otherEntityType)
            => string.Format(
                GetString("IndexWrongType", nameof(index), nameof(entityType), nameof(otherEntityType)),
                index, entityType, otherEntityType);

        /// <summary>
        ///     The property '{property}' cannot be ignored on type '{type}' because it's declared on the base type '{baseType}'. To exclude this property from your model, use the [NotMapped] attribute or 'Ignore' on the base type in 'OnModelCreating'.
        /// </summary>
        public static string InheritedPropertyCannotBeIgnored(object? property, object? type, object? baseType)
            => string.Format(
                GetString("InheritedPropertyCannotBeIgnored", nameof(property), nameof(type), nameof(baseType)),
                property, type, baseType);

        /// <summary>
        ///     The property '{entityType}.{navigation}' is of an interface type ('{propertyType}'). If it is a navigation, manually configure the relationship for this property by casting it to a mapped entity type. Otherwise, ignore the property using the [NotMapped] attribute or 'Ignore' in 'OnModelCreating'.
        /// </summary>
        public static string InterfacePropertyNotAdded(object? entityType, object? navigation, object? propertyType)
            => string.Format(
                GetString("InterfacePropertyNotAdded", nameof(entityType), nameof(navigation), nameof(propertyType)),
                entityType, navigation, propertyType);

        /// <summary>
        ///     Unable to track an entity of type '{entityType}' because alternate key property '{keyProperty}' is null. If the alternate key is not used in a relationship, then consider using a unique index instead. Unique indexes may contain nulls, while alternate keys may not.
        /// </summary>
        public static string InvalidAlternateKeyValue(object? entityType, object? keyProperty)
            => string.Format(
                GetString("InvalidAlternateKeyValue", nameof(entityType), nameof(keyProperty)),
                entityType, keyProperty);

        /// <summary>
        ///     The specified type '{type}' must be a non-interface type with a public constructor to be used as a complex type.
        /// </summary>
        public static string InvalidComplexType(object? type)
            => string.Format(
                GetString("InvalidComplexType", nameof(type)),
                type);

        /// <summary>
        ///     A previous error has left the DbContext in an invalid state. Applications should not continue to use a DbContext instance after an InvalidOperationException has been thrown.
        /// </summary>
        public static string InvalidDbContext
            => GetString("InvalidDbContext");

        /// <summary>
        ///     The specified type '{type}' must be a non-interface reference type to be used as an entity type.
        /// </summary>
        public static string InvalidEntityType(object? type)
            => string.Format(
                GetString("InvalidEntityType", nameof(type)),
                type);

        /// <summary>
        ///     The entity type configuration of type '{entityTypeConfigurationType}' is invalid. The configuration specified using EntityTypeConfigurationAttribute has to implement 'IEntityTypeConfiguration&lt;{entityType}&gt;'.
        /// </summary>
        public static string InvalidEntityTypeConfigurationAttribute(object? entityTypeConfigurationType, object? entityType)
            => string.Format(
                GetString("InvalidEntityTypeConfigurationAttribute", nameof(entityTypeConfigurationType), nameof(entityType)),
                entityTypeConfigurationType, entityType);

        /// <summary>
        ///     The value '{value}' provided for argument '{argumentName}' must be a valid value of enum type '{enumType}'.
        /// </summary>
        public static string InvalidEnumValue(object? value, object? argumentName, object? enumType)
            => string.Format(
                GetString("InvalidEnumValue", nameof(value), nameof(argumentName), nameof(enumType)),
                value, argumentName, enumType);

        /// <summary>
        ///     The expression '{expression}' is invalid inside an 'Include' operation, since it does not represent a property access: 't =&gt; t.MyProperty'. To target navigations declared on derived types, use casting ('t =&gt; ((Derived)t).MyProperty') or the 'as' operator ('t =&gt; (t as Derived).MyProperty'). Collection navigation access can be filtered by composing Where, OrderBy(Descending), ThenBy(Descending), Skip or Take operations. For more information on including related data, see https://go.microsoft.com/fwlink/?LinkID=746393.
        /// </summary>
        public static string InvalidIncludeExpression(object? expression)
            => string.Format(
                GetString("InvalidIncludeExpression", nameof(expression)),
                expression);

        /// <summary>
        ///     Unable to track an entity of type '{entityType}' because its primary key property '{keyProperty}' is null.
        /// </summary>
        public static string InvalidKeyValue(object? entityType, object? keyProperty)
            => string.Format(
                GetString("InvalidKeyValue", nameof(entityType), nameof(keyProperty)),
                entityType, keyProperty);

        /// <summary>
        ///     The expression '{expression}' is not a valid member access expression. The expression should represent a simple property or field access: 't =&gt; t.MyProperty'.
        /// </summary>
        public static string InvalidMemberExpression(object? expression)
            => string.Format(
                GetString("InvalidMemberExpression", nameof(expression)),
                expression);

        /// <summary>
        ///     The expression '{expression}' is not a valid member access expression. The expression should represent a simple property or field access: 't =&gt; t.MyProperty'. When specifying multiple properties or fields, use an anonymous type: 't =&gt; new {{ t.MyProperty, t.MyField }}'.
        /// </summary>
        public static string InvalidMembersExpression(object? expression)
            => string.Format(
                GetString("InvalidMembersExpression", nameof(expression)),
                expression);

        /// <summary>
        ///     The [InverseProperty] attribute on property '{1_entityType}.{0_property}' is not valid. The property '{referencedProperty}' is not a valid navigation on the related type '{referencedEntityType}'. Ensure that the property exists and is a valid reference or collection navigation.
        /// </summary>
        public static string InvalidNavigationWithInverseProperty(object? property, object? entityType, object? referencedProperty, object? referencedEntityType)
            => string.Format(
                GetString("InvalidNavigationWithInverseProperty", "0_property", "1_entityType", nameof(referencedProperty), nameof(referencedEntityType)),
                property, entityType, referencedProperty, referencedEntityType);

        /// <summary>
        ///     Invalid number of index sort order values provided for {indexProperties}: {numValues} values were provided, but the index has {numProperties} properties.
        /// </summary>
        public static string InvalidNumberOfIndexSortOrderValues(object? indexProperties, object? numValues, object? numProperties)
            => string.Format(
                GetString("InvalidNumberOfIndexSortOrderValues", nameof(indexProperties), nameof(numValues), nameof(numProperties)),
                indexProperties, numValues, numProperties);

        /// <summary>
        ///     The specified poolSize must be greater than 0.
        /// </summary>
        public static string InvalidPoolSize
            => GetString("InvalidPoolSize");

        /// <summary>
        ///     The property list specified using [ForeignKey("{2_properties}")] attribute on navigation '{1_entityType}.{0_navigation}' is incorrect. Provide a comma-separated list of property names.
        /// </summary>
        public static string InvalidPropertyListOnNavigation(object? navigation, object? entityType, object? properties)
            => string.Format(
                GetString("InvalidPropertyListOnNavigation", "0_navigation", "1_entityType", "2_properties"),
                navigation, entityType, properties);

        /// <summary>
        ///     An invalid relationship has been specified using the [InverseProperty] and [ForeignKey] attributes. The navigations '{1_entityType}.{0_navigation}' and '{3_referencedEntityType}.{2_referencedNavigation}' are related by the [InverseProperty] attribute, but the [ForeignKey] attributes specified for both navigations have different values. Either specify the same properties or remove one of the attributes.
        /// </summary>
        public static string InvalidRelationshipUsingDataAnnotations(object? navigation, object? entityType, object? referencedNavigation, object? referencedEntityType)
            => string.Format(
                GetString("InvalidRelationshipUsingDataAnnotations", "0_navigation", "1_entityType", "2_referencedNavigation", "3_referencedEntityType"),
                navigation, entityType, referencedNavigation, referencedEntityType);

        /// <summary>
        ///     A call was made to '{replaceService}', but Entity Framework is not building its own internal service provider. Either allow Entity Framework to build the service provider by removing the call to '{useInternalServiceProvider}', or build replacement services into the service provider before passing it to '{useInternalServiceProvider}'.
        /// </summary>
        public static string InvalidReplaceService(object? replaceService, object? useInternalServiceProvider)
            => string.Format(
                GetString("InvalidReplaceService", nameof(replaceService), nameof(useInternalServiceProvider)),
                replaceService, useInternalServiceProvider);

        /// <summary>
        ///     The invoked method cannot be used for the entity type '{entityType}' because it does not have a primary key. For more information on keyless entity types, see https://go.microsoft.com/fwlink/?linkid=2141943.
        /// </summary>
        public static string InvalidSetKeylessOperation(object? entityType)
            => string.Format(
                GetString("InvalidSetKeylessOperation", nameof(entityType)),
                entityType);

        /// <summary>
        ///     Cannot create a DbSet for '{typeName}' because this type is not included in the model for the context. However the model contains an entity type with the same name in a different namespace: '{entityTypeName}'.
        /// </summary>
        public static string InvalidSetSameTypeWithDifferentNamespace(object? typeName, object? entityTypeName)
            => string.Format(
                GetString("InvalidSetSameTypeWithDifferentNamespace", nameof(typeName), nameof(entityTypeName)),
                typeName, entityTypeName);

        /// <summary>
        ///     Cannot create a DbSet for '{typeName}' because it is configured as a shared-type entity type. Access the entity type via the 'Set' method overload that accepts an entity type name.
        /// </summary>
        public static string InvalidSetSharedType(object? typeName)
            => string.Format(
                GetString("InvalidSetSharedType", nameof(typeName)),
                typeName);

        /// <summary>
        ///     Cannot create a DbSet for '{typeName}' because this type is not included in the model for the context.
        /// </summary>
        public static string InvalidSetType(object? typeName)
            => string.Format(
                GetString("InvalidSetType", nameof(typeName)),
                typeName);

        /// <summary>
        ///     Cannot create a DbSet for '{typeName}' because it is configured as an owned entity type and must be accessed through its owning entity type '{ownerType}'. See https://aka.ms/efcore-docs-owned for more information.
        /// </summary>
        public static string InvalidSetTypeOwned(object? typeName, object? ownerType)
            => string.Format(
                GetString("InvalidSetTypeOwned", nameof(typeName), nameof(ownerType)),
                typeName, ownerType);

        /// <summary>
        ///     Invalid {name}: {value}
        /// </summary>
        public static string InvalidSwitch(object? name, object? value)
            => string.Format(
                GetString("InvalidSwitch", nameof(name), nameof(value)),
                name, value);

        /// <summary>
        ///     The value for property '{1_entityType}.{0_property}' cannot be set to a value of type '{valueType}' because its type is '{propertyType}'.
        /// </summary>
        public static string InvalidType(object? property, object? entityType, object? valueType, object? propertyType)
            => string.Format(
                GetString("InvalidType", "0_property", "1_entityType", nameof(valueType), nameof(propertyType)),
                property, entityType, valueType, propertyType);

        /// <summary>
        ///     Unable to include navigation chain '{includeExpression}' specified by 'Include' operation as the converted type '{type}' is not part of the model.
        /// </summary>
        public static string InvalidTypeConversionWithInclude(object? includeExpression, object? type)
            => string.Format(
                GetString("InvalidTypeConversionWithInclude", nameof(includeExpression), nameof(type)),
                includeExpression, type);

        /// <summary>
        ///     A call was made to '{useService}', but Entity Framework is not building its own internal service provider. Either allow Entity Framework to build the service provider by removing the call to '{useInternalServiceProvider}', or build the '{service}' services to use into the service provider before passing it to '{useInternalServiceProvider}'.
        /// </summary>
        public static string InvalidUseService(object? useService, object? useInternalServiceProvider, object? service)
            => string.Format(
                GetString("InvalidUseService", nameof(useService), nameof(useInternalServiceProvider), nameof(service)),
                useService, useInternalServiceProvider, service);

        /// <summary>
        ///     The '{factory}' cannot create a value generator for property '{2_entityType}.{1_property}'. Only integer properties are supported.
        /// </summary>
        public static string InvalidValueGeneratorFactoryProperty(object? factory, object? property, object? entityType)
            => string.Format(
                GetString("InvalidValueGeneratorFactoryProperty", nameof(factory), "1_property", "2_entityType"),
                factory, property, entityType);

        /// <summary>
        ///     [InverseProperty] attributes on navigation '{1_entityType}.{0_navigation}' and on navigation '{3_referencedEntityType}.{2_referencedNavigation}' are not pointing to each other. Change the attributes to use the corresponding names or remove one of them.
        /// </summary>
        public static string InversePropertyMismatch(object? navigation, object? entityType, object? referencedNavigation, object? referencedEntityType)
            => string.Format(
                GetString("InversePropertyMismatch", "0_navigation", "1_entityType", "2_referencedNavigation", "3_referencedEntityType"),
                navigation, entityType, referencedNavigation, referencedEntityType);

        /// <summary>
        ///     The navigation '{principalEntityType}.{navigation}' is not supported because it is pointing to an owned entity type '{ownedType}'. Only the ownership navigation from the entity type '{ownerType}' can point to the owned entity type. See https://aka.ms/efcore-docs-owned for more information.
        /// </summary>
        public static string InverseToOwnedType(object? principalEntityType, object? navigation, object? ownedType, object? ownerType)
            => string.Format(
                GetString("InverseToOwnedType", nameof(principalEntityType), nameof(navigation), nameof(ownedType), nameof(ownerType)),
                principalEntityType, navigation, ownedType, ownerType);

        /// <summary>
        ///     The source 'IQueryable' doesn't implement 'IAsyncEnumerable&lt;{genericParameter}&gt;'. Only sources that implement 'IAsyncEnumerable' can be used for Entity Framework asynchronous operations.
        /// </summary>
        public static string IQueryableNotAsync(object? genericParameter)
            => string.Format(
                GetString("IQueryableNotAsync", nameof(genericParameter)),
                genericParameter);

        /// <summary>
        ///     The provider for the source 'IQueryable' doesn't implement 'IAsyncQueryProvider'. Only providers that implement 'IAsyncQueryProvider' can be used for Entity Framework asynchronous operations.
        /// </summary>
        public static string IQueryableProviderNotAsync
            => GetString("IQueryableProviderNotAsync");

        /// <summary>
        ///     Invalid token type: '{tokenType}'.
        /// </summary>
        public static string JsonReaderInvalidTokenType(object? tokenType)
            => string.Format(
                GetString("JsonReaderInvalidTokenType", nameof(tokenType)),
                tokenType);

        /// <summary>
        ///     The derived type '{derivedType}' cannot have the [Key] attribute on property '{property}' since primary keys may only be declared on the root type. Move the property '{property}' to '{rootType}' or remove '{rootType}' from the model by using [NotMapped] attribute or calling 'EntityTypeBuilder.Ignore' on the base type in 'OnModelCreating'.
        /// </summary>
        public static string KeyAttributeOnDerivedEntity(object? derivedType, object? property, object? rootType)
            => string.Format(
                GetString("KeyAttributeOnDerivedEntity", nameof(derivedType), nameof(property), nameof(rootType)),
                derivedType, property, rootType);

        /// <summary>
        ///     Cannot remove key {keyProperties} from entity type '{entityType}' because it is referenced by a foreign key {foreignKeyProperties} defined on entity type '{dependentType}'. Remove or change the principal key for all referencing foreign keys before removing the key.
        /// </summary>
        public static string KeyInUse(object? keyProperties, object? entityType, object? foreignKeyProperties, object? dependentType)
            => string.Format(
                GetString("KeyInUse", nameof(keyProperties), nameof(entityType), nameof(foreignKeyProperties), nameof(dependentType)),
                keyProperties, entityType, foreignKeyProperties, dependentType);

        /// <summary>
        ///     The entity type '{entityType}' cannot be marked as keyless because it contains a key {keyProperties}.
        /// </summary>
        public static string KeylessTypeExistingKey(object? entityType, object? keyProperties)
            => string.Format(
                GetString("KeylessTypeExistingKey", nameof(entityType), nameof(keyProperties)),
                entityType, keyProperties);

        /// <summary>
        ///     Unable to track an instance of type '{type}' because it does not have a primary key. Only entity types with a primary key may be tracked.
        /// </summary>
        public static string KeylessTypeTracked(object? type)
            => string.Format(
                GetString("KeylessTypeTracked", nameof(type)),
                type);

        /// <summary>
        ///     The key {keyProperties} cannot be added to keyless type '{entityType}'.
        /// </summary>
        public static string KeylessTypeWithKey(object? keyProperties, object? entityType)
            => string.Format(
                GetString("KeylessTypeWithKey", nameof(keyProperties), nameof(entityType)),
                keyProperties, entityType);

        /// <summary>
        ///     The specified key properties {keyProperties} are not declared on the entity type '{entityType}'. Ensure key properties are declared on the target entity type.
        /// </summary>
        public static string KeyPropertiesWrongEntity(object? keyProperties, object? entityType)
            => string.Format(
                GetString("KeyPropertiesWrongEntity", nameof(keyProperties), nameof(entityType)),
                keyProperties, entityType);

        /// <summary>
        ///     The property '{1_entityType}.{0_property}' cannot be marked as nullable/optional because it has been included in the key {keyProperties}.
        /// </summary>
        public static string KeyPropertyCannotBeNullable(object? property, object? entityType, object? keyProperties)
            => string.Format(
                GetString("KeyPropertyCannotBeNullable", "0_property", "1_entityType", nameof(keyProperties)),
                property, entityType, keyProperties);

        /// <summary>
        ///     The property '{1_entityType}.{0_property}' must be marked as read-only after it has been saved because it is part of a key. Key properties are always read-only once an entity has been saved for the first time.
        /// </summary>
        public static string KeyPropertyMustBeReadOnly(object? property, object? entityType)
            => string.Format(
                GetString("KeyPropertyMustBeReadOnly", "0_property", "1_entityType"),
                property, entityType);

        /// <summary>
        ///     The property '{1_entityType}.{0_property}' is part of a key and so cannot be modified or marked as modified. To change the principal of an existing entity with an identifying foreign key, first delete the dependent and invoke 'SaveChanges', and then associate the dependent with the new principal.
        /// </summary>
        public static string KeyReadOnly(object? property, object? entityType)
            => string.Format(
                GetString("KeyReadOnly", "0_property", "1_entityType"),
                property, entityType);

        /// <summary>
        ///     The key {keyProperties} cannot be removed from the entity type '{entityType}' because it is defined on the entity type '{otherEntityType}'.
        /// </summary>
        public static string KeyWrongType(object? keyProperties, object? entityType, object? otherEntityType)
            => string.Format(
                GetString("KeyWrongType", nameof(keyProperties), nameof(entityType), nameof(otherEntityType)),
                keyProperties, entityType, otherEntityType);

        /// <summary>
        ///     The type mapping for '{type}' has not implemented code literal generation.
        /// </summary>
        public static string LiteralGenerationNotSupported(object? type)
            => string.Format(
                GetString("LiteralGenerationNotSupported", nameof(type)),
                type);

        /// <summary>
        ///     The navigation '{entityType}.{navigation}' cannot be used for both sides of a many-to-many relationship. Many-to-many relationships must use two distinct navigation properties.
        /// </summary>
        public static string ManyToManyOneNav(object? entityType, object? navigation)
            => string.Format(
                GetString("ManyToManyOneNav", nameof(entityType), nameof(navigation)),
                entityType, navigation);

        /// <summary>
        ///     EF Core does not support MemberListBinding: 'new Blog { Posts = { new Post(), new Post() } }'.
        /// </summary>
        public static string MemberListBindingNotSupported
            => GetString("MemberListBindingNotSupported");

        /// <summary>
        ///     EF Core does not support MemberMemberBinding: 'new Blog { Data = { Name = "hello world" } }'.
        /// </summary>
        public static string MemberMemberBindingNotSupported
            => GetString("MemberMemberBindingNotSupported");

        /// <summary>
        ///     An asynchronous store management operation was performed and no asynchronous seed delegate has been provided, however a synchronous seed delegate was. Set 'UseAsyncSeeding' option with a delegate equivalent to the one supplied in 'UseSeeding'.
        /// </summary>
        public static string MissingAsyncSeeder
            => GetString("MissingAsyncSeeder");

        /// <summary>
        ///     The specified field '{field}' could not be found for property '{2_entityType}.{1_property}'.
        /// </summary>
        public static string MissingBackingField(object? field, object? property, object? entityType)
            => string.Format(
                GetString("MissingBackingField", nameof(field), "1_property", "2_entityType"),
                field, property, entityType);

        /// <summary>
        ///     A synchronous store management operation was performed and no synchronous seed delegate has been provided, however an asynchronous seed delegate was. Set 'UseSeeding' option with a delegate equivalent to the one supplied in 'UseAsyncSeeding'.
        /// </summary>
        public static string MissingSeeder
            => GetString("MissingSeeder");

        /// <summary>
        ///     Runtime metadata changes are not allowed when the model hasn't been marked as read-only.
        /// </summary>
        public static string ModelMutable
            => GetString("ModelMutable");

        /// <summary>
        ///     The model must be finalized and its runtime dependencies must be initialized before '{method}' can be used. Ensure that either 'OnModelCreating' has completed or, if using a stand-alone 'ModelBuilder', that 'IModelRuntimeInitializer.Initialize(model.FinalizeModel())' was called.
        /// </summary>
        public static string ModelNotFinalized(object? method)
            => string.Format(
                GetString("ModelNotFinalized", nameof(method)),
                method);

        /// <summary>
        ///     Metadata changes are not allowed when the model has been marked as read-only.
        /// </summary>
        public static string ModelReadOnly
            => GetString("ModelReadOnly");

        /// <summary>
        ///     The filters '{filter1}' and '{filter2}' have both been configured on the same included navigation. Only one unique filter per navigation is allowed. For more information on including related data, see https://go.microsoft.com/fwlink/?LinkID=746393.
        /// </summary>
        public static string MultipleFilteredIncludesOnSameNavigation(object? filter1, object? filter2)
            => string.Format(
                GetString("MultipleFilteredIncludesOnSameNavigation", nameof(filter1), nameof(filter2)),
                filter1, filter2);

        /// <summary>
        ///     There are multiple navigations in entity type '{entityType}' which are pointing to same set of properties '{properties}' using a [ForeignKey] attribute: {navigations}.
        /// </summary>
        public static string MultipleNavigationsSameFk(object? entityType, object? properties, object? navigations)
            => string.Format(
                GetString("MultipleNavigationsSameFk", nameof(entityType), nameof(properties), nameof(navigations)),
                entityType, properties, navigations);

        /// <summary>
        ///     The entity type '{entityType}' is the target of multiple ownership relationships: {navigations}.
        /// </summary>
        public static string MultipleOwnerships(object? entityType, object? navigations)
            => string.Format(
                GetString("MultipleOwnerships", nameof(entityType), nameof(navigations)),
                entityType, navigations);

        /// <summary>
        ///     Services for database providers {storeNames} have been registered in the service provider. Only a single database provider can be registered in a service provider. If possible, ensure that Entity Framework is managing its service provider by removing the call to 'UseInternalServiceProvider'. Otherwise, consider conditionally registering the database provider, or maintaining one service provider per database provider.
        /// </summary>
        public static string MultipleProvidersConfigured(object? storeNames)
            => string.Format(
                GetString("MultipleProvidersConfigured", nameof(storeNames)),
                storeNames);

        /// <summary>
        ///     When called from '{caller}', rewriting a node of type '{type}' must return a non-null value of the same type. Alternatively, override '{caller}' and change it to not visit children of this type.
        /// </summary>
        public static string MustRewriteToSameNode(object? caller, object? type)
            => string.Format(
                GetString("MustRewriteToSameNode", nameof(caller), nameof(type)),
                caller, type);

        /// <summary>
        ///     The property '{keyProperty}' cannot be configured as 'ValueGeneratedOnUpdate' or 'ValueGeneratedOnAddOrUpdate' because it's part of a key and its value cannot be changed after the entity has been added to the store.
        /// </summary>
        public static string MutableKeyProperty(object? keyProperty)
            => string.Format(
                GetString("MutableKeyProperty", nameof(keyProperty)),
                keyProperty);

        /// <summary>
        ///     The index '{indexName}' specified via [Index] attribute on the entity type '{entityType}' with properties {indexProperties} is invalid. The property '{propertyName}' has been marked as unmapped via the [NotMapped] attribute or the 'EntityTypeBuilder.Ignore' fluent API. An index cannot use unmapped properties.
        /// </summary>
        public static string NamedIndexDefinedOnIgnoredProperty(object? indexName, object? entityType, object? indexProperties, object? propertyName)
            => string.Format(
                GetString("NamedIndexDefinedOnIgnoredProperty", nameof(indexName), nameof(entityType), nameof(indexProperties), nameof(propertyName)),
                indexName, entityType, indexProperties, propertyName);

        /// <summary>
        ///     An index '{indexName}' specified via [Index] attribute on the entity type '{entityType}' references properties {indexProperties}, but no property with name '{propertyName}' exists on that entity type or any of its base types.
        /// </summary>
        public static string NamedIndexDefinedOnNonExistentProperty(object? indexName, object? entityType, object? indexProperties, object? propertyName)
            => string.Format(
                GetString("NamedIndexDefinedOnNonExistentProperty", nameof(indexName), nameof(entityType), nameof(indexProperties), nameof(propertyName)),
                indexName, entityType, indexProperties, propertyName);

        /// <summary>
        ///     The index with name {indexName} cannot be removed from the entity type '{entityType}' because no such index exists on that entity type.
        /// </summary>
        public static string NamedIndexWrongType(object? indexName, object? entityType)
            => string.Format(
                GetString("NamedIndexWrongType", nameof(indexName), nameof(entityType)),
                indexName, entityType);

        /// <summary>
        ///     Design-time DbContext operations are not supported when publishing with NativeAOT.
        /// </summary>
        public static string NativeAotDesignTimeModel
            => GetString("NativeAotDesignTimeModel");

        /// <summary>
        ///     Model building is not supported when publishing with NativeAOT. Use a compiled model.
        /// </summary>
        public static string NativeAotNoCompiledModel
            => GetString("NativeAotNoCompiledModel");

        /// <summary>
        ///     The type of navigation '{1_entityType}.{0_navigation}' is '{foundType}' which is an array type. Collection navigations cannot be arrays.
        /// </summary>
        public static string NavigationArray(object? navigation, object? entityType, object? foundType)
            => string.Format(
                GetString("NavigationArray", "0_navigation", "1_entityType", nameof(foundType)),
                navigation, entityType, foundType);

        /// <summary>
        ///     The type of navigation '{1_entityType}.{0_navigation}' is '{foundType}' which does not implement 'ICollection&lt;{targetType}&gt;'. Collection navigations must implement 'ICollection&lt;&gt;' of the target type.
        /// </summary>
        public static string NavigationBadType(object? navigation, object? entityType, object? foundType, object? targetType)
            => string.Format(
                GetString("NavigationBadType", "0_navigation", "1_entityType", nameof(foundType), nameof(targetType)),
                navigation, entityType, foundType, targetType);

        /// <summary>
        ///     The type of navigation '{1_entityType}.{0_navigation}' is '{foundType}' for which it was not possible to create a concrete instance. Either initialize the property before use, add a public parameterless constructor to the type, or use a type which can be assigned a 'HashSet&lt;&gt;' or 'List&lt;&gt;'.
        /// </summary>
        public static string NavigationCannotCreateType(object? navigation, object? entityType, object? foundType)
            => string.Format(
                GetString("NavigationCannotCreateType", "0_navigation", "1_entityType", nameof(foundType)),
                navigation, entityType, foundType);

        /// <summary>
        ///     The collection navigation '{navigation}' cannot be added to the entity type '{entityType}' because its CLR type '{clrType}' does not implement 'IEnumerable&lt;{targetType}&gt;'. Collection navigations must implement IEnumerable&lt;&gt; of the related entity.
        /// </summary>
        public static string NavigationCollectionWrongClrType(object? navigation, object? entityType, object? clrType, object? targetType)
            => string.Format(
                GetString("NavigationCollectionWrongClrType", nameof(navigation), nameof(entityType), nameof(clrType), nameof(targetType)),
                navigation, entityType, clrType, targetType);

        /// <summary>
        ///     The navigation '{1_entityType}.{0_navigation}' cannot be associated with foreign key {targetForeignKeyProperties} because it was created for foreign key {actualForeignKeyProperties}.
        /// </summary>
        public static string NavigationForWrongForeignKey(object? navigation, object? entityType, object? targetForeignKeyProperties, object? actualForeignKeyProperties)
            => string.Format(
                GetString("NavigationForWrongForeignKey", "0_navigation", "1_entityType", nameof(targetForeignKeyProperties), nameof(actualForeignKeyProperties)),
                navigation, entityType, targetForeignKeyProperties, actualForeignKeyProperties);

        /// <summary>
        ///     The property '{1_entityType}.{0_property}' is being accessed using the '{referenceMethod}' or '{collectionMethod}' method, but is defined in the model as a non-navigation. Use the '{propertyMethod}' method to access non-navigation properties.
        /// </summary>
        public static string NavigationIsProperty(object? property, object? entityType, object? referenceMethod, object? collectionMethod, object? propertyMethod)
            => string.Format(
                GetString("NavigationIsProperty", "0_property", "1_entityType", nameof(referenceMethod), nameof(collectionMethod), nameof(propertyMethod)),
                property, entityType, referenceMethod, collectionMethod, propertyMethod);

        /// <summary>
        ///     The relationship between '{principalEntityType}' and '{dependentEntityType}' cannot be configured as an ownership as there is no associated navigation to the owned type. An ownership must always have an associated navigation. See https://aka.ms/efcore-docs-owned for more information.
        /// </summary>
        public static string NavigationlessOwnership(object? principalEntityType, object? dependentEntityType)
            => string.Format(
                GetString("NavigationlessOwnership", nameof(principalEntityType), nameof(dependentEntityType)),
                principalEntityType, dependentEntityType);

        /// <summary>
        ///     The navigation '{1_entityType}.{0_navigation}' does not have a setter and no writable backing field was found or specified. Read-only collection navigations must be initialized before use.
        /// </summary>
        public static string NavigationNoSetter(object? navigation, object? entityType)
            => string.Format(
                GetString("NavigationNoSetter", "0_navigation", "1_entityType"),
                navigation, entityType);

        /// <summary>
        ///     Unable to determine the relationship represented by navigation '{entityType}.{navigation}' of type '{propertyType}'. Either manually configure the relationship, or ignore this property using the '[NotMapped]' attribute or by using 'EntityTypeBuilder.Ignore' in 'OnModelCreating'.
        /// </summary>
        public static string NavigationNotAdded(object? entityType, object? navigation, object? propertyType)
            => string.Format(
                GetString("NavigationNotAdded", nameof(entityType), nameof(navigation), nameof(propertyType)),
                entityType, navigation, propertyType);

        /// <summary>
        ///     The property '{entityType}.{navigation}' of type '{propertyType}' appears to be a navigation to another entity type. Navigations are not supported when using 'SqlQuery". Either include this type in the model and use 'FromSql' for the query, or ignore this property using the '[NotMapped]' attribute.
        /// </summary>
        public static string NavigationNotAddedAdHoc(object? entityType, object? navigation, object? propertyType)
            => string.Format(
                GetString("NavigationNotAddedAdHoc", nameof(entityType), nameof(navigation), nameof(propertyType)),
                entityType, navigation, propertyType);

        /// <summary>
        ///     Unable to configure navigation '{complexType}.{navigation}' of type '{propertyType}' as complex types don't support navigations. Ignore this property using the '[NotMapped]' attribute or by using 'EntityTypeBuilder.Ignore' in 'OnModelCreating'.
        /// </summary>
        public static string NavigationNotAddedComplexType(object? complexType, object? navigation, object? propertyType)
            => string.Format(
                GetString("NavigationNotAddedComplexType", nameof(complexType), nameof(navigation), nameof(propertyType)),
                complexType, navigation, propertyType);

        /// <summary>
        ///     The navigation '{navigation}' cannot be added to the entity type '{entityType}' because its CLR type '{clrType}' does not match the expected CLR type '{targetType}'.
        /// </summary>
        public static string NavigationSingleWrongClrType(object? navigation, object? entityType, object? clrType, object? targetType)
            => string.Format(
                GetString("NavigationSingleWrongClrType", nameof(navigation), nameof(entityType), nameof(clrType), nameof(targetType)),
                navigation, entityType, clrType, targetType);

        /// <summary>
        ///     The navigation '{navigation}' cannot be added because it targets the keyless entity type '{entityType}'. Navigations can only target entity types with keys. For more information on keyless entity types, see https://go.microsoft.com/fwlink/?linkid=2141943.
        /// </summary>
        public static string NavigationToKeylessType(object? navigation, object? entityType)
            => string.Format(
                GetString("NavigationToKeylessType", nameof(navigation), nameof(entityType)),
                navigation, entityType);

        /// <summary>
        ///     No backing field was found for property '{1_entityType}.{0_property}'. Name the backing field so that it is discovered by convention, configure the backing field to use, or use a different '{propertyAccessMode}'.
        /// </summary>
        public static string NoBackingField(object? property, object? entityType, object? propertyAccessMode)
            => string.Format(
                GetString("NoBackingField", "0_property", "1_entityType", nameof(propertyAccessMode)),
                property, entityType, propertyAccessMode);

        /// <summary>
        ///     No backing field was found for property '{1_entityType}.{0_property}'. Lazy-loaded navigations must have backing fields. Either name the backing field so that it is discovered by convention or configure the backing field to use.
        /// </summary>
        public static string NoBackingFieldLazyLoading(object? property, object? entityType)
            => string.Format(
                GetString("NoBackingFieldLazyLoading", "0_property", "1_entityType"),
                property, entityType);

        /// <summary>
        ///     The navigation '{navigation}' cannot be added to the entity type '{entityType}' because there is no corresponding CLR property on the underlying type and navigations properties cannot be added in shadow state.
        /// </summary>
        public static string NoClrNavigation(object? navigation, object? entityType)
            => string.Format(
                GetString("NoClrNavigation", nameof(navigation), nameof(entityType)),
                navigation, entityType);

        /// <summary>
        ///     The entity type '{entityType}' is part of a hierarchy, but does not have a discriminator property configured.
        /// </summary>
        public static string NoDiscriminatorProperty(object? entityType)
            => string.Format(
                GetString("NoDiscriminatorProperty", nameof(entityType)),
                entityType);

        /// <summary>
        ///     The entity type '{entityType}' has a discriminator property, but does not have a discriminator value configured.
        /// </summary>
        public static string NoDiscriminatorValue(object? entityType)
            => string.Format(
                GetString("NoDiscriminatorValue", nameof(entityType)),
                entityType);

        /// <summary>
        ///     Entity Framework services have not been added to the internal service provider. Either remove the call to 'UseInternalServiceProvider' so that Entity Framework will manage its own internal services, or use the method from your database provider to add the required services to the service provider (e.g. 'AddEntityFrameworkSqlServer').
        /// </summary>
        public static string NoEfServices
            => GetString("NoEfServices");

        /// <summary>
        ///     No backing field could be found for property '{1_entityType}.{0_property}' and the property does not have a getter.
        /// </summary>
        public static string NoFieldOrGetter(object? property, object? entityType)
            => string.Format(
                GetString("NoFieldOrGetter", "0_property", "1_entityType"),
                property, entityType);

        /// <summary>
        ///     No backing field could be found for property '{1_entityType}.{0_property}' and the property does not have a setter.
        /// </summary>
        public static string NoFieldOrSetter(object? property, object? entityType)
            => string.Format(
                GetString("NoFieldOrSetter", "0_property", "1_entityType"),
                property, entityType);

        /// <summary>
        ///     The property '{1_entityType}.{0_property}' does not have a getter. Either make the property readable or use a different '{propertyAccessMode}'.
        /// </summary>
        public static string NoGetter(object? property, object? entityType, object? propertyAccessMode)
            => string.Format(
                GetString("NoGetter", "0_property", "1_entityType", nameof(propertyAccessMode)),
                property, entityType, propertyAccessMode);

        /// <summary>
        ///     'InterceptionResult.Result' was called when 'InterceptionResult.HasResult' is false.
        /// </summary>
        public static string NoInterceptionResult
            => GetString("NoInterceptionResult");

        /// <summary>
        ///     Property '{entityType}.{property}' cannot be used as a key because it has type '{providerType}' which does not implement 'IComparable&lt;T&gt;', 'IComparable' or 'IStructuralComparable'. Use 'HasConversion' in 'OnModelCreating' to wrap '{providerType}' with a type that can be compared.
        /// </summary>
        public static string NonComparableKeyType(object? entityType, object? property, object? providerType)
            => string.Format(
                GetString("NonComparableKeyType", nameof(entityType), nameof(property), nameof(providerType)),
                entityType, property, providerType);

        /// <summary>
        ///     Property '{entityType}.{property}' cannot be used as a key because it has type '{modelType}' and provider type '{providerType}', neither of which implement 'IComparable&lt;T&gt;', 'IComparable' or 'IStructuralComparable'. Make '{modelType}' implement one of these interfaces to use it as a key.
        /// </summary>
        public static string NonComparableKeyTypes(object? entityType, object? property, object? modelType, object? providerType)
            => string.Format(
                GetString("NonComparableKeyTypes", nameof(entityType), nameof(property), nameof(modelType), nameof(providerType)),
                entityType, property, modelType, providerType);

        /// <summary>
        ///     The navigation '{1_entityType}.{0_navigation}' must be configured in 'OnModelCreating' with an explicit name for the target shared-type entity type, or excluded by calling 'EntityTypeBuilder.Ignore'.
        /// </summary>
        public static string NonConfiguredNavigationToSharedType(object? navigation, object? entityType)
            => string.Format(
                GetString("NonConfiguredNavigationToSharedType", "0_navigation", "1_entityType"),
                navigation, entityType);

        /// <summary>
        ///     The DbContextOptions passed to the {contextType} constructor must be a DbContextOptions&lt;{contextType}&gt;. When registering multiple DbContext types, make sure that the constructor for each context type has a DbContextOptions&lt;TContext&gt; parameter rather than a non-generic DbContextOptions parameter.
        /// </summary>
        public static string NonGenericOptions(object? contextType)
            => string.Format(
                GetString("NonGenericOptions", nameof(contextType)),
                contextType);

        /// <summary>
        ///     Cannot add indexer property '{property}' since there is no indexer on '{entityType}' taking a single argument of type assignable from '{type}'.
        /// </summary>
        public static string NonIndexerEntityType(object? property, object? entityType, object? type)
            => string.Format(
                GetString("NonIndexerEntityType", nameof(property), nameof(entityType), nameof(type)),
                property, entityType, type);

        /// <summary>
        ///     The complex collection '{entityType}'.'{name}' is of type '{type}' which does not implement '{listInterface}'.
        /// </summary>
        public static string NonListCollection(object? entityType, object? name, object? type, object? listInterface)
            => string.Format(
                GetString("NonListCollection", nameof(entityType), nameof(name), nameof(type), nameof(listInterface)),
                entityType, name, type, listInterface);

        /// <summary>
        ///     The collection type '{2_collectionType}' being used for navigation '{1_entityType}.{0_navigation}' does not implement 'INotifyCollectionChanged'. Any entity type configured to use the '{changeTrackingStrategy}' change tracking strategy must use collections that implement 'INotifyCollectionChanged'. Consider using 'ObservableCollection&lt;T&gt;' for this.
        /// </summary>
        public static string NonNotifyingCollection(object? navigation, object? entityType, object? collectionType, object? changeTrackingStrategy)
            => string.Format(
                GetString("NonNotifyingCollection", "0_navigation", "1_entityType", "2_collectionType", nameof(changeTrackingStrategy)),
                navigation, entityType, collectionType, changeTrackingStrategy);

        /// <summary>
        ///     The LINQ expression '{expression}' could not be translated. Additional information: {details} See https://go.microsoft.com/fwlink/?linkid=2101038 for more information.
        /// </summary>
        public static string NonQueryTranslationFailedWithDetails(object? expression, object? details)
            => string.Format(
                GetString("NonQueryTranslationFailedWithDetails", nameof(expression), nameof(details)),
                expression, details);

        /// <summary>
        ///     The foreign key {foreignKeyProperties} on the entity type '{declaringEntityType}' cannot have a required dependent end since it is not unique.
        /// </summary>
        public static string NonUniqueRequiredDependentForeignKey(object? foreignKeyProperties, object? declaringEntityType)
            => string.Format(
                GetString("NonUniqueRequiredDependentForeignKey", nameof(foreignKeyProperties), nameof(declaringEntityType)),
                foreignKeyProperties, declaringEntityType);

        /// <summary>
        ///     '{principalEntityType}.{principalNavigation}' cannot be configured as required since it was configured as a collection.
        /// </summary>
        public static string NonUniqueRequiredDependentNavigation(object? principalEntityType, object? principalNavigation)
            => string.Format(
                GetString("NonUniqueRequiredDependentNavigation", nameof(principalEntityType), nameof(principalNavigation)),
                principalEntityType, principalNavigation);

        /// <summary>
        ///     A parameterless constructor was not found on entity type '{entityType}'. In order to create an instance of '{entityType}', Entity Framework requires that a parameterless constructor be declared.
        /// </summary>
        public static string NoParameterlessConstructor(object? entityType)
            => string.Format(
                GetString("NoParameterlessConstructor", nameof(entityType)),
                entityType);

        /// <summary>
        ///     No property was associated with field '{field}' of entity type '{entity}'. Either configure a property or use a different '{propertyAccessMode}'.
        /// </summary>
        public static string NoProperty(object? field, object? entity, object? propertyAccessMode)
            => string.Format(
                GetString("NoProperty", nameof(field), nameof(entity), nameof(propertyAccessMode)),
                field, entity, propertyAccessMode);

        /// <summary>
        ///     The property '{property}' cannot be added to the type '{type}' because no property type was specified and there is no corresponding CLR property or field. To add a shadow state property, the property type must be specified.
        /// </summary>
        public static string NoPropertyType(object? property, object? type)
            => string.Format(
                GetString("NoPropertyType", nameof(property), nameof(type)),
                property, type);

        /// <summary>
        ///     No database provider has been configured for this DbContext. A provider can be configured by overriding the 'DbContext.OnConfiguring' method or by using 'AddDbContext' on the application service provider. If 'AddDbContext' is used, then also ensure that your DbContext type accepts a DbContextOptions&lt;TContext&gt; object in its constructor and passes it to the base constructor for DbContext.
        /// </summary>
        public static string NoProviderConfigured
            => GetString("NoProviderConfigured");

        /// <summary>
        ///     Unable to resolve service for type '{service}'. This is often because no database provider has been configured for this DbContext. A provider can be configured by overriding the 'DbContext.OnConfiguring' method or by using 'AddDbContext' on the application service provider. If 'AddDbContext' is used, then also ensure that your DbContext type accepts a DbContextOptions&lt;TContext&gt; object in its constructor and passes it to the base constructor for DbContext.
        /// </summary>
        public static string NoProviderConfiguredFailedToResolveService(object? service)
            => string.Format(
                GetString("NoProviderConfiguredFailedToResolveService", nameof(service)),
                service);

        /// <summary>
        ///     An 'ExecuteUpdate' call must specify at least one 'SetProperty' invocation, to indicate the properties to be updated.
        /// </summary>
        public static string NoSetPropertyInvocation
            => GetString("NoSetPropertyInvocation");

        /// <summary>
        ///     The property '{1_entityType}.{0_property}' does not have a setter. Either make the property writable or use a different '{propertyAccessMode}'.
        /// </summary>
        public static string NoSetter(object? property, object? entityType, object? propertyAccessMode)
            => string.Format(
                GetString("NoSetter", "0_property", "1_entityType", nameof(propertyAccessMode)),
                property, entityType, propertyAccessMode);

        /// <summary>
        ///     The database provider attempted to register an implementation of the '{service}' service. This is not a service defined by Entity Framework and as such must be registered as a provider-specific service using the 'TryAddProviderSpecificServices' method.
        /// </summary>
        public static string NotAnEFService(object? service)
            => string.Format(
                GetString("NotAnEFService", nameof(service)),
                service);

        /// <summary>
        ///     The database provider attempted to register an implementation of the '{service}' service. This is a service defined by Entity Framework and as such must not be registered using the 'TryAddProviderSpecificServices' method.
        /// </summary>
        public static string NotAProviderService(object? service)
            => string.Format(
                GetString("NotAProviderService", nameof(service)),
                service);

        /// <summary>
        ///     The entity type '{entityType}' cannot inherit from '{baseEntityType}' because '{clrType}' is not a descendant of '{baseClrType}'.
        /// </summary>
        public static string NotAssignableClrBaseType(object? entityType, object? baseEntityType, object? clrType, object? baseClrType)
            => string.Format(
                GetString("NotAssignableClrBaseType", nameof(entityType), nameof(baseEntityType), nameof(clrType), nameof(baseClrType)),
                entityType, baseEntityType, clrType, baseClrType);

        /// <summary>
        ///     The property '{entityType}.{property}' cannot be mapped as a collection since it does not implement 'IEnumerable&lt;T&gt;'.
        /// </summary>
        public static string NotCollection(object? entityType, object? property)
            => string.Format(
                GetString("NotCollection", nameof(entityType), nameof(property)),
                entityType, property);

        /// <summary>
        ///     When precompiling queries, the '{parameter}' parameter of method '{method}' cannot be parameterized.
        /// </summary>
        public static string NotParameterizedAttributeWithNonConstantNotSupportedInPrecompiledQueries(object? parameter, object? method)
            => string.Format(
                GetString("NotParameterizedAttributeWithNonConstantNotSupportedInPrecompiledQueries", nameof(parameter), nameof(method)),
                parameter, method);

        /// <summary>
        ///     The given 'IQueryable' does not support generation of query strings.
        /// </summary>
        public static string NotQueryingEnumerable
            => GetString("NotQueryingEnumerable");

        /// <summary>
        ///     The property '{1_entityType}.{0_property}' does not have a value set and no value generator is available for properties of type '{propertyType}'. Either set a value for the property before adding the entity or configure a value generator for properties of type '{propertyType}' in 'OnModelCreating'.
        /// </summary>
        public static string NoValueGenerator(object? property, object? entityType, object? propertyType)
            => string.Format(
                GetString("NoValueGenerator", "0_property", "1_entityType", nameof(propertyType)),
                property, entityType, propertyType);

        /// <summary>
        ///     A key on entity type '{entityType}' cannot contain the property '{property}' because it is nullable/optional. All properties on which a key is declared must be marked as non-nullable/required.
        /// </summary>
        public static string NullableKey(object? entityType, object? property)
            => string.Format(
                GetString("NullableKey", nameof(entityType), nameof(property)),
                entityType, property);

        /// <summary>
        ///     The complex type property '{type}.{property}' is configured as required (non-nullable) but has a null value when saving changes.
        /// </summary>
        public static string NullRequiredComplexProperty(object? type, object? property)
            => string.Format(
                GetString("NullRequiredComplexProperty", nameof(type), nameof(property)),
                type, property);

        /// <summary>
        ///     The primitive collection property '{type}.{property}' is configured as required (non-nullable) but has a null value when saving changes. Either mark the property as optional (nullable) or set a non-null value.
        /// </summary>
        public static string NullRequiredPrimitiveCollection(object? type, object? property)
            => string.Format(
                GetString("NullRequiredPrimitiveCollection", nameof(type), nameof(property)),
                type, property);

        /// <summary>
        ///     The object '{name}' has been removed from the model.
        /// </summary>
        public static string ObjectRemovedFromModel(object? name)
            => string.Format(
                GetString("ObjectRemovedFromModel", nameof(name)),
                name);

        /// <summary>
        ///     Options extension of type '{optionsExtension}' not found.
        /// </summary>
        public static string OptionsExtensionNotFound(object? optionsExtension)
            => string.Format(
                GetString("OptionsExtensionNotFound", nameof(optionsExtension)),
                optionsExtension);

        /// <summary>
        ///     Original values are not stored for the property '{structuralType}.{property}'.
        /// </summary>
        public static string OriginalValueNotStored(object? structuralType, object? property)
            => string.Format(
                GetString("OriginalValueNotStored", nameof(structuralType), nameof(property)),
                structuralType, property);

        /// <summary>
        ///     The original value for property '{1_entityType}.{0_property}' cannot be accessed because it is not being tracked. Original values are not recorded for most properties of entities when the 'ChangingAndChangedNotifications' strategy is used. To access all original values, use a different change tracking strategy such as 'ChangingAndChangedNotificationsWithOriginalValues'.
        /// </summary>
        public static string OriginalValueNotTracked(object? property, object? entityType)
            => string.Format(
                GetString("OriginalValueNotTracked", "0_property", "1_entityType"),
                property, entityType);

        /// <summary>
        ///     The owned entity type '{entityType}' cannot have a base type. See https://aka.ms/efcore-docs-owned for more information.
        /// </summary>
        public static string OwnedDerivedType(object? entityType)
            => string.Format(
                GetString("OwnedDerivedType", nameof(entityType)),
                entityType);

        /// <summary>
        ///     A tracking query is attempting to project an owned entity without a corresponding owner in its result, but owned entities cannot be tracked without their owner. Either include the owner entity in the result or make the query non-tracking using 'AsNoTracking'.
        /// </summary>
        public static string OwnedEntitiesCannotBeTrackedWithoutTheirOwner
            => GetString("OwnedEntitiesCannotBeTrackedWithoutTheirOwner");

        /// <summary>
        ///     The entity type '{ownedType}' has been marked as owned and must be referenced from another entity type via a navigation. Add a navigation to an entity type that points at '{ownedType}' or don't configure it as owned.
        /// </summary>
        public static string OwnerlessOwnedType(object? ownedType)
            => string.Format(
                GetString("OwnerlessOwnedType", nameof(ownedType)),
                ownedType);

        /// <summary>
        ///     The navigation '{navigation}' cannot be changed, because the foreign key between '{principalEntityType}' and '{dependentEntityType}' is an ownership. To change the navigation to the owned entity type remove the ownership.
        /// </summary>
        public static string OwnershipToDependent(object? navigation, object? principalEntityType, object? dependentEntityType)
            => string.Format(
                GetString("OwnershipToDependent", nameof(navigation), nameof(principalEntityType), nameof(dependentEntityType)),
                navigation, principalEntityType, dependentEntityType);

        /// <summary>
        ///     The DbContext of type '{contextType}' cannot be pooled because it does not have a public constructor accepting a single parameter of type DbContextOptions or has more than one constructor.
        /// </summary>
        public static string PoolingContextCtorError(object? contextType)
            => string.Format(
                GetString("PoolingContextCtorError", nameof(contextType)),
                contextType);

        /// <summary>
        ///     'OnConfiguring' cannot be used to modify DbContextOptions when DbContext pooling is enabled.
        /// </summary>
        public static string PoolingOptionsModified
            => GetString("PoolingOptionsModified");

        /// <summary>
        ///     Precompiled queries aren't supported by the current provider.
        /// </summary>
        public static string PrecompiledQueryNotSupported
            => GetString("PrecompiledQueryNotSupported");

        /// <summary>
        ///     The derived type '{derivedType}' cannot have the [PrimaryKey] attribute since primary keys may only be declared on the root type. Move the attribute to '{rootType}', or remove '{rootType}' from the model by using [NotMapped] attribute or calling 'EntityTypeBuilder.Ignore' on the base type in 'OnModelCreating'.
        /// </summary>
        public static string PrimaryKeyAttributeOnDerivedEntity(object? derivedType, object? rootType)
            => string.Format(
                GetString("PrimaryKeyAttributeOnDerivedEntity", nameof(derivedType), nameof(rootType)),
                derivedType, rootType);

        /// <summary>
        ///     The [PrimaryKey] attribute on the entity type '{entityType}' is invalid because the property '{propertyName}' was marked as unmapped by [NotMapped] attribute or 'Ignore()' in 'OnModelCreating'. A primary key cannot use unmapped properties.
        /// </summary>
        public static string PrimaryKeyDefinedOnIgnoredProperty(object? entityType, object? propertyName)
            => string.Format(
                GetString("PrimaryKeyDefinedOnIgnoredProperty", nameof(entityType), nameof(propertyName)),
                entityType, propertyName);

        /// <summary>
        ///     The [PrimaryKey] attribute on the entity type '{entityType}' references properties {properties}, but no property with name '{propertyName}' exists on that entity type or any of its base types.
        /// </summary>
        public static string PrimaryKeyDefinedOnNonExistentProperty(object? entityType, object? properties, object? propertyName)
            => string.Format(
                GetString("PrimaryKeyDefinedOnNonExistentProperty", nameof(entityType), nameof(properties), nameof(propertyName)),
                entityType, properties, propertyName);

        /// <summary>
        ///     When creating the relationship between '{navigationSpecification1}' and '{navigationSpecification2}' the entity type '{targetEntityType}' cannot be set as principal.
        /// </summary>
        public static string PrincipalEndIncompatibleNavigations(object? navigationSpecification1, object? navigationSpecification2, object? targetEntityType)
            => string.Format(
                GetString("PrincipalEndIncompatibleNavigations", nameof(navigationSpecification1), nameof(navigationSpecification2), nameof(targetEntityType)),
                navigationSpecification1, navigationSpecification2, targetEntityType);

        /// <summary>
        ///     You are configuring a relationship between '{dependentEntityType}' and '{principalEntityType}', but have specified a principal key on '{entityType}'. The foreign key must target a type that is part of the relationship.
        /// </summary>
        public static string PrincipalEntityTypeNotInRelationship(object? dependentEntityType, object? principalEntityType, object? entityType)
            => string.Format(
                GetString("PrincipalEntityTypeNotInRelationship", nameof(dependentEntityType), nameof(principalEntityType), nameof(entityType)),
                dependentEntityType, principalEntityType, entityType);

        /// <summary>
        ///     The keyless entity type '{entityType}' cannot be on the principal end of the relationship between '{firstNavigationSpecification}' and '{secondNavigationSpecification}'. The principal entity type must have a key. For more information on keyless entity types, see https://go.microsoft.com/fwlink/?linkid=2141943.
        /// </summary>
        public static string PrincipalKeylessType(object? entityType, object? firstNavigationSpecification, object? secondNavigationSpecification)
            => string.Format(
                GetString("PrincipalKeylessType", nameof(entityType), nameof(firstNavigationSpecification), nameof(secondNavigationSpecification)),
                entityType, firstNavigationSpecification, secondNavigationSpecification);

        /// <summary>
        ///     The relationship from '{referencingEntityTypeOrNavigation}' to '{referencedEntityTypeOrNavigation}' is not supported because the owned entity type '{ownedType}' cannot be on the principal side of a non-ownership relationship. Remove the relationship or configure the foreign key to be on '{ownedType}'.
        /// </summary>
        public static string PrincipalOwnedType(object? referencingEntityTypeOrNavigation, object? referencedEntityTypeOrNavigation, object? ownedType)
            => string.Format(
                GetString("PrincipalOwnedType", nameof(referencingEntityTypeOrNavigation), nameof(referencedEntityTypeOrNavigation), nameof(ownedType)),
                referencingEntityTypeOrNavigation, referencedEntityTypeOrNavigation, ownedType);

        /// <summary>
        ///     The indexer property '{property}' cannot be added to the type '{type}' because the CLR type contains a member with the same name. Specify a different name or configure '{property}' as a non-indexer property.
        /// </summary>
        public static string PropertyClashingNonIndexer(object? property, object? type)
            => string.Format(
                GetString("PropertyClashingNonIndexer", nameof(property), nameof(type)),
                property, type);

        /// <summary>
        ///     The property '{1_entityType}.{0_property}' contains null, but the property is marked as required.  Consider using 'DbContextOptionsBuilder.EnableSensitiveDataLogging' to see the key values.
        /// </summary>
        public static string PropertyConceptualNull(object? property, object? entityType)
            => string.Format(
                GetString("PropertyConceptualNull", "0_property", "1_entityType"),
                property, entityType);

        /// <summary>
        ///     The property '{property}' contains null on entity '{entityType}' with the key value '{keyValue}', but the property is marked as required.
        /// </summary>
        public static string PropertyConceptualNullSensitive(object? property, object? entityType, object? keyValue)
            => string.Format(
                GetString("PropertyConceptualNullSensitive", nameof(property), nameof(entityType), nameof(keyValue)),
                property, entityType, keyValue);

        /// <summary>
        ///     The property '{property}' belongs to the type '{expectedType}', but is being used with an instance of type '{actualType}'.
        /// </summary>
        public static string PropertyDoesNotBelong(object? property, object? expectedType, object? actualType)
            => string.Format(
                GetString("PropertyDoesNotBelong", nameof(property), nameof(expectedType), nameof(actualType)),
                property, expectedType, actualType);

        /// <summary>
        ///     The property '{property}' cannot be removed from the type '{type}' because it is being used in the foreign key {foreignKeyProperties} on '{foreignKeyType}'. All containing foreign keys must be removed or redefined before the property can be removed.
        /// </summary>
        public static string PropertyInUseForeignKey(object? property, object? type, object? foreignKeyProperties, object? foreignKeyType)
            => string.Format(
                GetString("PropertyInUseForeignKey", nameof(property), nameof(type), nameof(foreignKeyProperties), nameof(foreignKeyType)),
                property, type, foreignKeyProperties, foreignKeyType);

        /// <summary>
        ///     The property '{property}' cannot be removed from the type '{entityType}' because it is being used in the index {index} on '{indexType}'. All containing indexes must be removed or redefined before the property can be removed.
        /// </summary>
        public static string PropertyInUseIndex(object? property, object? entityType, object? index, object? indexType)
            => string.Format(
                GetString("PropertyInUseIndex", nameof(property), nameof(entityType), nameof(index), nameof(indexType)),
                property, entityType, index, indexType);

        /// <summary>
        ///     The property '{property}' cannot be removed from the type '{entityType}' because it is being used in the key {keyProperties}. All containing keys must be removed or redefined before the property can be removed.
        /// </summary>
        public static string PropertyInUseKey(object? property, object? entityType, object? keyProperties)
            => string.Format(
                GetString("PropertyInUseKey", nameof(property), nameof(entityType), nameof(keyProperties)),
                property, entityType, keyProperties);

        /// <summary>
        ///     The property '{propertyName}' on entity type '{entityType}' is not a collection property and cannot be used with indexed collection accessors.
        /// </summary>
        public static string PropertyIsNotACollection(object? propertyName, object? entityType)
            => string.Format(
                GetString("PropertyIsNotACollection", nameof(propertyName), nameof(entityType)),
                propertyName, entityType);

        /// <summary>
        ///     The EF.Property&lt;T&gt; method may only be used within Entity Framework LINQ queries.
        /// </summary>
        public static string PropertyMethodInvoked
            => GetString("PropertyMethodInvoked");

        /// <summary>
        ///     The property '{entityType}.{property}' could not be mapped because it is of type '{propertyType}', which is not a supported primitive type or a valid entity type. Either explicitly map this property, or ignore it using the '[NotMapped]' attribute or by using 'EntityTypeBuilder.Ignore' in 'OnModelCreating'.
        /// </summary>
        public static string PropertyNotAdded(object? entityType, object? property, object? propertyType)
            => string.Format(
                GetString("PropertyNotAdded", nameof(entityType), nameof(property), nameof(propertyType)),
                entityType, property, propertyType);

        /// <summary>
        ///     The property '{entityType}.{property}' could not be mapped because it is of type '{propertyType}', which is not a supported primitive type or a valid entity type. The property can be ignored using the '[NotMapped]' attribute.
        /// </summary>
        public static string PropertyNotAddedAdHoc(object? entityType, object? property, object? propertyType)
            => string.Format(
                GetString("PropertyNotAddedAdHoc", nameof(entityType), nameof(property), nameof(propertyType)),
                entityType, property, propertyType);

        /// <summary>
        ///     The property '{1_entityType}.{0_property}' could not be found. Ensure that the property exists and has been included in the model.
        /// </summary>
        public static string PropertyNotFound(object? property, object? entityType)
            => string.Format(
                GetString("PropertyNotFound", "0_property", "1_entityType"),
                property, entityType);

        /// <summary>
        ///     The '{propertyType}' property '{entityType}.{property}' could not be mapped because the database provider does not support this type. Consider converting the property value to a type supported by the database using a value converter. See https://aka.ms/efcore-docs-value-converters for more information. Alternately, exclude the property from the model using the '[NotMapped]' attribute or by using 'EntityTypeBuilder.Ignore' in 'OnModelCreating'.
        /// </summary>
        public static string PropertyNotMapped(object? propertyType, object? entityType, object? property)
            => string.Format(
                GetString("PropertyNotMapped", nameof(propertyType), nameof(entityType), nameof(property)),
                propertyType, entityType, property);

        /// <summary>
        ///     The property '{1_entityType}.{0_property}' is defined as read-only after it has been saved, but its value has been modified or marked as modified.
        /// </summary>
        public static string PropertyReadOnlyAfterSave(object? property, object? entityType)
            => string.Format(
                GetString("PropertyReadOnlyAfterSave", "0_property", "1_entityType"),
                property, entityType);

        /// <summary>
        ///     The property '{1_entityType}.{0_property}' is defined as read-only before it has been saved, but its value has been set to something other than a temporary or default value.
        /// </summary>
        public static string PropertyReadOnlyBeforeSave(object? property, object? entityType)
            => string.Format(
                GetString("PropertyReadOnlyBeforeSave", "0_property", "1_entityType"),
                property, entityType);

        /// <summary>
        ///     The property '{property}' cannot be added to the type '{type}' because the type of the corresponding CLR property or field '{clrType}' does not match the specified type '{propertyType}'.
        /// </summary>
        public static string PropertyWrongClrType(object? property, object? type, object? clrType, object? propertyType)
            => string.Format(
                GetString("PropertyWrongClrType", nameof(property), nameof(type), nameof(clrType), nameof(propertyType)),
                property, type, clrType, propertyType);

        /// <summary>
        ///     The property '{property}' cannot be added to the type '{type}' because it is declared on the CLR type '{clrType}'.
        /// </summary>
        public static string PropertyWrongEntityClrType(object? property, object? type, object? clrType)
            => string.Format(
                GetString("PropertyWrongEntityClrType", nameof(property), nameof(type), nameof(clrType)),
                property, type, clrType);

        /// <summary>
        ///     The property '{property}' cannot be added to the type '{type}' because it doesn't match the name of the provided CLR property or field '{clrName}'. Use the same name or specify a different CLR member.
        /// </summary>
        public static string PropertyWrongName(object? property, object? type, object? clrName)
            => string.Format(
                GetString("PropertyWrongName", nameof(property), nameof(type), nameof(clrName)),
                property, type, clrName);

        /// <summary>
        ///     The property '{property}' cannot be removed from the type '{type}' because it is declared on the '{otherType}' type.
        /// </summary>
        public static string PropertyWrongType(object? property, object? type, object? otherType)
            => string.Format(
                GetString("PropertyWrongType", nameof(property), nameof(type), nameof(otherType)),
                property, type, otherType);

        /// <summary>
        ///     The materialization condition passed for entity shaper of entity type '{entityType}' is not of the correct shape. A materialization condition must be a 'LambdaExpression' of 'Func&lt;ValueBuffer, IEntityType&gt;'.
        /// </summary>
        public static string QueryEntityMaterializationConditionWrongShape(object? entityType)
            => string.Format(
                GetString("QueryEntityMaterializationConditionWrongShape", nameof(entityType)),
                entityType);

        /// <summary>
        ///     The query contains a projection '{projection}' of type '{queryableType}'. Collections in the final projection must be an 'IEnumerable&lt;T&gt;' type such as 'List&lt;T&gt;'. Consider using 'ToList' or some other mechanism to convert the 'IQueryable&lt;T&gt;' or 'IOrderedEnumerable&lt;T&gt;' into an 'IEnumerable&lt;T&gt;'.
        /// </summary>
        public static string QueryInvalidMaterializationType(object? projection, object? queryableType)
            => string.Format(
                GetString("QueryInvalidMaterializationType", nameof(projection), nameof(queryableType)),
                projection, queryableType);

        /// <summary>
        ///     Query wasn't precompiled and dynamic code isn't supported with NativeAOT.
        /// </summary>
        public static string QueryNotPrecompiled
            => GetString("QueryNotPrecompiled");

        /// <summary>
        ///     The replacement entity type: {entityType} does not have same name and CLR type as entity type this query root represents.
        /// </summary>
        public static string QueryRootDifferentEntityType(object? entityType)
            => string.Format(
                GetString("QueryRootDifferentEntityType", nameof(entityType)),
                entityType);

        /// <summary>
        ///     Translation of 'Select' which contains grouping parameter without composition is not supported.
        /// </summary>
        public static string QuerySelectContainsGrouping
            => GetString("QuerySelectContainsGrouping");

        /// <summary>
        ///     Translation of '{expression}' failed. Either the query source is not an entity type, or the specified property does not exist on the entity type.
        /// </summary>
        public static string QueryUnableToTranslateEFProperty(object? expression)
            => string.Format(
                GetString("QueryUnableToTranslateEFProperty", nameof(expression)),
                expression);

        /// <summary>
        ///     Translation of member '{member}' on entity type '{entityType}' failed. This commonly occurs when the specified member is unmapped.
        /// </summary>
        public static string QueryUnableToTranslateMember(object? member, object? entityType)
            => string.Format(
                GetString("QueryUnableToTranslateMember", nameof(member), nameof(entityType)),
                member, entityType);

        /// <summary>
        ///     Translation of method '{declaringTypeName}.{methodName}' failed. If this method can be mapped to your custom function, see https://go.microsoft.com/fwlink/?linkid=2132413 for more information.
        /// </summary>
        public static string QueryUnableToTranslateMethod(object? declaringTypeName, object? methodName)
            => string.Format(
                GetString("QueryUnableToTranslateMethod", nameof(declaringTypeName), nameof(methodName)),
                declaringTypeName, methodName);

        /// <summary>
        ///     Translation of the 'string.Equals' overload with a 'StringComparison' parameter is not supported. See https://go.microsoft.com/fwlink/?linkid=2129535 for more information.
        /// </summary>
        public static string QueryUnableToTranslateStringEqualsWithStringComparison
            => GetString("QueryUnableToTranslateStringEqualsWithStringComparison");

        /// <summary>
        ///     Query root of type '{type}' wasn't handled by provider code. This issue happens when using a provider specific method on a different provider where it is not supported.
        /// </summary>
        public static string QueryUnhandledQueryRootExpression(object? type)
            => string.Format(
                GetString("QueryUnhandledQueryRootExpression", nameof(type)),
                type);

        /// <summary>
        ///     An attempt was made to use the context instance while it is being configured. A DbContext instance cannot be used inside 'OnConfiguring' since it is still being configured at this point. This can happen if a second operation is started on this context instance before a previous operation completed. Any instance members are not guaranteed to be thread safe.
        /// </summary>
        public static string RecursiveOnConfiguring
            => GetString("RecursiveOnConfiguring");

        /// <summary>
        ///     An attempt was made to use the model while it was being created. A DbContext instance cannot be used inside 'OnModelCreating' in any way that makes use of the model that is being created.
        /// </summary>
        public static string RecursiveOnModelCreating
            => GetString("RecursiveOnModelCreating");

        /// <summary>
        ///     The relationship from '{referencingEntityTypeOrNavigation}' to '{referencedEntityTypeOrNavigation}' with foreign key properties {foreignKeyPropertiesWithTypes} cannot target the primary key {primaryKeyPropertiesWithTypes} because it is not compatible. Configure a principal key or a set of foreign key properties with compatible types for this relationship.
        /// </summary>
        public static string ReferencedShadowKey(object? referencingEntityTypeOrNavigation, object? referencedEntityTypeOrNavigation, object? foreignKeyPropertiesWithTypes, object? primaryKeyPropertiesWithTypes)
            => string.Format(
                GetString("ReferencedShadowKey", nameof(referencingEntityTypeOrNavigation), nameof(referencedEntityTypeOrNavigation), nameof(foreignKeyPropertiesWithTypes), nameof(primaryKeyPropertiesWithTypes)),
                referencingEntityTypeOrNavigation, referencedEntityTypeOrNavigation, foreignKeyPropertiesWithTypes, primaryKeyPropertiesWithTypes);

        /// <summary>
        ///     The property '{1_entityType}.{0_property}' is being accessed using the '{referenceMethod}' method, but is defined in the model as a collection navigation. Use the '{collectionMethod}' method to access collection navigations.
        /// </summary>
        public static string ReferenceIsCollection(object? property, object? entityType, object? referenceMethod, object? collectionMethod)
            => string.Format(
                GetString("ReferenceIsCollection", "0_property", "1_entityType", nameof(referenceMethod), nameof(collectionMethod)),
                property, entityType, referenceMethod, collectionMethod);

        /// <summary>
        ///     The navigation '{1_entityType}.{0_navigation}' cannot have 'IsLoaded' set to false because the referenced entity is non-null and is therefore loaded.
        /// </summary>
        public static string ReferenceMustBeLoaded(object? navigation, object? entityType)
            => string.Format(
                GetString("ReferenceMustBeLoaded", "0_navigation", "1_entityType"),
                navigation, entityType);

        /// <summary>
        ///     The principal and dependent ends of the relationship cannot be changed once foreign key or principal key properties have been specified. Remove the conflicting configuration.
        /// </summary>
        public static string RelationshipCannotBeInverted
            => GetString("RelationshipCannotBeInverted");

        /// <summary>
        ///     The association between entity types '{firstType}' and '{secondType}' has been severed, but the relationship is either marked as required or is implicitly required because the foreign key is not nullable. If the dependent/child entity should be deleted when a required relationship is severed, configure the relationship to use cascade deletes. Consider using 'DbContextOptionsBuilder.EnableSensitiveDataLogging' to see the key values.
        /// </summary>
        public static string RelationshipConceptualNull(object? firstType, object? secondType)
            => string.Format(
                GetString("RelationshipConceptualNull", nameof(firstType), nameof(secondType)),
                firstType, secondType);

        /// <summary>
        ///     The association between entities '{firstType}' and '{secondType}' with the key value '{secondKeyValue}' has been severed, but the relationship is either marked as required or is implicitly required because the foreign key is not nullable. If the dependent/child entity should be deleted when a required relationship is severed, configure the relationship to use cascade deletes.
        /// </summary>
        public static string RelationshipConceptualNullSensitive(object? firstType, object? secondType, object? secondKeyValue)
            => string.Format(
                GetString("RelationshipConceptualNullSensitive", nameof(firstType), nameof(secondType), nameof(secondKeyValue)),
                firstType, secondType, secondKeyValue);

        /// <summary>
        ///     A relationship cycle involving the property '{entityType}.{property}' was detected. This prevents Entity Framework from determining the correct configuration. Review the foreign keys defined on the property and the corresponding principal property and either remove one of them or specify '{configuration}' explicitly on one of the properties.
        /// </summary>
        public static string RelationshipCycle(object? entityType, object? property, object? configuration)
            => string.Format(
                GetString("RelationshipCycle", nameof(entityType), nameof(property), nameof(configuration)),
                entityType, property, configuration);

        /// <summary>
        ///     '{entityType}.{navigation}' cannot be configured as required since it represents a skip navigation.
        /// </summary>
        public static string RequiredSkipNavigation(object? entityType, object? navigation)
            => string.Format(
                GetString("RequiredSkipNavigation", nameof(entityType), nameof(navigation)),
                entityType, navigation);

        /// <summary>
        ///     'ObservableCollection&lt;T&gt;.Clear' is not supported because it uses the 'INotifyCollectionChanged' 'Reset' operation, which does not supply the items removed. Either use multiple calls to 'Remove', or use a notifying collection that supports 'Clear', such as 'Microsoft.EntityFrameworkCore.ChangeTracking.ObservableHashSet&lt;T&gt;'.
        /// </summary>
        public static string ResetNotSupported
            => GetString("ResetNotSupported");

        /// <summary>
        ///     The maximum number of retries ({retryLimit}) was exceeded while executing database operations with '{strategy}'. See the inner exception for the most recent failure.
        /// </summary>
        public static string RetryLimitExceeded(object? retryLimit, object? strategy)
            => string.Format(
                GetString("RetryLimitExceeded", nameof(retryLimit), nameof(strategy)),
                retryLimit, strategy);

        /// <summary>
        ///     The requested configuration is not stored in the read-optimized model, please use 'DbContext.GetService&lt;IDesignTimeModel&gt;().Model'.
        /// </summary>
        public static string RuntimeModelMissingData
            => GetString("RuntimeModelMissingData");

        /// <summary>
        ///     While registering a runtime parameter, the lambda expression must have only one parameter which must be same as 'QueryCompilationContext.QueryContextParameter' expression.
        /// </summary>
        public static string RuntimeParameterMissingParameter
            => GetString("RuntimeParameterMissingParameter");

        /// <summary>
        ///     The same parameter instance with name '{parameterName}' was used in multiple lambdas in the query tree. Each lambda must have its own parameter instances.
        /// </summary>
        public static string SameParameterInstanceUsedInMultipleLambdas(object? parameterName)
            => string.Format(
                GetString("SameParameterInstanceUsedInMultipleLambdas", nameof(parameterName)),
                parameterName);

        /// <summary>
        ///     Cannot save instance of '{entityType}' because it is an owned entity without any reference to its owner. Owned entities can only be saved as part of an aggregate also including the owner entity.
        /// </summary>
        public static string SaveOwnedWithoutOwner(object? entityType)
            => string.Format(
                GetString("SaveOwnedWithoutOwner", nameof(entityType)),
                entityType);

        /// <summary>
        ///     Savepoints are not supported by the database provider in use.
        /// </summary>
        public static string SavepointsNotSupported
            => GetString("SavepointsNotSupported");

        /// <summary>
        ///     The seed entity for entity type '{entityType}' cannot be added because it has the complex property '{property}' set. Complex properties are currently not supported in seeding. See https://github.com/dotnet/efcore/issues/31254 for more information. Consider using 'DbContextOptionsBuilder.EnableSensitiveDataLogging' to see the involved property values.
        /// </summary>
        public static string SeedDatumComplexProperty(object? entityType, object? property)
            => string.Format(
                GetString("SeedDatumComplexProperty", nameof(entityType), nameof(property)),
                entityType, property);

        /// <summary>
        ///     The seed entity for entity type '{entityType}' with the key value '{keyValue}' cannot be added because it has the complex property '{property}' set. Complex properties are currently not supported in seeding. See https://github.com/dotnet/efcore/issues/31254 for more information.
        /// </summary>
        public static string SeedDatumComplexPropertySensitive(object? entityType, object? keyValue, object? property)
            => string.Format(
                GetString("SeedDatumComplexPropertySensitive", nameof(entityType), nameof(keyValue), nameof(property)),
                entityType, keyValue, property);

        /// <summary>
        ///     The seed entity for entity type '{entityType}' cannot be added because a default value was provided for the required property '{property}'. Please provide a value different from '{defaultValue}'.
        /// </summary>
        public static string SeedDatumDefaultValue(object? entityType, object? property, object? defaultValue)
            => string.Format(
                GetString("SeedDatumDefaultValue", nameof(entityType), nameof(property), nameof(defaultValue)),
                entityType, property, defaultValue);

        /// <summary>
        ///     The seed entity for entity type '{entityType}' cannot be added because the value provided is of a derived type '{derivedType}'. Add the derived seed entities to the corresponding entity type.
        /// </summary>
        public static string SeedDatumDerivedType(object? entityType, object? derivedType)
            => string.Format(
                GetString("SeedDatumDerivedType", nameof(entityType), nameof(derivedType)),
                entityType, derivedType);

        /// <summary>
        ///     The seed entity for entity type '{entityType}' cannot be added because another seed entity with the same key value for {keyProperties} has already been added. Consider using 'DbContextOptionsBuilder.EnableSensitiveDataLogging' to see the conflicting key values.
        /// </summary>
        public static string SeedDatumDuplicate(object? entityType, object? keyProperties)
            => string.Format(
                GetString("SeedDatumDuplicate", nameof(entityType), nameof(keyProperties)),
                entityType, keyProperties);

        /// <summary>
        ///     The seed entity for entity type '{entityType}' cannot be added because another seed entity with the key value '{keyValue}' has already been added.
        /// </summary>
        public static string SeedDatumDuplicateSensitive(object? entityType, object? keyValue)
            => string.Format(
                GetString("SeedDatumDuplicateSensitive", nameof(entityType), nameof(keyValue)),
                entityType, keyValue);

        /// <summary>
        ///     The seed entity for entity type '{entityType}' cannot be added because the value provided for the property '{property}' is not compatible with the property type '{type}'. Consider using 'DbContextOptionsBuilder.EnableSensitiveDataLogging' to see the involved property value.
        /// </summary>
        public static string SeedDatumIncompatibleValue(object? entityType, object? property, object? type)
            => string.Format(
                GetString("SeedDatumIncompatibleValue", nameof(entityType), nameof(property), nameof(type)),
                entityType, property, type);

        /// <summary>
        ///     The seed entity for entity type '{entityType}' cannot be added because the value '{value}' provided for the property '{property}' is not compatible with the property type '{type}'.
        /// </summary>
        public static string SeedDatumIncompatibleValueSensitive(object? entityType, object? value, object? property, object? type)
            => string.Format(
                GetString("SeedDatumIncompatibleValueSensitive", nameof(entityType), nameof(value), nameof(property), nameof(type)),
                entityType, value, property, type);

        /// <summary>
        ///     The seed entity for entity type '{entityType}' cannot be added because no value was provided for the required property '{property}'.
        /// </summary>
        public static string SeedDatumMissingValue(object? entityType, object? property)
            => string.Format(
                GetString("SeedDatumMissingValue", nameof(entityType), nameof(property)),
                entityType, property);

        /// <summary>
        ///     The seed entity for entity type '{entityType}' cannot be added because it has the navigation '{navigation}' set. To seed relationships,  add the entity seed to '{relatedEntityType}' and specify the foreign key values {foreignKeyProperties}. Consider using 'DbContextOptionsBuilder.EnableSensitiveDataLogging' to see the involved property values.
        /// </summary>
        public static string SeedDatumNavigation(object? entityType, object? navigation, object? relatedEntityType, object? foreignKeyProperties)
            => string.Format(
                GetString("SeedDatumNavigation", nameof(entityType), nameof(navigation), nameof(relatedEntityType), nameof(foreignKeyProperties)),
                entityType, navigation, relatedEntityType, foreignKeyProperties);

        /// <summary>
        ///     The seed entity for entity type '{entityType}' with the key value '{keyValue}' cannot be added because it has the navigation '{navigation}' set. To seed relationships, add the entity seed to '{relatedEntityType}' and specify the foreign key values {foreignKeyProperties}.
        /// </summary>
        public static string SeedDatumNavigationSensitive(object? entityType, object? keyValue, object? navigation, object? relatedEntityType, object? foreignKeyProperties)
            => string.Format(
                GetString("SeedDatumNavigationSensitive", nameof(entityType), nameof(keyValue), nameof(navigation), nameof(relatedEntityType), nameof(foreignKeyProperties)),
                entityType, keyValue, navigation, relatedEntityType, foreignKeyProperties);

        /// <summary>
        ///     The seed entity for entity type '{entityType}' cannot be added because a non-zero value is required for property '{property}'. Consider providing a negative value to avoid collisions with non-seed data.
        /// </summary>
        public static string SeedDatumSignedNumericValue(object? entityType, object? property)
            => string.Format(
                GetString("SeedDatumSignedNumericValue", nameof(entityType), nameof(property)),
                entityType, property);

        /// <summary>
        ///     The seed entity for entity type '{entityType}' cannot be added because keyless entity types are not supported. Consider providing a key or removing the seed data.
        /// </summary>
        public static string SeedKeylessEntity(object? entityType)
            => string.Format(
                GetString("SeedKeylessEntity", nameof(entityType)),
                entityType);

        /// <summary>
        ///     The inverse for the navigation '{entityType}.{property}' cannot be the same navigation. Change the value in the [InverseProperty] attribute to a different navigation.
        /// </summary>
        public static string SelfReferencingNavigationWithInverseProperty(object? entityType, object? property)
            => string.Format(
                GetString("SelfReferencingNavigationWithInverseProperty", nameof(entityType), nameof(property)),
                entityType, property);

        /// <summary>
        ///     To show additional information call 'DbContextOptionsBuilder.EnableSensitiveDataLogging'.
        /// </summary>
        public static string SensitiveDataDisabled
            => GetString("SensitiveDataDisabled");

        /// <summary>
        ///     Sequence contains more than one element.
        /// </summary>
        public static string SequenceContainsMoreThanOneElement
            => GetString("SequenceContainsMoreThanOneElement");

        /// <summary>
        ///     Sequence contains no elements.
        /// </summary>
        public static string SequenceContainsNoElements
            => GetString("SequenceContainsNoElements");

        /// <summary>
        ///     configuration added for '{key}'
        /// </summary>
        public static string ServiceProviderConfigAdded(object? key)
            => string.Format(
                GetString("ServiceProviderConfigAdded", nameof(key)),
                key);

        /// <summary>
        ///     configuration changed for '{key}'
        /// </summary>
        public static string ServiceProviderConfigChanged(object? key)
            => string.Format(
                GetString("ServiceProviderConfigChanged", nameof(key)),
                key);

        /// <summary>
        ///     configuration removed for '{key}'
        /// </summary>
        public static string ServiceProviderConfigRemoved(object? key)
            => string.Format(
                GetString("ServiceProviderConfigRemoved", nameof(key)),
                key);

        /// <summary>
        ///     Unable to translate set operation since both operands have different 'Include' operations. Consider having same 'Include' applied on both sides.
        /// </summary>
        public static string SetOperationWithDifferentIncludesInOperands
            => GetString("SetOperationWithDifferentIncludesInOperands");

        /// <summary>
        ///     The shared-type entity type '{entityType}' cannot have a base type.
        /// </summary>
        public static string SharedTypeDerivedType(object? entityType)
            => string.Format(
                GetString("SharedTypeDerivedType", nameof(entityType)),
                entityType);

        /// <summary>
        ///     A call was made to '{optionCall}' that changed an option that must be constant within a service provider, but Entity Framework is not building its own internal service provider. Either allow Entity Framework to build the service provider by removing the call to '{useInternalServiceProvider}', or ensure that the configuration for '{optionCall}' does not change for all uses of a given service provider passed to '{useInternalServiceProvider}'.
        /// </summary>
        public static string SingletonOptionChanged(object? optionCall, object? useInternalServiceProvider)
            => string.Format(
                GetString("SingletonOptionChanged", nameof(optionCall), nameof(useInternalServiceProvider)),
                optionCall, useInternalServiceProvider);

        /// <summary>
        ///     An attempt was made to register an instance for the '{scope}' service '{service}'. Instances can only be registered for 'Singleton' services.
        /// </summary>
        public static string SingletonRequired(object? scope, object? service)
            => string.Format(
                GetString("SingletonRequired", nameof(scope), nameof(service)),
                scope, service);

        /// <summary>
        ///     The foreign key {foreignKeyProperties} cannot be set for the skip navigation '{navigation}' as it uses the join entity type '{joinType}' while the inverse skip navigation '{inverse}' is associated with a foreign key using the join entity type '{inverseJoinType}'. The inverse navigation must use the same join entity type.
        /// </summary>
        public static string SkipInverseMismatchedForeignKey(object? foreignKeyProperties, object? navigation, object? joinType, object? inverse, object? inverseJoinType)
            => string.Format(
                GetString("SkipInverseMismatchedForeignKey", nameof(foreignKeyProperties), nameof(navigation), nameof(joinType), nameof(inverse), nameof(inverseJoinType)),
                foreignKeyProperties, navigation, joinType, inverse, inverseJoinType);

        /// <summary>
        ///     The skip navigation '{inverse}' using the join entity type '{inverseJoinType}' cannot be set as the inverse of '{navigation}', which uses the join entity type '{joinType}'. The inverse navigation must use the same join entity type.
        /// </summary>
        public static string SkipInverseMismatchedJoinType(object? inverse, object? inverseJoinType, object? navigation, object? joinType)
            => string.Format(
                GetString("SkipInverseMismatchedJoinType", nameof(inverse), nameof(inverseJoinType), nameof(navigation), nameof(joinType)),
                inverse, inverseJoinType, navigation, joinType);

        /// <summary>
        ///     The foreign key {foreignKeyProperties} cannot be used for the skip navigation '{entityType}.{navigation}' because it is declared on the entity type '{dependentEntityType}', but a foreign key on '{entityType}' is expected.
        /// </summary>
        public static string SkipNavigationForeignKeyWrongDependentType(object? foreignKeyProperties, object? entityType, object? navigation, object? dependentEntityType)
            => string.Format(
                GetString("SkipNavigationForeignKeyWrongDependentType", nameof(foreignKeyProperties), nameof(entityType), nameof(navigation), nameof(dependentEntityType)),
                foreignKeyProperties, entityType, navigation, dependentEntityType);

        /// <summary>
        ///     The foreign key {foreignKeyProperties} cannot be used for the skip navigation '{entityType}.{navigation}' because it is declared on the entity type '{entityType}', but a foreign key on '{principalEntityType}' is expected.
        /// </summary>
        public static string SkipNavigationForeignKeyWrongPrincipalType(object? foreignKeyProperties, object? entityType, object? navigation, object? principalEntityType)
            => string.Format(
                GetString("SkipNavigationForeignKeyWrongPrincipalType", nameof(foreignKeyProperties), nameof(entityType), nameof(navigation), nameof(principalEntityType)),
                foreignKeyProperties, entityType, navigation, principalEntityType);

        /// <summary>
        ///     The skip navigation '{entityType}.{skipNavigation}' cannot be removed because it is configured as the inverse of the skip navigation '{referencingEntityType}.{inverseSkipNavigation}'. All referencing skip navigations must be removed before this skip navigation can be removed.
        /// </summary>
        public static string SkipNavigationInUseBySkipNavigation(object? entityType, object? skipNavigation, object? referencingEntityType, object? inverseSkipNavigation)
            => string.Format(
                GetString("SkipNavigationInUseBySkipNavigation", nameof(entityType), nameof(skipNavigation), nameof(referencingEntityType), nameof(inverseSkipNavigation)),
                entityType, skipNavigation, referencingEntityType, inverseSkipNavigation);

        /// <summary>
        ///     The skip navigation '{1_entityType}.{0_navigation}' doesn't have a foreign key associated with it. Every skip navigation must have a configured foreign key.
        /// </summary>
        public static string SkipNavigationNoForeignKey(object? navigation, object? entityType)
            => string.Format(
                GetString("SkipNavigationNoForeignKey", "0_navigation", "1_entityType"),
                navigation, entityType);

        /// <summary>
        ///     The skip navigation '{1_entityType}.{0_navigation}' doesn't have an inverse navigation configured. Every skip navigation should have an inverse skip navigation.
        /// </summary>
        public static string SkipNavigationNoInverse(object? navigation, object? entityType)
            => string.Format(
                GetString("SkipNavigationNoInverse", "0_navigation", "1_entityType"),
                navigation, entityType);

        /// <summary>
        ///     The skip navigation '{1_entityType}.{0_navigation}' is not a collection. Only collection skip navigations are currently supported.
        /// </summary>
        public static string SkipNavigationNonCollection(object? navigation, object? entityType)
            => string.Format(
                GetString("SkipNavigationNonCollection", "0_navigation", "1_entityType"),
                navigation, entityType);

        /// <summary>
        ///     The skip navigation '{inverse}' declared on the entity type '{inverseEntityType}' cannot be set as the inverse of '{navigation}', which targets '{targetEntityType}'. The inverse navigation should be declared on the target entity type.
        /// </summary>
        public static string SkipNavigationWrongInverse(object? inverse, object? inverseEntityType, object? navigation, object? targetEntityType)
            => string.Format(
                GetString("SkipNavigationWrongInverse", nameof(inverse), nameof(inverseEntityType), nameof(navigation), nameof(targetEntityType)),
                inverse, inverseEntityType, navigation, targetEntityType);

        /// <summary>
        ///     The skip navigation '{navigation}' cannot be removed from the entity type '{entityType}' because it is defined on the entity type '{otherEntityType}'.
        /// </summary>
        public static string SkipNavigationWrongType(object? navigation, object? entityType, object? otherEntityType)
            => string.Format(
                GetString("SkipNavigationWrongType", nameof(navigation), nameof(entityType), nameof(otherEntityType)),
                navigation, entityType, otherEntityType);

        /// <summary>
        ///     The property '{1_entityType}.{0_property}' cannot be assigned a value generated by the database. Store-generated values can only be assigned to properties configured to use store-generated values.
        /// </summary>
        public static string StoreGenValue(object? property, object? entityType)
            => string.Format(
                GetString("StoreGenValue", "0_property", "1_entityType"),
                property, entityType);

        /// <summary>
        ///     The property '{1_entityType}.{0_property}' cannot be assigned a temporary value. Temporary values can only be assigned to properties configured to use store-generated values.
        /// </summary>
        public static string TempValue(object? property, object? entityType)
            => string.Format(
                GetString("TempValue", "0_property", "1_entityType"),
                property, entityType);

        /// <summary>
        ///     The property '{1_entityType}.{0_property}' has a temporary value while attempting to change the entity's state to '{state}'. Either set a permanent value explicitly, or ensure that the database is configured to generate values for this property.
        /// </summary>
        public static string TempValuePersists(object? property, object? entityType, object? state)
            => string.Format(
                GetString("TempValuePersists", "0_property", "1_entityType", nameof(state)),
                property, entityType, state);

        /// <summary>
        ///     The instance of entity type '{runtimeEntityType}' cannot be tracked as the entity type '{entityType}' because the two types are not in the same hierarchy.
        /// </summary>
        public static string TrackingTypeMismatch(object? runtimeEntityType, object? entityType)
            => string.Format(
                GetString("TrackingTypeMismatch", nameof(runtimeEntityType), nameof(entityType)),
                runtimeEntityType, entityType);

        /// <summary>
        ///     The current provider doesn't support System.Transaction.
        /// </summary>
        public static string TransactionsNotSupported
            => GetString("TransactionsNotSupported");

        /// <summary>
        ///     The LINQ expression '{expression}' could not be translated. Either rewrite the query in a form that can be translated, or switch to client evaluation explicitly by inserting a call to 'AsEnumerable', 'AsAsyncEnumerable', 'ToList', or 'ToListAsync'. See https://go.microsoft.com/fwlink/?linkid=2101038 for more information.
        /// </summary>
        public static string TranslationFailed(object? expression)
            => string.Format(
                GetString("TranslationFailed", nameof(expression)),
                expression);

        /// <summary>
        ///     The LINQ expression '{expression}' could not be translated. Additional information: {details} Either rewrite the query in a form that can be translated, or switch to client evaluation explicitly by inserting a call to 'AsEnumerable', 'AsAsyncEnumerable', 'ToList', or 'ToListAsync'. See https://go.microsoft.com/fwlink/?linkid=2101038 for more information.
        /// </summary>
        public static string TranslationFailedWithDetails(object? expression, object? details)
            => string.Format(
                GetString("TranslationFailedWithDetails", nameof(expression), nameof(details)),
                expression, details);

        /// <summary>
        ///     The type '{type}' has been configured as '{typeConfiguration}', this conflicts with type '{otherType}' configured as '{otherTypeConfiguration}'. All base types and implemented interfaces must have the same configuration type.
        /// </summary>
        public static string TypeConfigurationConflict(object? type, object? typeConfiguration, object? otherType, object? otherTypeConfiguration)
            => string.Format(
                GetString("TypeConfigurationConflict", nameof(type), nameof(typeConfiguration), nameof(otherType), nameof(otherTypeConfiguration)),
                type, typeConfiguration, otherType, otherTypeConfiguration);

        /// <summary>
        ///     The type '{type}' has not been configured as a shared type in the model. Before calling 'UsingEntity' add the entity type in the model as a shared entity.
        /// </summary>
        public static string TypeNotMarkedAsShared(object? type)
            => string.Format(
                GetString("TypeNotMarkedAsShared", nameof(type)),
                type);

        /// <summary>
        ///     Unable to materialize entity instance of type '{entityType}'. No discriminators matched the discriminator value '{discriminator}'.
        /// </summary>
        public static string UnableToDiscriminate(object? entityType, object? discriminator)
            => string.Format(
                GetString("UnableToDiscriminate", nameof(entityType), nameof(discriminator)),
                entityType, discriminator);

        /// <summary>
        ///     Unable to set 'IsUnique' to '{isUnique}' on the relationship associated with the navigation '{2_entityType}.{1_navigationName}' because the navigation has the opposite multiplicity.
        /// </summary>
        public static string UnableToSetIsUnique(object? isUnique, object? navigationName, object? entityType)
            => string.Format(
                GetString("UnableToSetIsUnique", nameof(isUnique), "1_navigationName", "2_entityType"),
                isUnique, navigationName, entityType);

        /// <summary>
        ///     The type '{type}' cannot be configured as '{configuration}' since model building assumes that it is configured as '{expectedConfiguration}'. Remove the unsupported configuration for '{configurationType}'.
        /// </summary>
        public static string UnconfigurableType(object? type, object? configuration, object? expectedConfiguration, object? configurationType)
            => string.Format(
                GetString("UnconfigurableType", nameof(type), nameof(configuration), nameof(expectedConfiguration), nameof(configurationType)),
                type, configuration, expectedConfiguration, configurationType);

        /// <summary>
        ///     Default type mapping cannot be configured for the type '{type}' since it's not a valid scalar type. Remove the unsupported configuration.
        /// </summary>
        public static string UnconfigurableTypeMapping(object? type)
            => string.Format(
                GetString("UnconfigurableTypeMapping", nameof(type)),
                type);

        /// <summary>
        ///     Unhandled expression node type '{nodeType}'.
        /// </summary>
        public static string UnhandledExpressionNode(object? nodeType)
            => string.Format(
                GetString("UnhandledExpressionNode", nameof(nodeType)),
                nodeType);

        /// <summary>
        ///     Unhandled member binding type '{bindingType}'.
        /// </summary>
        public static string UnhandledMemberBinding(object? bindingType)
            => string.Format(
                GetString("UnhandledMemberBinding", nameof(bindingType)),
                bindingType);

        /// <summary>
        ///     Unhandled 'INavigationBase' of type '{type}'.
        /// </summary>
        public static string UnhandledNavigationBase(object? type)
            => string.Format(
                GetString("UnhandledNavigationBase", nameof(type)),
                type);

        /// <summary>
        ///     Unhandled {entity} encountered.
        /// </summary>
        public static string UnknownEntity(object? entity)
            => string.Format(
                GetString("UnknownEntity", nameof(entity)),
                entity);

        /// <summary>
        ///     The value of '{entityType}.{property}' is unknown when attempting to save changes. This is because the property is also part of a foreign key for which the principal entity in the relationship is not known.
        /// </summary>
        public static string UnknownKeyValue(object? entityType, object? property)
            => string.Format(
                GetString("UnknownKeyValue", nameof(entityType), nameof(property)),
                entityType, property);

        /// <summary>
        ///     The value of shadow key property '{entityType}.{property}' is unknown when attempting to save changes. This is because shadow property values cannot be preserved when the entity is not being tracked. Consider adding the property to the entity's .NET type. See https://aka.ms/efcore-docs-owned-collections for more information.
        /// </summary>
        public static string UnknownShadowKeyValue(object? entityType, object? property)
            => string.Format(
                GetString("UnknownShadowKeyValue", nameof(entityType), nameof(property)),
                entityType, property);

        /// <summary>
        ///     The unnamed index specified via [Index] attribute on the entity type '{entityType}' with properties {indexProperties} is invalid. The property '{propertyName}' was marked as unmapped by [NotMapped] attribute or 'Ignore()' in 'OnModelCreating'. An index cannot use unmapped properties.
        /// </summary>
        public static string UnnamedIndexDefinedOnIgnoredProperty(object? entityType, object? indexProperties, object? propertyName)
            => string.Format(
                GetString("UnnamedIndexDefinedOnIgnoredProperty", nameof(entityType), nameof(indexProperties), nameof(propertyName)),
                entityType, indexProperties, propertyName);

        /// <summary>
        ///     An unnamed index specified via [Index] attribute on the entity type '{entityType}' references properties {indexProperties}, but no property with name '{propertyName}' exists on that entity type or any of its base types.
        /// </summary>
        public static string UnnamedIndexDefinedOnNonExistentProperty(object? entityType, object? indexProperties, object? propertyName)
            => string.Format(
                GetString("UnnamedIndexDefinedOnNonExistentProperty", nameof(entityType), nameof(indexProperties), nameof(propertyName)),
                entityType, indexProperties, propertyName);

        /// <summary>
        ///     The entity type '{entityType}' uses a shared type and the supplied entity is currently not being tracked. To start tracking this entity, call '{referenceCall}' or '{collectionCall}' on the owner entry.
        /// </summary>
        public static string UntrackedDependentEntity(object? entityType, object? referenceCall, object? collectionCall)
            => string.Format(
                GetString("UntrackedDependentEntity", nameof(entityType), nameof(referenceCall), nameof(collectionCall)),
                entityType, referenceCall, collectionCall);

        /// <summary>
        ///     The value for property '{1_entityType}.{0_property}' cannot be set to null because its type is '{propertyType}' which is not a nullable type.
        /// </summary>
        public static string ValueCannotBeNull(object? property, object? entityType, object? propertyType)
            => string.Format(
                GetString("ValueCannotBeNull", "0_property", "1_entityType", nameof(propertyType)),
                property, entityType, propertyType);

        /// <summary>
        ///     Calling '{visitMethodName}' is not allowed. Visit the expression manually for the relevant part in the visitor.
        /// </summary>
        public static string VisitIsNotAllowed(object? visitMethodName)
            => string.Format(
                GetString("VisitIsNotAllowed", nameof(visitMethodName)),
                visitMethodName);

        /// <summary>
        ///     An error was generated for warning '{eventName}': {message} This exception can be suppressed or logged by passing event ID '{eventId}' to the 'ConfigureWarnings' method in 'DbContext.OnConfiguring' or 'AddDbContext'.
        /// </summary>
        public static string WarningAsErrorTemplate(object? eventName, object? message, object? eventId)
            => string.Format(
                GetString("WarningAsErrorTemplate", nameof(eventName), nameof(message), nameof(eventId)),
                eventName, message, eventId);

        /// <summary>
        ///     Property '{1_entityType}.{0_property}' is of type '{actualType}' but the generic type provided is of type '{genericType}'.
        /// </summary>
        public static string WrongGenericPropertyType(object? property, object? entityType, object? actualType, object? genericType)
            => string.Format(
                GetString("WrongGenericPropertyType", "0_property", "1_entityType", nameof(actualType), nameof(genericType)),
                property, entityType, actualType, genericType);

        /// <summary>
        ///     Cannot start tracking the entry for entity type '{entityType}' because it was created by a different StateManager instance.
        /// </summary>
        public static string WrongStateManager(object? entityType)
            => string.Format(
                GetString("WrongStateManager", nameof(entityType)),
                entityType);

        private static string GetString(string name, params string[] formatterNames)
        {
            var value = _resourceManager.GetString(name)!;
            for (var i = 0; i < formatterNames.Length; i++)
            {
                value = value.Replace("{" + formatterNames[i] + "}", "{" + i + "}");
            }

            return value;
        }
    }
}

namespace Microsoft.EntityFrameworkCore.Diagnostics.Internal
{
    /// <summary>
    ///     This is an internal API that supports the Entity Framework Core infrastructure and not subject to
    ///     the same compatibility standards as public APIs. It may be changed or removed without notice in
    ///     any release. You should only use it directly in your code with extreme caution and knowing that
    ///     doing so can result in application failures when updating to a new Entity Framework Core release.
    /// </summary>
    public static class CoreResources
    {
        private static readonly ResourceManager _resourceManager
            = new ResourceManager("Microsoft.EntityFrameworkCore.Properties.CoreStrings", typeof(CoreResources).Assembly);

        /// <summary>
        ///     The complex property '{entityType}.{property}' is configured with a collection type '{collectionType}' but is not marked as a collection. Consider using 'ComplexCollection()' to configure this as a complex collection instead.
        /// </summary>
        public static EventDefinition<string, string, string> LogAccidentalComplexPropertyCollection(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogAccidentalComplexPropertyCollection;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogAccidentalComplexPropertyCollection,
                    logger,
                    static logger => new EventDefinition<string, string, string>(
                        logger.Options,
                        CoreEventId.AccidentalComplexPropertyCollection,
                        LogLevel.Warning,
                        "CoreEventId.AccidentalComplexPropertyCollection",
                        level => LoggerMessage.Define<string, string, string>(
                            level,
                            CoreEventId.AccidentalComplexPropertyCollection,
                            _resourceManager.GetString("LogAccidentalComplexPropertyCollection")!)));
            }

            return (EventDefinition<string, string, string>)definition;
        }

        /// <summary>
        ///     The type '{entityType}' has been mapped as an entity type. If you are mapping this type intentionally, then please suppress this warning and report the issue on GitHub.
        /// </summary>
        public static EventDefinition<string> LogAccidentalEntityType(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogAccidentalEntityType;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogAccidentalEntityType,
                    logger,
                    static logger => new EventDefinition<string>(
                        logger.Options,
                        CoreEventId.AccidentalEntityType,
                        LogLevel.Warning,
                        "CoreEventId.AccidentalEntityType",
                        level => LoggerMessage.Define<string>(
                            level,
                            CoreEventId.AccidentalEntityType,
                            _resourceManager.GetString("LogAccidentalEntityType")!)));
            }

            return (EventDefinition<string>)definition;
        }

        /// <summary>
        ///     The foreign key {foreignKeyProperties} on entity type '{entityType}' cannot be configured as required since the dependent side cannot be determined. To identify the dependent side of the relationship, configure the foreign key property or the principal key before configuring the foreign key as required in 'OnModelCreating'. See https://go.microsoft.com/fwlink/?LinkId=724062 for more details.
        /// </summary>
        public static EventDefinition<string, string> LogAmbiguousEndRequired(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogAmbiguousEndRequired;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogAmbiguousEndRequired,
                    logger,
                    static logger => new EventDefinition<string, string>(
                        logger.Options,
                        CoreEventId.AmbiguousEndRequiredWarning,
                        LogLevel.Warning,
                        "CoreEventId.AmbiguousEndRequiredWarning",
                        level => LoggerMessage.Define<string, string>(
                            level,
                            CoreEventId.AmbiguousEndRequiredWarning,
                            _resourceManager.GetString("LogAmbiguousEndRequired")!)));
            }

            return (EventDefinition<string, string>)definition;
        }

        /// <summary>
        ///     A cascade state change of an entity of type '{entityType}' to '{state}' occurred due to deletion of its parent entity of type '{parentType}'. Consider using 'DbContextOptionsBuilder.EnableSensitiveDataLogging' to see key values.
        /// </summary>
        public static EventDefinition<string, EntityState, string> LogCascadeDelete(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogCascadeDelete;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogCascadeDelete,
                    logger,
                    static logger => new EventDefinition<string, EntityState, string>(
                        logger.Options,
                        CoreEventId.CascadeDelete,
                        LogLevel.Debug,
                        "CoreEventId.CascadeDelete",
                        level => LoggerMessage.Define<string, EntityState, string>(
                            level,
                            CoreEventId.CascadeDelete,
                            _resourceManager.GetString("LogCascadeDelete")!)));
            }

            return (EventDefinition<string, EntityState, string>)definition;
        }

        /// <summary>
        ///     An entity of type '{entityType}' changed to '{state}' state due to severed required relationship to its parent entity of type '{parentType}'. Consider using 'DbContextOptionsBuilder.EnableSensitiveDataLogging' to see key values.
        /// </summary>
        public static EventDefinition<string, EntityState, string> LogCascadeDeleteOrphan(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogCascadeDeleteOrphan;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogCascadeDeleteOrphan,
                    logger,
                    static logger => new EventDefinition<string, EntityState, string>(
                        logger.Options,
                        CoreEventId.CascadeDeleteOrphan,
                        LogLevel.Debug,
                        "CoreEventId.CascadeDeleteOrphan",
                        level => LoggerMessage.Define<string, EntityState, string>(
                            level,
                            CoreEventId.CascadeDeleteOrphan,
                            _resourceManager.GetString("LogCascadeDeleteOrphan")!)));
            }

            return (EventDefinition<string, EntityState, string>)definition;
        }

        /// <summary>
        ///     An entity of type '{entityType}' with key '{keyValues}' changed to '{state}' state due to severed required relationship to its parent entity of type '{parentType}'.
        /// </summary>
        public static EventDefinition<string, string, EntityState, string> LogCascadeDeleteOrphanSensitive(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogCascadeDeleteOrphanSensitive;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogCascadeDeleteOrphanSensitive,
                    logger,
                    static logger => new EventDefinition<string, string, EntityState, string>(
                        logger.Options,
                        CoreEventId.CascadeDeleteOrphan,
                        LogLevel.Debug,
                        "CoreEventId.CascadeDeleteOrphan",
                        level => LoggerMessage.Define<string, string, EntityState, string>(
                            level,
                            CoreEventId.CascadeDeleteOrphan,
                            _resourceManager.GetString("LogCascadeDeleteOrphanSensitive")!)));
            }

            return (EventDefinition<string, string, EntityState, string>)definition;
        }

        /// <summary>
        ///     A cascade state change of an entity of type '{entityType}' with key '{keyValues}' to '{state}' occurred due to the deletion of its parent entity of type '{parentType}' with key '{parentKeyValues}'.
        /// </summary>
        public static EventDefinition<string, string, EntityState, string, string> LogCascadeDeleteSensitive(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogCascadeDeleteSensitive;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogCascadeDeleteSensitive,
                    logger,
                    static logger => new EventDefinition<string, string, EntityState, string, string>(
                        logger.Options,
                        CoreEventId.CascadeDelete,
                        LogLevel.Debug,
                        "CoreEventId.CascadeDelete",
                        level => LoggerMessage.Define<string, string, EntityState, string, string>(
                            level,
                            CoreEventId.CascadeDelete,
                            _resourceManager.GetString("LogCascadeDeleteSensitive")!)));
            }

            return (EventDefinition<string, string, EntityState, string, string>)definition;
        }

        /// <summary>
        ///     {addedCount} entities were added and {removedCount} entities were removed from navigation '{entityType}.{property}'. Consider using 'DbContextOptionsBuilder.EnableSensitiveDataLogging' to see key values.
        /// </summary>
        public static EventDefinition<int, int, string, string> LogCollectionChangeDetected(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogCollectionChangeDetected;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogCollectionChangeDetected,
                    logger,
                    static logger => new EventDefinition<int, int, string, string>(
                        logger.Options,
                        CoreEventId.CollectionChangeDetected,
                        LogLevel.Debug,
                        "CoreEventId.CollectionChangeDetected",
                        level => LoggerMessage.Define<int, int, string, string>(
                            level,
                            CoreEventId.CollectionChangeDetected,
                            _resourceManager.GetString("LogCollectionChangeDetected")!)));
            }

            return (EventDefinition<int, int, string, string>)definition;
        }

        /// <summary>
        ///     {addedCount} entities were added and {removedCount} entities were removed from navigation '{entityType}.{property}' on entity with key '{keyValues}'.
        /// </summary>
        public static EventDefinition<int, int, string, string, string> LogCollectionChangeDetectedSensitive(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogCollectionChangeDetectedSensitive;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogCollectionChangeDetectedSensitive,
                    logger,
                    static logger => new EventDefinition<int, int, string, string, string>(
                        logger.Options,
                        CoreEventId.CollectionChangeDetected,
                        LogLevel.Debug,
                        "CoreEventId.CollectionChangeDetected",
                        level => LoggerMessage.Define<int, int, string, string, string>(
                            level,
                            CoreEventId.CollectionChangeDetected,
                            _resourceManager.GetString("LogCollectionChangeDetectedSensitive")!)));
            }

            return (EventDefinition<int, int, string, string, string>)definition;
        }

        /// <summary>
        ///     The property '{entityType}.{property}' is a collection or enumeration type with a value converter but with no value comparer. Set a value comparer to ensure the collection/enumeration elements are compared correctly.
        /// </summary>
        public static EventDefinition<string, string> LogCollectionWithoutComparer(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogCollectionWithoutComparer;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogCollectionWithoutComparer,
                    logger,
                    static logger => new EventDefinition<string, string>(
                        logger.Options,
                        CoreEventId.CollectionWithoutComparer,
                        LogLevel.Warning,
                        "CoreEventId.CollectionWithoutComparer",
                        level => LoggerMessage.Define<string, string>(
                            level,
                            CoreEventId.CollectionWithoutComparer,
                            _resourceManager.GetString("LogCollectionWithoutComparer")!)));
            }

            return (EventDefinition<string, string>)definition;
        }

        /// <summary>
        ///     The unchanged property '{typePath}.{property}' was detected as changed and will be marked as modified. Consider using 'DbContextOptionsBuilder.EnableSensitiveDataLogging' to see property values.
        /// </summary>
        public static EventDefinition<string, string> LogComplexElementPropertyChangeDetected(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogComplexElementPropertyChangeDetected;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogComplexElementPropertyChangeDetected,
                    logger,
                    static logger => new EventDefinition<string, string>(
                        logger.Options,
                        CoreEventId.ComplexElementPropertyChangeDetected,
                        LogLevel.Debug,
                        "CoreEventId.ComplexElementPropertyChangeDetected",
                        level => LoggerMessage.Define<string, string>(
                            level,
                            CoreEventId.ComplexElementPropertyChangeDetected,
                            _resourceManager.GetString("LogComplexElementPropertyChangeDetected")!)));
            }

            return (EventDefinition<string, string>)definition;
        }

        /// <summary>
        ///     The unchanged property '{typePath}.{property}' was detected as changed from '{oldValue}' to '{newValue}' and will be marked as modified for entity with key '{keyValues}'.
        /// </summary>
        public static EventDefinition<string, string, object?, object?, string> LogComplexElementPropertyChangeDetectedSensitive(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogComplexElementPropertyChangeDetectedSensitive;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogComplexElementPropertyChangeDetectedSensitive,
                    logger,
                    static logger => new EventDefinition<string, string, object?, object?, string>(
                        logger.Options,
                        CoreEventId.ComplexElementPropertyChangeDetected,
                        LogLevel.Debug,
                        "CoreEventId.ComplexElementPropertyChangeDetected",
                        level => LoggerMessage.Define<string, string, object?, object?, string>(
                            level,
                            CoreEventId.ComplexElementPropertyChangeDetected,
                            _resourceManager.GetString("LogComplexElementPropertyChangeDetectedSensitive")!)));
            }

            return (EventDefinition<string, string, object?, object?, string>)definition;
        }

        /// <summary>
        ///     The relationship was separated into two relationships because the [ForeignKey] attribute specified on the navigation '{navigationEntityType}.{navigation}' doesn't match the [ForeignKey] attribute specified on the property '{propertyEntityType}.{property}'.
        /// </summary>
        public static EventDefinition<string, string?, string, string?> LogConflictingForeignKeyAttributesOnNavigationAndProperty(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogConflictingForeignKeyAttributesOnNavigationAndProperty;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogConflictingForeignKeyAttributesOnNavigationAndProperty,
                    logger,
                    static logger => new EventDefinition<string, string?, string, string?>(
                        logger.Options,
                        CoreEventId.ConflictingForeignKeyAttributesOnNavigationAndPropertyWarning,
                        LogLevel.Warning,
                        "CoreEventId.ConflictingForeignKeyAttributesOnNavigationAndPropertyWarning",
                        level => LoggerMessage.Define<string, string?, string, string?>(
                            level,
                            CoreEventId.ConflictingForeignKeyAttributesOnNavigationAndPropertyWarning,
                            _resourceManager.GetString("LogConflictingForeignKeyAttributesOnNavigationAndProperty")!)));
            }

            return (EventDefinition<string, string?, string, string?>)definition;
        }

        /// <summary>
        ///     The entity type '{entity}' has the [Keyless] attribute, but the [Key] attribute was specified on property '{property}'; the two are incompatible, consider removing one. Note that the entity will have no key unless you configure one in 'OnModelCreating'.
        /// </summary>
        public static EventDefinition<string, string> LogConflictingKeylessAndKeyAttributes(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogConflictingKeylessAndKeyAttributes;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogConflictingKeylessAndKeyAttributes,
                    logger,
                    static logger => new EventDefinition<string, string>(
                        logger.Options,
                        CoreEventId.ConflictingKeylessAndKeyAttributesWarning,
                        LogLevel.Warning,
                        "CoreEventId.ConflictingKeylessAndKeyAttributesWarning",
                        level => LoggerMessage.Define<string, string>(
                            level,
                            CoreEventId.ConflictingKeylessAndKeyAttributesWarning,
                            _resourceManager.GetString("LogConflictingKeylessAndKeyAttributes")!)));
            }

            return (EventDefinition<string, string>)definition;
        }

        /// <summary>
        ///     There are multiple relationships between '{dependentEntityType}' and '{principalEntityType}' without configured foreign key properties. This will cause Entity Framework to create shadow properties on '{dependentType}' with names dependent on the discovery order. Consider configuring the foreign key properties using the [ForeignKey] attribute or in 'OnModelCreating'.
        /// </summary>
        public static EventDefinition<string, string, string> LogConflictingShadowForeignKeys(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogConflictingShadowForeignKeys;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogConflictingShadowForeignKeys,
                    logger,
                    static logger => new EventDefinition<string, string, string>(
                        logger.Options,
                        CoreEventId.ConflictingShadowForeignKeysWarning,
                        LogLevel.Warning,
                        "CoreEventId.ConflictingShadowForeignKeysWarning",
                        level => LoggerMessage.Define<string, string, string>(
                            level,
                            CoreEventId.ConflictingShadowForeignKeysWarning,
                            _resourceManager.GetString("LogConflictingShadowForeignKeys")!)));
            }

            return (EventDefinition<string, string, string>)definition;
        }

        /// <summary>
        ///     '{contextType}' disposed.
        /// </summary>
        public static EventDefinition<string> LogContextDisposed(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogContextDisposed;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogContextDisposed,
                    logger,
                    static logger => new EventDefinition<string>(
                        logger.Options,
                        CoreEventId.ContextDisposed,
                        LogLevel.Debug,
                        "CoreEventId.ContextDisposed",
                        level => LoggerMessage.Define<string>(
                            level,
                            CoreEventId.ContextDisposed,
                            _resourceManager.GetString("LogContextDisposed")!)));
            }

            return (EventDefinition<string>)definition;
        }

        /// <summary>
        ///     Entity Framework Core {version} initialized '{contextType}' using provider '{provider}:{providerVersion}' with options: {options}
        /// </summary>
        public static EventDefinition<string, string, string?, string?, string> LogContextInitialized(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogContextInitialized;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogContextInitialized,
                    logger,
                    static logger => new EventDefinition<string, string, string?, string?, string>(
                        logger.Options,
                        CoreEventId.ContextInitialized,
                        LogLevel.Debug,
                        "CoreEventId.ContextInitialized",
                        level => LoggerMessage.Define<string, string, string?, string?, string>(
                            level,
                            CoreEventId.ContextInitialized,
                            _resourceManager.GetString("LogContextInitialized")!)));
            }

            return (EventDefinition<string, string, string?, string?, string>)definition;
        }

        /// <summary>
        ///     An attempt was made to lazy-load navigation '{navigation}' on a detached entity of type '{entityType}'. Lazy loading is not supported for detached entities or entities that are loaded with 'AsNoTracking'.
        /// </summary>
        public static EventDefinition<string, string> LogDetachedLazyLoading(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogDetachedLazyLoading;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogDetachedLazyLoading,
                    logger,
                    static logger => new EventDefinition<string, string>(
                        logger.Options,
                        CoreEventId.DetachedLazyLoadingWarning,
                        LogLevel.Warning,
                        "CoreEventId.DetachedLazyLoadingWarning",
                        level => LoggerMessage.Define<string, string>(
                            level,
                            CoreEventId.DetachedLazyLoadingWarning,
                            _resourceManager.GetString("LogDetachedLazyLoading")!)));
            }

            return (EventDefinition<string, string>)definition;
        }

        /// <summary>
        ///     DetectChanges completed for '{contextType}'.
        /// </summary>
        public static EventDefinition<string> LogDetectChangesCompleted(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogDetectChangesCompleted;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogDetectChangesCompleted,
                    logger,
                    static logger => new EventDefinition<string>(
                        logger.Options,
                        CoreEventId.DetectChangesCompleted,
                        LogLevel.Debug,
                        "CoreEventId.DetectChangesCompleted",
                        level => LoggerMessage.Define<string>(
                            level,
                            CoreEventId.DetectChangesCompleted,
                            _resourceManager.GetString("LogDetectChangesCompleted")!)));
            }

            return (EventDefinition<string>)definition;
        }

        /// <summary>
        ///     DetectChanges starting for '{contextType}'.
        /// </summary>
        public static EventDefinition<string?> LogDetectChangesStarting(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogDetectChangesStarting;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogDetectChangesStarting,
                    logger,
                    static logger => new EventDefinition<string?>(
                        logger.Options,
                        CoreEventId.DetectChangesStarting,
                        LogLevel.Debug,
                        "CoreEventId.DetectChangesStarting",
                        level => LoggerMessage.Define<string?>(
                            level,
                            CoreEventId.DetectChangesStarting,
                            _resourceManager.GetString("LogDetectChangesStarting")!)));
            }

            return (EventDefinition<string?>)definition;
        }

        /// <summary>
        ///     The query uses the 'Distinct' operator after applying an ordering. If there are any row limiting operation used before 'Distinct' and after ordering then ordering will be used for it. Ordering(s) will be erased after 'Distinct' and results afterwards would be unordered.
        /// </summary>
        public static EventDefinition LogDistinctAfterOrderByWithoutRowLimitingOperatorWarning(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogDistinctAfterOrderByWithoutRowLimitingOperatorWarning;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogDistinctAfterOrderByWithoutRowLimitingOperatorWarning,
                    logger,
                    static logger => new EventDefinition(
                        logger.Options,
                        CoreEventId.DistinctAfterOrderByWithoutRowLimitingOperatorWarning,
                        LogLevel.Warning,
                        "CoreEventId.DistinctAfterOrderByWithoutRowLimitingOperatorWarning",
                        level => LoggerMessage.Define(
                            level,
                            CoreEventId.DistinctAfterOrderByWithoutRowLimitingOperatorWarning,
                            _resourceManager.GetString("LogDistinctAfterOrderByWithoutRowLimitingOperatorWarning")!)));
            }

            return (EventDefinition)definition;
        }

        /// <summary>
        ///     The same entity is being tracked as different entity types '{dependent1}' and '{dependent2}' with defining navigations. If a property value changes, it will result in two store changes, which might not be the desired outcome.
        /// </summary>
        public static EventDefinition<string, string> LogDuplicateDependentEntityTypeInstance(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogDuplicateDependentEntityTypeInstance;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogDuplicateDependentEntityTypeInstance,
                    logger,
                    static logger => new EventDefinition<string, string>(
                        logger.Options,
                        CoreEventId.DuplicateDependentEntityTypeInstanceWarning,
                        LogLevel.Warning,
                        "CoreEventId.DuplicateDependentEntityTypeInstanceWarning",
                        level => LoggerMessage.Define<string, string>(
                            level,
                            CoreEventId.DuplicateDependentEntityTypeInstanceWarning,
                            _resourceManager.GetString("LogDuplicateDependentEntityTypeInstance")!)));
            }

            return (EventDefinition<string, string>)definition;
        }

        /// <summary>
        ///     An exception occurred while iterating over the results of a query for context type '{contextType}'.{newline}{error}
        /// </summary>
        public static EventDefinition<Type, string, Exception> LogExceptionDuringQueryIteration(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogExceptionDuringQueryIteration;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogExceptionDuringQueryIteration,
                    logger,
                    static logger => new EventDefinition<Type, string, Exception>(
                        logger.Options,
                        CoreEventId.QueryIterationFailed,
                        LogLevel.Error,
                        "CoreEventId.QueryIterationFailed",
                        level => LoggerMessage.Define<Type, string, Exception>(
                            level,
                            CoreEventId.QueryIterationFailed,
                            _resourceManager.GetString("LogExceptionDuringQueryIteration")!)));
            }

            return (EventDefinition<Type, string, Exception>)definition;
        }

        /// <summary>
        ///     An exception occurred in the database while saving changes for context type '{contextType}'.{newline}{error}
        /// </summary>
        public static EventDefinition<Type?, string, Exception> LogExceptionDuringSaveChanges(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogExceptionDuringSaveChanges;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogExceptionDuringSaveChanges,
                    logger,
                    static logger => new EventDefinition<Type?, string, Exception>(
                        logger.Options,
                        CoreEventId.SaveChangesFailed,
                        LogLevel.Error,
                        "CoreEventId.SaveChangesFailed",
                        level => LoggerMessage.Define<Type?, string, Exception>(
                            level,
                            CoreEventId.SaveChangesFailed,
                            _resourceManager.GetString("LogExceptionDuringSaveChanges")!)));
            }

            return (EventDefinition<Type?, string, Exception>)definition;
        }

        /// <summary>
        ///     A transient exception occurred during execution. The operation will be retried after {delay}ms.{newline}{error}
        /// </summary>
        public static EventDefinition<int, string, Exception> LogExecutionStrategyRetrying(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogExecutionStrategyRetrying;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogExecutionStrategyRetrying,
                    logger,
                    static logger => new EventDefinition<int, string, Exception>(
                        logger.Options,
                        CoreEventId.ExecutionStrategyRetrying,
                        LogLevel.Information,
                        "CoreEventId.ExecutionStrategyRetrying",
                        level => LoggerMessage.Define<int, string, Exception>(
                            level,
                            CoreEventId.ExecutionStrategyRetrying,
                            _resourceManager.GetString("LogExecutionStrategyRetrying")!)));
            }

            return (EventDefinition<int, string, Exception>)definition;
        }

        /// <summary>
        ///     The query uses the 'First'/'FirstOrDefault' operator without 'OrderBy' and filter operators. This may lead to unpredictable results.
        /// </summary>
        public static EventDefinition LogFirstWithoutOrderByAndFilter(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogFirstWithoutOrderByAndFilter;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogFirstWithoutOrderByAndFilter,
                    logger,
                    static logger => new EventDefinition(
                        logger.Options,
                        CoreEventId.FirstWithoutOrderByAndFilterWarning,
                        LogLevel.Warning,
                        "CoreEventId.FirstWithoutOrderByAndFilterWarning",
                        level => LoggerMessage.Define(
                            level,
                            CoreEventId.FirstWithoutOrderByAndFilterWarning,
                            _resourceManager.GetString("LogFirstWithoutOrderByAndFilter")!)));
            }

            return (EventDefinition)definition;
        }

        /// <summary>
        ///     Navigations '{dependentEntityType}.{dependentNavigation}' and '{principalEntityType}.{principalNavigation}' were separated into two relationships since the [ForeignKey] attribute was specified on navigations on both sides.
        /// </summary>
        public static EventDefinition<string, string, string, string> LogForeignKeyAttributesOnBothNavigations(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogForeignKeyAttributesOnBothNavigations;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogForeignKeyAttributesOnBothNavigations,
                    logger,
                    static logger => new EventDefinition<string, string, string, string>(
                        logger.Options,
                        CoreEventId.ForeignKeyAttributesOnBothNavigationsWarning,
                        LogLevel.Warning,
                        "CoreEventId.ForeignKeyAttributesOnBothNavigationsWarning",
                        level => LoggerMessage.Define<string, string, string, string>(
                            level,
                            CoreEventId.ForeignKeyAttributesOnBothNavigationsWarning,
                            _resourceManager.GetString("LogForeignKeyAttributesOnBothNavigations")!)));
            }

            return (EventDefinition<string, string, string, string>)definition;
        }

        /// <summary>
        ///     Navigations '{dependentEntityType}.{dependentNavigation}' and '{principalEntityType}.{principalNavigation}' were separated into two relationships since the [ForeignKey] attribute was specified on properties '{dependentProperty}' and '{principalProperty}' on both sides.
        /// </summary>
        public static EventDefinition<string, string?, string, string?, string?, string?> LogForeignKeyAttributesOnBothProperties(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogForeignKeyAttributesOnBothProperties;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogForeignKeyAttributesOnBothProperties,
                    logger,
                    static logger => new EventDefinition<string, string?, string, string?, string?, string?>(
                        logger.Options,
                        CoreEventId.ForeignKeyAttributesOnBothPropertiesWarning,
                        LogLevel.Warning,
                        "CoreEventId.ForeignKeyAttributesOnBothPropertiesWarning",
                        level => LoggerMessage.Define<string, string?, string, string?, string?, string?>(
                            level,
                            CoreEventId.ForeignKeyAttributesOnBothPropertiesWarning,
                            _resourceManager.GetString("LogForeignKeyAttributesOnBothProperties")!)));
            }

            return (EventDefinition<string, string?, string, string?, string?, string?>)definition;
        }

        /// <summary>
        ///     The foreign key property '{entityType}.{property}' was detected as changed. Consider using 'DbContextOptionsBuilder.EnableSensitiveDataLogging' to see property values.
        /// </summary>
        public static EventDefinition<string, string> LogForeignKeyChangeDetected(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogForeignKeyChangeDetected;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogForeignKeyChangeDetected,
                    logger,
                    static logger => new EventDefinition<string, string>(
                        logger.Options,
                        CoreEventId.ForeignKeyChangeDetected,
                        LogLevel.Debug,
                        "CoreEventId.ForeignKeyChangeDetected",
                        level => LoggerMessage.Define<string, string>(
                            level,
                            CoreEventId.ForeignKeyChangeDetected,
                            _resourceManager.GetString("LogForeignKeyChangeDetected")!)));
            }

            return (EventDefinition<string, string>)definition;
        }

        /// <summary>
        ///     The foreign key property '{entityType}.{property}' was detected as changed from '{oldValue}' to '{newValue}' for entity with key '{keyValues}'.
        /// </summary>
        public static EventDefinition<string, string, object?, object?, string> LogForeignKeyChangeDetectedSensitive(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogForeignKeyChangeDetectedSensitive;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogForeignKeyChangeDetectedSensitive,
                    logger,
                    static logger => new EventDefinition<string, string, object?, object?, string>(
                        logger.Options,
                        CoreEventId.ForeignKeyChangeDetected,
                        LogLevel.Debug,
                        "CoreEventId.ForeignKeyChangeDetected",
                        level => LoggerMessage.Define<string, string, object?, object?, string>(
                            level,
                            CoreEventId.ForeignKeyChangeDetected,
                            _resourceManager.GetString("LogForeignKeyChangeDetectedSensitive")!)));
            }

            return (EventDefinition<string, string, object?, object?, string>)definition;
        }

        /// <summary>
        ///     For the relationship between dependent '{dependentToPrincipalNavigationSpecification}' and principal '{principalToDependentNavigationSpecification}', the foreign key properties haven't been configured by convention because the best match {foreignKeyProperties} are incompatible with the current principal key {principalKey}. This message can be disregarded if explicit configuration has been specified in 'OnModelCreating'.
        /// </summary>
        public static EventDefinition<string, string, string, string> LogIncompatibleMatchingForeignKeyProperties(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogIncompatibleMatchingForeignKeyProperties;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogIncompatibleMatchingForeignKeyProperties,
                    logger,
                    static logger => new EventDefinition<string, string, string, string>(
                        logger.Options,
                        CoreEventId.IncompatibleMatchingForeignKeyProperties,
                        LogLevel.Debug,
                        "CoreEventId.IncompatibleMatchingForeignKeyProperties",
                        level => LoggerMessage.Define<string, string, string, string>(
                            level,
                            CoreEventId.IncompatibleMatchingForeignKeyProperties,
                            _resourceManager.GetString("LogIncompatibleMatchingForeignKeyProperties")!)));
            }

            return (EventDefinition<string, string, string, string>)definition;
        }

        /// <summary>
        ///     Unable to find navigation '{navigation}' specified in string based include path '{navigationChain}'.
        /// </summary>
        public static EventDefinition<object, object> LogInvalidIncludePath(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogInvalidIncludePath;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogInvalidIncludePath,
                    logger,
                    static logger => new EventDefinition<object, object>(
                        logger.Options,
                        CoreEventId.InvalidIncludePathError,
                        LogLevel.Error,
                        "CoreEventId.InvalidIncludePathError",
                        level => LoggerMessage.Define<object, object>(
                            level,
                            CoreEventId.InvalidIncludePathError,
                            _resourceManager.GetString("LogInvalidIncludePath")!)));
            }

            return (EventDefinition<object, object>)definition;
        }

        /// <summary>
        ///     An attempt was made to lazy-load navigation '{entityType}.{navigation}' after the associated DbContext was disposed or returned to the pool, or the entity was explicitly detached from the context.
        /// </summary>
        public static EventDefinition<string, string> LogLazyLoadOnDisposedContext(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogLazyLoadOnDisposedContext;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogLazyLoadOnDisposedContext,
                    logger,
                    static logger => new EventDefinition<string, string>(
                        logger.Options,
                        CoreEventId.LazyLoadOnDisposedContextWarning,
                        LogLevel.Warning,
                        "CoreEventId.LazyLoadOnDisposedContextWarning",
                        level => LoggerMessage.Define<string, string>(
                            level,
                            CoreEventId.LazyLoadOnDisposedContextWarning,
                            _resourceManager.GetString("LogLazyLoadOnDisposedContext")!)));
            }

            return (EventDefinition<string, string>)definition;
        }

        /// <summary>
        ///     More than twenty 'IServiceProvider' instances have been created for internal use by Entity Framework. This is commonly caused by injection of a new singleton service instance into every DbContext instance. For example, calling 'UseLoggerFactory' passing in a new instance each time--see https://go.microsoft.com/fwlink/?linkid=869049 for more details. This may lead to performance issues, consider reviewing calls on 'DbContextOptionsBuilder' that may require new service providers to be built.
        /// </summary>
        public static EventDefinition LogManyServiceProvidersCreated(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogManyServiceProvidersCreated;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogManyServiceProvidersCreated,
                    logger,
                    static logger => new EventDefinition(
                        logger.Options,
                        CoreEventId.ManyServiceProvidersCreatedWarning,
                        LogLevel.Warning,
                        "CoreEventId.ManyServiceProvidersCreatedWarning",
                        level => LoggerMessage.Define(
                            level,
                            CoreEventId.ManyServiceProvidersCreatedWarning,
                            _resourceManager.GetString("LogManyServiceProvidersCreated")!)));
            }

            return (EventDefinition)definition;
        }

        /// <summary>
        ///     The complex property '{type}.{property}' was first mapped explicitly and then ignored. Consider not mapping the complex property in the first place.
        /// </summary>
        public static EventDefinition<string, string> LogMappedComplexPropertyIgnored(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogMappedComplexPropertyIgnored;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogMappedComplexPropertyIgnored,
                    logger,
                    static logger => new EventDefinition<string, string>(
                        logger.Options,
                        CoreEventId.MappedComplexPropertyIgnoredWarning,
                        LogLevel.Warning,
                        "CoreEventId.MappedComplexPropertyIgnoredWarning",
                        level => LoggerMessage.Define<string, string>(
                            level,
                            CoreEventId.MappedComplexPropertyIgnoredWarning,
                            _resourceManager.GetString("LogMappedComplexPropertyIgnored")!)));
            }

            return (EventDefinition<string, string>)definition;
        }

        /// <summary>
        ///     The entity type '{entityType}' was first mapped explicitly and then ignored. Consider not mapping the entity type in the first place.
        /// </summary>
        public static EventDefinition<string> LogMappedEntityTypeIgnored(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogMappedEntityTypeIgnored;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogMappedEntityTypeIgnored,
                    logger,
                    static logger => new EventDefinition<string>(
                        logger.Options,
                        CoreEventId.MappedEntityTypeIgnoredWarning,
                        LogLevel.Warning,
                        "CoreEventId.MappedEntityTypeIgnoredWarning",
                        level => LoggerMessage.Define<string>(
                            level,
                            CoreEventId.MappedEntityTypeIgnoredWarning,
                            _resourceManager.GetString("LogMappedEntityTypeIgnored")!)));
            }

            return (EventDefinition<string>)definition;
        }

        /// <summary>
        ///     The navigation '{entityType}.{navigation}' was first mapped explicitly and then ignored. Consider not mapping the navigation in the first place.
        /// </summary>
        public static EventDefinition<string, string> LogMappedNavigationIgnored(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogMappedNavigationIgnored;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogMappedNavigationIgnored,
                    logger,
                    static logger => new EventDefinition<string, string>(
                        logger.Options,
                        CoreEventId.MappedNavigationIgnoredWarning,
                        LogLevel.Warning,
                        "CoreEventId.MappedNavigationIgnoredWarning",
                        level => LoggerMessage.Define<string, string>(
                            level,
                            CoreEventId.MappedNavigationIgnoredWarning,
                            _resourceManager.GetString("LogMappedNavigationIgnored")!)));
            }

            return (EventDefinition<string, string>)definition;
        }

        /// <summary>
        ///     The property '{entityType}.{property}' was first mapped explicitly and then ignored. Consider not mapping the property in the first place.
        /// </summary>
        public static EventDefinition<string, string> LogMappedPropertyIgnored(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogMappedPropertyIgnored;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogMappedPropertyIgnored,
                    logger,
                    static logger => new EventDefinition<string, string>(
                        logger.Options,
                        CoreEventId.MappedPropertyIgnoredWarning,
                        LogLevel.Warning,
                        "CoreEventId.MappedPropertyIgnoredWarning",
                        level => LoggerMessage.Define<string, string>(
                            level,
                            CoreEventId.MappedPropertyIgnoredWarning,
                            _resourceManager.GetString("LogMappedPropertyIgnored")!)));
            }

            return (EventDefinition<string, string>)definition;
        }

        /// <summary>
        ///     There are multiple navigations ({navigations}) configured with [InverseProperty] attribute which point to the same inverse navigation '{inverseNavigation}' therefore no relationship was configured by convention.
        /// </summary>
        public static EventDefinition<string, string?> LogMultipleInversePropertiesSameTarget(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogMultipleInversePropertiesSameTarget;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogMultipleInversePropertiesSameTarget,
                    logger,
                    static logger => new EventDefinition<string, string?>(
                        logger.Options,
                        CoreEventId.MultipleInversePropertiesSameTargetWarning,
                        LogLevel.Warning,
                        "CoreEventId.MultipleInversePropertiesSameTargetWarning",
                        level => LoggerMessage.Define<string, string?>(
                            level,
                            CoreEventId.MultipleInversePropertiesSameTargetWarning,
                            _resourceManager.GetString("LogMultipleInversePropertiesSameTarget")!)));
            }

            return (EventDefinition<string, string?>)definition;
        }

        /// <summary>
        ///     No relationship from '{firstEntityType}' to '{secondEntityType}' has been configured by convention because there are multiple properties on one entity type - {navigationProperties} that could be matched with the properties on the other entity type - {inverseNavigations}. This message can be disregarded if explicit configuration has been specified in 'OnModelCreating'.
        /// </summary>
        public static EventDefinition<string, string, string, string> LogMultipleNavigationProperties(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogMultipleNavigationProperties;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogMultipleNavigationProperties,
                    logger,
                    static logger => new EventDefinition<string, string, string, string>(
                        logger.Options,
                        CoreEventId.MultipleNavigationProperties,
                        LogLevel.Debug,
                        "CoreEventId.MultipleNavigationProperties",
                        level => LoggerMessage.Define<string, string, string, string>(
                            level,
                            CoreEventId.MultipleNavigationProperties,
                            _resourceManager.GetString("LogMultipleNavigationProperties")!)));
            }

            return (EventDefinition<string, string, string, string>)definition;
        }

        /// <summary>
        ///     A primary key hasn't been configured by convention as both properties '{firstProperty}' and '{secondProperty}' could be used as the primary key for the entity type '{entityType}'. This message can be disregarded if explicit configuration has been specified in 'OnModelCreating'.
        /// </summary>
        public static EventDefinition<string, string, string> LogMultiplePrimaryKeyCandidates(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogMultiplePrimaryKeyCandidates;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogMultiplePrimaryKeyCandidates,
                    logger,
                    static logger => new EventDefinition<string, string, string>(
                        logger.Options,
                        CoreEventId.MultiplePrimaryKeyCandidates,
                        LogLevel.Debug,
                        "CoreEventId.MultiplePrimaryKeyCandidates",
                        level => LoggerMessage.Define<string, string, string>(
                            level,
                            CoreEventId.MultiplePrimaryKeyCandidates,
                            _resourceManager.GetString("LogMultiplePrimaryKeyCandidates")!)));
            }

            return (EventDefinition<string, string, string>)definition;
        }

        /// <summary>
        ///     Including navigation: '{navigation}'.
        /// </summary>
        public static EventDefinition<string> LogNavigationBaseIncluded(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogNavigationBaseIncluded;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogNavigationBaseIncluded,
                    logger,
                    static logger => new EventDefinition<string>(
                        logger.Options,
                        CoreEventId.NavigationBaseIncluded,
                        LogLevel.Debug,
                        "CoreEventId.NavigationBaseIncluded",
                        level => LoggerMessage.Define<string>(
                            level,
                            CoreEventId.NavigationBaseIncluded,
                            _resourceManager.GetString("LogNavigationBaseIncluded")!)));
            }

            return (EventDefinition<string>)definition;
        }

        /// <summary>
        ///     The navigation '{navigation}' was ignored from 'Include' in the query since the fix-up will automatically populate it. If any further navigations are specified in 'Include' afterwards then they will be ignored. Walking back include tree is not allowed.
        /// </summary>
        public static EventDefinition<string> LogNavigationBaseIncludeIgnored(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogNavigationBaseIncludeIgnored;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogNavigationBaseIncludeIgnored,
                    logger,
                    static logger => new EventDefinition<string>(
                        logger.Options,
                        CoreEventId.NavigationBaseIncludeIgnored,
                        LogLevel.Error,
                        "CoreEventId.NavigationBaseIncludeIgnored",
                        level => LoggerMessage.Define<string>(
                            level,
                            CoreEventId.NavigationBaseIncludeIgnored,
                            _resourceManager.GetString("LogNavigationBaseIncludeIgnored")!)));
            }

            return (EventDefinition<string>)definition;
        }

        /// <summary>
        ///     The navigation '{entityType}.{navigation}' is being lazy-loaded.
        /// </summary>
        public static EventDefinition<string, string> LogNavigationLazyLoading(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogNavigationLazyLoading;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogNavigationLazyLoading,
                    logger,
                    static logger => new EventDefinition<string, string>(
                        logger.Options,
                        CoreEventId.NavigationLazyLoading,
                        LogLevel.Debug,
                        "CoreEventId.NavigationLazyLoading",
                        level => LoggerMessage.Define<string, string>(
                            level,
                            CoreEventId.NavigationLazyLoading,
                            _resourceManager.GetString("LogNavigationLazyLoading")!)));
            }

            return (EventDefinition<string, string>)definition;
        }

        /// <summary>
        ///     No instantiatable types implementing `IEntityTypeConfiguration` were found while scanning assembly '{assemblyName}'.
        /// </summary>
        public static EventDefinition<string> LogNoEntityTypeConfigurationsWarning(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogNoEntityTypeConfigurationsWarning;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogNoEntityTypeConfigurationsWarning,
                    logger,
                    static logger => new EventDefinition<string>(
                        logger.Options,
                        CoreEventId.NoEntityTypeConfigurationsWarning,
                        LogLevel.Warning,
                        "CoreEventId.NoEntityTypeConfigurationsWarning",
                        level => LoggerMessage.Define<string>(
                            level,
                            CoreEventId.NoEntityTypeConfigurationsWarning,
                            _resourceManager.GetString("LogNoEntityTypeConfigurationsWarning")!)));
            }

            return (EventDefinition<string>)definition;
        }

        /// <summary>
        ///     The navigation '{targetEntityType}.{inverseNavigation}' specified in the [InverseProperty] attribute cannot be used as the inverse of '{ownedEntityType}.{navigation}' because it's not the ownership navigation '{ownershipNavigation}'.
        /// </summary>
        public static EventDefinition<string, string?, string, string?, string?> LogNonOwnershipInverseNavigation(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogNonOwnershipInverseNavigation;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogNonOwnershipInverseNavigation,
                    logger,
                    static logger => new EventDefinition<string, string?, string, string?, string?>(
                        logger.Options,
                        CoreEventId.NonOwnershipInverseNavigationWarning,
                        LogLevel.Warning,
                        "CoreEventId.NonOwnershipInverseNavigationWarning",
                        level => LoggerMessage.Define<string, string?, string, string?, string?>(
                            level,
                            CoreEventId.NonOwnershipInverseNavigationWarning,
                            _resourceManager.GetString("LogNonOwnershipInverseNavigation")!)));
            }

            return (EventDefinition<string, string?, string, string?, string?>)definition;
        }

        /// <summary>
        ///     The model supplied in the context options was created with EF Core version '{oldVersion}', but the context is from version '{newVersion}'. Update the externally built model.
        /// </summary>
        public static EventDefinition<string, string> LogOldModelVersion(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogOldModelVersion;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogOldModelVersion,
                    logger,
                    static logger => new EventDefinition<string, string>(
                        logger.Options,
                        CoreEventId.OldModelVersionWarning,
                        LogLevel.Warning,
                        "CoreEventId.OldModelVersionWarning",
                        level => LoggerMessage.Define<string, string>(
                            level,
                            CoreEventId.OldModelVersionWarning,
                            _resourceManager.GetString("LogOldModelVersion")!)));
            }

            return (EventDefinition<string, string>)definition;
        }

        /// <summary>
        ///     {error}
        /// </summary>
        public static EventDefinition<Exception> LogOptimisticConcurrencyException(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogOptimisticConcurrencyException;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogOptimisticConcurrencyException,
                    logger,
                    static logger => new EventDefinition<Exception>(
                        logger.Options,
                        CoreEventId.OptimisticConcurrencyException,
                        LogLevel.Debug,
                        "CoreEventId.OptimisticConcurrencyException",
                        level => LoggerMessage.Define<Exception>(
                            level,
                            CoreEventId.OptimisticConcurrencyException,
                            _resourceManager.GetString("LogOptimisticConcurrencyException")!)));
            }

            return (EventDefinition<Exception>)definition;
        }

        /// <summary>
        ///     Entity '{principalEntityType}' has a global query filter defined and is the required end of a relationship with the entity '{declaringEntityType}'. This may lead to unexpected results when the required entity is filtered out. Either configure the navigation as optional, or define matching query filters for both entities in the navigation. See https://go.microsoft.com/fwlink/?linkid=2131316 for more information.
        /// </summary>
        public static EventDefinition<string, string> LogPossibleIncorrectRequiredNavigationWithQueryFilterInteraction(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogPossibleIncorrectRequiredNavigationWithQueryFilterInteraction;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogPossibleIncorrectRequiredNavigationWithQueryFilterInteraction,
                    logger,
                    static logger => new EventDefinition<string, string>(
                        logger.Options,
                        CoreEventId.PossibleIncorrectRequiredNavigationWithQueryFilterInteractionWarning,
                        LogLevel.Warning,
                        "CoreEventId.PossibleIncorrectRequiredNavigationWithQueryFilterInteractionWarning",
                        level => LoggerMessage.Define<string, string>(
                            level,
                            CoreEventId.PossibleIncorrectRequiredNavigationWithQueryFilterInteractionWarning,
                            _resourceManager.GetString("LogPossibleIncorrectRequiredNavigationWithQueryFilterInteraction")!)));
            }

            return (EventDefinition<string, string>)definition;
        }

        /// <summary>
        ///     Collection navigations are only considered null if their parent entity is null. Use 'Any' to check whether collection navigation '{navigationPath}' is empty.
        /// </summary>
        public static EventDefinition<string> LogPossibleUnintendedCollectionNavigationNullComparison(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogPossibleUnintendedCollectionNavigationNullComparison;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogPossibleUnintendedCollectionNavigationNullComparison,
                    logger,
                    static logger => new EventDefinition<string>(
                        logger.Options,
                        CoreEventId.PossibleUnintendedCollectionNavigationNullComparisonWarning,
                        LogLevel.Warning,
                        "CoreEventId.PossibleUnintendedCollectionNavigationNullComparisonWarning",
                        level => LoggerMessage.Define<string>(
                            level,
                            CoreEventId.PossibleUnintendedCollectionNavigationNullComparisonWarning,
                            _resourceManager.GetString("LogPossibleUnintendedCollectionNavigationNullComparison")!)));
            }

            return (EventDefinition<string>)definition;
        }

        /// <summary>
        ///     Possible unintended reference comparison between '{left}' and '{right}'.
        /// </summary>
        public static EventDefinition<object, object> LogPossibleUnintendedReferenceComparison(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogPossibleUnintendedReferenceComparison;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogPossibleUnintendedReferenceComparison,
                    logger,
                    static logger => new EventDefinition<object, object>(
                        logger.Options,
                        CoreEventId.PossibleUnintendedReferenceComparisonWarning,
                        LogLevel.Warning,
                        "CoreEventId.PossibleUnintendedReferenceComparisonWarning",
                        level => LoggerMessage.Define<object, object>(
                            level,
                            CoreEventId.PossibleUnintendedReferenceComparisonWarning,
                            _resourceManager.GetString("LogPossibleUnintendedReferenceComparison")!)));
            }

            return (EventDefinition<object, object>)definition;
        }

        /// <summary>
        ///     The unchanged property '{entityType}.{property}' was detected as changed and will be marked as modified. Consider using 'DbContextOptionsBuilder.EnableSensitiveDataLogging' to see property values.
        /// </summary>
        public static EventDefinition<string, string> LogPropertyChangeDetected(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogPropertyChangeDetected;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogPropertyChangeDetected,
                    logger,
                    static logger => new EventDefinition<string, string>(
                        logger.Options,
                        CoreEventId.PropertyChangeDetected,
                        LogLevel.Debug,
                        "CoreEventId.PropertyChangeDetected",
                        level => LoggerMessage.Define<string, string>(
                            level,
                            CoreEventId.PropertyChangeDetected,
                            _resourceManager.GetString("LogPropertyChangeDetected")!)));
            }

            return (EventDefinition<string, string>)definition;
        }

        /// <summary>
        ///     The unchanged property '{entityType}.{property}' was detected as changed from '{oldValue}' to '{newValue}' and will be marked as modified for entity with key '{keyValues}'.
        /// </summary>
        public static EventDefinition<string, string, object?, object?, string> LogPropertyChangeDetectedSensitive(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogPropertyChangeDetectedSensitive;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogPropertyChangeDetectedSensitive,
                    logger,
                    static logger => new EventDefinition<string, string, object?, object?, string>(
                        logger.Options,
                        CoreEventId.PropertyChangeDetected,
                        LogLevel.Debug,
                        "CoreEventId.PropertyChangeDetected",
                        level => LoggerMessage.Define<string, string, object?, object?, string>(
                            level,
                            CoreEventId.PropertyChangeDetected,
                            _resourceManager.GetString("LogPropertyChangeDetectedSensitive")!)));
            }

            return (EventDefinition<string, string, object?, object?, string>)definition;
        }

        /// <summary>
        ///     A query was canceled for context type '{contextType}'.
        /// </summary>
        public static EventDefinition<Type> LogQueryCanceled(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogQueryCanceled;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogQueryCanceled,
                    logger,
                    static logger => new EventDefinition<Type>(
                        logger.Options,
                        CoreEventId.QueryCanceled,
                        LogLevel.Debug,
                        "CoreEventId.QueryCanceled",
                        level => LoggerMessage.Define<Type>(
                            level,
                            CoreEventId.QueryCanceled,
                            _resourceManager.GetString("LogQueryCanceled")!)));
            }

            return (EventDefinition<Type>)definition;
        }

        /// <summary>
        ///     Compiling query expression: {newline}'{queryExpression}'
        /// </summary>
        public static EventDefinition<string, string> LogQueryCompilationStarting(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogQueryCompilationStarting;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogQueryCompilationStarting,
                    logger,
                    static logger => new EventDefinition<string, string>(
                        logger.Options,
                        CoreEventId.QueryCompilationStarting,
                        LogLevel.Debug,
                        "CoreEventId.QueryCompilationStarting",
                        level => LoggerMessage.Define<string, string>(
                            level,
                            CoreEventId.QueryCompilationStarting,
                            _resourceManager.GetString("LogQueryCompilationStarting")!)));
            }

            return (EventDefinition<string, string>)definition;
        }

        /// <summary>
        ///     Generated query execution expression: {newline}'{plan}'
        /// </summary>
        public static EventDefinition<string, string> LogQueryExecutionPlanned(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogQueryExecutionPlanned;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogQueryExecutionPlanned,
                    logger,
                    static logger => new EventDefinition<string, string>(
                        logger.Options,
                        CoreEventId.QueryExecutionPlanned,
                        LogLevel.Debug,
                        "CoreEventId.QueryExecutionPlanned",
                        level => LoggerMessage.Define<string, string>(
                            level,
                            CoreEventId.QueryExecutionPlanned,
                            _resourceManager.GetString("LogQueryExecutionPlanned")!)));
            }

            return (EventDefinition<string, string>)definition;
        }

        /// <summary>
        ///     'AddEntityFramework*' was called on the service provider, but 'UseInternalServiceProvider' wasn't called in the DbContext options configuration. Consider removing the 'AddEntityFramework*' call, as in most cases it's not needed and may cause conflicts with other products and services registered in the same service provider.
        /// </summary>
        public static EventDefinition LogRedundantAddServicesCall(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogRedundantAddServicesCall;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogRedundantAddServicesCall,
                    logger,
                    static logger => new EventDefinition(
                        logger.Options,
                        CoreEventId.RedundantAddServicesCallWarning,
                        LogLevel.Warning,
                        "CoreEventId.RedundantAddServicesCallWarning",
                        level => LoggerMessage.Define(
                            level,
                            CoreEventId.RedundantAddServicesCallWarning,
                            _resourceManager.GetString("LogRedundantAddServicesCall")!)));
            }

            return (EventDefinition)definition;
        }

        /// <summary>
        ///     The foreign key {redundantForeignKeyProperties} on entity type '{entityType}' targets itself. Consider removing it since it serves no purpose.
        /// </summary>
        public static EventDefinition<string, string> LogRedundantForeignKey(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogRedundantForeignKey;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogRedundantForeignKey,
                    logger,
                    static logger => new EventDefinition<string, string>(
                        logger.Options,
                        CoreEventId.RedundantForeignKeyWarning,
                        LogLevel.Warning,
                        "CoreEventId.RedundantForeignKeyWarning",
                        level => LoggerMessage.Define<string, string>(
                            level,
                            CoreEventId.RedundantForeignKeyWarning,
                            _resourceManager.GetString("LogRedundantForeignKey")!)));
            }

            return (EventDefinition<string, string>)definition;
        }

        /// <summary>
        ///     The index {redundantIndexProperties} was not created on entity type '{firstEntityType}' as the properties are already covered by the index {otherIndexProperties}.
        /// </summary>
        public static EventDefinition<string, string, string> LogRedundantIndexRemoved(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogRedundantIndexRemoved;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogRedundantIndexRemoved,
                    logger,
                    static logger => new EventDefinition<string, string, string>(
                        logger.Options,
                        CoreEventId.RedundantIndexRemoved,
                        LogLevel.Debug,
                        "CoreEventId.RedundantIndexRemoved",
                        level => LoggerMessage.Define<string, string, string>(
                            level,
                            CoreEventId.RedundantIndexRemoved,
                            _resourceManager.GetString("LogRedundantIndexRemoved")!)));
            }

            return (EventDefinition<string, string, string>)definition;
        }

        /// <summary>
        ///     The navigation '{entityType}.{property}' was detected as changed. Consider using 'DbContextOptionsBuilder.EnableSensitiveDataLogging' to see key values.
        /// </summary>
        public static EventDefinition<string, string> LogReferenceChangeDetected(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogReferenceChangeDetected;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogReferenceChangeDetected,
                    logger,
                    static logger => new EventDefinition<string, string>(
                        logger.Options,
                        CoreEventId.ReferenceChangeDetected,
                        LogLevel.Debug,
                        "CoreEventId.ReferenceChangeDetected",
                        level => LoggerMessage.Define<string, string>(
                            level,
                            CoreEventId.ReferenceChangeDetected,
                            _resourceManager.GetString("LogReferenceChangeDetected")!)));
            }

            return (EventDefinition<string, string>)definition;
        }

        /// <summary>
        ///     The navigation '{entityType}.{property}' for entity with key '{keyValues}' was detected as changed.
        /// </summary>
        public static EventDefinition<string, string, string> LogReferenceChangeDetectedSensitive(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogReferenceChangeDetectedSensitive;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogReferenceChangeDetectedSensitive,
                    logger,
                    static logger => new EventDefinition<string, string, string>(
                        logger.Options,
                        CoreEventId.ReferenceChangeDetected,
                        LogLevel.Debug,
                        "CoreEventId.ReferenceChangeDetected",
                        level => LoggerMessage.Define<string, string, string>(
                            level,
                            CoreEventId.ReferenceChangeDetected,
                            _resourceManager.GetString("LogReferenceChangeDetectedSensitive")!)));
            }

            return (EventDefinition<string, string, string>)definition;
        }

        /// <summary>
        ///     The [Required] attribute on '{principalEntityType}.{principalNavigation}' was ignored because it is a collection. The [Required] attribute should only be specified on reference navigations pointing to the principal side of the relationship.
        /// </summary>
        public static EventDefinition<string, string> LogRequiredAttributeOnCollection(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogRequiredAttributeOnCollection;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogRequiredAttributeOnCollection,
                    logger,
                    static logger => new EventDefinition<string, string>(
                        logger.Options,
                        CoreEventId.RequiredAttributeOnCollection,
                        LogLevel.Debug,
                        "CoreEventId.RequiredAttributeOnCollection",
                        level => LoggerMessage.Define<string, string>(
                            level,
                            CoreEventId.RequiredAttributeOnCollection,
                            _resourceManager.GetString("LogRequiredAttributeOnCollection")!)));
            }

            return (EventDefinition<string, string>)definition;
        }

        /// <summary>
        ///     The [Required] attribute on '{principalEntityType}.{principalNavigation}' was ignored because it is a skip navigation. Consider configuring the underlying foreign keys in 'OnModelCreating' instead.
        /// </summary>
        public static EventDefinition<string, string> LogRequiredAttributeOnSkipNavigation(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogRequiredAttributeOnSkipNavigation;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogRequiredAttributeOnSkipNavigation,
                    logger,
                    static logger => new EventDefinition<string, string>(
                        logger.Options,
                        CoreEventId.RequiredAttributeOnSkipNavigation,
                        LogLevel.Debug,
                        "CoreEventId.RequiredAttributeOnSkipNavigation",
                        level => LoggerMessage.Define<string, string>(
                            level,
                            CoreEventId.RequiredAttributeOnSkipNavigation,
                            _resourceManager.GetString("LogRequiredAttributeOnSkipNavigation")!)));
            }

            return (EventDefinition<string, string>)definition;
        }

        /// <summary>
        ///     The query uses a row limiting operator ('Skip'/'Take') without an 'OrderBy' operator. This may lead to unpredictable results. If the 'Distinct' operator is used after 'OrderBy', then make sure to use the 'OrderBy' operator after 'Distinct' as the ordering would otherwise get erased.
        /// </summary>
        public static EventDefinition LogRowLimitingOperationWithoutOrderBy(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogRowLimitingOperationWithoutOrderBy;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogRowLimitingOperationWithoutOrderBy,
                    logger,
                    static logger => new EventDefinition(
                        logger.Options,
                        CoreEventId.RowLimitingOperationWithoutOrderByWarning,
                        LogLevel.Warning,
                        "CoreEventId.RowLimitingOperationWithoutOrderByWarning",
                        level => LoggerMessage.Define(
                            level,
                            CoreEventId.RowLimitingOperationWithoutOrderByWarning,
                            _resourceManager.GetString("LogRowLimitingOperationWithoutOrderBy")!)));
            }

            return (EventDefinition)definition;
        }

        /// <summary>
        ///     A cancellation occurred while saving changes for context type '{contextType}'.
        /// </summary>
        public static EventDefinition<Type?> LogSaveChangesCanceled(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogSaveChangesCanceled;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogSaveChangesCanceled,
                    logger,
                    static logger => new EventDefinition<Type?>(
                        logger.Options,
                        CoreEventId.SaveChangesCanceled,
                        LogLevel.Debug,
                        "CoreEventId.SaveChangesCanceled",
                        level => LoggerMessage.Define<Type?>(
                            level,
                            CoreEventId.SaveChangesCanceled,
                            _resourceManager.GetString("LogSaveChangesCanceled")!)));
            }

            return (EventDefinition<Type?>)definition;
        }

        /// <summary>
        ///     SaveChanges completed for '{contextType}' with {savedCount} entities written to the database.
        /// </summary>
        public static EventDefinition<string?, int> LogSaveChangesCompleted(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogSaveChangesCompleted;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogSaveChangesCompleted,
                    logger,
                    static logger => new EventDefinition<string?, int>(
                        logger.Options,
                        CoreEventId.SaveChangesCompleted,
                        LogLevel.Debug,
                        "CoreEventId.SaveChangesCompleted",
                        level => LoggerMessage.Define<string?, int>(
                            level,
                            CoreEventId.SaveChangesCompleted,
                            _resourceManager.GetString("LogSaveChangesCompleted")!)));
            }

            return (EventDefinition<string?, int>)definition;
        }

        /// <summary>
        ///     SaveChanges starting for '{contextType}'.
        /// </summary>
        public static EventDefinition<string?> LogSaveChangesStarting(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogSaveChangesStarting;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogSaveChangesStarting,
                    logger,
                    static logger => new EventDefinition<string?>(
                        logger.Options,
                        CoreEventId.SaveChangesStarting,
                        LogLevel.Debug,
                        "CoreEventId.SaveChangesStarting",
                        level => LoggerMessage.Define<string?>(
                            level,
                            CoreEventId.SaveChangesStarting,
                            _resourceManager.GetString("LogSaveChangesStarting")!)));
            }

            return (EventDefinition<string?>)definition;
        }

        /// <summary>
        ///     Sensitive data logging is enabled. Log entries and exception messages may include sensitive application data; this mode should only be enabled during development.
        /// </summary>
        public static EventDefinition LogSensitiveDataLoggingEnabled(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogSensitiveDataLoggingEnabled;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogSensitiveDataLoggingEnabled,
                    logger,
                    static logger => new EventDefinition(
                        logger.Options,
                        CoreEventId.SensitiveDataLoggingEnabledWarning,
                        LogLevel.Warning,
                        "CoreEventId.SensitiveDataLoggingEnabledWarning",
                        level => LoggerMessage.Define(
                            level,
                            CoreEventId.SensitiveDataLoggingEnabledWarning,
                            _resourceManager.GetString("LogSensitiveDataLoggingEnabled")!)));
            }

            return (EventDefinition)definition;
        }

        /// <summary>
        ///     An 'IServiceProvider' was created for internal use by Entity Framework.
        /// </summary>
        public static EventDefinition LogServiceProviderCreated(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogServiceProviderCreated;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogServiceProviderCreated,
                    logger,
                    static logger => new EventDefinition(
                        logger.Options,
                        CoreEventId.ServiceProviderCreated,
                        LogLevel.Debug,
                        "CoreEventId.ServiceProviderCreated",
                        level => LoggerMessage.Define(
                            level,
                            CoreEventId.ServiceProviderCreated,
                            _resourceManager.GetString("LogServiceProviderCreated")!)));
            }

            return (EventDefinition)definition;
        }

        /// <summary>
        ///     An additional 'IServiceProvider' was created for internal use by Entity Framework. An existing service provider was not used due to the following configuration changes: {debugInfo}.
        /// </summary>
        public static EventDefinition<string> LogServiceProviderDebugInfo(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogServiceProviderDebugInfo;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogServiceProviderDebugInfo,
                    logger,
                    static logger => new EventDefinition<string>(
                        logger.Options,
                        CoreEventId.ServiceProviderDebugInfo,
                        LogLevel.Debug,
                        "CoreEventId.ServiceProviderDebugInfo",
                        level => LoggerMessage.Define<string>(
                            level,
                            CoreEventId.ServiceProviderDebugInfo,
                            _resourceManager.GetString("LogServiceProviderDebugInfo")!)));
            }

            return (EventDefinition<string>)definition;
        }

        /// <summary>
        ///     The foreign key property '{entityType}.{property}' was created in shadow state because a conflicting property with the simple name '{baseName}' exists in the entity type, but is either not mapped, is already used for another relationship, or is incompatible with the associated primary key type. See https://aka.ms/efcore-relationships for information on mapping relationships in EF Core.
        /// </summary>
        public static EventDefinition<string, string, string> LogShadowForeignKeyPropertyCreated(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogShadowForeignKeyPropertyCreated;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogShadowForeignKeyPropertyCreated,
                    logger,
                    static logger => new EventDefinition<string, string, string>(
                        logger.Options,
                        CoreEventId.ShadowForeignKeyPropertyCreated,
                        LogLevel.Warning,
                        "CoreEventId.ShadowForeignKeyPropertyCreated",
                        level => LoggerMessage.Define<string, string, string>(
                            level,
                            CoreEventId.ShadowForeignKeyPropertyCreated,
                            _resourceManager.GetString("LogShadowForeignKeyPropertyCreated")!)));
            }

            return (EventDefinition<string, string, string>)definition;
        }

        /// <summary>
        ///     The property '{entityType}.{property}' was created in shadow state because there are no eligible CLR members with a matching name.
        /// </summary>
        public static EventDefinition<string, string> LogShadowPropertyCreated(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogShadowPropertyCreated;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogShadowPropertyCreated,
                    logger,
                    static logger => new EventDefinition<string, string>(
                        logger.Options,
                        CoreEventId.ShadowPropertyCreated,
                        LogLevel.Debug,
                        "CoreEventId.ShadowPropertyCreated",
                        level => LoggerMessage.Define<string, string>(
                            level,
                            CoreEventId.ShadowPropertyCreated,
                            _resourceManager.GetString("LogShadowPropertyCreated")!)));
            }

            return (EventDefinition<string, string>)definition;
        }

        /// <summary>
        ///     {addedCount} entities were added and {removedCount} entities were removed from skip navigation '{entityType}.{property}'. Consider using 'DbContextOptionsBuilder.EnableSensitiveDataLogging' to see key values.
        /// </summary>
        public static EventDefinition<int, int, string, string> LogSkipCollectionChangeDetected(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogSkipCollectionChangeDetected;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogSkipCollectionChangeDetected,
                    logger,
                    static logger => new EventDefinition<int, int, string, string>(
                        logger.Options,
                        CoreEventId.SkipCollectionChangeDetected,
                        LogLevel.Debug,
                        "CoreEventId.SkipCollectionChangeDetected",
                        level => LoggerMessage.Define<int, int, string, string>(
                            level,
                            CoreEventId.SkipCollectionChangeDetected,
                            _resourceManager.GetString("LogSkipCollectionChangeDetected")!)));
            }

            return (EventDefinition<int, int, string, string>)definition;
        }

        /// <summary>
        ///     {addedCount} entities were added and {removedCount} entities were removed from skip navigation '{entityType}.{property}' on entity with key '{keyValues}'.
        /// </summary>
        public static EventDefinition<int, int, string, string, string> LogSkipCollectionChangeDetectedSensitive(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogSkipCollectionChangeDetectedSensitive;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogSkipCollectionChangeDetectedSensitive,
                    logger,
                    static logger => new EventDefinition<int, int, string, string, string>(
                        logger.Options,
                        CoreEventId.SkipCollectionChangeDetected,
                        LogLevel.Debug,
                        "CoreEventId.SkipCollectionChangeDetected",
                        level => LoggerMessage.Define<int, int, string, string, string>(
                            level,
                            CoreEventId.SkipCollectionChangeDetected,
                            _resourceManager.GetString("LogSkipCollectionChangeDetectedSensitive")!)));
            }

            return (EventDefinition<int, int, string, string, string>)definition;
        }

        /// <summary>
        ///     The type '{entityTypeConfig}' was found while scanning assemblies but could not be instantiated because it does not have a parameterless constructor.
        /// </summary>
        public static EventDefinition<string> LogSkippedEntityTypeConfigurationWarning(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogSkippedEntityTypeConfigurationWarning;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogSkippedEntityTypeConfigurationWarning,
                    logger,
                    static logger => new EventDefinition<string>(
                        logger.Options,
                        CoreEventId.SkippedEntityTypeConfigurationWarning,
                        LogLevel.Warning,
                        "CoreEventId.SkippedEntityTypeConfigurationWarning",
                        level => LoggerMessage.Define<string>(
                            level,
                            CoreEventId.SkippedEntityTypeConfigurationWarning,
                            _resourceManager.GetString("LogSkippedEntityTypeConfigurationWarning")!)));
            }

            return (EventDefinition<string>)definition;
        }

        /// <summary>
        ///     Context '{contextType}' started tracking '{entityType}' entity. Consider using 'DbContextOptionsBuilder.EnableSensitiveDataLogging' to see key values.
        /// </summary>
        public static EventDefinition<string, string> LogStartedTracking(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogStartedTracking;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogStartedTracking,
                    logger,
                    static logger => new EventDefinition<string, string>(
                        logger.Options,
                        CoreEventId.StartedTracking,
                        LogLevel.Debug,
                        "CoreEventId.StartedTracking",
                        level => LoggerMessage.Define<string, string>(
                            level,
                            CoreEventId.StartedTracking,
                            _resourceManager.GetString("LogStartedTracking")!)));
            }

            return (EventDefinition<string, string>)definition;
        }

        /// <summary>
        ///     Context '{contextType}' started tracking '{entityType}' entity with key '{keyValues}'.
        /// </summary>
        public static EventDefinition<string, string, string> LogStartedTrackingSensitive(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogStartedTrackingSensitive;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogStartedTrackingSensitive,
                    logger,
                    static logger => new EventDefinition<string, string, string>(
                        logger.Options,
                        CoreEventId.StartedTracking,
                        LogLevel.Debug,
                        "CoreEventId.StartedTracking",
                        level => LoggerMessage.Define<string, string, string>(
                            level,
                            CoreEventId.StartedTracking,
                            _resourceManager.GetString("LogStartedTrackingSensitive")!)));
            }

            return (EventDefinition<string, string, string>)definition;
        }

        /// <summary>
        ///     An entity of type '{entityType}' tracked by '{contextType}' changed state from '{oldState}' to '{newState}'. Consider using 'DbContextOptionsBuilder.EnableSensitiveDataLogging' to see key values.
        /// </summary>
        public static EventDefinition<string, string, EntityState, EntityState> LogStateChanged(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogStateChanged;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogStateChanged,
                    logger,
                    static logger => new EventDefinition<string, string, EntityState, EntityState>(
                        logger.Options,
                        CoreEventId.StateChanged,
                        LogLevel.Debug,
                        "CoreEventId.StateChanged",
                        level => LoggerMessage.Define<string, string, EntityState, EntityState>(
                            level,
                            CoreEventId.StateChanged,
                            _resourceManager.GetString("LogStateChanged")!)));
            }

            return (EventDefinition<string, string, EntityState, EntityState>)definition;
        }

        /// <summary>
        ///     The '{entityType}' entity with key '{keyValues}' tracked by '{contextType}' changed state from '{oldState}' to '{newState}'.
        /// </summary>
        public static EventDefinition<string, string, string, EntityState, EntityState> LogStateChangedSensitive(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogStateChangedSensitive;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogStateChangedSensitive,
                    logger,
                    static logger => new EventDefinition<string, string, string, EntityState, EntityState>(
                        logger.Options,
                        CoreEventId.StateChanged,
                        LogLevel.Debug,
                        "CoreEventId.StateChanged",
                        level => LoggerMessage.Define<string, string, string, EntityState, EntityState>(
                            level,
                            CoreEventId.StateChanged,
                            _resourceManager.GetString("LogStateChangedSensitive")!)));
            }

            return (EventDefinition<string, string, string, EntityState, EntityState>)definition;
        }

        /// <summary>
        ///     A string value was read from JSON for enum '{enumType}'. Starting with EF Core 8, a breaking change was made to store enum values in JSON as numbers by default. See https://aka.ms/efcore-docs-jsonenums for details.
        /// </summary>
        public static EventDefinition<string> LogStringEnumValueInJson(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogStringEnumValueInJson;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogStringEnumValueInJson,
                    logger,
                    static logger => new EventDefinition<string>(
                        logger.Options,
                        CoreEventId.StringEnumValueInJson,
                        LogLevel.Warning,
                        "CoreEventId.StringEnumValueInJson",
                        level => LoggerMessage.Define<string>(
                            level,
                            CoreEventId.StringEnumValueInJson,
                            _resourceManager.GetString("LogStringEnumValueInJson")!)));
            }

            return (EventDefinition<string>)definition;
        }

        /// <summary>
        ///     '{contextType}' generated a temporary value for the property '{entityType}.{property}'. Consider using 'DbContextOptionsBuilder.EnableSensitiveDataLogging' to see key values.
        /// </summary>
        public static EventDefinition<string, string, string> LogTempValueGenerated(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogTempValueGenerated;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogTempValueGenerated,
                    logger,
                    static logger => new EventDefinition<string, string, string>(
                        logger.Options,
                        CoreEventId.ValueGenerated,
                        LogLevel.Debug,
                        "CoreEventId.ValueGenerated",
                        level => LoggerMessage.Define<string, string, string>(
                            level,
                            CoreEventId.ValueGenerated,
                            _resourceManager.GetString("LogTempValueGenerated")!)));
            }

            return (EventDefinition<string, string, string>)definition;
        }

        /// <summary>
        ///     '{contextType}' generated temporary value '{keyValue}' for the property '{entityType}.{property}'.
        /// </summary>
        public static EventDefinition<string, object?, string, string> LogTempValueGeneratedSensitive(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogTempValueGeneratedSensitive;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogTempValueGeneratedSensitive,
                    logger,
                    static logger => new EventDefinition<string, object?, string, string>(
                        logger.Options,
                        CoreEventId.ValueGenerated,
                        LogLevel.Debug,
                        "CoreEventId.ValueGenerated",
                        level => LoggerMessage.Define<string, object?, string, string>(
                            level,
                            CoreEventId.ValueGenerated,
                            _resourceManager.GetString("LogTempValueGeneratedSensitive")!)));
            }

            return (EventDefinition<string, object?, string, string>)definition;
        }

        /// <summary>
        ///     Attempting to load types from '{assemblyName}' resulted in ignored error: '{exceptionMessage}'.
        /// </summary>
        public static EventDefinition<string, string> LogTypeLoadingErrorWarning(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogTypeLoadingErrorWarning;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogTypeLoadingErrorWarning,
                    logger,
                    static logger => new EventDefinition<string, string>(
                        logger.Options,
                        CoreEventId.TypeLoadingErrorWarning,
                        LogLevel.Warning,
                        "CoreEventId.TypeLoadingErrorWarning",
                        level => LoggerMessage.Define<string, string>(
                            level,
                            CoreEventId.TypeLoadingErrorWarning,
                            _resourceManager.GetString("LogTypeLoadingErrorWarning")!)));
            }

            return (EventDefinition<string, string>)definition;
        }

        /// <summary>
        ///     '{contextType}' generated a value for the property '{entityType}.{property}'. Consider using 'DbContextOptionsBuilder.EnableSensitiveDataLogging' to see key values.
        /// </summary>
        public static EventDefinition<string, string, string> LogValueGenerated(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogValueGenerated;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogValueGenerated,
                    logger,
                    static logger => new EventDefinition<string, string, string>(
                        logger.Options,
                        CoreEventId.ValueGenerated,
                        LogLevel.Debug,
                        "CoreEventId.ValueGenerated",
                        level => LoggerMessage.Define<string, string, string>(
                            level,
                            CoreEventId.ValueGenerated,
                            _resourceManager.GetString("LogValueGenerated")!)));
            }

            return (EventDefinition<string, string, string>)definition;
        }

        /// <summary>
        ///     '{contextType}' generated value '{keyValue}' for the property '{entityType}.{property}'.
        /// </summary>
        public static EventDefinition<string, object?, string, string> LogValueGeneratedSensitive(IDiagnosticsLogger logger)
        {
            var definition = ((LoggingDefinitions)logger.Definitions).LogValueGeneratedSensitive;
            if (definition == null)
            {
                definition = NonCapturingLazyInitializer.EnsureInitialized(
                    ref ((LoggingDefinitions)logger.Definitions).LogValueGeneratedSensitive,
                    logger,
                    static logger => new EventDefinition<string, object?, string, string>(
                        logger.Options,
                        CoreEventId.ValueGenerated,
                        LogLevel.Debug,
                        "CoreEventId.ValueGenerated",
                        level => LoggerMessage.Define<string, object?, string, string>(
                            level,
                            CoreEventId.ValueGenerated,
                            _resourceManager.GetString("LogValueGeneratedSensitive")!)));
            }

            return (EventDefinition<string, object?, string, string>)definition;
        }
    }
}
