#include "sys"
#include "config/config"

int sysrun(string const &s) {
    int ret = system(s.c_str());
    if (ret == -1) {
	warnmsg("Failed to start command: " << s << '\n');
	return -1;
    }
    if (WIFEXITED(ret)) {
	int stat = WEXITSTATUS(ret);
	if (stat) {
	    warnmsg("Command" << s << " exited with status " << stat << '\n');
	} else {
	    msg("Command " << s << " terminated normally\n");
	}
	return stat;
    }
    warnmsg("Command " << s << " failed miserably!\n");
    return ret;
}
