/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FilterIterator;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.IsLastExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PositionIterator;
import net.sf.saxon.expr.PositionRange;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.SliceExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Last;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.Value;

public final class FilterExpression
extends ComputedExpression {
    private Expression start;
    private Expression filter;
    private boolean filterIsPositional;
    private boolean filterIsSingletonBoolean;
    private int isIndexable = 0;

    public FilterExpression(Expression expression, Expression expression2) {
        this.start = expression;
        this.filter = expression2;
        this.adoptChildExpression(expression);
        this.adoptChildExpression(expression2);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.start.getItemType(typeHierarchy);
    }

    public Expression getBaseExpression() {
        return this.start;
    }

    public Expression getFilter() {
        return this.filter;
    }

    public boolean isPositional(TypeHierarchy typeHierarchy) {
        return FilterExpression.isPositionalFilter(this.filter, typeHierarchy);
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.start = this.start.simplify(staticContext);
        this.filter = this.filter.simplify(staticContext);
        if (this.start instanceof EmptySequence) {
            return this.start;
        }
        if (this.filter instanceof Value && !(this.filter instanceof NumericValue)) {
            try {
                if (this.filter.effectiveBooleanValue(null)) {
                    ComputedExpression.setParentExpression(this.start, this.getParentExpression());
                    return this.start;
                }
                return EmptySequence.getInstance();
            }
            catch (XPathException xPathException) {
                throw StaticError.makeStaticError(xPathException);
            }
        }
        if (this.filter instanceof Last) {
            this.filter = new IsLastExpression(true);
            this.adoptChildExpression(this.filter);
        }
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression;
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        Expression expression2 = this.start.typeCheck(staticContext, itemType);
        if (expression2 != this.start) {
            this.start = expression2;
            this.adoptChildExpression(expression2);
        }
        if ((expression = this.filter.typeCheck(staticContext, this.start.getItemType(typeHierarchy))) != this.filter) {
            this.filter = expression;
            this.adoptChildExpression(expression);
        }
        if ((expression = ExpressionTool.unsortedIfHomogeneous(staticContext.getConfiguration().getOptimizer(), this.filter, false)) != this.filter) {
            this.filter = expression;
            this.adoptChildExpression(expression);
        }
        if (this.filter instanceof IntegerValue && ((IntegerValue)this.filter).longValue() == 1L) {
            FirstItemExpression firstItemExpression = new FirstItemExpression(this.start);
            firstItemExpression.setParentExpression(this.getParentExpression());
            firstItemExpression.setLocationId(this.getLocationId());
            return firstItemExpression;
        }
        if (this.filter instanceof PositionRange) {
            PositionRange positionRange = (PositionRange)this.filter;
            if (positionRange.isFirstPositionOnly()) {
                FirstItemExpression firstItemExpression = new FirstItemExpression(this.start);
                firstItemExpression.setParentExpression(this.getParentExpression());
                firstItemExpression.setLocationId(this.getLocationId());
                return firstItemExpression;
            }
            TailExpression tailExpression = positionRange.makeTailExpression(this.start);
            if (tailExpression != null) {
                tailExpression.setParentExpression(this.getParentExpression());
                tailExpression.setLocationId(this.getLocationId());
                return tailExpression;
            }
        }
        this.filterIsPositional = FilterExpression.isPositionalFilter(this.filter, typeHierarchy);
        this.filterIsSingletonBoolean = this.filter.getCardinality() == 16384 && this.filter.getItemType(typeHierarchy) == Type.BOOLEAN_TYPE;
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        Object object;
        Object object2;
        Expression expression;
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        Expression expression2 = this.start.optimize(optimizer, staticContext, itemType);
        if (expression2 != this.start) {
            this.start = expression2;
            this.adoptChildExpression(expression2);
        }
        if ((expression = this.filter.optimize(optimizer, staticContext, this.start.getItemType(typeHierarchy))) != this.filter) {
            this.filter = expression;
            this.adoptChildExpression(expression);
        }
        if ((expression = ExpressionTool.unsortedIfHomogeneous(optimizer, this.filter, false)) != this.filter) {
            this.filter = expression;
            this.adoptChildExpression(expression);
        }
        if (this.filter instanceof IntegerValue && ((IntegerValue)this.filter).longValue() == 1L) {
            FirstItemExpression firstItemExpression = new FirstItemExpression(this.start);
            firstItemExpression.setLocationId(this.getLocationId());
            firstItemExpression.setParentExpression(this.getParentExpression());
            return firstItemExpression;
        }
        if (this.filter instanceof BooleanValue) {
            if (((BooleanValue)this.filter).getBooleanValue()) {
                ComputedExpression.setParentExpression(this.start, this.getParentExpression());
                return this.start;
            }
            return EmptySequence.getInstance();
        }
        if (this.filter instanceof PositionRange) {
            object2 = (PositionRange)this.filter;
            if (((PositionRange)object2).isFirstPositionOnly()) {
                FirstItemExpression firstItemExpression = new FirstItemExpression(this.start);
                firstItemExpression.setLocationId(this.getLocationId());
                firstItemExpression.setParentExpression(this.getParentExpression());
                return firstItemExpression;
            }
            object = ((PositionRange)object2).makeTailExpression(this.start);
            if (object != null) {
                ((ComputedExpression)object).setParentExpression(this.getParentExpression());
                ((ComputedExpression)object).setLocationId(this.getLocationId());
                return object;
            }
        }
        this.filterIsPositional = FilterExpression.isPositionalFilter(this.filter, typeHierarchy);
        boolean bl = this.filterIsSingletonBoolean = this.filter.getCardinality() == 16384 && this.filter.getItemType(typeHierarchy) == Type.BOOLEAN_TYPE;
        if (this.filterIsPositional) {
            this.isIndexable = 0;
        } else {
            this.isIndexable = optimizer.isIndexableFilter(this.filter);
            if (this.isIndexable != 0) {
                object2 = optimizer.tryToConvertFilterExpressionToKey(this, staticContext);
                if (object2 != null) {
                    return object2;
                }
                if (this.start instanceof VariableReference && (object = ((VariableReference)this.start).getBinding()) instanceof LetExpression) {
                    ((LetExpression)object).setIndexedVariable();
                }
            }
        }
        if (this.filterIsPositional && this.filter instanceof BooleanExpression && ((BooleanExpression)this.filter).operator == 10) {
            object2 = (BooleanExpression)this.filter;
            if (FilterExpression.isExplicitlyPositional(((BooleanExpression)object2).operand0) && !FilterExpression.isExplicitlyPositional(((BooleanExpression)object2).operand1)) {
                object = FilterExpression.forceToBoolean(((BooleanExpression)object2).operand0, staticContext.getConfiguration());
                Expression expression3 = FilterExpression.forceToBoolean(((BooleanExpression)object2).operand1, staticContext.getConfiguration());
                FilterExpression filterExpression = new FilterExpression(this.start, (Expression)object);
                FilterExpression filterExpression2 = new FilterExpression(filterExpression, expression3);
                filterExpression2.setLocationId(this.getLocationId());
                filterExpression2.setParentExpression(this.getParentExpression());
                return filterExpression2.optimize(optimizer, staticContext, itemType);
            }
            if (FilterExpression.isExplicitlyPositional(((BooleanExpression)object2).operand1) && !FilterExpression.isExplicitlyPositional(((BooleanExpression)object2).operand0)) {
                object = FilterExpression.forceToBoolean(((BooleanExpression)object2).operand0, staticContext.getConfiguration());
                Expression expression4 = FilterExpression.forceToBoolean(((BooleanExpression)object2).operand1, staticContext.getConfiguration());
                FilterExpression filterExpression = new FilterExpression(this.start, expression4);
                FilterExpression filterExpression3 = new FilterExpression(filterExpression, (Expression)object);
                filterExpression3.setLocationId(this.getLocationId());
                filterExpression3.setParentExpression(this.getParentExpression());
                return filterExpression3.optimize(optimizer, staticContext, itemType);
            }
        }
        if (this.filter instanceof PositionRange && !((PositionRange)this.filter).hasFocusDependentRange()) {
            object2 = new SliceExpression(this.start, (PositionRange)this.filter);
            ((ComputedExpression)object2).setLocationId(this.getLocationId());
            ((ComputedExpression)object2).setParentExpression(this.getParentExpression());
            return object2;
        }
        object2 = new PromotionOffer(optimizer);
        ((PromotionOffer)object2).action = 10;
        ((PromotionOffer)object2).promoteDocumentDependent = (this.start.getSpecialProperties() & 0x10000) != 0;
        ((PromotionOffer)object2).containingExpression = this;
        expression = this.doPromotion(this.filter, (PromotionOffer)object2);
        if (expression != this.filter) {
            this.filter = expression;
            this.adoptChildExpression(expression);
        }
        if (((PromotionOffer)object2).containingExpression instanceof LetExpression) {
            ((PromotionOffer)object2).containingExpression = ((PromotionOffer)object2).containingExpression.optimize(optimizer, staticContext, itemType);
        }
        return ((PromotionOffer)object2).containingExpression;
    }

    private static Expression forceToBoolean(Expression expression, Configuration configuration) {
        TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
        if (expression.getItemType(typeHierarchy).getPrimitiveType() == 514) {
            return expression;
        }
        Expression[] expressionArray = new Expression[]{expression};
        FunctionCall functionCall = SystemFunction.makeSystemFunction("boolean", 1, configuration.getNamePool());
        functionCall.setArguments(expressionArray);
        return functionCall;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        if (promotionOffer.action != 13 || !this.filterIsPositional) {
            this.start = this.doPromotion(this.start, promotionOffer);
        }
        if (promotionOffer.action == 12 || promotionOffer.action == 14) {
            this.filter = this.doPromotion(this.filter, promotionOffer);
        }
        return this;
    }

    private static boolean isPositionalFilter(Expression expression, TypeHierarchy typeHierarchy) {
        ItemType itemType = expression.getItemType(typeHierarchy);
        if (itemType == Type.BOOLEAN_TYPE) {
            return FilterExpression.isExplicitlyPositional(expression);
        }
        return itemType == Type.ANY_ATOMIC_TYPE || itemType instanceof AnyItemType || itemType == Type.INTEGER_TYPE || itemType == Type.NUMBER_TYPE || typeHierarchy.isSubType(itemType, Type.NUMBER_TYPE) || FilterExpression.isExplicitlyPositional(expression);
    }

    private static boolean isExplicitlyPositional(Expression expression) {
        return (expression.getDependencies() & 0xC) != 0;
    }

    public Iterator iterateSubExpressions() {
        return new PairIterator(this.start, this.filter);
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        boolean bl = false;
        if (this.start == expression) {
            this.start = expression2;
            bl = true;
        }
        if (this.filter == expression) {
            this.filter = expression2;
            bl = true;
        }
        return bl;
    }

    public int computeCardinality() {
        PositionRange positionRange;
        if (this.filter instanceof NumericValue) {
            return 24576;
        }
        if (!Cardinality.allowsMany(this.start.getCardinality())) {
            return 24576;
        }
        if (this.filter instanceof PositionRange && (positionRange = (PositionRange)this.filter).matchesAtMostOneItem()) {
            return 24576;
        }
        if (this.filter instanceof IsLastExpression && ((IsLastExpression)this.filter).getCondition()) {
            return 24576;
        }
        int n = this.start.getCardinality();
        switch (n) {
            case 49152: {
                return 57344;
            }
            case 16384: {
                return 24576;
            }
        }
        return n;
    }

    public int computeSpecialProperties() {
        return this.start.getSpecialProperties();
    }

    public boolean equals(Object object) {
        if (object instanceof FilterExpression) {
            FilterExpression filterExpression = (FilterExpression)object;
            return this.start.equals(filterExpression.start) && this.filter.equals(filterExpression.filter);
        }
        return false;
    }

    public int hashCode() {
        return "FilterExpression".hashCode() + this.start.hashCode() + this.filter.hashCode();
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator;
        Expression expression = this.start;
        ValueRepresentation valueRepresentation = null;
        if (expression instanceof ValueRepresentation) {
            valueRepresentation = (ValueRepresentation)((Object)expression);
        } else if (expression instanceof VariableReference) {
            valueRepresentation = ((VariableReference)expression).evaluateVariable(xPathContext);
        }
        if (valueRepresentation instanceof Value) {
            expression = (Value)valueRepresentation;
        }
        if (valueRepresentation instanceof EmptySequence) {
            return EmptyIterator.getInstance();
        }
        ValueRepresentation valueRepresentation2 = null;
        if (this.filter instanceof ValueRepresentation) {
            valueRepresentation2 = (ValueRepresentation)((Object)this.filter);
        } else if (this.filter instanceof VariableReference) {
            valueRepresentation2 = ((VariableReference)this.filter).evaluateVariable(xPathContext);
        }
        if (valueRepresentation2 != null) {
            if (valueRepresentation2 instanceof Value) {
                if ((valueRepresentation2 = ((Value)valueRepresentation2).reduce()) instanceof AtomicValue && (valueRepresentation2 = ((AtomicValue)valueRepresentation2).getPrimitiveValue()) instanceof NumericValue) {
                    if (((NumericValue)valueRepresentation2).isWholeNumber()) {
                        int n = (int)((NumericValue)valueRepresentation2).longValue();
                        if (valueRepresentation != null) {
                            if (valueRepresentation instanceof Value) {
                                return SingletonIterator.makeIterator(((Value)valueRepresentation).itemAt(n - 1));
                            }
                            if (valueRepresentation instanceof NodeInfo) {
                                if (n == 1) {
                                    return SingletonIterator.makeIterator((NodeInfo)valueRepresentation);
                                }
                                return EmptyIterator.getInstance();
                            }
                        }
                        if (n >= 1) {
                            SequenceIterator sequenceIterator2 = expression.iterate(xPathContext);
                            return PositionIterator.make(sequenceIterator2, n, n);
                        }
                        return EmptyIterator.getInstance();
                    }
                    return EmptyIterator.getInstance();
                }
                if (((Value)valueRepresentation2).effectiveBooleanValue(xPathContext)) {
                    return this.start.iterate(xPathContext);
                }
                return EmptyIterator.getInstance();
            }
            if (valueRepresentation2 instanceof NodeInfo) {
                return this.start.iterate(xPathContext);
            }
        }
        if (this.isIndexable != 0 && valueRepresentation instanceof Closure && ((Closure)valueRepresentation).isIndexable() && (sequenceIterator = xPathContext.getConfiguration().getOptimizer().tryIndexedFilter(valueRepresentation, this.filter, this.isIndexable, xPathContext)) != null) {
            return sequenceIterator;
        }
        sequenceIterator = expression.iterate(xPathContext);
        if (sequenceIterator instanceof EmptyIterator) {
            return sequenceIterator;
        }
        if (this.filterIsPositional) {
            FilterIterator filterIterator = new FilterIterator(sequenceIterator, this.filter, xPathContext);
            filterIterator.setFilterIsSingletonBoolean(this.filterIsSingletonBoolean);
            return filterIterator;
        }
        return new FilterIterator.NonNumeric(sequenceIterator, this.filter, xPathContext);
    }

    public boolean isIndexable() {
        return this.isIndexable != 0;
    }

    public int computeDependencies() {
        return this.start.getDependencies() | this.filter.getDependencies() & 0x1E1;
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "filter []");
        this.start.display(n + 1, printStream, configuration);
        this.filter.display(n + 1, printStream, configuration);
    }
}

