'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _WizardHeader = require('./WizardHeader');

var _WizardHeader2 = _interopRequireDefault(_WizardHeader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

/**
 * Wizard - main Wizard component.
 */
var Wizard = function Wizard(_ref) {
  var children = _ref.children,
      className = _ref.className,
      embedded = _ref.embedded,
      props = _objectWithoutProperties(_ref, ['children', 'className', 'embedded']);

  var renderChildren = function renderChildren() {
    return _react2.default.Children.map(children, function (child) {
      if (child && child.type === _WizardHeader2.default) {
        return _react2.default.cloneElement(child, {
          embedded: embedded
        });
      }
      return child;
    });
  };

  return _react2.default.createElement(
    'div',
    _extends({ className: className }, props),
    renderChildren()
  );
};
Wizard.propTypes = {
  /** Children nodes */
  children: _propTypes2.default.node,
  /** Additional css classes */
  className: _propTypes2.default.string,
  /** Embedded wizard */
  embedded: _propTypes2.default.bool
};
Wizard.defaultProps = {
  children: null,
  className: '',
  embedded: false
};
exports.default = Wizard;