#ifndef H_CDW_INPUT_LINE
#define H_CDW_INPUT_LINE


#include "cdw_ncurses.h"


typedef struct  {
	WINDOW *parent;

	WINDOW *win;
	int n_cols;  /* width - number of columns of input field */
	/* no height field, it is always equal 1 */
	cdw_colors_t colors;

	int begin_y;
	int begin_x;

	int chars_max;  /* maximum number of chars that user can enter into input line */
	int input_type;

	FIELD *field[2];
	FORM *form;

	/* a hack: should input line driver save data from field buffer to data buffer? */
	bool save_on_tab;
} CDW_INPUT_LINE;



CDW_INPUT_LINE *cdw_input_line_new(WINDOW *parent, int begin_y, int begin_x, int n_cols, const char *initial_string, int input_type, int chars_max);
void            cdw_input_line_delete(CDW_INPUT_LINE **input_line);
int             cdw_input_line_driver(CDW_INPUT_LINE *input_line, char **buffer, int attempts_max);
void            cdw_input_line_refresh_with_string(CDW_INPUT_LINE *input_line, const char *string);


#endif /* #ifndef H_CDW_INPUT_LINE */

