/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2021 Univ. Grenoble Alpes, CNRS, Grenoble INP, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#ifndef EXTERNALSHAKER_H
#define EXTERNALSHAKER_H

#include <Action.h>
#include <MeshComponent.h>

#include <QTimer>
#include <QMutex>
#include <QElapsedTimer>
#include <vtkDoubleArray.h>

class ExternalShaker : public camitk::Action {
    Q_OBJECT

public:

    /// Default Constructor
    ExternalShaker(camitk::ActionExtension* extension);

    /// Default Destructor
    virtual ~ExternalShaker();

public slots:
    /** this method is automatically called when the action is triggered.
      * Call getTargets() method to get the list of components to use.
      * \note getTargets() is automatically filtered so that it only contains compatible components,
      * i.e., instances of MeshComponent (or a subclass).
      */
    virtual camitk::Action::ApplyStatus apply();

    /// move the points once (using external library)
    void animate();

private:
    /// timer that call process method regularly
    QTimer* processTimer;

    /// Mutex used for the 3D update
    QMutex* mutex;

    /// accumulate all the computation time in order to compute the FPS
    double elapsedTime;

    /// number of simulation
    long simulationCount;

    /// current mesh component
    camitk::MeshComponent* currentTarget;

    /// initial position of the point (so that we can compute total displacements)
    vtkSmartPointer<vtkPoints> initialPosition;

};

#endif // EXTERNALSHAKER_H

