/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include <MeshComponent.h>
#include <Log.h>
#include <Application.h>
using namespace camitk;

#include <vtkUnstructuredGrid.h>
#include <vtkGeometryFilter.h>
#include <vtkCleanPolyData.h>

#include "ExtractSurface.h"

// -------------------- ExtractSurface --------------------
ExtractSurface::ExtractSurface(ActionExtension* extension) : Action(extension) {
    this->setName("ExtractSurface");
    this->setDescription("Extract Surface from Volumetric Mesh");
    this->setComponent("MeshComponent");
    this->setFamily("Mesh Processing");
    this->addTag("ExtractSurface");
}

// --------------- apply -------------------
Action::ApplyStatus ExtractSurface::apply() {
    CAMITK_INFO("ExtractSurface", "apply", "Extracting Surface " << getTargets().last()->getName().toStdString());

    // set waiting cursor and status bar
    QApplication::setOverrideCursor ( QCursor ( Qt::WaitCursor ) );
    Application::showStatusBarMessage("Extracting Surface...");
    Application::resetProgressBar();

    // use the last target
    MeshComponent *targetMesh = dynamic_cast<MeshComponent*>(getTargets().last());

    vtkSmartPointer<vtkGeometryFilter> geometryFilter = vtkSmartPointer<vtkGeometryFilter>::New();
    vtkSmartPointer<vtkCleanPolyData> cleanFilter = vtkSmartPointer<vtkCleanPolyData>::New();
    
    geometryFilter->SetInput(targetMesh->getPointSet());
    cleanFilter->SetInputConnection(geometryFilter->GetOutputPort());
    cleanFilter->Update();
    
    // create a new mesh Component    
    new MeshComponent(cleanFilter->GetOutput(), targetMesh->getName() + " surface");
    Application::refresh();    

    // restore the normal cursor and progress bar
    Application::resetProgressBar();
    Application::showStatusBarMessage("");
    QApplication::restoreOverrideCursor();
    return SUCCESS;
}
