<?php
/**
 * Common parts for photos view
 *
 * This file is part of Zoph.
 *
 * Zoph is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Zoph is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with Zoph; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @package Zoph
 * @author Jeroen Roos
 */

namespace photos\view;

use search;
use user;

use conf\conf;
use photos\params;
use web\request;

/**
 * This is a base view for the photos page, that contains common parts for all views
 */
abstract class view {

    /** * @var array request variables */
    protected $vars;
    /** * @var request web request */
    protected $request;
    /** * @var photos\params interface data for page */
    protected $params;

    /**
     * Create view
     * @param request web request
     */
    public function __construct(request $request, params $params) {
        $this->request=$request;
        $this->vars=$request->getRequestVars();
        $this->params=$params;
    }

    /**
     * Get actionlinks
     */
    protected function getActionlinks() {
        $user=user::getCurrent();
        $qs=$this->request->getQueryString();
        $actionlinks=array();
        if ($this->vars["_action"] ?? "display" == "search") {
            $search = new search();
            $search->setSearchURL($this->request);
            $actionlinks[translate("save search")] = "search.php?_action=new&_qs=" . $search->getSearchQS();
        }
        if ($user->isAdmin()) {
            $actionlinks[translate("edit")] = "edit_photos.php?" . $qs;
            $actionlinks[translate("geotag")] = "tracks.php?_action=geotag&" . $qs;
        }

        $actionlinks[translate("slideshow")] = "slideshow.php?" . $qs;

        if (conf::get("feature.download") && ($user->get("download") || $user->isAdmin())) {
            $actionlinks[translate("download")] = "download.php?" . $qs;
        }
        return $actionlinks;
    }

    /**
     * Output view
     */
    abstract public function view();

    /**
     * Get the title for this view
     */
    public function getTitle() {
        return $this->params->title;
    }
}
