/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto;

import java.util.Random;
import net.lingala.zip4j.crypto.AesCipherUtil;
import net.lingala.zip4j.crypto.Encrypter;
import net.lingala.zip4j.crypto.PBKDF2.MacBasedPRF;
import net.lingala.zip4j.crypto.PBKDF2.PBKDF2Engine;
import net.lingala.zip4j.crypto.PBKDF2.PBKDF2Parameters;
import net.lingala.zip4j.crypto.engine.AESEngine;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.enums.AesKeyStrength;

public class AESEncrpyter
implements Encrypter {
    private static final int PASSWORD_VERIFIER_LENGTH = 2;
    private char[] password;
    private AesKeyStrength aesKeyStrength;
    private AESEngine aesEngine;
    private MacBasedPRF mac;
    private boolean finished;
    private int nonce = 1;
    private int loopCount = 0;
    private byte[] iv;
    private byte[] counterBlock;
    private byte[] derivedPasswordVerifier;
    private byte[] saltBytes;

    public AESEncrpyter(char[] password, AesKeyStrength aesKeyStrength) throws ZipException {
        if (password == null || password.length == 0) {
            throw new ZipException("input password is empty or null");
        }
        if (aesKeyStrength != AesKeyStrength.KEY_STRENGTH_128 && aesKeyStrength != AesKeyStrength.KEY_STRENGTH_256) {
            throw new ZipException("Invalid AES key strength");
        }
        this.password = password;
        this.aesKeyStrength = aesKeyStrength;
        this.finished = false;
        this.counterBlock = new byte[16];
        this.iv = new byte[16];
        this.init();
    }

    private void init() throws ZipException {
        int keyLength = this.aesKeyStrength.getKeyLength();
        int macLength = this.aesKeyStrength.getMacLength();
        int saltLength = this.aesKeyStrength.getSaltLength();
        this.saltBytes = AESEncrpyter.generateSalt(saltLength);
        byte[] keyBytes = this.deriveKey(this.saltBytes, this.password, keyLength, macLength);
        if (keyBytes == null || keyBytes.length != keyLength + macLength + 2) {
            throw new ZipException("invalid key generated, cannot decrypt file");
        }
        byte[] aesKey = new byte[keyLength];
        byte[] macKey = new byte[macLength];
        this.derivedPasswordVerifier = new byte[2];
        System.arraycopy(keyBytes, 0, aesKey, 0, keyLength);
        System.arraycopy(keyBytes, keyLength, macKey, 0, macLength);
        System.arraycopy(keyBytes, keyLength + macLength, this.derivedPasswordVerifier, 0, 2);
        this.aesEngine = new AESEngine(aesKey);
        this.mac = new MacBasedPRF("HmacSHA1");
        this.mac.init(macKey);
    }

    private byte[] deriveKey(byte[] salt, char[] password, int keyLength, int macLength) throws ZipException {
        try {
            PBKDF2Parameters p = new PBKDF2Parameters("HmacSHA1", "ISO-8859-1", salt, 1000);
            PBKDF2Engine e = new PBKDF2Engine(p);
            byte[] derivedKey = e.deriveKey(password, keyLength + macLength + 2);
            return derivedKey;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    @Override
    public int encryptData(byte[] buff) throws ZipException {
        if (buff == null) {
            throw new ZipException("input bytes are null, cannot perform AES encrpytion");
        }
        return this.encryptData(buff, 0, buff.length);
    }

    @Override
    public int encryptData(byte[] buff, int start, int len) throws ZipException {
        if (this.finished) {
            throw new ZipException("AES Encrypter is in finished state (A non 16 byte block has already been passed to encrypter)");
        }
        if (len % 16 != 0) {
            this.finished = true;
        }
        for (int j = start; j < start + len; j += 16) {
            this.loopCount = j + 16 <= start + len ? 16 : start + len - j;
            AesCipherUtil.prepareBuffAESIVBytes(this.iv, this.nonce);
            this.aesEngine.processBlock(this.iv, this.counterBlock);
            for (int k = 0; k < this.loopCount; ++k) {
                buff[j + k] = (byte)(buff[j + k] ^ this.counterBlock[k]);
            }
            this.mac.update(buff, j, this.loopCount);
            ++this.nonce;
        }
        return len;
    }

    private static byte[] generateSalt(int size) throws ZipException {
        if (size != 8 && size != 16) {
            throw new ZipException("invalid salt size, cannot generate salt");
        }
        int rounds = 0;
        if (size == 8) {
            rounds = 2;
        }
        if (size == 16) {
            rounds = 4;
        }
        byte[] salt = new byte[size];
        for (int j = 0; j < rounds; ++j) {
            Random rand = new Random();
            int i = rand.nextInt();
            salt[0 + j * 4] = (byte)(i >> 24);
            salt[1 + j * 4] = (byte)(i >> 16);
            salt[2 + j * 4] = (byte)(i >> 8);
            salt[3 + j * 4] = (byte)i;
        }
        return salt;
    }

    public byte[] getFinalMac() {
        byte[] rawMacBytes = this.mac.doFinal();
        byte[] macBytes = new byte[10];
        System.arraycopy(rawMacBytes, 0, macBytes, 0, 10);
        return macBytes;
    }

    public byte[] getDerivedPasswordVerifier() {
        return this.derivedPasswordVerifier;
    }

    public byte[] getSaltBytes() {
        return this.saltBytes;
    }
}

