/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.converters;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.LeaseInfo;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.converters.Auto;
import com.netflix.discovery.converters.EnumLookup;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.util.DeserializerStringCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vlsi.utils.CompactHashMap;

public class EurekaJacksonCodec {
    private static final Logger logger = LoggerFactory.getLogger(EurekaJacksonCodec.class);
    private static final Version VERSION = new Version(1, 1, 0, null);
    public static final String NODE_LEASE = "leaseInfo";
    public static final String NODE_METADATA = "metadata";
    public static final String NODE_DATACENTER = "dataCenterInfo";
    public static final String NODE_APP = "application";
    protected static final String ELEM_INSTANCE = "instance";
    protected static final String ELEM_OVERRIDDEN_STATUS = "overriddenStatus";
    protected static final String ELEM_OVERRIDDEN_STATUS_LEGACY = "overriddenstatus";
    protected static final String ELEM_HOST = "hostName";
    protected static final String ELEM_INSTANCE_ID = "instanceId";
    protected static final String ELEM_APP = "app";
    protected static final String ELEM_IP = "ipAddr";
    protected static final String ELEM_SID = "sid";
    protected static final String ELEM_STATUS = "status";
    protected static final String ELEM_PORT = "port";
    protected static final String ELEM_SECURE_PORT = "securePort";
    protected static final String ELEM_COUNTRY_ID = "countryId";
    protected static final String ELEM_IDENTIFYING_ATTR = "identifyingAttribute";
    protected static final String ELEM_HEALTHCHECKURL = "healthCheckUrl";
    protected static final String ELEM_SECHEALTHCHECKURL = "secureHealthCheckUrl";
    protected static final String ELEM_APPGROUPNAME = "appGroupName";
    protected static final String ELEM_HOMEPAGEURL = "homePageUrl";
    protected static final String ELEM_STATUSPAGEURL = "statusPageUrl";
    protected static final String ELEM_VIPADDRESS = "vipAddress";
    protected static final String ELEM_SECVIPADDRESS = "secureVipAddress";
    protected static final String ELEM_ISCOORDINATINGDISCSOERVER = "isCoordinatingDiscoveryServer";
    protected static final String ELEM_LASTUPDATEDTS = "lastUpdatedTimestamp";
    protected static final String ELEM_LASTDIRTYTS = "lastDirtyTimestamp";
    protected static final String ELEM_ACTIONTYPE = "actionType";
    protected static final String ELEM_ASGNAME = "asgName";
    protected static final String ELEM_NAME = "name";
    protected static final String DATACENTER_METADATA = "metadata";
    protected static final String VERSIONS_DELTA_TEMPLATE = "versions_delta";
    protected static final String APPS_HASHCODE_TEMPTE = "apps_hashcode";
    public static EurekaJacksonCodec INSTANCE = new EurekaJacksonCodec();
    public static final Supplier<? extends Map<String, String>> METADATA_MAP_SUPPLIER;
    private final String versionDeltaKey;
    private final String appHashCodeKey;
    private final ObjectMapper mapper;
    private final Map<Class<?>, Supplier<ObjectReader>> objectReaderByClass;
    private final Map<Class<?>, ObjectWriter> objectWriterByClass;

    static EurekaClientConfig loadConfig() {
        return DiscoveryManager.getInstance().getEurekaClientConfig();
    }

    public EurekaJacksonCodec() {
        this(EurekaJacksonCodec.formatKey(EurekaJacksonCodec.loadConfig(), VERSIONS_DELTA_TEMPLATE), EurekaJacksonCodec.formatKey(EurekaJacksonCodec.loadConfig(), APPS_HASHCODE_TEMPTE));
    }

    public EurekaJacksonCodec(String versionDeltaKey, String appsHashCodeKey) {
        this.versionDeltaKey = versionDeltaKey;
        this.appHashCodeKey = appsHashCodeKey;
        this.mapper = new ObjectMapper();
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        SimpleModule module = new SimpleModule("eureka1.x", VERSION);
        module.addSerializer(DataCenterInfo.class, (JsonSerializer)new DataCenterInfoSerializer());
        module.addSerializer(InstanceInfo.class, (JsonSerializer)new InstanceInfoSerializer());
        module.addSerializer(Application.class, (JsonSerializer)new ApplicationSerializer());
        module.addSerializer(Applications.class, (JsonSerializer)new ApplicationsSerializer(this.versionDeltaKey, this.appHashCodeKey));
        module.addDeserializer(LeaseInfo.class, (JsonDeserializer)new LeaseInfoDeserializer());
        module.addDeserializer(InstanceInfo.class, (JsonDeserializer)new InstanceInfoDeserializer(this.mapper));
        module.addDeserializer(Application.class, (JsonDeserializer)new ApplicationDeserializer(this.mapper));
        module.addDeserializer(Applications.class, (JsonDeserializer)new ApplicationsDeserializer(this.mapper, this.versionDeltaKey, this.appHashCodeKey));
        this.mapper.registerModule((Module)module);
        HashMap readers = new HashMap();
        readers.put(InstanceInfo.class, () -> this.mapper.reader().forType(InstanceInfo.class).withRootName(ELEM_INSTANCE));
        readers.put(Application.class, () -> this.mapper.reader().forType(Application.class).withRootName(NODE_APP));
        readers.put(Applications.class, () -> this.mapper.reader().forType(Applications.class).withRootName("applications"));
        this.objectReaderByClass = readers;
        HashMap writers = new HashMap();
        writers.put(InstanceInfo.class, this.mapper.writer().forType(InstanceInfo.class).withRootName(ELEM_INSTANCE));
        writers.put(Application.class, this.mapper.writer().forType(Application.class).withRootName(NODE_APP));
        writers.put(Applications.class, this.mapper.writer().forType(Applications.class).withRootName("applications"));
        this.objectWriterByClass = writers;
    }

    protected ObjectMapper getMapper() {
        return this.mapper;
    }

    protected String getVersionDeltaKey() {
        return this.versionDeltaKey;
    }

    protected String getAppHashCodeKey() {
        return this.appHashCodeKey;
    }

    protected static String formatKey(EurekaClientConfig clientConfig, String keyTemplate) {
        String replacement = clientConfig == null ? "__" : clientConfig.getEscapeCharReplacement();
        StringBuilder sb = new StringBuilder(keyTemplate.length() + 1);
        for (char c : keyTemplate.toCharArray()) {
            if (c == '_') {
                sb.append(replacement);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readValue(Class<T> type, InputStream entityStream) throws IOException {
        ObjectReader reader = DeserializerStringCache.init(Optional.ofNullable(this.objectReaderByClass.get(type)).map(Supplier::get).orElseGet(() -> this.mapper.readerFor(type)));
        try {
            Object object = reader.readValue(entityStream);
            return (T)object;
        }
        finally {
            DeserializerStringCache.clear(reader, DeserializerStringCache.CacheScope.GLOBAL_SCOPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readValue(Class<T> type, String text) throws IOException {
        ObjectReader reader = DeserializerStringCache.init(Optional.ofNullable(this.objectReaderByClass.get(type)).map(Supplier::get).orElseGet(() -> this.mapper.readerFor(type)));
        try {
            Object object = reader.readValue(text);
            return (T)object;
        }
        finally {
            DeserializerStringCache.clear(reader, DeserializerStringCache.CacheScope.GLOBAL_SCOPE);
        }
    }

    public <T> void writeTo(T object, OutputStream entityStream) throws IOException {
        ObjectWriter writer = this.objectWriterByClass.get(object.getClass());
        if (writer == null) {
            this.mapper.writeValue(entityStream, object);
        } else {
            writer.writeValue(entityStream, object);
        }
    }

    public <T> String writeToString(T object) {
        try {
            ObjectWriter writer = this.objectWriterByClass.get(object.getClass());
            if (writer == null) {
                return this.mapper.writeValueAsString(object);
            }
            return writer.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot encode provided object", e);
        }
    }

    public static EurekaJacksonCodec getInstance() {
        return INSTANCE;
    }

    public static void setInstance(EurekaJacksonCodec instance) {
        INSTANCE = instance;
    }

    private static void tryCatchLog(Callable<Void> callable) {
        try {
            callable.call();
        }
        catch (Exception ex) {
            logger.error("Error in unmarshalling the object:", (Throwable)ex);
        }
    }

    static {
        boolean useCompact = true;
        try {
            Class.forName("vlsi.utils.CompactHashMap");
        }
        catch (ClassNotFoundException e) {
            useCompact = false;
        }
        METADATA_MAP_SUPPLIER = useCompact ? CompactHashMap::new : HashMap::new;
    }

    public static class ApplicationsDeserializer
    extends JsonDeserializer<Applications> {
        protected ObjectMapper mapper;
        protected String versionDeltaKey;
        protected String appHashCodeKey;

        public ApplicationsDeserializer(ObjectMapper mapper, String versionDeltaKey, String appHashCodeKey) {
            this.mapper = mapper;
            this.versionDeltaKey = versionDeltaKey;
            this.appHashCodeKey = appHashCodeKey;
        }

        public Applications deserialize(JsonParser jp, DeserializationContext context) throws IOException {
            JsonToken jsonToken;
            if (Thread.currentThread().isInterrupted()) {
                throw new JsonParseException(jp, "processing aborted");
            }
            Applications apps = new Applications();
            while ((jsonToken = jp.nextToken()) != JsonToken.END_OBJECT) {
                if (JsonToken.FIELD_NAME != jsonToken) continue;
                String fieldName = jp.getCurrentName();
                jsonToken = jp.nextToken();
                if (this.versionDeltaKey.equals(fieldName)) {
                    apps.setVersion(jp.getValueAsLong());
                    continue;
                }
                if (this.appHashCodeKey.equals(fieldName)) {
                    apps.setAppsHashCode(jp.getValueAsString());
                    continue;
                }
                if (!EurekaJacksonCodec.NODE_APP.equals(fieldName)) continue;
                ObjectReader applicationReader = DeserializerStringCache.init(this.mapper.readerFor(Application.class), context);
                if (jsonToken == JsonToken.START_ARRAY) {
                    while (jp.nextToken() != JsonToken.END_ARRAY) {
                        apps.addApplication((Application)applicationReader.readValue(jp));
                    }
                    continue;
                }
                if (jsonToken != JsonToken.START_OBJECT) continue;
                apps.addApplication((Application)applicationReader.readValue(jp));
            }
            return apps;
        }
    }

    public static class ApplicationsSerializer
    extends JsonSerializer<Applications> {
        protected String versionDeltaKey;
        protected String appHashCodeKey;

        public ApplicationsSerializer(String versionDeltaKey, String appHashCodeKey) {
            this.versionDeltaKey = versionDeltaKey;
            this.appHashCodeKey = appHashCodeKey;
        }

        public void serialize(Applications applications, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeStringField(this.versionDeltaKey, applications.getVersion().toString());
            jgen.writeStringField(this.appHashCodeKey, applications.getAppsHashCode());
            jgen.writeObjectField(EurekaJacksonCodec.NODE_APP, applications.getRegisteredApplications());
        }
    }

    public static class ApplicationDeserializer
    extends JsonDeserializer<Application> {
        private final ObjectMapper mapper;

        public ApplicationDeserializer(ObjectMapper mapper) {
            this.mapper = mapper;
        }

        public Application deserialize(JsonParser jp, DeserializationContext context) throws IOException {
            JsonToken jsonToken;
            if (Thread.currentThread().isInterrupted()) {
                throw new JsonParseException(jp, "processing aborted");
            }
            Application application = new Application();
            block4: while ((jsonToken = jp.nextToken()) != JsonToken.END_OBJECT) {
                if (JsonToken.FIELD_NAME != jsonToken) continue;
                ApplicationField field = ApplicationField.lookup.find(jp);
                jsonToken = jp.nextToken();
                if (field == null) continue;
                switch (field) {
                    case NAME: {
                        application.setName(jp.getText());
                        break;
                    }
                    case INSTANCE: {
                        ObjectReader instanceInfoReader = DeserializerStringCache.init(this.mapper.readerFor(InstanceInfo.class), context);
                        if (jsonToken == JsonToken.START_ARRAY) {
                            while (jp.nextToken() != JsonToken.END_ARRAY) {
                                application.addInstance((InstanceInfo)instanceInfoReader.readValue(jp));
                            }
                            continue block4;
                        }
                        if (jsonToken != JsonToken.START_OBJECT) break;
                        application.addInstance((InstanceInfo)instanceInfoReader.readValue(jp));
                    }
                }
            }
            return application;
        }

        static enum ApplicationField {
            NAME("name"),
            INSTANCE("instance");

            private final char[] fieldName;
            public static EnumLookup<ApplicationField> lookup;

            private ApplicationField(String name) {
                this.fieldName = name.toCharArray();
            }

            public char[] getFieldName() {
                return this.fieldName;
            }

            static {
                lookup = new EnumLookup<ApplicationField>(ApplicationField.class, ApplicationField::getFieldName);
            }
        }
    }

    public static class ApplicationSerializer
    extends JsonSerializer<Application> {
        public void serialize(Application value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeStringField(EurekaJacksonCodec.ELEM_NAME, value.getName());
            jgen.writeObjectField(EurekaJacksonCodec.ELEM_INSTANCE, value.getInstances());
            jgen.writeEndObject();
        }
    }

    public static class InstanceInfoDeserializer
    extends JsonDeserializer<InstanceInfo> {
        private static char[] BUF_AT_CLASS = "@class".toCharArray();
        private final ObjectMapper mapper;
        private final ConcurrentMap<String, BiConsumer<Object, String>> autoUnmarshalActions = new ConcurrentHashMap<String, BiConsumer<Object, String>>();
        private static EnumLookup<InstanceInfo.InstanceStatus> statusLookup = new EnumLookup<InstanceInfo.InstanceStatus>(InstanceInfo.InstanceStatus.class);
        private static EnumLookup<InstanceInfo.ActionType> actionTypeLookup = new EnumLookup<InstanceInfo.ActionType>(InstanceInfo.ActionType.class);
        static Set<String> globalCachedMetadata = new HashSet<String>();
        static final Function<String, String> self;

        protected InstanceInfoDeserializer(ObjectMapper mapper) {
            this.mapper = mapper;
        }

        public InstanceInfo deserialize(JsonParser jp, DeserializationContext context) throws IOException {
            JsonToken jsonToken;
            if (Thread.currentThread().isInterrupted()) {
                throw new JsonParseException(jp, "processing aborted");
            }
            DeserializerStringCache intern = DeserializerStringCache.from(context);
            InstanceInfo.Builder builder = InstanceInfo.Builder.newBuilder(self);
            block37: while ((jsonToken = jp.nextToken()) != JsonToken.END_OBJECT) {
                InstanceInfoField instanceInfoField = InstanceInfoField.lookup.find(jp);
                jsonToken = jp.nextToken();
                if (instanceInfoField != null && jsonToken != JsonToken.VALUE_NULL) {
                    switch (instanceInfoField) {
                        case HOSTNAME: {
                            builder.setHostName(intern.apply(jp));
                            continue block37;
                        }
                        case INSTANCE_ID: {
                            builder.setInstanceId(intern.apply(jp));
                            continue block37;
                        }
                        case APP: {
                            builder.setAppNameForDeser(intern.apply(jp, DeserializerStringCache.CacheScope.APPLICATION_SCOPE, () -> {
                                try {
                                    return jp.getText().toUpperCase();
                                }
                                catch (IOException e) {
                                    throw new RuntimeJsonMappingException(e.getMessage());
                                }
                            }));
                            continue block37;
                        }
                        case IP: {
                            builder.setIPAddr(intern.apply(jp));
                            continue block37;
                        }
                        case SID: {
                            builder.setSID(intern.apply(jp, DeserializerStringCache.CacheScope.GLOBAL_SCOPE));
                            continue block37;
                        }
                        case ID_ATTR: {
                            continue block37;
                        }
                        case STATUS: {
                            builder.setStatus(statusLookup.find(jp, InstanceInfo.InstanceStatus.UNKNOWN));
                            continue block37;
                        }
                        case OVERRIDDEN_STATUS: {
                            builder.setOverriddenStatus(statusLookup.find(jp, InstanceInfo.InstanceStatus.UNKNOWN));
                            continue block37;
                        }
                        case OVERRIDDEN_STATUS_LEGACY: {
                            builder.setOverriddenStatus(statusLookup.find(jp, InstanceInfo.InstanceStatus.UNKNOWN));
                            continue block37;
                        }
                        case PORT: {
                            PortField field;
                            while ((jsonToken = jp.nextToken()) != JsonToken.END_OBJECT) {
                                field = PortField.lookup.find(jp);
                                switch (field) {
                                    case PORT: {
                                        if (jsonToken == JsonToken.FIELD_NAME) {
                                            jp.nextToken();
                                        }
                                        builder.setPort(jp.getValueAsInt());
                                        break;
                                    }
                                    case ENABLED: {
                                        if (jsonToken == JsonToken.FIELD_NAME) {
                                            jp.nextToken();
                                        }
                                        builder.enablePort(InstanceInfo.PortType.UNSECURE, jp.getValueAsBoolean());
                                        break;
                                    }
                                }
                            }
                            continue block37;
                        }
                        case SECURE_PORT: {
                            PortField field;
                            while ((jsonToken = jp.nextToken()) != JsonToken.END_OBJECT) {
                                field = PortField.lookup.find(jp);
                                switch (field) {
                                    case PORT: {
                                        if (jsonToken == JsonToken.FIELD_NAME) {
                                            jp.nextToken();
                                        }
                                        builder.setSecurePort(jp.getValueAsInt());
                                        break;
                                    }
                                    case ENABLED: {
                                        if (jsonToken == JsonToken.FIELD_NAME) {
                                            jp.nextToken();
                                        }
                                        builder.enablePort(InstanceInfo.PortType.SECURE, jp.getValueAsBoolean());
                                        break;
                                    }
                                }
                            }
                            continue block37;
                        }
                        case COUNTRY_ID: {
                            builder.setCountryId(jp.getValueAsInt());
                            continue block37;
                        }
                        case DATACENTER: {
                            builder.setDataCenterInfo((DataCenterInfo)DeserializerStringCache.init(this.mapper.readerFor(DataCenterInfo.class), context).readValue(jp));
                            continue block37;
                        }
                        case LEASE: {
                            builder.setLeaseInfo((LeaseInfo)this.mapper.readerFor(LeaseInfo.class).readValue(jp));
                            continue block37;
                        }
                        case HEALTHCHECKURL: {
                            builder.setHealthCheckUrlsForDeser(intern.apply(jp.getText()), null);
                            continue block37;
                        }
                        case SECHEALTHCHECKURL: {
                            builder.setHealthCheckUrlsForDeser(null, intern.apply(jp.getText()));
                            continue block37;
                        }
                        case APPGROUPNAME: {
                            builder.setAppGroupNameForDeser(intern.apply(jp, DeserializerStringCache.CacheScope.GLOBAL_SCOPE, () -> {
                                try {
                                    return jp.getText().toUpperCase();
                                }
                                catch (IOException e) {
                                    throw new RuntimeJsonMappingException(e.getMessage());
                                }
                            }));
                            continue block37;
                        }
                        case HOMEPAGEURL: {
                            builder.setHomePageUrlForDeser(intern.apply(jp.getText()));
                            continue block37;
                        }
                        case STATUSPAGEURL: {
                            builder.setStatusPageUrlForDeser(intern.apply(jp.getText()));
                            continue block37;
                        }
                        case VIPADDRESS: {
                            builder.setVIPAddressDeser(intern.apply(jp));
                            continue block37;
                        }
                        case SECVIPADDRESS: {
                            builder.setSecureVIPAddressDeser(intern.apply(jp));
                            continue block37;
                        }
                        case ISCOORDINATINGDISCSERVER: {
                            builder.setIsCoordinatingDiscoveryServer(jp.getValueAsBoolean());
                            continue block37;
                        }
                        case LASTUPDATEDTS: {
                            builder.setLastUpdatedTimestamp(jp.getValueAsLong());
                            continue block37;
                        }
                        case LASTDIRTYTS: {
                            builder.setLastDirtyTimestamp(jp.getValueAsLong());
                            continue block37;
                        }
                        case ACTIONTYPE: {
                            builder.setActionType(actionTypeLookup.find(jp.getTextCharacters(), jp.getTextOffset(), jp.getTextLength()));
                            continue block37;
                        }
                        case ASGNAME: {
                            builder.setASGName(intern.apply(jp));
                            continue block37;
                        }
                        case METADATA: {
                            Map<String, String> metadataMap = null;
                            while ((jsonToken = jp.nextToken()) != JsonToken.END_OBJECT) {
                                char[] parserChars = jp.getTextCharacters();
                                if (parserChars[0] == '@' && EnumLookup.equals(BUF_AT_CLASS, parserChars, jp.getTextOffset(), jp.getTextLength())) {
                                    jsonToken = jp.nextToken();
                                    continue;
                                }
                                String key = intern.apply(jp, DeserializerStringCache.CacheScope.GLOBAL_SCOPE);
                                jsonToken = jp.nextToken();
                                String value = intern.apply(jp, DeserializerStringCache.CacheScope.APPLICATION_SCOPE);
                                metadataMap = Optional.ofNullable(metadataMap).orElseGet(METADATA_MAP_SUPPLIER);
                                metadataMap.put(key, value);
                            }
                            builder.setMetadata(metadataMap == null ? Collections.emptyMap() : metadataMap);
                            continue block37;
                        }
                    }
                    this.autoUnmarshalEligible(jp.getCurrentName(), jp.getValueAsString(), builder.getRawInstance());
                    continue;
                }
                this.autoUnmarshalEligible(jp.getCurrentName(), jp.getValueAsString(), builder.getRawInstance());
            }
            return builder.build();
        }

        void autoUnmarshalEligible(String fieldName, String value, Object o) {
            if (value == null || o == null) {
                return;
            }
            Class<?> c = o.getClass();
            String cacheKey = c.getName() + ":" + fieldName;
            BiConsumer action = this.autoUnmarshalActions.computeIfAbsent(cacheKey, k -> {
                try {
                    Field f = null;
                    try {
                        f = c.getDeclaredField(fieldName);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                    if (f == null) {
                        return (t, v) -> {};
                    }
                    Auto annotation = f.getAnnotation(Auto.class);
                    if (annotation == null) {
                        return (t, v) -> {};
                    }
                    f.setAccessible(true);
                    Field setterField = f;
                    Class<?> returnClass = setterField.getType();
                    if (!String.class.equals(returnClass)) {
                        Method method = returnClass.getDeclaredMethod("valueOf", String.class);
                        return (t, v) -> EurekaJacksonCodec.tryCatchLog(() -> {
                            setterField.set(t, method.invoke((Object)returnClass, v));
                            return null;
                        });
                    }
                    return (t, v) -> EurekaJacksonCodec.tryCatchLog(() -> {
                        setterField.set(t, v);
                        return null;
                    });
                }
                catch (Exception ex) {
                    logger.error("Error in unmarshalling the object:", (Throwable)ex);
                    return null;
                }
            });
            action.accept(o, value);
        }

        static {
            globalCachedMetadata.add("route53Type");
            globalCachedMetadata.add("enableRoute53");
            globalCachedMetadata.add("netflix.stack");
            globalCachedMetadata.add("netflix.detail");
            globalCachedMetadata.add("NETFLIX_ENVIRONMENT");
            globalCachedMetadata.add("transportPort");
            self = s -> s;
        }

        static enum PortField {
            PORT("$"),
            ENABLED("@enabled");

            private final char[] fieldName;
            public static EnumLookup<PortField> lookup;

            private PortField(String name) {
                this.fieldName = name.toCharArray();
            }

            public char[] getFieldName() {
                return this.fieldName;
            }

            static {
                lookup = new EnumLookup<PortField>(PortField.class, PortField::getFieldName);
            }
        }

        static enum InstanceInfoField {
            HOSTNAME("hostName"),
            INSTANCE_ID("instanceId"),
            APP("app"),
            IP("ipAddr"),
            SID("sid"),
            ID_ATTR("identifyingAttribute"),
            STATUS("status"),
            OVERRIDDEN_STATUS("overriddenStatus"),
            OVERRIDDEN_STATUS_LEGACY("overriddenstatus"),
            PORT("port"),
            SECURE_PORT("securePort"),
            COUNTRY_ID("countryId"),
            DATACENTER("dataCenterInfo"),
            LEASE("leaseInfo"),
            HEALTHCHECKURL("healthCheckUrl"),
            SECHEALTHCHECKURL("secureHealthCheckUrl"),
            APPGROUPNAME("appGroupName"),
            HOMEPAGEURL("homePageUrl"),
            STATUSPAGEURL("statusPageUrl"),
            VIPADDRESS("vipAddress"),
            SECVIPADDRESS("secureVipAddress"),
            ISCOORDINATINGDISCSERVER("isCoordinatingDiscoveryServer"),
            LASTUPDATEDTS("lastUpdatedTimestamp"),
            LASTDIRTYTS("lastDirtyTimestamp"),
            ACTIONTYPE("actionType"),
            ASGNAME("asgName"),
            METADATA("metadata");

            private final char[] elementName;
            public static EnumLookup<InstanceInfoField> lookup;

            private InstanceInfoField(String elementName) {
                this.elementName = elementName.toCharArray();
            }

            public char[] getElementName() {
                return this.elementName;
            }

            static {
                lookup = new EnumLookup<InstanceInfoField>(InstanceInfoField.class, InstanceInfoField::getElementName);
            }
        }
    }

    public static class InstanceInfoSerializer
    extends JsonSerializer<InstanceInfo> {
        public static final String METADATA_COMPATIBILITY_KEY = "@class";
        public static final String METADATA_COMPATIBILITY_VALUE = "java.util.Collections$EmptyMap";
        protected static final Object EMPTY_METADATA = Collections.singletonMap("@class", "java.util.Collections$EmptyMap");

        public void serialize(InstanceInfo info, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            Map<String, String> metadata;
            jgen.writeStartObject();
            if (info.getInstanceId() != null) {
                jgen.writeStringField(EurekaJacksonCodec.ELEM_INSTANCE_ID, info.getInstanceId());
            }
            jgen.writeStringField(EurekaJacksonCodec.ELEM_HOST, info.getHostName());
            jgen.writeStringField(EurekaJacksonCodec.ELEM_APP, info.getAppName());
            jgen.writeStringField(EurekaJacksonCodec.ELEM_IP, info.getIPAddr());
            String sid = info.getSID();
            if (!"unknown".equals(sid) && !"na".equals(sid)) {
                jgen.writeStringField(EurekaJacksonCodec.ELEM_SID, sid);
            }
            jgen.writeStringField(EurekaJacksonCodec.ELEM_STATUS, info.getStatus().name());
            jgen.writeStringField(EurekaJacksonCodec.ELEM_OVERRIDDEN_STATUS, info.getOverriddenStatus().name());
            jgen.writeFieldName(EurekaJacksonCodec.ELEM_PORT);
            jgen.writeStartObject();
            jgen.writeNumberField("$", info.getPort());
            jgen.writeStringField("@enabled", Boolean.toString(info.isPortEnabled(InstanceInfo.PortType.UNSECURE)));
            jgen.writeEndObject();
            jgen.writeFieldName(EurekaJacksonCodec.ELEM_SECURE_PORT);
            jgen.writeStartObject();
            jgen.writeNumberField("$", info.getSecurePort());
            jgen.writeStringField("@enabled", Boolean.toString(info.isPortEnabled(InstanceInfo.PortType.SECURE)));
            jgen.writeEndObject();
            jgen.writeNumberField(EurekaJacksonCodec.ELEM_COUNTRY_ID, info.getCountryId());
            if (info.getDataCenterInfo() != null) {
                jgen.writeObjectField(EurekaJacksonCodec.NODE_DATACENTER, (Object)info.getDataCenterInfo());
            }
            if (info.getLeaseInfo() != null) {
                jgen.writeObjectField(EurekaJacksonCodec.NODE_LEASE, (Object)info.getLeaseInfo());
            }
            if ((metadata = info.getMetadata()) != null) {
                if (metadata.isEmpty()) {
                    jgen.writeObjectField("metadata", EMPTY_METADATA);
                } else {
                    jgen.writeObjectField("metadata", metadata);
                }
            }
            this.autoMarshalEligible(info, jgen);
            jgen.writeEndObject();
        }

        protected void autoMarshalEligible(Object o, JsonGenerator jgen) {
            try {
                Field[] fields;
                Class<?> c = o.getClass();
                for (Field f : fields = c.getDeclaredFields()) {
                    Auto annotation = f.getAnnotation(Auto.class);
                    if (annotation == null) continue;
                    f.setAccessible(true);
                    if (f.get(o) == null) continue;
                    jgen.writeStringField(f.getName(), String.valueOf(f.get(o)));
                }
            }
            catch (Throwable th) {
                logger.error("Error in marshalling the object", th);
            }
        }
    }

    public static class LeaseInfoDeserializer
    extends JsonDeserializer<LeaseInfo> {
        private static EnumLookup<LeaseInfoField> fieldLookup = new EnumLookup<LeaseInfoField>(LeaseInfoField.class, LeaseInfoField::getFieldName);

        public LeaseInfo deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonToken jsonToken;
            LeaseInfo.Builder builder = LeaseInfo.Builder.newBuilder();
            while ((jsonToken = jp.nextToken()) != JsonToken.END_OBJECT) {
                LeaseInfoField field = fieldLookup.find(jp);
                jsonToken = jp.nextToken();
                if (field == null || jsonToken == JsonToken.VALUE_NULL) continue;
                switch (field) {
                    case DURATION: {
                        builder.setDurationInSecs(jp.getValueAsInt());
                        break;
                    }
                    case EVICTION_TIMESTAMP: {
                        builder.setEvictionTimestamp(jp.getValueAsLong());
                        break;
                    }
                    case LAST_RENEW_TIMESTAMP: {
                        builder.setRenewalTimestamp(jp.getValueAsLong());
                        break;
                    }
                    case REG_TIMESTAMP: {
                        builder.setRegistrationTimestamp(jp.getValueAsLong());
                        break;
                    }
                    case RENEW_INTERVAL: {
                        builder.setRenewalIntervalInSecs(jp.getValueAsInt());
                        break;
                    }
                    case SERVICE_UP_TIMESTAMP: {
                        builder.setServiceUpTimestamp(jp.getValueAsLong());
                    }
                }
            }
            return builder.build();
        }

        static enum LeaseInfoField {
            DURATION("durationInSecs"),
            EVICTION_TIMESTAMP("evictionTimestamp"),
            LAST_RENEW_TIMESTAMP("lastRenewalTimestamp"),
            REG_TIMESTAMP("registrationTimestamp"),
            RENEW_INTERVAL("renewalIntervalInSecs"),
            SERVICE_UP_TIMESTAMP("serviceUpTimestamp");

            private final char[] fieldName;

            private LeaseInfoField(String fieldName) {
                this.fieldName = fieldName.toCharArray();
            }

            public char[] getFieldName() {
                return this.fieldName;
            }
        }
    }

    public static class DataCenterInfoSerializer
    extends JsonSerializer<DataCenterInfo> {
        public void serializeWithType(DataCenterInfo dataCenterInfo, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            if (dataCenterInfo.getName() == DataCenterInfo.Name.Amazon) {
                jgen.writeStringField("@class", "com.netflix.appinfo.AmazonInfo");
            } else {
                jgen.writeStringField("@class", "com.netflix.appinfo.InstanceInfo$DefaultDataCenterInfo");
            }
            jgen.writeStringField(EurekaJacksonCodec.ELEM_NAME, dataCenterInfo.getName().name());
            if (dataCenterInfo.getName() == DataCenterInfo.Name.Amazon) {
                AmazonInfo aInfo = (AmazonInfo)dataCenterInfo;
                jgen.writeObjectField("metadata", aInfo.getMetadata());
            }
            jgen.writeEndObject();
        }

        public void serialize(DataCenterInfo dataCenterInfo, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            this.serializeWithType(dataCenterInfo, jgen, provider, null);
        }
    }
}

