#!/usr/bin/perl -w 

%consonants = (
	"k" => "0x0c95",
	"kh" => "0x0c96",
	"g" => "0x0c97",
	"gh" => "0x0c98",
	"N^" => "0x0c99",
	"~N" => "0x0c99",
	"c" => "0x0c9a",
	"ch" => "0x0c9a",
	"chh" => "0x0c9b",
	"Ch" => "0x0c9b",
	"j" => "0x0c9c",
	"jh" => "0x0c9d",
	"~n" => "0x0c9e",
	"JN" => "0x0c9e",
	"T" => "0x0c9f",
	"Th" => "0x0ca0",
	"D" => "0x0ca1",
	"Dh" => "0x0ca2",
	"N" => "0x0ca3",
	"t" => "0x0ca4",
	"th" => "0x0ca5",
	"d" => "0x0ca6",
	"dh" => "0x0ca7",
	"n" => "0x0ca8",
	"p" => "0x0caa",
	"ph" => "0x0cab",
	"b" => "0x0cac",
	"bh" => "0x0cad",
	"m" => "0x0cae",
	"y" => "0x0caf",
	"r" => "0x0cb0",
	"R" => "0x0cb1",
	"l" => "0x0cb2",
	"L" => "0x0cb3",
	"v" => "0x0cb5",
	"w" => "0x0cb5",
	"sh" => "0x0cb6",
	"shh" => "0x0cb7",
	"Sh" => "0x0cb7",
	"s" => "0x0cb8",
	"h" => "0x0cb9",
	"x" => "0x0c95 0x0ccd 0x0cb7",
	"GY" => "0x0c9c 0x0ccd 0x0c9e",
	"dny" => "0x0c9c 0x0ccd 0x0c9e",
);

%vowels = (
	"" => " 0x0ccd",
	"a" => "",
	"A" => " 0x0cbe",
	"aa" => " 0x0cbe",
	"i" => " 0x0cbf",
	"I" => " 0x0cc0",
	"ii" => " 0x0cc0",
	"u" => " 0x0cc1",
	"U" => " 0x0cc2",
	"uu" => " 0x0cc2",
	"R^i" => " 0x0cc3",
	"RRi" => " 0x0cc3",
	"R^I" => " 0x0cc4",
	"RRI" => " 0x0cc4",
	"e" => " 0x0cc6",
	"E" => " 0x0cc7",
	"ai" => " 0x0cc8",
	"o" => " 0x0cca",
	"O" => " 0x0ccb",
	"au" => " 0x0ccc",
	".h" => " 0x0ccd 0x200c",
);

print "// Kannada kmap according to Itrans transliteration\n";
print "// by Miikka-Markus Alhonen 2002-02-17\n";
print "// 2003-06-04 upgraded to Unicode 4.0\n\n";
print "// Consonant + vowel/virama\n";

foreach $cons (sort keys %consonants) {
  foreach $vowel (sort keys %vowels) {
    printf ("\"%s%s=%s%s\",\n",$cons,$vowel,$consonants{$cons},$vowels{$vowel});
  }
}

print <<EOF;

// Independent vowels

"a=0x0c85",
"A=0x0c86",
"aa=0x0c86",
"i=0x0c87",
"I=0x0c88",
"ii=0x0c88",
"u=0x0c89",
"U=0x0c8a",
"uu=0x0c8a",
"R^i=0x0c8b",
"RRi=0x0c8b",
"L^i=0x0c8c",
"LLi=0x0c8c",
"e=0x0c8e",
"E=0x0c8f",
"ai=0x0c90",
"o=0x0c92",
"O=0x0c93",
"au=0x0c94",
"R^I=0x0ce0",
"RRI=0x0ce0",
"L^I=0x0ce1",
"LLI=0x0ce1",

// Numbers

"0x30=0x0ce6",
"0x31=0x0ce7",
"0x32=0x0ce8",
"0x33=0x0ce9",
"0x34=0x0cea",
"0x35=0x0ceb",
"0x36=0x0cec",
"0x37=0x0ced",
"0x38=0x0cee",
"0x39=0x0cef",

// Other marks

".n=0x0c82",
"M=0x0c82",
"H=0x0c83",
".a=0x0cbd",
".h=0x0ccd 0x200c",
".=0x0964",
"..=0x0965",
"|=0x0964",
"||=0x0965",
";=0x0965",
"{\\\\rm 0x20 .}=0x002e",
"{}=0x200d",
EOF
