.TH yara 1 "September 22, 2008" "Victor M. Alvarez"
.SH NAME
yara \- find files matching patterns and rules written in a special-purpose language.
.SH SYNOPSIS
.B yara
[OPTION]... [RULEFILE]... FILE | PID
.SH DESCRIPTION
.I Yara
scans the given
.I FILE
or the process indentified by
.I PID
looking if it matches the patterns and rules provided in a special purpose-language. The rules are read from
.I RULEFILEs
or standard input.
.PP
The options to
.IR yara (1)
are:
.TP
.BI \-t " tag" " --tag=" tag
Print rules tagged as
.I tag
and ignore the rest. This option can be used multiple times.
.TP
.BI \-i " identifier" " --identifier=" identifier
Print rules named
.I identifier
and ignore the rest. This option can be used multiple times.
.TP
.B \-n " --negate"
Print rules that doesn't apply (negate)
.TP
.B \-D " --print-module-data"
Print module data.
.TP
.B \-g " --print-tags"
Print the tags associated to the rule.
.TP
.B \-m " --print-meta"
Print metadata associated to the rule.
.TP
.B \-s " --print-strings"
Print strings found in the file.
.TP
.BI \-p " number" " --threads=" number
Use the specified
.I number
of threads to scan a directory.
.TP
.BI \-l " number" " --max-rules=" number
Abort scanning after a
.I number
of rules matched.
.TP
.BI \-a " seconds" " --timeout=" seconds
Abort scanning after a number of
.I seconds
has elapsed.
.TP
.BI \-d " identifier"=value
Define an external variable. This option can be used multiple times.
.TP
.BI \-x " module"=file
Pass file's content as extra data to module. This option can be used multiple
times.
.TP
.B \-r " --recursive"
Scan files in directories recursively.
.TP
.B \-f " --fast-scan"
Speeds up scanning by searching only for the first occurrence of each pattern.
.TP
.B \-w " --no-warnings"
Disable warnings.
.TP
.B \-v " --version"
Show version information.
.SH EXAMPLES
$ yara /foo/bar/rules1 /foo/bar/rules2 .
.RS
.PP
Apply rules on
.I /foo/bar/rules1
and
.I /foo/bar/rules2
to all files on current directory. Subdirectories are not scanned.
.RE
.PP
$ yara -t Packer -t Compiler /foo/bar/rules bazfile
.RS
.PP
Apply rules on
.I /foo/bar/rules
to
.I bazfile.
Only reports rules tagged as
.I Packer
or
.I Compiler.
.RE
.PP
$ cat /foo/bar/rules1 | yara -r /foo
.RS
.PP
Scan all files in the
.I /foo
directory and its subdirectories. Rules are read from standard input.
.RE
.PP
$ yara -d mybool=true -d myint=5 -d mystring="my string" /foo/bar/rules bazfile
.RS
.PP
Defines three external variables
.I mybool
.I myint
and
.I mystring.
.RE
.PP
$ yara -x cuckoo=cuckoo_json_report /foo/bar/rules bazfile
.RS
.PP
Apply rules on
.I /foo/bar/rules
to
.I bazfile
while passing the content of
.I cuckoo_json_report
to the cuckoo module.
.RE

.SH AUTHOR
Victor M. Alvarez <plusvic@gmail.com>;<vmalvarez@virustotal.com>
