//////////////////////////////////////////////////////////////////////////////
// Name:        SVGPatternElement.h
// Author:      Alex Thuering
// Copyright:   (c) 2005 Alex Thuering
// Licence:     wxWindows licence
// Notes:       generated by generate.py
//////////////////////////////////////////////////////////////////////////////

#ifndef WX_SVG_PATTERN_ELEMENT_H
#define WX_SVG_PATTERN_ELEMENT_H

#include "SVGElement.h"
#include "SVGURIReference.h"
#include "SVGTests.h"
#include "SVGLangSpace.h"
#include "SVGExternalResourcesRequired.h"
#include "SVGStylable.h"
#include "SVGFitToViewBox.h"
#include "SVGUnitTypes.h"
#include "SVGAnimatedEnumeration.h"
#include "SVGAnimatedTransformList.h"
#include "SVGAnimatedLength.h"
#include "SVGSVGElement.h"
#include "String_wxsvg.h"
#include "Element.h"

class wxSVGPatternElement:
  public wxSVGElement,
  public wxSVGURIReference,
  public wxSVGTests,
  public wxSVGLangSpace,
  public wxSVGExternalResourcesRequired,
  public wxSVGStylable,
  public wxSVGFitToViewBox,
  public wxSVGUnitTypes
{
  protected:
    wxSVGAnimatedEnumeration m_patternUnits;
    wxSVGAnimatedEnumeration m_patternContentUnits;
    wxSVGAnimatedTransformList m_patternTransform;
    wxSVGAnimatedLength m_x;
    wxSVGAnimatedLength m_y;
    wxSVGAnimatedLength m_width;
    wxSVGAnimatedLength m_height;

  public:
    inline const wxSVGAnimatedEnumeration& GetPatternUnits() const { return m_patternUnits; }
    inline void SetPatternUnits(const wxSVGAnimatedEnumeration& n) { m_patternUnits = n; }
    inline void SetPatternUnits(unsigned char n) { m_patternUnits.SetBaseVal(n); }

    inline const wxSVGAnimatedEnumeration& GetPatternContentUnits() const { return m_patternContentUnits; }
    inline void SetPatternContentUnits(const wxSVGAnimatedEnumeration& n) { m_patternContentUnits = n; }
    inline void SetPatternContentUnits(unsigned char n) { m_patternContentUnits.SetBaseVal(n); }

    inline const wxSVGAnimatedTransformList& GetPatternTransform() const { return m_patternTransform; }
    inline void SetPatternTransform(const wxSVGAnimatedTransformList& n) { m_patternTransform = n; }
    inline void SetPatternTransform(const wxSVGTransformList& n) { m_patternTransform.SetBaseVal(n); }

    inline const wxSVGAnimatedLength& GetX() const { WX_SVG_ANIM_LENGTH_CALC_WIDTH(m_x, GetViewportElement()); return m_x; }
    inline void SetX(const wxSVGAnimatedLength& n) { m_x = n; }
    inline void SetX(const wxSVGLength& n) { m_x.SetBaseVal(n); }

    inline const wxSVGAnimatedLength& GetY() const { WX_SVG_ANIM_LENGTH_CALC_HEIGHT(m_y, GetViewportElement()); return m_y; }
    inline void SetY(const wxSVGAnimatedLength& n) { m_y = n; }
    inline void SetY(const wxSVGLength& n) { m_y.SetBaseVal(n); }

    inline const wxSVGAnimatedLength& GetWidth() const { WX_SVG_ANIM_LENGTH_CALC_WIDTH(m_width, GetViewportElement()); return m_width; }
    inline void SetWidth(const wxSVGAnimatedLength& n) { m_width = n; }
    inline void SetWidth(const wxSVGLength& n) { m_width.SetBaseVal(n); }

    inline const wxSVGAnimatedLength& GetHeight() const { WX_SVG_ANIM_LENGTH_CALC_HEIGHT(m_height, GetViewportElement()); return m_height; }
    inline void SetHeight(const wxSVGAnimatedLength& n) { m_height = n; }
    inline void SetHeight(const wxSVGLength& n) { m_height.SetBaseVal(n); }

  public:
    wxSVGPatternElement(wxString tagName = wxT("pattern")):
      wxSVGElement(tagName) {}
    virtual ~wxSVGPatternElement() {}
    wxSvgXmlNode* CloneNode(bool deep = true) { return new wxSVGPatternElement(*this); }
    bool HasAttribute(const wxString& name);
    wxString GetAttribute(const wxString& name);
    bool SetAttribute(const wxString& name, const wxString& value);
    wxSvgXmlAttrHash GetAttributes() const;
    virtual wxSVGDTD GetDtd() const { return wxSVG_PATTERN_ELEMENT; }
};

#endif // WX_SVG_PATTERN_ELEMENT_H
