// DBus-template.hh --- DBUS template
//
// Copyright (C) 2007, 2008, 2009, 2011 Rob Caelers <robc@krandor.nl>
// All rights reserved.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string>
#include <list>
#include <map>
#include <deque>

#include <stdlib.h>
#include <gio/gio.h>

#include "DBus-gio.hh"
#include "DBusBinding-gio.hh"
#include "DBusException.hh"
#include "DBusGUI.hh"

using namespace std;




#include "Menus.hh"

class org_workrave_ControlInterface_Stub : public DBusBindingBase, public org_workrave_ControlInterface
{
private:
  typedef void (org_workrave_ControlInterface_Stub::*DBusMethodPointer)(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);

  struct DBusMethod
  {
    const string name;
    DBusMethodPointer fn;
  };

  virtual void call(const std::string &method_name, void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);

  virtual const char *get_interface_introspect()
  {
    return interface_introspect;
  }

public:
  org_workrave_ControlInterface_Stub(DBus *dbus);
  ~org_workrave_ControlInterface_Stub();



private:
  void OpenMain(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);
  void Preferences(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);
  void NetworkConnect(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);
  void NetworkLog(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);
  void NetworkReconnect(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);
  void NetworkDisconnect(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);
  void ReadingMode(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);
  void Statistics(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);
  void Exercises(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);
  void RestBreak(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);
  void Quit(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);
  void About(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);





  static const DBusMethod method_table[];
  static const char *interface_introspect;
};


org_workrave_ControlInterface *org_workrave_ControlInterface::instance(const DBus *dbus)
{
  org_workrave_ControlInterface_Stub *iface = NULL;
  DBusBindingBase *binding = dbus->find_binding("org.workrave.ControlInterface");

  if (binding != NULL)
    {
      iface = dynamic_cast<org_workrave_ControlInterface_Stub *>(binding);
    }

  return iface;
}

org_workrave_ControlInterface_Stub::org_workrave_ControlInterface_Stub(DBus *dbus)
  : DBusBindingBase(dbus)
{
}

org_workrave_ControlInterface_Stub::~org_workrave_ControlInterface_Stub()
{
}

void
org_workrave_ControlInterface_Stub::call(const std::string &method_name, void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs)
{
  const DBusMethod *table = method_table;
  while (table->fn != NULL)
    {
      if (method_name == table->name)
        {
          DBusMethodPointer ptr = table->fn;
          if (ptr != NULL)
            {
              (this->*ptr)(object, invocation, sender, inargs);
            }
          return;
        }
      table++;
    }
  throw DBusUsageException(std::string("No such member:") + method_name );
}







void
org_workrave_ControlInterface_Stub::OpenMain(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs)
{
  (void) sender;

  try
    {
      Menus *dbus_object = (Menus *) object;


      gsize num_in_args = g_variant_n_children(inargs);
      if (num_in_args != 0)
        {
          throw DBusSystemException("Incorrect numer of in-parameters");
        }


      dbus_object->on_menu_open_main_window( 
      );

      GVariant *out = NULL;

      g_dbus_method_invocation_return_value(invocation, out);
    }
  catch (DBusException)
    {
      throw;
    }

}



void
org_workrave_ControlInterface_Stub::Preferences(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs)
{
  (void) sender;

  try
    {
      Menus *dbus_object = (Menus *) object;


      gsize num_in_args = g_variant_n_children(inargs);
      if (num_in_args != 0)
        {
          throw DBusSystemException("Incorrect numer of in-parameters");
        }


      dbus_object->on_menu_preferences( 
      );

      GVariant *out = NULL;

      g_dbus_method_invocation_return_value(invocation, out);
    }
  catch (DBusException)
    {
      throw;
    }

}



void
org_workrave_ControlInterface_Stub::NetworkConnect(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs)
{
  (void) sender;

  try
    {
      Menus *dbus_object = (Menus *) object;


      gsize num_in_args = g_variant_n_children(inargs);
      if (num_in_args != 0)
        {
          throw DBusSystemException("Incorrect numer of in-parameters");
        }


      dbus_object->on_menu_network_join( 
      );

      GVariant *out = NULL;

      g_dbus_method_invocation_return_value(invocation, out);
    }
  catch (DBusException)
    {
      throw;
    }

}



void
org_workrave_ControlInterface_Stub::NetworkLog(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs)
{
  (void) sender;

  try
    {
      Menus *dbus_object = (Menus *) object;

      bool p_show       ;

      gsize num_in_args = g_variant_n_children(inargs);
      if (num_in_args != 1)
        {
          throw DBusSystemException("Incorrect numer of in-parameters");
        }

      GVariant *v_show = g_variant_get_child_value(inargs, 0);
      get_bool(v_show, &p_show);

      dbus_object->on_menu_network_log( 
       p_show      );

      GVariant *out = NULL;

      g_dbus_method_invocation_return_value(invocation, out);
    }
  catch (DBusException)
    {
      throw;
    }

}



void
org_workrave_ControlInterface_Stub::NetworkReconnect(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs)
{
  (void) sender;

  try
    {
      Menus *dbus_object = (Menus *) object;


      gsize num_in_args = g_variant_n_children(inargs);
      if (num_in_args != 0)
        {
          throw DBusSystemException("Incorrect numer of in-parameters");
        }


      dbus_object->on_menu_network_reconnect( 
      );

      GVariant *out = NULL;

      g_dbus_method_invocation_return_value(invocation, out);
    }
  catch (DBusException)
    {
      throw;
    }

}



void
org_workrave_ControlInterface_Stub::NetworkDisconnect(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs)
{
  (void) sender;

  try
    {
      Menus *dbus_object = (Menus *) object;


      gsize num_in_args = g_variant_n_children(inargs);
      if (num_in_args != 0)
        {
          throw DBusSystemException("Incorrect numer of in-parameters");
        }


      dbus_object->on_menu_network_leave( 
      );

      GVariant *out = NULL;

      g_dbus_method_invocation_return_value(invocation, out);
    }
  catch (DBusException)
    {
      throw;
    }

}



void
org_workrave_ControlInterface_Stub::ReadingMode(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs)
{
  (void) sender;

  try
    {
      Menus *dbus_object = (Menus *) object;

      bool p_show       ;

      gsize num_in_args = g_variant_n_children(inargs);
      if (num_in_args != 1)
        {
          throw DBusSystemException("Incorrect numer of in-parameters");
        }

      GVariant *v_show = g_variant_get_child_value(inargs, 0);
      get_bool(v_show, &p_show);

      dbus_object->on_menu_reading( 
       p_show      );

      GVariant *out = NULL;

      g_dbus_method_invocation_return_value(invocation, out);
    }
  catch (DBusException)
    {
      throw;
    }

}



void
org_workrave_ControlInterface_Stub::Statistics(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs)
{
  (void) sender;

  try
    {
      Menus *dbus_object = (Menus *) object;


      gsize num_in_args = g_variant_n_children(inargs);
      if (num_in_args != 0)
        {
          throw DBusSystemException("Incorrect numer of in-parameters");
        }


      dbus_object->on_menu_statistics( 
      );

      GVariant *out = NULL;

      g_dbus_method_invocation_return_value(invocation, out);
    }
  catch (DBusException)
    {
      throw;
    }

}



void
org_workrave_ControlInterface_Stub::Exercises(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs)
{
#if defined(HAVE_EXERCISES)
  (void) sender;

  try
    {
      Menus *dbus_object = (Menus *) object;


      gsize num_in_args = g_variant_n_children(inargs);
      if (num_in_args != 0)
        {
          throw DBusSystemException("Incorrect numer of in-parameters");
        }


      dbus_object->on_menu_exercises( 
      );

      GVariant *out = NULL;

      g_dbus_method_invocation_return_value(invocation, out);
    }
  catch (DBusException)
    {
      throw;
    }

#else
 (void) object;

  g_dbus_method_invocation_return_dbus_error (invocation,
                                              "org.workrave.NotImplemented",
                                              "This method is unavailable in current configuration");
#endif
}



void
org_workrave_ControlInterface_Stub::RestBreak(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs)
{
  (void) sender;

  try
    {
      Menus *dbus_object = (Menus *) object;


      gsize num_in_args = g_variant_n_children(inargs);
      if (num_in_args != 0)
        {
          throw DBusSystemException("Incorrect numer of in-parameters");
        }


      dbus_object->on_menu_restbreak_now( 
      );

      GVariant *out = NULL;

      g_dbus_method_invocation_return_value(invocation, out);
    }
  catch (DBusException)
    {
      throw;
    }

}



void
org_workrave_ControlInterface_Stub::Quit(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs)
{
  (void) sender;

  try
    {
      Menus *dbus_object = (Menus *) object;


      gsize num_in_args = g_variant_n_children(inargs);
      if (num_in_args != 0)
        {
          throw DBusSystemException("Incorrect numer of in-parameters");
        }


      dbus_object->on_menu_quit( 
      );

      GVariant *out = NULL;

      g_dbus_method_invocation_return_value(invocation, out);
    }
  catch (DBusException)
    {
      throw;
    }

}



void
org_workrave_ControlInterface_Stub::About(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs)
{
  (void) sender;

  try
    {
      Menus *dbus_object = (Menus *) object;


      gsize num_in_args = g_variant_n_children(inargs);
      if (num_in_args != 0)
        {
          throw DBusSystemException("Incorrect numer of in-parameters");
        }


      dbus_object->on_menu_about( 
      );

      GVariant *out = NULL;

      g_dbus_method_invocation_return_value(invocation, out);
    }
  catch (DBusException)
    {
      throw;
    }

}




const org_workrave_ControlInterface_Stub::DBusMethod org_workrave_ControlInterface_Stub::method_table[] = {
  { "OpenMain", &org_workrave_ControlInterface_Stub::OpenMain },
  { "Preferences", &org_workrave_ControlInterface_Stub::Preferences },
  { "NetworkConnect", &org_workrave_ControlInterface_Stub::NetworkConnect },
  { "NetworkLog", &org_workrave_ControlInterface_Stub::NetworkLog },
  { "NetworkReconnect", &org_workrave_ControlInterface_Stub::NetworkReconnect },
  { "NetworkDisconnect", &org_workrave_ControlInterface_Stub::NetworkDisconnect },
  { "ReadingMode", &org_workrave_ControlInterface_Stub::ReadingMode },
  { "Statistics", &org_workrave_ControlInterface_Stub::Statistics },
  { "Exercises", &org_workrave_ControlInterface_Stub::Exercises },
  { "RestBreak", &org_workrave_ControlInterface_Stub::RestBreak },
  { "Quit", &org_workrave_ControlInterface_Stub::Quit },
  { "About", &org_workrave_ControlInterface_Stub::About },
  { "", NULL }
};

const char *
org_workrave_ControlInterface_Stub::interface_introspect =
  "  <interface name=\"org.workrave.ControlInterface\">\n"
  "    <method name=\"OpenMain\">\n"
  "    </method>\n"
  "    <method name=\"Preferences\">\n"
  "    </method>\n"
  "    <method name=\"NetworkConnect\">\n"
  "    </method>\n"
  "    <method name=\"NetworkLog\">\n"
  "      <arg type=\"b\" name=\"show\" direction=\"in\" />\n"
  "    </method>\n"
  "    <method name=\"NetworkReconnect\">\n"
  "    </method>\n"
  "    <method name=\"NetworkDisconnect\">\n"
  "    </method>\n"
  "    <method name=\"ReadingMode\">\n"
  "      <arg type=\"b\" name=\"show\" direction=\"in\" />\n"
  "    </method>\n"
  "    <method name=\"Statistics\">\n"
  "    </method>\n"
  "    <method name=\"Exercises\">\n"
  "    </method>\n"
  "    <method name=\"RestBreak\">\n"
  "    </method>\n"
  "    <method name=\"Quit\">\n"
  "    </method>\n"
  "    <method name=\"About\">\n"
  "    </method>\n"
  "  </interface>\n";





#include "GenericDBusApplet.hh"

class org_workrave_AppletInterface_Stub : public DBusBindingBase, public org_workrave_AppletInterface
{
private:
  typedef void (org_workrave_AppletInterface_Stub::*DBusMethodPointer)(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);

  struct DBusMethod
  {
    const string name;
    DBusMethodPointer fn;
  };

  virtual void call(const std::string &method_name, void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);

  virtual const char *get_interface_introspect()
  {
    return interface_introspect;
  }

public:
  org_workrave_AppletInterface_Stub(DBus *dbus);
  ~org_workrave_AppletInterface_Stub();

  void TimersUpdated(const string &path,        GenericDBusApplet::TimerData &micro      , GenericDBusApplet::TimerData &rest      , GenericDBusApplet::TimerData &daily  );
  void MenuUpdated(const string &path,        GenericDBusApplet::MenuItems &menuitems  );


private:
  void Embed(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);
  void Command(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);
  void GetMenu(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);


  void get_TimerData(GVariant *variant, GenericDBusApplet::TimerData *result);
  GVariant *put_TimerData(const GenericDBusApplet::TimerData *result);
  void get_MenuItem(GVariant *variant, GenericDBusApplet::MenuItem *result);
  GVariant *put_MenuItem(const GenericDBusApplet::MenuItem *result);

  void get_MenuItems(GVariant *variant, GenericDBusApplet::MenuItems *result);
  GVariant *put_MenuItems(const GenericDBusApplet::MenuItems *result);


  static const DBusMethod method_table[];
  static const char *interface_introspect;
};


org_workrave_AppletInterface *org_workrave_AppletInterface::instance(const DBus *dbus)
{
  org_workrave_AppletInterface_Stub *iface = NULL;
  DBusBindingBase *binding = dbus->find_binding("org.workrave.AppletInterface");

  if (binding != NULL)
    {
      iface = dynamic_cast<org_workrave_AppletInterface_Stub *>(binding);
    }

  return iface;
}

org_workrave_AppletInterface_Stub::org_workrave_AppletInterface_Stub(DBus *dbus)
  : DBusBindingBase(dbus)
{
}

org_workrave_AppletInterface_Stub::~org_workrave_AppletInterface_Stub()
{
}

void
org_workrave_AppletInterface_Stub::call(const std::string &method_name, void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs)
{
  const DBusMethod *table = method_table;
  while (table->fn != NULL)
    {
      if (method_name == table->name)
        {
          DBusMethodPointer ptr = table->fn;
          if (ptr != NULL)
            {
              (this->*ptr)(object, invocation, sender, inargs);
            }
          return;
        }
      table++;
    }
  throw DBusUsageException(std::string("No such member:") + method_name );
}



void
org_workrave_AppletInterface_Stub::get_TimerData(GVariant *variant, GenericDBusApplet::TimerData *result)
{

  gsize num_fields = g_variant_n_children(variant);
  if (num_fields != 8)
    {
      throw DBusSystemException("Incorrect number of field in struct");
    }


  GVariant *v_bar_text = g_variant_get_child_value(variant, 0);

  get_string(v_bar_text, (std::string *) &(result->bar_text));
  GVariant *v_slot = g_variant_get_child_value(variant, 1);

  get_int32(v_slot, (gint32 *) &(result->slot));
  GVariant *v_bar_secondary_color = g_variant_get_child_value(variant, 2);

  get_uint32(v_bar_secondary_color, (guint32 *) &(result->bar_secondary_color));
  GVariant *v_bar_secondary_val = g_variant_get_child_value(variant, 3);

  get_uint32(v_bar_secondary_val, (guint32 *) &(result->bar_secondary_val));
  GVariant *v_bar_secondary_max = g_variant_get_child_value(variant, 4);

  get_uint32(v_bar_secondary_max, (guint32 *) &(result->bar_secondary_max));
  GVariant *v_bar_primary_color = g_variant_get_child_value(variant, 5);

  get_uint32(v_bar_primary_color, (guint32 *) &(result->bar_primary_color));
  GVariant *v_bar_primary_val = g_variant_get_child_value(variant, 6);

  get_uint32(v_bar_primary_val, (guint32 *) &(result->bar_primary_val));
  GVariant *v_bar_primary_max = g_variant_get_child_value(variant, 7);

  get_uint32(v_bar_primary_max, (guint32 *) &(result->bar_primary_max));


  g_variant_unref(v_bar_text);
  g_variant_unref(v_slot);
  g_variant_unref(v_bar_secondary_color);
  g_variant_unref(v_bar_secondary_val);
  g_variant_unref(v_bar_secondary_max);
  g_variant_unref(v_bar_primary_color);
  g_variant_unref(v_bar_primary_val);
  g_variant_unref(v_bar_primary_max);
}


GVariant *
org_workrave_AppletInterface_Stub::put_TimerData(const GenericDBusApplet::TimerData *result)
{
  GVariantBuilder builder;
  g_variant_builder_init(&builder, (GVariantType *)"(siuuuuuu)");


  GVariant *v;

  v = put_string((std::string *) &(result->bar_text));
  g_variant_builder_add_value(&builder, v);
  v = put_int32((gint32 *) &(result->slot));
  g_variant_builder_add_value(&builder, v);
  v = put_uint32((guint32 *) &(result->bar_secondary_color));
  g_variant_builder_add_value(&builder, v);
  v = put_uint32((guint32 *) &(result->bar_secondary_val));
  g_variant_builder_add_value(&builder, v);
  v = put_uint32((guint32 *) &(result->bar_secondary_max));
  g_variant_builder_add_value(&builder, v);
  v = put_uint32((guint32 *) &(result->bar_primary_color));
  g_variant_builder_add_value(&builder, v);
  v = put_uint32((guint32 *) &(result->bar_primary_val));
  g_variant_builder_add_value(&builder, v);
  v = put_uint32((guint32 *) &(result->bar_primary_max));
  g_variant_builder_add_value(&builder, v);

  return g_variant_builder_end(&builder);
}


void
org_workrave_AppletInterface_Stub::get_MenuItem(GVariant *variant, GenericDBusApplet::MenuItem *result)
{

  gsize num_fields = g_variant_n_children(variant);
  if (num_fields != 3)
    {
      throw DBusSystemException("Incorrect number of field in struct");
    }


  GVariant *v_text = g_variant_get_child_value(variant, 0);

  get_string(v_text, (std::string *) &(result->text));
  GVariant *v_command = g_variant_get_child_value(variant, 1);

  get_int32(v_command, (gint32 *) &(result->command));
  GVariant *v_flags = g_variant_get_child_value(variant, 2);

  get_int32(v_flags, (gint32 *) &(result->flags));


  g_variant_unref(v_text);
  g_variant_unref(v_command);
  g_variant_unref(v_flags);
}


GVariant *
org_workrave_AppletInterface_Stub::put_MenuItem(const GenericDBusApplet::MenuItem *result)
{
  GVariantBuilder builder;
  g_variant_builder_init(&builder, (GVariantType *)"(sii)");


  GVariant *v;

  v = put_string((std::string *) &(result->text));
  g_variant_builder_add_value(&builder, v);
  v = put_int32((gint32 *) &(result->command));
  g_variant_builder_add_value(&builder, v);
  v = put_int32((gint32 *) &(result->flags));
  g_variant_builder_add_value(&builder, v);

  return g_variant_builder_end(&builder);
}



void
org_workrave_AppletInterface_Stub::get_MenuItems(GVariant *variant, GenericDBusApplet::MenuItems *result)
{
  GVariantIter iter;
  g_variant_iter_init(&iter, variant);

  GVariant *child;
  while ((child = g_variant_iter_next_value(&iter)))
    {
      GenericDBusApplet::MenuItem tmp;
      get_MenuItem(child, &tmp);
      result->push_back(tmp);

      g_variant_unref (child);
    }
}

GVariant *
org_workrave_AppletInterface_Stub::put_MenuItems(const GenericDBusApplet::MenuItems *result)
{
  GVariantBuilder builder;
  g_variant_builder_init(&builder, (GVariantType *)"a(sii)");

  GenericDBusApplet::MenuItems::const_iterator it;

  for (it = result->begin(); it != result->end(); it++)
  {
    GVariant *v = put_MenuItem(&(*it));
    g_variant_builder_add_value(&builder, v);
  }

  return g_variant_builder_end(&builder);
}




void
org_workrave_AppletInterface_Stub::Embed(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs)
{
  (void) sender;

  try
    {
      GenericDBusApplet *dbus_object = (GenericDBusApplet *) object;

      bool p_enabled       ;
      std::string p_sender       ;

      gsize num_in_args = g_variant_n_children(inargs);
      if (num_in_args != 2)
        {
          throw DBusSystemException("Incorrect numer of in-parameters");
        }

      GVariant *v_enabled = g_variant_get_child_value(inargs, 0);
      get_bool(v_enabled, &p_enabled);
      GVariant *v_sender = g_variant_get_child_value(inargs, 1);
      get_string(v_sender, &p_sender);

      dbus_object->applet_embed( 
       p_enabled      , p_sender      );

      GVariant *out = NULL;

      g_dbus_method_invocation_return_value(invocation, out);
    }
  catch (DBusException)
    {
      throw;
    }

}



void
org_workrave_AppletInterface_Stub::Command(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs)
{
  (void) sender;

  try
    {
      GenericDBusApplet *dbus_object = (GenericDBusApplet *) object;

      gint32 p_command       ;

      gsize num_in_args = g_variant_n_children(inargs);
      if (num_in_args != 1)
        {
          throw DBusSystemException("Incorrect numer of in-parameters");
        }

      GVariant *v_command = g_variant_get_child_value(inargs, 0);
      get_int32(v_command, &p_command);

      dbus_object->applet_command( 
       p_command      );

      GVariant *out = NULL;

      g_dbus_method_invocation_return_value(invocation, out);
    }
  catch (DBusException)
    {
      throw;
    }

}



void
org_workrave_AppletInterface_Stub::GetMenu(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs)
{
  (void) sender;

  try
    {
      GenericDBusApplet *dbus_object = (GenericDBusApplet *) object;

      GenericDBusApplet::MenuItems p_menuitems       ;

      gsize num_in_args = g_variant_n_children(inargs);
      if (num_in_args != 0)
        {
          throw DBusSystemException("Incorrect numer of in-parameters");
        }


      dbus_object->get_menu( 
       p_menuitems      );

      GVariantBuilder builder;
      g_variant_builder_init(&builder, (GVariantType*)"(a(sii))");

      GVariant *v_menuitems = put_MenuItems(&p_menuitems);
      g_variant_builder_add_value(&builder, v_menuitems);

      GVariant *out = g_variant_builder_end(&builder);

      g_dbus_method_invocation_return_value(invocation, out);
    }
  catch (DBusException)
    {
      throw;
    }

}



void org_workrave_AppletInterface_Stub::TimersUpdated(const string &path,        GenericDBusApplet::TimerData &micro      , GenericDBusApplet::TimerData &rest      , GenericDBusApplet::TimerData &daily)
{
  GDBusConnection *connection = dbus->get_connection();
  if (connection == NULL)
    {
      return;
    }

  GVariantBuilder builder;
  g_variant_builder_init(&builder, (GVariantType*)"((siuuuuuu)(siuuuuuu)(siuuuuuu))");

  GVariant *v_micro = put_TimerData(&micro);
  g_variant_builder_add_value(&builder, v_micro);
  GVariant *v_rest = put_TimerData(&rest);
  g_variant_builder_add_value(&builder, v_rest);
  GVariant *v_daily = put_TimerData(&daily);
  g_variant_builder_add_value(&builder, v_daily);

  GVariant *out = g_variant_builder_end(&builder);

  GError *error = NULL;
  g_dbus_connection_emit_signal(connection,
                                NULL,
                                path.c_str(),
                                "org.workrave.AppletInterface",
                                "TimersUpdated",
                                out,
                                &error);

  if (error != NULL)
    {
      g_error_free(error);
    }
}

void org_workrave_AppletInterface_Stub::MenuUpdated(const string &path,        GenericDBusApplet::MenuItems &menuitems)
{
  GDBusConnection *connection = dbus->get_connection();
  if (connection == NULL)
    {
      return;
    }

  GVariantBuilder builder;
  g_variant_builder_init(&builder, (GVariantType*)"(a(sii))");

  GVariant *v_menuitems = put_MenuItems(&menuitems);
  g_variant_builder_add_value(&builder, v_menuitems);

  GVariant *out = g_variant_builder_end(&builder);

  GError *error = NULL;
  g_dbus_connection_emit_signal(connection,
                                NULL,
                                path.c_str(),
                                "org.workrave.AppletInterface",
                                "MenuUpdated",
                                out,
                                &error);

  if (error != NULL)
    {
      g_error_free(error);
    }
}


const org_workrave_AppletInterface_Stub::DBusMethod org_workrave_AppletInterface_Stub::method_table[] = {
  { "Embed", &org_workrave_AppletInterface_Stub::Embed },
  { "Command", &org_workrave_AppletInterface_Stub::Command },
  { "GetMenu", &org_workrave_AppletInterface_Stub::GetMenu },
  { "", NULL }
};

const char *
org_workrave_AppletInterface_Stub::interface_introspect =
  "  <interface name=\"org.workrave.AppletInterface\">\n"
  "    <method name=\"Embed\">\n"
  "      <arg type=\"b\" name=\"enabled\" direction=\"in\" />\n"
  "      <arg type=\"s\" name=\"sender\" direction=\"in\" />\n"
  "    </method>\n"
  "    <method name=\"Command\">\n"
  "      <arg type=\"i\" name=\"command\" direction=\"in\" />\n"
  "    </method>\n"
  "    <method name=\"GetMenu\">\n"
  "      <arg type=\"a(sii)\" name=\"menuitems\" direction=\"out\" />\n"
  "    </method>\n"
  "    <signal name=\"TimersUpdated\">\n"
  "      <arg type=\"a(sii)\" name=\"menuitems\" />\n"
  "      <arg type=\"a(sii)\" name=\"menuitems\" />\n"
  "      <arg type=\"a(sii)\" name=\"menuitems\" />\n"
  "    </signal>\n"
  "    <signal name=\"MenuUpdated\">\n"
  "      <arg type=\"a(sii)\" name=\"menuitems\" />\n"
  "    </signal>\n"
  "  </interface>\n";



#if defined(HAVE_PANELAPPLET2) || defined(HAVE_PANELAPPLET4)


#include "gdk/gdk.h"
#include "GnomeAppletWindow.hh"
#include "Orientation.hh"

class org_workrave_GnomeAppletSupportInterface_Stub : public DBusBindingBase, public org_workrave_GnomeAppletSupportInterface
{
private:
  typedef void (org_workrave_GnomeAppletSupportInterface_Stub::*DBusMethodPointer)(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);

  struct DBusMethod
  {
    const string name;
    DBusMethodPointer fn;
  };

  virtual void call(const std::string &method_name, void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);

  virtual const char *get_interface_introspect()
  {
    return interface_introspect;
  }

public:
  org_workrave_GnomeAppletSupportInterface_Stub(DBus *dbus);
  ~org_workrave_GnomeAppletSupportInterface_Stub();



private:
  void SetOrientation(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);
  void SetSize(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);
  void SetBackground(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);
  void ButtonClicked(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);
  void EmbedRequest(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs);

  void get_Orientation(GVariant *variant, Orientation *result);
  GVariant *put_Orientation(const Orientation *result);

  void get_Color(GVariant *variant, GdkColor *result);
  GVariant *put_Color(const GdkColor *result);



  static const DBusMethod method_table[];
  static const char *interface_introspect;
};


org_workrave_GnomeAppletSupportInterface *org_workrave_GnomeAppletSupportInterface::instance(const DBus *dbus)
{
  org_workrave_GnomeAppletSupportInterface_Stub *iface = NULL;
  DBusBindingBase *binding = dbus->find_binding("org.workrave.GnomeAppletSupportInterface");

  if (binding != NULL)
    {
      iface = dynamic_cast<org_workrave_GnomeAppletSupportInterface_Stub *>(binding);
    }

  return iface;
}

org_workrave_GnomeAppletSupportInterface_Stub::org_workrave_GnomeAppletSupportInterface_Stub(DBus *dbus)
  : DBusBindingBase(dbus)
{
}

org_workrave_GnomeAppletSupportInterface_Stub::~org_workrave_GnomeAppletSupportInterface_Stub()
{
}

void
org_workrave_GnomeAppletSupportInterface_Stub::call(const std::string &method_name, void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs)
{
  const DBusMethod *table = method_table;
  while (table->fn != NULL)
    {
      if (method_name == table->name)
        {
          DBusMethodPointer ptr = table->fn;
          if (ptr != NULL)
            {
              (this->*ptr)(object, invocation, sender, inargs);
            }
          return;
        }
      table++;
    }
  throw DBusUsageException(std::string("No such member:") + method_name );
}


void
org_workrave_GnomeAppletSupportInterface_Stub::get_Orientation(GVariant *variant, Orientation *result)
{
  std::string value;

  get_string(variant, &value);

  if ("up" == value)
    {
      *result = ORIENTATION_UP;
    }
  else if ("right" == value)
    {
      *result = ORIENTATION_RIGHT;
    }
  else if ("down" == value)
    {
      *result = ORIENTATION_DOWN;
    }
  else if ("left" == value)
    {
      *result = ORIENTATION_LEFT;
    }
  else
    {
      throw DBusTypeException("Illegal enum value");
    }
}

GVariant *
org_workrave_GnomeAppletSupportInterface_Stub::put_Orientation(const Orientation *result)
{
  string value;
  switch (*result)
    {
    case ORIENTATION_UP:
      value = "up";
      break;
    case ORIENTATION_RIGHT:
      value = "right";
      break;
    case ORIENTATION_DOWN:
      value = "down";
      break;
    case ORIENTATION_LEFT:
      value = "left";
      break;
    default:
      throw DBusTypeException("Illegal enum value");
    }

  return put_string(&value);
}



void
org_workrave_GnomeAppletSupportInterface_Stub::get_Color(GVariant *variant, GdkColor *result)
{

  gsize num_fields = g_variant_n_children(variant);
  if (num_fields != 4)
    {
      throw DBusSystemException("Incorrect number of field in struct");
    }


  GVariant *v_pixel = g_variant_get_child_value(variant, 0);

  get_uint32(v_pixel, (guint32 *) &(result->pixel));
  GVariant *v_red = g_variant_get_child_value(variant, 1);

  get_uint32(v_red, (guint32 *) &(result->red));
  GVariant *v_green = g_variant_get_child_value(variant, 2);

  get_uint32(v_green, (guint32 *) &(result->green));
  GVariant *v_blue = g_variant_get_child_value(variant, 3);

  get_uint32(v_blue, (guint32 *) &(result->blue));


  g_variant_unref(v_pixel);
  g_variant_unref(v_red);
  g_variant_unref(v_green);
  g_variant_unref(v_blue);
}


GVariant *
org_workrave_GnomeAppletSupportInterface_Stub::put_Color(const GdkColor *result)
{
  GVariantBuilder builder;
  g_variant_builder_init(&builder, (GVariantType *)"(uuuu)");


  GVariant *v;

  v = put_uint32((guint32 *) &(result->pixel));
  g_variant_builder_add_value(&builder, v);
  v = put_uint32((guint32 *) &(result->red));
  g_variant_builder_add_value(&builder, v);
  v = put_uint32((guint32 *) &(result->green));
  g_variant_builder_add_value(&builder, v);
  v = put_uint32((guint32 *) &(result->blue));
  g_variant_builder_add_value(&builder, v);

  return g_variant_builder_end(&builder);
}






void
org_workrave_GnomeAppletSupportInterface_Stub::SetOrientation(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs)
{
  (void) sender;

  try
    {
      GnomeAppletWindow *dbus_object = (GnomeAppletWindow *) object;

      Orientation p_orientation       ;

      gsize num_in_args = g_variant_n_children(inargs);
      if (num_in_args != 1)
        {
          throw DBusSystemException("Incorrect numer of in-parameters");
        }

      GVariant *v_orientation = g_variant_get_child_value(inargs, 0);
      get_Orientation(v_orientation, &p_orientation);

      dbus_object->set_applet_orientation( 
       p_orientation      );

      GVariant *out = NULL;

      g_dbus_method_invocation_return_value(invocation, out);
    }
  catch (DBusException)
    {
      throw;
    }

}



void
org_workrave_GnomeAppletSupportInterface_Stub::SetSize(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs)
{
  (void) sender;

  try
    {
      GnomeAppletWindow *dbus_object = (GnomeAppletWindow *) object;

      guint32 p_size       ;

      gsize num_in_args = g_variant_n_children(inargs);
      if (num_in_args != 1)
        {
          throw DBusSystemException("Incorrect numer of in-parameters");
        }

      GVariant *v_size = g_variant_get_child_value(inargs, 0);
      get_uint32(v_size, &p_size);

      dbus_object->set_applet_size( 
       p_size      );

      GVariant *out = NULL;

      g_dbus_method_invocation_return_value(invocation, out);
    }
  catch (DBusException)
    {
      throw;
    }

}



void
org_workrave_GnomeAppletSupportInterface_Stub::SetBackground(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs)
{
  (void) sender;

  try
    {
      GnomeAppletWindow *dbus_object = (GnomeAppletWindow *) object;

      guint32 p_type       ;
      GdkColor p_color       ;
      guint32 p_xid       ;

      gsize num_in_args = g_variant_n_children(inargs);
      if (num_in_args != 3)
        {
          throw DBusSystemException("Incorrect numer of in-parameters");
        }

      GVariant *v_type = g_variant_get_child_value(inargs, 0);
      get_uint32(v_type, &p_type);
      GVariant *v_color = g_variant_get_child_value(inargs, 1);
      get_Color(v_color, &p_color);
      GVariant *v_xid = g_variant_get_child_value(inargs, 2);
      get_uint32(v_xid, &p_xid);

      dbus_object->set_applet_background( 
       p_type      , p_color      , p_xid      );

      GVariant *out = NULL;

      g_dbus_method_invocation_return_value(invocation, out);
    }
  catch (DBusException)
    {
      throw;
    }

}



void
org_workrave_GnomeAppletSupportInterface_Stub::ButtonClicked(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs)
{
  (void) sender;

  try
    {
      GnomeAppletWindow *dbus_object = (GnomeAppletWindow *) object;

      guint32 p_button       ;

      gsize num_in_args = g_variant_n_children(inargs);
      if (num_in_args != 1)
        {
          throw DBusSystemException("Incorrect numer of in-parameters");
        }

      GVariant *v_button = g_variant_get_child_value(inargs, 0);
      get_uint32(v_button, &p_button);

      dbus_object->button_clicked( 
       p_button      );

      GVariant *out = NULL;

      g_dbus_method_invocation_return_value(invocation, out);
    }
  catch (DBusException)
    {
      throw;
    }

}



void
org_workrave_GnomeAppletSupportInterface_Stub::EmbedRequest(void *object, GDBusMethodInvocation *invocation, const std::string &sender, GVariant *inargs)
{
  (void) sender;

  try
    {
      GnomeAppletWindow *dbus_object = (GnomeAppletWindow *) object;


      gsize num_in_args = g_variant_n_children(inargs);
      if (num_in_args != 0)
        {
          throw DBusSystemException("Incorrect numer of in-parameters");
        }


      dbus_object->fire_gnome_applet( 
      );

      GVariant *out = NULL;

      g_dbus_method_invocation_return_value(invocation, out);
    }
  catch (DBusException)
    {
      throw;
    }

}




const org_workrave_GnomeAppletSupportInterface_Stub::DBusMethod org_workrave_GnomeAppletSupportInterface_Stub::method_table[] = {
  { "SetOrientation", &org_workrave_GnomeAppletSupportInterface_Stub::SetOrientation },
  { "SetSize", &org_workrave_GnomeAppletSupportInterface_Stub::SetSize },
  { "SetBackground", &org_workrave_GnomeAppletSupportInterface_Stub::SetBackground },
  { "ButtonClicked", &org_workrave_GnomeAppletSupportInterface_Stub::ButtonClicked },
  { "EmbedRequest", &org_workrave_GnomeAppletSupportInterface_Stub::EmbedRequest },
  { "", NULL }
};

const char *
org_workrave_GnomeAppletSupportInterface_Stub::interface_introspect =
  "  <interface name=\"org.workrave.GnomeAppletSupportInterface\">\n"
  "    <method name=\"SetOrientation\">\n"
  "      <arg type=\"s\" name=\"orientation\" direction=\"in\" />\n"
  "    </method>\n"
  "    <method name=\"SetSize\">\n"
  "      <arg type=\"u\" name=\"size\" direction=\"in\" />\n"
  "    </method>\n"
  "    <method name=\"SetBackground\">\n"
  "      <arg type=\"u\" name=\"type\" direction=\"in\" />\n"
  "      <arg type=\"(uuuu)\" name=\"color\" direction=\"in\" />\n"
  "      <arg type=\"u\" name=\"xid\" direction=\"in\" />\n"
  "    </method>\n"
  "    <method name=\"ButtonClicked\">\n"
  "      <arg type=\"u\" name=\"button\" direction=\"in\" />\n"
  "    </method>\n"
  "    <method name=\"EmbedRequest\">\n"
  "    </method>\n"
  "  </interface>\n";

 #endif // defined(HAVE_PANELAPPLET2) || defined(HAVE_PANELAPPLET4)


void init_DBusGUI(DBus *dbus)
{
  dbus->register_binding("org.workrave.ControlInterface", new org_workrave_ControlInterface_Stub(dbus));
  dbus->register_binding("org.workrave.AppletInterface", new org_workrave_AppletInterface_Stub(dbus));
#if defined(HAVE_PANELAPPLET2) || defined(HAVE_PANELAPPLET4)
  dbus->register_binding("org.workrave.GnomeAppletSupportInterface", new org_workrave_GnomeAppletSupportInterface_Stub(dbus));
#endif // defined(HAVE_PANELAPPLET2) || defined(HAVE_PANELAPPLET4)
}
