/* method_callback.hh
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2011 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef METHOD_CALLBACK_HH
#define METHOD_CALLBACK_HH

#include "wdefines.h"
#include "generic_callback.hh"

template< typename X, void (X::*method)() >
class MethodCallback : public GenericCallback<void>
{
public:
    MethodCallback( X* object ) : m_object( object )
    {}

    void callback()
    {
        if ( m_object != NULL ) {
            ( m_object->*method )();
        }
    }
private:
    X* m_object;
};

template< typename X, typename Y, void (X::*method)( Y ) >
class MethodCallbackArg : public GenericCallbackArg<void, Y>
{
public:
    MethodCallbackArg( X* object ) : m_object( object )
    {}

    void callback( Y y )
    {
        if ( m_object != NULL ) {
            ( m_object->*method )( y );
        }
    }
private:
    X* m_object;
};

#endif
