/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.jvxl.api.MeshDataServer;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshCollection;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.Parser;
import org.jmol.util.Point3fi;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

public class Isosurface
extends MeshCollection
implements MeshDataServer {
    private IsosurfaceMesh[] isomeshes = new IsosurfaceMesh[4];
    protected IsosurfaceMesh thisMesh;
    private int lighting;
    private boolean iHaveBitSets;
    private boolean explicitContours;
    private int atomIndex;
    private int moNumber;
    private short defaultColix;
    private short meshColix;
    private Point3f center;
    private Point3f offset;
    private float scale3d;
    private boolean isPhaseColored;
    private boolean isColorExplicit;
    protected SurfaceGenerator sg;
    protected JvxlData jvxlData;
    private ColorEncoder colorEncoder = new ColorEncoder();
    private float withinDistance;
    private Vector withinPoints;
    private int indexColorPositive;
    private int indexColorNegative;
    private int nLCAO = 0;
    private Point4f lcaoDir = new Point4f();
    private boolean associateNormals;
    private static final int MAX_OBJECT_CLICK_DISTANCE_SQUARED = 100;
    private final Point3i ptXY = new Point3i();

    public void allocMesh(String string) {
        int n = this.meshCount++;
        this.isomeshes = (IsosurfaceMesh[])ArrayUtil.ensureLength(this.isomeshes, this.meshCount * 2);
        this.meshes = this.isomeshes;
        this.thisMesh = this.isomeshes[n] = new IsosurfaceMesh(string, this.g3d, this.colix, n);
        this.currentMesh = this.isomeshes[n];
        this.jvxlData = this.thisMesh.jvxlData;
        this.sg.setJvxlData(this.jvxlData);
    }

    public void initShape() {
        super.initShape();
        this.myType = "isosurface";
        this.newSg();
    }

    private void newSg() {
        this.jvxlData = new JvxlData();
        this.sg = new SurfaceGenerator(this.viewer, this, this.colorEncoder, null, this.jvxlData);
        this.sg.setVersion("Jmol " + Viewer.getJmolVersion());
    }

    protected void clearSg() {
        this.sg = null;
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        int n;
        Object object2;
        if ("navigate" == string) {
            this.navigate((Integer)object);
            return;
        }
        if ("delete" == string) {
            this.setPropertySuper(string, object, bitSet);
            if (!this.explicitID) {
                this.nUnnamed = 0;
                this.nLCAO = 0;
            }
            return;
        }
        if ("remapcolor" == string) {
            if (this.thisMesh != null) {
                this.remapColors();
            }
            return;
        }
        if ("thisID" == string) {
            if (this.actualID != null) {
                object = this.actualID;
            }
            this.setPropertySuper("thisID", object, null);
            return;
        }
        if ("map" == string) {
            this.setProperty("squareData", Boolean.FALSE, null);
            return;
        }
        if ("color" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.isColorSolid = true;
                this.thisMesh.polygonColixes = null;
            } else if (!TextFormat.isWild(this.previousMeshID)) {
                int n2 = this.meshCount;
                while (--n2 >= 0) {
                    this.isomeshes[n2].isColorSolid = true;
                    this.isomeshes[n2].polygonColixes = null;
                }
            }
            this.setPropertySuper(string, object, bitSet);
            return;
        }
        if ("fixed" == string) {
            this.isFixed = (Boolean)object;
            this.setModelIndex();
            return;
        }
        if ("modelIndex" == string) {
            if (!this.iHaveModelIndex) {
                this.modelIndex = (Integer)object;
                this.sg.setModelIndex(this.modelIndex);
                this.isFixed = this.modelIndex < 0;
            }
            this.isFixed = this.modelIndex < 0;
            return;
        }
        if ("lcaoCartoon" == string || "lonePair" == string || "radical" == string) {
            Vector3f[] vector3fArray = (Vector3f[])object;
            if (!this.explicitID) {
                this.setPropertySuper("thisID", null, null);
            }
            if (!this.sg.setParameter("lcaoCartoonCenter", vector3fArray[2])) {
                this.drawLcaoCartoon(vector3fArray[0], vector3fArray[1], vector3fArray[3], "lonePair" == string ? 2 : ("radical" == string ? 1 : 0));
            }
            return;
        }
        if ("select" == string && this.iHaveBitSets) {
            return;
        }
        if ("ignore" == string && this.iHaveBitSets) {
            return;
        }
        if ("colorMesh" == string) {
            int n3 = (Integer)object;
            this.meshColix = Graphics3D.getColix(n3);
            return;
        }
        if ("offset" == string) {
            this.offset = new Point3f((Point3f)object);
            if (this.offset.equals(JmolConstants.center)) {
                this.offset = null;
            }
            if (this.thisMesh != null) {
                this.thisMesh.ptOffset = this.offset;
                this.thisMesh.offsetVertices = null;
            }
            return;
        }
        if ("setColorScheme" == string) {
            object2 = object;
            n = ((Boolean)object2[1]).booleanValue();
            if (this.thisMesh != null) {
                this.thisMesh.colix = Graphics3D.getColixTranslucent(this.thisMesh.colix, n != 0, n != 0 ? 0.5f : 0.0f);
            }
        }
        if ("title" == string) {
            if (object instanceof String && "-".equals((String)object)) {
                object = null;
            }
            this.setPropertySuper(string, object, bitSet);
            object = this.title;
        }
        if ("withinPoints" == string) {
            object2 = object;
            this.withinDistance = ((Float)object2[0]).floatValue();
            BitSet bitSet2 = (BitSet)object2[2];
            this.withinPoints = (Vector)object2[3];
            if (this.withinPoints.size() == 0) {
                this.withinPoints = this.viewer.getAtomPointVector(bitSet2);
            }
        }
        if ("scale3d" == string) {
            this.scale3d = ((Float)object).floatValue();
            if (this.thisMesh != null) {
                this.thisMesh.scale3d = this.thisMesh.jvxlData.scale3d = this.scale3d;
                this.thisMesh.offsetVertices = null;
            }
        }
        if ("getSurfaceSets" == string && this.thisMesh != null) {
            this.thisMesh.thisSet = (Integer)object;
        }
        if ("contour" == string) {
            this.explicitContours = true;
        }
        if ("atomIndex" == string) {
            this.atomIndex = (Integer)object;
        }
        if ("pocket" == string) {
            object2 = (Boolean)object;
            int n4 = this.lighting = ((Boolean)object2).booleanValue() ? 0x4000004C : 0x40000049;
        }
        if ("colorRGB" == string) {
            int n5 = (Integer)object;
            this.defaultColix = Graphics3D.getColix(n5);
        }
        if ("molecularOrbital" == string) {
            this.moNumber = (Integer)object;
            if (!this.isColorExplicit) {
                this.isPhaseColored = true;
            }
        }
        if (string == "functionXY" && this.sg.isStateDataRead()) {
            this.setScriptInfo();
        }
        if ("center" == string) {
            this.center.set((Point3f)object);
        }
        if ("phase" == string) {
            this.isPhaseColored = true;
        }
        if ("plane" == string) {
            this.allowContourLines = false;
        }
        if ("functionXY" == string) {
            this.allowContourLines = false;
        }
        if ("finalize" == string) {
            this.thisMesh.setDiscreteColixes(this.sg.getParams().contoursDiscrete, this.sg.getParams().contourColixes);
            this.setScriptInfo();
            this.setJvxlInfo();
            this.clearSg();
            return;
        }
        if ("init" == string) {
            this.newSg();
        }
        if ("localName" == string) {
            object = this.viewer.getOutputStream((String)object);
            string = "outputStream";
        }
        if (("mapColor" == string || "readFile" == string) && object == null && (object = this.viewer.getBufferedReaderOrErrorMessageFromName(this.sg.getFileName(), null, false)) instanceof String) {
            Logger.error("Isosurface: could not open file " + this.sg.getFileName() + " -- " + this.sg.getFileName());
            return;
        }
        if (this.sg != null && this.sg.setParameter(string, object, bitSet)) {
            return;
        }
        if ("init" == string) {
            this.explicitID = false;
            String string2 = object instanceof String ? (String)object : null;
            n = string2 == null ? -1 : string2.indexOf("# ID=");
            this.actualID = n >= 0 ? Parser.getNextQuotedString(string2, n) : null;
            this.setPropertySuper("thisID", "+PREVIOUS_MESH+", null);
            if (string2 != null && !(this.iHaveBitSets = this.getScriptBitSets(string2, null))) {
                this.sg.setParameter("select", bitSet);
            }
            this.initializeIsosurface();
            this.sg.setModelIndex(this.modelIndex);
            return;
        }
        if ("clear" == string) {
            this.discardTempData(true);
            return;
        }
        if (string == "deleteModelAtoms") {
            int n6 = ((int[])((Object[])object)[2])[0];
            BitSet bitSet3 = new BitSet();
            bitSet3.set(n6);
            int n7 = ((int[])((Object[])object)[2])[1];
            int n8 = ((int[])((Object[])object)[2])[2];
            int n9 = this.meshCount;
            while (--n9 >= 0) {
                Mesh mesh = this.meshes[n9];
                if (mesh == null) continue;
                if (mesh.modelIndex == n6) {
                    --this.meshCount;
                    if (mesh == this.currentMesh) {
                        this.thisMesh = null;
                        this.currentMesh = null;
                    }
                    this.isomeshes = (IsosurfaceMesh[])ArrayUtil.deleteElements(this.meshes, n9, 1);
                    this.meshes = this.isomeshes;
                    continue;
                }
                if (mesh.modelIndex <= n6) continue;
                --mesh.modelIndex;
                if (mesh.atomIndex >= n7) {
                    mesh.atomIndex -= n8;
                }
                if (mesh.bitsets == null) continue;
                BitSetUtil.deleteBits(mesh.bitsets[0], bitSet);
                BitSetUtil.deleteBits(mesh.bitsets[1], bitSet);
                BitSetUtil.deleteBits(mesh.bitsets[2], bitSet3);
            }
            return;
        }
        if ("setColorScheme" == string) {
            String string3 = (String)((Object[])object)[0];
            this.setColorCommand(string3, true);
        }
        this.setPropertySuper(string, object, bitSet);
    }

    private void setPropertySuper(String string, Object object, BitSet bitSet) {
        if (string == "thisID" && this.currentMesh != null && this.currentMesh.thisID.equals((String)object)) {
            this.checkExplicit((String)object);
            return;
        }
        this.currentMesh = this.thisMesh;
        super.setProperty(string, object, bitSet);
        this.thisMesh = (IsosurfaceMesh)this.currentMesh;
        JvxlData jvxlData = this.jvxlData = this.thisMesh == null ? null : this.thisMesh.jvxlData;
        if (this.sg != null) {
            this.sg.setJvxlData(this.jvxlData);
        }
    }

    public boolean getProperty(String string, Object[] objectArray) {
        int n;
        if (string == "intersectPlane") {
            IsosurfaceMesh isosurfaceMesh = (IsosurfaceMesh)this.getMesh((String)objectArray[0]);
            if (isosurfaceMesh == null) {
                return false;
            }
            objectArray[3] = new Integer(isosurfaceMesh.modelIndex);
            return isosurfaceMesh.getIntersection((Point4f)objectArray[1], (Vector)objectArray[2], false);
        }
        if (string == "getBoundingBox") {
            String string2 = (String)objectArray[0];
            IsosurfaceMesh isosurfaceMesh = (IsosurfaceMesh)this.getMesh(string2);
            if (isosurfaceMesh == null || isosurfaceMesh.vertices == null) {
                return false;
            }
            objectArray[2] = isosurfaceMesh.jvxlData.boundingBox;
            return true;
        }
        if (string == "getCenter" && (n = ((Integer)objectArray[1]).intValue()) < 0) {
            String string3 = (String)objectArray[0];
            IsosurfaceMesh isosurfaceMesh = (IsosurfaceMesh)this.getMesh(string3);
            if (isosurfaceMesh == null || isosurfaceMesh.vertices == null) {
                return false;
            }
            Point3f point3f = new Point3f(isosurfaceMesh.jvxlData.boundingBox[0]);
            point3f.add(isosurfaceMesh.jvxlData.boundingBox[1]);
            point3f.scale(0.5f);
            objectArray[2] = point3f;
            return true;
        }
        return super.getProperty(string, objectArray);
    }

    public Object getProperty(String string, int n) {
        Object object = super.getProperty(string, n);
        if (object != null) {
            return object;
        }
        if (string == "dataRange") {
            float[] fArray;
            if (this.thisMesh == null || this.jvxlData.jvxlPlane != null && !this.jvxlData.jvxlDataIsColorMapped) {
                fArray = null;
            } else {
                float[] fArray2 = new float[4];
                fArray2[0] = this.jvxlData.mappedDataMin;
                fArray2[1] = this.jvxlData.mappedDataMax;
                fArray2[2] = this.jvxlData.valueMappedToRed;
                fArray = fArray2;
                fArray2[3] = this.jvxlData.valueMappedToBlue;
            }
            return fArray;
        }
        if (string == "moNumber") {
            return new Integer(this.moNumber);
        }
        if (string == "area") {
            return this.thisMesh == null ? new Float(Float.NaN) : this.thisMesh.calculateArea();
        }
        if (string == "volume") {
            return this.thisMesh == null ? new Float(Float.NaN) : this.thisMesh.calculateVolume();
        }
        if (this.thisMesh == null) {
            return null;
        }
        if (string == "cutoff") {
            return new Float(this.jvxlData.cutoff);
        }
        if (string == "minMaxInfo") {
            return new float[]{this.jvxlData.dataMin, this.jvxlData.dataMax};
        }
        if (string == "plane") {
            return this.jvxlData.jvxlPlane;
        }
        if (string == "jvxlDataXml" || string == "jvxlMeshXml") {
            MeshData meshData = null;
            if (string == "jvxlMeshXml" || this.jvxlData.vertexDataOnly) {
                meshData = new MeshData();
                this.fillMeshData(meshData, 1, null);
                meshData.polygonColorData = Isosurface.getPolygonColorData(meshData.polygonCount, meshData.polygonColixes);
            }
            return JvxlCoder.jvxlGetFile(this.jvxlData, meshData, this.title, "", true, 1, this.thisMesh.getState(this.myType), this.thisMesh.scriptCommand == null ? "" : this.thisMesh.scriptCommand);
        }
        if (string == "jvxlFileInfo") {
            return JvxlCoder.jvxlGetInfo(this.jvxlData);
        }
        return null;
    }

    public static String getPolygonColorData(int n, short[] sArray) {
        if (sArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        short s = 0;
        boolean bl = false;
        int n3 = 0;
        while (true) {
            if (n3 >= n) {
                bl = true;
                if (!true) break;
            }
            if (bl || sArray[n3] != s) {
                if (n2 != 0) {
                    stringBuffer.append(" ").append(n2).append(" ").append(s == 0 ? 0 : Graphics3D.getArgb(s));
                }
                if (bl) break;
                s = sArray[n3];
                n2 = 1;
            } else {
                ++n2;
            }
            ++n3;
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    protected void getColorState(StringBuffer stringBuffer, Mesh mesh) {
        boolean bl;
        boolean bl2 = bl = mesh.isColorSolid && ((IsosurfaceMesh)mesh).polygonColixes != null;
        if (mesh.isColorSolid && !bl) {
            Isosurface.appendCmd(stringBuffer, this.getColorCommand(this.myType, mesh.colix));
        }
    }

    private boolean getScriptBitSets(String string, BitSet[] bitSetArray) {
        this.script = string;
        this.getModelIndex(string);
        if (string == null) {
            return false;
        }
        this.getCapSlabInfo(string);
        int n = string.indexOf("# ({");
        if (n < 0) {
            return false;
        }
        int n2 = string.indexOf("})", n);
        if (n2 < 0) {
            return false;
        }
        BitSet bitSet = Escape.unescapeBitset(string.substring(n + 3, n2 + 1));
        if (bitSetArray == null) {
            this.sg.setParameter("select", bitSet);
        } else {
            bitSetArray[0] = bitSet;
        }
        n = string.indexOf("({", n2);
        if (n < 0) {
            return true;
        }
        n2 = string.indexOf("})", n);
        if (n2 < 0) {
            return false;
        }
        bitSet = Escape.unescapeBitset(string.substring(n + 1, n2 + 1));
        if (bitSetArray == null) {
            this.sg.setParameter("ignore", bitSet);
        } else {
            bitSetArray[1] = bitSet;
        }
        n = string.indexOf("/({", n2);
        if (n == n2 + 2) {
            n2 = string.indexOf("})", n);
            if (n2 < 0) {
                return false;
            }
            bitSet = Escape.unescapeBitset(string.substring(n + 3, n2 + 1));
            if (bitSetArray == null) {
                this.viewer.setTrajectory(bitSet);
            } else {
                bitSetArray[2] = bitSet;
            }
        }
        return true;
    }

    protected void getCapSlabInfo(String string) {
        int n = string.indexOf("# SLAB=");
        if (n >= 0) {
            this.sg.setParameter("slab", this.getCapSlabObject(n, string));
        }
        if ((n = string.indexOf("# CAP=")) >= 0) {
            this.sg.setParameter("cap", this.getCapSlabObject(n, string));
        }
    }

    private Object getCapSlabObject(int n, String string) {
        try {
            String string2 = Parser.getNextQuotedString(string, n);
            if (string2.indexOf("array") == 0) {
                String[] stringArray = TextFormat.split(string2.substring(6, string2.length() - 1), ",");
                return new Point3f[]{(Point3f)Escape.unescapePoint(stringArray[0]), (Point3f)Escape.unescapePoint(stringArray[1]), (Point3f)Escape.unescapePoint(stringArray[2]), (Point3f)Escape.unescapePoint(stringArray[3])};
            }
            return Escape.unescapePoint(string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void initializeIsosurface() {
        this.lighting = 0x40000049;
        if (!this.iHaveModelIndex) {
            this.modelIndex = this.viewer.getCurrentModelIndex();
        }
        boolean bl = this.isFixed = this.modelIndex < 0;
        if (this.modelIndex < 0) {
            this.modelIndex = 0;
        }
        this.title = null;
        this.explicitContours = false;
        this.atomIndex = -1;
        this.colix = (short)5;
        this.meshColix = 0;
        this.defaultColix = 0;
        this.isColorExplicit = false;
        this.isPhaseColored = false;
        this.allowContourLines = true;
        this.center = new Point3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.offset = null;
        this.scale3d = 0.0f;
        this.withinPoints = null;
        this.linkedMesh = null;
        this.initState();
    }

    private void initState() {
        this.associateNormals = true;
        this.sg.initState();
    }

    private void discardTempData(boolean bl) {
        if (!bl) {
            return;
        }
        this.title = null;
        if (this.thisMesh == null) {
            return;
        }
        this.thisMesh.surfaceSet = null;
    }

    private short getDefaultColix() {
        int n;
        if (this.defaultColix != 0) {
            return this.defaultColix;
        }
        if (!this.sg.isCubeData()) {
            return this.colix;
        }
        if (this.sg.getCutoff() >= 0.0f) {
            this.indexColorPositive %= JmolConstants.argbsIsosurfacePositive.length;
            n = JmolConstants.argbsIsosurfacePositive[this.indexColorPositive++];
        } else {
            this.indexColorNegative %= JmolConstants.argbsIsosurfaceNegative.length;
            n = JmolConstants.argbsIsosurfaceNegative[this.indexColorNegative++];
        }
        return Graphics3D.getColix(n);
    }

    private void drawLcaoCartoon(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, int n) {
        Object object;
        Object object2;
        boolean bl;
        String string = this.sg.setLcao();
        float f = vector3f3.x + vector3f3.y + vector3f3.z;
        this.defaultColix = Graphics3D.getColix(this.sg.getColor(1));
        int n2 = this.sg.getColor(-1);
        Vector3f vector3f4 = new Vector3f();
        boolean bl2 = bl = string.length() > 0 && string.charAt(0) == '-';
        if (bl) {
            string = string.substring(1);
        }
        int n3 = bl ? -1 : 1;
        vector3f4.cross(vector3f, vector3f2);
        if (f != 0.0f) {
            object2 = new AxisAngle4f();
            if (vector3f3.x != 0.0f) {
                ((AxisAngle4f)object2).set(vector3f2, f);
            } else if (vector3f3.y != 0.0f) {
                ((AxisAngle4f)object2).set(vector3f4, f);
            } else {
                ((AxisAngle4f)object2).set(vector3f, f);
            }
            object = new Matrix3f();
            ((Matrix3f)object).set((AxisAngle4f)object2);
            ((Matrix3f)object).transform(vector3f2);
            ((Matrix3f)object).transform(vector3f4);
            ((Matrix3f)object).transform(vector3f);
        }
        if (this.thisMesh == null && this.nLCAO == 0) {
            this.nLCAO = this.meshCount;
        }
        Object object3 = this.thisMesh == null ? (n > 0 ? "lp" : "lcao") + ++this.nLCAO + "_" + string : (object2 = this.thisMesh.thisID);
        if (this.thisMesh == null) {
            this.allocMesh((String)object2);
        }
        if (string.equals("px")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            object = this.thisMesh;
            this.createLcaoLobe(vector3f2, n3, n);
            if (n > 0) {
                return;
            }
            this.setProperty("thisID", (String)object2 + "b", null);
            this.createLcaoLobe(vector3f2, -n3, n);
            this.thisMesh.colix = Graphics3D.getColix(n2);
            this.linkedMesh = this.thisMesh.linkedMesh = object;
            return;
        }
        if (string.equals("py")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            object = this.thisMesh;
            this.createLcaoLobe(vector3f4, n3, n);
            if (n > 0) {
                return;
            }
            this.setProperty("thisID", (String)object2 + "b", null);
            this.createLcaoLobe(vector3f4, -n3, n);
            this.thisMesh.colix = Graphics3D.getColix(n2);
            this.linkedMesh = this.thisMesh.linkedMesh = object;
            return;
        }
        if (string.equals("pz")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            object = this.thisMesh;
            this.createLcaoLobe(vector3f, n3, n);
            if (n > 0) {
                return;
            }
            this.setProperty("thisID", (String)object2 + "b", null);
            this.createLcaoLobe(vector3f, -n3, n);
            this.thisMesh.colix = Graphics3D.getColix(n2);
            this.linkedMesh = this.thisMesh.linkedMesh = object;
            return;
        }
        if (string.equals("pxa")) {
            this.createLcaoLobe(vector3f2, n3, n);
            return;
        }
        if (string.equals("pxb")) {
            this.createLcaoLobe(vector3f2, -n3, n);
            return;
        }
        if (string.equals("pya")) {
            this.createLcaoLobe(vector3f4, n3, n);
            return;
        }
        if (string.equals("pyb")) {
            this.createLcaoLobe(vector3f4, -n3, n);
            return;
        }
        if (string.equals("pza")) {
            this.createLcaoLobe(vector3f, n3, n);
            return;
        }
        if (string.equals("pzb")) {
            this.createLcaoLobe(vector3f, -n3, n);
            return;
        }
        if (string.indexOf("sp") == 0 || string.indexOf("lp") == 0) {
            this.createLcaoLobe(vector3f, n3, n);
            return;
        }
        if (string.equals("spacefill") || string.equals("cpk")) {
            this.createLcaoLobe(null, 2.0f * this.viewer.getAtomRadius(this.atomIndex), n);
            return;
        }
        this.createLcaoLobe(null, 1.0f, n);
    }

    private void createLcaoLobe(Vector3f vector3f, float f, int n) {
        this.initState();
        if (Logger.debugging) {
            Logger.debug("creating isosurface ID " + this.thisMesh.thisID);
        }
        this.thisMesh.colix = this.defaultColix;
        if (vector3f == null) {
            this.setProperty("sphere", new Float(f / 2.0f), null);
        } else {
            this.lcaoDir.x = vector3f.x * f;
            this.lcaoDir.y = vector3f.y * f;
            this.lcaoDir.z = vector3f.z * f;
            this.lcaoDir.w = 0.7f;
            this.setProperty(n == 2 ? "lp" : (n == 1 ? "rad" : "lobe"), this.lcaoDir, null);
        }
        this.setScriptInfo();
    }

    public void invalidateTriangles() {
        this.thisMesh.invalidatePolygons();
    }

    public void fillMeshData(MeshData meshData, int n, IsosurfaceMesh isosurfaceMesh) {
        if (meshData == null) {
            if (this.thisMesh == null) {
                this.allocMesh(null);
            }
            this.thisMesh.clear("isosurface", this.sg.getIAddGridPoints());
            this.thisMesh.colix = this.getDefaultColix();
            this.thisMesh.meshColix = this.meshColix;
            if (this.isPhaseColored || this.thisMesh.jvxlData.isBicolorMap) {
                this.thisMesh.isColorSolid = false;
            }
            return;
        }
        if (isosurfaceMesh == null) {
            isosurfaceMesh = this.thisMesh;
        }
        if (isosurfaceMesh == null) {
            return;
        }
        switch (n) {
            case 1: {
                meshData.vertices = isosurfaceMesh.vertices;
                meshData.vertexValues = isosurfaceMesh.vertexValues;
                meshData.vertexCount = isosurfaceMesh.vertexCount;
                meshData.vertexIncrement = isosurfaceMesh.vertexIncrement;
                meshData.polygonCount = isosurfaceMesh.polygonCount;
                meshData.polygonIndexes = isosurfaceMesh.polygonIndexes;
                meshData.polygonColixes = isosurfaceMesh.polygonColixes;
                return;
            }
            case 2: {
                if (isosurfaceMesh.vertexColixes == null || isosurfaceMesh.vertexCount > isosurfaceMesh.vertexColixes.length) {
                    isosurfaceMesh.vertexColixes = new short[isosurfaceMesh.vertexCount];
                }
                meshData.vertexColixes = isosurfaceMesh.vertexColixes;
                meshData.polygonIndexes = null;
                return;
            }
            case 3: {
                isosurfaceMesh.surfaceSet = meshData.surfaceSet;
                isosurfaceMesh.vertexSets = meshData.vertexSets;
                isosurfaceMesh.nSets = meshData.nSets;
                return;
            }
            case 4: {
                isosurfaceMesh.vertices = meshData.vertices;
                isosurfaceMesh.vertexValues = meshData.vertexValues;
                isosurfaceMesh.vertexCount = meshData.vertexCount;
                isosurfaceMesh.vertexIncrement = meshData.vertexIncrement;
                isosurfaceMesh.polygonCount = meshData.polygonCount;
                isosurfaceMesh.polygonIndexes = meshData.polygonIndexes;
                isosurfaceMesh.polygonColixes = meshData.polygonColixes;
                return;
            }
        }
    }

    public void notifySurfaceGenerationCompleted() {
        this.setModelIndex();
        this.thisMesh.insideOut = this.sg.isInsideOut();
        this.thisMesh.calculatedArea = null;
        this.thisMesh.calculatedVolume = null;
        this.thisMesh.initialize(this.sg.getPlane() != null ? 0x4000004C : this.lighting, null);
        if (this.thisMesh.jvxlData.jvxlPlane != null) {
            this.allowContourLines = false;
        }
        this.thisMesh.isSolvent = (this.sg.getDataType() & 0x80) != 0;
    }

    public void notifySurfaceMappingCompleted() {
        this.setModelIndex();
        String string = this.colorEncoder.getColorSchemeName();
        this.viewer.setPropertyColorScheme(string, this.sg.getParams().colorSchemeTranslucent, false);
        this.viewer.setCurrentColorRange(this.jvxlData.valueMappedToRed, this.jvxlData.valueMappedToBlue);
        this.thisMesh.isColorSolid = false;
        this.thisMesh.colorDensity = this.jvxlData.colorDensity;
        this.thisMesh.getContours();
        if (this.thisMesh.jvxlData.jvxlPlane != null) {
            this.allowContourLines = false;
        }
        if (this.thisMesh.jvxlData.nContours != 0 && this.thisMesh.jvxlData.nContours != -1) {
            this.explicitContours = true;
        }
        if (this.explicitContours && this.thisMesh.jvxlData.jvxlPlane != null) {
            this.thisMesh.havePlanarContours = true;
        }
        this.setPropertySuper("token", new Integer(this.explicitContours ? 1073741945 : 1073741887), null);
        this.setPropertySuper("token", new Integer(this.explicitContours ? 1073741861 : 0x40000074), null);
        this.setColorCommand(string, true);
    }

    private void setColorCommand(String string, boolean bl) {
        if (this.thisMesh == null) {
            return;
        }
        this.thisMesh.colorCommand = "color $" + this.thisMesh.thisID + " " + this.getUserColorScheme(string) + " range ";
        if (bl) {
            this.thisMesh.colorCommand = this.thisMesh.colorCommand + (this.jvxlData.isColorReversed ? this.jvxlData.valueMappedToBlue + " " + this.jvxlData.valueMappedToRed : this.jvxlData.valueMappedToRed + " " + this.jvxlData.valueMappedToBlue);
            return;
        }
        float[] fArray = this.viewer.getCurrentColorRange();
        this.thisMesh.colorCommand = this.thisMesh.colorCommand + fArray[0] + " " + fArray[1];
    }

    public Point3f[] calculateGeodesicSurface(BitSet bitSet, float f) {
        return this.viewer.calculateSurface(bitSet, f);
    }

    public int getSurfacePointIndexAndFraction(float f, boolean bl, int n, int n2, int n3, Point3i point3i, int n4, int n5, float f2, float f3, Point3f point3f, Vector3f vector3f, boolean bl2, float[] fArray) {
        return 0;
    }

    public int addVertexCopy(Point3f point3f, float f, int n) {
        return this.withinPoints != null && !this.checkWithin(point3f) ? -1 : this.thisMesh.addVertexCopy(point3f, f, n, this.associateNormals);
    }

    private boolean checkWithin(Point3f point3f) {
        int n = this.withinPoints.size();
        while (--n >= 0) {
            if (!(point3f.distance((Point3f)this.withinPoints.get(n)) <= this.withinDistance)) continue;
            return true;
        }
        return false;
    }

    public int addTriangleCheck(int n, int n2, int n3, int n4, int n5, boolean bl, int n6) {
        return n < 0 || n2 < 0 || n3 < 0 || bl && !MeshData.checkCutoff(n, n2, n3, this.thisMesh.vertexValues) ? -1 : this.thisMesh.addTriangleCheck(n, n2, n3, n4, n5, n6);
    }

    private void setModelIndex() {
        this.setModelIndex(this.atomIndex, this.modelIndex);
        this.thisMesh.ptCenter.set(this.center);
        this.thisMesh.ptOffset = this.offset;
        this.thisMesh.scale3d = this.thisMesh.jvxlData.jvxlPlane == null ? 0.0f : this.scale3d;
    }

    protected void setScriptInfo() {
        int n;
        this.thisMesh.title = this.sg.getTitle();
        String string = this.sg.getScript();
        this.thisMesh.dataType = this.sg.getParams().dataType;
        this.thisMesh.scale3d = this.sg.getParams().scale3d;
        this.thisMesh.bitsets = null;
        this.thisMesh.slabbingObject = this.sg.getParams().slabbingObject;
        this.thisMesh.cappingObject = this.sg.getParams().cappingObject;
        if (string != null) {
            if (string.charAt(0) == ' ') {
                string = this.myType + " ID " + Escape.escape(this.thisMesh.thisID) + string;
            } else if (this.sg.getIUseBitSets()) {
                this.thisMesh.bitsets = new BitSet[3];
                this.thisMesh.bitsets[0] = this.sg.getBsSelected();
                this.thisMesh.bitsets[1] = this.sg.getBsIgnore();
                this.thisMesh.bitsets[2] = this.viewer.getBitSetTrajectories();
            }
        }
        if (!this.explicitID && string != null && (n = string.indexOf("# ID=")) >= 0) {
            this.thisMesh.thisID = Parser.getNextQuotedString(string, n);
        }
        this.thisMesh.scriptCommand = string;
        Vector vector = this.sg.getFunctionXYinfo();
        if (this.thisMesh.data1 == null) {
            this.thisMesh.data1 = vector;
        } else {
            this.thisMesh.data2 = vector;
        }
    }

    private void setJvxlInfo() {
        if (this.sg.getJvxlData() != this.jvxlData || this.sg.getJvxlData() != this.thisMesh.jvxlData) {
            this.jvxlData = this.thisMesh.jvxlData = this.sg.getJvxlData();
        }
    }

    public Vector getShapeDetail() {
        Vector vector = new Vector();
        for (int i = 0; i < this.meshCount; ++i) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            IsosurfaceMesh isosurfaceMesh = this.isomeshes[i];
            if (isosurfaceMesh == null || isosurfaceMesh.vertices == null) continue;
            hashtable.put("ID", isosurfaceMesh.thisID == null ? "<noid>" : isosurfaceMesh.thisID);
            hashtable.put("vertexCount", new Integer(isosurfaceMesh.vertexCount));
            if (isosurfaceMesh.ptCenter.x != Float.MAX_VALUE) {
                hashtable.put("center", isosurfaceMesh.ptCenter);
            }
            hashtable.put("offset", isosurfaceMesh.ptOffset == null ? new Point3f() : isosurfaceMesh.ptOffset);
            if (isosurfaceMesh.scale3d != 0.0f) {
                hashtable.put("scale3d", new Float(isosurfaceMesh.scale3d));
            }
            hashtable.put("xyzMin", isosurfaceMesh.jvxlData.boundingBox[0]);
            hashtable.put("xyzMax", isosurfaceMesh.jvxlData.boundingBox[1]);
            String string = JvxlCoder.jvxlGetInfo(isosurfaceMesh.jvxlData);
            if (string != null) {
                hashtable.put("jvxlInfo", string.replace('\n', ' '));
            }
            hashtable.put("modelIndex", new Integer(isosurfaceMesh.modelIndex));
            if (isosurfaceMesh.title != null) {
                hashtable.put("title", isosurfaceMesh.title);
            }
            if (isosurfaceMesh.jvxlData.contourValues != null || isosurfaceMesh.jvxlData.contourValuesUsed != null) {
                hashtable.put("contours", isosurfaceMesh.getContourList(this.viewer));
            }
            vector.addElement(hashtable);
        }
        return vector;
    }

    protected void remapColors() {
        int n;
        JvxlData jvxlData = this.thisMesh.jvxlData;
        float[] fArray = this.thisMesh.vertexValues;
        short[] sArray = this.thisMesh.vertexColixes;
        this.thisMesh.polygonColixes = null;
        if (fArray == null || jvxlData.isBicolorMap || jvxlData.vertexCount == 0) {
            return;
        }
        if (sArray == null) {
            sArray = this.thisMesh.vertexColixes = new short[this.thisMesh.vertexCount];
        }
        boolean bl = Graphics3D.isColixTranslucent(this.thisMesh.colix);
        int n2 = this.thisMesh.vertexCount;
        while (--n2 >= 0) {
            sArray[n2] = this.viewer.getColixForPropertyValue(fArray[n2]);
            if (!bl) continue;
            sArray[n2] = Graphics3D.getColixTranslucent(sArray[n2], true, this.translucentLevel);
        }
        Vector[] vectorArray = this.thisMesh.getContours();
        if (vectorArray != null) {
            n = vectorArray.length;
            while (--n >= 0) {
                float f = ((Float)vectorArray[n].get(2)).floatValue();
                short[] sArray2 = (short[])vectorArray[n].get(3);
                sArray2[0] = this.viewer.getColixForPropertyValue(f);
                int[] nArray = (int[])vectorArray[n].get(4);
                nArray[0] = Graphics3D.getArgb(sArray2[0]);
            }
        }
        if (this.thisMesh.contourValues != null) {
            this.thisMesh.contourColixes = new short[this.thisMesh.contourValues.length];
            for (n = 0; n < this.thisMesh.contourValues.length; ++n) {
                this.thisMesh.contourColixes[n] = this.viewer.getColixForPropertyValue(this.thisMesh.contourValues[n]);
            }
            this.thisMesh.setDiscreteColixes(null, null);
        }
        float[] fArray2 = this.viewer.getCurrentColorRange();
        jvxlData.valueMappedToRed = Math.min(fArray2[0], fArray2[1]);
        jvxlData.valueMappedToBlue = Math.max(fArray2[0], fArray2[1]);
        jvxlData.isJvxlPrecisionColor = true;
        JvxlCoder.jvxlCreateColorData(jvxlData, fArray);
        this.setColorCommand(this.viewer.getPropertyColorScheme(), false);
        this.thisMesh.isColorSolid = false;
    }

    private String getUserColorScheme(String string) {
        String string2 = this.viewer.getColorSchemeList(string, false);
        return "\"" + (string2.length() == 0 ? string : string2) + "\"";
    }

    public void getPlane(int n) {
    }

    public float getValue(int n, int n2, int n3, int n4) {
        return 0.0f;
    }

    public boolean checkObjectHovered(int n, int n2, BitSet bitSet) {
        if (!this.viewer.getDrawHover()) {
            return false;
        }
        String string = this.findValue(n, n2, false, bitSet);
        if (string == null) {
            return false;
        }
        if (this.g3d.isDisplayAntialiased()) {
            n <<= 1;
            n2 <<= 1;
        }
        this.viewer.hoverOn(n, n2, string);
        return true;
    }

    public Point3fi checkObjectClicked(int n, int n2, int n3, BitSet bitSet) {
        Tuple3f tuple3f;
        if (!this.viewer.isBound(n3, 29)) {
            return null;
        }
        int n4 = 100;
        if (this.g3d.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
            n4 <<= 1;
        }
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = Integer.MIN_VALUE;
        int n9 = Integer.MAX_VALUE;
        for (int i = 0; i < this.meshCount && n5 < 0; ++i) {
            IsosurfaceMesh isosurfaceMesh = this.isomeshes[i];
            if (isosurfaceMesh.visibilityFlags == 0 || isosurfaceMesh.modelIndex >= 0 && !bitSet.get(isosurfaceMesh.modelIndex)) continue;
            Point3f[] point3fArray = isosurfaceMesh.getCenters();
            int n10 = point3fArray.length;
            while (--n10 >= 0) {
                tuple3f = point3fArray[n10];
                int n11 = this.coordinateInRange(n, n2, (Point3f)tuple3f, n4, this.ptXY);
                if (n11 < 0) continue;
                n5 = i;
                if (this.ptXY.z < n9) {
                    n9 = this.ptXY.z;
                    n7 = n10;
                }
                if (this.ptXY.z <= n8) continue;
                n8 = this.ptXY.z;
                n6 = n10;
            }
        }
        if (n5 < 0) {
            return null;
        }
        IsosurfaceMesh isosurfaceMesh = this.isomeshes[n5];
        this.setPropertySuper("thisID", isosurfaceMesh.thisID, null);
        boolean bl = false;
        int n12 = bl ? n7 : n6;
        Point3fi point3fi = new Point3fi();
        point3fi.set(isosurfaceMesh.centers[n12]);
        point3fi.modelIndex = (short)isosurfaceMesh.modelIndex;
        tuple3f = new Vector3f();
        isosurfaceMesh.getFacePlane(n12, (Vector3f)tuple3f);
        tuple3f.scale(-1.0f);
        this.setHeading(point3fi, (Vector3f)tuple3f, 2);
        return point3fi;
    }

    private void navigate(int n) {
        if (this.thisMesh == null) {
            return;
        }
        Point3f point3f = new Point3f(this.viewer.getNavigationOffset());
        Point3f point3f2 = new Point3f();
        this.viewer.unTransformPoint(point3f, point3f2);
        point3f.z += (float)n;
        this.viewer.unTransformPoint(point3f, point3f2);
        Point3f point3f3 = new Point3f();
        Vector3f vector3f = new Vector3f();
        if (!this.getClosestNormal(this.thisMesh, point3f2, point3f3, vector3f)) {
            return;
        }
        Point3f point3f4 = new Point3f(point3f3);
        point3f4.add(vector3f);
        Point3f point3f5 = new Point3f();
        this.viewer.transformPoint(point3f4, point3f5);
        if (point3f5.y > point3f.y) {
            vector3f.scale(-1.0f);
        }
        this.setHeading(point3f3, vector3f, 0);
    }

    private void setHeading(Point3f point3f, Vector3f vector3f, int n) {
        StateManager.Orientation orientation = this.viewer.getOrientation();
        this.viewer.navigate(0.0f, point3f);
        Point3f point3f2 = new Point3f();
        Point3f point3f3 = new Point3f(vector3f);
        point3f3.add(point3f);
        this.viewer.transformPoint(point3f3, point3f2);
        Point3f point3f4 = new Point3f(this.viewer.getNavigationOffset());
        point3f2.sub(point3f4);
        point3f2.z = 0.0f;
        float f = Measure.computeTorsion(JmolConstants.axisNY, JmolConstants.center, JmolConstants.axisZ, point3f2, true);
        this.viewer.navigate(0.0f, JmolConstants.axisZ, f);
        point3f3.set(vector3f);
        point3f3.add(point3f);
        this.viewer.transformPoint(point3f3, point3f2);
        point3f2.sub(point3f4);
        f = Measure.computeTorsion(JmolConstants.axisNY, JmolConstants.center, JmolConstants.axisX, point3f2, true);
        this.viewer.navigate(0.0f, JmolConstants.axisX, 20.0f - f);
        point3f4 = new Point3f(this.viewer.getNavigationOffset());
        if (n <= 0) {
            return;
        }
        this.viewer.saveOrientation("_navsurf");
        orientation.restore(0.0f, true);
        this.viewer.script("restore orientation _navsurf " + n);
    }

    private boolean getClosestNormal(IsosurfaceMesh isosurfaceMesh, Point3f point3f, Point3f point3f2, Vector3f vector3f) {
        Point3f[] point3fArray = isosurfaceMesh.getCenters();
        float f = Float.MAX_VALUE;
        int n = -1;
        int n2 = point3fArray.length;
        while (--n2 >= 0) {
            float f2;
            float f3 = point3fArray[n2].distance(point3f);
            if (f2 >= f) continue;
            f = f3;
            n = n2;
        }
        if (n < 0) {
            return false;
        }
        this.getClosestPoint(isosurfaceMesh, n, point3f, point3f2, vector3f);
        return true;
    }

    private void getClosestPoint(IsosurfaceMesh isosurfaceMesh, int n, Point3f point3f, Point3f point3f2, Vector3f vector3f) {
        Point4f point4f = isosurfaceMesh.getFacePlane(n, vector3f);
        float f = Measure.distanceToPlane(point4f, point3f);
        vector3f.scale(-f);
        point3f2.set(point3f);
        point3f2.add(vector3f);
        f = Measure.distanceToPlane(point4f, point3f2);
        if (isosurfaceMesh.centers[n].distance(point3f) < point3f2.distance(point3f)) {
            point3f2.set(isosurfaceMesh.centers[n]);
        }
    }

    private String findValue(int n, int n2, boolean bl, BitSet bitSet) {
        int n3 = 100;
        if (this.g3d.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
            n3 <<= 1;
        }
        Vector vector = null;
        for (int i = 0; i < this.meshCount; ++i) {
            int n4;
            int n5;
            int n6;
            IsosurfaceMesh isosurfaceMesh = this.isomeshes[i];
            if (isosurfaceMesh.visibilityFlags == 0 || isosurfaceMesh.modelIndex >= 0 && !bitSet.get(isosurfaceMesh.modelIndex)) continue;
            Vector[] vectorArray = isosurfaceMesh.jvxlData.vContours;
            if (vectorArray != null) {
                for (n6 = 0; n6 < vectorArray.length; ++n6) {
                    Vector vector2 = vectorArray[n6];
                    int n7 = vector2.size() - 1;
                    for (n5 = 6; n5 < n7; ++n5) {
                        Point3f point3f = (Point3f)vector2.get(n5);
                        int n8 = this.coordinateInRange(n, n2, point3f, n3, this.ptXY);
                        if (n8 < 0) continue;
                        n3 = n8;
                        vector = vector2;
                    }
                }
                if (vector == null) continue;
                return vector.get(2).toString();
            }
            if (isosurfaceMesh.jvxlData.jvxlPlane != null && isosurfaceMesh.vertexValues != null) {
                n6 = -1;
                n4 = isosurfaceMesh.vertexCount;
                while (--n4 >= isosurfaceMesh.firstRealVertex) {
                    Point3f point3f;
                    if (Float.isNaN(isosurfaceMesh.firstRealVertex) || (n5 = this.coordinateInRange(n, n2, point3f = isosurfaceMesh.vertices[n4], n3, this.ptXY)) < 0) continue;
                    n3 = n5;
                    n6 = n4;
                }
                if (n6 == -1) continue;
                return "v" + n6 + ": " + isosurfaceMesh.vertexValues[n6];
            }
            if (isosurfaceMesh.vertexValues == null) continue;
            n6 = -1;
            n4 = isosurfaceMesh.vertexCount;
            while (--n4 >= isosurfaceMesh.firstRealVertex) {
                Point3f point3f = isosurfaceMesh.vertices[n4];
                n5 = this.coordinateInRange(n, n2, point3f, n3, this.ptXY);
                if (n5 < 0) continue;
                n3 = n5;
                n6 = n4;
            }
            if (n6 == -1) continue;
            return "v" + n6 + ": " + isosurfaceMesh.vertexValues[n6];
        }
        return null;
    }
}

