<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:exsl="http://exslt.org/common"
                              xmlns:date="http://exslt.org/dates-and-times"
                              extension-element-prefixes="exsl date">

   <!--                                                                         -->
   <!-- Initalization part                                                      -->
   <!--                                                                         -->

   <!-- Well, you know... -->
   <xsl:param name="skin_version">unknown</xsl:param>

   <!-- Where to output files ? Default to current dir -->
   <xsl:param name="output_dir">.</xsl:param>

   <!-- Where are the other XML files ? This is needed in order to load history.xml -->
   <xsl:param name="xml_dir">.</xsl:param>

   <!-- What to is the skin settings file? Default to ./options.xml -->
   <xsl:param name="skin_settings_file"></xsl:param>

   <!-- We keep month number in form mm, to be able to generate file names  -->
   <xsl:variable name="current_month" select="/body/month"/>

   <!-- We keepyear in form yyyy, to be able to generate file names  -->
   <xsl:variable name="current_year" select="/body/year"/>

   <!-- Load skin settings -->
   <xsl:variable name="skin_settings" select="document($skin_settings_file)/settings"/>

   <!-- Load history settings -->
   <xsl:variable name="history_settings" select="document(concat($xml_dir, '/', 'history.xml'))/body/year"/>

   <!-- Includes -->

   <xsl:include href="shared.xsl"/>

   <!--                                                                         -->
   <!-- Common part                                                             -->
   <!--                                                                         -->

   <xsl:template match="/body">
      <xsl:apply-templates select="node()"/>
   </xsl:template>

   <!-- strip unknown nodes -->
   <xsl:template match="node()">
   </xsl:template>

   <!--                                                                         -->
   <!-- Sites part                                                              -->
   <!--                                                                         -->

   <!-- Sites table -->
   <xsl:template match="list[@key='hits']">
      <p/>
      <table width="510" border="1" cellspacing="0" cellpadding="2" bordercolor="#CCCCCC" align="center" class="RP_description_text">
      <tr bgcolor="#CCCCCC">
         <th align="center" colspan="10">
            Top <xsl:value-of select="$skin_settings/table[@name='TopSites']/setting[@name='nTop']/value"/> of <xsl:value-of select="../count/@value"/> Total Sites
         </th>
      </tr>
      <tr>
         <th bgcolor="#CCCCCC" align="center">#</th>
         <xsl:if test="$skin_settings/table[@name='TopSites']/setting[@name='ShowPercent']/value = 'yes'">
            <th bgcolor="#78D796" align="center" colspan="2">Hits</th>
            <th bgcolor="#85C4FF" align="center" colspan="2">Files</th>
            <th bgcolor="#FF7878" align="center" colspan="2">KBytes</th>
            <th bgcolor="#FAFF8A" align="center" colspan="2">Visits</th>
         </xsl:if>
         <xsl:if test="$skin_settings/table[@name='TopSites']/setting[@name='ShowPercent']/value != 'yes'">
            <th bgcolor="#78D796" align="center">Hits</th>
            <th bgcolor="#85C4FF" align="center">Files</th>
            <th bgcolor="#FF7878" align="center">KBytes</th>
            <th bgcolor="#FAFF8A" align="center">Visits</th>
         </xsl:if>
         <th bgcolor="#9EF9FF" align="center">Hostname</th>
      </tr>
      <xsl:apply-templates select="site[$skin_settings/table[@name='TopSites']/setting[@name='nTop']/value >= position()]"/>
      <tr>
         <th height="4"></th>
      </tr>
      <tr bgcolor="#CCCCCC">
         <td colspan="10" align="center"> <a href="./site_200306.html">View All
            Sites</a></td>
      </tr>
      </table>
   </xsl:template>

   <xsl:template match="list[@key='hits']/site">
      <tr>
         <td align="center"><xsl:value-of select="position()"/></td>
         <td align="right"><b><xsl:value-of select="@hits"/></b></td>
         <xsl:if test="$skin_settings/table[@name='TopSites']/setting[@name='ShowPercent']/value = 'yes'">
            <td align="right"><xsl:value-of select="format-number(@hits div ../../sums/@hits, '##.#%')"/></td>
         </xsl:if>
         <td align="right"><b><xsl:value-of select="@files"/></b></td>
         <xsl:if test="$skin_settings/table[@name='TopSites']/setting[@name='ShowPercent']/value = 'yes'">
            <td align="right"><xsl:value-of select="format-number(@files div ../../sums/@files, '##.#%')"/></td>
         </xsl:if>
         <td align="right"><b><xsl:value-of select="@kilobytes"/></b></td>
         <xsl:if test="$skin_settings/table[@name='TopSites']/setting[@name='ShowPercent']/value = 'yes'">
            <td align="right"><xsl:value-of select="format-number(@kilobytes div ../../sums/@kilobytes, '##.#%')"/></td>
         </xsl:if>
         <td align="right"><b><xsl:value-of select="@visits"/></b></td>
         <xsl:if test="$skin_settings/table[@name='TopSites']/setting[@name='ShowPercent']/value = 'yes'">
            <td align="right"><xsl:value-of select="format-number(@visits div ../../sums/@visits, '##.#%')"/></td>
         </xsl:if>
         <td align="left"><xsl:value-of select="@hostname"/></td>
      </tr>
   </xsl:template>

   <!-- Sites table (sorted per kbyte)-->
   <xsl:template match="list[@key='kilobytes']">
      <p/>
      <table width="510" border="1" cellspacing="0" cellpadding="2" bordercolor="#CCCCCC" align="center" class="RP_description_text">
      <tr bgcolor="#CCCCCC">
         <th align="center" colspan="10">
            Top <xsl:value-of select="$skin_settings/table[@name='TopKSites']/setting[@name='nTop']/value"/> of <xsl:value-of select="../count/@value"/>
            Total Sites (sorted per Kilobytes)
         </th>
      </tr>
      <tr>
         <th bgcolor="#CCCCCC" align="center">#</th>
         <xsl:if test="$skin_settings/table[@name='TopKSites']/setting[@name='ShowPercent']/value = 'yes'">
            <th bgcolor="#78D796" align="center" colspan="2">Hits</th>
            <th bgcolor="#85C4FF" align="center" colspan="2">Files</th>
            <th bgcolor="#FF7878" align="center" colspan="2">KBytes</th>
            <th bgcolor="#FAFF8A" align="center" colspan="2">Visits</th>
         </xsl:if>
         <xsl:if test="$skin_settings/table[@name='TopKSites']/setting[@name='ShowPercent']/value != 'yes'">
            <th bgcolor="#78D796" align="center">Hits</th>
            <th bgcolor="#85C4FF" align="center">Files</th>
            <th bgcolor="#FF7878" align="center">KBytes</th>
            <th bgcolor="#FAFF8A" align="center">Visits</th>
         </xsl:if>
         <th bgcolor="#9EF9FF" align="center">Hostname</th>
      </tr>
      <xsl:apply-templates select="site[$skin_settings/table[@name='TopKSites']/setting[@name='nTop']/value >= position()]"/>
      <tr>
         <th height="4"></th>
      </tr>
      <tr bgcolor="#CCCCCC">
         <td colspan="10" align="center"> <a href="./site_200306.html">View All
            Sites</a></td>
      </tr>
      </table>
   </xsl:template>

   <xsl:template match="list[@key='kilobytes']/site">
      <tr>
         <td align="center"><xsl:value-of select="position()"/></td>
         <td align="right"><b><xsl:value-of select="@hits"/></b></td>
         <xsl:if test="$skin_settings/table[@name='TopKSites']/setting[@name='ShowPercent']/value = 'yes'">
            <td align="right"><xsl:value-of select="format-number(@hits div ../../sums/@hits, '##.#%')"/></td>
         </xsl:if>
         <td align="right"><b><xsl:value-of select="@files"/></b></td>
         <xsl:if test="$skin_settings/table[@name='TopKSites']/setting[@name='ShowPercent']/value = 'yes'">
            <td align="right"><xsl:value-of select="format-number(@files div ../../sums/@files, '##.#%')"/></td>
         </xsl:if>
         <td align="right"><b><xsl:value-of select="@kilobytes"/></b></td>
         <xsl:if test="$skin_settings/table[@name='TopKSites']/setting[@name='ShowPercent']/value = 'yes'">
            <td align="right"><xsl:value-of select="format-number(@kilobytes div ../../sums/@kilobytes, '##.#%')"/></td>
         </xsl:if>
         <td align="right"><b><xsl:value-of select="@visits"/></b></td>
         <xsl:if test="$skin_settings/table[@name='TopKSites']/setting[@name='ShowPercent']/value = 'yes'">
            <td align="right"><xsl:value-of select="format-number(@visits div ../../sums/@visits, '##.#%')"/></td>
         </xsl:if>
         <td align="left"><xsl:value-of select="@hostname"/></td>
      </tr>
   </xsl:template>

   <!-- Site document creation starts here -->
   <xsl:template match="sites">
      <xsl:document href="{$output_dir}/sites_{$current_year}_{$current_month}.html"
                  method="html"
                  encoding="UTF-8"
                  doctype-public="-//W3C/DTD XHTML 1.0 Strict//EN"
                  doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"
                  indent="yes"
                  >

         <html>
         <head>
            <meta http-equiv="Content-Style-Type" content="text/css"/>
            <link rel="stylesheet" href="classic.css"/>
            <title>Statistics for <xsl:value-of select="/body/globalsettings/setting[@name='HostName']/value"/> - Sites </title>
         </head>

         <body>
            <table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">
            <tr valign="top">

               <!-- Call left panel creation procedure -->
               <xsl:call-template name="leftpanel">
                  <xsl:with-param name="cur_page">sites</xsl:with-param>
                  <xsl:with-param name="year" select="$current_year"/>
                  <xsl:with-param name="month" select="$current_month"/>
               </xsl:call-template>

               <td width="40" background="separator.png"><img src="separator.png" width="40" height="1"/></td>

               <td width="*">

                  <!-- draw header -->
                  <xsl:call-template name="header">
                     <xsl:with-param name="page_title">Sites</xsl:with-param>
                     <xsl:with-param name="page_name">sites</xsl:with-param>
                     <xsl:with-param name="cur_month" select="$current_month"/>
                     <xsl:with-param name="cur_year" select="$current_year"/>
                  </xsl:call-template>

                  <p class="RP_description_text"> Here is the list of the Sites.<br/>
                     It is the location of users on the internet.<br/>
                     With this you can know which users became 'addicted' to <xsl:value-of select="/body/globalsettings/setting[@name='HostName']/value"/>.
                     Beware, that the users are located using their IP addresses. This has
                     some pitfalls :

                     <ul>
                     <li class="RP_description_text">Users connecting with modems don't usually
                        have fixed IP addresses. This means that if someone with a modem connects
                        to <xsl:value-of select="/body/globalsettings/setting[@name='HostName']/value"/>, drops the line, and then connects again,
                        it is very likely that he will have a different IP address, and thus,
                        will be considered as coming from another site.</li>
                     <li class="RP_description_text">Large corporate users are likely to connect
                        from behind an http proxy server. This means if two users from such
                        a company connect to <xsl:value-of select="/body/globalsettings/setting[@name='HostName']/value"/>, they will appear as coming
                        from the same site.</li>
                     </ul>
                  </p>

                  <!-- Show sites table -->
                  <xsl:apply-templates select="list[@key='hits']"/>

                  <!-- Show sites table (sorted per kilobytes)-->
                  <xsl:apply-templates select="list[@key='kilobytes']"/>

                  <p/>

                  <!-- Write footer -->
                  <xsl:call-template name="footer">
                     <xsl:with-param name="cur_month" select="$current_month"/>
                     <xsl:with-param name="cur_year" select="$current_year"/>
                  </xsl:call-template>

               </td>
            </tr>
            </table>
         </body>
         </html>

      </xsl:document>

   </xsl:template>

</xsl:stylesheet>
