# vue-router

> 注意: TypeScript ユーザ向けは、vue-router@3.0+ と vue@2.5+ が必須、逆もまた同様です。

**[リリースノート](https://github.com/vuejs/vue-router/releases)**

- [インストール](installation.md)
- 基本的な使い方
  - [はじめに](essentials/getting-started.md)
  - [動的ルートマッチング](essentials/dynamic-matching.md)
  - [ネストされたルート](essentials/nested-routes.md)
  - [プログラムによるナビゲーション](essentials/navigation.md)
  - [名前付きルート](essentials/named-routes.md)
  - [名前付きビュー](essentials/named-views.md)
  - [リダイレクトとエイリアス](essentials/redirect-and-alias.md)
  - [ルートコンポーネントにプロパティを渡す](essentials/passing-props.md)
  - [HTML5 History モード](essentials/history-mode.md)
- 高度な使い方
  - [ナビゲーションガード](advanced/navigation-guards.md)
  - [ルートメタフィールド](advanced/meta.md)
  - [トランジション](advanced/transitions.md)
  - [データの取得](advanced/data-fetching.md)
  - [スクロールの振る舞い](advanced/scroll-behavior.md)
  - [遅延ローディング](advanced/lazy-loading.md)
- API リファレンス
  - [ルーターコンストラクタオプション](api/options.md)
    - [routes](api/options.md#routes)
    - [mode](api/options.md#mode)
    - [base](api/options.md#base)
    - [linkActiveClass](api/options.md#linkactiveclass)
    - [linkExactActiveClass](api/options.md#linkexactactiveclass)
    - [scrollBehavior](api/options.md#scrollbehavior)
    - [parseQuery / stringifyQuery](api/options.md#parsequery--stringifyquery)
    - [fallback](api/options.md#fallback)
  - [ルーターインスタンス](api/router-instance.md)
    - [Properties](api/router-instance.md#properties)
    - [Methods](api/router-instance.md#methods)
  - [ルートオブジェクト](api/route-object.md)
  - [コンポーネント注入](api/component-injections.md)
  - [router-link](api/router-link.md)
  - [router-view](api/router-view.md)
