// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_MLS_4S_4S_S_TRACE_AARCH64_H_
#define VIXL_SIM_MLS_4S_4S_S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_mls_4S_4S_S[] = {
  0xc1fc0000, 0xc17e0001, 0x017a0002, 0x00000020,
  0x837a0000, 0x827d0001, 0x82f70002, 0x00000020,
  0x84f40000, 0x03fa0001, 0x82ee0002, 0x00000020,
  0x84f40000, 0x03fa0001, 0x82ee0002, 0x00000020,
  0xc17e0000, 0xc0ff0001, 0x817d0002, 0x00000020,
  0xc2f80000, 0x427c0001, 0x81740002, 0x00000020,
  0xc2f80000, 0x427c0001, 0x81740002, 0x00000020,
  0xc2f78200, 0x427b8101, 0x80f40302, 0x00000020,
  0x017a0000, 0x817d0001, 0xfff70002, 0x00000020,
  0x017a0000, 0x817d0001, 0xfff70002, 0x00000020,
  0x01798200, 0x817c8101, 0xff770302, 0x00000020,
  0x01788600, 0x817b8301, 0xfe770902, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff8200, 0xffff8101, 0xff800302, 0x00000020,
  0xfffe8600, 0xfffe8301, 0xfe800902, 0x00000020,
  0xffeec600, 0xffeea301, 0xee806902, 0x00000020,
  0xffff8200, 0xffff8101, 0xff800302, 0x00000020,
  0xfffe8600, 0xfffe8301, 0xfe800902, 0x00000020,
  0xffeec600, 0xffeea301, 0xee806902, 0x00000020,
  0xffb14000, 0xffb0a001, 0xb001e002, 0x00000020,
  0xffff0400, 0xffff0201, 0xff000602, 0x00000020,
  0xffef4400, 0xffef2201, 0xef006602, 0x00000020,
  0xffb1be00, 0xffb11f01, 0xb081dd02, 0x00000020,
  0xff73ba00, 0xff729d01, 0x71835702, 0x00000020,
  0xfff04000, 0xfff02001, 0xf0006002, 0x00000020,
  0xffb2ba00, 0xffb21d01, 0xb181d702, 0x00000020,
  0xff74b600, 0xff739b01, 0x72835102, 0x00000020,
  0xff363400, 0xff349a01, 0x3304ce02, 0x00000020,
  0xffc27a00, 0xffc1fd01, 0xc1817702, 0x00000020,
  0xff847600, 0xff837b01, 0x8282f102, 0x00000020,
  0xff45f400, 0xff447a01, 0x43046e02, 0x00000020,
  0xc0476e00, 0xbfc5f701, 0x46046502, 0x00000020,
  0xffc1fc00, 0xffc17e01, 0xc1017a02, 0x00000020,
  0xff837a00, 0xff827d01, 0x8182f702, 0x00000020,
  0xc084f400, 0xc003fa01, 0x8482ee02, 0x00000020,
  0x8185f000, 0x8084f801, 0x8702e802, 0x00000020,
  0xffc17e00, 0xffc0ff01, 0xc0817d02, 0x00000020,
  0xc0c2f800, 0xc0427c01, 0xc3817402, 0x00000020,
  0x81c3f400, 0x80c37a01, 0xc6016e02, 0x00000020,
  0x42c47200, 0x4143f901, 0xc8016b02, 0x00000020,
  0xc1017a00, 0xc0817d01, 0x02fff702, 0x00000020,
  0x82027600, 0x81027b01, 0x057ff102, 0x00000020,
  0x4302f400, 0x4182fa01, 0x077fee02, 0x00000020,
  0x0fcfda00, 0xdb1cad01, 0x07998702, 0x00000020,
  0xc100fc00, 0xc080fe01, 0x027ffa02, 0x00000020,
  0x82017a00, 0x81017d01, 0x047ff702, 0x00000020,
  0x4ece6000, 0x1a9b3001, 0x04999002, 0x00000020,
  0x4ece8a00, 0xc5460501, 0x5a198f02, 0x00000020,
  0xc1007e00, 0xc0807f01, 0x01fffd02, 0x00000020,
  0x8dcd6400, 0x5a1a3201, 0x02199602, 0x00000020,
  0x8dcd8e00, 0x04c50701, 0x57999502, 0x00000020,
  0x8dcf0800, 0x04c68401, 0x59198c02, 0x00000020,
  0xcccce600, 0x9999b301, 0x00199902, 0x00000020,
  0xcccd1000, 0x44448801, 0x55999802, 0x00000020,
  0xccce8a00, 0x44460501, 0x57198f02, 0x00000020,
  0xcccf8600, 0x44470301, 0x58198902, 0x00000020,
  0x00002a00, 0xaaaad501, 0x557fff02, 0x00000020,
  0x0001a400, 0xaaac5201, 0x56fff602, 0x00000020,
  0x0002a000, 0xaaad5001, 0x57fff002, 0x00000020,
  0x00031e00, 0xaaadcf01, 0x587fed02, 0x00000020,
  0x00017a00, 0x00017d01, 0x017ff702, 0x00000020,
  0x00027600, 0x00027b01, 0x027ff102, 0x00000020,
  0x0002f400, 0x0002fa01, 0x02ffee02, 0x00000020,
  0x0002f400, 0x0002fa01, 0x02ffee02, 0x00000020,
  0x0000fc00, 0x0000fe01, 0x00fffa02, 0x00000020,
  0x00017a00, 0x00017d01, 0x017ff702, 0x00000020,
  0x00017a00, 0x00017d01, 0x017ff702, 0x00000020,
  0x0000fc00, 0x0000fe01, 0x00fffa02, 0x00000020,
  0x00007e00, 0x00007f01, 0x007ffd02, 0x00000020,
  0x00007e00, 0x00007f01, 0x007ffd02, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00005400, 0x5555aa01, 0xaafffe02, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff8200, 0xffff8101, 0xff800302, 0x00000020,
  0xffffd600, 0x55552b01, 0xaa800102, 0x00000020,
  0x33336e00, 0xbbbbf701, 0xaae66502, 0x00000020,
  0xffff8200, 0xffff8101, 0xff800302, 0x00000020,
  0xffffd600, 0x55552b01, 0xaa800102, 0x00000020,
  0x33336e00, 0xbbbbf701, 0xaae66502, 0x00000020,
  0x72336e00, 0xfb3bf701, 0xa9666502, 0x00000020,
  0x00005400, 0x5555aa01, 0xaafffe02, 0x00000020,
  0x3333ec00, 0xbbbc7601, 0xab666202, 0x00000020,
  0x7233ec00, 0xfb3c7601, 0xa9e66202, 0x00000020,
  0xb1336e00, 0x3abbf701, 0xa7e66502, 0x00000020,
  0x33339800, 0x6666cc01, 0x00666402, 0x00000020,
  0x72339800, 0xa5e6cc01, 0xfee66402, 0x00000020,
  0xb1331a00, 0xe5664d01, 0xfce66702, 0x00000020,
  0xf0321e00, 0x24e54f01, 0xfa666d02, 0x00000020,
  0x3f000000, 0x3f800001, 0xfe800002, 0x00000020,
  0x7dff8200, 0x7eff8101, 0xfc800302, 0x00000020,
  0xbcfe8600, 0xbe7e8301, 0xfa000902, 0x00000020,
  0xfbfd0c00, 0xfdfd0601, 0xf7001202, 0x00000020,
  0x3eff8200, 0x3f7f8101, 0xfe000302, 0x00000020,
  0x7dfe8600, 0x7efe8301, 0xfb800902, 0x00000020,
  0xbcfd0c00, 0xbe7d0601, 0xf8801202, 0x00000020,
  0xbd3c0c00, 0xbebc8601, 0x387e9202, 0x00000020,
  0x3eff0400, 0x3f7f0201, 0xfd800602, 0x00000020,
  0x7dfd8a00, 0x7efd8501, 0xfa800f02, 0x00000020,
  0x7e3c8a00, 0x7f3d0501, 0x3a7e8f02, 0x00000020,
  0x7e7b0c00, 0x7f7c0601, 0x79fd1202, 0x00000020,
  0x3efe8600, 0x3f7e8301, 0xfd000902, 0x00000020,
  0x3f3d8600, 0x3fbe0301, 0x3cfe8902, 0x00000020,
  0x3f7c0800, 0x3ffd0401, 0x7c7d0c02, 0x00000020,
  0x3fba0c00, 0x403b8601, 0xbb7b9202, 0x00000020,
  0x003f0000, 0x003f8001, 0x3ffe8002, 0x00000020,
  0x007d8200, 0x007e8101, 0x7f7d0302, 0x00000020,
  0x00bb8600, 0x00bd0301, 0xbe7b8902, 0x00000020,
  0x00f90c00, 0x00fb0601, 0xfcfa1202, 0x00000020,
  0x003e8200, 0x003f0101, 0x3f7e8302, 0x00000020,
  0x007c8600, 0x007d8301, 0x7e7d0902, 0x00000020,
  0x00ba0c00, 0x00bb8601, 0xbcfb9202, 0x00000020,
  0x00c9cc00, 0x00cb6601, 0xccfb3202, 0x00000020,
  0x003e0400, 0x003e8201, 0x3efe8602, 0x00000020,
  0x007b8a00, 0x007c8501, 0x7d7d0f02, 0x00000020,
  0x008b4a00, 0x008c6501, 0x8d7caf02, 0x00000020,
  0x008cc400, 0x008de201, 0x8efca602, 0x00000020,
  0x003d8600, 0x003e0301, 0x3e7e8902, 0x00000020,
  0x004d4600, 0x004de301, 0x4e7e2902, 0x00000020,
  0x004ec000, 0x004f6001, 0x4ffe2002, 0x00000020,
  0x004fbc00, 0x00505e01, 0x50fe1a02, 0x00000020,
  0x000fc000, 0x000fe001, 0x0fffa002, 0x00000020,
  0x00113a00, 0x00115d01, 0x117f9702, 0x00000020,
  0x00123600, 0x00125b01, 0x127f9102, 0x00000020,
  0x0012b400, 0x0012da01, 0x12ff8e02, 0x00000020,
  0x00017d00, 0x017ff701, 0x00000002, 0x00000023,
  0x00027b00, 0x027ff101, 0x00000002, 0x00000025,
  0x0002fa00, 0x02ffee01, 0x00000002, 0x00000026,
  0x0002fa00, 0x02ffee01, 0x00000002, 0x00000026,
  0x0000fe00, 0x00fffa01, 0x00000002, 0x00000022,
  0x00017d00, 0x017ff701, 0x00000002, 0x00000023,
  0x00017d00, 0x017ff701, 0x00000002, 0x00000023,
  0x0000fe00, 0x00fffa01, 0x00000002, 0x00000022,
  0x00007f00, 0x007ffd01, 0x00000002, 0x00000021,
  0x00007f00, 0x007ffd01, 0x00000002, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff0200, 0xff000601, 0x00000002, 0x0000001e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff8100, 0xff800301, 0x00000002, 0x0000001f,
  0xfffe8300, 0xfe800901, 0x00000002, 0x0000001d,
  0xffeea300, 0xee806901, 0x00000002, 0xfffffffd,
  0xffff8100, 0xff800301, 0x00000002, 0x0000001f,
  0xfffe8300, 0xfe800901, 0x00000002, 0x0000001d,
  0xffeea300, 0xee806901, 0x00000002, 0xfffffffd,
  0xffb0a000, 0xb001e001, 0x00000002, 0xffffff80,
  0xffff0200, 0xff000601, 0x00000002, 0x0000001e,
  0xffef2200, 0xef006601, 0x00000002, 0xfffffffe,
  0xffb11f00, 0xb081dd01, 0x00000002, 0xffffff81,
  0xff729d00, 0x71835701, 0x00000002, 0xffffff03,
  0xfff02000, 0xf0006001, 0x00000002, 0x00000000,
  0xffb21d00, 0xb181d701, 0x00000002, 0xffffff83,
  0xff739b00, 0x72835101, 0x00000002, 0xffffff05,
  0xff349a00, 0x3304ce01, 0x00000002, 0xfffffe86,
  0xffc1fd00, 0xc1817701, 0x00000002, 0xffffffa3,
  0xff837b00, 0x8282f101, 0x00000002, 0xffffff25,
  0xff447a00, 0x43046e01, 0x00000002, 0xfffffea6,
  0xbfc5f700, 0x46046501, 0x00000002, 0xffff7ea9,
  0xffc17e00, 0xc1017a01, 0x00000002, 0xffffffa2,
  0xff827d00, 0x8182f701, 0x00000002, 0xffffff23,
  0xc003fa00, 0x8482ee01, 0x00000002, 0xffff7f26,
  0x8084f800, 0x8702e801, 0x00000002, 0xfffeff28,
  0xffc0ff00, 0xc0817d01, 0x00000002, 0xffffffa1,
  0xc0427c00, 0xc3817401, 0x00000002, 0xffff7fa4,
  0x80c37a00, 0xc6016e01, 0x00000002, 0xfffeffa6,
  0x4143f900, 0xc8016b01, 0x00000002, 0xfffe7fa7,
  0xc0817d00, 0x02fff701, 0x00000002, 0xffff8023,
  0x81027b00, 0x057ff101, 0x00000002, 0xffff0025,
  0x4182fa00, 0x077fee01, 0x00000002, 0xfffe8026,
  0xdb1cad00, 0x07998701, 0x00000002, 0xcccb4cf3,
  0xc080fe00, 0x027ffa01, 0x00000002, 0xffff8022,
  0x81017d00, 0x047ff701, 0x00000002, 0xffff0023,
  0x1a9b3000, 0x04999001, 0x00000002, 0xcccbccf0,
  0xc5460500, 0x5a198f01, 0x00000002, 0x7776779b,
  0xc0807f00, 0x01fffd01, 0x00000002, 0xffff8021,
  0x5a1a3200, 0x02199601, 0x00000002, 0xcccc4cee,
  0x04c50700, 0x57999501, 0x00000002, 0x7776f799,
  0x04c68400, 0x59198c01, 0x00000002, 0xf776f79c,
  0x9999b300, 0x00199901, 0x00000002, 0xcccccced,
  0x44448800, 0x55999801, 0x00000002, 0x77777798,
  0x44460500, 0x57198f01, 0x00000002, 0xf777779b,
  0x44470300, 0x58198901, 0x00000002, 0x7777779d,
  0xaaaad500, 0x557fff01, 0x00000002, 0xaaaaaacb,
  0xaaac5200, 0x56fff601, 0x00000002, 0x2aaaaace,
  0xaaad5000, 0x57fff001, 0x00000002, 0xaaaaaad0,
  0xaaadcf00, 0x587fed01, 0x00000002, 0x2aaaaad1,
  0x00017d00, 0x017ff701, 0x00000002, 0x80000023,
  0x00027b00, 0x027ff101, 0x00000002, 0x00000025,
  0x0002fa00, 0x02ffee01, 0x00000002, 0x80000026,
  0x0002fa00, 0x02ffee01, 0x00000002, 0x00000026,
  0x0000fe00, 0x00fffa01, 0x00000002, 0x80000022,
  0x00017d00, 0x017ff701, 0x00000002, 0x00000023,
  0x00017d00, 0x017ff701, 0x00000002, 0x80000023,
  0x0000fe00, 0x00fffa01, 0x00000002, 0x00000022,
  0x00007f00, 0x007ffd01, 0x00000002, 0x80000021,
  0x00007f00, 0x007ffd01, 0x00000002, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x80000020,
  0x5555aa00, 0xaafffe01, 0x00000002, 0xd5555576,
  0x00000000, 0x00000001, 0x00000002, 0x80000020,
  0xffff8100, 0xff800301, 0x00000002, 0x0000001f,
  0x55552b00, 0xaa800101, 0x00000002, 0x55555575,
  0xbbbbf700, 0xaae66501, 0x00000002, 0x888888a9,
  0xffff8100, 0xff800301, 0x00000002, 0x8000001f,
  0x55552b00, 0xaa800101, 0x00000002, 0xd5555575,
  0xbbbbf700, 0xaae66501, 0x00000002, 0x088888a9,
  0xfb3bf700, 0xa9666501, 0x00000002, 0x088908a9,
  0x5555aa00, 0xaafffe01, 0x00000002, 0x55555576,
  0xbbbc7600, 0xab666201, 0x00000002, 0x888888aa,
  0xfb3c7600, 0xa9e66201, 0x00000002, 0x888908aa,
  0x3abbf700, 0xa7e66501, 0x00000002, 0x888988a9,
  0x6666cc00, 0x00666401, 0x00000002, 0x33333354,
  0xa5e6cc00, 0xfee66401, 0x00000002, 0x3333b354,
  0xe5664d00, 0xfce66701, 0x00000002, 0x33343353,
  0x24e54f00, 0xfa666d01, 0x00000002, 0x3334b351,
  0x3f800000, 0xfe800001, 0x00000002, 0x00008020,
  0x7eff8100, 0xfc800301, 0x00000002, 0x0001001f,
  0xbe7e8300, 0xfa000901, 0x00000002, 0x0001801d,
  0xfdfd0600, 0xf7001201, 0x00000002, 0x0002001a,
  0x3f7f8100, 0xfe000301, 0x00000002, 0x0000801f,
  0x7efe8300, 0xfb800901, 0x00000002, 0x0001001d,
  0xbe7d0600, 0xf8801201, 0x00000002, 0x0001801a,
  0xbebc8600, 0x387e9201, 0x00000002, 0x0001809a,
  0x3f7f0200, 0xfd800601, 0x00000002, 0x0000801e,
  0x7efd8500, 0xfa800f01, 0x00000002, 0x0001001b,
  0x7f3d0500, 0x3a7e8f01, 0x00000002, 0x0001009b,
  0x7f7c0600, 0x79fd1201, 0x00000002, 0x0001011a,
  0x3f7e8300, 0xfd000901, 0x00000002, 0x0000801d,
  0x3fbe0300, 0x3cfe8901, 0x00000002, 0x0000809d,
  0x3ffd0400, 0x7c7d0c01, 0x00000002, 0x0000811c,
  0x403b8600, 0xbb7b9201, 0x00000002, 0x0000819a,
  0x003f8000, 0x3ffe8001, 0x00000002, 0x000000a0,
  0x007e8100, 0x7f7d0301, 0x00000002, 0x0000011f,
  0x00bd0300, 0xbe7b8901, 0x00000002, 0x0000019d,
  0x00fb0600, 0xfcfa1201, 0x00000002, 0x0000021a,
  0x003f0100, 0x3f7e8301, 0x00000002, 0x0000009f,
  0x007d8300, 0x7e7d0901, 0x00000002, 0x0000011d,
  0x00bb8600, 0xbcfb9201, 0x00000002, 0x0000019a,
  0x00cb6600, 0xccfb3201, 0x00000002, 0x000001ba,
  0x003e8200, 0x3efe8601, 0x00000002, 0x0000009e,
  0x007c8500, 0x7d7d0f01, 0x00000002, 0x0000011b,
  0x008c6500, 0x8d7caf01, 0x00000002, 0x0000013b,
  0x008de200, 0x8efca601, 0x00000002, 0x0000013e,
  0x003e0300, 0x3e7e8901, 0x00000002, 0x0000009d,
  0x004de300, 0x4e7e2901, 0x00000002, 0x000000bd,
  0x004f6000, 0x4ffe2001, 0x00000002, 0x000000c0,
  0x00505e00, 0x50fe1a01, 0x00000002, 0x000000c2,
  0x000fe000, 0x0fffa001, 0x00000002, 0x00000040,
  0x00115d00, 0x117f9701, 0x00000002, 0x00000043,
  0x00125b00, 0x127f9101, 0x00000002, 0x00000045,
  0x0012da00, 0x12ff8e01, 0x00000002, 0x00000046,
  0x017ff700, 0x00000001, 0x00000005, 0x00000026,
  0x027ff100, 0x00000001, 0x00000007, 0x0000002a,
  0x02ffee00, 0x00000001, 0x00000008, 0x0000002c,
  0x02ffee00, 0x00000001, 0x00000008, 0x0000002c,
  0x00fffa00, 0x00000001, 0x00000004, 0x00000024,
  0x017ff700, 0x00000001, 0x00000005, 0x00000026,
  0x017ff700, 0x00000001, 0x00000005, 0x00000026,
  0x00fffa00, 0x00000001, 0x00000004, 0x00000024,
  0x007ffd00, 0x00000001, 0x00000003, 0x00000022,
  0x007ffd00, 0x00000001, 0x00000003, 0x00000022,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xff000600, 0x00000001, 0x00000000, 0x0000001c,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xff800300, 0x00000001, 0x00000001, 0x0000001e,
  0xfe800900, 0x00000001, 0xffffffff, 0x0000001a,
  0xee806900, 0x00000001, 0xffffffdf, 0xffffffda,
  0xff800300, 0x00000001, 0x00000001, 0x0000001e,
  0xfe800900, 0x00000001, 0xffffffff, 0x0000001a,
  0xee806900, 0x00000001, 0xffffffdf, 0xffffffda,
  0xb001e000, 0x00000001, 0xffffff62, 0xfffffee0,
  0xff000600, 0x00000001, 0x00000000, 0x0000001c,
  0xef006600, 0x00000001, 0xffffffe0, 0xffffffdc,
  0xb081dd00, 0x00000001, 0xffffff63, 0xfffffee2,
  0x71835700, 0x00000001, 0xfffffee5, 0xfffffde6,
  0xf0006000, 0x00000001, 0xffffffe2, 0xffffffe0,
  0xb181d700, 0x00000001, 0xffffff65, 0xfffffee6,
  0x72835100, 0x00000001, 0xfffffee7, 0xfffffdea,
  0x3304ce00, 0x00000001, 0xfffffe68, 0xfffffcec,
  0xc1817700, 0x00000001, 0xffffff85, 0xffffff26,
  0x8282f100, 0x00000001, 0xffffff07, 0xfffffe2a,
  0x43046e00, 0x00000001, 0xfffffe88, 0xfffffd2c,
  0x46046500, 0x00000001, 0xffff7e8b, 0xfffefd32,
  0xc1017a00, 0x00000001, 0xffffff84, 0xffffff24,
  0x8182f700, 0x00000001, 0xffffff05, 0xfffffe26,
  0x8482ee00, 0x00000001, 0xffff7f08, 0xfffefe2c,
  0x8702e800, 0x00000001, 0xfffeff0a, 0xfffdfe30,
  0xc0817d00, 0x00000001, 0xffffff83, 0xffffff22,
  0xc3817400, 0x00000001, 0xffff7f86, 0xfffeff28,
  0xc6016e00, 0x00000001, 0xfffeff88, 0xfffdff2c,
  0xc8016b00, 0x00000001, 0xfffe7f89, 0xfffcff2e,
  0x02fff700, 0x00000001, 0xffff8005, 0xffff0026,
  0x057ff100, 0x00000001, 0xffff0007, 0xfffe002a,
  0x077fee00, 0x00000001, 0xfffe8008, 0xfffd002c,
  0x07998700, 0x00000001, 0xcccb4cd5, 0x999699c6,
  0x027ffa00, 0x00000001, 0xffff8004, 0xffff0024,
  0x047ff700, 0x00000001, 0xffff0005, 0xfffe0026,
  0x04999000, 0x00000001, 0xcccbccd2, 0x999799c0,
  0x5a198f00, 0x00000001, 0x7776777d, 0xeeecef16,
  0x01fffd00, 0x00000001, 0xffff8003, 0xffff0022,
  0x02199600, 0x00000001, 0xcccc4cd0, 0x999899bc,
  0x57999500, 0x00000001, 0x7776f77b, 0xeeedef12,
  0x59198c00, 0x00000001, 0xf776f77e, 0xeeedef18,
  0x00199900, 0x00000001, 0xcccccccf, 0x999999ba,
  0x55999800, 0x00000001, 0x7777777a, 0xeeeeef10,
  0x57198f00, 0x00000001, 0xf777777d, 0xeeeeef16,
  0x58198900, 0x00000001, 0x7777777f, 0xeeeeef1a,
  0x557fff00, 0x00000001, 0xaaaaaaad, 0x55555576,
  0x56fff600, 0x00000001, 0x2aaaaab0, 0x5555557c,
  0x57fff000, 0x00000001, 0xaaaaaab2, 0x55555580,
  0x587fed00, 0x00000001, 0x2aaaaab3, 0x55555582,
  0x017ff700, 0x00000001, 0x80000005, 0x00000026,
  0x027ff100, 0x00000001, 0x00000007, 0x0000002a,
  0x02ffee00, 0x00000001, 0x80000008, 0x0000002c,
  0x02ffee00, 0x00000001, 0x00000008, 0x0000002c,
  0x00fffa00, 0x00000001, 0x80000004, 0x00000024,
  0x017ff700, 0x00000001, 0x00000005, 0x00000026,
  0x017ff700, 0x00000001, 0x80000005, 0x00000026,
  0x00fffa00, 0x00000001, 0x00000004, 0x00000024,
  0x007ffd00, 0x00000001, 0x80000003, 0x00000022,
  0x007ffd00, 0x00000001, 0x00000003, 0x00000022,
  0x00000000, 0x00000001, 0x80000002, 0x00000020,
  0xaafffe00, 0x00000001, 0xd5555558, 0xaaaaaacc,
  0x00000000, 0x00000001, 0x80000002, 0x00000020,
  0xff800300, 0x00000001, 0x00000001, 0x0000001e,
  0xaa800100, 0x00000001, 0x55555557, 0xaaaaaaca,
  0xaae66500, 0x00000001, 0x8888888b, 0x11111132,
  0xff800300, 0x00000001, 0x80000001, 0x0000001e,
  0xaa800100, 0x00000001, 0xd5555557, 0xaaaaaaca,
  0xaae66500, 0x00000001, 0x0888888b, 0x11111132,
  0xa9666500, 0x00000001, 0x0889088b, 0x11121132,
  0xaafffe00, 0x00000001, 0x55555558, 0xaaaaaacc,
  0xab666200, 0x00000001, 0x8888888c, 0x11111134,
  0xa9e66200, 0x00000001, 0x8889088c, 0x11121134,
  0xa7e66500, 0x00000001, 0x8889888b, 0x11131132,
  0x00666400, 0x00000001, 0x33333336, 0x66666688,
  0xfee66400, 0x00000001, 0x3333b336, 0x66676688,
  0xfce66700, 0x00000001, 0x33343335, 0x66686686,
  0xfa666d00, 0x00000001, 0x3334b333, 0x66696682,
  0xfe800000, 0x00000001, 0x00008002, 0x00010020,
  0xfc800300, 0x00000001, 0x00010001, 0x0002001e,
  0xfa000900, 0x00000001, 0x00017fff, 0x0003001a,
  0xf7001200, 0x00000001, 0x0001fffc, 0x00040014,
  0xfe000300, 0x00000001, 0x00008001, 0x0001001e,
  0xfb800900, 0x00000001, 0x0000ffff, 0x0002001a,
  0xf8801200, 0x00000001, 0x00017ffc, 0x00030014,
  0x387e9200, 0x00000001, 0x0001807c, 0x00030114,
  0xfd800600, 0x00000001, 0x00008000, 0x0001001c,
  0xfa800f00, 0x00000001, 0x0000fffd, 0x00020016,
  0x3a7e8f00, 0x00000001, 0x0001007d, 0x00020116,
  0x79fd1200, 0x00000001, 0x000100fc, 0x00020214,
  0xfd000900, 0x00000001, 0x00007fff, 0x0001001a,
  0x3cfe8900, 0x00000001, 0x0000807f, 0x0001011a,
  0x7c7d0c00, 0x00000001, 0x000080fe, 0x00010218,
  0xbb7b9200, 0x00000001, 0x0000817c, 0x00010314,
  0x3ffe8000, 0x00000001, 0x00000082, 0x00000120,
  0x7f7d0300, 0x00000001, 0x00000101, 0x0000021e,
  0xbe7b8900, 0x00000001, 0x0000017f, 0x0000031a,
  0xfcfa1200, 0x00000001, 0x000001fc, 0x00000414,
  0x3f7e8300, 0x00000001, 0x00000081, 0x0000011e,
  0x7e7d0900, 0x00000001, 0x000000ff, 0x0000021a,
  0xbcfb9200, 0x00000001, 0x0000017c, 0x00000314,
  0xccfb3200, 0x00000001, 0x0000019c, 0x00000354,
  0x3efe8600, 0x00000001, 0x00000080, 0x0000011c,
  0x7d7d0f00, 0x00000001, 0x000000fd, 0x00000216,
  0x8d7caf00, 0x00000001, 0x0000011d, 0x00000256,
  0x8efca600, 0x00000001, 0x00000120, 0x0000025c,
  0x3e7e8900, 0x00000001, 0x0000007f, 0x0000011a,
  0x4e7e2900, 0x00000001, 0x0000009f, 0x0000015a,
  0x4ffe2000, 0x00000001, 0x000000a2, 0x00000160,
  0x50fe1a00, 0x00000001, 0x000000a4, 0x00000164,
  0x0fffa000, 0x00000001, 0x00000022, 0x00000060,
  0x117f9700, 0x00000001, 0x00000025, 0x00000066,
  0x127f9100, 0x00000001, 0x00000027, 0x0000006a,
  0x12ff8e00, 0x00000001, 0x00000028, 0x0000006c,
  0x00000000, 0x00000004, 0x00000008, 0x00000080,
  0x00000000, 0x00000006, 0x0000000c, 0x000000c0,
  0x00000000, 0x00000007, 0x0000000e, 0x000000e0,
  0x00000000, 0x00000007, 0x0000000e, 0x000000e0,
  0x00000000, 0x00000003, 0x00000006, 0x00000060,
  0x00000000, 0x00000004, 0x00000008, 0x00000080,
  0x00000000, 0x00000004, 0x00000008, 0x00000080,
  0x00000000, 0x00000003, 0x00000006, 0x00000060,
  0x00000000, 0x00000002, 0x00000004, 0x00000040,
  0x00000000, 0x00000002, 0x00000004, 0x00000040,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0xffffffff, 0xfffffffe, 0xffffffe0,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xffffffc0,
  0x00000000, 0xffffffde, 0xffffffbc, 0xfffffbc0,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xffffffc0,
  0x00000000, 0xffffffde, 0xffffffbc, 0xfffffbc0,
  0x00000000, 0xffffff61, 0xfffffec2, 0xffffec20,
  0x00000000, 0xffffffff, 0xfffffffe, 0xffffffe0,
  0x00000000, 0xffffffdf, 0xffffffbe, 0xfffffbe0,
  0x00000000, 0xffffff62, 0xfffffec4, 0xffffec40,
  0x00000000, 0xfffffee4, 0xfffffdc8, 0xffffdc80,
  0x00000000, 0xffffffe1, 0xffffffc2, 0xfffffc20,
  0x00000000, 0xffffff64, 0xfffffec8, 0xffffec80,
  0x00000000, 0xfffffee6, 0xfffffdcc, 0xffffdcc0,
  0x00000000, 0xfffffe67, 0xfffffcce, 0xffffcce0,
  0x00000000, 0xffffff84, 0xffffff08, 0xfffff080,
  0x00000000, 0xffffff06, 0xfffffe0c, 0xffffe0c0,
  0x00000000, 0xfffffe87, 0xfffffd0e, 0xffffd0e0,
  0x00000000, 0xffff7e8a, 0xfffefd14, 0xffefd140,
  0x00000000, 0xffffff83, 0xffffff06, 0xfffff060,
  0x00000000, 0xffffff04, 0xfffffe08, 0xffffe080,
  0x00000000, 0xffff7f07, 0xfffefe0e, 0xffefe0e0,
  0x00000000, 0xfffeff09, 0xfffdfe12, 0xffdfe120,
  0x00000000, 0xffffff82, 0xffffff04, 0xfffff040,
  0x00000000, 0xffff7f85, 0xfffeff0a, 0xffeff0a0,
  0x00000000, 0xfffeff87, 0xfffdff0e, 0xffdff0e0,
  0x00000000, 0xfffe7f88, 0xfffcff10, 0xffcff100,
  0x00000000, 0xffff8004, 0xffff0008, 0xfff00080,
  0x00000000, 0xffff0006, 0xfffe000c, 0xffe000c0,
  0x00000000, 0xfffe8007, 0xfffd000e, 0xffd000e0,
  0x00000000, 0xcccb4cd4, 0x999699a8, 0x99699a80,
  0x00000000, 0xffff8003, 0xffff0006, 0xfff00060,
  0x00000000, 0xffff0004, 0xfffe0008, 0xffe00080,
  0x00000000, 0xcccbccd1, 0x999799a2, 0x99799a20,
  0x00000000, 0x7776777c, 0xeeeceef8, 0xeeceef80,
  0x00000000, 0xffff8002, 0xffff0004, 0xfff00040,
  0x00000000, 0xcccc4ccf, 0x9998999e, 0x998999e0,
  0x00000000, 0x7776f77a, 0xeeedeef4, 0xeedeef40,
  0x00000000, 0xf776f77d, 0xeeedeefa, 0xeedeefa0,
  0x00000000, 0xccccccce, 0x9999999c, 0x999999c0,
  0x00000000, 0x77777779, 0xeeeeeef2, 0xeeeeef20,
  0x00000000, 0xf777777c, 0xeeeeeef8, 0xeeeeef80,
  0x00000000, 0x7777777e, 0xeeeeeefc, 0xeeeeefc0,
  0x00000000, 0xaaaaaaac, 0x55555558, 0x55555580,
  0x00000000, 0x2aaaaaaf, 0x5555555e, 0x555555e0,
  0x00000000, 0xaaaaaab1, 0x55555562, 0x55555620,
  0x00000000, 0x2aaaaab2, 0x55555564, 0x55555640,
  0x00000000, 0x80000004, 0x00000008, 0x00000080,
  0x00000000, 0x00000006, 0x0000000c, 0x000000c0,
  0x00000000, 0x80000007, 0x0000000e, 0x000000e0,
  0x00000000, 0x00000007, 0x0000000e, 0x000000e0,
  0x00000000, 0x80000003, 0x00000006, 0x00000060,
  0x00000000, 0x00000004, 0x00000008, 0x00000080,
  0x00000000, 0x80000004, 0x00000008, 0x00000080,
  0x00000000, 0x00000003, 0x00000006, 0x00000060,
  0x00000000, 0x80000002, 0x00000004, 0x00000040,
  0x00000000, 0x00000002, 0x00000004, 0x00000040,
  0x00000000, 0x80000001, 0x00000002, 0x00000020,
  0x00000000, 0xd5555557, 0xaaaaaaae, 0xaaaaaae0,
  0x00000000, 0x80000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x55555556, 0xaaaaaaac, 0xaaaaaac0,
  0x00000000, 0x8888888a, 0x11111114, 0x11111140,
  0x00000000, 0x80000000, 0x00000000, 0x00000000,
  0x00000000, 0xd5555556, 0xaaaaaaac, 0xaaaaaac0,
  0x00000000, 0x0888888a, 0x11111114, 0x11111140,
  0x00000000, 0x0889088a, 0x11121114, 0x11211140,
  0x00000000, 0x55555557, 0xaaaaaaae, 0xaaaaaae0,
  0x00000000, 0x8888888b, 0x11111116, 0x11111160,
  0x00000000, 0x8889088b, 0x11121116, 0x11211160,
  0x00000000, 0x8889888a, 0x11131114, 0x11311140,
  0x00000000, 0x33333335, 0x6666666a, 0x666666a0,
  0x00000000, 0x3333b335, 0x6667666a, 0x667666a0,
  0x00000000, 0x33343334, 0x66686668, 0x66866680,
  0x00000000, 0x3334b332, 0x66696664, 0x66966640,
  0x00000000, 0x00008001, 0x00010002, 0x00100020,
  0x00000000, 0x00010000, 0x00020000, 0x00200000,
  0x00000000, 0x00017ffe, 0x0002fffc, 0x002fffc0,
  0x00000000, 0x0001fffb, 0x0003fff6, 0x003fff60,
  0x00000000, 0x00008000, 0x00010000, 0x00100000,
  0x00000000, 0x0000fffe, 0x0001fffc, 0x001fffc0,
  0x00000000, 0x00017ffb, 0x0002fff6, 0x002fff60,
  0x00000000, 0x0001807b, 0x000300f6, 0x00300f60,
  0x00000000, 0x00007fff, 0x0000fffe, 0x000fffe0,
  0x00000000, 0x0000fffc, 0x0001fff8, 0x001fff80,
  0x00000000, 0x0001007c, 0x000200f8, 0x00200f80,
  0x00000000, 0x000100fb, 0x000201f6, 0x00201f60,
  0x00000000, 0x00007ffe, 0x0000fffc, 0x000fffc0,
  0x00000000, 0x0000807e, 0x000100fc, 0x00100fc0,
  0x00000000, 0x000080fd, 0x000101fa, 0x00101fa0,
  0x00000000, 0x0000817b, 0x000102f6, 0x00102f60,
  0x00000000, 0x00000081, 0x00000102, 0x00001020,
  0x00000000, 0x00000100, 0x00000200, 0x00002000,
  0x00000000, 0x0000017e, 0x000002fc, 0x00002fc0,
  0x00000000, 0x000001fb, 0x000003f6, 0x00003f60,
  0x00000000, 0x00000080, 0x00000100, 0x00001000,
  0x00000000, 0x000000fe, 0x000001fc, 0x00001fc0,
  0x00000000, 0x0000017b, 0x000002f6, 0x00002f60,
  0x00000000, 0x0000019b, 0x00000336, 0x00003360,
  0x00000000, 0x0000007f, 0x000000fe, 0x00000fe0,
  0x00000000, 0x000000fc, 0x000001f8, 0x00001f80,
  0x00000000, 0x0000011c, 0x00000238, 0x00002380,
  0x00000000, 0x0000011f, 0x0000023e, 0x000023e0,
  0x00000000, 0x0000007e, 0x000000fc, 0x00000fc0,
  0x00000000, 0x0000009e, 0x0000013c, 0x000013c0,
  0x00000000, 0x000000a1, 0x00000142, 0x00001420,
  0x00000000, 0x000000a3, 0x00000146, 0x00001460,
  0x00000000, 0x00000021, 0x00000042, 0x00000420,
  0x00000000, 0x00000024, 0x00000048, 0x00000480,
  0x00000000, 0x00000026, 0x0000004c, 0x000004c0,
  0x00000000, 0x00000027, 0x0000004e, 0x000004e0,
  0x00000003, 0x00000007, 0x00000062, 0x00000197,
  0x00000005, 0x0000000b, 0x000000a2, 0x00000291,
  0x00000006, 0x0000000d, 0x000000c2, 0x0000030e,
  0x00000006, 0x0000000d, 0x000000c2, 0x0000030e,
  0x00000002, 0x00000005, 0x00000042, 0x0000011a,
  0x00000003, 0x00000007, 0x00000062, 0x00000197,
  0x00000003, 0x00000007, 0x00000062, 0x00000197,
  0x00000002, 0x00000005, 0x00000042, 0x0000011a,
  0x00000001, 0x00000003, 0x00000022, 0x0000009d,
  0x00000001, 0x00000003, 0x00000022, 0x0000009d,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffffffe, 0xfffffffd, 0xffffffc2, 0xffffff26,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffffff, 0xffffffff, 0xffffffe2, 0xffffffa3,
  0xfffffffd, 0xfffffffb, 0xffffffa2, 0xfffffea9,
  0xffffffdd, 0xffffffbb, 0xfffffba2, 0xffffef09,
  0xffffffff, 0xffffffff, 0xffffffe2, 0xffffffa3,
  0xfffffffd, 0xfffffffb, 0xffffffa2, 0xfffffea9,
  0xffffffdd, 0xffffffbb, 0xfffffba2, 0xffffef09,
  0xffffff60, 0xfffffec1, 0xffffec02, 0xffffb200,
  0xfffffffe, 0xfffffffd, 0xffffffc2, 0xffffff26,
  0xffffffde, 0xffffffbd, 0xfffffbc2, 0xffffef86,
  0xffffff61, 0xfffffec3, 0xffffec22, 0xffffb27d,
  0xfffffee3, 0xfffffdc7, 0xffffdc62, 0xffff74f7,
  0xffffffe0, 0xffffffc1, 0xfffffc02, 0xfffff080,
  0xffffff63, 0xfffffec7, 0xffffec62, 0xffffb377,
  0xfffffee5, 0xfffffdcb, 0xffffdca2, 0xffff75f1,
  0xfffffe66, 0xfffffccd, 0xffffccc2, 0xffff37ee,
  0xffffff83, 0xffffff07, 0xfffff062, 0xffffc317,
  0xffffff05, 0xfffffe0b, 0xffffe0a2, 0xffff8591,
  0xfffffe86, 0xfffffd0d, 0xffffd0c2, 0xffff478e,
  0xffff7e89, 0xfffefd13, 0xffefd122, 0xffc0c905,
  0xffffff82, 0xffffff05, 0xfffff042, 0xffffc29a,
  0xffffff03, 0xfffffe07, 0xffffe062, 0xffff8497,
  0xffff7f06, 0xfffefe0d, 0xffefe0c2, 0xffc1060e,
  0xfffeff08, 0xfffdfe11, 0xffdfe102, 0xff828708,
  0xffffff81, 0xffffff03, 0xfffff022, 0xffffc21d,
  0xffff7f84, 0xfffeff09, 0xffeff082, 0xffc14394,
  0xfffeff86, 0xfffdff0d, 0xffdff0c2, 0xff82c48e,
  0xfffe7f87, 0xfffcff0f, 0xffcff0e2, 0xff44450b,
  0xffff8003, 0xffff0007, 0xfff00062, 0xffc18197,
  0xffff0005, 0xfffe000b, 0xffe000a2, 0xff830291,
  0xfffe8006, 0xfffd000d, 0xffd000c2, 0xff44830e,
  0xcccb4cd3, 0x999699a7, 0x99699a62, 0xff448327,
  0xffff8002, 0xffff0005, 0xfff00042, 0xffc1811a,
  0xffff0003, 0xfffe0007, 0xffe00062, 0xff830197,
  0xcccbccd0, 0x999799a1, 0x99799a02, 0xff8301b0,
  0x7776777b, 0xeeeceef7, 0xeeceef62, 0x54d8572f,
  0xffff8001, 0xffff0003, 0xfff00022, 0xffc1809d,
  0xcccc4cce, 0x9998999d, 0x998999c2, 0xffc180b6,
  0x7776f779, 0xeeedeef3, 0xeedeef22, 0x5516d635,
  0xf776f77c, 0xeeedeef9, 0xeedeef82, 0xd516d7ac,
  0xcccccccd, 0x9999999b, 0x999999a2, 0x00000039,
  0x77777778, 0xeeeeeef1, 0xeeeeef02, 0x555555b8,
  0xf777777b, 0xeeeeeef7, 0xeeeeef62, 0xd555572f,
  0x7777777d, 0xeeeeeefb, 0xeeeeefa2, 0x55555829,
  0xaaaaaaab, 0x55555557, 0x55555562, 0x5555559f,
  0x2aaaaaae, 0x5555555d, 0x555555c2, 0xd5555716,
  0xaaaaaab0, 0x55555561, 0x55555602, 0x55555810,
  0x2aaaaab1, 0x55555563, 0x55555622, 0xd555588d,
  0x80000003, 0x00000007, 0x00000062, 0x80000197,
  0x00000005, 0x0000000b, 0x000000a2, 0x00000291,
  0x80000006, 0x0000000d, 0x000000c2, 0x8000030e,
  0x00000006, 0x0000000d, 0x000000c2, 0x0000030e,
  0x80000002, 0x00000005, 0x00000042, 0x8000011a,
  0x00000003, 0x00000007, 0x00000062, 0x00000197,
  0x80000003, 0x00000007, 0x00000062, 0x80000197,
  0x00000002, 0x00000005, 0x00000042, 0x0000011a,
  0x80000001, 0x00000003, 0x00000022, 0x8000009d,
  0x00000001, 0x00000003, 0x00000022, 0x0000009d,
  0x80000000, 0x00000001, 0x00000002, 0x80000020,
  0xd5555556, 0xaaaaaaad, 0xaaaaaac2, 0x2aaaab1e,
  0x80000000, 0x00000001, 0x00000002, 0x80000020,
  0xffffffff, 0xffffffff, 0xffffffe2, 0xffffffa3,
  0x55555555, 0xaaaaaaab, 0xaaaaaaa2, 0xaaaaaaa1,
  0x88888889, 0x11111113, 0x11111122, 0xaaaaab05,
  0x7fffffff, 0xffffffff, 0xffffffe2, 0x7fffffa3,
  0xd5555555, 0xaaaaaaab, 0xaaaaaaa2, 0x2aaaaaa1,
  0x08888889, 0x11111113, 0x11111122, 0x2aaaab05,
  0x08890889, 0x11121113, 0x11211122, 0x2ae92b05,
  0x55555556, 0xaaaaaaad, 0xaaaaaac2, 0xaaaaab1e,
  0x8888888a, 0x11111115, 0x11111142, 0xaaaaab82,
  0x8889088a, 0x11121115, 0x11211142, 0xaae92b82,
  0x88898889, 0x11131113, 0x11311122, 0xab27ab05,
  0x33333334, 0x66666669, 0x66666682, 0x00000084,
  0x3333b334, 0x66676669, 0x66766682, 0x003e8084,
  0x33343333, 0x66686667, 0x66866662, 0x007d0007,
  0x3334b331, 0x66696663, 0x66966622, 0x00bb7f0d,
  0x00008000, 0x00010001, 0x00100002, 0x003e8020,
  0x0000ffff, 0x0001ffff, 0x001fffe2, 0x007cffa3,
  0x00017ffd, 0x0002fffb, 0x002fffa2, 0x00bb7ea9,
  0x0001fffa, 0x0003fff5, 0x003fff42, 0x00f9fd32,
  0x00007fff, 0x0000ffff, 0x000fffe2, 0x003e7fa3,
  0x0000fffd, 0x0001fffb, 0x001fffa2, 0x007cfea9,
  0x00017ffa, 0x0002fff5, 0x002fff42, 0x00bb7d32,
  0x0001807a, 0x000300f5, 0x00300f42, 0x00bbbbb2,
  0x00007ffe, 0x0000fffd, 0x000fffc2, 0x003e7f26,
  0x0000fffb, 0x0001fff7, 0x001fff62, 0x007cfdaf,
  0x0001007b, 0x000200f7, 0x00200f62, 0x007d3c2f,
  0x000100fa, 0x000201f5, 0x00201f42, 0x007d7a32,
  0x00007ffd, 0x0000fffb, 0x000fffa2, 0x003e7ea9,
  0x0000807d, 0x000100fb, 0x00100fa2, 0x003ebd29,
  0x000080fc, 0x000101f9, 0x00101f82, 0x003efb2c,
  0x0000817a, 0x000102f5, 0x00102f42, 0x003f38b2,
  0x00000080, 0x00000101, 0x00001002, 0x00003ea0,
  0x000000ff, 0x000001ff, 0x00001fe2, 0x00007ca3,
  0x0000017d, 0x000002fb, 0x00002fa2, 0x0000ba29,
  0x000001fa, 0x000003f5, 0x00003f42, 0x0000f732,
  0x0000007f, 0x000000ff, 0x00000fe2, 0x00003e23,
  0x000000fd, 0x000001fb, 0x00001fa2, 0x00007ba9,
  0x0000017a, 0x000002f5, 0x00002f42, 0x0000b8b2,
  0x0000019a, 0x00000335, 0x00003342, 0x0000c852,
  0x0000007e, 0x000000fd, 0x00000fc2, 0x00003da6,
  0x000000fb, 0x000001f7, 0x00001f62, 0x00007aaf,
  0x0000011b, 0x00000237, 0x00002362, 0x00008a4f,
  0x0000011e, 0x0000023d, 0x000023c2, 0x00008bc6,
  0x0000007d, 0x000000fb, 0x00000fa2, 0x00003d29,
  0x0000009d, 0x0000013b, 0x000013a2, 0x00004cc9,
  0x000000a0, 0x00000141, 0x00001402, 0x00004e40,
  0x000000a2, 0x00000145, 0x00001442, 0x00004f3a,
  0x00000020, 0x00000041, 0x00000402, 0x00000fc0,
  0x00000023, 0x00000047, 0x00000462, 0x00001137,
  0x00000025, 0x0000004b, 0x000004a2, 0x00001231,
  0x00000026, 0x0000004d, 0x000004c2, 0x000012ae,
  0x00000006, 0x00000061, 0x00000179, 0x0000019a,
  0x0000000a, 0x000000a1, 0x00000273, 0x00000296,
  0x0000000c, 0x000000c1, 0x000002f0, 0x00000314,
  0x0000000c, 0x000000c1, 0x000002f0, 0x00000314,
  0x00000004, 0x00000041, 0x000000fc, 0x0000011c,
  0x00000006, 0x00000061, 0x00000179, 0x0000019a,
  0x00000006, 0x00000061, 0x00000179, 0x0000019a,
  0x00000004, 0x00000041, 0x000000fc, 0x0000011c,
  0x00000002, 0x00000021, 0x0000007f, 0x0000009e,
  0x00000002, 0x00000021, 0x0000007f, 0x0000009e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffffffc, 0xffffffc1, 0xffffff08, 0xffffff24,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffffffe, 0xffffffe1, 0xffffff85, 0xffffffa2,
  0xfffffffa, 0xffffffa1, 0xfffffe8b, 0xfffffea6,
  0xffffffba, 0xfffffba1, 0xffffeeeb, 0xffffeee6,
  0xfffffffe, 0xffffffe1, 0xffffff85, 0xffffffa2,
  0xfffffffa, 0xffffffa1, 0xfffffe8b, 0xfffffea6,
  0xffffffba, 0xfffffba1, 0xffffeeeb, 0xffffeee6,
  0xfffffec0, 0xffffec01, 0xffffb1e2, 0xffffb160,
  0xfffffffc, 0xffffffc1, 0xffffff08, 0xffffff24,
  0xffffffbc, 0xfffffbc1, 0xffffef68, 0xffffef64,
  0xfffffec2, 0xffffec21, 0xffffb25f, 0xffffb1de,
  0xfffffdc6, 0xffffdc61, 0xffff74d9, 0xffff73da,
  0xffffffc0, 0xfffffc01, 0xfffff062, 0xfffff060,
  0xfffffec6, 0xffffec61, 0xffffb359, 0xffffb2da,
  0xfffffdca, 0xffffdca1, 0xffff75d3, 0xffff74d6,
  0xfffffccc, 0xffffccc1, 0xffff37d0, 0xffff3654,
  0xffffff06, 0xfffff061, 0xffffc2f9, 0xffffc29a,
  0xfffffe0a, 0xffffe0a1, 0xffff8573, 0xffff8496,
  0xfffffd0c, 0xffffd0c1, 0xffff4770, 0xffff4614,
  0xfffefd12, 0xffefd121, 0xffc0c8e7, 0xffc0478e,
  0xffffff04, 0xfffff041, 0xffffc27c, 0xffffc21c,
  0xfffffe06, 0xffffe061, 0xffff8479, 0xffff839a,
  0xfffefe0c, 0xffefe0c1, 0xffc105f0, 0xffc08514,
  0xfffdfe10, 0xffdfe101, 0xff8286ea, 0xff818610,
  0xffffff02, 0xfffff021, 0xffffc1ff, 0xffffc19e,
  0xfffeff08, 0xffeff081, 0xffc14376, 0xffc0c318,
  0xfffdff0c, 0xffdff0c1, 0xff82c470, 0xff81c414,
  0xfffcff0e, 0xffcff0e1, 0xff4444ed, 0xff42c492,
  0xffff0006, 0xfff00061, 0xffc18179, 0xffc1019a,
  0xfffe000a, 0xffe000a1, 0xff830273, 0xff820296,
  0xfffd000c, 0xffd000c1, 0xff4482f0, 0xff430314,
  0x999699a6, 0x99699a61, 0xff448309, 0xcc0fcffa,
  0xffff0004, 0xfff00041, 0xffc180fc, 0xffc1011c,
  0xfffe0006, 0xffe00061, 0xff830179, 0xff82019a,
  0x999799a0, 0x99799a01, 0xff830192, 0xcc4ece80,
  0xeeeceef6, 0xeeceef61, 0x54d85711, 0xcc4eceaa,
  0xffff0002, 0xfff00021, 0xffc1807f, 0xffc1009e,
  0x9998999c, 0x998999c1, 0xffc18098, 0xcc8dcd84,
  0xeeedeef2, 0xeedeef21, 0x5516d617, 0xcc8dcdae,
  0xeeedeef8, 0xeedeef81, 0xd516d78e, 0xcc8dcf28,
  0x9999999a, 0x999999a1, 0x0000001b, 0xcccccd06,
  0xeeeeeef0, 0xeeeeef01, 0x5555559a, 0xcccccd30,
  0xeeeeeef6, 0xeeeeef61, 0xd5555711, 0xccccceaa,
  0xeeeeeefa, 0xeeeeefa1, 0x5555580b, 0xcccccfa6,
  0x55555556, 0x55555561, 0x55555581, 0x0000004a,
  0x5555555c, 0x555555c1, 0xd55556f8, 0x000001c4,
  0x55555560, 0x55555601, 0x555557f2, 0x000002c0,
  0x55555562, 0x55555621, 0xd555586f, 0x0000033e,
  0x00000006, 0x00000061, 0x80000179, 0x0000019a,
  0x0000000a, 0x000000a1, 0x00000273, 0x00000296,
  0x0000000c, 0x000000c1, 0x800002f0, 0x00000314,
  0x0000000c, 0x000000c1, 0x000002f0, 0x00000314,
  0x00000004, 0x00000041, 0x800000fc, 0x0000011c,
  0x00000006, 0x00000061, 0x00000179, 0x0000019a,
  0x00000006, 0x00000061, 0x80000179, 0x0000019a,
  0x00000004, 0x00000041, 0x000000fc, 0x0000011c,
  0x00000002, 0x00000021, 0x8000007f, 0x0000009e,
  0x00000002, 0x00000021, 0x0000007f, 0x0000009e,
  0x00000000, 0x00000001, 0x80000002, 0x00000020,
  0xaaaaaaac, 0xaaaaaac1, 0x2aaaab00, 0x00000074,
  0x00000000, 0x00000001, 0x80000002, 0x00000020,
  0xfffffffe, 0xffffffe1, 0xffffff85, 0xffffffa2,
  0xaaaaaaaa, 0xaaaaaaa1, 0xaaaaaa83, 0xfffffff6,
  0x11111112, 0x11111121, 0xaaaaaae7, 0x3333338e,
  0xfffffffe, 0xffffffe1, 0x7fffff85, 0xffffffa2,
  0xaaaaaaaa, 0xaaaaaaa1, 0x2aaaaa83, 0xfffffff6,
  0x11111112, 0x11111121, 0x2aaaaae7, 0x3333338e,
  0x11121112, 0x11211121, 0x2ae92ae7, 0x3372338e,
  0xaaaaaaac, 0xaaaaaac1, 0xaaaaab00, 0x00000074,
  0x11111114, 0x11111141, 0xaaaaab64, 0x3333340c,
  0x11121114, 0x11211141, 0xaae92b64, 0x3372340c,
  0x11131112, 0x11311121, 0xab27aae7, 0x33b1338e,
  0x66666668, 0x66666681, 0x00000066, 0x333333b8,
  0x66676668, 0x66766681, 0x003e8066, 0x337233b8,
  0x66686666, 0x66866661, 0x007cffe9, 0x33b1333a,
  0x66696662, 0x66966621, 0x00bb7eef, 0x33f0323e,
  0x00010000, 0x00100001, 0x003e8002, 0x003f0020,
  0x0001fffe, 0x001fffe1, 0x007cff85, 0x007dffa2,
  0x0002fffa, 0x002fffa1, 0x00bb7e8b, 0x00bcfea6,
  0x0003fff4, 0x003fff41, 0x00f9fd14, 0x00fbfd2c,
  0x0000fffe, 0x000fffe1, 0x003e7f85, 0x003effa2,
  0x0001fffa, 0x001fffa1, 0x007cfe8b, 0x007dfea6,
  0x0002fff4, 0x002fff41, 0x00bb7d14, 0x00bcfd2c,
  0x000300f4, 0x00300f41, 0x00bbbb94, 0x00bd3c2c,
  0x0000fffc, 0x000fffc1, 0x003e7f08, 0x003eff24,
  0x0001fff6, 0x001fff61, 0x007cfd91, 0x007dfdaa,
  0x000200f6, 0x00200f61, 0x007d3c11, 0x007e3caa,
  0x000201f4, 0x00201f41, 0x007d7a14, 0x007e7b2c,
  0x0000fffa, 0x000fffa1, 0x003e7e8b, 0x003efea6,
  0x000100fa, 0x00100fa1, 0x003ebd0b, 0x003f3da6,
  0x000101f8, 0x00101f81, 0x003efb0e, 0x003f7c28,
  0x000102f4, 0x00102f41, 0x003f3894, 0x003fba2c,
  0x00000100, 0x00001001, 0x00003e82, 0x00003f20,
  0x000001fe, 0x00001fe1, 0x00007c85, 0x00007da2,
  0x000002fa, 0x00002fa1, 0x0000ba0b, 0x0000bba6,
  0x000003f4, 0x00003f41, 0x0000f714, 0x0000f92c,
  0x000000fe, 0x00000fe1, 0x00003e05, 0x00003ea2,
  0x000001fa, 0x00001fa1, 0x00007b8b, 0x00007ca6,
  0x000002f4, 0x00002f41, 0x0000b894, 0x0000ba2c,
  0x00000334, 0x00003341, 0x0000c834, 0x0000c9ec,
  0x000000fc, 0x00000fc1, 0x00003d88, 0x00003e24,
  0x000001f6, 0x00001f61, 0x00007a91, 0x00007baa,
  0x00000236, 0x00002361, 0x00008a31, 0x00008b6a,
  0x0000023c, 0x000023c1, 0x00008ba8, 0x00008ce4,
  0x000000fa, 0x00000fa1, 0x00003d0b, 0x00003da6,
  0x0000013a, 0x000013a1, 0x00004cab, 0x00004d66,
  0x00000140, 0x00001401, 0x00004e22, 0x00004ee0,
  0x00000144, 0x00001441, 0x00004f1c, 0x00004fdc,
  0x00000040, 0x00000401, 0x00000fa2, 0x00000fe0,
  0x00000046, 0x00000461, 0x00001119, 0x0000115a,
  0x0000004a, 0x000004a1, 0x00001213, 0x00001256,
  0x0000004c, 0x000004c1, 0x00001290, 0x000012d4,
  0x00000060, 0x00000178, 0x0000017c, 0x0000019d,
  0x000000a0, 0x00000272, 0x00000278, 0x0000029b,
  0x000000c0, 0x000002ef, 0x000002f6, 0x0000031a,
  0x000000c0, 0x000002ef, 0x000002f6, 0x0000031a,
  0x00000040, 0x000000fb, 0x000000fe, 0x0000011e,
  0x00000060, 0x00000178, 0x0000017c, 0x0000019d,
  0x00000060, 0x00000178, 0x0000017c, 0x0000019d,
  0x00000040, 0x000000fb, 0x000000fe, 0x0000011e,
  0x00000020, 0x0000007e, 0x00000080, 0x0000009f,
  0x00000020, 0x0000007e, 0x00000080, 0x0000009f,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffffc0, 0xffffff07, 0xffffff06, 0xffffff22,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffffe0, 0xffffff84, 0xffffff84, 0xffffffa1,
  0xffffffa0, 0xfffffe8a, 0xfffffe88, 0xfffffea3,
  0xfffffba0, 0xffffeeea, 0xffffeec8, 0xffffeec3,
  0xffffffe0, 0xffffff84, 0xffffff84, 0xffffffa1,
  0xffffffa0, 0xfffffe8a, 0xfffffe88, 0xfffffea3,
  0xfffffba0, 0xffffeeea, 0xffffeec8, 0xffffeec3,
  0xffffec00, 0xffffb1e1, 0xffffb142, 0xffffb0c0,
  0xffffffc0, 0xffffff07, 0xffffff06, 0xffffff22,
  0xfffffbc0, 0xffffef67, 0xffffef46, 0xffffef42,
  0xffffec20, 0xffffb25e, 0xffffb1c0, 0xffffb13f,
  0xffffdc60, 0xffff74d8, 0xffff73bc, 0xffff72bd,
  0xfffffc00, 0xfffff061, 0xfffff042, 0xfffff040,
  0xffffec60, 0xffffb358, 0xffffb2bc, 0xffffb23d,
  0xffffdca0, 0xffff75d2, 0xffff74b8, 0xffff73bb,
  0xffffccc0, 0xffff37cf, 0xffff3636, 0xffff34ba,
  0xfffff060, 0xffffc2f8, 0xffffc27c, 0xffffc21d,
  0xffffe0a0, 0xffff8572, 0xffff8478, 0xffff839b,
  0xffffd0c0, 0xffff476f, 0xffff45f6, 0xffff449a,
  0xffefd120, 0xffc0c8e6, 0xffc04770, 0xffbfc617,
  0xfffff040, 0xffffc27b, 0xffffc1fe, 0xffffc19e,
  0xffffe060, 0xffff8478, 0xffff837c, 0xffff829d,
  0xffefe0c0, 0xffc105ef, 0xffc084f6, 0xffc0041a,
  0xffdfe100, 0xff8286e9, 0xff8185f2, 0xff808518,
  0xfffff020, 0xffffc1fe, 0xffffc180, 0xffffc11f,
  0xffeff080, 0xffc14375, 0xffc0c2fa, 0xffc0429c,
  0xffdff0c0, 0xff82c46f, 0xff81c3f6, 0xff80c39a,
  0xffcff0e0, 0xff4444ec, 0xff42c474, 0xff414419,
  0xfff00060, 0xffc18178, 0xffc1017c, 0xffc0819d,
  0xffe000a0, 0xff830272, 0xff820278, 0xff81029b,
  0xffd000c0, 0xff4482ef, 0xff4302f6, 0xff41831a,
  0x99699a60, 0xff448308, 0xcc0fcfdc, 0x98db1ccd,
  0xfff00040, 0xffc180fb, 0xffc100fe, 0xffc0811e,
  0xffe00060, 0xff830178, 0xff82017c, 0xff81019d,
  0x99799a00, 0xff830191, 0xcc4ece62, 0x991a9b50,
  0xeeceef60, 0x54d85710, 0xcc4ece8c, 0x43c54625,
  0xfff00020, 0xffc1807e, 0xffc10080, 0xffc0809f,
  0x998999c0, 0xffc18097, 0xcc8dcd66, 0x995a1a52,
  0xeedeef20, 0x5516d616, 0xcc8dcd90, 0x4404c527,
  0xeedeef80, 0xd516d78d, 0xcc8dcf0a, 0xc404c6a4,
  0x999999a0, 0x0000001a, 0xcccccce8, 0x999999d3,
  0xeeeeef00, 0x55555599, 0xcccccd12, 0x444444a8,
  0xeeeeef60, 0xd5555710, 0xccccce8c, 0xc4444625,
  0xeeeeefa0, 0x5555580a, 0xcccccf88, 0x44444723,
  0x55555560, 0x55555580, 0x0000002c, 0xaaaaaaf5,
  0x555555c0, 0xd55556f7, 0x000001a6, 0x2aaaac72,
  0x55555600, 0x555557f1, 0x000002a2, 0xaaaaad70,
  0x55555620, 0xd555586e, 0x00000320, 0x2aaaadef,
  0x00000060, 0x80000178, 0x0000017c, 0x8000019d,
  0x000000a0, 0x00000272, 0x00000278, 0x0000029b,
  0x000000c0, 0x800002ef, 0x000002f6, 0x8000031a,
  0x000000c0, 0x000002ef, 0x000002f6, 0x0000031a,
  0x00000040, 0x800000fb, 0x000000fe, 0x8000011e,
  0x00000060, 0x00000178, 0x0000017c, 0x0000019d,
  0x00000060, 0x80000178, 0x0000017c, 0x8000019d,
  0x00000040, 0x000000fb, 0x000000fe, 0x0000011e,
  0x00000020, 0x8000007e, 0x00000080, 0x8000009f,
  0x00000020, 0x0000007e, 0x00000080, 0x0000009f,
  0x00000000, 0x80000001, 0x00000002, 0x80000020,
  0xaaaaaac0, 0x2aaaaaff, 0x00000056, 0xd55555ca,
  0x00000000, 0x80000001, 0x00000002, 0x80000020,
  0xffffffe0, 0xffffff84, 0xffffff84, 0xffffffa1,
  0xaaaaaaa0, 0xaaaaaa82, 0xffffffd8, 0x5555554b,
  0x11111120, 0xaaaaaae6, 0x33333370, 0xbbbbbc17,
  0xffffffe0, 0x7fffff84, 0xffffff84, 0x7fffffa1,
  0xaaaaaaa0, 0x2aaaaa82, 0xffffffd8, 0xd555554b,
  0x11111120, 0x2aaaaae6, 0x33333370, 0x3bbbbc17,
  0x11211120, 0x2ae92ae6, 0x33723370, 0x3bfb3c17,
  0xaaaaaac0, 0xaaaaaaff, 0x00000056, 0x555555ca,
  0x11111140, 0xaaaaab63, 0x333333ee, 0xbbbbbc96,
  0x11211140, 0xaae92b63, 0x337233ee, 0xbbfb3c96,
  0x11311120, 0xab27aae6, 0x33b13370, 0xbc3abc17,
  0x66666680, 0x00000065, 0x3333339a, 0x666666ec,
  0x66766680, 0x003e8065, 0x3372339a, 0x66a5e6ec,
  0x66866660, 0x007cffe8, 0x33b1331c, 0x66e5666d,
  0x66966620, 0x00bb7eee, 0x33f03220, 0x6724e56f,
  0x00100000, 0x003e8001, 0x003f0002, 0x003f8020,
  0x001fffe0, 0x007cff84, 0x007dff84, 0x007effa1,
  0x002fffa0, 0x00bb7e8a, 0x00bcfe88, 0x00be7ea3,
  0x003fff40, 0x00f9fd13, 0x00fbfd0e, 0x00fdfd26,
  0x000fffe0, 0x003e7f84, 0x003eff84, 0x003f7fa1,
  0x001fffa0, 0x007cfe8a, 0x007dfe88, 0x007efea3,
  0x002fff40, 0x00bb7d13, 0x00bcfd0e, 0x00be7d26,
  0x00300f40, 0x00bbbb93, 0x00bd3c0e, 0x00bebca6,
  0x000fffc0, 0x003e7f07, 0x003eff06, 0x003f7f22,
  0x001fff60, 0x007cfd90, 0x007dfd8c, 0x007efda5,
  0x00200f60, 0x007d3c10, 0x007e3c8c, 0x007f3d25,
  0x00201f40, 0x007d7a13, 0x007e7b0e, 0x007f7c26,
  0x000fffa0, 0x003e7e8a, 0x003efe88, 0x003f7ea3,
  0x00100fa0, 0x003ebd0a, 0x003f3d88, 0x003fbe23,
  0x00101f80, 0x003efb0d, 0x003f7c0a, 0x003ffd24,
  0x00102f40, 0x003f3893, 0x003fba0e, 0x00403ba6,
  0x00001000, 0x00003e81, 0x00003f02, 0x00003fa0,
  0x00001fe0, 0x00007c84, 0x00007d84, 0x00007ea1,
  0x00002fa0, 0x0000ba0a, 0x0000bb88, 0x0000bd23,
  0x00003f40, 0x0000f713, 0x0000f90e, 0x0000fb26,
  0x00000fe0, 0x00003e04, 0x00003e84, 0x00003f21,
  0x00001fa0, 0x00007b8a, 0x00007c88, 0x00007da3,
  0x00002f40, 0x0000b893, 0x0000ba0e, 0x0000bba6,
  0x00003340, 0x0000c833, 0x0000c9ce, 0x0000cb86,
  0x00000fc0, 0x00003d87, 0x00003e06, 0x00003ea2,
  0x00001f60, 0x00007a90, 0x00007b8c, 0x00007ca5,
  0x00002360, 0x00008a30, 0x00008b4c, 0x00008c85,
  0x000023c0, 0x00008ba7, 0x00008cc6, 0x00008e02,
  0x00000fa0, 0x00003d0a, 0x00003d88, 0x00003e23,
  0x000013a0, 0x00004caa, 0x00004d48, 0x00004e03,
  0x00001400, 0x00004e21, 0x00004ec2, 0x00004f80,
  0x00001440, 0x00004f1b, 0x00004fbe, 0x0000507e,
  0x00000400, 0x00000fa1, 0x00000fc2, 0x00001000,
  0x00000460, 0x00001118, 0x0000113c, 0x0000117d,
  0x000004a0, 0x00001212, 0x00001238, 0x0000127b,
  0x000004c0, 0x0000128f, 0x000012b6, 0x000012fa,
  0x00000177, 0x0000017b, 0x0000017f, 0x00018017,
  0x00000271, 0x00000277, 0x0000027d, 0x00028011,
  0x000002ee, 0x000002f5, 0x000002fc, 0x0003000e,
  0x000002ee, 0x000002f5, 0x000002fc, 0x0003000e,
  0x000000fa, 0x000000fd, 0x00000100, 0x0001001a,
  0x00000177, 0x0000017b, 0x0000017f, 0x00018017,
  0x00000177, 0x0000017b, 0x0000017f, 0x00018017,
  0x000000fa, 0x000000fd, 0x00000100, 0x0001001a,
  0x0000007d, 0x0000007f, 0x00000081, 0x0000801d,
  0x0000007d, 0x0000007f, 0x00000081, 0x0000801d,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff06, 0xffffff05, 0xffffff04, 0xffff0026,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff83, 0xffffff83, 0xffffff83, 0xffff8023,
  0xfffffe89, 0xfffffe87, 0xfffffe85, 0xfffe8029,
  0xffffeee9, 0xffffeec7, 0xffffeea5, 0xffee8089,
  0xffffff83, 0xffffff83, 0xffffff83, 0xffff8023,
  0xfffffe89, 0xfffffe87, 0xfffffe85, 0xfffe8029,
  0xffffeee9, 0xffffeec7, 0xffffeea5, 0xffee8089,
  0xffffb1e0, 0xffffb141, 0xffffb0a2, 0xffb00200,
  0xffffff06, 0xffffff05, 0xffffff04, 0xffff0026,
  0xffffef66, 0xffffef45, 0xffffef24, 0xffef0086,
  0xffffb25d, 0xffffb1bf, 0xffffb121, 0xffb081fd,
  0xffff74d7, 0xffff73bb, 0xffff729f, 0xff718377,
  0xfffff060, 0xfffff041, 0xfffff022, 0xfff00080,
  0xffffb357, 0xffffb2bb, 0xffffb21f, 0xffb181f7,
  0xffff75d1, 0xffff74b7, 0xffff739d, 0xff728371,
  0xffff37ce, 0xffff3635, 0xffff349c, 0xff3304ee,
  0xffffc2f7, 0xffffc27b, 0xffffc1ff, 0xffc18197,
  0xffff8571, 0xffff8477, 0xffff837d, 0xff828311,
  0xffff476e, 0xffff45f5, 0xffff447c, 0xff43048e,
  0xffc0c8e5, 0xffc0476f, 0xffbfc5f9, 0xbf460485,
  0xffffc27a, 0xffffc1fd, 0xffffc180, 0xffc1019a,
  0xffff8477, 0xffff837b, 0xffff827f, 0xff818317,
  0xffc105ee, 0xffc084f5, 0xffc003fc, 0xbf84830e,
  0xff8286e8, 0xff8185f1, 0xff8084fa, 0x7f870308,
  0xffffc1fd, 0xffffc17f, 0xffffc101, 0xffc0819d,
  0xffc14374, 0xffc0c2f9, 0xffc0427e, 0xbfc38194,
  0xff82c46e, 0xff81c3f5, 0xff80c37c, 0x7fc6018e,
  0xff4444eb, 0xff42c473, 0xff4143fb, 0x3fc8018b,
  0xffc18177, 0xffc1017b, 0xffc0817f, 0xc0030017,
  0xff830271, 0xff820277, 0xff81027d, 0x80058011,
  0xff4482ee, 0xff4302f5, 0xff4182fc, 0x4007800e,
  0xff448307, 0xcc0fcfdb, 0x98db1caf, 0x400799a7,
  0xffc180fa, 0xffc100fd, 0xffc08100, 0xc002801a,
  0xff830177, 0xff82017b, 0xff81017f, 0x80048017,
  0xff830190, 0xcc4ece61, 0x991a9b32, 0x800499b0,
  0x54d8570f, 0xcc4ece8b, 0x43c54607, 0xd55a19af,
  0xffc1807d, 0xffc1007f, 0xffc08081, 0xc002001d,
  0xffc18096, 0xcc8dcd65, 0x995a1a34, 0xc00219b6,
  0x5516d615, 0xcc8dcd8f, 0x4404c509, 0x155799b5,
  0xd516d78c, 0xcc8dcf09, 0xc404c686, 0x955919ac,
  0x00000019, 0xcccccce7, 0x999999b5, 0x000019b9,
  0x55555598, 0xcccccd11, 0x4444448a, 0x555599b8,
  0xd555570f, 0xccccce8b, 0xc4444607, 0xd55719af,
  0x55555809, 0xcccccf87, 0x44444705, 0x555819a9,
  0x5555557f, 0x0000002b, 0xaaaaaad7, 0x5555801f,
  0xd55556f6, 0x000001a5, 0x2aaaac54, 0xd5570016,
  0x555557f0, 0x000002a1, 0xaaaaad52, 0x55580010,
  0xd555586d, 0x0000031f, 0x2aaaadd1, 0xd558800d,
  0x80000177, 0x0000017b, 0x8000017f, 0x80018017,
  0x00000271, 0x00000277, 0x0000027d, 0x00028011,
  0x800002ee, 0x000002f5, 0x800002fc, 0x8003000e,
  0x000002ee, 0x000002f5, 0x000002fc, 0x0003000e,
  0x800000fa, 0x000000fd, 0x80000100, 0x8001001a,
  0x00000177, 0x0000017b, 0x0000017f, 0x00018017,
  0x80000177, 0x0000017b, 0x8000017f, 0x80018017,
  0x000000fa, 0x000000fd, 0x00000100, 0x0001001a,
  0x8000007d, 0x0000007f, 0x80000081, 0x8000801d,
  0x0000007d, 0x0000007f, 0x00000081, 0x0000801d,
  0x80000000, 0x00000001, 0x80000002, 0x80000020,
  0x2aaaaafe, 0x00000055, 0xd55555ac, 0x2aab001e,
  0x80000000, 0x00000001, 0x80000002, 0x80000020,
  0xffffff83, 0xffffff83, 0xffffff83, 0xffff8023,
  0xaaaaaa81, 0xffffffd7, 0x5555552d, 0xaaaa8021,
  0xaaaaaae5, 0x3333336f, 0xbbbbbbf9, 0xaaaae685,
  0x7fffff83, 0xffffff83, 0x7fffff83, 0x7fff8023,
  0x2aaaaa81, 0xffffffd7, 0xd555552d, 0x2aaa8021,
  0x2aaaaae5, 0x3333336f, 0x3bbbbbf9, 0x2aaae685,
  0x2ae92ae5, 0x3372336f, 0x3bfb3bf9, 0x6aa96685,
  0xaaaaaafe, 0x00000055, 0x555555ac, 0xaaab001e,
  0xaaaaab62, 0x333333ed, 0xbbbbbc78, 0xaaab6682,
  0xaae92b62, 0x337233ed, 0xbbfb3c78, 0xeaa9e682,
  0xab27aae5, 0x33b1336f, 0xbc3abbf9, 0x2aa7e685,
  0x00000064, 0x33333399, 0x666666ce, 0x00006684,
  0x003e8064, 0x33723399, 0x66a5e6ce, 0x3ffee684,
  0x007cffe7, 0x33b1331b, 0x66e5664f, 0x7ffce687,
  0x00bb7eed, 0x33f0321f, 0x6724e551, 0xbffa668d,
  0x003e8000, 0x003f0001, 0x003f8002, 0x3ffe8020,
  0x007cff83, 0x007dff83, 0x007eff83, 0x7ffc8023,
  0x00bb7e89, 0x00bcfe87, 0x00be7e85, 0xbffa0029,
  0x00f9fd12, 0x00fbfd0d, 0x00fdfd08, 0xfff70032,
  0x003e7f83, 0x003eff83, 0x003f7f83, 0x3ffe0023,
  0x007cfe89, 0x007dfe87, 0x007efe85, 0x7ffb8029,
  0x00bb7d12, 0x00bcfd0d, 0x00be7d08, 0xbff88032,
  0x00bbbb92, 0x00bd3c0d, 0x00bebc88, 0xc0387eb2,
  0x003e7f06, 0x003eff05, 0x003f7f04, 0x3ffd8026,
  0x007cfd8f, 0x007dfd8b, 0x007efd87, 0x7ffa802f,
  0x007d3c0f, 0x007e3c8b, 0x007f3d07, 0x803a7eaf,
  0x007d7a12, 0x007e7b0d, 0x007f7c08, 0x8079fd32,
  0x003e7e89, 0x003efe87, 0x003f7e85, 0x3ffd0029,
  0x003ebd09, 0x003f3d87, 0x003fbe05, 0x403cfea9,
  0x003efb0c, 0x003f7c09, 0x003ffd06, 0x407c7d2c,
  0x003f3892, 0x003fba0d, 0x00403b88, 0x40bb7bb2,
  0x00003e80, 0x00003f01, 0x00003f82, 0x003ffea0,
  0x00007c83, 0x00007d83, 0x00007e83, 0x007f7d23,
  0x0000ba09, 0x0000bb87, 0x0000bd05, 0x00be7ba9,
  0x0000f712, 0x0000f90d, 0x0000fb08, 0x00fcfa32,
  0x00003e03, 0x00003e83, 0x00003f03, 0x003f7ea3,
  0x00007b89, 0x00007c87, 0x00007d85, 0x007e7d29,
  0x0000b892, 0x0000ba0d, 0x0000bb88, 0x00bcfbb2,
  0x0000c832, 0x0000c9cd, 0x0000cb68, 0x00ccfb52,
  0x00003d86, 0x00003e05, 0x00003e84, 0x003efea6,
  0x00007a8f, 0x00007b8b, 0x00007c87, 0x007d7d2f,
  0x00008a2f, 0x00008b4b, 0x00008c67, 0x008d7ccf,
  0x00008ba6, 0x00008cc5, 0x00008de4, 0x008efcc6,
  0x00003d09, 0x00003d87, 0x00003e05, 0x003e7ea9,
  0x00004ca9, 0x00004d47, 0x00004de5, 0x004e7e49,
  0x00004e20, 0x00004ec1, 0x00004f62, 0x004ffe40,
  0x00004f1a, 0x00004fbd, 0x00005060, 0x0050fe3a,
  0x00000fa0, 0x00000fc1, 0x00000fe2, 0x000fffc0,
  0x00001117, 0x0000113b, 0x0000115f, 0x00117fb7,
  0x00001211, 0x00001237, 0x0000125d, 0x00127fb1,
  0x0000128e, 0x000012b5, 0x000012dc, 0x0012ffae,
  0x0000017a, 0x0000017e, 0x00017ff9, 0x0001801a,
  0x00000276, 0x0000027c, 0x00027ff3, 0x00028016,
  0x000002f4, 0x000002fb, 0x0002fff0, 0x00030014,
  0x000002f4, 0x000002fb, 0x0002fff0, 0x00030014,
  0x000000fc, 0x000000ff, 0x0000fffc, 0x0001001c,
  0x0000017a, 0x0000017e, 0x00017ff9, 0x0001801a,
  0x0000017a, 0x0000017e, 0x00017ff9, 0x0001801a,
  0x000000fc, 0x000000ff, 0x0000fffc, 0x0001001c,
  0x0000007e, 0x00000080, 0x00007fff, 0x0000801e,
  0x0000007e, 0x00000080, 0x00007fff, 0x0000801e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff04, 0xffffff03, 0xffff0008, 0xffff0024,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff82, 0xffffff82, 0xffff8005, 0xffff8022,
  0xfffffe86, 0xfffffe84, 0xfffe800b, 0xfffe8026,
  0xffffeec6, 0xffffeea4, 0xffee806b, 0xffee8066,
  0xffffff82, 0xffffff82, 0xffff8005, 0xffff8022,
  0xfffffe86, 0xfffffe84, 0xfffe800b, 0xfffe8026,
  0xffffeec6, 0xffffeea4, 0xffee806b, 0xffee8066,
  0xffffb140, 0xffffb0a1, 0xffb001e2, 0xffb00160,
  0xffffff04, 0xffffff03, 0xffff0008, 0xffff0024,
  0xffffef44, 0xffffef23, 0xffef0068, 0xffef0064,
  0xffffb1be, 0xffffb120, 0xffb081df, 0xffb0815e,
  0xffff73ba, 0xffff729e, 0xff718359, 0xff71825a,
  0xfffff040, 0xfffff021, 0xfff00062, 0xfff00060,
  0xffffb2ba, 0xffffb21e, 0xffb181d9, 0xffb1815a,
  0xffff74b6, 0xffff739c, 0xff728353, 0xff728256,
  0xffff3634, 0xffff349b, 0xff3304d0, 0xff330354,
  0xffffc27a, 0xffffc1fe, 0xffc18179, 0xffc1811a,
  0xffff8476, 0xffff837c, 0xff8282f3, 0xff828216,
  0xffff45f4, 0xffff447b, 0xff430470, 0xff430314,
  0xffc0476e, 0xffbfc5f8, 0xbf460467, 0xbf45830e,
  0xffffc1fc, 0xffffc17f, 0xffc1017c, 0xffc1011c,
  0xffff837a, 0xffff827e, 0xff8182f9, 0xff81821a,
  0xffc084f4, 0xffc003fb, 0xbf8482f0, 0xbf840214,
  0xff8185f0, 0xff8084f9, 0x7f8702ea, 0x7f860210,
  0xffffc17e, 0xffffc100, 0xffc0817f, 0xffc0811e,
  0xffc0c2f8, 0xffc0427d, 0xbfc38176, 0xbfc30118,
  0xff81c3f4, 0xff80c37b, 0x7fc60170, 0x7fc50114,
  0xff42c472, 0xff4143fa, 0x3fc8016d, 0x3fc68112,
  0xffc1017a, 0xffc0817e, 0xc002fff9, 0xc002801a,
  0xff820276, 0xff81027c, 0x80057ff3, 0x80048016,
  0xff4302f4, 0xff4182fb, 0x40077ff0, 0x40060014,
  0xcc0fcfda, 0x98db1cae, 0x40079989, 0x0cd2e67a,
  0xffc100fc, 0xffc080ff, 0xc0027ffc, 0xc002001c,
  0xff82017a, 0xff81017e, 0x80047ff9, 0x8003801a,
  0xcc4ece60, 0x991a9b31, 0x80049992, 0x4cd06680,
  0xcc4ece8a, 0x43c54606, 0xd55a1991, 0x4cd0912a,
  0xffc1007e, 0xffc08080, 0xc001ffff, 0xc001801e,
  0xcc8dcd64, 0x995a1a33, 0xc0021998, 0x8cce6684,
  0xcc8dcd8e, 0x4404c508, 0x15579997, 0x8cce912e,
  0xcc8dcf08, 0xc404c685, 0x9559198e, 0x8cd01128,
  0xcccccce6, 0x999999b4, 0x0000199b, 0xcccce686,
  0xcccccd10, 0x44444489, 0x5555999a, 0xcccd1130,
  0xccccce8a, 0xc4444606, 0xd5571991, 0xccce912a,
  0xcccccf86, 0x44444704, 0x5558198b, 0xcccf9126,
  0x0000002a, 0xaaaaaad6, 0x55558001, 0x00002aca,
  0x000001a4, 0x2aaaac53, 0xd556fff8, 0x0001aac4,
  0x000002a0, 0xaaaaad51, 0x5557fff2, 0x0002aac0,
  0x0000031e, 0x2aaaadd0, 0xd5587fef, 0x00032abe,
  0x0000017a, 0x8000017e, 0x80017ff9, 0x0001801a,
  0x00000276, 0x0000027c, 0x00027ff3, 0x00028016,
  0x000002f4, 0x800002fb, 0x8002fff0, 0x00030014,
  0x000002f4, 0x000002fb, 0x0002fff0, 0x00030014,
  0x000000fc, 0x800000ff, 0x8000fffc, 0x0001001c,
  0x0000017a, 0x0000017e, 0x00017ff9, 0x0001801a,
  0x0000017a, 0x8000017e, 0x80017ff9, 0x0001801a,
  0x000000fc, 0x000000ff, 0x0000fffc, 0x0001001c,
  0x0000007e, 0x80000080, 0x80007fff, 0x0000801e,
  0x0000007e, 0x00000080, 0x00007fff, 0x0000801e,
  0x00000000, 0x80000001, 0x80000002, 0x00000020,
  0x00000054, 0xd55555ab, 0x2aab0000, 0x00005574,
  0x00000000, 0x80000001, 0x80000002, 0x00000020,
  0xffffff82, 0xffffff82, 0xffff8005, 0xffff8022,
  0xffffffd6, 0x5555552c, 0xaaaa8003, 0xffffd576,
  0x3333336e, 0xbbbbbbf8, 0xaaaae667, 0x33336f0e,
  0xffffff82, 0x7fffff82, 0x7fff8005, 0xffff8022,
  0xffffffd6, 0xd555552c, 0x2aaa8003, 0xffffd576,
  0x3333336e, 0x3bbbbbf8, 0x2aaae667, 0x33336f0e,
  0x3372336e, 0x3bfb3bf8, 0x6aa96667, 0x73326f0e,
  0x00000054, 0x555555ab, 0xaaab0000, 0x00005574,
  0x333333ec, 0xbbbbbc77, 0xaaab6664, 0x3333ef0c,
  0x337233ec, 0xbbfb3c77, 0xeaa9e664, 0x7332ef0c,
  0x33b1336e, 0xbc3abbf8, 0x2aa7e667, 0xb3316f0e,
  0x33333398, 0x666666cd, 0x00006666, 0x333399b8,
  0x33723398, 0x66a5e6cd, 0x3ffee666, 0x733299b8,
  0x33b1331a, 0x66e5664e, 0x7ffce669, 0xb33119ba,
  0x33f0321e, 0x6724e550, 0xbffa666f, 0xf32f19be,
  0x003f0000, 0x003f8001, 0x3ffe8002, 0x3fff0020,
  0x007dff82, 0x007eff82, 0x7ffc8005, 0x7ffd8022,
  0x00bcfe86, 0x00be7e84, 0xbffa000b, 0xbffb8026,
  0x00fbfd0c, 0x00fdfd07, 0xfff70014, 0xfff9002c,
  0x003eff82, 0x003f7f82, 0x3ffe0005, 0x3ffe8022,
  0x007dfe86, 0x007efe84, 0x7ffb800b, 0x7ffc8026,
  0x00bcfd0c, 0x00be7d07, 0xbff88014, 0xbffa002c,
  0x00bd3c0c, 0x00bebc87, 0xc0387e94, 0xc039ff2c,
  0x003eff04, 0x003f7f03, 0x3ffd8008, 0x3ffe0024,
  0x007dfd8a, 0x007efd86, 0x7ffa8011, 0x7ffb802a,
  0x007e3c8a, 0x007f3d06, 0x803a7e91, 0x803b7f2a,
  0x007e7b0c, 0x007f7c07, 0x8079fd14, 0x807afe2c,
  0x003efe86, 0x003f7e84, 0x3ffd000b, 0x3ffd8026,
  0x003f3d86, 0x003fbe04, 0x403cfe8b, 0x403d7f26,
  0x003f7c08, 0x003ffd05, 0x407c7d0e, 0x407cfe28,
  0x003fba0c, 0x00403b87, 0x40bb7b94, 0x40bbfd2c,
  0x00003f00, 0x00003f81, 0x003ffe82, 0x003fff20,
  0x00007d82, 0x00007e82, 0x007f7d05, 0x007f7e22,
  0x0000bb86, 0x0000bd04, 0x00be7b8b, 0x00be7d26,
  0x0000f90c, 0x0000fb07, 0x00fcfa14, 0x00fcfc2c,
  0x00003e82, 0x00003f02, 0x003f7e85, 0x003f7f22,
  0x00007c86, 0x00007d84, 0x007e7d0b, 0x007e7e26,
  0x0000ba0c, 0x0000bb87, 0x00bcfb94, 0x00bcfd2c,
  0x0000c9cc, 0x0000cb67, 0x00ccfb34, 0x00ccfcec,
  0x00003e04, 0x00003e83, 0x003efe88, 0x003eff24,
  0x00007b8a, 0x00007c86, 0x007d7d11, 0x007d7e2a,
  0x00008b4a, 0x00008c66, 0x008d7cb1, 0x008d7dea,
  0x00008cc4, 0x00008de3, 0x008efca8, 0x008efde4,
  0x00003d86, 0x00003e04, 0x003e7e8b, 0x003e7f26,
  0x00004d46, 0x00004de4, 0x004e7e2b, 0x004e7ee6,
  0x00004ec0, 0x00004f61, 0x004ffe22, 0x004ffee0,
  0x00004fbc, 0x0000505f, 0x0050fe1c, 0x0050fedc,
  0x00000fc0, 0x00000fe1, 0x000fffa2, 0x000fffe0,
  0x0000113a, 0x0000115e, 0x00117f99, 0x00117fda,
  0x00001236, 0x0000125c, 0x00127f93, 0x00127fd6,
  0x000012b4, 0x000012db, 0x0012ff90, 0x0012ffd4,
  0x0000017d, 0x00017ff8, 0x00017ffc, 0x0001801d,
  0x0000027b, 0x00027ff2, 0x00027ff8, 0x0002801b,
  0x000002fa, 0x0002ffef, 0x0002fff6, 0x0003001a,
  0x000002fa, 0x0002ffef, 0x0002fff6, 0x0003001a,
  0x000000fe, 0x0000fffb, 0x0000fffe, 0x0001001e,
  0x0000017d, 0x00017ff8, 0x00017ffc, 0x0001801d,
  0x0000017d, 0x00017ff8, 0x00017ffc, 0x0001801d,
  0x000000fe, 0x0000fffb, 0x0000fffe, 0x0001001e,
  0x0000007f, 0x00007ffe, 0x00008000, 0x0000801f,
  0x0000007f, 0x00007ffe, 0x00008000, 0x0000801f,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff02, 0xffff0007, 0xffff0006, 0xffff0022,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff81, 0xffff8004, 0xffff8004, 0xffff8021,
  0xfffffe83, 0xfffe800a, 0xfffe8008, 0xfffe8023,
  0xffffeea3, 0xffee806a, 0xffee8048, 0xffee8043,
  0xffffff81, 0xffff8004, 0xffff8004, 0xffff8021,
  0xfffffe83, 0xfffe800a, 0xfffe8008, 0xfffe8023,
  0xffffeea3, 0xffee806a, 0xffee8048, 0xffee8043,
  0xffffb0a0, 0xffb001e1, 0xffb00142, 0xffb000c0,
  0xffffff02, 0xffff0007, 0xffff0006, 0xffff0022,
  0xffffef22, 0xffef0067, 0xffef0046, 0xffef0042,
  0xffffb11f, 0xffb081de, 0xffb08140, 0xffb080bf,
  0xffff729d, 0xff718358, 0xff71823c, 0xff71813d,
  0xfffff020, 0xfff00061, 0xfff00042, 0xfff00040,
  0xffffb21d, 0xffb181d8, 0xffb1813c, 0xffb180bd,
  0xffff739b, 0xff728352, 0xff728238, 0xff72813b,
  0xffff349a, 0xff3304cf, 0xff330336, 0xff3301ba,
  0xffffc1fd, 0xffc18178, 0xffc180fc, 0xffc1809d,
  0xffff837b, 0xff8282f2, 0xff8281f8, 0xff82811b,
  0xffff447a, 0xff43046f, 0xff4302f6, 0xff43019a,
  0xffbfc5f7, 0xbf460466, 0xbf4582f0, 0xbf450197,
  0xffffc17e, 0xffc1017b, 0xffc100fe, 0xffc1009e,
  0xffff827d, 0xff8182f8, 0xff8181fc, 0xff81811d,
  0xffc003fa, 0xbf8482ef, 0xbf8401f6, 0xbf83811a,
  0xff8084f8, 0x7f8702e9, 0x7f8601f2, 0x7f850118,
  0xffffc0ff, 0xffc0817e, 0xffc08100, 0xffc0809f,
  0xffc0427c, 0xbfc38175, 0xbfc300fa, 0xbfc2809c,
  0xff80c37a, 0x7fc6016f, 0x7fc500f6, 0x7fc4009a,
  0xff4143f9, 0x3fc8016c, 0x3fc680f4, 0x3fc50099,
  0xffc0817d, 0xc002fff8, 0xc0027ffc, 0xc002001d,
  0xff81027b, 0x80057ff2, 0x80047ff8, 0x8003801b,
  0xff4182fa, 0x40077fef, 0x4005fff6, 0x4004801a,
  0x98db1cad, 0x40079988, 0x0cd2e65c, 0xd99e334d,
  0xffc080fe, 0xc0027ffb, 0xc001fffe, 0xc001801e,
  0xff81017d, 0x80047ff8, 0x80037ffc, 0x8002801d,
  0x991a9b30, 0x80049991, 0x4cd06662, 0x199c3350,
  0x43c54605, 0xd55a1990, 0x4cd0910c, 0xc44708a5,
  0xffc0807f, 0xc001fffe, 0xc0018000, 0xc001001f,
  0x995a1a32, 0xc0021997, 0x8cce6666, 0x599ab352,
  0x4404c507, 0x15579996, 0x8cce9110, 0x044588a7,
  0xc404c684, 0x9559198d, 0x8cd0110a, 0x844708a4,
  0x999999b3, 0x0000199a, 0xcccce668, 0x9999b353,
  0x44444488, 0x55559999, 0xcccd1112, 0x444488a8,
  0xc4444605, 0xd5571990, 0xccce910c, 0xc44608a5,
  0x44444703, 0x5558198a, 0xcccf9108, 0x444708a3,
  0xaaaaaad5, 0x55558000, 0x00002aac, 0xaaaad575,
  0x2aaaac52, 0xd556fff7, 0x0001aaa6, 0x2aac5572,
  0xaaaaad50, 0x5557fff1, 0x0002aaa2, 0xaaad5570,
  0x2aaaadcf, 0xd5587fee, 0x00032aa0, 0x2aadd56f,
  0x8000017d, 0x80017ff8, 0x00017ffc, 0x8001801d,
  0x0000027b, 0x00027ff2, 0x00027ff8, 0x0002801b,
  0x800002fa, 0x8002ffef, 0x0002fff6, 0x8003001a,
  0x000002fa, 0x0002ffef, 0x0002fff6, 0x0003001a,
  0x800000fe, 0x8000fffb, 0x0000fffe, 0x8001001e,
  0x0000017d, 0x00017ff8, 0x00017ffc, 0x0001801d,
  0x8000017d, 0x80017ff8, 0x00017ffc, 0x8001801d,
  0x000000fe, 0x0000fffb, 0x0000fffe, 0x0001001e,
  0x8000007f, 0x80007ffe, 0x00008000, 0x8000801f,
  0x0000007f, 0x00007ffe, 0x00008000, 0x0000801f,
  0x80000000, 0x80000001, 0x00000002, 0x80000020,
  0xd55555aa, 0x2aaaffff, 0x00005556, 0xd555aaca,
  0x80000000, 0x80000001, 0x00000002, 0x80000020,
  0xffffff81, 0xffff8004, 0xffff8004, 0xffff8021,
  0x5555552b, 0xaaaa8002, 0xffffd558, 0x55552acb,
  0xbbbbbbf7, 0xaaaae666, 0x33336ef0, 0xbbbbf797,
  0x7fffff81, 0x7fff8004, 0xffff8004, 0x7fff8021,
  0xd555552b, 0x2aaa8002, 0xffffd558, 0xd5552acb,
  0x3bbbbbf7, 0x2aaae666, 0x33336ef0, 0x3bbbf797,
  0x3bfb3bf7, 0x6aa96666, 0x73326ef0, 0x7bbb7797,
  0x555555aa, 0xaaaaffff, 0x00005556, 0x5555aaca,
  0xbbbbbc76, 0xaaab6663, 0x3333eeee, 0xbbbc7796,
  0xbbfb3c76, 0xeaa9e663, 0x7332eeee, 0xfbbbf796,
  0xbc3abbf7, 0x2aa7e666, 0xb3316ef0, 0x3bbaf797,
  0x666666cc, 0x00006665, 0x3333999a, 0x6666ccec,
  0x66a5e6cc, 0x3ffee665, 0x7332999a, 0xa6664cec,
  0x66e5664d, 0x7ffce668, 0xb331199c, 0xe6654ced,
  0x6724e54f, 0xbffa666e, 0xf32f19a0, 0x2663ccef,
  0x003f8000, 0x3ffe8001, 0x3fff0002, 0x3fff8020,
  0x007eff81, 0x7ffc8004, 0x7ffd8004, 0x7ffe8021,
  0x00be7e83, 0xbffa000a, 0xbffb8008, 0xbffd0023,
  0x00fdfd06, 0xfff70013, 0xfff9000e, 0xfffb0026,
  0x003f7f81, 0x3ffe0004, 0x3ffe8004, 0x3fff0021,
  0x007efe83, 0x7ffb800a, 0x7ffc8008, 0x7ffd8023,
  0x00be7d06, 0xbff88013, 0xbffa000e, 0xbffb8026,
  0x00bebc86, 0xc0387e93, 0xc039ff0e, 0xc03b7fa6,
  0x003f7f02, 0x3ffd8007, 0x3ffe0006, 0x3ffe8022,
  0x007efd85, 0x7ffa8010, 0x7ffb800c, 0x7ffc8025,
  0x007f3d05, 0x803a7e90, 0x803b7f0c, 0x803c7fa5,
  0x007f7c06, 0x8079fd13, 0x807afe0e, 0x807bff26,
  0x003f7e83, 0x3ffd000a, 0x3ffd8008, 0x3ffe0023,
  0x003fbe03, 0x403cfe8a, 0x403d7f08, 0x403dffa3,
  0x003ffd04, 0x407c7d0d, 0x407cfe0a, 0x407d7f24,
  0x00403b86, 0x40bb7b93, 0x40bbfd0e, 0x40bc7ea6,
  0x00003f80, 0x003ffe81, 0x003fff02, 0x003fffa0,
  0x00007e81, 0x007f7d04, 0x007f7e04, 0x007f7f21,
  0x0000bd03, 0x00be7b8a, 0x00be7d08, 0x00be7ea3,
  0x0000fb06, 0x00fcfa13, 0x00fcfc0e, 0x00fcfe26,
  0x00003f01, 0x003f7e84, 0x003f7f04, 0x003f7fa1,
  0x00007d83, 0x007e7d0a, 0x007e7e08, 0x007e7f23,
  0x0000bb86, 0x00bcfb93, 0x00bcfd0e, 0x00bcfea6,
  0x0000cb66, 0x00ccfb33, 0x00ccfcce, 0x00ccfe86,
  0x00003e82, 0x003efe87, 0x003eff06, 0x003effa2,
  0x00007c85, 0x007d7d10, 0x007d7e0c, 0x007d7f25,
  0x00008c65, 0x008d7cb0, 0x008d7dcc, 0x008d7f05,
  0x00008de2, 0x008efca7, 0x008efdc6, 0x008eff02,
  0x00003e03, 0x003e7e8a, 0x003e7f08, 0x003e7fa3,
  0x00004de3, 0x004e7e2a, 0x004e7ec8, 0x004e7f83,
  0x00004f60, 0x004ffe21, 0x004ffec2, 0x004fff80,
  0x0000505e, 0x0050fe1b, 0x0050febe, 0x0050ff7e,
  0x00000fe0, 0x000fffa1, 0x000fffc2, 0x00100000,
  0x0000115d, 0x00117f98, 0x00117fbc, 0x00117ffd,
  0x0000125b, 0x00127f92, 0x00127fb8, 0x00127ffb,
  0x000012da, 0x0012ff8f, 0x0012ffb6, 0x0012fffa,
  0x00017ff7, 0x00017ffb, 0x00017fff, 0x999999b9,
  0x00027ff1, 0x00027ff7, 0x00027ffd, 0x0000001f,
  0x0002ffee, 0x0002fff5, 0x0002fffc, 0x33333352,
  0x0002ffee, 0x0002fff5, 0x0002fffc, 0x33333352,
  0x0000fffa, 0x0000fffd, 0x00010000, 0x66666686,
  0x00017ff7, 0x00017ffb, 0x00017fff, 0x999999b9,
  0x00017ff7, 0x00017ffb, 0x00017fff, 0x999999b9,
  0x0000fffa, 0x0000fffd, 0x00010000, 0x66666686,
  0x00007ffd, 0x00007fff, 0x00008001, 0x33333353,
  0x00007ffd, 0x00007fff, 0x00008001, 0x33333353,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff0006, 0xffff0005, 0xffff0004, 0x999999ba,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff8003, 0xffff8003, 0xffff8003, 0xcccccced,
  0xfffe8009, 0xfffe8007, 0xfffe8005, 0x66666687,
  0xffee8069, 0xffee8047, 0xffee8025, 0x00000027,
  0xffff8003, 0xffff8003, 0xffff8003, 0xcccccced,
  0xfffe8009, 0xfffe8007, 0xfffe8005, 0x66666687,
  0xffee8069, 0xffee8047, 0xffee8025, 0x00000027,
  0xffb001e0, 0xffb00141, 0xffb000a2, 0x00000040,
  0xffff0006, 0xffff0005, 0xffff0004, 0x999999ba,
  0xffef0066, 0xffef0045, 0xffef0024, 0x3333335a,
  0xffb081dd, 0xffb0813f, 0xffb080a1, 0x33333373,
  0xff718357, 0xff71823b, 0xff71811f, 0x00000059,
  0xfff00060, 0xfff00041, 0xfff00022, 0x999999c0,
  0xffb181d7, 0xffb1813b, 0xffb1809f, 0x999999d9,
  0xff728351, 0xff728237, 0xff72811d, 0x666666bf,
  0xff3304ce, 0xff330335, 0xff33019c, 0x00000072,
  0xffc18177, 0xffc180fb, 0xffc1807f, 0x00000039,
  0xff8282f1, 0xff8281f7, 0xff8280fd, 0xcccccd1f,
  0xff43046e, 0xff4302f5, 0xff43017c, 0x666666d2,
  0xbf460465, 0xbf4582ef, 0xbf450179, 0x6666806b,
  0xffc1017a, 0xffc100fd, 0xffc10080, 0xcccccd06,
  0xff8182f7, 0xff8181fb, 0xff8180ff, 0x666666b9,
  0xbf8482ee, 0xbf8401f5, 0xbf8380fc, 0x66668052,
  0x7f8702e8, 0x7f8601f1, 0x7f8500fa, 0x333366b8,
  0xffc0817d, 0xffc080ff, 0xffc08081, 0x999999d3,
  0xbfc38174, 0xbfc300f9, 0xbfc2807e, 0x9999b36c,
  0x7fc6016e, 0x7fc500f5, 0x7fc4007c, 0x666699d2,
  0x3fc8016b, 0x3fc680f3, 0x3fc5007b, 0x00004d05,
  0xc002fff7, 0xc0027ffb, 0xc001ffff, 0x000019b9,
  0x80057ff1, 0x80047ff7, 0x80037ffd, 0xcccd001f,
  0x40077fee, 0x4005fff5, 0x40047ffc, 0x6666b352,
  0x40079987, 0x0cd2e65b, 0xd99e332f, 0xa3d75729,
  0xc0027ffa, 0xc001fffd, 0xc0018000, 0xcccce686,
  0x80047ff7, 0x80037ffb, 0x80027fff, 0x666699b9,
  0x80049990, 0x4cd06661, 0x199c3332, 0xa3d73d90,
  0xd55a198f, 0x4cd0910b, 0xc4470887, 0xb4e84ea1,
  0xc001fffd, 0xc0017fff, 0xc0010001, 0x9999b353,
  0xc0021996, 0x8cce6665, 0x599ab334, 0xd70a572a,
  0x15579995, 0x8cce910f, 0x04458889, 0xe81b683b,
  0x9559198c, 0x8cd01109, 0x84470886, 0x01b501d4,
  0x00001999, 0xcccce667, 0x9999b335, 0x3d70a3f7,
  0x55559998, 0xcccd1111, 0x4444888a, 0x4e81b508,
  0xd557198f, 0xccce910b, 0xc4460887, 0x681b4ea1,
  0x55581989, 0xcccf9107, 0x44470885, 0x4e81b507,
  0x55557fff, 0x00002aab, 0xaaaad557, 0x11111131,
  0xd556fff6, 0x0001aaa5, 0x2aac5554, 0x2aaaaaca,
  0x5557fff0, 0x0002aaa1, 0xaaad5552, 0x11111130,
  0xd5587fed, 0x00032a9f, 0x2aadd551, 0xc4444463,
  0x80017ff7, 0x00017ffb, 0x80017fff, 0x199999b9,
  0x00027ff1, 0x00027ff7, 0x00027ffd, 0x0000001f,
  0x8002ffee, 0x0002fff5, 0x8002fffc, 0xb3333352,
  0x0002ffee, 0x0002fff5, 0x0002fffc, 0x33333352,
  0x8000fffa, 0x0000fffd, 0x80010000, 0xe6666686,
  0x00017ff7, 0x00017ffb, 0x00017fff, 0x999999b9,
  0x80017ff7, 0x00017ffb, 0x80017fff, 0x199999b9,
  0x0000fffa, 0x0000fffd, 0x00010000, 0x66666686,
  0x80007ffd, 0x00007fff, 0x80008001, 0xb3333353,
  0x00007ffd, 0x00007fff, 0x00008001, 0x33333353,
  0x80000000, 0x00000001, 0x80000002, 0x80000020,
  0x2aaafffe, 0x00005555, 0xd555aaac, 0xa2222242,
  0x80000000, 0x00000001, 0x80000002, 0x80000020,
  0xffff8003, 0xffff8003, 0xffff8003, 0xcccccced,
  0xaaaa8001, 0xffffd557, 0x55552aad, 0xeeeeef0f,
  0xaaaae665, 0x33336eef, 0xbbbbf779, 0xe4b17e6b,
  0x7fff8003, 0xffff8003, 0x7fff8003, 0x4ccccced,
  0x2aaa8001, 0xffffd557, 0xd5552aad, 0x6eeeef0f,
  0x2aaae665, 0x33336eef, 0x3bbbf779, 0x64b17e6b,
  0x6aa96665, 0x73326eef, 0x7bbb7779, 0xfe4afe6b,
  0xaaaafffe, 0x00005555, 0x5555aaac, 0x22222242,
  0xaaab6662, 0x3333eeed, 0xbbbc7778, 0x17e4b19e,
  0xeaa9e662, 0x7332eeed, 0xfbbbf778, 0xb17e319e,
  0x2aa7e665, 0xb3316eef, 0x3bbaf779, 0x17e47e6b,
  0x00006664, 0x33339999, 0x6666ccce, 0xf5c28f7c,
  0x3ffee664, 0x73329999, 0xa6664cce, 0x8f5c0f7c,
  0x7ffce667, 0xb331199b, 0xe6654ccf, 0xf5c25c49,
  0xbffa666d, 0xf32f199f, 0x2663ccd1, 0x28f575e3,
  0x3ffe8000, 0x3fff0001, 0x3fff8002, 0x99998020,
  0x7ffc8003, 0x7ffd8003, 0x7ffe8003, 0xffffcced,
  0xbffa0009, 0xbffb8007, 0xbffd0005, 0x3332e687,
  0xfff70012, 0xfff9000d, 0xfffb0008, 0x3332ccee,
  0x3ffe0003, 0x3ffe8003, 0x3fff0003, 0x66664ced,
  0x7ffb8009, 0x7ffc8007, 0x7ffd8005, 0x99996687,
  0xbff88012, 0xbffa000d, 0xbffb8008, 0x99994cee,
  0xc0387e92, 0xc039ff0d, 0xc03b7f88, 0x3332e66e,
  0x3ffd8006, 0x3ffe0005, 0x3ffe8004, 0x333319ba,
  0x7ffa800f, 0x7ffb800b, 0x7ffc8007, 0x33330021,
  0x803a7e8f, 0x803b7f0b, 0x803c7f87, 0xcccc99a1,
  0x8079fd12, 0x807afe0d, 0x807bff08, 0x3332ffee,
  0x3ffd0009, 0x3ffd8007, 0x3ffe0005, 0xffffe687,
  0x403cfe89, 0x403d7f07, 0x403dff85, 0x99998007,
  0x407c7d0c, 0x407cfe09, 0x407d7f06, 0xffffe654,
  0x40bb7b92, 0x40bbfd0d, 0x40bc7e88, 0x3333196e,
  0x003ffe80, 0x003fff01, 0x003fff82, 0x999999a0,
  0x007f7d03, 0x007f7e03, 0x007f7f03, 0xffffffed,
  0x00be7b89, 0x00be7d07, 0x00be7e85, 0x33333307,
  0x00fcfa12, 0x00fcfc0d, 0x00fcfe08, 0x333332ee,
  0x003f7e83, 0x003f7f03, 0x003f7f83, 0x6666666d,
  0x007e7d09, 0x007e7e07, 0x007e7f05, 0x99999987,
  0x00bcfb92, 0x00bcfd0d, 0x00bcfe88, 0x9999996e,
  0x00ccfb32, 0x00ccfccd, 0x00ccfe68, 0xffffffce,
  0x003efe86, 0x003eff05, 0x003eff84, 0x3333333a,
  0x007d7d0f, 0x007d7e0b, 0x007d7f07, 0x33333321,
  0x008d7caf, 0x008d7dcb, 0x008d7ee7, 0x99999981,
  0x008efca6, 0x008efdc5, 0x008efee4, 0x3333331a,
  0x003e7e89, 0x003e7f07, 0x003e7f85, 0x00000007,
  0x004e7e29, 0x004e7ec7, 0x004e7f65, 0x66666667,
  0x004ffe20, 0x004ffec1, 0x004fff62, 0x00000000,
  0x0050fe1a, 0x0050febd, 0x0050ff60, 0x66666666,
  0x000fffa0, 0x000fffc1, 0x000fffe2, 0x66666680,
  0x00117f97, 0x00117fbb, 0x00117fdf, 0x00000019,
  0x00127f91, 0x00127fb7, 0x00127fdd, 0x6666667f,
  0x0012ff8e, 0x0012ffb5, 0x0012ffdc, 0x999999b2,
  0x00017ffa, 0x00017ffe, 0x9999999b, 0x0000001f,
  0x00027ff6, 0x00027ffc, 0x00000001, 0xaaaaaac9,
  0x0002fff4, 0x0002fffb, 0x33333334, 0x0000001e,
  0x0002fff4, 0x0002fffb, 0x33333334, 0x0000001e,
  0x0000fffc, 0x0000ffff, 0x66666668, 0xaaaaaaca,
  0x00017ffa, 0x00017ffe, 0x9999999b, 0x0000001f,
  0x00017ffa, 0x00017ffe, 0x9999999b, 0x0000001f,
  0x0000fffc, 0x0000ffff, 0x66666668, 0xaaaaaaca,
  0x00007ffe, 0x00008000, 0x33333335, 0x55555575,
  0x00007ffe, 0x00008000, 0x33333335, 0x55555575,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff0004, 0xffff0003, 0x9999999c, 0x55555576,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff8002, 0xffff8002, 0xcccccccf, 0xaaaaaacb,
  0xfffe8006, 0xfffe8004, 0x66666669, 0x00000021,
  0xffee8046, 0xffee8024, 0x00000009, 0x55555581,
  0xffff8002, 0xffff8002, 0xcccccccf, 0xaaaaaacb,
  0xfffe8006, 0xfffe8004, 0x66666669, 0x00000021,
  0xffee8046, 0xffee8024, 0x00000009, 0x55555581,
  0xffb00140, 0xffb000a1, 0x00000022, 0xaaaaab00,
  0xffff0004, 0xffff0003, 0x9999999c, 0x55555576,
  0xffef0044, 0xffef0023, 0x3333333c, 0xaaaaaad6,
  0xffb0813e, 0xffb080a0, 0x33333355, 0x00000055,
  0xff71823a, 0xff71811e, 0x0000003b, 0x0000007f,
  0xfff00040, 0xfff00021, 0x999999a2, 0x55555580,
  0xffb1813a, 0xffb1809e, 0x999999bb, 0xaaaaaaff,
  0xff728236, 0xff72811c, 0x666666a1, 0xaaaaab29,
  0xff330334, 0xff33019b, 0x00000054, 0x555555fe,
  0xffc180fa, 0xffc1807e, 0x0000001b, 0x5555559f,
  0xff8281f6, 0xff8280fc, 0xcccccd01, 0x555555c9,
  0xff4302f4, 0xff43017b, 0x666666b4, 0x0000009e,
  0xbf4582ee, 0xbf450178, 0x6666804d, 0x5555809d,
  0xffc100fc, 0xffc1007f, 0xcccccce8, 0x0000004a,
  0xff8181fa, 0xff8180fe, 0x6666669b, 0xaaaaab1f,
  0xbf8401f4, 0xbf8380fb, 0x66668034, 0x00002b1e,
  0x7f8601f0, 0x7f8500f9, 0x3333669a, 0x000055c8,
  0xffc080fe, 0xffc08080, 0x999999b5, 0xaaaaaaf5,
  0xbfc300f8, 0xbfc2807d, 0x9999b34e, 0x00002af4,
  0x7fc500f4, 0x7fc4007b, 0x666699b4, 0x0000559e,
  0x3fc680f2, 0x3fc5007a, 0x00004ce7, 0xaaab2af3,
  0xc0027ffa, 0xc001fffe, 0x0000199b, 0x5555801f,
  0x80047ff6, 0x80037ffc, 0xcccd0001, 0x5555aac9,
  0x4005fff4, 0x40047ffb, 0x6666b334, 0x0000801e,
  0x0cd2e65a, 0xd99e332e, 0xa3d7570b, 0x1111912f,
  0xc001fffc, 0xc0017fff, 0xcccce668, 0x00002aca,
  0x80037ffa, 0x80027ffe, 0x6666999b, 0xaaab001f,
  0x4cd06660, 0x199c3331, 0xa3d73d72, 0xbbbc1130,
  0x4cd0910a, 0xc4470886, 0xb4e84e83, 0x82d882f7,
  0xc0017ffe, 0xc0010000, 0x9999b335, 0xaaaad575,
  0x8cce6664, 0x599ab333, 0xd70a570c, 0xbbbbe686,
  0x8cce910e, 0x04458888, 0xe81b681d, 0x82d8584d,
  0x8cd01108, 0x84470885, 0x01b501b6, 0x02d8584c,
  0xcccce666, 0x9999b334, 0x3d70a3d9, 0x11111131,
  0xcccd1110, 0x44448889, 0x4e81b4ea, 0xd82d82f8,
  0xccce910a, 0xc4460886, 0x681b4e83, 0x582d82f7,
  0xcccf9106, 0x44470884, 0x4e81b4e9, 0x82d82da1,
  0x00002aaa, 0xaaaad556, 0x11111113, 0xc71c71e7,
  0x0001aaa4, 0x2aac5553, 0x2aaaaaac, 0x471c71e6,
  0x0002aaa0, 0xaaad5551, 0x11111112, 0x71c71c90,
  0x00032a9e, 0x2aadd550, 0xc4444445, 0x471c71e5,
  0x00017ffa, 0x80017ffe, 0x1999999b, 0x8000001f,
  0x00027ff6, 0x00027ffc, 0x00000001, 0xaaaaaac9,
  0x0002fff4, 0x8002fffb, 0xb3333334, 0x8000001e,
  0x0002fff4, 0x0002fffb, 0x33333334, 0x0000001e,
  0x0000fffc, 0x8000ffff, 0xe6666668, 0x2aaaaaca,
  0x00017ffa, 0x00017ffe, 0x9999999b, 0x0000001f,
  0x00017ffa, 0x80017ffe, 0x1999999b, 0x8000001f,
  0x0000fffc, 0x0000ffff, 0x66666668, 0xaaaaaaca,
  0x00007ffe, 0x80008000, 0xb3333335, 0xd5555575,
  0x00007ffe, 0x00008000, 0x33333335, 0x55555575,
  0x00000000, 0x80000001, 0x80000002, 0x80000020,
  0x00005554, 0xd555aaab, 0xa2222224, 0x0e38e3ae,
  0x00000000, 0x80000001, 0x80000002, 0x80000020,
  0xffff8002, 0xffff8002, 0xcccccccf, 0xaaaaaacb,
  0xffffd556, 0x55552aac, 0xeeeeeef1, 0x38e38e59,
  0x33336eee, 0xbbbbf778, 0xe4b17e4d, 0x7d27d29d,
  0xffff8002, 0x7fff8002, 0x4ccccccf, 0x2aaaaacb,
  0xffffd556, 0xd5552aac, 0x6eeeeef1, 0xb8e38e59,
  0x33336eee, 0x3bbbf778, 0x64b17e4d, 0xfd27d29d,
  0x73326eee, 0x7bbb7778, 0xfe4afe4d, 0xa7d2529d,
  0x00005554, 0x5555aaab, 0x22222224, 0x8e38e3ae,
  0x3333eeec, 0xbbbc7777, 0x17e4b180, 0xd27d27f2,
  0x7332eeec, 0xfbbbf777, 0xb17e3180, 0x7d27a7f2,
  0xb3316eee, 0x3bbaf778, 0x17e47e4d, 0xd27cd29d,
  0x33339998, 0x6666cccd, 0xf5c28f5e, 0x44444464,
  0x73329998, 0xa6664ccd, 0x8f5c0f5e, 0xeeeec464,
  0xb331199a, 0xe6654cce, 0xf5c25c2b, 0x4443ef0f,
  0xf32f199e, 0x2663ccd0, 0x28f575c5, 0x4443c465,
  0x3fff0000, 0x3fff8001, 0x99998002, 0xaaaa8020,
  0x7ffd8002, 0x7ffe8002, 0xffffcccf, 0xffffaacb,
  0xbffb8006, 0xbffd0004, 0x3332e669, 0xffff8021,
  0xfff9000c, 0xfffb0007, 0x3332ccd0, 0xaaaa0022,
  0x3ffe8002, 0x3fff0002, 0x66664ccf, 0x55552acb,
  0x7ffc8006, 0x7ffd8004, 0x99996669, 0x55550021,
  0xbffa000c, 0xbffb8007, 0x99994cd0, 0xffff8022,
  0xc039ff0c, 0xc03b7f87, 0x3332e650, 0xaaaa2aa2,
  0x3ffe0004, 0x3ffe8003, 0x3333199c, 0xffffd576,
  0x7ffb800a, 0x7ffc8006, 0x33330003, 0xaaaa5577,
  0x803b7f0a, 0x803c7f86, 0xcccc9983, 0x5554fff7,
  0x807afe0c, 0x807bff07, 0x3332ffd0, 0xaaaa5522,
  0x3ffd8006, 0x3ffe0004, 0xffffe669, 0xaaaa8021,
  0x403d7f06, 0x403dff84, 0x99997fe9, 0x55552aa1,
  0x407cfe08, 0x407d7f05, 0xffffe636, 0xaaaa7fcc,
  0x40bbfd0c, 0x40bc7e87, 0x33331950, 0xaaaa7fa2,
  0x003fff00, 0x003fff81, 0x99999982, 0xaaaaaaa0,
  0x007f7e02, 0x007f7f02, 0xffffffcf, 0xffffffcb,
  0x00be7d06, 0x00be7e84, 0x333332e9, 0xffffffa1,
  0x00fcfc0c, 0x00fcfe07, 0x333332d0, 0xaaaaaa22,
  0x003f7f02, 0x003f7f82, 0x6666664f, 0x5555554b,
  0x007e7e06, 0x007e7f04, 0x99999969, 0x55555521,
  0x00bcfd0c, 0x00bcfe87, 0x99999950, 0xffffffa2,
  0x00ccfccc, 0x00ccfe67, 0xffffffb0, 0xaaaaaa42,
  0x003eff04, 0x003eff83, 0x3333331c, 0xfffffff6,
  0x007d7e0a, 0x007d7f06, 0x33333303, 0xaaaaaa77,
  0x008d7dca, 0x008d7ee6, 0x99999963, 0x55555517,
  0x008efdc4, 0x008efee3, 0x333332fc, 0x55555516,
  0x003e7f06, 0x003e7f84, 0xffffffe9, 0xaaaaaaa1,
  0x004e7ec6, 0x004e7f64, 0x66666649, 0x55555541,
  0x004ffec0, 0x004fff61, 0xffffffe2, 0x55555540,
  0x0050febc, 0x0050ff5f, 0x66666648, 0xffffffea,
  0x000fffc0, 0x000fffe1, 0x66666662, 0xaaaaaac0,
  0x00117fba, 0x00117fde, 0xfffffffb, 0xaaaaaabf,
  0x00127fb6, 0x00127fdc, 0x66666661, 0x55555569,
  0x0012ffb4, 0x0012ffdb, 0x99999994, 0xaaaaaabe,
  0x00017ffd, 0x9999999a, 0x00000001, 0x80000017,
  0x00027ffb, 0x00000000, 0xaaaaaaab, 0x80000011,
  0x0002fffa, 0x33333333, 0x00000000, 0x0000000e,
  0x0002fffa, 0x33333333, 0x00000000, 0x0000000e,
  0x0000fffe, 0x66666667, 0xaaaaaaac, 0x0000001a,
  0x00017ffd, 0x9999999a, 0x00000001, 0x80000017,
  0x00017ffd, 0x9999999a, 0x00000001, 0x80000017,
  0x0000fffe, 0x66666667, 0xaaaaaaac, 0x0000001a,
  0x00007fff, 0x33333334, 0x55555557, 0x8000001d,
  0x00007fff, 0x33333334, 0x55555557, 0x8000001d,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff0002, 0x9999999b, 0x55555558, 0x00000026,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff8001, 0xccccccce, 0xaaaaaaad, 0x80000023,
  0xfffe8003, 0x66666668, 0x00000003, 0x80000029,
  0xffee8023, 0x00000008, 0x55555563, 0x80000089,
  0xffff8001, 0xccccccce, 0xaaaaaaad, 0x80000023,
  0xfffe8003, 0x66666668, 0x00000003, 0x80000029,
  0xffee8023, 0x00000008, 0x55555563, 0x80000089,
  0xffb000a0, 0x00000021, 0xaaaaaae2, 0x00000200,
  0xffff0002, 0x9999999b, 0x55555558, 0x00000026,
  0xffef0022, 0x3333333b, 0xaaaaaab8, 0x00000086,
  0xffb0809f, 0x33333354, 0x00000037, 0x800001fd,
  0xff71811d, 0x0000003a, 0x00000061, 0x80000377,
  0xfff00020, 0x999999a1, 0x55555562, 0x00000080,
  0xffb1809d, 0x999999ba, 0xaaaaaae1, 0x800001f7,
  0xff72811b, 0x666666a0, 0xaaaaab0b, 0x80000371,
  0xff33019a, 0x00000053, 0x555555e0, 0x000004ee,
  0xffc1807d, 0x0000001a, 0x55555581, 0x80000197,
  0xff8280fb, 0xcccccd00, 0x555555ab, 0x80000311,
  0xff43017a, 0x666666b3, 0x00000080, 0x0000048e,
  0xbf450177, 0x6666804c, 0x5555807f, 0x80018485,
  0xffc1007e, 0xcccccce7, 0x0000002c, 0x0000019a,
  0xff8180fd, 0x6666669a, 0xaaaaab01, 0x80000317,
  0xbf8380fa, 0x66668033, 0x00002b00, 0x0001830e,
  0x7f8500f8, 0x33336699, 0x000055aa, 0x00030308,
  0xffc0807f, 0x999999b4, 0xaaaaaad7, 0x8000019d,
  0xbfc2807c, 0x9999b34d, 0x00002ad6, 0x00018194,
  0x7fc4007a, 0x666699b3, 0x00005580, 0x0003018e,
  0x3fc50079, 0x00004ce6, 0xaaab2ad5, 0x8004818b,
  0xc001fffd, 0x0000199a, 0x55558001, 0x80018017,
  0x80037ffb, 0xcccd0000, 0x5555aaab, 0x80030011,
  0x40047ffa, 0x6666b333, 0x00008000, 0x0004800e,
  0xd99e332d, 0xa3d7570a, 0x11119111, 0x199e19a7,
  0xc0017ffe, 0xcccce667, 0x00002aac, 0x0001801a,
  0x80027ffd, 0x6666999a, 0xaaab0001, 0x80030017,
  0x199c3330, 0xa3d73d71, 0xbbbc1112, 0x999c99b0,
  0xc4470885, 0xb4e84e82, 0x82d882d9, 0x199c99af,
  0xc000ffff, 0x9999b334, 0xaaaad557, 0x8001801d,
  0x599ab332, 0xd70a570b, 0xbbbbe668, 0x999b19b6,
  0x04458887, 0xe81b681c, 0x82d8582f, 0x199b19b5,
  0x84470884, 0x01b501b5, 0x02d8582e, 0x199b19ac,
  0x9999b333, 0x3d70a3d8, 0x11111113, 0x199999b9,
  0x44448888, 0x4e81b4e9, 0xd82d82da, 0x999999b8,
  0xc4460885, 0x681b4e82, 0x582d82d9, 0x999999af,
  0x44470883, 0x4e81b4e8, 0x82d82d83, 0x199999a9,
  0xaaaad555, 0x11111112, 0xc71c71c9, 0x8000001f,
  0x2aac5552, 0x2aaaaaab, 0x471c71c8, 0x80000016,
  0xaaad5550, 0x11111111, 0x71c71c72, 0x00000010,
  0x2aadd54f, 0xc4444444, 0x471c71c7, 0x0000000d,
  0x80017ffd, 0x1999999a, 0x80000001, 0x00000017,
  0x00027ffb, 0x00000000, 0xaaaaaaab, 0x80000011,
  0x8002fffa, 0xb3333333, 0x80000000, 0x8000000e,
  0x0002fffa, 0x33333333, 0x00000000, 0x0000000e,
  0x8000fffe, 0xe6666667, 0x2aaaaaac, 0x8000001a,
  0x00017ffd, 0x9999999a, 0x00000001, 0x80000017,
  0x80017ffd, 0x1999999a, 0x80000001, 0x00000017,
  0x0000fffe, 0x66666667, 0xaaaaaaac, 0x0000001a,
  0x80007fff, 0xb3333334, 0xd5555557, 0x0000001d,
  0x00007fff, 0x33333334, 0x55555557, 0x8000001d,
  0x80000000, 0x80000001, 0x80000002, 0x80000020,
  0xd555aaaa, 0xa2222223, 0x0e38e390, 0x8000001e,
  0x80000000, 0x80000001, 0x80000002, 0x80000020,
  0xffff8001, 0xccccccce, 0xaaaaaaad, 0x80000023,
  0x55552aab, 0xeeeeeef0, 0x38e38e3b, 0x80000021,
  0xbbbbf777, 0xe4b17e4c, 0x7d27d27f, 0xe6666685,
  0x7fff8001, 0x4cccccce, 0x2aaaaaad, 0x00000023,
  0xd5552aab, 0x6eeeeef0, 0xb8e38e3b, 0x00000021,
  0x3bbbf777, 0x64b17e4c, 0xfd27d27f, 0x66666685,
  0x7bbb7777, 0xfe4afe4c, 0xa7d2527f, 0x6664e685,
  0x5555aaaa, 0x22222223, 0x8e38e390, 0x0000001e,
  0xbbbc7776, 0x17e4b17f, 0xd27d27d4, 0x66666682,
  0xfbbbf776, 0xb17e317f, 0x7d27a7d4, 0x6664e682,
  0x3bbaf777, 0x17e47e4c, 0xd27cd27f, 0xe6636685,
  0x6666cccc, 0xf5c28f5d, 0x44444446, 0x66666684,
  0xa6664ccc, 0x8f5c0f5d, 0xeeeec446, 0x6664e684,
  0xe6654ccd, 0xf5c25c2a, 0x4443eef1, 0xe6636687,
  0x2663cccf, 0x28f575c4, 0x4443c447, 0xe661e68d,
  0x3fff8000, 0x99998001, 0xaaaa8002, 0xfffe8020,
  0x7ffe8001, 0xffffccce, 0xffffaaad, 0x7ffd0023,
  0xbffd0003, 0x3332e668, 0xffff8003, 0x7ffb8029,
  0xfffb0006, 0x3332cccf, 0xaaaa0004, 0xfffa0032,
  0x3fff0001, 0x66664cce, 0x55552aad, 0x7ffe8023,
  0x7ffd8003, 0x99996668, 0x55550003, 0x7ffd0029,
  0xbffb8006, 0x99994ccf, 0xffff8004, 0xfffb8032,
  0xc03b7f86, 0x3332e64f, 0xaaaa2a84, 0xfffb7eb2,
  0x3ffe8002, 0x3333199b, 0xffffd558, 0xfffe8026,
  0x7ffc8005, 0x33330002, 0xaaaa5559, 0x7ffd002f,
  0x803c7f85, 0xcccc9982, 0x5554ffd9, 0x7ffcfeaf,
  0x807bff06, 0x3332ffcf, 0xaaaa5504, 0xfffcfd32,
  0x3ffe0003, 0xffffe668, 0xaaaa8003, 0x7ffe8029,
  0x403dff83, 0x99997fe8, 0x55552a83, 0x7ffe7ea9,
  0x407d7f04, 0xffffe635, 0xaaaa7fae, 0xfffe7d2c,
  0x40bc7e86, 0x3333194f, 0xaaaa7f84, 0xfffe7bb2,
  0x003fff80, 0x99999981, 0xaaaaaa82, 0xfffffea0,
  0x007f7f01, 0xffffffce, 0xffffffad, 0x7ffffd23,
  0x00be7e83, 0x333332e8, 0xffffff83, 0x7ffffba9,
  0x00fcfe06, 0x333332cf, 0xaaaaaa04, 0xfffffa32,
  0x003f7f81, 0x6666664e, 0x5555552d, 0x7ffffea3,
  0x007e7f03, 0x99999968, 0x55555503, 0x7ffffd29,
  0x00bcfe86, 0x9999994f, 0xffffff84, 0xfffffbb2,
  0x00ccfe66, 0xffffffaf, 0xaaaaaa24, 0xfffffb52,
  0x003eff82, 0x3333331b, 0xffffffd8, 0xfffffea6,
  0x007d7f05, 0x33333302, 0xaaaaaa59, 0x7ffffd2f,
  0x008d7ee5, 0x99999962, 0x555554f9, 0x7ffffccf,
  0x008efee2, 0x333332fb, 0x555554f8, 0xfffffcc6,
  0x003e7f83, 0xffffffe8, 0xaaaaaa83, 0x7ffffea9,
  0x004e7f63, 0x66666648, 0x55555523, 0x7ffffe49,
  0x004fff60, 0xffffffe1, 0x55555522, 0xfffffe40,
  0x0050ff5e, 0x66666647, 0xffffffcc, 0xfffffe3a,
  0x000fffe0, 0x66666661, 0xaaaaaaa2, 0xffffffc0,
  0x00117fdd, 0xfffffffa, 0xaaaaaaa1, 0x7fffffb7,
  0x00127fdb, 0x66666660, 0x5555554b, 0x7fffffb1,
  0x0012ffda, 0x99999993, 0xaaaaaaa0, 0xffffffae,
  0x99999999, 0x00000000, 0x7ffffff9, 0x8000001a,
  0xffffffff, 0xaaaaaaaa, 0x7ffffff3, 0x80000016,
  0x33333332, 0xffffffff, 0xfffffff0, 0x00000014,
  0x33333332, 0xffffffff, 0xfffffff0, 0x00000014,
  0x66666666, 0xaaaaaaab, 0xfffffffc, 0x0000001c,
  0x99999999, 0x00000000, 0x7ffffff9, 0x8000001a,
  0x99999999, 0x00000000, 0x7ffffff9, 0x8000001a,
  0x66666666, 0xaaaaaaab, 0xfffffffc, 0x0000001c,
  0x33333333, 0x55555556, 0x7fffffff, 0x8000001e,
  0x33333333, 0x55555556, 0x7fffffff, 0x8000001e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x9999999a, 0x55555557, 0x00000008, 0x00000024,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xcccccccd, 0xaaaaaaac, 0x80000005, 0x80000022,
  0x66666667, 0x00000002, 0x8000000b, 0x80000026,
  0x00000007, 0x55555562, 0x8000006b, 0x80000066,
  0xcccccccd, 0xaaaaaaac, 0x80000005, 0x80000022,
  0x66666667, 0x00000002, 0x8000000b, 0x80000026,
  0x00000007, 0x55555562, 0x8000006b, 0x80000066,
  0x00000020, 0xaaaaaae1, 0x000001e2, 0x00000160,
  0x9999999a, 0x55555557, 0x00000008, 0x00000024,
  0x3333333a, 0xaaaaaab7, 0x00000068, 0x00000064,
  0x33333353, 0x00000036, 0x800001df, 0x8000015e,
  0x00000039, 0x00000060, 0x80000359, 0x8000025a,
  0x999999a0, 0x55555561, 0x00000062, 0x00000060,
  0x999999b9, 0xaaaaaae0, 0x800001d9, 0x8000015a,
  0x6666669f, 0xaaaaab0a, 0x80000353, 0x80000256,
  0x00000052, 0x555555df, 0x000004d0, 0x00000354,
  0x00000019, 0x55555580, 0x80000179, 0x8000011a,
  0xccccccff, 0x555555aa, 0x800002f3, 0x80000216,
  0x666666b2, 0x0000007f, 0x00000470, 0x00000314,
  0x6666804b, 0x5555807e, 0x80018467, 0x8001030e,
  0xcccccce6, 0x0000002b, 0x0000017c, 0x0000011c,
  0x66666699, 0xaaaaab00, 0x800002f9, 0x8000021a,
  0x66668032, 0x00002aff, 0x000182f0, 0x00010214,
  0x33336698, 0x000055a9, 0x000302ea, 0x00020210,
  0x999999b3, 0xaaaaaad6, 0x8000017f, 0x8000011e,
  0x9999b34c, 0x00002ad5, 0x00018176, 0x00010118,
  0x666699b2, 0x0000557f, 0x00030170, 0x00020114,
  0x00004ce5, 0xaaab2ad4, 0x8004816d, 0x80030112,
  0x00001999, 0x55558000, 0x80017ff9, 0x8001001a,
  0xccccffff, 0x5555aaaa, 0x8002fff3, 0x80020016,
  0x6666b332, 0x00007fff, 0x00047ff0, 0x00030014,
  0xa3d75709, 0x11119110, 0x199e1989, 0xe669667a,
  0xcccce666, 0x00002aab, 0x00017ffc, 0x0001001c,
  0x66669999, 0xaaab0000, 0x8002fff9, 0x8002001a,
  0xa3d73d70, 0xbbbc1111, 0x999c9992, 0x66686680,
  0xb4e84e81, 0x82d882d8, 0x199c9991, 0x9113112a,
  0x9999b333, 0xaaaad556, 0x80017fff, 0x8001001e,
  0xd70a570a, 0xbbbbe667, 0x999b1998, 0x66676684,
  0xe81b681b, 0x82d8582e, 0x199b1997, 0x9112112e,
  0x01b501b4, 0x02d8582d, 0x199b198e, 0x11121128,
  0x3d70a3d7, 0x11111112, 0x1999999b, 0xe6666686,
  0x4e81b4e8, 0xd82d82d9, 0x9999999a, 0x11111130,
  0x681b4e81, 0x582d82d8, 0x99999991, 0x9111112a,
  0x4e81b4e7, 0x82d82d82, 0x1999998b, 0x91111126,
  0x11111111, 0xc71c71c8, 0x80000001, 0x2aaaaaca,
  0x2aaaaaaa, 0x471c71c7, 0x7ffffff8, 0xaaaaaac4,
  0x11111110, 0x71c71c71, 0xfffffff2, 0xaaaaaac0,
  0xc4444443, 0x471c71c6, 0xffffffef, 0x2aaaaabe,
  0x19999999, 0x80000000, 0xfffffff9, 0x8000001a,
  0xffffffff, 0xaaaaaaaa, 0x7ffffff3, 0x80000016,
  0xb3333332, 0x7fffffff, 0x7ffffff0, 0x00000014,
  0x33333332, 0xffffffff, 0xfffffff0, 0x00000014,
  0xe6666666, 0x2aaaaaab, 0x7ffffffc, 0x0000001c,
  0x99999999, 0x00000000, 0x7ffffff9, 0x8000001a,
  0x19999999, 0x80000000, 0xfffffff9, 0x8000001a,
  0x66666666, 0xaaaaaaab, 0xfffffffc, 0x0000001c,
  0xb3333333, 0xd5555556, 0xffffffff, 0x8000001e,
  0x33333333, 0x55555556, 0x7fffffff, 0x8000001e,
  0x80000000, 0x80000001, 0x80000002, 0x00000020,
  0xa2222222, 0x0e38e38f, 0x80000000, 0x55555574,
  0x80000000, 0x80000001, 0x80000002, 0x00000020,
  0xcccccccd, 0xaaaaaaac, 0x80000005, 0x80000022,
  0xeeeeeeef, 0x38e38e3a, 0x80000003, 0xd5555576,
  0xe4b17e4b, 0x7d27d27e, 0xe6666667, 0x6eeeef0e,
  0x4ccccccd, 0x2aaaaaac, 0x00000005, 0x80000022,
  0x6eeeeeef, 0xb8e38e3a, 0x00000003, 0xd5555576,
  0x64b17e4b, 0xfd27d27e, 0x66666667, 0x6eeeef0e,
  0xfe4afe4b, 0xa7d2527e, 0x6664e667, 0x6eedef0e,
  0x22222222, 0x8e38e38f, 0x00000000, 0x55555574,
  0x17e4b17e, 0xd27d27d3, 0x66666664, 0xeeeeef0c,
  0xb17e317e, 0x7d27a7d3, 0x6664e664, 0xeeedef0c,
  0x17e47e4b, 0xd27cd27e, 0xe6636667, 0x6eecef0e,
  0xf5c28f5c, 0x44444445, 0x66666666, 0x999999b8,
  0x8f5c0f5c, 0xeeeec445, 0x6664e666, 0x999899b8,
  0xf5c25c29, 0x4443eef0, 0xe6636669, 0x199799ba,
  0x28f575c3, 0x4443c446, 0xe661e66f, 0x199699be,
  0x99998000, 0xaaaa8001, 0xfffe8002, 0xffff0020,
  0xffffcccd, 0xffffaaac, 0x7ffd0005, 0x7ffe0022,
  0x3332e667, 0xffff8002, 0x7ffb800b, 0x7ffd0026,
  0x3332ccce, 0xaaaa0003, 0xfffa0014, 0xfffc002c,
  0x66664ccd, 0x55552aac, 0x7ffe8005, 0x7fff0022,
  0x99996667, 0x55550002, 0x7ffd000b, 0x7ffe0026,
  0x99994cce, 0xffff8003, 0xfffb8014, 0xfffd002c,
  0x3332e64e, 0xaaaa2a83, 0xfffb7e94, 0xfffcff2c,
  0x3333199a, 0xffffd557, 0xfffe8008, 0xffff0024,
  0x33330001, 0xaaaa5558, 0x7ffd0011, 0x7ffe002a,
  0xcccc9981, 0x5554ffd8, 0x7ffcfe91, 0x7ffdff2a,
  0x3332ffce, 0xaaaa5503, 0xfffcfd14, 0xfffdfe2c,
  0xffffe667, 0xaaaa8002, 0x7ffe800b, 0x7fff0026,
  0x99997fe7, 0x55552a82, 0x7ffe7e8b, 0x7ffeff26,
  0xffffe634, 0xaaaa7fad, 0xfffe7d0e, 0xfffefe28,
  0x3333194e, 0xaaaa7f83, 0xfffe7b94, 0xfffefd2c,
  0x99999980, 0xaaaaaa81, 0xfffffe82, 0xffffff20,
  0xffffffcd, 0xffffffac, 0x7ffffd05, 0x7ffffe22,
  0x333332e7, 0xffffff82, 0x7ffffb8b, 0x7ffffd26,
  0x333332ce, 0xaaaaaa03, 0xfffffa14, 0xfffffc2c,
  0x6666664d, 0x5555552c, 0x7ffffe85, 0x7fffff22,
  0x99999967, 0x55555502, 0x7ffffd0b, 0x7ffffe26,
  0x9999994e, 0xffffff83, 0xfffffb94, 0xfffffd2c,
  0xffffffae, 0xaaaaaa23, 0xfffffb34, 0xfffffcec,
  0x3333331a, 0xffffffd7, 0xfffffe88, 0xffffff24,
  0x33333301, 0xaaaaaa58, 0x7ffffd11, 0x7ffffe2a,
  0x99999961, 0x555554f8, 0x7ffffcb1, 0x7ffffdea,
  0x333332fa, 0x555554f7, 0xfffffca8, 0xfffffde4,
  0xffffffe7, 0xaaaaaa82, 0x7ffffe8b, 0x7fffff26,
  0x66666647, 0x55555522, 0x7ffffe2b, 0x7ffffee6,
  0xffffffe0, 0x55555521, 0xfffffe22, 0xfffffee0,
  0x66666646, 0xffffffcb, 0xfffffe1c, 0xfffffedc,
  0x66666660, 0xaaaaaaa1, 0xffffffa2, 0xffffffe0,
  0xfffffff9, 0xaaaaaaa0, 0x7fffff99, 0x7fffffda,
  0x6666665f, 0x5555554a, 0x7fffff93, 0x7fffffd6,
  0x99999992, 0xaaaaaa9f, 0xffffff90, 0xffffffd4,
  0xffffffff, 0x7ffffff8, 0x7ffffffc, 0x8000001d,
  0xaaaaaaa9, 0x7ffffff2, 0x7ffffff8, 0x8000001b,
  0xfffffffe, 0xffffffef, 0xfffffff6, 0x0000001a,
  0xfffffffe, 0xffffffef, 0xfffffff6, 0x0000001a,
  0xaaaaaaaa, 0xfffffffb, 0xfffffffe, 0x0000001e,
  0xffffffff, 0x7ffffff8, 0x7ffffffc, 0x8000001d,
  0xffffffff, 0x7ffffff8, 0x7ffffffc, 0x8000001d,
  0xaaaaaaaa, 0xfffffffb, 0xfffffffe, 0x0000001e,
  0x55555555, 0x7ffffffe, 0x80000000, 0x8000001f,
  0x55555555, 0x7ffffffe, 0x80000000, 0x8000001f,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x55555556, 0x00000007, 0x00000006, 0x00000022,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xaaaaaaab, 0x80000004, 0x80000004, 0x80000021,
  0x00000001, 0x8000000a, 0x80000008, 0x80000023,
  0x55555561, 0x8000006a, 0x80000048, 0x80000043,
  0xaaaaaaab, 0x80000004, 0x80000004, 0x80000021,
  0x00000001, 0x8000000a, 0x80000008, 0x80000023,
  0x55555561, 0x8000006a, 0x80000048, 0x80000043,
  0xaaaaaae0, 0x000001e1, 0x00000142, 0x000000c0,
  0x55555556, 0x00000007, 0x00000006, 0x00000022,
  0xaaaaaab6, 0x00000067, 0x00000046, 0x00000042,
  0x00000035, 0x800001de, 0x80000140, 0x800000bf,
  0x0000005f, 0x80000358, 0x8000023c, 0x8000013d,
  0x55555560, 0x00000061, 0x00000042, 0x00000040,
  0xaaaaaadf, 0x800001d8, 0x8000013c, 0x800000bd,
  0xaaaaab09, 0x80000352, 0x80000238, 0x8000013b,
  0x555555de, 0x000004cf, 0x00000336, 0x000001ba,
  0x5555557f, 0x80000178, 0x800000fc, 0x8000009d,
  0x555555a9, 0x800002f2, 0x800001f8, 0x8000011b,
  0x0000007e, 0x0000046f, 0x000002f6, 0x0000019a,
  0x5555807d, 0x80018466, 0x800102f0, 0x80008197,
  0x0000002a, 0x0000017b, 0x000000fe, 0x0000009e,
  0xaaaaaaff, 0x800002f8, 0x800001fc, 0x8000011d,
  0x00002afe, 0x000182ef, 0x000101f6, 0x0000811a,
  0x000055a8, 0x000302e9, 0x000201f2, 0x00010118,
  0xaaaaaad5, 0x8000017e, 0x80000100, 0x8000009f,
  0x00002ad4, 0x00018175, 0x000100fa, 0x0000809c,
  0x0000557e, 0x0003016f, 0x000200f6, 0x0001009a,
  0xaaab2ad3, 0x8004816c, 0x800300f4, 0x80018099,
  0x55557fff, 0x80017ff8, 0x8000fffc, 0x8000801d,
  0x5555aaa9, 0x8002fff2, 0x8001fff8, 0x8001001b,
  0x00007ffe, 0x00047fef, 0x0002fff6, 0x0001801a,
  0x1111910f, 0x199e1988, 0xe669665c, 0xb334b34d,
  0x00002aaa, 0x00017ffb, 0x0000fffe, 0x0000801e,
  0xaaaaffff, 0x8002fff8, 0x8001fffc, 0x8001001d,
  0xbbbc1110, 0x999c9991, 0x66686662, 0x33343350,
  0x82d882d7, 0x199c9990, 0x9113110c, 0x088988a5,
  0xaaaad555, 0x80017ffe, 0x80010000, 0x8000801f,
  0xbbbbe666, 0x999b1997, 0x66676666, 0x3333b352,
  0x82d8582d, 0x199b1996, 0x91121110, 0x088908a7,
  0x02d8582c, 0x199b198d, 0x1112110a, 0x088908a4,
  0x11111111, 0x1999999a, 0xe6666668, 0xb3333353,
  0xd82d82d8, 0x99999999, 0x11111112, 0x888888a8,
  0x582d82d7, 0x99999990, 0x9111110c, 0x888888a5,
  0x82d82d81, 0x1999998a, 0x91111108, 0x088888a3,
  0xc71c71c7, 0x80000000, 0x2aaaaaac, 0xd5555575,
  0x471c71c6, 0x7ffffff7, 0xaaaaaaa6, 0xd5555572,
  0x71c71c70, 0xfffffff1, 0xaaaaaaa2, 0x55555570,
  0x471c71c5, 0xffffffee, 0x2aaaaaa0, 0x5555556f,
  0x7fffffff, 0xfffffff8, 0x7ffffffc, 0x0000001d,
  0xaaaaaaa9, 0x7ffffff2, 0x7ffffff8, 0x8000001b,
  0x7ffffffe, 0x7fffffef, 0xfffffff6, 0x8000001a,
  0xfffffffe, 0xffffffef, 0xfffffff6, 0x0000001a,
  0x2aaaaaaa, 0x7ffffffb, 0xfffffffe, 0x8000001e,
  0xffffffff, 0x7ffffff8, 0x7ffffffc, 0x8000001d,
  0x7fffffff, 0xfffffff8, 0x7ffffffc, 0x0000001d,
  0xaaaaaaaa, 0xfffffffb, 0xfffffffe, 0x0000001e,
  0xd5555555, 0xfffffffe, 0x80000000, 0x0000001f,
  0x55555555, 0x7ffffffe, 0x80000000, 0x8000001f,
  0x80000000, 0x80000001, 0x00000002, 0x80000020,
  0x0e38e38e, 0x7fffffff, 0x55555556, 0x2aaaaaca,
  0x80000000, 0x80000001, 0x00000002, 0x80000020,
  0xaaaaaaab, 0x80000004, 0x80000004, 0x80000021,
  0x38e38e39, 0x80000002, 0xd5555558, 0x2aaaaacb,
  0x7d27d27d, 0xe6666666, 0x6eeeeef0, 0xf7777797,
  0x2aaaaaab, 0x00000004, 0x80000004, 0x00000021,
  0xb8e38e39, 0x00000002, 0xd5555558, 0xaaaaaacb,
  0xfd27d27d, 0x66666666, 0x6eeeeef0, 0x77777797,
  0xa7d2527d, 0x6664e666, 0x6eedeef0, 0x7776f797,
  0x8e38e38e, 0xffffffff, 0x55555556, 0xaaaaaaca,
  0xd27d27d2, 0x66666663, 0xeeeeeeee, 0x77777796,
  0x7d27a7d2, 0x6664e663, 0xeeedeeee, 0x7776f796,
  0xd27cd27d, 0xe6636666, 0x6eeceef0, 0xf7767797,
  0x44444444, 0x66666665, 0x9999999a, 0xccccccec,
  0xeeeec444, 0x6664e665, 0x9998999a, 0xcccc4cec,
  0x4443eeef, 0xe6636668, 0x1997999c, 0x4ccbcced,
  0x4443c445, 0xe661e66e, 0x199699a0, 0x4ccb4cef,
  0xaaaa8000, 0xfffe8001, 0xffff0002, 0xffff8020,
  0xffffaaab, 0x7ffd0004, 0x7ffe0004, 0x7fff0021,
  0xffff8001, 0x7ffb800a, 0x7ffd0008, 0x7ffe8023,
  0xaaaa0002, 0xfffa0013, 0xfffc000e, 0xfffe0026,
  0x55552aab, 0x7ffe8004, 0x7fff0004, 0x7fff8021,
  0x55550001, 0x7ffd000a, 0x7ffe0008, 0x7fff0023,
  0xffff8002, 0xfffb8013, 0xfffd000e, 0xfffe8026,
  0xaaaa2a82, 0xfffb7e93, 0xfffcff0e, 0xfffe7fa6,
  0xffffd556, 0xfffe8007, 0xffff0006, 0xffff8022,
  0xaaaa5557, 0x7ffd0010, 0x7ffe000c, 0x7fff0025,
  0x5554ffd7, 0x7ffcfe90, 0x7ffdff0c, 0x7ffeffa5,
  0xaaaa5502, 0xfffcfd13, 0xfffdfe0e, 0xfffeff26,
  0xaaaa8001, 0x7ffe800a, 0x7fff0008, 0x7fff8023,
  0x55552a81, 0x7ffe7e8a, 0x7ffeff08, 0x7fff7fa3,
  0xaaaa7fac, 0xfffe7d0d, 0xfffefe0a, 0xffff7f24,
  0xaaaa7f82, 0xfffe7b93, 0xfffefd0e, 0xffff7ea6,
  0xaaaaaa80, 0xfffffe81, 0xffffff02, 0xffffffa0,
  0xffffffab, 0x7ffffd04, 0x7ffffe04, 0x7fffff21,
  0xffffff81, 0x7ffffb8a, 0x7ffffd08, 0x7ffffea3,
  0xaaaaaa02, 0xfffffa13, 0xfffffc0e, 0xfffffe26,
  0x5555552b, 0x7ffffe84, 0x7fffff04, 0x7fffffa1,
  0x55555501, 0x7ffffd0a, 0x7ffffe08, 0x7fffff23,
  0xffffff82, 0xfffffb93, 0xfffffd0e, 0xfffffea6,
  0xaaaaaa22, 0xfffffb33, 0xfffffcce, 0xfffffe86,
  0xffffffd6, 0xfffffe87, 0xffffff06, 0xffffffa2,
  0xaaaaaa57, 0x7ffffd10, 0x7ffffe0c, 0x7fffff25,
  0x555554f7, 0x7ffffcb0, 0x7ffffdcc, 0x7fffff05,
  0x555554f6, 0xfffffca7, 0xfffffdc6, 0xffffff02,
  0xaaaaaa81, 0x7ffffe8a, 0x7fffff08, 0x7fffffa3,
  0x55555521, 0x7ffffe2a, 0x7ffffec8, 0x7fffff83,
  0x55555520, 0xfffffe21, 0xfffffec2, 0xffffff80,
  0xffffffca, 0xfffffe1b, 0xfffffebe, 0xffffff7e,
  0xaaaaaaa0, 0xffffffa1, 0xffffffc2, 0x00000000,
  0xaaaaaa9f, 0x7fffff98, 0x7fffffbc, 0x7ffffffd,
  0x55555549, 0x7fffff92, 0x7fffffb8, 0x7ffffffb,
  0xaaaaaa9e, 0xffffff8f, 0xffffffb6, 0xfffffffa,
  0x7ffffff7, 0x7ffffffb, 0x7fffffff, 0x80000020,
  0x7ffffff1, 0x7ffffff7, 0x7ffffffd, 0x80000020,
  0xffffffee, 0xfffffff5, 0xfffffffc, 0x00000020,
  0xffffffee, 0xfffffff5, 0xfffffffc, 0x00000020,
  0xfffffffa, 0xfffffffd, 0x00000000, 0x00000020,
  0x7ffffff7, 0x7ffffffb, 0x7fffffff, 0x80000020,
  0x7ffffff7, 0x7ffffffb, 0x7fffffff, 0x80000020,
  0xfffffffa, 0xfffffffd, 0x00000000, 0x00000020,
  0x7ffffffd, 0x7fffffff, 0x80000001, 0x80000020,
  0x7ffffffd, 0x7fffffff, 0x80000001, 0x80000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000006, 0x00000005, 0x00000004, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x80000003, 0x80000003, 0x80000003, 0x80000020,
  0x80000009, 0x80000007, 0x80000005, 0x80000020,
  0x80000069, 0x80000047, 0x80000025, 0x80000020,
  0x80000003, 0x80000003, 0x80000003, 0x80000020,
  0x80000009, 0x80000007, 0x80000005, 0x80000020,
  0x80000069, 0x80000047, 0x80000025, 0x80000020,
  0x000001e0, 0x00000141, 0x000000a2, 0x00000020,
  0x00000006, 0x00000005, 0x00000004, 0x00000020,
  0x00000066, 0x00000045, 0x00000024, 0x00000020,
  0x800001dd, 0x8000013f, 0x800000a1, 0x80000020,
  0x80000357, 0x8000023b, 0x8000011f, 0x80000020,
  0x00000060, 0x00000041, 0x00000022, 0x00000020,
  0x800001d7, 0x8000013b, 0x8000009f, 0x80000020,
  0x80000351, 0x80000237, 0x8000011d, 0x80000020,
  0x000004ce, 0x00000335, 0x0000019c, 0x00000020,
  0x80000177, 0x800000fb, 0x8000007f, 0x80000020,
  0x800002f1, 0x800001f7, 0x800000fd, 0x80000020,
  0x0000046e, 0x000002f5, 0x0000017c, 0x00000020,
  0x80018465, 0x800102ef, 0x80008179, 0x80000020,
  0x0000017a, 0x000000fd, 0x00000080, 0x00000020,
  0x800002f7, 0x800001fb, 0x800000ff, 0x80000020,
  0x000182ee, 0x000101f5, 0x000080fc, 0x00000020,
  0x000302e8, 0x000201f1, 0x000100fa, 0x00000020,
  0x8000017d, 0x800000ff, 0x80000081, 0x80000020,
  0x00018174, 0x000100f9, 0x0000807e, 0x00000020,
  0x0003016e, 0x000200f5, 0x0001007c, 0x00000020,
  0x8004816b, 0x800300f3, 0x8001807b, 0x80000020,
  0x80017ff7, 0x8000fffb, 0x80007fff, 0x80000020,
  0x8002fff1, 0x8001fff7, 0x8000fffd, 0x80000020,
  0x00047fee, 0x0002fff5, 0x00017ffc, 0x00000020,
  0x199e1987, 0xe669665b, 0xb334b32f, 0x80000020,
  0x00017ffa, 0x0000fffd, 0x00008000, 0x00000020,
  0x8002fff7, 0x8001fffb, 0x8000ffff, 0x80000020,
  0x999c9990, 0x66686661, 0x33343332, 0x00000020,
  0x199c998f, 0x9113110b, 0x08898887, 0x80000020,
  0x80017ffd, 0x8000ffff, 0x80008001, 0x80000020,
  0x999b1996, 0x66676665, 0x3333b334, 0x00000020,
  0x199b1995, 0x9112110f, 0x08890889, 0x80000020,
  0x199b198c, 0x11121109, 0x08890886, 0x00000020,
  0x19999999, 0xe6666667, 0xb3333335, 0x80000020,
  0x99999998, 0x11111111, 0x8888888a, 0x00000020,
  0x9999998f, 0x9111110b, 0x88888887, 0x80000020,
  0x19999989, 0x91111107, 0x08888885, 0x80000020,
  0x7fffffff, 0x2aaaaaab, 0xd5555557, 0x80000020,
  0x7ffffff6, 0xaaaaaaa5, 0xd5555554, 0x00000020,
  0xfffffff0, 0xaaaaaaa1, 0x55555552, 0x00000020,
  0xffffffed, 0x2aaaaa9f, 0x55555551, 0x80000020,
  0xfffffff7, 0x7ffffffb, 0xffffffff, 0x80000020,
  0x7ffffff1, 0x7ffffff7, 0x7ffffffd, 0x80000020,
  0x7fffffee, 0xfffffff5, 0x7ffffffc, 0x00000020,
  0xffffffee, 0xfffffff5, 0xfffffffc, 0x00000020,
  0x7ffffffa, 0xfffffffd, 0x80000000, 0x00000020,
  0x7ffffff7, 0x7ffffffb, 0x7fffffff, 0x80000020,
  0xfffffff7, 0x7ffffffb, 0xffffffff, 0x80000020,
  0xfffffffa, 0xfffffffd, 0x00000000, 0x00000020,
  0xfffffffd, 0x7fffffff, 0x00000001, 0x80000020,
  0x7ffffffd, 0x7fffffff, 0x80000001, 0x80000020,
  0x80000000, 0x00000001, 0x80000002, 0x00000020,
  0x7ffffffe, 0x55555555, 0x2aaaaaac, 0x00000020,
  0x80000000, 0x00000001, 0x80000002, 0x00000020,
  0x80000003, 0x80000003, 0x80000003, 0x80000020,
  0x80000001, 0xd5555557, 0x2aaaaaad, 0x80000020,
  0xe6666665, 0x6eeeeeef, 0xf7777779, 0x80000020,
  0x00000003, 0x80000003, 0x00000003, 0x80000020,
  0x00000001, 0xd5555557, 0xaaaaaaad, 0x80000020,
  0x66666665, 0x6eeeeeef, 0x77777779, 0x80000020,
  0x6664e665, 0x6eedeeef, 0x7776f779, 0x80000020,
  0xfffffffe, 0x55555555, 0xaaaaaaac, 0x00000020,
  0x66666662, 0xeeeeeeed, 0x77777778, 0x00000020,
  0x6664e662, 0xeeedeeed, 0x7776f778, 0x00000020,
  0xe6636665, 0x6eeceeef, 0xf7767779, 0x80000020,
  0x66666664, 0x99999999, 0xccccccce, 0x00000020,
  0x6664e664, 0x99989999, 0xcccc4cce, 0x00000020,
  0xe6636667, 0x1997999b, 0x4ccbcccf, 0x80000020,
  0xe661e66d, 0x1996999f, 0x4ccb4cd1, 0x80000020,
  0xfffe8000, 0xffff0001, 0xffff8002, 0x00000020,
  0x7ffd0003, 0x7ffe0003, 0x7fff0003, 0x80000020,
  0x7ffb8009, 0x7ffd0007, 0x7ffe8005, 0x80000020,
  0xfffa0012, 0xfffc000d, 0xfffe0008, 0x00000020,
  0x7ffe8003, 0x7fff0003, 0x7fff8003, 0x80000020,
  0x7ffd0009, 0x7ffe0007, 0x7fff0005, 0x80000020,
  0xfffb8012, 0xfffd000d, 0xfffe8008, 0x00000020,
  0xfffb7e92, 0xfffcff0d, 0xfffe7f88, 0x00000020,
  0xfffe8006, 0xffff0005, 0xffff8004, 0x00000020,
  0x7ffd000f, 0x7ffe000b, 0x7fff0007, 0x80000020,
  0x7ffcfe8f, 0x7ffdff0b, 0x7ffeff87, 0x80000020,
  0xfffcfd12, 0xfffdfe0d, 0xfffeff08, 0x00000020,
  0x7ffe8009, 0x7fff0007, 0x7fff8005, 0x80000020,
  0x7ffe7e89, 0x7ffeff07, 0x7fff7f85, 0x80000020,
  0xfffe7d0c, 0xfffefe09, 0xffff7f06, 0x00000020,
  0xfffe7b92, 0xfffefd0d, 0xffff7e88, 0x00000020,
  0xfffffe80, 0xffffff01, 0xffffff82, 0x00000020,
  0x7ffffd03, 0x7ffffe03, 0x7fffff03, 0x80000020,
  0x7ffffb89, 0x7ffffd07, 0x7ffffe85, 0x80000020,
  0xfffffa12, 0xfffffc0d, 0xfffffe08, 0x00000020,
  0x7ffffe83, 0x7fffff03, 0x7fffff83, 0x80000020,
  0x7ffffd09, 0x7ffffe07, 0x7fffff05, 0x80000020,
  0xfffffb92, 0xfffffd0d, 0xfffffe88, 0x00000020,
  0xfffffb32, 0xfffffccd, 0xfffffe68, 0x00000020,
  0xfffffe86, 0xffffff05, 0xffffff84, 0x00000020,
  0x7ffffd0f, 0x7ffffe0b, 0x7fffff07, 0x80000020,
  0x7ffffcaf, 0x7ffffdcb, 0x7ffffee7, 0x80000020,
  0xfffffca6, 0xfffffdc5, 0xfffffee4, 0x00000020,
  0x7ffffe89, 0x7fffff07, 0x7fffff85, 0x80000020,
  0x7ffffe29, 0x7ffffec7, 0x7fffff65, 0x80000020,
  0xfffffe20, 0xfffffec1, 0xffffff62, 0x00000020,
  0xfffffe1a, 0xfffffebd, 0xffffff60, 0x00000020,
  0xffffffa0, 0xffffffc1, 0xffffffe2, 0x00000020,
  0x7fffff97, 0x7fffffbb, 0x7fffffdf, 0x80000020,
  0x7fffff91, 0x7fffffb7, 0x7fffffdd, 0x80000020,
  0xffffff8e, 0xffffffb5, 0xffffffdc, 0x00000020,
  0x7ffffffa, 0x7ffffffe, 0x80000002, 0x80000023,
  0x7ffffff6, 0x7ffffffc, 0x80000002, 0x80000025,
  0xfffffff4, 0xfffffffb, 0x00000002, 0x00000026,
  0xfffffff4, 0xfffffffb, 0x00000002, 0x00000026,
  0xfffffffc, 0xffffffff, 0x00000002, 0x00000022,
  0x7ffffffa, 0x7ffffffe, 0x80000002, 0x80000023,
  0x7ffffffa, 0x7ffffffe, 0x80000002, 0x80000023,
  0xfffffffc, 0xffffffff, 0x00000002, 0x00000022,
  0x7ffffffe, 0x80000000, 0x80000002, 0x80000021,
  0x7ffffffe, 0x80000000, 0x80000002, 0x80000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000004, 0x00000003, 0x00000002, 0x0000001e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x80000002, 0x80000002, 0x80000002, 0x8000001f,
  0x80000006, 0x80000004, 0x80000002, 0x8000001d,
  0x80000046, 0x80000024, 0x80000002, 0x7ffffffd,
  0x80000002, 0x80000002, 0x80000002, 0x8000001f,
  0x80000006, 0x80000004, 0x80000002, 0x8000001d,
  0x80000046, 0x80000024, 0x80000002, 0x7ffffffd,
  0x00000140, 0x000000a1, 0x00000002, 0xffffff80,
  0x00000004, 0x00000003, 0x00000002, 0x0000001e,
  0x00000044, 0x00000023, 0x00000002, 0xfffffffe,
  0x8000013e, 0x800000a0, 0x80000002, 0x7fffff81,
  0x8000023a, 0x8000011e, 0x80000002, 0x7fffff03,
  0x00000040, 0x00000021, 0x00000002, 0x00000000,
  0x8000013a, 0x8000009e, 0x80000002, 0x7fffff83,
  0x80000236, 0x8000011c, 0x80000002, 0x7fffff05,
  0x00000334, 0x0000019b, 0x00000002, 0xfffffe86,
  0x800000fa, 0x8000007e, 0x80000002, 0x7fffffa3,
  0x800001f6, 0x800000fc, 0x80000002, 0x7fffff25,
  0x000002f4, 0x0000017b, 0x00000002, 0xfffffea6,
  0x800102ee, 0x80008178, 0x80000002, 0x7fff7ea9,
  0x000000fc, 0x0000007f, 0x00000002, 0xffffffa2,
  0x800001fa, 0x800000fe, 0x80000002, 0x7fffff23,
  0x000101f4, 0x000080fb, 0x00000002, 0xffff7f26,
  0x000201f0, 0x000100f9, 0x00000002, 0xfffeff28,
  0x800000fe, 0x80000080, 0x80000002, 0x7fffffa1,
  0x000100f8, 0x0000807d, 0x00000002, 0xffff7fa4,
  0x000200f4, 0x0001007b, 0x00000002, 0xfffeffa6,
  0x800300f2, 0x8001807a, 0x80000002, 0x7ffe7fa7,
  0x8000fffa, 0x80007ffe, 0x80000002, 0x7fff8023,
  0x8001fff6, 0x8000fffc, 0x80000002, 0x7fff0025,
  0x0002fff4, 0x00017ffb, 0x00000002, 0xfffe8026,
  0xe669665a, 0xb334b32e, 0x80000002, 0x4ccb4cf3,
  0x0000fffc, 0x00007fff, 0x00000002, 0xffff8022,
  0x8001fffa, 0x8000fffe, 0x80000002, 0x7fff0023,
  0x66686660, 0x33343331, 0x00000002, 0xcccbccf0,
  0x9113110a, 0x08898886, 0x80000002, 0xf776779b,
  0x8000fffe, 0x80008000, 0x80000002, 0x7fff8021,
  0x66676664, 0x3333b333, 0x00000002, 0xcccc4cee,
  0x9112110e, 0x08890888, 0x80000002, 0xf776f799,
  0x11121108, 0x08890885, 0x00000002, 0xf776f79c,
  0xe6666666, 0xb3333334, 0x80000002, 0x4ccccced,
  0x11111110, 0x88888889, 0x00000002, 0x77777798,
  0x9111110a, 0x88888886, 0x80000002, 0x7777779b,
  0x91111106, 0x08888884, 0x80000002, 0xf777779d,
  0x2aaaaaaa, 0xd5555556, 0x80000002, 0x2aaaaacb,
  0xaaaaaaa4, 0xd5555553, 0x00000002, 0x2aaaaace,
  0xaaaaaaa0, 0x55555551, 0x00000002, 0xaaaaaad0,
  0x2aaaaa9e, 0x55555550, 0x80000002, 0xaaaaaad1,
  0x7ffffffa, 0xfffffffe, 0x80000002, 0x00000023,
  0x7ffffff6, 0x7ffffffc, 0x80000002, 0x80000025,
  0xfffffff4, 0x7ffffffb, 0x00000002, 0x80000026,
  0xfffffff4, 0xfffffffb, 0x00000002, 0x00000026,
  0xfffffffc, 0x7fffffff, 0x00000002, 0x80000022,
  0x7ffffffa, 0x7ffffffe, 0x80000002, 0x80000023,
  0x7ffffffa, 0xfffffffe, 0x80000002, 0x00000023,
  0xfffffffc, 0xffffffff, 0x00000002, 0x00000022,
  0x7ffffffe, 0x00000000, 0x80000002, 0x00000021,
  0x7ffffffe, 0x80000000, 0x80000002, 0x80000021,
  0x00000000, 0x80000001, 0x00000002, 0x80000020,
  0x55555554, 0x2aaaaaab, 0x00000002, 0xd5555576,
  0x00000000, 0x80000001, 0x00000002, 0x80000020,
  0x80000002, 0x80000002, 0x80000002, 0x8000001f,
  0xd5555556, 0x2aaaaaac, 0x80000002, 0xd5555575,
  0x6eeeeeee, 0xf7777778, 0x80000002, 0x088888a9,
  0x80000002, 0x00000002, 0x80000002, 0x0000001f,
  0xd5555556, 0xaaaaaaac, 0x80000002, 0x55555575,
  0x6eeeeeee, 0x77777778, 0x80000002, 0x888888a9,
  0x6eedeeee, 0x7776f778, 0x80000002, 0x888908a9,
  0x55555554, 0xaaaaaaab, 0x00000002, 0x55555576,
  0xeeeeeeec, 0x77777777, 0x00000002, 0x888888aa,
  0xeeedeeec, 0x7776f777, 0x00000002, 0x888908aa,
  0x6eeceeee, 0xf7767778, 0x80000002, 0x088988a9,
  0x99999998, 0xcccccccd, 0x00000002, 0x33333354,
  0x99989998, 0xcccc4ccd, 0x00000002, 0x3333b354,
  0x1997999a, 0x4ccbccce, 0x80000002, 0xb3343353,
  0x1996999e, 0x4ccb4cd0, 0x80000002, 0xb334b351,
  0xffff0000, 0xffff8001, 0x00000002, 0x00008020,
  0x7ffe0002, 0x7fff0002, 0x80000002, 0x8001001f,
  0x7ffd0006, 0x7ffe8004, 0x80000002, 0x8001801d,
  0xfffc000c, 0xfffe0007, 0x00000002, 0x0002001a,
  0x7fff0002, 0x7fff8002, 0x80000002, 0x8000801f,
  0x7ffe0006, 0x7fff0004, 0x80000002, 0x8001001d,
  0xfffd000c, 0xfffe8007, 0x00000002, 0x0001801a,
  0xfffcff0c, 0xfffe7f87, 0x00000002, 0x0001809a,
  0xffff0004, 0xffff8003, 0x00000002, 0x0000801e,
  0x7ffe000a, 0x7fff0006, 0x80000002, 0x8001001b,
  0x7ffdff0a, 0x7ffeff86, 0x80000002, 0x8001009b,
  0xfffdfe0c, 0xfffeff07, 0x00000002, 0x0001011a,
  0x7fff0006, 0x7fff8004, 0x80000002, 0x8000801d,
  0x7ffeff06, 0x7fff7f84, 0x80000002, 0x8000809d,
  0xfffefe08, 0xffff7f05, 0x00000002, 0x0000811c,
  0xfffefd0c, 0xffff7e87, 0x00000002, 0x0000819a,
  0xffffff00, 0xffffff81, 0x00000002, 0x000000a0,
  0x7ffffe02, 0x7fffff02, 0x80000002, 0x8000011f,
  0x7ffffd06, 0x7ffffe84, 0x80000002, 0x8000019d,
  0xfffffc0c, 0xfffffe07, 0x00000002, 0x0000021a,
  0x7fffff02, 0x7fffff82, 0x80000002, 0x8000009f,
  0x7ffffe06, 0x7fffff04, 0x80000002, 0x8000011d,
  0xfffffd0c, 0xfffffe87, 0x00000002, 0x0000019a,
  0xfffffccc, 0xfffffe67, 0x00000002, 0x000001ba,
  0xffffff04, 0xffffff83, 0x00000002, 0x0000009e,
  0x7ffffe0a, 0x7fffff06, 0x80000002, 0x8000011b,
  0x7ffffdca, 0x7ffffee6, 0x80000002, 0x8000013b,
  0xfffffdc4, 0xfffffee3, 0x00000002, 0x0000013e,
  0x7fffff06, 0x7fffff84, 0x80000002, 0x8000009d,
  0x7ffffec6, 0x7fffff64, 0x80000002, 0x800000bd,
  0xfffffec0, 0xffffff61, 0x00000002, 0x000000c0,
  0xfffffebc, 0xffffff5f, 0x00000002, 0x000000c2,
  0xffffffc0, 0xffffffe1, 0x00000002, 0x00000040,
  0x7fffffba, 0x7fffffde, 0x80000002, 0x80000043,
  0x7fffffb6, 0x7fffffdc, 0x80000002, 0x80000045,
  0xffffffb4, 0xffffffdb, 0x00000002, 0x00000046,
  0x7ffffffd, 0x80000001, 0x80000005, 0x0000001e,
  0x7ffffffb, 0x80000001, 0x80000007, 0x55555572,
  0xfffffffa, 0x00000001, 0x00000008, 0x0000001c,
  0xfffffffa, 0x00000001, 0x00000008, 0x0000001c,
  0xfffffffe, 0x00000001, 0x00000004, 0x55555574,
  0x7ffffffd, 0x80000001, 0x80000005, 0x0000001e,
  0x7ffffffd, 0x80000001, 0x80000005, 0x0000001e,
  0xfffffffe, 0x00000001, 0x00000004, 0x55555574,
  0x7fffffff, 0x80000001, 0x80000003, 0xaaaaaaca,
  0x7fffffff, 0x80000001, 0x80000003, 0xaaaaaaca,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000002, 0x00000001, 0x00000000, 0xaaaaaacc,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x80000001, 0x80000001, 0x80000001, 0x55555576,
  0x80000003, 0x80000001, 0x7fffffff, 0x00000022,
  0x80000023, 0x80000001, 0x7fffffdf, 0xaaaaaae2,
  0x80000001, 0x80000001, 0x80000001, 0x55555576,
  0x80000003, 0x80000001, 0x7fffffff, 0x00000022,
  0x80000023, 0x80000001, 0x7fffffdf, 0xaaaaaae2,
  0x000000a0, 0x00000001, 0xffffff62, 0x555555e0,
  0x00000002, 0x00000001, 0x00000000, 0xaaaaaacc,
  0x00000022, 0x00000001, 0xffffffe0, 0x5555558c,
  0x8000009f, 0x80000001, 0x7fffff63, 0x0000008a,
  0x8000011d, 0x80000001, 0x7ffffee5, 0x000000de,
  0x00000020, 0x00000001, 0xffffffe2, 0xaaaaaae0,
  0x8000009d, 0x80000001, 0x7fffff65, 0x555555de,
  0x8000011b, 0x80000001, 0x7ffffee7, 0x55555632,
  0x0000019a, 0x00000001, 0xfffffe68, 0xaaaaabdc,
  0x8000007d, 0x80000001, 0x7fffff85, 0xaaaaab1e,
  0x800000fb, 0x80000001, 0x7fffff07, 0xaaaaab72,
  0x0000017a, 0x00000001, 0xfffffe88, 0x0000011c,
  0x80008177, 0x80000001, 0x7fff7e8b, 0xaaab011a,
  0x0000007e, 0x00000001, 0xffffff84, 0x00000074,
  0x800000fd, 0x80000001, 0x7fffff05, 0x5555561e,
  0x000080fa, 0x00000001, 0xffff7f08, 0x0000561c,
  0x000100f8, 0x00000001, 0xfffeff0a, 0x0000ab70,
  0x8000007f, 0x80000001, 0x7fffff83, 0x555555ca,
  0x0000807c, 0x00000001, 0xffff7f86, 0x000055c8,
  0x0001007a, 0x00000001, 0xfffeff88, 0x0000ab1c,
  0x80018079, 0x80000001, 0x7ffe7f89, 0x555655c6,
  0x80007ffd, 0x80000001, 0x7fff8005, 0xaaab001e,
  0x8000fffb, 0x80000001, 0x7fff0007, 0xaaab5572,
  0x00017ffa, 0x00000001, 0xfffe8008, 0x0001001c,
  0xb334b32d, 0x80000001, 0x4ccb4cd5, 0x2223223e,
  0x00007ffe, 0x00000001, 0xffff8004, 0x00005574,
  0x8000fffd, 0x80000001, 0x7fff0005, 0x5556001e,
  0x33343330, 0x00000001, 0xcccbccd2, 0x77782240,
  0x08898885, 0x80000001, 0xf776777d, 0x05b105ce,
  0x80007fff, 0x80000001, 0x7fff8003, 0x5555aaca,
  0x3333b332, 0x00000001, 0xcccc4cd0, 0x7777ccec,
  0x08890887, 0x80000001, 0xf776f77b, 0x05b0b07a,
  0x08890884, 0x00000001, 0xf776f77e, 0x05b0b078,
  0xb3333333, 0x80000001, 0x4ccccccf, 0x22222242,
  0x88888888, 0x00000001, 0x7777777a, 0xb05b05d0,
  0x88888885, 0x80000001, 0x7777777d, 0xb05b05ce,
  0x08888883, 0x80000001, 0xf777777f, 0x05b05b22,
  0xd5555555, 0x80000001, 0x2aaaaaad, 0x8e38e3ae,
  0xd5555552, 0x00000001, 0x2aaaaab0, 0x8e38e3ac,
  0x55555550, 0x00000001, 0xaaaaaab2, 0xe38e3900,
  0x5555554f, 0x80000001, 0xaaaaaab3, 0x8e38e3aa,
  0xfffffffd, 0x80000001, 0x00000005, 0x0000001e,
  0x7ffffffb, 0x80000001, 0x80000007, 0x55555572,
  0x7ffffffa, 0x00000001, 0x80000008, 0x0000001c,
  0xfffffffa, 0x00000001, 0x00000008, 0x0000001c,
  0x7ffffffe, 0x00000001, 0x80000004, 0x55555574,
  0x7ffffffd, 0x80000001, 0x80000005, 0x0000001e,
  0xfffffffd, 0x80000001, 0x00000005, 0x0000001e,
  0xfffffffe, 0x00000001, 0x00000004, 0x55555574,
  0xffffffff, 0x80000001, 0x00000003, 0xaaaaaaca,
  0x7fffffff, 0x80000001, 0x80000003, 0xaaaaaaca,
  0x80000000, 0x00000001, 0x80000002, 0x00000020,
  0x2aaaaaaa, 0x00000001, 0xd5555558, 0x1c71c73c,
  0x80000000, 0x00000001, 0x80000002, 0x00000020,
  0x80000001, 0x80000001, 0x80000001, 0x55555576,
  0x2aaaaaab, 0x80000001, 0xd5555557, 0x71c71c92,
  0xf7777777, 0x80000001, 0x0888888b, 0xfa4fa51a,
  0x00000001, 0x80000001, 0x00000001, 0x55555576,
  0xaaaaaaab, 0x80000001, 0x55555557, 0x71c71c92,
  0x77777777, 0x80000001, 0x8888888b, 0xfa4fa51a,
  0x7776f777, 0x80000001, 0x8889088b, 0x4fa4a51a,
  0xaaaaaaaa, 0x00000001, 0x55555558, 0x1c71c73c,
  0x77777776, 0x00000001, 0x8888888c, 0xa4fa4fc4,
  0x7776f776, 0x00000001, 0x8889088c, 0xfa4f4fc4,
  0xf7767777, 0x80000001, 0x0889888b, 0xa4f9a51a,
  0xcccccccc, 0x00000001, 0x33333336, 0x888888a8,
  0xcccc4ccc, 0x00000001, 0x3333b336, 0xdddd88a8,
  0x4ccbcccd, 0x80000001, 0xb3343335, 0x8887ddfe,
  0x4ccb4ccf, 0x80000001, 0xb334b333, 0x888788aa,
  0xffff8000, 0x00000001, 0x00008002, 0x55550020,
  0x7fff0001, 0x80000001, 0x80010001, 0xffff5576,
  0x7ffe8003, 0x80000001, 0x80017fff, 0xffff0022,
  0xfffe0006, 0x00000001, 0x0001fffc, 0x55540024,
  0x7fff8001, 0x80000001, 0x80008001, 0xaaaa5576,
  0x7fff0003, 0x80000001, 0x8000ffff, 0xaaaa0022,
  0xfffe8006, 0x00000001, 0x00017ffc, 0xffff0024,
  0xfffe7f86, 0x00000001, 0x0001807c, 0x55545524,
  0xffff8002, 0x00000001, 0x00008000, 0xffffaacc,
  0x7fff0005, 0x80000001, 0x8000fffd, 0x5554aace,
  0x7ffeff85, 0x80000001, 0x8001007d, 0xaaa9ffce,
  0xfffeff06, 0x00000001, 0x000100fc, 0x5554aa24,
  0x7fff8003, 0x80000001, 0x80007fff, 0x55550022,
  0x7fff7f83, 0x80000001, 0x8000807f, 0xaaaa5522,
  0xffff7f04, 0x00000001, 0x000080fe, 0x5554ff78,
  0xffff7e86, 0x00000001, 0x0000817c, 0x5554ff24,
  0xffffff80, 0x00000001, 0x00000082, 0x55555520,
  0x7fffff01, 0x80000001, 0x80000101, 0xffffff76,
  0x7ffffe83, 0x80000001, 0x8000017f, 0xffffff22,
  0xfffffe06, 0x00000001, 0x000001fc, 0x55555424,
  0x7fffff81, 0x80000001, 0x80000081, 0xaaaaaa76,
  0x7fffff03, 0x80000001, 0x800000ff, 0xaaaaaa22,
  0xfffffe86, 0x00000001, 0x0000017c, 0xffffff24,
  0xfffffe66, 0x00000001, 0x0000019c, 0x55555464,
  0xffffff82, 0x00000001, 0x00000080, 0xffffffcc,
  0x7fffff05, 0x80000001, 0x800000fd, 0x555554ce,
  0x7ffffee5, 0x80000001, 0x8000011d, 0xaaaaaa0e,
  0xfffffee2, 0x00000001, 0x00000120, 0xaaaaaa0c,
  0x7fffff83, 0x80000001, 0x8000007f, 0x55555522,
  0x7fffff63, 0x80000001, 0x8000009f, 0xaaaaaa62,
  0xffffff60, 0x00000001, 0x000000a2, 0xaaaaaa60,
  0xffffff5e, 0x00000001, 0x000000a4, 0xffffffb4,
  0xffffffe0, 0x00000001, 0x00000022, 0x55555560,
  0x7fffffdd, 0x80000001, 0x80000025, 0x5555555e,
  0x7fffffdb, 0x80000001, 0x80000027, 0xaaaaaab2,
  0xffffffda, 0x00000001, 0x00000028, 0x5555555c,
  0x80000000, 0x80000004, 0x00000000, 0x66666684,
  0x80000000, 0x80000006, 0x55555554, 0x0000001c,
  0x00000000, 0x00000007, 0xfffffffe, 0xcccccce8,
  0x00000000, 0x00000007, 0xfffffffe, 0xcccccce8,
  0x00000000, 0x00000003, 0x55555556, 0x999999b8,
  0x80000000, 0x80000004, 0x00000000, 0x66666684,
  0x80000000, 0x80000004, 0x00000000, 0x66666684,
  0x00000000, 0x00000003, 0x55555556, 0x999999b8,
  0x80000000, 0x80000002, 0xaaaaaaac, 0xccccccec,
  0x80000000, 0x80000002, 0xaaaaaaac, 0xccccccec,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0xffffffff, 0xaaaaaaae, 0x66666688,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x80000000, 0x80000000, 0x55555558, 0x33333354,
  0x80000000, 0x7ffffffe, 0x00000004, 0x999999bc,
  0x80000000, 0x7fffffde, 0xaaaaaac4, 0x0000003c,
  0x80000000, 0x80000000, 0x55555558, 0x33333354,
  0x80000000, 0x7ffffffe, 0x00000004, 0x999999bc,
  0x80000000, 0x7fffffde, 0xaaaaaac4, 0x0000003c,
  0x00000000, 0xffffff61, 0x555555c2, 0x000000a0,
  0x00000000, 0xffffffff, 0xaaaaaaae, 0x66666688,
  0x00000000, 0xffffffdf, 0x5555556e, 0xcccccd08,
  0x80000000, 0x7fffff62, 0x0000006c, 0xcccccd6c,
  0x80000000, 0x7ffffee4, 0x000000c0, 0x00000104,
  0x00000000, 0xffffffe1, 0xaaaaaac2, 0x666666a0,
  0x80000000, 0x7fffff64, 0x555555c0, 0x66666704,
  0x80000000, 0x7ffffee6, 0x55555614, 0x99999a9c,
  0x00000000, 0xfffffe67, 0xaaaaabbe, 0x00000168,
  0x80000000, 0x7fffff84, 0xaaaaab00, 0x00000084,
  0x80000000, 0x7fffff06, 0xaaaaab54, 0x3333341c,
  0x00000000, 0xfffffe87, 0x000000fe, 0x99999ae8,
  0x80000000, 0x7fff7e8a, 0xaaab00fc, 0x999a014c,
  0x00000000, 0xffffff83, 0x00000056, 0x333333b8,
  0x80000000, 0x7fffff04, 0x55555600, 0x99999a84,
  0x00000000, 0xffff7f07, 0x000055fe, 0x999a00e8,
  0x00000000, 0xfffeff09, 0x0000ab52, 0xcccd9a80,
  0x80000000, 0x7fffff82, 0x555555ac, 0x666666ec,
  0x00000000, 0xffff7f85, 0x000055aa, 0x6666cd50,
  0x00000000, 0xfffeff87, 0x0000aafe, 0x999a66e8,
  0x80000000, 0x7ffe7f88, 0x555655a8, 0x000133b4,
  0x80000000, 0x7fff8004, 0xaaab0000, 0x00006684,
  0x80000000, 0x7fff0006, 0xaaab5554, 0x3334001c,
  0x00000000, 0xfffe8007, 0x0000fffe, 0x999acce8,
  0x80000000, 0x4ccb4cd4, 0x22232220, 0x8f5d5c44,
  0x00000000, 0xffff8003, 0x00005556, 0x333399b8,
  0x80000000, 0x7fff0004, 0x55560000, 0x999a6684,
  0x00000000, 0xcccbccd1, 0x77782222, 0x8f5cf5e0,
  0x80000000, 0xf776777c, 0x05b105b0, 0xd3a13a24,
  0x80000000, 0x7fff8002, 0x5555aaac, 0x6666ccec,
  0x00000000, 0xcccc4ccf, 0x7777ccce, 0x5c295c48,
  0x80000000, 0xf776f77a, 0x05b0b05c, 0xa06da08c,
  0x00000000, 0xf776f77d, 0x05b0b05a, 0x06d406f0,
  0x80000000, 0x4cccccce, 0x22222224, 0xf5c28f7c,
  0x00000000, 0x77777779, 0xb05b05b2, 0x3a06d3c0,
  0x80000000, 0x7777777c, 0xb05b05b0, 0xa06d3a24,
  0x80000000, 0xf777777e, 0x05b05b04, 0x3a06d3bc,
  0x80000000, 0x2aaaaaac, 0x8e38e390, 0x44444464,
  0x00000000, 0x2aaaaaaf, 0x8e38e38e, 0xaaaaaac8,
  0x00000000, 0xaaaaaab1, 0xe38e38e2, 0x44444460,
  0x80000000, 0xaaaaaab2, 0x8e38e38c, 0x1111112c,
  0x80000000, 0x00000004, 0x00000000, 0x66666684,
  0x80000000, 0x80000006, 0x55555554, 0x0000001c,
  0x00000000, 0x80000007, 0xfffffffe, 0xcccccce8,
  0x00000000, 0x00000007, 0xfffffffe, 0xcccccce8,
  0x00000000, 0x80000003, 0x55555556, 0x999999b8,
  0x80000000, 0x80000004, 0x00000000, 0x66666684,
  0x80000000, 0x00000004, 0x00000000, 0x66666684,
  0x00000000, 0x00000003, 0x55555556, 0x999999b8,
  0x80000000, 0x00000002, 0xaaaaaaac, 0xccccccec,
  0x80000000, 0x80000002, 0xaaaaaaac, 0xccccccec,
  0x00000000, 0x80000001, 0x00000002, 0x00000020,
  0x00000000, 0xd5555557, 0x1c71c71e, 0x888888a8,
  0x00000000, 0x80000001, 0x00000002, 0x00000020,
  0x80000000, 0x80000000, 0x55555558, 0x33333354,
  0x80000000, 0xd5555556, 0x71c71c74, 0xbbbbbbdc,
  0x80000000, 0x0888888a, 0xfa4fa4fc, 0x92c5f94c,
  0x80000000, 0x00000000, 0x55555558, 0x33333354,
  0x80000000, 0x55555556, 0x71c71c74, 0xbbbbbbdc,
  0x80000000, 0x8888888a, 0xfa4fa4fc, 0x92c5f94c,
  0x80000000, 0x8889088a, 0x4fa4a4fc, 0xf92bf94c,
  0x00000000, 0x55555557, 0x1c71c71e, 0x888888a8,
  0x00000000, 0x8888888b, 0xa4fa4fa6, 0x5f92c618,
  0x00000000, 0x8889088b, 0xfa4f4fa6, 0xc5f8c618,
  0x80000000, 0x0889888a, 0xa4f9a4fc, 0x5f91f94c,
  0x00000000, 0x33333335, 0x8888888a, 0xd70a3d90,
  0x00000000, 0x3333b335, 0xdddd888a, 0x3d703d90,
  0x80000000, 0xb3343334, 0x8887dde0, 0xd70970c4,
  0x80000000, 0xb334b332, 0x8887888c, 0xa3d5d72c,
  0x00000000, 0x00008001, 0x55550002, 0x66660020,
  0x80000000, 0x80010000, 0xffff5558, 0xffff3354,
  0x80000000, 0x80017ffe, 0xffff0004, 0xcccb99bc,
  0x00000000, 0x0001fffb, 0x55540006, 0xcccb3358,
  0x80000000, 0x80008000, 0xaaaa5558, 0x99993354,
  0x80000000, 0x8000fffe, 0xaaaa0004, 0x666599bc,
  0x00000000, 0x00017ffb, 0xffff0006, 0x66653358,
  0x00000000, 0x0001807b, 0x55545506, 0xcccb9958,
  0x00000000, 0x00007fff, 0xffffaaae, 0xcccc6688,
  0x80000000, 0x8000fffc, 0x5554aab0, 0xcccc0024,
  0x80000000, 0x8001007c, 0xaaa9ffb0, 0x33326624,
  0x00000000, 0x000100fb, 0x5554aa06, 0xcccbff58,
  0x80000000, 0x80007ffe, 0x55550004, 0xffff99bc,
  0x80000000, 0x8000807e, 0xaaaa5504, 0x6665ffbc,
  0x00000000, 0x000080fd, 0x5554ff5a, 0xffff98f0,
  0x00000000, 0x0000817b, 0x5554ff06, 0xcccc6558,
  0x00000000, 0x00000081, 0x55555502, 0x66666620,
  0x80000000, 0x80000100, 0xffffff58, 0xffffff54,
  0x80000000, 0x8000017e, 0xffffff04, 0xcccccbbc,
  0x00000000, 0x000001fb, 0x55555406, 0xcccccb58,
  0x80000000, 0x80000080, 0xaaaaaa58, 0x99999954,
  0x80000000, 0x800000fe, 0xaaaaaa04, 0x666665bc,
  0x00000000, 0x0000017b, 0xffffff06, 0x66666558,
  0x00000000, 0x0000019b, 0x55555446, 0xfffffed8,
  0x00000000, 0x0000007f, 0xffffffae, 0xcccccc88,
  0x80000000, 0x800000fc, 0x555554b0, 0xcccccc24,
  0x80000000, 0x8000011c, 0xaaaaa9f0, 0x666665a4,
  0x00000000, 0x0000011f, 0xaaaaa9ee, 0xcccccc08,
  0x80000000, 0x8000007e, 0x55555504, 0xffffffbc,
  0x80000000, 0x8000009e, 0xaaaaaa44, 0x9999993c,
  0x00000000, 0x000000a1, 0xaaaaaa42, 0xffffffa0,
  0x00000000, 0x000000a3, 0xffffff96, 0x99999938,
  0x00000000, 0x00000021, 0x55555542, 0x999999a0,
  0x80000000, 0x80000024, 0x55555540, 0x00000004,
  0x80000000, 0x80000026, 0xaaaaaa94, 0x9999999c,
  0x00000000, 0x00000027, 0x5555553e, 0x66666668,
  0x80000003, 0xffffffff, 0x66666666, 0xfffe8020,
  0x80000005, 0x55555553, 0xfffffffe, 0xfffd8020,
  0x00000006, 0xfffffffd, 0xccccccca, 0xfffd0020,
  0x00000006, 0xfffffffd, 0xccccccca, 0xfffd0020,
  0x00000002, 0x55555555, 0x9999999a, 0xffff0020,
  0x80000003, 0xffffffff, 0x66666666, 0xfffe8020,
  0x80000003, 0xffffffff, 0x66666666, 0xfffe8020,
  0x00000002, 0x55555555, 0x9999999a, 0xffff0020,
  0x80000001, 0xaaaaaaab, 0xccccccce, 0xffff8020,
  0x80000001, 0xaaaaaaab, 0xccccccce, 0xffff8020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffffffe, 0xaaaaaaad, 0x6666666a, 0x00010020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x7fffffff, 0x55555557, 0x33333336, 0x00008020,
  0x7ffffffd, 0x00000003, 0x9999999e, 0x00018020,
  0x7fffffdd, 0xaaaaaac3, 0x0000001e, 0x00118020,
  0x7fffffff, 0x55555557, 0x33333336, 0x00008020,
  0x7ffffffd, 0x00000003, 0x9999999e, 0x00018020,
  0x7fffffdd, 0xaaaaaac3, 0x0000001e, 0x00118020,
  0xffffff60, 0x555555c1, 0x00000082, 0x00500020,
  0xfffffffe, 0xaaaaaaad, 0x6666666a, 0x00010020,
  0xffffffde, 0x5555556d, 0xccccccea, 0x00110020,
  0x7fffff61, 0x0000006b, 0xcccccd4e, 0x004f8020,
  0x7ffffee3, 0x000000bf, 0x000000e6, 0x008e8020,
  0xffffffe0, 0xaaaaaac1, 0x66666682, 0x00100020,
  0x7fffff63, 0x555555bf, 0x666666e6, 0x004e8020,
  0x7ffffee5, 0x55555613, 0x99999a7e, 0x008d8020,
  0xfffffe66, 0xaaaaabbd, 0x0000014a, 0x00cd0020,
  0x7fffff83, 0xaaaaaaff, 0x00000066, 0x003e8020,
  0x7fffff05, 0xaaaaab53, 0x333333fe, 0x007d8020,
  0xfffffe86, 0x000000fd, 0x99999aca, 0x00bd0020,
  0x7fff7e89, 0xaaab00fb, 0x999a012e, 0x40bb8020,
  0xffffff82, 0x00000055, 0x3333339a, 0x003f0020,
  0x7fffff03, 0x555555ff, 0x99999a66, 0x007e8020,
  0xffff7f06, 0x000055fd, 0x999a00ca, 0x407d0020,
  0xfffeff08, 0x0000ab51, 0xcccd9a62, 0x807c0020,
  0x7fffff81, 0x555555ab, 0x666666ce, 0x003f8020,
  0xffff7f84, 0x000055a9, 0x6666cd32, 0x403e0020,
  0xfffeff86, 0x0000aafd, 0x999a66ca, 0x803d0020,
  0x7ffe7f87, 0x555655a7, 0x00013396, 0xc03c8020,
  0x7fff8003, 0xaaaaffff, 0x00006666, 0x3ffe8020,
  0x7fff0005, 0xaaab5553, 0x3333fffe, 0x7ffd8020,
  0xfffe8006, 0x0000fffd, 0x999accca, 0xbffd0020,
  0x4ccb4cd3, 0x2223221f, 0x8f5d5c26, 0x59968020,
  0xffff8002, 0x00005555, 0x3333999a, 0x3fff0020,
  0x7fff0003, 0x5555ffff, 0x999a6666, 0x7ffe8020,
  0xcccbccd0, 0x77782221, 0x8f5cf5c2, 0x19980020,
  0xf776777b, 0x05b105af, 0xd3a13a06, 0xc4428020,
  0x7fff8001, 0x5555aaab, 0x6666ccce, 0x3fff8020,
  0xcccc4cce, 0x7777cccd, 0x5c295c2a, 0xd9990020,
  0xf776f779, 0x05b0b05b, 0xa06da06e, 0x84438020,
  0xf776f77c, 0x05b0b059, 0x06d406d2, 0x84420020,
  0x4ccccccd, 0x22222223, 0xf5c28f5e, 0x99998020,
  0x77777778, 0xb05b05b1, 0x3a06d3a2, 0x44440020,
  0x7777777b, 0xb05b05af, 0xa06d3a06, 0x44428020,
  0xf777777d, 0x05b05b03, 0x3a06d39e, 0x44418020,
  0x2aaaaaab, 0x8e38e38f, 0x44444446, 0xaaaa8020,
  0x2aaaaaae, 0x8e38e38d, 0xaaaaaaaa, 0xaaa90020,
  0xaaaaaab0, 0xe38e38e1, 0x44444442, 0xaaa80020,
  0xaaaaaab1, 0x8e38e38b, 0x1111110e, 0xaaa78020,
  0x00000003, 0xffffffff, 0x66666666, 0xfffe8020,
  0x80000005, 0x55555553, 0xfffffffe, 0xfffd8020,
  0x80000006, 0xfffffffd, 0xccccccca, 0xfffd0020,
  0x00000006, 0xfffffffd, 0xccccccca, 0xfffd0020,
  0x80000002, 0x55555555, 0x9999999a, 0xffff0020,
  0x80000003, 0xffffffff, 0x66666666, 0xfffe8020,
  0x00000003, 0xffffffff, 0x66666666, 0xfffe8020,
  0x00000002, 0x55555555, 0x9999999a, 0xffff0020,
  0x00000001, 0xaaaaaaab, 0xccccccce, 0xffff8020,
  0x80000001, 0xaaaaaaab, 0xccccccce, 0xffff8020,
  0x80000000, 0x00000001, 0x00000002, 0x00000020,
  0xd5555556, 0x1c71c71d, 0x8888888a, 0x55550020,
  0x80000000, 0x00000001, 0x00000002, 0x00000020,
  0x7fffffff, 0x55555557, 0x33333336, 0x00008020,
  0xd5555555, 0x71c71c73, 0xbbbbbbbe, 0x55558020,
  0x08888889, 0xfa4fa4fb, 0x92c5f92e, 0xbbbb8020,
  0xffffffff, 0x55555557, 0x33333336, 0x00008020,
  0x55555555, 0x71c71c73, 0xbbbbbbbe, 0x55558020,
  0x88888889, 0xfa4fa4fb, 0x92c5f92e, 0xbbbb8020,
  0x88890889, 0x4fa4a4fb, 0xf92bf92e, 0x7bbb8020,
  0x55555556, 0x1c71c71d, 0x8888888a, 0x55550020,
  0x8888888a, 0xa4fa4fa5, 0x5f92c5fa, 0xbbbb0020,
  0x8889088a, 0xfa4f4fa5, 0xc5f8c5fa, 0x7bbb0020,
  0x08898889, 0xa4f9a4fb, 0x5f91f92e, 0x3bbb8020,
  0x33333334, 0x88888889, 0xd70a3d72, 0x66660020,
  0x3333b334, 0xdddd8889, 0x3d703d72, 0x26660020,
  0xb3343333, 0x8887dddf, 0xd70970a6, 0xe6668020,
  0xb334b331, 0x8887888b, 0xa3d5d70e, 0xa6678020,
  0x00008000, 0x55550001, 0x66660002, 0xc0000020,
  0x8000ffff, 0xffff5557, 0xffff3336, 0x80008020,
  0x80017ffd, 0xffff0003, 0xcccb999e, 0x40018020,
  0x0001fffa, 0x55540005, 0xcccb333a, 0x00030020,
  0x80007fff, 0xaaaa5557, 0x99993336, 0xc0008020,
  0x8000fffd, 0xaaaa0003, 0x6665999e, 0x80018020,
  0x00017ffa, 0xffff0005, 0x6665333a, 0x40030020,
  0x0001807a, 0x55545505, 0xcccb993a, 0x3fc30020,
  0x00007ffe, 0xffffaaad, 0xcccc666a, 0xc0010020,
  0x8000fffb, 0x5554aaaf, 0xcccc0006, 0x80028020,
  0x8001007b, 0xaaa9ffaf, 0x33326606, 0x7fc28020,
  0x000100fa, 0x5554aa05, 0xcccbff3a, 0x7f830020,
  0x80007ffd, 0x55550003, 0xffff999e, 0xc0018020,
  0x8000807d, 0xaaaa5503, 0x6665ff9e, 0xbfc18020,
  0x000080fc, 0x5554ff59, 0xffff98d2, 0xbf820020,
  0x0000817a, 0x5554ff05, 0xcccc653a, 0xbf430020,
  0x00000080, 0x55555501, 0x66666602, 0xffc00020,
  0x800000ff, 0xffffff57, 0xffffff36, 0xff808020,
  0x8000017d, 0xffffff03, 0xcccccb9e, 0xff418020,
  0x000001fa, 0x55555405, 0xcccccb3a, 0xff030020,
  0x8000007f, 0xaaaaaa57, 0x99999936, 0xffc08020,
  0x800000fd, 0xaaaaaa03, 0x6666659e, 0xff818020,
  0x0000017a, 0xffffff05, 0x6666653a, 0xff430020,
  0x0000019a, 0x55555445, 0xfffffeba, 0xff330020,
  0x0000007e, 0xffffffad, 0xcccccc6a, 0xffc10020,
  0x800000fb, 0x555554af, 0xcccccc06, 0xff828020,
  0x8000011b, 0xaaaaa9ef, 0x66666586, 0xff728020,
  0x0000011e, 0xaaaaa9ed, 0xcccccbea, 0xff710020,
  0x8000007d, 0x55555503, 0xffffff9e, 0xffc18020,
  0x8000009d, 0xaaaaaa43, 0x9999991e, 0xffb18020,
  0x000000a0, 0xaaaaaa41, 0xffffff82, 0xffb00020,
  0x000000a2, 0xffffff95, 0x9999991a, 0xffaf0020,
  0x00000020, 0x55555541, 0x99999982, 0xfff00020,
  0x80000023, 0x5555553f, 0xffffffe6, 0xffee8020,
  0x80000025, 0xaaaaaa93, 0x9999997e, 0xffed8020,
  0x00000026, 0x5555553d, 0x6666664a, 0xffed0020,
  0xfffffffe, 0x66666665, 0xfffe8002, 0xfffe8023,
  0x55555552, 0xfffffffd, 0xfffd8002, 0xfffd8025,
  0xfffffffc, 0xccccccc9, 0xfffd0002, 0xfffd0026,
  0xfffffffc, 0xccccccc9, 0xfffd0002, 0xfffd0026,
  0x55555554, 0x99999999, 0xffff0002, 0xffff0022,
  0xfffffffe, 0x66666665, 0xfffe8002, 0xfffe8023,
  0xfffffffe, 0x66666665, 0xfffe8002, 0xfffe8023,
  0x55555554, 0x99999999, 0xffff0002, 0xffff0022,
  0xaaaaaaaa, 0xcccccccd, 0xffff8002, 0xffff8021,
  0xaaaaaaaa, 0xcccccccd, 0xffff8002, 0xffff8021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xaaaaaaac, 0x66666669, 0x00010002, 0x0001001e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x55555556, 0x33333335, 0x00008002, 0x0000801f,
  0x00000002, 0x9999999d, 0x00018002, 0x0001801d,
  0xaaaaaac2, 0x0000001d, 0x00118002, 0x00117ffd,
  0x55555556, 0x33333335, 0x00008002, 0x0000801f,
  0x00000002, 0x9999999d, 0x00018002, 0x0001801d,
  0xaaaaaac2, 0x0000001d, 0x00118002, 0x00117ffd,
  0x555555c0, 0x00000081, 0x00500002, 0x004fff80,
  0xaaaaaaac, 0x66666669, 0x00010002, 0x0001001e,
  0x5555556c, 0xcccccce9, 0x00110002, 0x0010fffe,
  0x0000006a, 0xcccccd4d, 0x004f8002, 0x004f7f81,
  0x000000be, 0x000000e5, 0x008e8002, 0x008e7f03,
  0xaaaaaac0, 0x66666681, 0x00100002, 0x00100000,
  0x555555be, 0x666666e5, 0x004e8002, 0x004e7f83,
  0x55555612, 0x99999a7d, 0x008d8002, 0x008d7f05,
  0xaaaaabbc, 0x00000149, 0x00cd0002, 0x00ccfe86,
  0xaaaaaafe, 0x00000065, 0x003e8002, 0x003e7fa3,
  0xaaaaab52, 0x333333fd, 0x007d8002, 0x007d7f25,
  0x000000fc, 0x99999ac9, 0x00bd0002, 0x00bcfea6,
  0xaaab00fa, 0x999a012d, 0x40bb8002, 0x40bafea9,
  0x00000054, 0x33333399, 0x003f0002, 0x003effa2,
  0x555555fe, 0x99999a65, 0x007e8002, 0x007e7f23,
  0x000055fc, 0x999a00c9, 0x407d0002, 0x407c7f26,
  0x0000ab50, 0xcccd9a61, 0x807c0002, 0x807aff28,
  0x555555aa, 0x666666cd, 0x003f8002, 0x003f7fa1,
  0x000055a8, 0x6666cd31, 0x403e0002, 0x403d7fa4,
  0x0000aafc, 0x999a66c9, 0x803d0002, 0x803bffa6,
  0x555655a6, 0x00013395, 0xc03c8002, 0xc03affa7,
  0xaaaafffe, 0x00006665, 0x3ffe8002, 0x3ffe0023,
  0xaaab5552, 0x3333fffd, 0x7ffd8002, 0x7ffc8025,
  0x0000fffc, 0x999accc9, 0xbffd0002, 0xbffb8026,
  0x2223221e, 0x8f5d5c25, 0x59968002, 0x2661ccf3,
  0x00005554, 0x33339999, 0x3fff0002, 0x3ffe8022,
  0x5555fffe, 0x999a6665, 0x7ffe8002, 0x7ffd8023,
  0x77782220, 0x8f5cf5c1, 0x19980002, 0xe663ccf0,
  0x05b105ae, 0xd3a13a05, 0xc4428002, 0x3bb8f79b,
  0x5555aaaa, 0x6666cccd, 0x3fff8002, 0x3fff0021,
  0x7777cccc, 0x5c295c29, 0xd9990002, 0xa6654cee,
  0x05b0b05a, 0xa06da06d, 0x84438002, 0xfbba7799,
  0x05b0b058, 0x06d406d1, 0x84420002, 0x7bb8f79c,
  0x22222222, 0xf5c28f5d, 0x99998002, 0x66664ced,
  0xb05b05b0, 0x3a06d3a1, 0x44440002, 0xbbbb7798,
  0xb05b05ae, 0xa06d3a05, 0x44428002, 0x3bb9f79b,
  0x05b05b02, 0x3a06d39d, 0x44418002, 0xbbb8f79d,
  0x8e38e38e, 0x44444445, 0xaaaa8002, 0x55552acb,
  0x8e38e38c, 0xaaaaaaa9, 0xaaa90002, 0xd553aace,
  0xe38e38e0, 0x44444441, 0xaaa80002, 0x5552aad0,
  0x8e38e38a, 0x1111110d, 0xaaa78002, 0xd5522ad1,
  0xfffffffe, 0x66666665, 0xfffe8002, 0x7ffe8023,
  0x55555552, 0xfffffffd, 0xfffd8002, 0xfffd8025,
  0xfffffffc, 0xccccccc9, 0xfffd0002, 0x7ffd0026,
  0xfffffffc, 0xccccccc9, 0xfffd0002, 0xfffd0026,
  0x55555554, 0x99999999, 0xffff0002, 0x7fff0022,
  0xfffffffe, 0x66666665, 0xfffe8002, 0xfffe8023,
  0xfffffffe, 0x66666665, 0xfffe8002, 0x7ffe8023,
  0x55555554, 0x99999999, 0xffff0002, 0xffff0022,
  0xaaaaaaaa, 0xcccccccd, 0xffff8002, 0x7fff8021,
  0xaaaaaaaa, 0xcccccccd, 0xffff8002, 0xffff8021,
  0x00000000, 0x00000001, 0x00000002, 0x80000020,
  0x1c71c71c, 0x88888889, 0x55550002, 0x2aaa5576,
  0x00000000, 0x00000001, 0x00000002, 0x80000020,
  0x55555556, 0x33333335, 0x00008002, 0x0000801f,
  0x71c71c72, 0xbbbbbbbd, 0x55558002, 0xaaaad575,
  0xfa4fa4fa, 0x92c5f92d, 0xbbbb8002, 0x444408a9,
  0x55555556, 0x33333335, 0x00008002, 0x8000801f,
  0x71c71c72, 0xbbbbbbbd, 0x55558002, 0x2aaad575,
  0xfa4fa4fa, 0x92c5f92d, 0xbbbb8002, 0xc44408a9,
  0x4fa4a4fa, 0xf92bf92d, 0x7bbb8002, 0x844488a9,
  0x1c71c71c, 0x88888889, 0x55550002, 0xaaaa5576,
  0xa4fa4fa4, 0x5f92c5f9, 0xbbbb0002, 0x444388aa,
  0xfa4f4fa4, 0xc5f8c5f9, 0x7bbb0002, 0x044408aa,
  0xa4f9a4fa, 0x5f91f92d, 0x3bbb8002, 0xc44508a9,
  0x88888888, 0xd70a3d71, 0x66660002, 0x99993354,
  0xdddd8888, 0x3d703d71, 0x26660002, 0x5999b354,
  0x8887ddde, 0xd70970a5, 0xe6668002, 0x199ab353,
  0x8887888a, 0xa3d5d70d, 0xa6678002, 0xd99c3351,
  0x55550000, 0x66660001, 0xc0000002, 0xc0008020,
  0xffff5556, 0xffff3335, 0x80008002, 0x8001801f,
  0xffff0002, 0xcccb999d, 0x40018002, 0x4003001d,
  0x55540004, 0xcccb3339, 0x00030002, 0x0005001a,
  0xaaaa5556, 0x99993335, 0xc0008002, 0xc001001f,
  0xaaaa0002, 0x6665999d, 0x80018002, 0x8002801d,
  0xffff0004, 0x66653339, 0x40030002, 0x4004801a,
  0x55545504, 0xcccb9939, 0x3fc30002, 0x3fc4809a,
  0xffffaaac, 0xcccc6669, 0xc0010002, 0xc001801e,
  0x5554aaae, 0xcccc0005, 0x80028002, 0x8003801b,
  0xaaa9ffae, 0x33326605, 0x7fc28002, 0x7fc3809b,
  0x5554aa04, 0xcccbff39, 0x7f830002, 0x7f84011a,
  0x55550002, 0xffff999d, 0xc0018002, 0xc002001d,
  0xaaaa5502, 0x6665ff9d, 0xbfc18002, 0xbfc2009d,
  0x5554ff58, 0xffff98d1, 0xbf820002, 0xbf82811c,
  0x5554ff04, 0xcccc6539, 0xbf430002, 0xbf43819a,
  0x55555500, 0x66666601, 0xffc00002, 0xffc000a0,
  0xffffff56, 0xffffff35, 0xff808002, 0xff80811f,
  0xffffff02, 0xcccccb9d, 0xff418002, 0xff41819d,
  0x55555404, 0xcccccb39, 0xff030002, 0xff03021a,
  0xaaaaaa56, 0x99999935, 0xffc08002, 0xffc0809f,
  0xaaaaaa02, 0x6666659d, 0xff818002, 0xff81811d,
  0xffffff04, 0x66666539, 0xff430002, 0xff43019a,
  0x55555444, 0xfffffeb9, 0xff330002, 0xff3301ba,
  0xffffffac, 0xcccccc69, 0xffc10002, 0xffc1009e,
  0x555554ae, 0xcccccc05, 0xff828002, 0xff82811b,
  0xaaaaa9ee, 0x66666585, 0xff728002, 0xff72813b,
  0xaaaaa9ec, 0xcccccbe9, 0xff710002, 0xff71013e,
  0x55555502, 0xffffff9d, 0xffc18002, 0xffc1809d,
  0xaaaaaa42, 0x9999991d, 0xffb18002, 0xffb180bd,
  0xaaaaaa40, 0xffffff81, 0xffb00002, 0xffb000c0,
  0xffffff94, 0x99999919, 0xffaf0002, 0xffaf00c2,
  0x55555540, 0x99999981, 0xfff00002, 0xfff00040,
  0x5555553e, 0xffffffe5, 0xffee8002, 0xffee8043,
  0xaaaaaa92, 0x9999997d, 0xffed8002, 0xffed8045,
  0x5555553c, 0x66666649, 0xffed0002, 0xffed0046,
  0x66666664, 0xfffe8001, 0xfffe8005, 0xfffe8026,
  0xfffffffc, 0xfffd8001, 0xfffd8007, 0xfffd802a,
  0xccccccc8, 0xfffd0001, 0xfffd0008, 0xfffd002c,
  0xccccccc8, 0xfffd0001, 0xfffd0008, 0xfffd002c,
  0x99999998, 0xffff0001, 0xffff0004, 0xffff0024,
  0x66666664, 0xfffe8001, 0xfffe8005, 0xfffe8026,
  0x66666664, 0xfffe8001, 0xfffe8005, 0xfffe8026,
  0x99999998, 0xffff0001, 0xffff0004, 0xffff0024,
  0xcccccccc, 0xffff8001, 0xffff8003, 0xffff8022,
  0xcccccccc, 0xffff8001, 0xffff8003, 0xffff8022,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x66666668, 0x00010001, 0x00010000, 0x0001001c,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x33333334, 0x00008001, 0x00008001, 0x0000801e,
  0x9999999c, 0x00018001, 0x00017fff, 0x0001801a,
  0x0000001c, 0x00118001, 0x00117fdf, 0x00117fda,
  0x33333334, 0x00008001, 0x00008001, 0x0000801e,
  0x9999999c, 0x00018001, 0x00017fff, 0x0001801a,
  0x0000001c, 0x00118001, 0x00117fdf, 0x00117fda,
  0x00000080, 0x00500001, 0x004fff62, 0x004ffee0,
  0x66666668, 0x00010001, 0x00010000, 0x0001001c,
  0xcccccce8, 0x00110001, 0x0010ffe0, 0x0010ffdc,
  0xcccccd4c, 0x004f8001, 0x004f7f63, 0x004f7ee2,
  0x000000e4, 0x008e8001, 0x008e7ee5, 0x008e7de6,
  0x66666680, 0x00100001, 0x000fffe2, 0x000fffe0,
  0x666666e4, 0x004e8001, 0x004e7f65, 0x004e7ee6,
  0x99999a7c, 0x008d8001, 0x008d7ee7, 0x008d7dea,
  0x00000148, 0x00cd0001, 0x00ccfe68, 0x00ccfcec,
  0x00000064, 0x003e8001, 0x003e7f85, 0x003e7f26,
  0x333333fc, 0x007d8001, 0x007d7f07, 0x007d7e2a,
  0x99999ac8, 0x00bd0001, 0x00bcfe88, 0x00bcfd2c,
  0x999a012c, 0x40bb8001, 0x40bafe8b, 0x40ba7d32,
  0x33333398, 0x003f0001, 0x003eff84, 0x003eff24,
  0x99999a64, 0x007e8001, 0x007e7f05, 0x007e7e26,
  0x999a00c8, 0x407d0001, 0x407c7f08, 0x407bfe2c,
  0xcccd9a60, 0x807c0001, 0x807aff0a, 0x8079fe30,
  0x666666cc, 0x003f8001, 0x003f7f83, 0x003f7f22,
  0x6666cd30, 0x403e0001, 0x403d7f86, 0x403cff28,
  0x999a66c8, 0x803d0001, 0x803bff88, 0x803aff2c,
  0x00013394, 0xc03c8001, 0xc03aff89, 0xc0397f2e,
  0x00006664, 0x3ffe8001, 0x3ffe0005, 0x3ffd8026,
  0x3333fffc, 0x7ffd8001, 0x7ffc8007, 0x7ffb802a,
  0x999accc8, 0xbffd0001, 0xbffb8008, 0xbffa002c,
  0x8f5d5c24, 0x59968001, 0x2661ccd5, 0xf32d19c6,
  0x33339998, 0x3fff0001, 0x3ffe8004, 0x3ffe0024,
  0x999a6664, 0x7ffe8001, 0x7ffd8005, 0x7ffc8026,
  0x8f5cf5c0, 0x19980001, 0xe663ccd2, 0xb32f99c0,
  0xd3a13a04, 0xc4428001, 0x3bb8f77d, 0xb32f6f16,
  0x6666cccc, 0x3fff8001, 0x3fff0003, 0x3ffe8022,
  0x5c295c28, 0xd9990001, 0xa6654cd0, 0x733199bc,
  0xa06da06c, 0x84438001, 0xfbba777b, 0x73316f12,
  0x06d406d0, 0x84420001, 0x7bb8f77e, 0x732fef18,
  0xf5c28f5c, 0x99998001, 0x66664ccf, 0x333319ba,
  0x3a06d3a0, 0x44440001, 0xbbbb777a, 0x3332ef10,
  0xa06d3a04, 0x44428001, 0x3bb9f77d, 0x33316f16,
  0x3a06d39c, 0x44418001, 0xbbb8f77f, 0x33306f1a,
  0x44444444, 0xaaaa8001, 0x55552aad, 0xffffd576,
  0xaaaaaaa8, 0xaaa90001, 0xd553aab0, 0xfffe557c,
  0x44444440, 0xaaa80001, 0x5552aab2, 0xfffd5580,
  0x1111110c, 0xaaa78001, 0xd5522ab3, 0xfffcd582,
  0x66666664, 0xfffe8001, 0x7ffe8005, 0xfffe8026,
  0xfffffffc, 0xfffd8001, 0xfffd8007, 0xfffd802a,
  0xccccccc8, 0xfffd0001, 0x7ffd0008, 0xfffd002c,
  0xccccccc8, 0xfffd0001, 0xfffd0008, 0xfffd002c,
  0x99999998, 0xffff0001, 0x7fff0004, 0xffff0024,
  0x66666664, 0xfffe8001, 0xfffe8005, 0xfffe8026,
  0x66666664, 0xfffe8001, 0x7ffe8005, 0xfffe8026,
  0x99999998, 0xffff0001, 0xffff0004, 0xffff0024,
  0xcccccccc, 0xffff8001, 0x7fff8003, 0xffff8022,
  0xcccccccc, 0xffff8001, 0xffff8003, 0xffff8022,
  0x00000000, 0x00000001, 0x80000002, 0x00000020,
  0x88888888, 0x55550001, 0x2aaa5558, 0xffffaacc,
  0x00000000, 0x00000001, 0x80000002, 0x00000020,
  0x33333334, 0x00008001, 0x00008001, 0x0000801e,
  0xbbbbbbbc, 0x55558001, 0xaaaad557, 0x00002aca,
  0x92c5f92c, 0xbbbb8001, 0x4444088b, 0xcccc9132,
  0x33333334, 0x00008001, 0x80008001, 0x0000801e,
  0xbbbbbbbc, 0x55558001, 0x2aaad557, 0x00002aca,
  0x92c5f92c, 0xbbbb8001, 0xc444088b, 0xcccc9132,
  0xf92bf92c, 0x7bbb8001, 0x8444888b, 0x8ccd9132,
  0x88888888, 0x55550001, 0xaaaa5558, 0xffffaacc,
  0x5f92c5f8, 0xbbbb0001, 0x4443888c, 0xcccc1134,
  0xc5f8c5f8, 0x7bbb0001, 0x0444088c, 0x8ccd1134,
  0x5f91f92c, 0x3bbb8001, 0xc445088b, 0x4cce9132,
  0xd70a3d70, 0x66660001, 0x99993336, 0xcccc6688,
  0x3d703d70, 0x26660001, 0x5999b336, 0x8ccd6688,
  0xd70970a4, 0xe6668001, 0x199ab335, 0x4ccee686,
  0xa3d5d70c, 0xa6678001, 0xd99c3333, 0x0cd0e682,
  0x66660000, 0xc0000001, 0xc0008002, 0xc0010020,
  0xffff3334, 0x80008001, 0x80018001, 0x8002801e,
  0xcccb999c, 0x40018001, 0x4002ffff, 0x4004801a,
  0xcccb3338, 0x00030001, 0x0004fffc, 0x00070014,
  0x99993334, 0xc0008001, 0xc0010001, 0xc001801e,
  0x6665999c, 0x80018001, 0x80027fff, 0x8003801a,
  0x66653338, 0x40030001, 0x40047ffc, 0x40060014,
  0xcccb9938, 0x3fc30001, 0x3fc4807c, 0x3fc60114,
  0xcccc6668, 0xc0010001, 0xc0018000, 0xc002001c,
  0xcccc0004, 0x80028001, 0x80037ffd, 0x80048016,
  0x33326604, 0x7fc28001, 0x7fc3807d, 0x7fc48116,
  0xcccbff38, 0x7f830001, 0x7f8400fc, 0x7f850214,
  0xffff999c, 0xc0018001, 0xc001ffff, 0xc002801a,
  0x6665ff9c, 0xbfc18001, 0xbfc2007f, 0xbfc2811a,
  0xffff98d0, 0xbf820001, 0xbf8280fe, 0xbf830218,
  0xcccc6538, 0xbf430001, 0xbf43817c, 0xbf440314,
  0x66666600, 0xffc00001, 0xffc00082, 0xffc00120,
  0xffffff34, 0xff808001, 0xff808101, 0xff80821e,
  0xcccccb9c, 0xff418001, 0xff41817f, 0xff41831a,
  0xcccccb38, 0xff030001, 0xff0301fc, 0xff030414,
  0x99999934, 0xffc08001, 0xffc08081, 0xffc0811e,
  0x6666659c, 0xff818001, 0xff8180ff, 0xff81821a,
  0x66666538, 0xff430001, 0xff43017c, 0xff430314,
  0xfffffeb8, 0xff330001, 0xff33019c, 0xff330354,
  0xcccccc68, 0xffc10001, 0xffc10080, 0xffc1011c,
  0xcccccc04, 0xff828001, 0xff8280fd, 0xff828216,
  0x66666584, 0xff728001, 0xff72811d, 0xff728256,
  0xcccccbe8, 0xff710001, 0xff710120, 0xff71025c,
  0xffffff9c, 0xffc18001, 0xffc1807f, 0xffc1811a,
  0x9999991c, 0xffb18001, 0xffb1809f, 0xffb1815a,
  0xffffff80, 0xffb00001, 0xffb000a2, 0xffb00160,
  0x99999918, 0xffaf0001, 0xffaf00a4, 0xffaf0164,
  0x99999980, 0xfff00001, 0xfff00022, 0xfff00060,
  0xffffffe4, 0xffee8001, 0xffee8025, 0xffee8066,
  0x9999997c, 0xffed8001, 0xffed8027, 0xffed806a,
  0x66666648, 0xffed0001, 0xffed0028, 0xffed006c,
  0xfffe8000, 0xfffe8004, 0xfffe8008, 0xfffe8029,
  0xfffd8000, 0xfffd8006, 0xfffd800c, 0xfffd802f,
  0xfffd0000, 0xfffd0007, 0xfffd000e, 0xfffd0032,
  0xfffd0000, 0xfffd0007, 0xfffd000e, 0xfffd0032,
  0xffff0000, 0xffff0003, 0xffff0006, 0xffff0026,
  0xfffe8000, 0xfffe8004, 0xfffe8008, 0xfffe8029,
  0xfffe8000, 0xfffe8004, 0xfffe8008, 0xfffe8029,
  0xffff0000, 0xffff0003, 0xffff0006, 0xffff0026,
  0xffff8000, 0xffff8002, 0xffff8004, 0xffff8023,
  0xffff8000, 0xffff8002, 0xffff8004, 0xffff8023,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00010000, 0x0000ffff, 0x0000fffe, 0x0001001a,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00008000, 0x00008000, 0x00008000, 0x0000801d,
  0x00018000, 0x00017ffe, 0x00017ffc, 0x00018017,
  0x00118000, 0x00117fde, 0x00117fbc, 0x00117fb7,
  0x00008000, 0x00008000, 0x00008000, 0x0000801d,
  0x00018000, 0x00017ffe, 0x00017ffc, 0x00018017,
  0x00118000, 0x00117fde, 0x00117fbc, 0x00117fb7,
  0x00500000, 0x004fff61, 0x004ffec2, 0x004ffe40,
  0x00010000, 0x0000ffff, 0x0000fffe, 0x0001001a,
  0x00110000, 0x0010ffdf, 0x0010ffbe, 0x0010ffba,
  0x004f8000, 0x004f7f62, 0x004f7ec4, 0x004f7e43,
  0x008e8000, 0x008e7ee4, 0x008e7dc8, 0x008e7cc9,
  0x00100000, 0x000fffe1, 0x000fffc2, 0x000fffc0,
  0x004e8000, 0x004e7f64, 0x004e7ec8, 0x004e7e49,
  0x008d8000, 0x008d7ee6, 0x008d7dcc, 0x008d7ccf,
  0x00cd0000, 0x00ccfe67, 0x00ccfcce, 0x00ccfb52,
  0x003e8000, 0x003e7f84, 0x003e7f08, 0x003e7ea9,
  0x007d8000, 0x007d7f06, 0x007d7e0c, 0x007d7d2f,
  0x00bd0000, 0x00bcfe87, 0x00bcfd0e, 0x00bcfbb2,
  0x40bb8000, 0x40bafe8a, 0x40ba7d14, 0x40b9fbbb,
  0x003f0000, 0x003eff83, 0x003eff06, 0x003efea6,
  0x007e8000, 0x007e7f04, 0x007e7e08, 0x007e7d29,
  0x407d0000, 0x407c7f07, 0x407bfe0e, 0x407b7d32,
  0x807c0000, 0x807aff09, 0x8079fe12, 0x8078fd38,
  0x003f8000, 0x003f7f82, 0x003f7f04, 0x003f7ea3,
  0x403e0000, 0x403d7f85, 0x403cff0a, 0x403c7eac,
  0x803d0000, 0x803bff87, 0x803aff0e, 0x8039feb2,
  0xc03c8000, 0xc03aff88, 0xc0397f10, 0xc037feb5,
  0x3ffe8000, 0x3ffe0004, 0x3ffd8008, 0x3ffd0029,
  0x7ffd8000, 0x7ffc8006, 0x7ffb800c, 0x7ffa802f,
  0xbffd0000, 0xbffb8007, 0xbffa000e, 0xbff88032,
  0x59968000, 0x2661ccd4, 0xf32d19a8, 0xbff86699,
  0x3fff0000, 0x3ffe8003, 0x3ffe0006, 0x3ffd8026,
  0x7ffe8000, 0x7ffd8004, 0x7ffc8008, 0x7ffb8029,
  0x19980000, 0xe663ccd1, 0xb32f99a2, 0x7ffb6690,
  0xc4428000, 0x3bb8f77c, 0xb32f6ef8, 0x2aa5e691,
  0x3fff8000, 0x3fff0002, 0x3ffe8004, 0x3ffe0023,
  0xd9990000, 0xa6654ccf, 0x7331999e, 0x3ffde68a,
  0x84438000, 0xfbba777a, 0x73316ef4, 0xeaa8668b,
  0x84420000, 0x7bb8f77d, 0x732feefa, 0x6aa6e694,
  0x99998000, 0x66664cce, 0x3333199c, 0xffffe687,
  0x44440000, 0xbbbb7779, 0x3332eef2, 0xaaaa6688,
  0x44428000, 0x3bb9f77c, 0x33316ef8, 0x2aa8e691,
  0x44418000, 0xbbb8f77e, 0x33306efc, 0xaaa7e697,
  0xaaaa8000, 0x55552aac, 0xffffd558, 0xaaaa8021,
  0xaaa90000, 0xd553aaaf, 0xfffe555e, 0x2aa9002a,
  0xaaa80000, 0x5552aab1, 0xfffd5562, 0xaaa80030,
  0xaaa78000, 0xd5522ab2, 0xfffcd564, 0x2aa78033,
  0xfffe8000, 0x7ffe8004, 0xfffe8008, 0x7ffe8029,
  0xfffd8000, 0xfffd8006, 0xfffd800c, 0xfffd802f,
  0xfffd0000, 0x7ffd0007, 0xfffd000e, 0x7ffd0032,
  0xfffd0000, 0xfffd0007, 0xfffd000e, 0xfffd0032,
  0xffff0000, 0x7fff0003, 0xffff0006, 0x7fff0026,
  0xfffe8000, 0xfffe8004, 0xfffe8008, 0xfffe8029,
  0xfffe8000, 0x7ffe8004, 0xfffe8008, 0x7ffe8029,
  0xffff0000, 0xffff0003, 0xffff0006, 0xffff0026,
  0xffff8000, 0x7fff8002, 0xffff8004, 0x7fff8023,
  0xffff8000, 0xffff8002, 0xffff8004, 0xffff8023,
  0x00000000, 0x80000001, 0x00000002, 0x80000020,
  0x55550000, 0x2aaa5557, 0xffffaaae, 0xd5550022,
  0x00000000, 0x80000001, 0x00000002, 0x80000020,
  0x00008000, 0x00008000, 0x00008000, 0x0000801d,
  0x55558000, 0xaaaad556, 0x00002aac, 0x5555801f,
  0xbbbb8000, 0x4444088a, 0xcccc9114, 0x555519bb,
  0x00008000, 0x80008000, 0x00008000, 0x8000801d,
  0x55558000, 0x2aaad556, 0x00002aac, 0xd555801f,
  0xbbbb8000, 0xc444088a, 0xcccc9114, 0xd55519bb,
  0x7bbb8000, 0x8444888a, 0x8ccd9114, 0x955699bb,
  0x55550000, 0xaaaa5557, 0xffffaaae, 0x55550022,
  0xbbbb0000, 0x4443888b, 0xcccc1116, 0x555499be,
  0x7bbb0000, 0x0444088b, 0x8ccd1116, 0x155619be,
  0x3bbb8000, 0xc445088a, 0x4cce9114, 0xd55819bb,
  0x66660000, 0x99993335, 0xcccc666a, 0xffff99bc,
  0x26660000, 0x5999b335, 0x8ccd666a, 0xc00119bc,
  0xe6668000, 0x199ab334, 0x4ccee668, 0x800319b9,
  0xa6678000, 0xd99c3332, 0x0cd0e664, 0x400599b3,
  0xc0000000, 0xc0008001, 0xc0010002, 0xc0018020,
  0x80008000, 0x80018000, 0x80028000, 0x8003801d,
  0x40018000, 0x4002fffe, 0x40047ffc, 0x40060017,
  0x00030000, 0x0004fffb, 0x0006fff6, 0x0009000e,
  0xc0008000, 0xc0010000, 0xc0018000, 0xc002001d,
  0x80018000, 0x80027ffe, 0x80037ffc, 0x80048017,
  0x40030000, 0x40047ffb, 0x4005fff6, 0x4007800e,
  0x3fc30000, 0x3fc4807b, 0x3fc600f6, 0x3fc7818e,
  0xc0010000, 0xc0017fff, 0xc001fffe, 0xc002801a,
  0x80028000, 0x80037ffc, 0x80047ff8, 0x80058011,
  0x7fc28000, 0x7fc3807c, 0x7fc480f8, 0x7fc58191,
  0x7f830000, 0x7f8400fb, 0x7f8501f6, 0x7f86030e,
  0xc0018000, 0xc001fffe, 0xc0027ffc, 0xc0030017,
  0xbfc18000, 0xbfc2007e, 0xbfc280fc, 0xbfc30197,
  0xbf820000, 0xbf8280fd, 0xbf8301fa, 0xbf838314,
  0xbf430000, 0xbf43817b, 0xbf4402f6, 0xbf44848e,
  0xffc00000, 0xffc00081, 0xffc00102, 0xffc001a0,
  0xff808000, 0xff808100, 0xff808200, 0xff80831d,
  0xff418000, 0xff41817e, 0xff4182fc, 0xff418497,
  0xff030000, 0xff0301fb, 0xff0303f6, 0xff03060e,
  0xffc08000, 0xffc08080, 0xffc08100, 0xffc0819d,
  0xff818000, 0xff8180fe, 0xff8181fc, 0xff818317,
  0xff430000, 0xff43017b, 0xff4302f6, 0xff43048e,
  0xff330000, 0xff33019b, 0xff330336, 0xff3304ee,
  0xffc10000, 0xffc1007f, 0xffc100fe, 0xffc1019a,
  0xff828000, 0xff8280fc, 0xff8281f8, 0xff828311,
  0xff728000, 0xff72811c, 0xff728238, 0xff728371,
  0xff710000, 0xff71011f, 0xff71023e, 0xff71037a,
  0xffc18000, 0xffc1807e, 0xffc180fc, 0xffc18197,
  0xffb18000, 0xffb1809e, 0xffb1813c, 0xffb181f7,
  0xffb00000, 0xffb000a1, 0xffb00142, 0xffb00200,
  0xffaf0000, 0xffaf00a3, 0xffaf0146, 0xffaf0206,
  0xfff00000, 0xfff00021, 0xfff00042, 0xfff00080,
  0xffee8000, 0xffee8024, 0xffee8048, 0xffee8089,
  0xffed8000, 0xffed8026, 0xffed804c, 0xffed808f,
  0xffed0000, 0xffed0027, 0xffed004e, 0xffed0092,
  0xfffe8003, 0xfffe8007, 0xfffe800b, 0xfffffea0,
  0xfffd8005, 0xfffd800b, 0xfffd8011, 0xfffffda0,
  0xfffd0006, 0xfffd000d, 0xfffd0014, 0xfffffd20,
  0xfffd0006, 0xfffd000d, 0xfffd0014, 0xfffffd20,
  0xffff0002, 0xffff0005, 0xffff0008, 0xffffff20,
  0xfffe8003, 0xfffe8007, 0xfffe800b, 0xfffffea0,
  0xfffe8003, 0xfffe8007, 0xfffe800b, 0xfffffea0,
  0xffff0002, 0xffff0005, 0xffff0008, 0xffffff20,
  0xffff8001, 0xffff8003, 0xffff8005, 0xffffffa0,
  0xffff8001, 0xffff8003, 0xffff8005, 0xffffffa0,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000fffe, 0x0000fffd, 0x0000fffc, 0x00000120,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00007fff, 0x00007fff, 0x00007fff, 0x000000a0,
  0x00017ffd, 0x00017ffb, 0x00017ff9, 0x000001a0,
  0x00117fdd, 0x00117fbb, 0x00117f99, 0x000011a0,
  0x00007fff, 0x00007fff, 0x00007fff, 0x000000a0,
  0x00017ffd, 0x00017ffb, 0x00017ff9, 0x000001a0,
  0x00117fdd, 0x00117fbb, 0x00117f99, 0x000011a0,
  0x004fff60, 0x004ffec1, 0x004ffe22, 0x00005020,
  0x0000fffe, 0x0000fffd, 0x0000fffc, 0x00000120,
  0x0010ffde, 0x0010ffbd, 0x0010ff9c, 0x00001120,
  0x004f7f61, 0x004f7ec3, 0x004f7e25, 0x00004fa0,
  0x008e7ee3, 0x008e7dc7, 0x008e7cab, 0x00008ea0,
  0x000fffe0, 0x000fffc1, 0x000fffa2, 0x00001020,
  0x004e7f63, 0x004e7ec7, 0x004e7e2b, 0x00004ea0,
  0x008d7ee5, 0x008d7dcb, 0x008d7cb1, 0x00008da0,
  0x00ccfe66, 0x00ccfccd, 0x00ccfb34, 0x0000cd20,
  0x003e7f83, 0x003e7f07, 0x003e7e8b, 0x00003ea0,
  0x007d7f05, 0x007d7e0b, 0x007d7d11, 0x00007da0,
  0x00bcfe86, 0x00bcfd0d, 0x00bcfb94, 0x0000bd20,
  0x40bafe89, 0x40ba7d13, 0x40b9fb9d, 0x0040bba0,
  0x003eff82, 0x003eff05, 0x003efe88, 0x00003f20,
  0x007e7f03, 0x007e7e07, 0x007e7d0b, 0x00007ea0,
  0x407c7f06, 0x407bfe0d, 0x407b7d14, 0x00407d20,
  0x807aff08, 0x8079fe11, 0x8078fd1a, 0x00807c20,
  0x003f7f81, 0x003f7f03, 0x003f7e85, 0x00003fa0,
  0x403d7f84, 0x403cff09, 0x403c7e8e, 0x00403e20,
  0x803bff86, 0x803aff0d, 0x8039fe94, 0x00803d20,
  0xc03aff87, 0xc0397f0f, 0xc037fe97, 0x00c03ca0,
  0x3ffe0003, 0x3ffd8007, 0x3ffd000b, 0x003ffea0,
  0x7ffc8005, 0x7ffb800b, 0x7ffa8011, 0x007ffda0,
  0xbffb8006, 0xbffa000d, 0xbff88014, 0x00bffd20,
  0x2661ccd3, 0xf32d19a7, 0xbff8667b, 0x9a5996a0,
  0x3ffe8002, 0x3ffe0005, 0x3ffd8008, 0x003fff20,
  0x7ffd8003, 0x7ffc8007, 0x7ffb800b, 0x007ffea0,
  0xe663ccd0, 0xb32f99a1, 0x7ffb6672, 0x9a199820,
  0x3bb8f77b, 0xb32f6ef7, 0x2aa5e673, 0x44c442a0,
  0x3fff0001, 0x3ffe8003, 0x3ffe0005, 0x003fffa0,
  0xa6654cce, 0x7331999d, 0x3ffde66c, 0x99d99920,
  0xfbba7779, 0x73316ef3, 0xeaa8666d, 0x448443a0,
  0x7bb8f77c, 0x732feef9, 0x6aa6e676, 0x44844220,
  0x66664ccd, 0x3333199b, 0xffffe669, 0x999999a0,
  0xbbbb7778, 0x3332eef1, 0xaaaa666a, 0x44444420,
  0x3bb9f77b, 0x33316ef7, 0x2aa8e673, 0x444442a0,
  0xbbb8f77d, 0x33306efb, 0xaaa7e679, 0x444441a0,
  0x55552aab, 0xffffd557, 0xaaaa8003, 0xaaaaaaa0,
  0xd553aaae, 0xfffe555d, 0x2aa9000c, 0xaaaaa920,
  0x5552aab0, 0xfffd5561, 0xaaa80012, 0xaaaaa820,
  0xd5522ab1, 0xfffcd563, 0x2aa78015, 0xaaaaa7a0,
  0x7ffe8003, 0xfffe8007, 0x7ffe800b, 0xfffffea0,
  0xfffd8005, 0xfffd800b, 0xfffd8011, 0xfffffda0,
  0x7ffd0006, 0xfffd000d, 0x7ffd0014, 0xfffffd20,
  0xfffd0006, 0xfffd000d, 0xfffd0014, 0xfffffd20,
  0x7fff0002, 0xffff0005, 0x7fff0008, 0xffffff20,
  0xfffe8003, 0xfffe8007, 0xfffe800b, 0xfffffea0,
  0x7ffe8003, 0xfffe8007, 0x7ffe800b, 0xfffffea0,
  0xffff0002, 0xffff0005, 0xffff0008, 0xffffff20,
  0x7fff8001, 0xffff8003, 0x7fff8005, 0xffffffa0,
  0xffff8001, 0xffff8003, 0xffff8005, 0xffffffa0,
  0x80000000, 0x00000001, 0x80000002, 0x00000020,
  0x2aaa5556, 0xffffaaad, 0xd5550004, 0x55555520,
  0x80000000, 0x00000001, 0x80000002, 0x00000020,
  0x00007fff, 0x00007fff, 0x00007fff, 0x000000a0,
  0xaaaad555, 0x00002aab, 0x55558001, 0x555555a0,
  0x44440889, 0xcccc9113, 0x5555199d, 0xbbbbbba0,
  0x80007fff, 0x00007fff, 0x80007fff, 0x000000a0,
  0x2aaad555, 0x00002aab, 0xd5558001, 0x555555a0,
  0xc4440889, 0xcccc9113, 0xd555199d, 0xbbbbbba0,
  0x84448889, 0x8ccd9113, 0x9556999d, 0xbb7bbba0,
  0xaaaa5556, 0xffffaaad, 0x55550004, 0x55555520,
  0x4443888a, 0xcccc1115, 0x555499a0, 0xbbbbbb20,
  0x0444088a, 0x8ccd1115, 0x155619a0, 0xbb7bbb20,
  0xc4450889, 0x4cce9113, 0xd558199d, 0xbb3bbba0,
  0x99993334, 0xcccc6669, 0xffff999e, 0x66666620,
  0x5999b334, 0x8ccd6669, 0xc001199e, 0x66266620,
  0x199ab333, 0x4ccee667, 0x8003199b, 0x65e666a0,
  0xd99c3331, 0x0cd0e663, 0x40059995, 0x65a667a0,
  0xc0008000, 0xc0010001, 0xc0018002, 0xffc00020,
  0x80017fff, 0x80027fff, 0x80037fff, 0xff8000a0,
  0x4002fffd, 0x40047ffb, 0x4005fff9, 0xff4001a0,
  0x0004fffa, 0x0006fff5, 0x0008fff0, 0xff000320,
  0xc000ffff, 0xc0017fff, 0xc001ffff, 0xffc000a0,
  0x80027ffd, 0x80037ffb, 0x80047ff9, 0xff8001a0,
  0x40047ffa, 0x4005fff5, 0x40077ff0, 0xff400320,
  0x3fc4807a, 0x3fc600f5, 0x3fc78170, 0xff3fc320,
  0xc0017ffe, 0xc001fffd, 0xc0027ffc, 0xffc00120,
  0x80037ffb, 0x80047ff7, 0x80057ff3, 0xff8002a0,
  0x7fc3807b, 0x7fc480f7, 0x7fc58173, 0xff7fc2a0,
  0x7f8400fa, 0x7f8501f5, 0x7f8602f0, 0xff7f8320,
  0xc001fffd, 0xc0027ffb, 0xc002fff9, 0xffc001a0,
  0xbfc2007d, 0xbfc280fb, 0xbfc30179, 0xffbfc1a0,
  0xbf8280fc, 0xbf8301f9, 0xbf8382f6, 0xffbf8220,
  0xbf43817a, 0xbf4402f5, 0xbf448470, 0xffbf4320,
  0xffc00080, 0xffc00101, 0xffc00182, 0xffffc020,
  0xff8080ff, 0xff8081ff, 0xff8082ff, 0xffff80a0,
  0xff41817d, 0xff4182fb, 0xff418479, 0xffff41a0,
  0xff0301fa, 0xff0303f5, 0xff0305f0, 0xffff0320,
  0xffc0807f, 0xffc080ff, 0xffc0817f, 0xffffc0a0,
  0xff8180fd, 0xff8181fb, 0xff8182f9, 0xffff81a0,
  0xff43017a, 0xff4302f5, 0xff430470, 0xffff4320,
  0xff33019a, 0xff330335, 0xff3304d0, 0xffff3320,
  0xffc1007e, 0xffc100fd, 0xffc1017c, 0xffffc120,
  0xff8280fb, 0xff8281f7, 0xff8282f3, 0xffff82a0,
  0xff72811b, 0xff728237, 0xff728353, 0xffff72a0,
  0xff71011e, 0xff71023d, 0xff71035c, 0xffff7120,
  0xffc1807d, 0xffc180fb, 0xffc18179, 0xffffc1a0,
  0xffb1809d, 0xffb1813b, 0xffb181d9, 0xffffb1a0,
  0xffb000a0, 0xffb00141, 0xffb001e2, 0xffffb020,
  0xffaf00a2, 0xffaf0145, 0xffaf01e8, 0xffffaf20,
  0xfff00020, 0xfff00041, 0xfff00062, 0xfffff020,
  0xffee8023, 0xffee8047, 0xffee806b, 0xffffeea0,
  0xffed8025, 0xffed804b, 0xffed8071, 0xffffeda0,
  0xffed0026, 0xffed004d, 0xffed0074, 0xffffed20,
  0xfffe8006, 0xfffe800a, 0xfffffe82, 0xfffffea3,
  0xfffd800a, 0xfffd8010, 0xfffffd82, 0xfffffda5,
  0xfffd000c, 0xfffd0013, 0xfffffd02, 0xfffffd26,
  0xfffd000c, 0xfffd0013, 0xfffffd02, 0xfffffd26,
  0xffff0004, 0xffff0007, 0xffffff02, 0xffffff22,
  0xfffe8006, 0xfffe800a, 0xfffffe82, 0xfffffea3,
  0xfffe8006, 0xfffe800a, 0xfffffe82, 0xfffffea3,
  0xffff0004, 0xffff0007, 0xffffff02, 0xffffff22,
  0xffff8002, 0xffff8004, 0xffffff82, 0xffffffa1,
  0xffff8002, 0xffff8004, 0xffffff82, 0xffffffa1,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000fffc, 0x0000fffb, 0x00000102, 0x0000011e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00007ffe, 0x00007ffe, 0x00000082, 0x0000009f,
  0x00017ffa, 0x00017ff8, 0x00000182, 0x0000019d,
  0x00117fba, 0x00117f98, 0x00001182, 0x0000117d,
  0x00007ffe, 0x00007ffe, 0x00000082, 0x0000009f,
  0x00017ffa, 0x00017ff8, 0x00000182, 0x0000019d,
  0x00117fba, 0x00117f98, 0x00001182, 0x0000117d,
  0x004ffec0, 0x004ffe21, 0x00005002, 0x00004f80,
  0x0000fffc, 0x0000fffb, 0x00000102, 0x0000011e,
  0x0010ffbc, 0x0010ff9b, 0x00001102, 0x000010fe,
  0x004f7ec2, 0x004f7e24, 0x00004f82, 0x00004f01,
  0x008e7dc6, 0x008e7caa, 0x00008e82, 0x00008d83,
  0x000fffc0, 0x000fffa1, 0x00001002, 0x00001000,
  0x004e7ec6, 0x004e7e2a, 0x00004e82, 0x00004e03,
  0x008d7dca, 0x008d7cb0, 0x00008d82, 0x00008c85,
  0x00ccfccc, 0x00ccfb33, 0x0000cd02, 0x0000cb86,
  0x003e7f06, 0x003e7e8a, 0x00003e82, 0x00003e23,
  0x007d7e0a, 0x007d7d10, 0x00007d82, 0x00007ca5,
  0x00bcfd0c, 0x00bcfb93, 0x0000bd02, 0x0000bba6,
  0x40ba7d12, 0x40b9fb9c, 0x0040bb82, 0x00403a29,
  0x003eff04, 0x003efe87, 0x00003f02, 0x00003ea2,
  0x007e7e06, 0x007e7d0a, 0x00007e82, 0x00007da3,
  0x407bfe0c, 0x407b7d13, 0x00407d02, 0x003ffc26,
  0x8079fe10, 0x8078fd19, 0x00807c02, 0x007f7b28,
  0x003f7f02, 0x003f7e84, 0x00003f82, 0x00003f21,
  0x403cff08, 0x403c7e8d, 0x00403e02, 0x003fbda4,
  0x803aff0c, 0x8039fe93, 0x00803d02, 0x007f3ca6,
  0xc0397f0e, 0xc037fe96, 0x00c03c82, 0x00bebc27,
  0x3ffd8006, 0x3ffd000a, 0x003ffe82, 0x003f7ea3,
  0x7ffb800a, 0x7ffa8010, 0x007ffd82, 0x007efda5,
  0xbffa000c, 0xbff88013, 0x00bffd02, 0x00be7d26,
  0xf32d19a6, 0xbff8667a, 0x9a599682, 0x6724e373,
  0x3ffe0004, 0x3ffd8007, 0x003fff02, 0x003f7f22,
  0x7ffc8006, 0x7ffb800a, 0x007ffe82, 0x007efea3,
  0xb32f99a0, 0x7ffb6671, 0x9a199802, 0x66e564f0,
  0xb32f6ef6, 0x2aa5e672, 0x44c44282, 0xbc3aba1b,
  0x3ffe8002, 0x3ffe0004, 0x003fff82, 0x003f7fa1,
  0x7331999c, 0x3ffde66b, 0x99d99902, 0x66a5e5ee,
  0x73316ef2, 0xeaa8666c, 0x44844382, 0xbbfb3b19,
  0x732feef8, 0x6aa6e675, 0x44844202, 0x3bfb399c,
  0x3333199a, 0xffffe668, 0x99999982, 0x6666666d,
  0x3332eef0, 0xaaaa6669, 0x44444402, 0xbbbbbb98,
  0x33316ef6, 0x2aa8e672, 0x44444282, 0x3bbbba1b,
  0x33306efa, 0xaaa7e678, 0x44444182, 0xbbbbb91d,
  0xffffd556, 0xaaaa8002, 0xaaaaaa82, 0x5555554b,
  0xfffe555c, 0x2aa9000b, 0xaaaaa902, 0xd55553ce,
  0xfffd5560, 0xaaa80011, 0xaaaaa802, 0x555552d0,
  0xfffcd562, 0x2aa78014, 0xaaaaa782, 0xd5555251,
  0xfffe8006, 0x7ffe800a, 0xfffffe82, 0x7ffffea3,
  0xfffd800a, 0xfffd8010, 0xfffffd82, 0xfffffda5,
  0xfffd000c, 0x7ffd0013, 0xfffffd02, 0x7ffffd26,
  0xfffd000c, 0xfffd0013, 0xfffffd02, 0xfffffd26,
  0xffff0004, 0x7fff0007, 0xffffff02, 0x7fffff22,
  0xfffe8006, 0xfffe800a, 0xfffffe82, 0xfffffea3,
  0xfffe8006, 0x7ffe800a, 0xfffffe82, 0x7ffffea3,
  0xffff0004, 0xffff0007, 0xffffff02, 0xffffff22,
  0xffff8002, 0x7fff8004, 0xffffff82, 0x7fffffa1,
  0xffff8002, 0xffff8004, 0xffffff82, 0xffffffa1,
  0x00000000, 0x80000001, 0x00000002, 0x80000020,
  0xffffaaac, 0xd5550003, 0x55555502, 0x2aaaaa76,
  0x00000000, 0x80000001, 0x00000002, 0x80000020,
  0x00007ffe, 0x00007ffe, 0x00000082, 0x0000009f,
  0x00002aaa, 0x55558000, 0x55555582, 0xaaaaaaf5,
  0xcccc9112, 0x5555199c, 0xbbbbbb82, 0x44444429,
  0x00007ffe, 0x80007ffe, 0x00000082, 0x8000009f,
  0x00002aaa, 0xd5558000, 0x55555582, 0x2aaaaaf5,
  0xcccc9112, 0xd555199c, 0xbbbbbb82, 0xc4444429,
  0x8ccd9112, 0x9556999c, 0xbb7bbb82, 0xc404c429,
  0xffffaaac, 0x55550003, 0x55555502, 0xaaaaaa76,
  0xcccc1114, 0x5554999f, 0xbbbbbb02, 0x444443aa,
  0x8ccd1114, 0x1556199f, 0xbb7bbb02, 0x4404c3aa,
  0x4cce9112, 0xd558199c, 0xbb3bbb82, 0x43c54429,
  0xcccc6668, 0xffff999d, 0x66666602, 0x99999954,
  0x8ccd6668, 0xc001199d, 0x66266602, 0x995a1954,
  0x4ccee666, 0x8003199a, 0x65e66682, 0x991a99d3,
  0x0cd0e662, 0x40059994, 0x65a66782, 0x98db1ad1,
  0xc0010000, 0xc0018001, 0xffc00002, 0xffc08020,
  0x80027ffe, 0x80037ffe, 0xff800082, 0xff81009f,
  0x40047ffa, 0x4005fff8, 0xff400182, 0xff41819d,
  0x0006fff4, 0x0008ffef, 0xff000302, 0xff02031a,
  0xc0017ffe, 0xc001fffe, 0xffc00082, 0xffc0809f,
  0x80037ffa, 0x80047ff8, 0xff800182, 0xff81019d,
  0x4005fff4, 0x40077fef, 0xff400302, 0xff41831a,
  0x3fc600f4, 0x3fc7816f, 0xff3fc302, 0xff41439a,
  0xc001fffc, 0xc0027ffb, 0xffc00102, 0xffc0811e,
  0x80047ff6, 0x80057ff2, 0xff800282, 0xff81029b,
  0x7fc480f6, 0x7fc58172, 0xff7fc282, 0xff80c31b,
  0x7f8501f4, 0x7f8602ef, 0xff7f8302, 0xff80841a,
  0xc0027ffa, 0xc002fff8, 0xffc00182, 0xffc0819d,
  0xbfc280fa, 0xbfc30178, 0xffbfc182, 0xffc0421d,
  0xbf8301f8, 0xbf8382f5, 0xffbf8202, 0xffc0031c,
  0xbf4402f4, 0xbf44846f, 0xffbf4302, 0xffbfc49a,
  0xffc00100, 0xffc00181, 0xffffc002, 0xffffc0a0,
  0xff8081fe, 0xff8082fe, 0xffff8082, 0xffff819f,
  0xff4182fa, 0xff418478, 0xffff4182, 0xffff431d,
  0xff0303f4, 0xff0305ef, 0xffff0302, 0xffff051a,
  0xffc080fe, 0xffc0817e, 0xffffc082, 0xffffc11f,
  0xff8181fa, 0xff8182f8, 0xffff8182, 0xffff829d,
  0xff4302f4, 0xff43046f, 0xffff4302, 0xffff449a,
  0xff330334, 0xff3304cf, 0xffff3302, 0xffff34ba,
  0xffc100fc, 0xffc1017b, 0xffffc102, 0xffffc19e,
  0xff8281f6, 0xff8282f2, 0xffff8282, 0xffff839b,
  0xff728236, 0xff728352, 0xffff7282, 0xffff73bb,
  0xff71023c, 0xff71035b, 0xffff7102, 0xffff723e,
  0xffc180fa, 0xffc18178, 0xffffc182, 0xffffc21d,
  0xffb1813a, 0xffb181d8, 0xffffb182, 0xffffb23d,
  0xffb00140, 0xffb001e1, 0xffffb002, 0xffffb0c0,
  0xffaf0144, 0xffaf01e7, 0xffffaf02, 0xffffafc2,
  0xfff00040, 0xfff00061, 0xfffff002, 0xfffff040,
  0xffee8046, 0xffee806a, 0xffffee82, 0xffffeec3,
  0xffed804a, 0xffed8070, 0xffffed82, 0xffffedc5,
  0xffed004c, 0xffed0073, 0xffffed02, 0xffffed46,
  0xfffe8009, 0xfffffe81, 0xfffffe85, 0xfffffea6,
  0xfffd800f, 0xfffffd81, 0xfffffd87, 0xfffffdaa,
  0xfffd0012, 0xfffffd01, 0xfffffd08, 0xfffffd2c,
  0xfffd0012, 0xfffffd01, 0xfffffd08, 0xfffffd2c,
  0xffff0006, 0xffffff01, 0xffffff04, 0xffffff24,
  0xfffe8009, 0xfffffe81, 0xfffffe85, 0xfffffea6,
  0xfffe8009, 0xfffffe81, 0xfffffe85, 0xfffffea6,
  0xffff0006, 0xffffff01, 0xffffff04, 0xffffff24,
  0xffff8003, 0xffffff81, 0xffffff83, 0xffffffa2,
  0xffff8003, 0xffffff81, 0xffffff83, 0xffffffa2,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000fffa, 0x00000101, 0x00000100, 0x0000011c,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00007ffd, 0x00000081, 0x00000081, 0x0000009e,
  0x00017ff7, 0x00000181, 0x0000017f, 0x0000019a,
  0x00117f97, 0x00001181, 0x0000115f, 0x0000115a,
  0x00007ffd, 0x00000081, 0x00000081, 0x0000009e,
  0x00017ff7, 0x00000181, 0x0000017f, 0x0000019a,
  0x00117f97, 0x00001181, 0x0000115f, 0x0000115a,
  0x004ffe20, 0x00005001, 0x00004f62, 0x00004ee0,
  0x0000fffa, 0x00000101, 0x00000100, 0x0000011c,
  0x0010ff9a, 0x00001101, 0x000010e0, 0x000010dc,
  0x004f7e23, 0x00004f81, 0x00004ee3, 0x00004e62,
  0x008e7ca9, 0x00008e81, 0x00008d65, 0x00008c66,
  0x000fffa0, 0x00001001, 0x00000fe2, 0x00000fe0,
  0x004e7e29, 0x00004e81, 0x00004de5, 0x00004d66,
  0x008d7caf, 0x00008d81, 0x00008c67, 0x00008b6a,
  0x00ccfb32, 0x0000cd01, 0x0000cb68, 0x0000c9ec,
  0x003e7e89, 0x00003e81, 0x00003e05, 0x00003da6,
  0x007d7d0f, 0x00007d81, 0x00007c87, 0x00007baa,
  0x00bcfb92, 0x0000bd01, 0x0000bb88, 0x0000ba2c,
  0x40b9fb9b, 0x0040bb81, 0x00403a0b, 0x003fb8b2,
  0x003efe86, 0x00003f01, 0x00003e84, 0x00003e24,
  0x007e7d09, 0x00007e81, 0x00007d85, 0x00007ca6,
  0x407b7d12, 0x00407d01, 0x003ffc08, 0x003f7b2c,
  0x8078fd18, 0x00807c01, 0x007f7b0a, 0x007e7a30,
  0x003f7e83, 0x00003f81, 0x00003f03, 0x00003ea2,
  0x403c7e8c, 0x00403e01, 0x003fbd86, 0x003f3d28,
  0x8039fe92, 0x00803d01, 0x007f3c88, 0x007e3c2c,
  0xc037fe95, 0x00c03c81, 0x00bebc09, 0x00bd3bae,
  0x3ffd0009, 0x003ffe81, 0x003f7e85, 0x003efea6,
  0x7ffa800f, 0x007ffd81, 0x007efd87, 0x007dfdaa,
  0xbff88012, 0x00bffd01, 0x00be7d08, 0x00bcfd2c,
  0xbff86679, 0x9a599681, 0x6724e355, 0x33f03046,
  0x3ffd8006, 0x003fff01, 0x003f7f04, 0x003eff24,
  0x7ffb8009, 0x007ffe81, 0x007efe85, 0x007dfea6,
  0x7ffb6670, 0x9a199801, 0x66e564d2, 0x33b131c0,
  0x2aa5e671, 0x44c44281, 0xbc3ab9fd, 0x33b13196,
  0x3ffe0003, 0x003fff81, 0x003f7f83, 0x003effa2,
  0x3ffde66a, 0x99d99901, 0x66a5e5d0, 0x337232bc,
  0xeaa8666b, 0x44844381, 0xbbfb3afb, 0x33723292,
  0x6aa6e674, 0x44844201, 0x3bfb397e, 0x33723118,
  0xffffe667, 0x99999981, 0x6666664f, 0x3333333a,
  0xaaaa6668, 0x44444401, 0xbbbbbb7a, 0x33333310,
  0x2aa8e671, 0x44444281, 0x3bbbb9fd, 0x33333196,
  0xaaa7e677, 0x44444181, 0xbbbbb8ff, 0x3333309a,
  0xaaaa8001, 0xaaaaaa81, 0x5555552d, 0xfffffff6,
  0x2aa9000a, 0xaaaaa901, 0xd55553b0, 0xfffffe7c,
  0xaaa80010, 0xaaaaa801, 0x555552b2, 0xfffffd80,
  0x2aa78013, 0xaaaaa781, 0xd5555233, 0xfffffd02,
  0x7ffe8009, 0xfffffe81, 0x7ffffe85, 0xfffffea6,
  0xfffd800f, 0xfffffd81, 0xfffffd87, 0xfffffdaa,
  0x7ffd0012, 0xfffffd01, 0x7ffffd08, 0xfffffd2c,
  0xfffd0012, 0xfffffd01, 0xfffffd08, 0xfffffd2c,
  0x7fff0006, 0xffffff01, 0x7fffff04, 0xffffff24,
  0xfffe8009, 0xfffffe81, 0xfffffe85, 0xfffffea6,
  0x7ffe8009, 0xfffffe81, 0x7ffffe85, 0xfffffea6,
  0xffff0006, 0xffffff01, 0xffffff04, 0xffffff24,
  0x7fff8003, 0xffffff81, 0x7fffff83, 0xffffffa2,
  0xffff8003, 0xffffff81, 0xffffff83, 0xffffffa2,
  0x80000000, 0x00000001, 0x80000002, 0x00000020,
  0xd5550002, 0x55555501, 0x2aaaaa58, 0xffffffcc,
  0x80000000, 0x00000001, 0x80000002, 0x00000020,
  0x00007ffd, 0x00000081, 0x00000081, 0x0000009e,
  0x55557fff, 0x55555581, 0xaaaaaad7, 0x0000004a,
  0x5555199b, 0xbbbbbb81, 0x4444440b, 0xccccccb2,
  0x80007ffd, 0x00000081, 0x80000081, 0x0000009e,
  0xd5557fff, 0x55555581, 0x2aaaaad7, 0x0000004a,
  0xd555199b, 0xbbbbbb81, 0xc444440b, 0xccccccb2,
  0x9556999b, 0xbb7bbb81, 0xc404c40b, 0xcc8dccb2,
  0x55550002, 0x55555501, 0xaaaaaa58, 0xffffffcc,
  0x5554999e, 0xbbbbbb01, 0x4444438c, 0xcccccc34,
  0x1556199e, 0xbb7bbb01, 0x4404c38c, 0xcc8dcc34,
  0xd558199b, 0xbb3bbb81, 0x43c5440b, 0xcc4eccb2,
  0xffff999c, 0x66666601, 0x99999936, 0xcccccc88,
  0xc001199c, 0x66266601, 0x995a1936, 0xcc8dcc88,
  0x80031999, 0x65e66681, 0x991a99b5, 0xcc4ecd06,
  0x40059993, 0x65a66781, 0x98db1ab3, 0xcc0fce02,
  0xc0018000, 0xffc00001, 0xffc08002, 0xffc10020,
  0x80037ffd, 0xff800081, 0xff810081, 0xff82009e,
  0x4005fff7, 0xff400181, 0xff41817f, 0xff43019a,
  0x0008ffee, 0xff000301, 0xff0202fc, 0xff040314,
  0xc001fffd, 0xffc00081, 0xffc08081, 0xffc1009e,
  0x80047ff7, 0xff800181, 0xff81017f, 0xff82019a,
  0x40077fee, 0xff400301, 0xff4182fc, 0xff430314,
  0x3fc7816e, 0xff3fc301, 0xff41437c, 0xff42c414,
  0xc0027ffa, 0xffc00101, 0xffc08100, 0xffc1011c,
  0x80057ff1, 0xff800281, 0xff81027d, 0xff820296,
  0x7fc58171, 0xff7fc281, 0xff80c2fd, 0xff81c396,
  0x7f8602ee, 0xff7f8301, 0xff8083fc, 0xff818514,
  0xc002fff7, 0xffc00181, 0xffc0817f, 0xffc1019a,
  0xbfc30177, 0xffbfc181, 0xffc041ff, 0xffc0c29a,
  0xbf8382f4, 0xffbf8201, 0xffc002fe, 0xffc08418,
  0xbf44846e, 0xffbf4301, 0xffbfc47c, 0xffc04614,
  0xffc00180, 0xffffc001, 0xffffc082, 0xffffc120,
  0xff8082fd, 0xffff8081, 0xffff8181, 0xffff829e,
  0xff418477, 0xffff4181, 0xffff42ff, 0xffff449a,
  0xff0305ee, 0xffff0301, 0xffff04fc, 0xffff0714,
  0xffc0817d, 0xffffc081, 0xffffc101, 0xffffc19e,
  0xff8182f7, 0xffff8181, 0xffff827f, 0xffff839a,
  0xff43046e, 0xffff4301, 0xffff447c, 0xffff4614,
  0xff3304ce, 0xffff3301, 0xffff349c, 0xffff3654,
  0xffc1017a, 0xffffc101, 0xffffc180, 0xffffc21c,
  0xff8282f1, 0xffff8281, 0xffff837d, 0xffff8496,
  0xff728351, 0xffff7281, 0xffff739d, 0xffff74d6,
  0xff71035a, 0xffff7101, 0xffff7220, 0xffff735c,
  0xffc18177, 0xffffc181, 0xffffc1ff, 0xffffc29a,
  0xffb181d7, 0xffffb181, 0xffffb21f, 0xffffb2da,
  0xffb001e0, 0xffffb001, 0xffffb0a2, 0xffffb160,
  0xffaf01e6, 0xffffaf01, 0xffffafa4, 0xffffb064,
  0xfff00060, 0xfffff001, 0xfffff022, 0xfffff060,
  0xffee8069, 0xffffee81, 0xffffeea5, 0xffffeee6,
  0xffed806f, 0xffffed81, 0xffffeda7, 0xffffedea,
  0xffed0072, 0xffffed01, 0xffffed28, 0xffffed6c,
  0xfffffe80, 0xfffffe84, 0xfffffe88, 0xfffffea9,
  0xfffffd80, 0xfffffd86, 0xfffffd8c, 0xfffffdaf,
  0xfffffd00, 0xfffffd07, 0xfffffd0e, 0xfffffd32,
  0xfffffd00, 0xfffffd07, 0xfffffd0e, 0xfffffd32,
  0xffffff00, 0xffffff03, 0xffffff06, 0xffffff26,
  0xfffffe80, 0xfffffe84, 0xfffffe88, 0xfffffea9,
  0xfffffe80, 0xfffffe84, 0xfffffe88, 0xfffffea9,
  0xffffff00, 0xffffff03, 0xffffff06, 0xffffff26,
  0xffffff80, 0xffffff82, 0xffffff84, 0xffffffa3,
  0xffffff80, 0xffffff82, 0xffffff84, 0xffffffa3,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000100, 0x000000ff, 0x000000fe, 0x0000011a,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000080, 0x00000080, 0x00000080, 0x0000009d,
  0x00000180, 0x0000017e, 0x0000017c, 0x00000197,
  0x00001180, 0x0000115e, 0x0000113c, 0x00001137,
  0x00000080, 0x00000080, 0x00000080, 0x0000009d,
  0x00000180, 0x0000017e, 0x0000017c, 0x00000197,
  0x00001180, 0x0000115e, 0x0000113c, 0x00001137,
  0x00005000, 0x00004f61, 0x00004ec2, 0x00004e40,
  0x00000100, 0x000000ff, 0x000000fe, 0x0000011a,
  0x00001100, 0x000010df, 0x000010be, 0x000010ba,
  0x00004f80, 0x00004ee2, 0x00004e44, 0x00004dc3,
  0x00008e80, 0x00008d64, 0x00008c48, 0x00008b49,
  0x00001000, 0x00000fe1, 0x00000fc2, 0x00000fc0,
  0x00004e80, 0x00004de4, 0x00004d48, 0x00004cc9,
  0x00008d80, 0x00008c66, 0x00008b4c, 0x00008a4f,
  0x0000cd00, 0x0000cb67, 0x0000c9ce, 0x0000c852,
  0x00003e80, 0x00003e04, 0x00003d88, 0x00003d29,
  0x00007d80, 0x00007c86, 0x00007b8c, 0x00007aaf,
  0x0000bd00, 0x0000bb87, 0x0000ba0e, 0x0000b8b2,
  0x0040bb80, 0x00403a0a, 0x003fb894, 0x003f373b,
  0x00003f00, 0x00003e83, 0x00003e06, 0x00003da6,
  0x00007e80, 0x00007d84, 0x00007c88, 0x00007ba9,
  0x00407d00, 0x003ffc07, 0x003f7b0e, 0x003efa32,
  0x00807c00, 0x007f7b09, 0x007e7a12, 0x007d7938,
  0x00003f80, 0x00003f02, 0x00003e84, 0x00003e23,
  0x00403e00, 0x003fbd85, 0x003f3d0a, 0x003ebcac,
  0x00803d00, 0x007f3c87, 0x007e3c0e, 0x007d3bb2,
  0x00c03c80, 0x00bebc08, 0x00bd3b90, 0x00bbbb35,
  0x003ffe80, 0x003f7e84, 0x003efe88, 0x003e7ea9,
  0x007ffd80, 0x007efd86, 0x007dfd8c, 0x007cfdaf,
  0x00bffd00, 0x00be7d07, 0x00bcfd0e, 0x00bb7d32,
  0x9a599680, 0x6724e354, 0x33f03028, 0x00bb7d19,
  0x003fff00, 0x003f7f03, 0x003eff06, 0x003e7f26,
  0x007ffe80, 0x007efe84, 0x007dfe88, 0x007cfea9,
  0x9a199800, 0x66e564d1, 0x33b131a2, 0x007cfe90,
  0x44c44280, 0xbc3ab9fc, 0x33b13178, 0xab27a911,
  0x003fff80, 0x003f7f82, 0x003eff84, 0x003e7fa3,
  0x99d99900, 0x66a5e5cf, 0x3372329e, 0x003e7f8a,
  0x44844380, 0xbbfb3afa, 0x33723274, 0xaae92a0b,
  0x44844200, 0x3bfb397d, 0x337230fa, 0x2ae92894,
  0x99999980, 0x6666664e, 0x3333331c, 0x00000007,
  0x44444400, 0xbbbbbb79, 0x333332f2, 0xaaaaaa88,
  0x44444280, 0x3bbbb9fc, 0x33333178, 0x2aaaa911,
  0x44444180, 0xbbbbb8fe, 0x3333307c, 0xaaaaa817,
  0xaaaaaa80, 0x5555552c, 0xffffffd8, 0xaaaaaaa1,
  0xaaaaa900, 0xd55553af, 0xfffffe5e, 0x2aaaa92a,
  0xaaaaa800, 0x555552b1, 0xfffffd62, 0xaaaaa830,
  0xaaaaa780, 0xd5555232, 0xfffffce4, 0x2aaaa7b3,
  0xfffffe80, 0x7ffffe84, 0xfffffe88, 0x7ffffea9,
  0xfffffd80, 0xfffffd86, 0xfffffd8c, 0xfffffdaf,
  0xfffffd00, 0x7ffffd07, 0xfffffd0e, 0x7ffffd32,
  0xfffffd00, 0xfffffd07, 0xfffffd0e, 0xfffffd32,
  0xffffff00, 0x7fffff03, 0xffffff06, 0x7fffff26,
  0xfffffe80, 0xfffffe84, 0xfffffe88, 0xfffffea9,
  0xfffffe80, 0x7ffffe84, 0xfffffe88, 0x7ffffea9,
  0xffffff00, 0xffffff03, 0xffffff06, 0xffffff26,
  0xffffff80, 0x7fffff82, 0xffffff84, 0x7fffffa3,
  0xffffff80, 0xffffff82, 0xffffff84, 0xffffffa3,
  0x00000000, 0x80000001, 0x00000002, 0x80000020,
  0x55555500, 0x2aaaaa57, 0xffffffae, 0xd5555522,
  0x00000000, 0x80000001, 0x00000002, 0x80000020,
  0x00000080, 0x00000080, 0x00000080, 0x0000009d,
  0x55555580, 0xaaaaaad6, 0x0000002c, 0x5555559f,
  0xbbbbbb80, 0x4444440a, 0xcccccc94, 0x5555553b,
  0x00000080, 0x80000080, 0x00000080, 0x8000009d,
  0x55555580, 0x2aaaaad6, 0x0000002c, 0xd555559f,
  0xbbbbbb80, 0xc444440a, 0xcccccc94, 0xd555553b,
  0xbb7bbb80, 0xc404c40a, 0xcc8dcc94, 0xd516d53b,
  0x55555500, 0xaaaaaa57, 0xffffffae, 0x55555522,
  0xbbbbbb00, 0x4444438b, 0xcccccc16, 0x555554be,
  0xbb7bbb00, 0x4404c38b, 0xcc8dcc16, 0x5516d4be,
  0xbb3bbb80, 0x43c5440a, 0xcc4ecc94, 0x54d8553b,
  0x66666600, 0x99999935, 0xcccccc6a, 0xffffffbc,
  0x66266600, 0x995a1935, 0xcc8dcc6a, 0xffc17fbc,
  0x65e66680, 0x991a99b4, 0xcc4ecce8, 0xff830039,
  0x65a66780, 0x98db1ab2, 0xcc0fcde4, 0xff448133,
  0xffc00000, 0xffc08001, 0xffc10002, 0xffc18020,
  0xff800080, 0xff810080, 0xff820080, 0xff83009d,
  0xff400180, 0xff41817e, 0xff43017c, 0xff448197,
  0xff000300, 0xff0202fb, 0xff0402f6, 0xff06030e,
  0xffc00080, 0xffc08080, 0xffc10080, 0xffc1809d,
  0xff800180, 0xff81017e, 0xff82017c, 0xff830197,
  0xff400300, 0xff4182fb, 0xff4302f6, 0xff44830e,
  0xff3fc300, 0xff41437b, 0xff42c3f6, 0xff44448e,
  0xffc00100, 0xffc080ff, 0xffc100fe, 0xffc1811a,
  0xff800280, 0xff81027c, 0xff820278, 0xff830291,
  0xff7fc280, 0xff80c2fc, 0xff81c378, 0xff82c411,
  0xff7f8300, 0xff8083fb, 0xff8184f6, 0xff82860e,
  0xffc00180, 0xffc0817e, 0xffc1017c, 0xffc18197,
  0xffbfc180, 0xffc041fe, 0xffc0c27c, 0xffc14317,
  0xffbf8200, 0xffc002fd, 0xffc083fa, 0xffc10514,
  0xffbf4300, 0xffbfc47b, 0xffc045f6, 0xffc0c78e,
  0xffffc000, 0xffffc081, 0xffffc102, 0xffffc1a0,
  0xffff8080, 0xffff8180, 0xffff8280, 0xffff839d,
  0xffff4180, 0xffff42fe, 0xffff447c, 0xffff4617,
  0xffff0300, 0xffff04fb, 0xffff06f6, 0xffff090e,
  0xffffc080, 0xffffc100, 0xffffc180, 0xffffc21d,
  0xffff8180, 0xffff827e, 0xffff837c, 0xffff8497,
  0xffff4300, 0xffff447b, 0xffff45f6, 0xffff478e,
  0xffff3300, 0xffff349b, 0xffff3636, 0xffff37ee,
  0xffffc100, 0xffffc17f, 0xffffc1fe, 0xffffc29a,
  0xffff8280, 0xffff837c, 0xffff8478, 0xffff8591,
  0xffff7280, 0xffff739c, 0xffff74b8, 0xffff75f1,
  0xffff7100, 0xffff721f, 0xffff733e, 0xffff747a,
  0xffffc180, 0xffffc1fe, 0xffffc27c, 0xffffc317,
  0xffffb180, 0xffffb21e, 0xffffb2bc, 0xffffb377,
  0xffffb000, 0xffffb0a1, 0xffffb142, 0xffffb200,
  0xffffaf00, 0xffffafa3, 0xffffb046, 0xffffb106,
  0xfffff000, 0xfffff021, 0xfffff042, 0xfffff080,
  0xffffee80, 0xffffeea4, 0xffffeec8, 0xffffef09,
  0xffffed80, 0xffffeda6, 0xffffedcc, 0xffffee0f,
  0xffffed00, 0xffffed27, 0xffffed4e, 0xffffed92,
  0xfffffe83, 0xfffffe87, 0xfffffe8b, 0xffffffc0,
  0xfffffd85, 0xfffffd8b, 0xfffffd91, 0xffffff80,
  0xfffffd06, 0xfffffd0d, 0xfffffd14, 0xffffff60,
  0xfffffd06, 0xfffffd0d, 0xfffffd14, 0xffffff60,
  0xffffff02, 0xffffff05, 0xffffff08, 0xffffffe0,
  0xfffffe83, 0xfffffe87, 0xfffffe8b, 0xffffffc0,
  0xfffffe83, 0xfffffe87, 0xfffffe8b, 0xffffffc0,
  0xffffff02, 0xffffff05, 0xffffff08, 0xffffffe0,
  0xffffff81, 0xffffff83, 0xffffff85, 0x00000000,
  0xffffff81, 0xffffff83, 0xffffff85, 0x00000000,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x000000fe, 0x000000fd, 0x000000fc, 0x00000060,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000007f, 0x0000007f, 0x0000007f, 0x00000040,
  0x0000017d, 0x0000017b, 0x00000179, 0x00000080,
  0x0000115d, 0x0000113b, 0x00001119, 0x00000480,
  0x0000007f, 0x0000007f, 0x0000007f, 0x00000040,
  0x0000017d, 0x0000017b, 0x00000179, 0x00000080,
  0x0000115d, 0x0000113b, 0x00001119, 0x00000480,
  0x00004f60, 0x00004ec1, 0x00004e22, 0x00001420,
  0x000000fe, 0x000000fd, 0x000000fc, 0x00000060,
  0x000010de, 0x000010bd, 0x0000109c, 0x00000460,
  0x00004ee1, 0x00004e43, 0x00004da5, 0x00001400,
  0x00008d63, 0x00008c47, 0x00008b2b, 0x000023c0,
  0x00000fe0, 0x00000fc1, 0x00000fa2, 0x00000420,
  0x00004de3, 0x00004d47, 0x00004cab, 0x000013c0,
  0x00008c65, 0x00008b4b, 0x00008a31, 0x00002380,
  0x0000cb66, 0x0000c9cd, 0x0000c834, 0x00003360,
  0x00003e03, 0x00003d87, 0x00003d0b, 0x00000fc0,
  0x00007c85, 0x00007b8b, 0x00007a91, 0x00001f80,
  0x0000bb86, 0x0000ba0d, 0x0000b894, 0x00002f60,
  0x00403a09, 0x003fb893, 0x003f371d, 0x00102f00,
  0x00003e82, 0x00003e05, 0x00003d88, 0x00000fe0,
  0x00007d83, 0x00007c87, 0x00007b8b, 0x00001fc0,
  0x003ffc06, 0x003f7b0d, 0x003efa14, 0x00101f60,
  0x007f7b08, 0x007e7a11, 0x007d791a, 0x00201f20,
  0x00003f01, 0x00003e83, 0x00003e05, 0x00001000,
  0x003fbd84, 0x003f3d09, 0x003ebc8e, 0x00100fa0,
  0x007f3c86, 0x007e3c0d, 0x007d3b94, 0x00200f60,
  0x00bebc07, 0x00bd3b8f, 0x00bbbb17, 0x00300f40,
  0x003f7e83, 0x003efe87, 0x003e7e8b, 0x000fffc0,
  0x007efd85, 0x007dfd8b, 0x007cfd91, 0x001fff80,
  0x00be7d06, 0x00bcfd0d, 0x00bb7d14, 0x002fff60,
  0x6724e353, 0x33f03027, 0x00bb7cfb, 0x669665c0,
  0x003f7f02, 0x003eff05, 0x003e7f08, 0x000fffe0,
  0x007efe83, 0x007dfe87, 0x007cfe8b, 0x001fffc0,
  0x66e564d0, 0x33b131a1, 0x007cfe72, 0x66866620,
  0xbc3ab9fb, 0x33b13177, 0xab27a8f3, 0x113110c0,
  0x003f7f81, 0x003eff83, 0x003e7f85, 0x00100000,
  0x66a5e5ce, 0x3372329d, 0x003e7f6c, 0x66766660,
  0xbbfb3af9, 0x33723273, 0xaae929ed, 0x11211100,
  0x3bfb397c, 0x337230f9, 0x2ae92876, 0x112110a0,
  0x6666664d, 0x3333331b, 0xffffffe9, 0x66666680,
  0xbbbbbb78, 0x333332f1, 0xaaaaaa6a, 0x11111120,
  0x3bbbb9fb, 0x33333177, 0x2aaaa8f3, 0x111110c0,
  0xbbbbb8fd, 0x3333307b, 0xaaaaa7f9, 0x11111080,
  0x5555552b, 0xffffffd7, 0xaaaaaa83, 0xaaaaaac0,
  0xd55553ae, 0xfffffe5d, 0x2aaaa90c, 0xaaaaaa60,
  0x555552b0, 0xfffffd61, 0xaaaaa812, 0xaaaaaa20,
  0xd5555231, 0xfffffce3, 0x2aaaa795, 0xaaaaaa00,
  0x7ffffe83, 0xfffffe87, 0x7ffffe8b, 0xffffffc0,
  0xfffffd85, 0xfffffd8b, 0xfffffd91, 0xffffff80,
  0x7ffffd06, 0xfffffd0d, 0x7ffffd14, 0xffffff60,
  0xfffffd06, 0xfffffd0d, 0xfffffd14, 0xffffff60,
  0x7fffff02, 0xffffff05, 0x7fffff08, 0xffffffe0,
  0xfffffe83, 0xfffffe87, 0xfffffe8b, 0xffffffc0,
  0x7ffffe83, 0xfffffe87, 0x7ffffe8b, 0xffffffc0,
  0xffffff02, 0xffffff05, 0xffffff08, 0xffffffe0,
  0x7fffff81, 0xffffff83, 0x7fffff85, 0x00000000,
  0xffffff81, 0xffffff83, 0xffffff85, 0x00000000,
  0x80000000, 0x00000001, 0x80000002, 0x00000020,
  0x2aaaaa56, 0xffffffad, 0xd5555504, 0x55555560,
  0x80000000, 0x00000001, 0x80000002, 0x00000020,
  0x0000007f, 0x0000007f, 0x0000007f, 0x00000040,
  0xaaaaaad5, 0x0000002b, 0x55555581, 0x55555580,
  0x44444409, 0xcccccc93, 0x5555551d, 0xeeeeef00,
  0x8000007f, 0x0000007f, 0x8000007f, 0x00000040,
  0x2aaaaad5, 0x0000002b, 0xd5555581, 0x55555580,
  0xc4444409, 0xcccccc93, 0xd555551d, 0xeeeeef00,
  0xc404c409, 0xcc8dcc93, 0xd516d51d, 0xeedeef00,
  0xaaaaaa56, 0xffffffad, 0x55555504, 0x55555560,
  0x4444438a, 0xcccccc15, 0x555554a0, 0xeeeeeee0,
  0x4404c38a, 0xcc8dcc15, 0x5516d4a0, 0xeedeeee0,
  0x43c54409, 0xcc4ecc93, 0x54d8551d, 0xeeceef00,
  0x99999934, 0xcccccc69, 0xffffff9e, 0x999999a0,
  0x995a1934, 0xcc8dcc69, 0xffc17f9e, 0x998999a0,
  0x991a99b3, 0xcc4ecce7, 0xff83001b, 0x997999c0,
  0x98db1ab1, 0xcc0fcde3, 0xff448115, 0x99699a00,
  0xffc08000, 0xffc10001, 0xffc18002, 0xfff00020,
  0xff81007f, 0xff82007f, 0xff83007f, 0xffe00040,
  0xff41817d, 0xff43017b, 0xff448179, 0xffd00080,
  0xff0202fa, 0xff0402f5, 0xff0602f0, 0xffc000e0,
  0xffc0807f, 0xffc1007f, 0xffc1807f, 0xfff00040,
  0xff81017d, 0xff82017b, 0xff830179, 0xffe00080,
  0xff4182fa, 0xff4302f5, 0xff4482f0, 0xffd000e0,
  0xff41437a, 0xff42c3f5, 0xff444470, 0xffcff0e0,
  0xffc080fe, 0xffc100fd, 0xffc180fc, 0xfff00060,
  0xff81027b, 0xff820277, 0xff830273, 0xffe000c0,
  0xff80c2fb, 0xff81c377, 0xff82c3f3, 0xffdff0c0,
  0xff8083fa, 0xff8184f5, 0xff8285f0, 0xffdfe0e0,
  0xffc0817d, 0xffc1017b, 0xffc18179, 0xfff00080,
  0xffc041fd, 0xffc0c27b, 0xffc142f9, 0xffeff080,
  0xffc002fc, 0xffc083f9, 0xffc104f6, 0xffefe0a0,
  0xffbfc47a, 0xffc045f5, 0xffc0c770, 0xffefd0e0,
  0xffffc080, 0xffffc101, 0xffffc182, 0xfffff020,
  0xffff817f, 0xffff827f, 0xffff837f, 0xffffe040,
  0xffff42fd, 0xffff447b, 0xffff45f9, 0xffffd080,
  0xffff04fa, 0xffff06f5, 0xffff08f0, 0xffffc0e0,
  0xffffc0ff, 0xffffc17f, 0xffffc1ff, 0xfffff040,
  0xffff827d, 0xffff837b, 0xffff8479, 0xffffe080,
  0xffff447a, 0xffff45f5, 0xffff4770, 0xffffd0e0,
  0xffff349a, 0xffff3635, 0xffff37d0, 0xffffcce0,
  0xffffc17e, 0xffffc1fd, 0xffffc27c, 0xfffff060,
  0xffff837b, 0xffff8477, 0xffff8573, 0xffffe0c0,
  0xffff739b, 0xffff74b7, 0xffff75d3, 0xffffdcc0,
  0xffff721e, 0xffff733d, 0xffff745c, 0xffffdc60,
  0xffffc1fd, 0xffffc27b, 0xffffc2f9, 0xfffff080,
  0xffffb21d, 0xffffb2bb, 0xffffb359, 0xffffec80,
  0xffffb0a0, 0xffffb141, 0xffffb1e2, 0xffffec20,
  0xffffafa2, 0xffffb045, 0xffffb0e8, 0xffffebe0,
  0xfffff020, 0xfffff041, 0xfffff062, 0xfffffc20,
  0xffffeea3, 0xffffeec7, 0xffffeeeb, 0xfffffbc0,
  0xffffeda5, 0xffffedcb, 0xffffedf1, 0xfffffb80,
  0xffffed26, 0xffffed4d, 0xffffed74, 0xfffffb60,
  0xfffffe86, 0xfffffe8a, 0xffffffa2, 0x00000017,
  0xfffffd8a, 0xfffffd90, 0xffffff62, 0x00000011,
  0xfffffd0c, 0xfffffd13, 0xffffff42, 0x0000000e,
  0xfffffd0c, 0xfffffd13, 0xffffff42, 0x0000000e,
  0xffffff04, 0xffffff07, 0xffffffc2, 0x0000001a,
  0xfffffe86, 0xfffffe8a, 0xffffffa2, 0x00000017,
  0xfffffe86, 0xfffffe8a, 0xffffffa2, 0x00000017,
  0xffffff04, 0xffffff07, 0xffffffc2, 0x0000001a,
  0xffffff82, 0xffffff84, 0xffffffe2, 0x0000001d,
  0xffffff82, 0xffffff84, 0xffffffe2, 0x0000001d,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x000000fc, 0x000000fb, 0x00000042, 0x00000026,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000007e, 0x0000007e, 0x00000022, 0x00000023,
  0x0000017a, 0x00000178, 0x00000062, 0x00000029,
  0x0000113a, 0x00001118, 0x00000462, 0x00000089,
  0x0000007e, 0x0000007e, 0x00000022, 0x00000023,
  0x0000017a, 0x00000178, 0x00000062, 0x00000029,
  0x0000113a, 0x00001118, 0x00000462, 0x00000089,
  0x00004ec0, 0x00004e21, 0x00001402, 0x00000200,
  0x000000fc, 0x000000fb, 0x00000042, 0x00000026,
  0x000010bc, 0x0000109b, 0x00000442, 0x00000086,
  0x00004e42, 0x00004da4, 0x000013e2, 0x000001fd,
  0x00008c46, 0x00008b2a, 0x000023a2, 0x00000377,
  0x00000fc0, 0x00000fa1, 0x00000402, 0x00000080,
  0x00004d46, 0x00004caa, 0x000013a2, 0x000001f7,
  0x00008b4a, 0x00008a30, 0x00002362, 0x00000371,
  0x0000c9cc, 0x0000c833, 0x00003342, 0x000004ee,
  0x00003d86, 0x00003d0a, 0x00000fa2, 0x00000197,
  0x00007b8a, 0x00007a90, 0x00001f62, 0x00000311,
  0x0000ba0c, 0x0000b893, 0x00002f42, 0x0000048e,
  0x003fb892, 0x003f371c, 0x00102ee2, 0x00018485,
  0x00003e04, 0x00003d87, 0x00000fc2, 0x0000019a,
  0x00007c86, 0x00007b8a, 0x00001fa2, 0x00000317,
  0x003f7b0c, 0x003efa13, 0x00101f42, 0x0001830e,
  0x007e7a10, 0x007d7919, 0x00201f02, 0x00030308,
  0x00003e82, 0x00003e04, 0x00000fe2, 0x0000019d,
  0x003f3d08, 0x003ebc8d, 0x00100f82, 0x00018194,
  0x007e3c0c, 0x007d3b93, 0x00200f42, 0x0003018e,
  0x00bd3b8e, 0x00bbbb16, 0x00300f22, 0x0004818b,
  0x003efe86, 0x003e7e8a, 0x000fffa2, 0x00018017,
  0x007dfd8a, 0x007cfd90, 0x001fff62, 0x00030011,
  0x00bcfd0c, 0x00bb7d13, 0x002fff42, 0x0004800e,
  0x33f03026, 0x00bb7cfa, 0x669665a2, 0x999e19a7,
  0x003eff04, 0x003e7f07, 0x000fffc2, 0x0001801a,
  0x007dfe86, 0x007cfe8a, 0x001fffa2, 0x00030017,
  0x33b131a0, 0x007cfe71, 0x66866602, 0x999c99b0,
  0x33b13176, 0xab27a8f2, 0x113110a2, 0x999c99af,
  0x003eff82, 0x003e7f84, 0x000fffe2, 0x0001801d,
  0x3372329c, 0x003e7f6b, 0x66766642, 0x999b19b6,
  0x33723272, 0xaae929ec, 0x112110e2, 0x999b19b5,
  0x337230f8, 0x2ae92875, 0x11211082, 0x199b19ac,
  0x3333331a, 0xffffffe8, 0x66666662, 0x999999b9,
  0x333332f0, 0xaaaaaa69, 0x11111102, 0x999999b8,
  0x33333176, 0x2aaaa8f2, 0x111110a2, 0x199999af,
  0x3333307a, 0xaaaaa7f8, 0x11111062, 0x999999a9,
  0xffffffd6, 0xaaaaaa82, 0xaaaaaaa2, 0x0000001f,
  0xfffffe5c, 0x2aaaa90b, 0xaaaaaa42, 0x80000016,
  0xfffffd60, 0xaaaaa811, 0xaaaaaa02, 0x00000010,
  0xfffffce2, 0x2aaaa794, 0xaaaaa9e2, 0x8000000d,
  0xfffffe86, 0x7ffffe8a, 0xffffffa2, 0x80000017,
  0xfffffd8a, 0xfffffd90, 0xffffff62, 0x00000011,
  0xfffffd0c, 0x7ffffd13, 0xffffff42, 0x8000000e,
  0xfffffd0c, 0xfffffd13, 0xffffff42, 0x0000000e,
  0xffffff04, 0x7fffff07, 0xffffffc2, 0x8000001a,
  0xfffffe86, 0xfffffe8a, 0xffffffa2, 0x00000017,
  0xfffffe86, 0x7ffffe8a, 0xffffffa2, 0x80000017,
  0xffffff04, 0xffffff07, 0xffffffc2, 0x0000001a,
  0xffffff82, 0x7fffff84, 0xffffffe2, 0x8000001d,
  0xffffff82, 0xffffff84, 0xffffffe2, 0x0000001d,
  0x00000000, 0x80000001, 0x00000002, 0x80000020,
  0xffffffac, 0xd5555503, 0x55555542, 0x8000001e,
  0x00000000, 0x80000001, 0x00000002, 0x80000020,
  0x0000007e, 0x0000007e, 0x00000022, 0x00000023,
  0x0000002a, 0x55555580, 0x55555562, 0x00000021,
  0xcccccc92, 0x5555551c, 0xeeeeeee2, 0x66666685,
  0x0000007e, 0x8000007e, 0x00000022, 0x80000023,
  0x0000002a, 0xd5555580, 0x55555562, 0x80000021,
  0xcccccc92, 0xd555551c, 0xeeeeeee2, 0xe6666685,
  0xcc8dcc92, 0xd516d51c, 0xeedeeee2, 0xe664e685,
  0xffffffac, 0x55555503, 0x55555542, 0x0000001e,
  0xcccccc14, 0x5555549f, 0xeeeeeec2, 0x66666682,
  0xcc8dcc14, 0x5516d49f, 0xeedeeec2, 0x6664e682,
  0xcc4ecc92, 0x54d8551c, 0xeeceeee2, 0x66636685,
  0xcccccc68, 0xffffff9d, 0x99999982, 0x66666684,
  0xcc8dcc68, 0xffc17f9d, 0x99899982, 0x6664e684,
  0xcc4ecce6, 0xff83001a, 0x997999a2, 0x66636687,
  0xcc0fcde2, 0xff448114, 0x996999e2, 0x6661e68d,
  0xffc10000, 0xffc18001, 0xfff00002, 0xfffe8020,
  0xff82007e, 0xff83007e, 0xffe00022, 0xfffd0023,
  0xff43017a, 0xff448178, 0xffd00062, 0xfffb8029,
  0xff0402f4, 0xff0602ef, 0xffc000c2, 0xfffa0032,
  0xffc1007e, 0xffc1807e, 0xfff00022, 0xfffe8023,
  0xff82017a, 0xff830178, 0xffe00062, 0xfffd0029,
  0xff4302f4, 0xff4482ef, 0xffd000c2, 0xfffb8032,
  0xff42c3f4, 0xff44446f, 0xffcff0c2, 0xfffb7eb2,
  0xffc100fc, 0xffc180fb, 0xfff00042, 0xfffe8026,
  0xff820276, 0xff830272, 0xffe000a2, 0xfffd002f,
  0xff81c376, 0xff82c3f2, 0xffdff0a2, 0xfffcfeaf,
  0xff8184f4, 0xff8285ef, 0xffdfe0c2, 0xfffcfd32,
  0xffc1017a, 0xffc18178, 0xfff00062, 0xfffe8029,
  0xffc0c27a, 0xffc142f8, 0xffeff062, 0xfffe7ea9,
  0xffc083f8, 0xffc104f5, 0xffefe082, 0xfffe7d2c,
  0xffc045f4, 0xffc0c76f, 0xffefd0c2, 0xfffe7bb2,
  0xffffc100, 0xffffc181, 0xfffff002, 0xfffffea0,
  0xffff827e, 0xffff837e, 0xffffe022, 0xfffffd23,
  0xffff447a, 0xffff45f8, 0xffffd062, 0xfffffba9,
  0xffff06f4, 0xffff08ef, 0xffffc0c2, 0xfffffa32,
  0xffffc17e, 0xffffc1fe, 0xfffff022, 0xfffffea3,
  0xffff837a, 0xffff8478, 0xffffe062, 0xfffffd29,
  0xffff45f4, 0xffff476f, 0xffffd0c2, 0xfffffbb2,
  0xffff3634, 0xffff37cf, 0xffffccc2, 0xfffffb52,
  0xffffc1fc, 0xffffc27b, 0xfffff042, 0xfffffea6,
  0xffff8476, 0xffff8572, 0xffffe0a2, 0xfffffd2f,
  0xffff74b6, 0xffff75d2, 0xffffdca2, 0xfffffccf,
  0xffff733c, 0xffff745b, 0xffffdc42, 0xfffffcc6,
  0xffffc27a, 0xffffc2f8, 0xfffff062, 0xfffffea9,
  0xffffb2ba, 0xffffb358, 0xffffec62, 0xfffffe49,
  0xffffb140, 0xffffb1e1, 0xffffec02, 0xfffffe40,
  0xffffb044, 0xffffb0e7, 0xffffebc2, 0xfffffe3a,
  0xfffff040, 0xfffff061, 0xfffffc02, 0xffffffc0,
  0xffffeec6, 0xffffeeea, 0xfffffba2, 0xffffffb7,
  0xffffedca, 0xffffedf0, 0xfffffb62, 0xffffffb1,
  0xffffed4c, 0xffffed73, 0xfffffb42, 0xffffffae,
  0xfffffe89, 0xffffffa1, 0xfffffff9, 0x0000001a,
  0xfffffd8f, 0xffffff61, 0xfffffff3, 0x00000016,
  0xfffffd12, 0xffffff41, 0xfffffff0, 0x00000014,
  0xfffffd12, 0xffffff41, 0xfffffff0, 0x00000014,
  0xffffff06, 0xffffffc1, 0xfffffffc, 0x0000001c,
  0xfffffe89, 0xffffffa1, 0xfffffff9, 0x0000001a,
  0xfffffe89, 0xffffffa1, 0xfffffff9, 0x0000001a,
  0xffffff06, 0xffffffc1, 0xfffffffc, 0x0000001c,
  0xffffff83, 0xffffffe1, 0xffffffff, 0x0000001e,
  0xffffff83, 0xffffffe1, 0xffffffff, 0x0000001e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x000000fa, 0x00000041, 0x00000008, 0x00000024,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000007d, 0x00000021, 0x00000005, 0x00000022,
  0x00000177, 0x00000061, 0x0000000b, 0x00000026,
  0x00001117, 0x00000461, 0x0000006b, 0x00000066,
  0x0000007d, 0x00000021, 0x00000005, 0x00000022,
  0x00000177, 0x00000061, 0x0000000b, 0x00000026,
  0x00001117, 0x00000461, 0x0000006b, 0x00000066,
  0x00004e20, 0x00001401, 0x000001e2, 0x00000160,
  0x000000fa, 0x00000041, 0x00000008, 0x00000024,
  0x0000109a, 0x00000441, 0x00000068, 0x00000064,
  0x00004da3, 0x000013e1, 0x000001df, 0x0000015e,
  0x00008b29, 0x000023a1, 0x00000359, 0x0000025a,
  0x00000fa0, 0x00000401, 0x00000062, 0x00000060,
  0x00004ca9, 0x000013a1, 0x000001d9, 0x0000015a,
  0x00008a2f, 0x00002361, 0x00000353, 0x00000256,
  0x0000c832, 0x00003341, 0x000004d0, 0x00000354,
  0x00003d09, 0x00000fa1, 0x00000179, 0x0000011a,
  0x00007a8f, 0x00001f61, 0x000002f3, 0x00000216,
  0x0000b892, 0x00002f41, 0x00000470, 0x00000314,
  0x003f371b, 0x00102ee1, 0x00018467, 0x0001030e,
  0x00003d86, 0x00000fc1, 0x0000017c, 0x0000011c,
  0x00007b89, 0x00001fa1, 0x000002f9, 0x0000021a,
  0x003efa12, 0x00101f41, 0x000182f0, 0x00010214,
  0x007d7918, 0x00201f01, 0x000302ea, 0x00020210,
  0x00003e03, 0x00000fe1, 0x0000017f, 0x0000011e,
  0x003ebc8c, 0x00100f81, 0x00018176, 0x00010118,
  0x007d3b92, 0x00200f41, 0x00030170, 0x00020114,
  0x00bbbb15, 0x00300f21, 0x0004816d, 0x00030112,
  0x003e7e89, 0x000fffa1, 0x00017ff9, 0x0001001a,
  0x007cfd8f, 0x001fff61, 0x0002fff3, 0x00020016,
  0x00bb7d12, 0x002fff41, 0x00047ff0, 0x00030014,
  0x00bb7cf9, 0x669665a1, 0x999e1989, 0x6669667a,
  0x003e7f06, 0x000fffc1, 0x00017ffc, 0x0001001c,
  0x007cfe89, 0x001fffa1, 0x0002fff9, 0x0002001a,
  0x007cfe70, 0x66866601, 0x999c9992, 0x66686680,
  0xab27a8f1, 0x113110a1, 0x999c9991, 0x1113112a,
  0x003e7f83, 0x000fffe1, 0x00017fff, 0x0001001e,
  0x003e7f6a, 0x66766641, 0x999b1998, 0x66676684,
  0xaae929eb, 0x112110e1, 0x999b1997, 0x1112112e,
  0x2ae92874, 0x11211081, 0x199b198e, 0x11121128,
  0xffffffe7, 0x66666661, 0x9999999b, 0x66666686,
  0xaaaaaa68, 0x11111101, 0x9999999a, 0x11111130,
  0x2aaaa8f1, 0x111110a1, 0x19999991, 0x1111112a,
  0xaaaaa7f7, 0x11111061, 0x9999998b, 0x11111126,
  0xaaaaaa81, 0xaaaaaaa1, 0x00000001, 0xaaaaaaca,
  0x2aaaa90a, 0xaaaaaa41, 0x7ffffff8, 0xaaaaaac4,
  0xaaaaa810, 0xaaaaaa01, 0xfffffff2, 0xaaaaaac0,
  0x2aaaa793, 0xaaaaa9e1, 0x7fffffef, 0xaaaaaabe,
  0x7ffffe89, 0xffffffa1, 0x7ffffff9, 0x0000001a,
  0xfffffd8f, 0xffffff61, 0xfffffff3, 0x00000016,
  0x7ffffd12, 0xffffff41, 0x7ffffff0, 0x00000014,
  0xfffffd12, 0xffffff41, 0xfffffff0, 0x00000014,
  0x7fffff06, 0xffffffc1, 0x7ffffffc, 0x0000001c,
  0xfffffe89, 0xffffffa1, 0xfffffff9, 0x0000001a,
  0x7ffffe89, 0xffffffa1, 0x7ffffff9, 0x0000001a,
  0xffffff06, 0xffffffc1, 0xfffffffc, 0x0000001c,
  0x7fffff83, 0xffffffe1, 0x7fffffff, 0x0000001e,
  0xffffff83, 0xffffffe1, 0xffffffff, 0x0000001e,
  0x80000000, 0x00000001, 0x80000002, 0x00000020,
  0xd5555502, 0x55555541, 0x80000000, 0x55555574,
  0x80000000, 0x00000001, 0x80000002, 0x00000020,
  0x0000007d, 0x00000021, 0x00000005, 0x00000022,
  0x5555557f, 0x55555561, 0x00000003, 0x55555576,
  0x5555551b, 0xeeeeeee1, 0x66666667, 0xeeeeef0e,
  0x8000007d, 0x00000021, 0x80000005, 0x00000022,
  0xd555557f, 0x55555561, 0x80000003, 0x55555576,
  0xd555551b, 0xeeeeeee1, 0xe6666667, 0xeeeeef0e,
  0xd516d51b, 0xeedeeee1, 0xe664e667, 0xeeedef0e,
  0x55555502, 0x55555541, 0x00000000, 0x55555574,
  0x5555549e, 0xeeeeeec1, 0x66666664, 0xeeeeef0c,
  0x5516d49e, 0xeedeeec1, 0x6664e664, 0xeeedef0c,
  0x54d8551b, 0xeeceeee1, 0x66636667, 0xeeecef0e,
  0xffffff9c, 0x99999981, 0x66666666, 0x999999b8,
  0xffc17f9c, 0x99899981, 0x6664e666, 0x999899b8,
  0xff830019, 0x997999a1, 0x66636669, 0x999799ba,
  0xff448113, 0x996999e1, 0x6661e66f, 0x999699be,
  0xffc18000, 0xfff00001, 0xfffe8002, 0xffff0020,
  0xff83007d, 0xffe00021, 0xfffd0005, 0xfffe0022,
  0xff448177, 0xffd00061, 0xfffb800b, 0xfffd0026,
  0xff0602ee, 0xffc000c1, 0xfffa0014, 0xfffc002c,
  0xffc1807d, 0xfff00021, 0xfffe8005, 0xffff0022,
  0xff830177, 0xffe00061, 0xfffd000b, 0xfffe0026,
  0xff4482ee, 0xffd000c1, 0xfffb8014, 0xfffd002c,
  0xff44446e, 0xffcff0c1, 0xfffb7e94, 0xfffcff2c,
  0xffc180fa, 0xfff00041, 0xfffe8008, 0xffff0024,
  0xff830271, 0xffe000a1, 0xfffd0011, 0xfffe002a,
  0xff82c3f1, 0xffdff0a1, 0xfffcfe91, 0xfffdff2a,
  0xff8285ee, 0xffdfe0c1, 0xfffcfd14, 0xfffdfe2c,
  0xffc18177, 0xfff00061, 0xfffe800b, 0xffff0026,
  0xffc142f7, 0xffeff061, 0xfffe7e8b, 0xfffeff26,
  0xffc104f4, 0xffefe081, 0xfffe7d0e, 0xfffefe28,
  0xffc0c76e, 0xffefd0c1, 0xfffe7b94, 0xfffefd2c,
  0xffffc180, 0xfffff001, 0xfffffe82, 0xffffff20,
  0xffff837d, 0xffffe021, 0xfffffd05, 0xfffffe22,
  0xffff45f7, 0xffffd061, 0xfffffb8b, 0xfffffd26,
  0xffff08ee, 0xffffc0c1, 0xfffffa14, 0xfffffc2c,
  0xffffc1fd, 0xfffff021, 0xfffffe85, 0xffffff22,
  0xffff8477, 0xffffe061, 0xfffffd0b, 0xfffffe26,
  0xffff476e, 0xffffd0c1, 0xfffffb94, 0xfffffd2c,
  0xffff37ce, 0xffffccc1, 0xfffffb34, 0xfffffcec,
  0xffffc27a, 0xfffff041, 0xfffffe88, 0xffffff24,
  0xffff8571, 0xffffe0a1, 0xfffffd11, 0xfffffe2a,
  0xffff75d1, 0xffffdca1, 0xfffffcb1, 0xfffffdea,
  0xffff745a, 0xffffdc41, 0xfffffca8, 0xfffffde4,
  0xffffc2f7, 0xfffff061, 0xfffffe8b, 0xffffff26,
  0xffffb357, 0xffffec61, 0xfffffe2b, 0xfffffee6,
  0xffffb1e0, 0xffffec01, 0xfffffe22, 0xfffffee0,
  0xffffb0e6, 0xffffebc1, 0xfffffe1c, 0xfffffedc,
  0xfffff060, 0xfffffc01, 0xffffffa2, 0xffffffe0,
  0xffffeee9, 0xfffffba1, 0xffffff99, 0xffffffda,
  0xffffedef, 0xfffffb61, 0xffffff93, 0xffffffd6,
  0xffffed72, 0xfffffb41, 0xffffff90, 0xffffffd4,
  0xffffffa0, 0xfffffff8, 0xfffffffc, 0x0000001d,
  0xffffff60, 0xfffffff2, 0xfffffff8, 0x0000001b,
  0xffffff40, 0xffffffef, 0xfffffff6, 0x0000001a,
  0xffffff40, 0xffffffef, 0xfffffff6, 0x0000001a,
  0xffffffc0, 0xfffffffb, 0xfffffffe, 0x0000001e,
  0xffffffa0, 0xfffffff8, 0xfffffffc, 0x0000001d,
  0xffffffa0, 0xfffffff8, 0xfffffffc, 0x0000001d,
  0xffffffc0, 0xfffffffb, 0xfffffffe, 0x0000001e,
  0xffffffe0, 0xfffffffe, 0x00000000, 0x0000001f,
  0xffffffe0, 0xfffffffe, 0x00000000, 0x0000001f,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000040, 0x00000007, 0x00000006, 0x00000022,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000020, 0x00000004, 0x00000004, 0x00000021,
  0x00000060, 0x0000000a, 0x00000008, 0x00000023,
  0x00000460, 0x0000006a, 0x00000048, 0x00000043,
  0x00000020, 0x00000004, 0x00000004, 0x00000021,
  0x00000060, 0x0000000a, 0x00000008, 0x00000023,
  0x00000460, 0x0000006a, 0x00000048, 0x00000043,
  0x00001400, 0x000001e1, 0x00000142, 0x000000c0,
  0x00000040, 0x00000007, 0x00000006, 0x00000022,
  0x00000440, 0x00000067, 0x00000046, 0x00000042,
  0x000013e0, 0x000001de, 0x00000140, 0x000000bf,
  0x000023a0, 0x00000358, 0x0000023c, 0x0000013d,
  0x00000400, 0x00000061, 0x00000042, 0x00000040,
  0x000013a0, 0x000001d8, 0x0000013c, 0x000000bd,
  0x00002360, 0x00000352, 0x00000238, 0x0000013b,
  0x00003340, 0x000004cf, 0x00000336, 0x000001ba,
  0x00000fa0, 0x00000178, 0x000000fc, 0x0000009d,
  0x00001f60, 0x000002f2, 0x000001f8, 0x0000011b,
  0x00002f40, 0x0000046f, 0x000002f6, 0x0000019a,
  0x00102ee0, 0x00018466, 0x000102f0, 0x00008197,
  0x00000fc0, 0x0000017b, 0x000000fe, 0x0000009e,
  0x00001fa0, 0x000002f8, 0x000001fc, 0x0000011d,
  0x00101f40, 0x000182ef, 0x000101f6, 0x0000811a,
  0x00201f00, 0x000302e9, 0x000201f2, 0x00010118,
  0x00000fe0, 0x0000017e, 0x00000100, 0x0000009f,
  0x00100f80, 0x00018175, 0x000100fa, 0x0000809c,
  0x00200f40, 0x0003016f, 0x000200f6, 0x0001009a,
  0x00300f20, 0x0004816c, 0x000300f4, 0x00018099,
  0x000fffa0, 0x00017ff8, 0x0000fffc, 0x0000801d,
  0x001fff60, 0x0002fff2, 0x0001fff8, 0x0001001b,
  0x002fff40, 0x00047fef, 0x0002fff6, 0x0001801a,
  0x669665a0, 0x999e1988, 0x6669665c, 0x3334b34d,
  0x000fffc0, 0x00017ffb, 0x0000fffe, 0x0000801e,
  0x001fffa0, 0x0002fff8, 0x0001fffc, 0x0001001d,
  0x66866600, 0x999c9991, 0x66686662, 0x33343350,
  0x113110a0, 0x999c9990, 0x1113110c, 0x888988a5,
  0x000fffe0, 0x00017ffe, 0x00010000, 0x0000801f,
  0x66766640, 0x999b1997, 0x66676666, 0x3333b352,
  0x112110e0, 0x999b1996, 0x11121110, 0x888908a7,
  0x11211080, 0x199b198d, 0x1112110a, 0x088908a4,
  0x66666660, 0x9999999a, 0x66666668, 0x33333353,
  0x11111100, 0x99999999, 0x11111112, 0x888888a8,
  0x111110a0, 0x19999990, 0x1111110c, 0x088888a5,
  0x11111060, 0x9999998a, 0x11111108, 0x888888a3,
  0xaaaaaaa0, 0x00000000, 0xaaaaaaac, 0x55555575,
  0xaaaaaa40, 0x7ffffff7, 0xaaaaaaa6, 0xd5555572,
  0xaaaaaa00, 0xfffffff1, 0xaaaaaaa2, 0x55555570,
  0xaaaaa9e0, 0x7fffffee, 0xaaaaaaa0, 0xd555556f,
  0xffffffa0, 0x7ffffff8, 0xfffffffc, 0x8000001d,
  0xffffff60, 0xfffffff2, 0xfffffff8, 0x0000001b,
  0xffffff40, 0x7fffffef, 0xfffffff6, 0x8000001a,
  0xffffff40, 0xffffffef, 0xfffffff6, 0x0000001a,
  0xffffffc0, 0x7ffffffb, 0xfffffffe, 0x8000001e,
  0xffffffa0, 0xfffffff8, 0xfffffffc, 0x0000001d,
  0xffffffa0, 0x7ffffff8, 0xfffffffc, 0x8000001d,
  0xffffffc0, 0xfffffffb, 0xfffffffe, 0x0000001e,
  0xffffffe0, 0x7ffffffe, 0x00000000, 0x8000001f,
  0xffffffe0, 0xfffffffe, 0x00000000, 0x0000001f,
  0x00000000, 0x80000001, 0x00000002, 0x80000020,
  0x55555540, 0x7fffffff, 0x55555556, 0x2aaaaaca,
  0x00000000, 0x80000001, 0x00000002, 0x80000020,
  0x00000020, 0x00000004, 0x00000004, 0x00000021,
  0x55555560, 0x00000002, 0x55555558, 0xaaaaaacb,
  0xeeeeeee0, 0x66666666, 0xeeeeeef0, 0x77777797,
  0x00000020, 0x80000004, 0x00000004, 0x80000021,
  0x55555560, 0x80000002, 0x55555558, 0x2aaaaacb,
  0xeeeeeee0, 0xe6666666, 0xeeeeeef0, 0xf7777797,
  0xeedeeee0, 0xe664e666, 0xeeedeef0, 0xf776f797,
  0x55555540, 0xffffffff, 0x55555556, 0xaaaaaaca,
  0xeeeeeec0, 0x66666663, 0xeeeeeeee, 0x77777796,
  0xeedeeec0, 0x6664e663, 0xeeedeeee, 0x7776f796,
  0xeeceeee0, 0x66636666, 0xeeeceef0, 0x77767797,
  0x99999980, 0x66666665, 0x9999999a, 0xccccccec,
  0x99899980, 0x6664e665, 0x9998999a, 0xcccc4cec,
  0x997999a0, 0x66636668, 0x9997999c, 0xcccbcced,
  0x996999e0, 0x6661e66e, 0x999699a0, 0xcccb4cef,
  0xfff00000, 0xfffe8001, 0xffff0002, 0xffff8020,
  0xffe00020, 0xfffd0004, 0xfffe0004, 0xffff0021,
  0xffd00060, 0xfffb800a, 0xfffd0008, 0xfffe8023,
  0xffc000c0, 0xfffa0013, 0xfffc000e, 0xfffe0026,
  0xfff00020, 0xfffe8004, 0xffff0004, 0xffff8021,
  0xffe00060, 0xfffd000a, 0xfffe0008, 0xffff0023,
  0xffd000c0, 0xfffb8013, 0xfffd000e, 0xfffe8026,
  0xffcff0c0, 0xfffb7e93, 0xfffcff0e, 0xfffe7fa6,
  0xfff00040, 0xfffe8007, 0xffff0006, 0xffff8022,
  0xffe000a0, 0xfffd0010, 0xfffe000c, 0xffff0025,
  0xffdff0a0, 0xfffcfe90, 0xfffdff0c, 0xfffeffa5,
  0xffdfe0c0, 0xfffcfd13, 0xfffdfe0e, 0xfffeff26,
  0xfff00060, 0xfffe800a, 0xffff0008, 0xffff8023,
  0xffeff060, 0xfffe7e8a, 0xfffeff08, 0xffff7fa3,
  0xffefe080, 0xfffe7d0d, 0xfffefe0a, 0xffff7f24,
  0xffefd0c0, 0xfffe7b93, 0xfffefd0e, 0xffff7ea6,
  0xfffff000, 0xfffffe81, 0xffffff02, 0xffffffa0,
  0xffffe020, 0xfffffd04, 0xfffffe04, 0xffffff21,
  0xffffd060, 0xfffffb8a, 0xfffffd08, 0xfffffea3,
  0xffffc0c0, 0xfffffa13, 0xfffffc0e, 0xfffffe26,
  0xfffff020, 0xfffffe84, 0xffffff04, 0xffffffa1,
  0xffffe060, 0xfffffd0a, 0xfffffe08, 0xffffff23,
  0xffffd0c0, 0xfffffb93, 0xfffffd0e, 0xfffffea6,
  0xffffccc0, 0xfffffb33, 0xfffffcce, 0xfffffe86,
  0xfffff040, 0xfffffe87, 0xffffff06, 0xffffffa2,
  0xffffe0a0, 0xfffffd10, 0xfffffe0c, 0xffffff25,
  0xffffdca0, 0xfffffcb0, 0xfffffdcc, 0xffffff05,
  0xffffdc40, 0xfffffca7, 0xfffffdc6, 0xffffff02,
  0xfffff060, 0xfffffe8a, 0xffffff08, 0xffffffa3,
  0xffffec60, 0xfffffe2a, 0xfffffec8, 0xffffff83,
  0xffffec00, 0xfffffe21, 0xfffffec2, 0xffffff80,
  0xffffebc0, 0xfffffe1b, 0xfffffebe, 0xffffff7e,
  0xfffffc00, 0xffffffa1, 0xffffffc2, 0x00000000,
  0xfffffba0, 0xffffff98, 0xffffffbc, 0xfffffffd,
  0xfffffb60, 0xffffff92, 0xffffffb8, 0xfffffffb,
  0xfffffb40, 0xffffff8f, 0xffffffb6, 0xfffffffa,
};
const unsigned kExpectedCount_NEON_mls_4S_4S_S = 3844;

#endif  // VIXL_SIM_MLS_4S_4S_S_TRACE_AARCH64_H_
