// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_FMUL_2D_TRACE_AARCH64_H_
#define VIXL_SIM_FMUL_2D_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_fmul_2D[] = {
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000009ff0, 0x0000000000000000,
  0x0000000000009ff0, 0x0000000000000000,
  0x0000000000009ff0, 0x0000000000000000,
  0x0000000000013fe0, 0x0000000000000000,
  0x0000000000013fe0, 0x0000000000000000,
  0x0000000000013fe0, 0x0000000000000000,
  0x000000000001dfd0, 0x0000000000000000,
  0x00000000000c7ec0, 0x0000000000000000,
  0x3dd3fdffffffffff, 0x7ff8000000000000,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff0000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000009ff0, 0x8000000000000000,
  0x8000000000009ff0, 0x8000000000000000,
  0x8000000000009ff0, 0x8000000000000000,
  0x8000000000013fe0, 0x8000000000000000,
  0x8000000000013fe0, 0x8000000000000000,
  0x8000000000013fe0, 0x8000000000000000,
  0x800000000001dfd0, 0x8000000000000000,
  0x80000000000c7ec0, 0x8000000000000000,
  0xbdd3fdffffffffff, 0x7ff8000000000000,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x7ff8000000000000,
  0xfff0000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0008000000000000,
  0x0000000000000000, 0x0008000000000000,
  0x0000000000000000, 0x0008000000000000,
  0x0000000000000000, 0x0010000000000000,
  0x0000000000000000, 0x0010000000000000,
  0x0000000000000000, 0x0010000000000001,
  0x0000000000000000, 0x0018000000000000,
  0x0000000000000000, 0x0044000000000000,
  0x0000000000000000, 0x400fffffffffffff,
  0x0000000000000000, 0x7ff0000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff8000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8008000000000000,
  0x8000000000000000, 0x8008000000000000,
  0x8000000000000000, 0x8008000000000000,
  0x8000000000000000, 0x8010000000000000,
  0x8000000000000000, 0x8010000000000000,
  0x8000000000000000, 0x8010000000000001,
  0x8000000000000000, 0x8018000000000000,
  0x8000000000000000, 0x8044000000000000,
  0x8000000000000000, 0xc00fffffffffffff,
  0x8000000000000000, 0xfff0000000000000,
  0x7ff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff0000000000000,
  0x7ff8000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0008000000000000,
  0x0000000000000000, 0x3fcffffffffffffe,
  0x0008000000000000, 0x3fcfffffffffffff,
  0x0008000000000000, 0x3fd0000000000000,
  0x0008000000000000, 0x3fdffffffffffffe,
  0x0010000000000000, 0x3fdfffffffffffff,
  0x0010000000000000, 0x3fe0000000000000,
  0x0010000000000001, 0x3fe7ffffffffffff,
  0x0018000000000000, 0x4013ffffffffffff,
  0x0044000000000000, 0x7fdffffffffffffe,
  0x400fffffffffffff, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x000091a2b3c4d5e6,
  0x0000000000000000, 0x0007ffffffffffff,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8008000000000000,
  0x8000000000000000, 0xbfcffffffffffffe,
  0x8008000000000000, 0xbfcfffffffffffff,
  0x8008000000000000, 0xbfd0000000000000,
  0x8008000000000000, 0xbfdffffffffffffe,
  0x8010000000000000, 0xbfdfffffffffffff,
  0x8010000000000000, 0xbfe0000000000000,
  0x8010000000000001, 0xbfe7ffffffffffff,
  0x8018000000000000, 0xc013ffffffffffff,
  0x8044000000000000, 0xffdffffffffffffe,
  0xc00fffffffffffff, 0xfff0000000000000,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0x800091a2b3c4d5e6,
  0x8000000000000000, 0x8007ffffffffffff,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0008000000000000,
  0x0008000000000000, 0x3fcfffffffffffff,
  0x3fcffffffffffffe, 0x3fd0000000000000,
  0x3fcfffffffffffff, 0x3fd0000000000001,
  0x3fd0000000000000, 0x3fdfffffffffffff,
  0x3fdffffffffffffe, 0x3fe0000000000000,
  0x3fdfffffffffffff, 0x3fe0000000000001,
  0x3fe0000000000000, 0x3fe8000000000000,
  0x3fe7ffffffffffff, 0x4014000000000000,
  0x4013ffffffffffff, 0x7fdfffffffffffff,
  0x7fdffffffffffffe, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x000091a2b3c4d5e6,
  0x000091a2b3c4d5e6, 0x0008000000000000,
  0x0007ffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8008000000000000,
  0x8008000000000000, 0xbfcfffffffffffff,
  0xbfcffffffffffffe, 0xbfd0000000000000,
  0xbfcfffffffffffff, 0xbfd0000000000001,
  0xbfd0000000000000, 0xbfdfffffffffffff,
  0xbfdffffffffffffe, 0xbfe0000000000000,
  0xbfdfffffffffffff, 0xbfe0000000000001,
  0xbfe0000000000000, 0xbfe8000000000000,
  0xbfe7ffffffffffff, 0xc014000000000000,
  0xc013ffffffffffff, 0xffdfffffffffffff,
  0xffdffffffffffffe, 0xfff0000000000000,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0x800091a2b3c4d5e6,
  0x800091a2b3c4d5e6, 0x8008000000000000,
  0x8007ffffffffffff, 0x8000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0008000000000000,
  0x0008000000000000, 0x3fd0000000000000,
  0x3fcfffffffffffff, 0x3fd0000000000001,
  0x3fd0000000000000, 0x3fd0000000000002,
  0x3fd0000000000001, 0x3fe0000000000000,
  0x3fdfffffffffffff, 0x3fe0000000000001,
  0x3fe0000000000000, 0x3fe0000000000002,
  0x3fe0000000000001, 0x3fe8000000000002,
  0x3fe8000000000000, 0x4014000000000001,
  0x4014000000000000, 0x7fe0000000000000,
  0x7fdfffffffffffff, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x000091a2b3c4d5e7,
  0x000091a2b3c4d5e6, 0x0008000000000000,
  0x0008000000000000, 0x0000000000000001,
  0x0000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8008000000000000,
  0x8008000000000000, 0xbfd0000000000000,
  0xbfcfffffffffffff, 0xbfd0000000000001,
  0xbfd0000000000000, 0xbfd0000000000002,
  0xbfd0000000000001, 0xbfe0000000000000,
  0xbfdfffffffffffff, 0xbfe0000000000001,
  0xbfe0000000000000, 0xbfe0000000000002,
  0xbfe0000000000001, 0xbfe8000000000002,
  0xbfe8000000000000, 0xc014000000000001,
  0xc014000000000000, 0xffe0000000000000,
  0xffdfffffffffffff, 0xfff0000000000000,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0x800091a2b3c4d5e7,
  0x800091a2b3c4d5e6, 0x8008000000000000,
  0x8008000000000000, 0x8000000000000001,
  0x8000000000000001, 0x0000000000000000,
  0x0000000000000000, 0x0010000000000000,
  0x0008000000000000, 0x3fdffffffffffffe,
  0x3fd0000000000000, 0x3fdfffffffffffff,
  0x3fd0000000000001, 0x3fe0000000000000,
  0x3fd0000000000002, 0x3feffffffffffffe,
  0x3fe0000000000000, 0x3fefffffffffffff,
  0x3fe0000000000001, 0x3ff0000000000000,
  0x3fe0000000000002, 0x3ff7ffffffffffff,
  0x3fe8000000000002, 0x4023ffffffffffff,
  0x4014000000000001, 0x7feffffffffffffe,
  0x7fe0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x000123456789abcd,
  0x000091a2b3c4d5e7, 0x000fffffffffffff,
  0x0008000000000000, 0x0000000000000001,
  0x0000000000000001, 0x8000000000000000,
  0x8000000000000000, 0x8010000000000000,
  0x8008000000000000, 0xbfdffffffffffffe,
  0xbfd0000000000000, 0xbfdfffffffffffff,
  0xbfd0000000000001, 0xbfe0000000000000,
  0xbfd0000000000002, 0xbfeffffffffffffe,
  0xbfe0000000000000, 0xbfefffffffffffff,
  0xbfe0000000000001, 0xbff0000000000000,
  0xbfe0000000000002, 0xbff7ffffffffffff,
  0xbfe8000000000002, 0xc023ffffffffffff,
  0xc014000000000001, 0xffeffffffffffffe,
  0xffe0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0x800123456789abcd,
  0x800091a2b3c4d5e7, 0x800fffffffffffff,
  0x8008000000000000, 0x8000000000000001,
  0x8000000000000001, 0x0000000000000000,
  0x0000000000000000, 0x0010000000000000,
  0x0010000000000000, 0x3fdfffffffffffff,
  0x3fdffffffffffffe, 0x3fe0000000000000,
  0x3fdfffffffffffff, 0x3fe0000000000001,
  0x3fe0000000000000, 0x3fefffffffffffff,
  0x3feffffffffffffe, 0x3ff0000000000000,
  0x3fefffffffffffff, 0x3ff0000000000001,
  0x3ff0000000000000, 0x3ff8000000000000,
  0x3ff7ffffffffffff, 0x4024000000000000,
  0x4023ffffffffffff, 0x7fefffffffffffff,
  0x7feffffffffffffe, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x000123456789abcd,
  0x000123456789abcd, 0x000fffffffffffff,
  0x000fffffffffffff, 0x0000000000000001,
  0x0000000000000001, 0x8000000000000000,
  0x8000000000000000, 0x8010000000000000,
  0x8010000000000000, 0xbfdfffffffffffff,
  0xbfdffffffffffffe, 0xbfe0000000000000,
  0xbfdfffffffffffff, 0xbfe0000000000001,
  0xbfe0000000000000, 0xbfefffffffffffff,
  0xbfeffffffffffffe, 0xbff0000000000000,
  0xbfefffffffffffff, 0xbff0000000000001,
  0xbff0000000000000, 0xbff8000000000000,
  0xbff7ffffffffffff, 0xc024000000000000,
  0xc023ffffffffffff, 0xffefffffffffffff,
  0xffeffffffffffffe, 0xfff0000000000000,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0x800123456789abcd,
  0x800123456789abcd, 0x800fffffffffffff,
  0x800fffffffffffff, 0x8000000000000001,
  0x8000000000000001, 0x0000000000000000,
  0x0000000000000000, 0x0010000000000001,
  0x0010000000000000, 0x3fe0000000000000,
  0x3fdfffffffffffff, 0x3fe0000000000001,
  0x3fe0000000000000, 0x3fe0000000000002,
  0x3fe0000000000001, 0x3ff0000000000000,
  0x3fefffffffffffff, 0x3ff0000000000001,
  0x3ff0000000000000, 0x3ff0000000000002,
  0x3ff0000000000001, 0x3ff8000000000002,
  0x3ff8000000000000, 0x4024000000000001,
  0x4024000000000000, 0x7ff0000000000000,
  0x7fefffffffffffff, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x000123456789abcd,
  0x000123456789abcd, 0x0010000000000000,
  0x000fffffffffffff, 0x0000000000000001,
  0x0000000000000001, 0x8000000000000000,
  0x8000000000000000, 0x8010000000000001,
  0x8010000000000000, 0xbfe0000000000000,
  0xbfdfffffffffffff, 0xbfe0000000000001,
  0xbfe0000000000000, 0xbfe0000000000002,
  0xbfe0000000000001, 0xbff0000000000000,
  0xbfefffffffffffff, 0xbff0000000000001,
  0xbff0000000000000, 0xbff0000000000002,
  0xbff0000000000001, 0xbff8000000000002,
  0xbff8000000000000, 0xc024000000000001,
  0xc024000000000000, 0xfff0000000000000,
  0xffefffffffffffff, 0xfff0000000000000,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0x800123456789abcd,
  0x800123456789abcd, 0x8010000000000000,
  0x800fffffffffffff, 0x8000000000000001,
  0x8000000000000001, 0x0000000000000000,
  0x0000000000000000, 0x0018000000000000,
  0x0010000000000001, 0x3fe7ffffffffffff,
  0x3fe0000000000000, 0x3fe8000000000000,
  0x3fe0000000000001, 0x3fe8000000000002,
  0x3fe0000000000002, 0x3ff7ffffffffffff,
  0x3ff0000000000000, 0x3ff8000000000000,
  0x3ff0000000000001, 0x3ff8000000000002,
  0x3ff0000000000002, 0x4002000000000000,
  0x3ff8000000000002, 0x402e000000000000,
  0x4024000000000001, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x0001b4e81b4e81b4,
  0x000123456789abcd, 0x0017fffffffffffe,
  0x0010000000000000, 0x0000000000000002,
  0x0000000000000001, 0x8000000000000000,
  0x8000000000000000, 0x8018000000000000,
  0x8010000000000001, 0xbfe7ffffffffffff,
  0xbfe0000000000000, 0xbfe8000000000000,
  0xbfe0000000000001, 0xbfe8000000000002,
  0xbfe0000000000002, 0xbff7ffffffffffff,
  0xbff0000000000000, 0xbff8000000000000,
  0xbff0000000000001, 0xbff8000000000002,
  0xbff0000000000002, 0xc002000000000000,
  0xbff8000000000002, 0xc02e000000000000,
  0xc024000000000001, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0x8001b4e81b4e81b4,
  0x800123456789abcd, 0x8017fffffffffffe,
  0x8010000000000000, 0x8000000000000002,
  0x8000000000000002, 0x0000000000000000,
  0x0000000000000000, 0x0044000000000000,
  0x0018000000000000, 0x4013ffffffffffff,
  0x3fe7ffffffffffff, 0x4014000000000000,
  0x3fe8000000000000, 0x4014000000000001,
  0x3fe8000000000002, 0x4023ffffffffffff,
  0x3ff7ffffffffffff, 0x4024000000000000,
  0x3ff8000000000000, 0x4024000000000001,
  0x3ff8000000000002, 0x402e000000000000,
  0x4002000000000000, 0x4059000000000000,
  0x402e000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x000b60b60b60b602,
  0x0001b4e81b4e81b4, 0x0043ffffffffffff,
  0x0017fffffffffffe, 0x000000000000000a,
  0x0000000000000002, 0x8000000000000000,
  0x8000000000000000, 0x8044000000000000,
  0x8018000000000000, 0xc013ffffffffffff,
  0xbfe7ffffffffffff, 0xc014000000000000,
  0xbfe8000000000000, 0xc014000000000001,
  0xbfe8000000000002, 0xc023ffffffffffff,
  0xbff7ffffffffffff, 0xc024000000000000,
  0xbff8000000000000, 0xc024000000000001,
  0xbff8000000000002, 0xc02e000000000000,
  0xc002000000000000, 0xc059000000000000,
  0xc02e000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0x800b60b60b60b602,
  0x8001b4e81b4e81b4, 0x8043ffffffffffff,
  0x8017fffffffffffe, 0x800000000000000a,
  0x800000000000000a, 0x0000000000000000,
  0x0000000000000000, 0x400fffffffffffff,
  0x0044000000000000, 0x7fdffffffffffffe,
  0x4013ffffffffffff, 0x7fdfffffffffffff,
  0x4014000000000000, 0x7fe0000000000000,
  0x4014000000000001, 0x7feffffffffffffe,
  0x4023ffffffffffff, 0x7fefffffffffffff,
  0x4024000000000000, 0x7ff0000000000000,
  0x4024000000000001, 0x7ff0000000000000,
  0x402e000000000000, 0x7ff0000000000000,
  0x4059000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x3fd23456789abccf,
  0x000b60b60b60b602, 0x400ffffffffffffd,
  0x0043ffffffffffff, 0x3ccfffffffffffff,
  0x000000000000000a, 0x8000000000000000,
  0x8000000000000000, 0xc00fffffffffffff,
  0x8044000000000000, 0xffdffffffffffffe,
  0xc013ffffffffffff, 0xffdfffffffffffff,
  0xc014000000000000, 0xffe0000000000000,
  0xc014000000000001, 0xffeffffffffffffe,
  0xc023ffffffffffff, 0xffefffffffffffff,
  0xc024000000000000, 0xfff0000000000000,
  0xc024000000000001, 0xfff0000000000000,
  0xc02e000000000000, 0xfff0000000000000,
  0xc059000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0xbfd23456789abccf,
  0x800b60b60b60b602, 0xc00ffffffffffffd,
  0x8043ffffffffffff, 0xbccfffffffffffff,
  0xbccfffffffffffff, 0x7ff8000000000000,
  0x0000000000000000, 0x7ff0000000000000,
  0x400fffffffffffff, 0x7ff0000000000000,
  0x7fdffffffffffffe, 0x7ff0000000000000,
  0x7fdfffffffffffff, 0x7ff0000000000000,
  0x7fe0000000000000, 0x7ff0000000000000,
  0x7feffffffffffffe, 0x7ff0000000000000,
  0x7fefffffffffffff, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x3fd23456789abccf, 0x7ff0000000000000,
  0x400ffffffffffffd, 0x7ff0000000000000,
  0x3ccfffffffffffff, 0x7ff8000000000000,
  0x8000000000000000, 0xfff0000000000000,
  0xc00fffffffffffff, 0xfff0000000000000,
  0xffdffffffffffffe, 0xfff0000000000000,
  0xffdfffffffffffff, 0xfff0000000000000,
  0xffe0000000000000, 0xfff0000000000000,
  0xffeffffffffffffe, 0xfff0000000000000,
  0xffefffffffffffff, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xbfd23456789abccf, 0xfff0000000000000,
  0xc00ffffffffffffd, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0xfff923456789abcd, 0x7ff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0xfff923456789abcd,
  0xfff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0xfff923456789abcd, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff923456789abcd,
  0x7ff923456789abcd, 0xfff8000000000000,
  0x7ff923456789abcd, 0xfff923456789abcd,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0x0000000000000000,
  0x7ff8000000000000, 0x0000000000000000,
  0x7ff0000000000000, 0x000091a2b3c4d5e6,
  0x7ff0000000000000, 0x000091a2b3c4d5e6,
  0x7ff0000000000000, 0x000091a2b3c4d5e7,
  0x7ff0000000000000, 0x000123456789abcd,
  0x7ff0000000000000, 0x000123456789abcd,
  0x7ff0000000000000, 0x000123456789abcd,
  0x7ff0000000000000, 0x0001b4e81b4e81b4,
  0x7ff0000000000000, 0x000b60b60b60b602,
  0x7ff0000000000000, 0x3fd23456789abccf,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x0000000000000000,
  0x7ff0000000000000, 0x0000000000000000,
  0x7ff0000000000000, 0x0000000000000000,
  0x7ff0000000000000, 0x8000000000000000,
  0x7ff8000000000000, 0x8000000000000000,
  0xfff0000000000000, 0x800091a2b3c4d5e6,
  0xfff0000000000000, 0x800091a2b3c4d5e6,
  0xfff0000000000000, 0x800091a2b3c4d5e7,
  0xfff0000000000000, 0x800123456789abcd,
  0xfff0000000000000, 0x800123456789abcd,
  0xfff0000000000000, 0x800123456789abcd,
  0xfff0000000000000, 0x8001b4e81b4e81b4,
  0xfff0000000000000, 0x800b60b60b60b602,
  0xfff0000000000000, 0xbfd23456789abccf,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0x8000000000000000,
  0xfff0000000000000, 0x8000000000000000,
  0xfff0000000000000, 0x8000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0007ffffffffffff,
  0x000091a2b3c4d5e6, 0x0008000000000000,
  0x000091a2b3c4d5e6, 0x0008000000000000,
  0x000091a2b3c4d5e7, 0x000fffffffffffff,
  0x000123456789abcd, 0x000fffffffffffff,
  0x000123456789abcd, 0x0010000000000000,
  0x000123456789abcd, 0x0017fffffffffffe,
  0x0001b4e81b4e81b4, 0x0043ffffffffffff,
  0x000b60b60b60b602, 0x400ffffffffffffd,
  0x3fd23456789abccf, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8007ffffffffffff,
  0x800091a2b3c4d5e6, 0x8008000000000000,
  0x800091a2b3c4d5e6, 0x8008000000000000,
  0x800091a2b3c4d5e7, 0x800fffffffffffff,
  0x800123456789abcd, 0x800fffffffffffff,
  0x800123456789abcd, 0x8010000000000000,
  0x800123456789abcd, 0x8017fffffffffffe,
  0x8001b4e81b4e81b4, 0x8043ffffffffffff,
  0x800b60b60b60b602, 0xc00ffffffffffffd,
  0xbfd23456789abccf, 0xfff0000000000000,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0007ffffffffffff, 0x0000000000000000,
  0x0008000000000000, 0x0000000000000001,
  0x0008000000000000, 0x0000000000000001,
  0x000fffffffffffff, 0x0000000000000001,
  0x000fffffffffffff, 0x0000000000000001,
  0x0010000000000000, 0x0000000000000002,
  0x0017fffffffffffe, 0x000000000000000a,
  0x0043ffffffffffff, 0x3ccfffffffffffff,
  0x400ffffffffffffd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8007ffffffffffff, 0x8000000000000000,
  0x8008000000000000, 0x8000000000000001,
  0x8008000000000000, 0x8000000000000001,
  0x800fffffffffffff, 0x8000000000000001,
  0x800fffffffffffff, 0x8000000000000001,
  0x8010000000000000, 0x8000000000000002,
  0x8017fffffffffffe, 0x800000000000000a,
  0x8043ffffffffffff, 0xbccfffffffffffff,
  0xc00ffffffffffffd, 0xfff0000000000000,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000001, 0x8000000000000000,
  0x0000000000000001, 0x8000000000000000,
  0x0000000000000001, 0x8000000000000000,
  0x0000000000000001, 0x8000000000000000,
  0x0000000000000002, 0x8000000000000000,
  0x000000000000000a, 0x8000000000000000,
  0x3ccfffffffffffff, 0x7ff8000000000000,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff0000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000001, 0x0000000000000000,
  0x8000000000000001, 0x0000000000000000,
  0x8000000000000001, 0x0000000000000000,
  0x8000000000000001, 0x0000000000000000,
  0x8000000000000002, 0x0000000000000000,
  0x800000000000000a, 0x0000000000000000,
  0xbccfffffffffffff, 0x7ff8000000000000,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x7ff8000000000000,
  0xfff0000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8008000000000000,
  0x8000000000000000, 0x8008000000000000,
  0x8000000000000000, 0x8008000000000000,
  0x8000000000000000, 0x8010000000000000,
  0x8000000000000000, 0x8010000000000000,
  0x8000000000000000, 0x8010000000000001,
  0x8000000000000000, 0x8018000000000000,
  0x8000000000000000, 0x8044000000000000,
  0x8000000000000000, 0xc00fffffffffffff,
  0x8000000000000000, 0xfff0000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff8000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0008000000000000,
  0x0000000000000000, 0x0008000000000000,
  0x0000000000000000, 0x0008000000000000,
  0x0000000000000000, 0x0010000000000000,
  0x0000000000000000, 0x0010000000000000,
  0x0000000000000000, 0x0010000000000001,
  0x0000000000000000, 0x0018000000000000,
  0x0000000000000000, 0x0044000000000000,
  0x0000000000000000, 0x400fffffffffffff,
  0x0000000000000000, 0x7ff0000000000000,
  0x7ff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x7ff0000000000000,
  0x7ff8000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8008000000000000,
  0x8000000000000000, 0xbfcffffffffffffe,
  0x8008000000000000, 0xbfcfffffffffffff,
  0x8008000000000000, 0xbfd0000000000000,
  0x8008000000000000, 0xbfdffffffffffffe,
  0x8010000000000000, 0xbfdfffffffffffff,
  0x8010000000000000, 0xbfe0000000000000,
  0x8010000000000001, 0xbfe7ffffffffffff,
  0x8018000000000000, 0xc013ffffffffffff,
  0x8044000000000000, 0xffdffffffffffffe,
  0xc00fffffffffffff, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0x800091a2b3c4d5e6,
  0x8000000000000000, 0x8007ffffffffffff,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0008000000000000,
  0x0000000000000000, 0x3fcffffffffffffe,
  0x0008000000000000, 0x3fcfffffffffffff,
  0x0008000000000000, 0x3fd0000000000000,
  0x0008000000000000, 0x3fdffffffffffffe,
  0x0010000000000000, 0x3fdfffffffffffff,
  0x0010000000000000, 0x3fe0000000000000,
  0x0010000000000001, 0x3fe7ffffffffffff,
  0x0018000000000000, 0x4013ffffffffffff,
  0x0044000000000000, 0x7fdffffffffffffe,
  0x400fffffffffffff, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x000091a2b3c4d5e6,
  0x0000000000000000, 0x0007ffffffffffff,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8008000000000000,
  0x8008000000000000, 0xbfcfffffffffffff,
  0xbfcffffffffffffe, 0xbfd0000000000000,
  0xbfcfffffffffffff, 0xbfd0000000000001,
  0xbfd0000000000000, 0xbfdfffffffffffff,
  0xbfdffffffffffffe, 0xbfe0000000000000,
  0xbfdfffffffffffff, 0xbfe0000000000001,
  0xbfe0000000000000, 0xbfe8000000000000,
  0xbfe7ffffffffffff, 0xc014000000000000,
  0xc013ffffffffffff, 0xffdfffffffffffff,
  0xffdffffffffffffe, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0x800091a2b3c4d5e6,
  0x800091a2b3c4d5e6, 0x8008000000000000,
  0x8007ffffffffffff, 0x8000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0008000000000000,
  0x0008000000000000, 0x3fcfffffffffffff,
  0x3fcffffffffffffe, 0x3fd0000000000000,
  0x3fcfffffffffffff, 0x3fd0000000000001,
  0x3fd0000000000000, 0x3fdfffffffffffff,
  0x3fdffffffffffffe, 0x3fe0000000000000,
  0x3fdfffffffffffff, 0x3fe0000000000001,
  0x3fe0000000000000, 0x3fe8000000000000,
  0x3fe7ffffffffffff, 0x4014000000000000,
  0x4013ffffffffffff, 0x7fdfffffffffffff,
  0x7fdffffffffffffe, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x000091a2b3c4d5e6,
  0x000091a2b3c4d5e6, 0x0008000000000000,
  0x0007ffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8008000000000000,
  0x8008000000000000, 0xbfd0000000000000,
  0xbfcfffffffffffff, 0xbfd0000000000001,
  0xbfd0000000000000, 0xbfd0000000000002,
  0xbfd0000000000001, 0xbfe0000000000000,
  0xbfdfffffffffffff, 0xbfe0000000000001,
  0xbfe0000000000000, 0xbfe0000000000002,
  0xbfe0000000000001, 0xbfe8000000000002,
  0xbfe8000000000000, 0xc014000000000001,
  0xc014000000000000, 0xffe0000000000000,
  0xffdfffffffffffff, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0x800091a2b3c4d5e7,
  0x800091a2b3c4d5e6, 0x8008000000000000,
  0x8008000000000000, 0x8000000000000001,
  0x8000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0008000000000000,
  0x0008000000000000, 0x3fd0000000000000,
  0x3fcfffffffffffff, 0x3fd0000000000001,
  0x3fd0000000000000, 0x3fd0000000000002,
  0x3fd0000000000001, 0x3fe0000000000000,
  0x3fdfffffffffffff, 0x3fe0000000000001,
  0x3fe0000000000000, 0x3fe0000000000002,
  0x3fe0000000000001, 0x3fe8000000000002,
  0x3fe8000000000000, 0x4014000000000001,
  0x4014000000000000, 0x7fe0000000000000,
  0x7fdfffffffffffff, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x000091a2b3c4d5e7,
  0x000091a2b3c4d5e6, 0x0008000000000000,
  0x0008000000000000, 0x0000000000000001,
  0x0000000000000001, 0x8000000000000000,
  0x8000000000000000, 0x8010000000000000,
  0x8008000000000000, 0xbfdffffffffffffe,
  0xbfd0000000000000, 0xbfdfffffffffffff,
  0xbfd0000000000001, 0xbfe0000000000000,
  0xbfd0000000000002, 0xbfeffffffffffffe,
  0xbfe0000000000000, 0xbfefffffffffffff,
  0xbfe0000000000001, 0xbff0000000000000,
  0xbfe0000000000002, 0xbff7ffffffffffff,
  0xbfe8000000000002, 0xc023ffffffffffff,
  0xc014000000000001, 0xffeffffffffffffe,
  0xffe0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0x800123456789abcd,
  0x800091a2b3c4d5e7, 0x800fffffffffffff,
  0x8008000000000000, 0x8000000000000001,
  0x8000000000000001, 0x0000000000000000,
  0x0000000000000000, 0x0010000000000000,
  0x0008000000000000, 0x3fdffffffffffffe,
  0x3fd0000000000000, 0x3fdfffffffffffff,
  0x3fd0000000000001, 0x3fe0000000000000,
  0x3fd0000000000002, 0x3feffffffffffffe,
  0x3fe0000000000000, 0x3fefffffffffffff,
  0x3fe0000000000001, 0x3ff0000000000000,
  0x3fe0000000000002, 0x3ff7ffffffffffff,
  0x3fe8000000000002, 0x4023ffffffffffff,
  0x4014000000000001, 0x7feffffffffffffe,
  0x7fe0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x000123456789abcd,
  0x000091a2b3c4d5e7, 0x000fffffffffffff,
  0x0008000000000000, 0x0000000000000001,
  0x0000000000000001, 0x8000000000000000,
  0x8000000000000000, 0x8010000000000000,
  0x8010000000000000, 0xbfdfffffffffffff,
  0xbfdffffffffffffe, 0xbfe0000000000000,
  0xbfdfffffffffffff, 0xbfe0000000000001,
  0xbfe0000000000000, 0xbfefffffffffffff,
  0xbfeffffffffffffe, 0xbff0000000000000,
  0xbfefffffffffffff, 0xbff0000000000001,
  0xbff0000000000000, 0xbff8000000000000,
  0xbff7ffffffffffff, 0xc024000000000000,
  0xc023ffffffffffff, 0xffefffffffffffff,
  0xffeffffffffffffe, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0x800123456789abcd,
  0x800123456789abcd, 0x800fffffffffffff,
  0x800fffffffffffff, 0x8000000000000001,
  0x8000000000000001, 0x0000000000000000,
  0x0000000000000000, 0x0010000000000000,
  0x0010000000000000, 0x3fdfffffffffffff,
  0x3fdffffffffffffe, 0x3fe0000000000000,
  0x3fdfffffffffffff, 0x3fe0000000000001,
  0x3fe0000000000000, 0x3fefffffffffffff,
  0x3feffffffffffffe, 0x3ff0000000000000,
  0x3fefffffffffffff, 0x3ff0000000000001,
  0x3ff0000000000000, 0x3ff8000000000000,
  0x3ff7ffffffffffff, 0x4024000000000000,
  0x4023ffffffffffff, 0x7fefffffffffffff,
  0x7feffffffffffffe, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x000123456789abcd,
  0x000123456789abcd, 0x000fffffffffffff,
  0x000fffffffffffff, 0x0000000000000001,
  0x0000000000000001, 0x8000000000000000,
  0x8000000000000000, 0x8010000000000001,
  0x8010000000000000, 0xbfe0000000000000,
  0xbfdfffffffffffff, 0xbfe0000000000001,
  0xbfe0000000000000, 0xbfe0000000000002,
  0xbfe0000000000001, 0xbff0000000000000,
  0xbfefffffffffffff, 0xbff0000000000001,
  0xbff0000000000000, 0xbff0000000000002,
  0xbff0000000000001, 0xbff8000000000002,
  0xbff8000000000000, 0xc024000000000001,
  0xc024000000000000, 0xfff0000000000000,
  0xffefffffffffffff, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0x800123456789abcd,
  0x800123456789abcd, 0x8010000000000000,
  0x800fffffffffffff, 0x8000000000000001,
  0x8000000000000001, 0x0000000000000000,
  0x0000000000000000, 0x0010000000000001,
  0x0010000000000000, 0x3fe0000000000000,
  0x3fdfffffffffffff, 0x3fe0000000000001,
  0x3fe0000000000000, 0x3fe0000000000002,
  0x3fe0000000000001, 0x3ff0000000000000,
  0x3fefffffffffffff, 0x3ff0000000000001,
  0x3ff0000000000000, 0x3ff0000000000002,
  0x3ff0000000000001, 0x3ff8000000000002,
  0x3ff8000000000000, 0x4024000000000001,
  0x4024000000000000, 0x7ff0000000000000,
  0x7fefffffffffffff, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x000123456789abcd,
  0x000123456789abcd, 0x0010000000000000,
  0x000fffffffffffff, 0x0000000000000001,
  0x0000000000000001, 0x8000000000000000,
  0x8000000000000000, 0x8018000000000000,
  0x8010000000000001, 0xbfe7ffffffffffff,
  0xbfe0000000000000, 0xbfe8000000000000,
  0xbfe0000000000001, 0xbfe8000000000002,
  0xbfe0000000000002, 0xbff7ffffffffffff,
  0xbff0000000000000, 0xbff8000000000000,
  0xbff0000000000001, 0xbff8000000000002,
  0xbff0000000000002, 0xc002000000000000,
  0xbff8000000000002, 0xc02e000000000000,
  0xc024000000000001, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0x8001b4e81b4e81b4,
  0x800123456789abcd, 0x8017fffffffffffe,
  0x8010000000000000, 0x8000000000000002,
  0x8000000000000001, 0x0000000000000000,
  0x0000000000000000, 0x0018000000000000,
  0x0010000000000001, 0x3fe7ffffffffffff,
  0x3fe0000000000000, 0x3fe8000000000000,
  0x3fe0000000000001, 0x3fe8000000000002,
  0x3fe0000000000002, 0x3ff7ffffffffffff,
  0x3ff0000000000000, 0x3ff8000000000000,
  0x3ff0000000000001, 0x3ff8000000000002,
  0x3ff0000000000002, 0x4002000000000000,
  0x3ff8000000000002, 0x402e000000000000,
  0x4024000000000001, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x0001b4e81b4e81b4,
  0x000123456789abcd, 0x0017fffffffffffe,
  0x0010000000000000, 0x0000000000000002,
  0x0000000000000002, 0x8000000000000000,
  0x8000000000000000, 0x8044000000000000,
  0x8018000000000000, 0xc013ffffffffffff,
  0xbfe7ffffffffffff, 0xc014000000000000,
  0xbfe8000000000000, 0xc014000000000001,
  0xbfe8000000000002, 0xc023ffffffffffff,
  0xbff7ffffffffffff, 0xc024000000000000,
  0xbff8000000000000, 0xc024000000000001,
  0xbff8000000000002, 0xc02e000000000000,
  0xc002000000000000, 0xc059000000000000,
  0xc02e000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0x800b60b60b60b602,
  0x8001b4e81b4e81b4, 0x8043ffffffffffff,
  0x8017fffffffffffe, 0x800000000000000a,
  0x8000000000000002, 0x0000000000000000,
  0x0000000000000000, 0x0044000000000000,
  0x0018000000000000, 0x4013ffffffffffff,
  0x3fe7ffffffffffff, 0x4014000000000000,
  0x3fe8000000000000, 0x4014000000000001,
  0x3fe8000000000002, 0x4023ffffffffffff,
  0x3ff7ffffffffffff, 0x4024000000000000,
  0x3ff8000000000000, 0x4024000000000001,
  0x3ff8000000000002, 0x402e000000000000,
  0x4002000000000000, 0x4059000000000000,
  0x402e000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x000b60b60b60b602,
  0x0001b4e81b4e81b4, 0x0043ffffffffffff,
  0x0017fffffffffffe, 0x000000000000000a,
  0x000000000000000a, 0x8000000000000000,
  0x8000000000000000, 0xc00fffffffffffff,
  0x8044000000000000, 0xffdffffffffffffe,
  0xc013ffffffffffff, 0xffdfffffffffffff,
  0xc014000000000000, 0xffe0000000000000,
  0xc014000000000001, 0xffeffffffffffffe,
  0xc023ffffffffffff, 0xffefffffffffffff,
  0xc024000000000000, 0xfff0000000000000,
  0xc024000000000001, 0xfff0000000000000,
  0xc02e000000000000, 0xfff0000000000000,
  0xc059000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0xbfd23456789abccf,
  0x800b60b60b60b602, 0xc00ffffffffffffd,
  0x8043ffffffffffff, 0xbccfffffffffffff,
  0x800000000000000a, 0x0000000000000000,
  0x0000000000000000, 0x400fffffffffffff,
  0x0044000000000000, 0x7fdffffffffffffe,
  0x4013ffffffffffff, 0x7fdfffffffffffff,
  0x4014000000000000, 0x7fe0000000000000,
  0x4014000000000001, 0x7feffffffffffffe,
  0x4023ffffffffffff, 0x7fefffffffffffff,
  0x4024000000000000, 0x7ff0000000000000,
  0x4024000000000001, 0x7ff0000000000000,
  0x402e000000000000, 0x7ff0000000000000,
  0x4059000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x3fd23456789abccf,
  0x000b60b60b60b602, 0x400ffffffffffffd,
  0x0043ffffffffffff, 0x3ccfffffffffffff,
  0x3ccfffffffffffff, 0x7ff8000000000000,
  0x8000000000000000, 0xfff0000000000000,
  0xc00fffffffffffff, 0xfff0000000000000,
  0xffdffffffffffffe, 0xfff0000000000000,
  0xffdfffffffffffff, 0xfff0000000000000,
  0xffe0000000000000, 0xfff0000000000000,
  0xffeffffffffffffe, 0xfff0000000000000,
  0xffefffffffffffff, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xbfd23456789abccf, 0xfff0000000000000,
  0xc00ffffffffffffd, 0xfff0000000000000,
  0xbccfffffffffffff, 0x7ff8000000000000,
  0x0000000000000000, 0x7ff0000000000000,
  0x400fffffffffffff, 0x7ff0000000000000,
  0x7fdffffffffffffe, 0x7ff0000000000000,
  0x7fdfffffffffffff, 0x7ff0000000000000,
  0x7fe0000000000000, 0x7ff0000000000000,
  0x7feffffffffffffe, 0x7ff0000000000000,
  0x7fefffffffffffff, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x3fd23456789abccf, 0x7ff0000000000000,
  0x400ffffffffffffd, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff923456789abcd,
  0x7ff8000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0x7ff923456789abcd, 0xfff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0x7ff8000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0x7ff923456789abcd, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x7ff8000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0x7ff923456789abcd,
  0xfff923456789abcd, 0x7ff8000000000000,
  0xfff923456789abcd, 0x7ff923456789abcd,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0x7ff8000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff923456789abcd,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x8000000000000000,
  0x7ff8000000000000, 0x8000000000000000,
  0xfff0000000000000, 0x800091a2b3c4d5e6,
  0xfff0000000000000, 0x800091a2b3c4d5e6,
  0xfff0000000000000, 0x800091a2b3c4d5e7,
  0xfff0000000000000, 0x800123456789abcd,
  0xfff0000000000000, 0x800123456789abcd,
  0xfff0000000000000, 0x800123456789abcd,
  0xfff0000000000000, 0x8001b4e81b4e81b4,
  0xfff0000000000000, 0x800b60b60b60b602,
  0xfff0000000000000, 0xbfd23456789abccf,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0x8000000000000000,
  0xfff0000000000000, 0x8000000000000000,
  0xfff0000000000000, 0x8000000000000000,
  0xfff0000000000000, 0x0000000000000000,
  0x7ff8000000000000, 0x0000000000000000,
  0x7ff0000000000000, 0x000091a2b3c4d5e6,
  0x7ff0000000000000, 0x000091a2b3c4d5e6,
  0x7ff0000000000000, 0x000091a2b3c4d5e7,
  0x7ff0000000000000, 0x000123456789abcd,
  0x7ff0000000000000, 0x000123456789abcd,
  0x7ff0000000000000, 0x000123456789abcd,
  0x7ff0000000000000, 0x0001b4e81b4e81b4,
  0x7ff0000000000000, 0x000b60b60b60b602,
  0x7ff0000000000000, 0x3fd23456789abccf,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x0000000000000000,
  0x7ff0000000000000, 0x0000000000000000,
  0x7ff0000000000000, 0x0000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8007ffffffffffff,
  0x800091a2b3c4d5e6, 0x8008000000000000,
  0x800091a2b3c4d5e6, 0x8008000000000000,
  0x800091a2b3c4d5e7, 0x800fffffffffffff,
  0x800123456789abcd, 0x800fffffffffffff,
  0x800123456789abcd, 0x8010000000000000,
  0x800123456789abcd, 0x8017fffffffffffe,
  0x8001b4e81b4e81b4, 0x8043ffffffffffff,
  0x800b60b60b60b602, 0xc00ffffffffffffd,
  0xbfd23456789abccf, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0007ffffffffffff,
  0x000091a2b3c4d5e6, 0x0008000000000000,
  0x000091a2b3c4d5e6, 0x0008000000000000,
  0x000091a2b3c4d5e7, 0x000fffffffffffff,
  0x000123456789abcd, 0x000fffffffffffff,
  0x000123456789abcd, 0x0010000000000000,
  0x000123456789abcd, 0x0017fffffffffffe,
  0x0001b4e81b4e81b4, 0x0043ffffffffffff,
  0x000b60b60b60b602, 0x400ffffffffffffd,
  0x3fd23456789abccf, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8007ffffffffffff, 0x8000000000000000,
  0x8008000000000000, 0x8000000000000001,
  0x8008000000000000, 0x8000000000000001,
  0x800fffffffffffff, 0x8000000000000001,
  0x800fffffffffffff, 0x8000000000000001,
  0x8010000000000000, 0x8000000000000002,
  0x8017fffffffffffe, 0x800000000000000a,
  0x8043ffffffffffff, 0xbccfffffffffffff,
  0xc00ffffffffffffd, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0007ffffffffffff, 0x0000000000000000,
  0x0008000000000000, 0x0000000000000001,
  0x0008000000000000, 0x0000000000000001,
  0x000fffffffffffff, 0x0000000000000001,
  0x000fffffffffffff, 0x0000000000000001,
  0x0010000000000000, 0x0000000000000002,
  0x0017fffffffffffe, 0x000000000000000a,
  0x0043ffffffffffff, 0x3ccfffffffffffff,
  0x400ffffffffffffd, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
};
const unsigned kExpectedCount_NEON_fmul_2D = 1444;

#endif  // VIXL_SIM_FMUL_2D_TRACE_AARCH64_H_
