/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.client.prefs;

import com.sun.appserv.management.client.prefs.LoginInfoStore;
import com.sun.appserv.management.client.prefs.MemoryHashLoginInfoStore;
import com.sun.appserv.management.client.prefs.StoreException;
import java.util.Arrays;

public class LoginInfoStoreFactory {
    private LoginInfoStoreFactory() {
    }

    public static LoginInfoStore getStore(String storeImplClassName) throws StoreException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        LoginInfoStore store = null;
        store = storeImplClassName == null ? LoginInfoStoreFactory.getDefaultStore() : LoginInfoStoreFactory.getCustomStore(storeImplClassName);
        return store;
    }

    private static LoginInfoStore getDefaultStore() throws StoreException {
        return new MemoryHashLoginInfoStore();
    }

    private static LoginInfoStore getCustomStore(String icn) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> ic = Class.forName(icn);
        String in = LoginInfoStore.class.getName();
        if (ic == null || !LoginInfoStoreFactory.isStore(ic)) {
            throw new IllegalArgumentException("Class: " + ic.getName() + " does not implement: " + in);
        }
        LoginInfoStore store = (LoginInfoStore)ic.newInstance();
        return store;
    }

    private static boolean isStore(Class c) {
        Class<?>[] ifs = c.getInterfaces();
        Class<LoginInfoStore> sc = LoginInfoStore.class;
        return Arrays.asList(ifs).contains(sc);
    }
}

