#include "application-system.h"

struct _ApplicationSystem
{
	GObject parent_instance;
	GHashTable *startupids;
	GHashTable *simpletons;
	GHashTable *desktops;
	GHashTable *exec_cache;
	GHashTable *pid_cache;
	GAppInfoMonitor *monitor;
	gboolean invalidated;
	GRecMutex __lock_invalidated;
	GDBusConnection *bus;
};

uint app_changed_singal;

G_DEFINE_TYPE(ApplicationSystem, application_system, G_TYPE_OBJECT)

static void application_system_finalize(GObject *obj)
{
	ApplicationSystem *self = APPMENU_SYSTEM(obj);
	g_clear_pointer(&self->startupids, g_hash_table_unref);
	g_clear_pointer(&self->simpletons, g_hash_table_unref);
	g_clear_pointer(&self->desktops, g_hash_table_unref);
	g_clear_pointer(&self->exec_cache, g_hash_table_unref);
	g_clear_pointer(&self->pid_cache, g_hash_table_unref);
	g_rec_mutex_clear(&self->__lock_invalidated);
	g_clear_object(&self->bus);
	g_clear_object(&self->monitor);
	G_OBJECT_CLASS(application_system_parent_class)->finalize(obj);
}

static void application_system_class_init(ApplicationSystemClass *klass)
{
	application_system_parent_class = g_type_class_peek_parent(klass);
	G_OBJECT_CLASS(klass)->finalize = application_system_finalize;
	app_changed_singal              = g_signal_new("app-launched",
                                          application_system_get_type(),
                                          G_SIGNAL_RUN_LAST,
                                          0,
                                          NULL,
                                          NULL,
                                          g_cclosure_marshal_VOID__STRING,
                                          G_TYPE_NONE,
                                          1,
                                          G_TYPE_STRING);
}

static void create_simpletons(ApplicationSystem *self)
{
	g_hash_table_insert(self->simpletons,
	                    g_strdup("google-chrome-stable"),
	                    g_strdup("google-chrome"));
	g_hash_table_insert(self->simpletons, g_strdup("calibre-gui"), g_strdup("calibre"));
	g_hash_table_insert(self->simpletons, g_strdup("code - oss"), g_strdup("vscode-oss"));
	g_hash_table_insert(self->simpletons, g_strdup("code"), g_strdup("vscode"));
	g_hash_table_insert(self->simpletons, g_strdup("psppire"), g_strdup("pspp"));
	g_hash_table_insert(self->simpletons,
	                    g_strdup("gnome-twitch"),
	                    g_strdup("com.vinszent.gnometwitch"));
	g_hash_table_insert(self->simpletons, g_strdup("anoise.py"), g_strdup("anoise"));
}

static void application_system_init(ApplicationSystem *self)
{
	self->startupids = g_hash_table_new_full(g_str_hash, g_str_equal, g_free, g_free);
	self->simpletons = g_hash_table_new_full(g_str_hash, g_str_equal, g_free, g_free);
	create_simpletons(self);
	self->desktops   = g_hash_table_new_full(g_str_hash, g_str_equal, g_free, g_object_unref);
	self->exec_cache = g_hash_table_new_full(g_str_hash, g_str_equal, g_free, g_free);
	self->pid_cache  = g_hash_table_new_full(g_direct_hash, g_direct_equal, NULL, g_free);
	self->monitor    = g_app_info_monitor_get();
	g_rec_mutex_init(&self->__lock_invalidated);
	self->invalidated = FALSE;
}
