/**
	@license GNU GPLv2
	PROJECT "db_table"
	Copyright  2006 Danilo Cicerone

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software Foundation,
	Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
*/

/**
	@file db_table.cxx
	@author Danilo Cicerone info@digitazero.org
	@date 2006-12-05
	@version 0.2.2
*/

#include "db_table.h"

DB_Table::DB_Table(int x, int y, int w, int h, const char *l) :
	Fl_Table_Row(x,y,w,h,l)
{
	end();
}

DB_Table::~DB_Table()
{

}

void
DB_Table::draw_cell(TableContext context,
	int R, int C, int X, int Y, int W, int H)
{
	//fprintf(stderr, "%d %d\n", R, C);

	switch (context)
	{
		case CONTEXT_STARTPAGE:
			fl_font(FL_HELVETICA, 12);
			return;

		case CONTEXT_COL_HEADER:
			fl_push_clip(X, Y, W, H);
			{
				fl_draw_box(FL_THIN_UP_BOX, X, Y, W, H, color());
				fl_color(FL_BLACK);
				fl_draw(xTable_Header[C].c_str(), X, Y, W, H, FL_ALIGN_CENTER);
			}
			fl_pop_clip();
			return;

		case CONTEXT_CELL:
		{
			fl_push_clip(X, Y, W, H);
			{
				if (R % 2)
				{
					// BG COLOR
					fl_color(row_selected(R) ? selection_color() : FL_GRAY);
					fl_rectf(X, Y, W, H);
				}
				else
				{
					// BG COLOR
					fl_color(row_selected(R) ? selection_color() : FL_WHITE);
					fl_rectf(X, Y, W, H);
				}

				// TEXT
				fl_color(row_selected(R) ? FL_WHITE : FL_BLACK);
				fl_draw(xTable[R * (int)cols() + C].c_str(), X, Y, W, H, FL_ALIGN_CENTER);

				// BORDER
				fl_color(FL_LIGHT2);
				fl_rect(X, Y, W, H);
			}
			fl_pop_clip();
			return;
		}

		default:
		return;
	}
}
