## TFSA-2021-157: FPE in TFLite division operations

### CVE Number
CVE-2021-37683

### Impact
The implementation of division in TFLite is [vulnerable to a division by 0
error](https://github.com/tensorflow/tensorflow/blob/460e000de3a83278fb00b61a16d161b1964f15f4/tensorflow/lite/kernels/div.cc)

There is no check that the divisor tensor does not contain zero elements.

### Patches
We have patched the issue in GitHub commit
[1e206baedf8bef0334cca3eb92bab134ef525a28](https://github.com/tensorflow/tensorflow/commit/1e206baedf8bef0334cca3eb92bab134ef525a28).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
