'\"
'\" Generated from file 'bibtex\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2005 for documentation, Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>
'\"
.TH "bibtex" n 0\&.8 tcllib "bibtex"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
bibtex \- Parse bibtex files
.SH SYNOPSIS
package require \fBTcl 8\&.5 9\fR
.sp
package require \fBbibtex ?0\&.8?\fR
.sp
\fB::bibtex::parse\fR ?\fIoptions\fR? ?\fItext\fR?
.sp
\fB::bibtex::parse\fR \fItext\fR
.sp
\fB::bibtex::parse\fR ?\fB-command\fR \fIcmd\fR? \fB-channel\fR \fIchan\fR
.sp
\fB::bibtex::parse\fR ?\fB-recordcommand\fR   \fIrecordcmd\fR? ?\fB-preamblecommand\fR \fIpreamblecmd\fR? ?\fB-stringcommand\fR   \fIstringcmd\fR? ?\fB-commentcommand\fR  \fIcommentcmd\fR? ?\fB-progresscommand\fR \fIprogresscmd\fR? ?\fB-casesensitivestrings\fR \fIbool\fR? (\fItext\fR | \fB-channel\fR \fIchan\fR)
.sp
\fB::bibtex::wait\fR \fItoken\fR
.sp
\fB::bibtex::destroy\fR \fItoken\fR
.sp
\fB::bibtex::addStrings\fR \fItoken\fR \fIstringdict\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides commands for the parsing of bibliographies in
BibTeX format\&.
.TP
\fB::bibtex::parse\fR ?\fIoptions\fR? ?\fItext\fR?
This is the general form of the command for parsing a
bibliography\&. Depending on the options used to invoke it it will
either return a token for the parser, or the parsed entries of the
input bibliography\&. Instead of performing an immediate parse returning
a predefined format the command can also enter an event-based parsing
style where all relevant entries in the input are reported through
callback commands, in the style of SAX\&.
.TP
\fB::bibtex::parse\fR \fItext\fR
In this form the command will assume that the specified \fItext\fR is
a bibliography in BibTeX format, parse it, and then return a list
containing one element per record found in the bibliography\&. Note that
comments, string definitions, preambles, etc\&. will not show up in the
result\&.  Each element will be a list containing record type,
bibliography key and record data, in this order\&. The record data will
be a dictionary, its keys the keys of the record, with the associated
values\&.
.TP
\fB::bibtex::parse\fR ?\fB-command\fR \fIcmd\fR? \fB-channel\fR \fIchan\fR
In this form the command will reads the bibliography from the
specified Tcl channel \fIchan\fR and then returns the same data
structure as described above\&.
.sp
If however the option \fB-command\fR is specified the result will be a
handle for the parser instead and all processing will be incremental
and happen in the background\&. When the input has been exhausted the
callback \fIcmd\fR will be invoked with the result of the parse\&. The
exact definition for the callback is
.sp
.RS
.TP
\fBcmd\fR \fItoken\fR \fIparseresult\fR
The parse result will have the structure explained above, for the
simpler forms of the parser\&.
.RE
.sp
\fINote\fR that the parser will \fInot\fR close the channel after it
has exhausted it\&. This is still the responsibility of the user of the
parser\&.
.TP
\fB::bibtex::parse\fR ?\fB-recordcommand\fR   \fIrecordcmd\fR? ?\fB-preamblecommand\fR \fIpreamblecmd\fR? ?\fB-stringcommand\fR   \fIstringcmd\fR? ?\fB-commentcommand\fR  \fIcommentcmd\fR? ?\fB-progresscommand\fR \fIprogresscmd\fR? ?\fB-casesensitivestrings\fR \fIbool\fR? (\fItext\fR | \fB-channel\fR \fIchan\fR)
This is the most low-level form for the parser\&. The returned result
will be a handle for the parser\&. During processing it will invoke the
invoke the specified callback commands for each type of data found in
the bibliography\&.
.sp
The processing will be incremental and happen in the background if,
and only if a Tcl channel \fIchan\fR is specified\&. For a \fItext\fR
the processing will happen immediately and all callbacks will be
invoked before the command itself returns\&.
.sp
The callbacks, i\&.e\&. \fI*cmd\fR, are all command prefixes and will be
invoked with additional arguments appended to them\&. The meaning of the
arguments depends on the callback and is explained below\&. The first
argument will however always be the handle of the parser invoking the
callback\&.
.RS
.TP
\fB-casesensitivestrings\fR
This option takes a boolean value\&. When set string macro processing
becomes case-sensitive\&. The default is case-insensitive string macro
processing\&.
.TP
\fBrecordcmd\fR \fItoken\fR \fItype\fR \fIkey\fR \fIrecorddict\fR
This callback is invoked whenever the parser detects a bibliography
record in the input\&. Its arguments are the record type, the
bibliography key for the record, and a dictionary containing the keys
and values describing the record\&. Any string macros known to the
parser have already been expanded\&.
.TP
\fBpreamblecmd\fR \fItoken\fR \fIpreambletext\fR
This callback is invoked whenever the parser detects an @preamble
block in the input\&. The only additional argument is the text found in
the preamble block\&. By default such entries are ignored\&.
.TP
\fBstringcmd\fR \fItoken\fR \fIstringdict\fR
This callback is invoked whenever the parser detects an @string-based
macro definition in the input\&. The argument is a dictionary with the
macro names as keys and their replacement strings as values\&. By
default such definitions are added to the parser state for use in
future bibliography records\&.
.TP
\fBcommentcmd\fR \fItoken\fR \fIcommenttext\fR
This callback is invoked whenever the parser detects a comment in the
input\&. The only additional argument is the comment text\&. By default
such entries are ignored\&.
.TP
\fBprogresscmd\fR \fItoken\fR \fIpercent\fR
This callback is invoked during processing to tell the user about the
progress which has been made\&. Its argument is the percentage of data
processed, as integer number between \fB0\fR and \fB100\fR\&.
In the case of incremental processing the perecentage will always be
\fB-1\fR as the total number of entries is not known beforehand\&.
.RE
.sp
.TP
\fB::bibtex::wait\fR \fItoken\fR
This command waits for the parser represented by the \fItoken\fR to
complete and then returns\&. The returned result is the empty string\&.
.TP
\fB::bibtex::destroy\fR \fItoken\fR
This command cleans up all internal state associated with the parser
represented by the handle \fItoken\fR, effectively destroying it\&. This
command can be called from within the parser callbacks to terminate
processing\&.
.TP
\fB::bibtex::addStrings\fR \fItoken\fR \fIstringdict\fR
This command adds the macro definitions stored in the
dictionary \fIstringdict\fR to the parser represented
by the handle \fItoken\fR\&.
.sp
The dictionary keys are the macro names and the values their
replacement strings\&. This command has the correct signature for use as
a \fB-stringcommand\fR callback in an invokation of the command
\fB::bibtex::parse\fR\&.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIbibtex\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
bibliography, bibtex, parsing, text processing
.SH CATEGORY
Text processing
.SH COPYRIGHT
.nf
Copyright (c) 2005 for documentation, Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>

.fi
