/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef PIXLABEL_H
#define PIXLABEL_H

#include <QLabel>
#include <QPixmap>
#include <QString>
#include <QMenu>
#include <QMouseEvent>
#include <QAction>

#include <QScrollArea>

class PictureScrollArea;

/**
	@author Anistratov Oleg <ower@users.sourceforge.net>
*/

class PixLabel : public QLabel
{
  Q_OBJECT
  private:
    QLabel*  m_fullPicture;
    QString  m_filename;
    QString  m_lastdir;
    QString  m_label;
    QPixmap* m_pixmap;
    QMenu*   m_menu;
    QAction* m_cancelAct;
    QAction* m_fullSizeAct;
    bool     m_readOnly;
    PictureScrollArea* m_scrollPic;

  public:
    PixLabel(QString label, QWidget* parent = 0 );
    ~PixLabel(){};

    void retranslate();

    const QPixmap*  pixmap     () const {return m_pixmap  ;}
    const QString & filename   () const {return m_filename;}
    void freePixmap ();
    void setReadOnly(bool ro){m_readOnly = ro;}
    void setTextLabel(const QString & str){setText(str); m_label = str;}

  public slots:
    void slot_cancelPicture   ();
    void slot_choosePictureDlg();
    void slot_setPixmap(const QPixmap & pix);
    void slot_setPixmap       (const QPixmap* );
    void slot_setFilename     (const QString & fname){if(!fname.isNull())m_filename = fname; else m_filename = "";}
    void slot_setLastdir      (const QString & ldir ){if(!ldir .isNull())m_lastdir  = ldir ;}
    void slot_showFullSize    ();

  protected:
    void mouseReleaseEvent(QMouseEvent * ev)
    {
      if(ev->button() == Qt::RightButton && !m_readOnly)
        m_menu->popup(ev->globalPos());
    }
    void mouseDoubleClickEvent(QMouseEvent * ev)
    {
      if(ev->button()== Qt::LeftButton) emit clicked();
      if(m_readOnly) slot_showFullSize();
    }

  signals:
    void clicked();
    void changed();
};

#endif
