/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* eslint-disable no-new-wrappers */

'use strict';

var Number = require( '@stdlib/number/ctor' );
var isDateObjectArray = require( './../lib' );

var bool = isDateObjectArray( [ new Date(), new Date(), new Date() ] );
console.log( bool );
// => true

bool = isDateObjectArray( [ new Date(), new Number( 3 ) ] );
console.log( bool );
// => false

bool = isDateObjectArray( [ new Date(), new String( '2017-01-01' ), {} ] );
console.log( bool );
// => false

bool = isDateObjectArray( [ [], {} ] );
console.log( bool );
// => false

bool = isDateObjectArray( [ 'a', 'b' ] );
console.log( bool );
// => false

bool = isDateObjectArray( [] );
console.log( bool );
// => false
