var actual = fn("**/a/*/b/c/.js");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\/b\/c\/\.js)$/);

var actual = fn("**/a/*/b/c.d/.js");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\/b\/c\.d\/\.js)$/);

var actual = fn("**/*.{*,gitignore}");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.[^/]*?|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.gitignore)$/);

var actual = fn("**/*.{js,gitignore}");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.gitignore)$/);

var actual = fn("**/{a,/.gitignore}");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/a|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/\.gitignore)$/);

var actual = fn("**/{a..z..2}/*.js");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/c\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/e\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/g\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/i\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/k\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/m\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/o\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/q\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/s\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/u\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/w\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/y\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js)$/);

var actual = fn("**/{a..c}/*.js");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/b\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/c\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js)$/);

var actual = fn("**/{1..10}/*.js");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/1\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/2\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/3\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/4\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/5\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/6\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/7\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/8\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/9\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/10\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js)$/);

var actual = fn("**/{1..10..2}/*.js");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/1\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/3\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/5\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/7\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/9\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js)$/);

var actual = fn("a/{b..s}/xyz/*-{01..10}.js");
actual.should.eql(/^(?:a\/b\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-01\.js|a\/b\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-02\.js|a\/b\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-03\.js|a\/b\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-04\.js|a\/b\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-05\.js|a\/b\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-06\.js|a\/b\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-07\.js|a\/b\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-08\.js|a\/b\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-09\.js|a\/b\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-10\.js|a\/c\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-01\.js|a\/c\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-02\.js|a\/c\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-03\.js|a\/c\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-04\.js|a\/c\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-05\.js|a\/c\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-06\.js|a\/c\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-07\.js|a\/c\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-08\.js|a\/c\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-09\.js|a\/c\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-10\.js|a\/d\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-01\.js|a\/d\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-02\.js|a\/d\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-03\.js|a\/d\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-04\.js|a\/d\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-05\.js|a\/d\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-06\.js|a\/d\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-07\.js|a\/d\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-08\.js|a\/d\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-09\.js|a\/d\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-10\.js|a\/e\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-01\.js|a\/e\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-02\.js|a\/e\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-03\.js|a\/e\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-04\.js|a\/e\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-05\.js|a\/e\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-06\.js|a\/e\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-07\.js|a\/e\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-08\.js|a\/e\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-09\.js|a\/e\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-10\.js|a\/f\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-01\.js|a\/f\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-02\.js|a\/f\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-03\.js|a\/f\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-04\.js|a\/f\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-05\.js|a\/f\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-06\.js|a\/f\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-07\.js|a\/f\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-08\.js|a\/f\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-09\.js|a\/f\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-10\.js|a\/g\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-01\.js|a\/g\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-02\.js|a\/g\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-03\.js|a\/g\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-04\.js|a\/g\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-05\.js|a\/g\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-06\.js|a\/g\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-07\.js|a\/g\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-08\.js|a\/g\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-09\.js|a\/g\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-10\.js|a\/h\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-01\.js|a\/h\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-02\.js|a\/h\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-03\.js|a\/h\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-04\.js|a\/h\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-05\.js|a\/h\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-06\.js|a\/h\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-07\.js|a\/h\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-08\.js|a\/h\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-09\.js|a\/h\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-10\.js|a\/i\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-01\.js|a\/i\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-02\.js|a\/i\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-03\.js|a\/i\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-04\.js|a\/i\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-05\.js|a\/i\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-06\.js|a\/i\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-07\.js|a\/i\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-08\.js|a\/i\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-09\.js|a\/i\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-10\.js|a\/j\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-01\.js|a\/j\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-02\.js|a\/j\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-03\.js|a\/j\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-04\.js|a\/j\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-05\.js|a\/j\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-06\.js|a\/j\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-07\.js|a\/j\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-08\.js|a\/j\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-09\.js|a\/j\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-10\.js|a\/k\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-01\.js|a\/k\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-02\.js|a\/k\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-03\.js|a\/k\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-04\.js|a\/k\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-05\.js|a\/k\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-06\.js|a\/k\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-07\.js|a\/k\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-08\.js|a\/k\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-09\.js|a\/k\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-10\.js|a\/l\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-01\.js|a\/l\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-02\.js|a\/l\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-03\.js|a\/l\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-04\.js|a\/l\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-05\.js|a\/l\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-06\.js|a\/l\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-07\.js|a\/l\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-08\.js|a\/l\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-09\.js|a\/l\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-10\.js|a\/m\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-01\.js|a\/m\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-02\.js|a\/m\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-03\.js|a\/m\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-04\.js|a\/m\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-05\.js|a\/m\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-06\.js|a\/m\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-07\.js|a\/m\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-08\.js|a\/m\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-09\.js|a\/m\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-10\.js|a\/n\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-01\.js|a\/n\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-02\.js|a\/n\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-03\.js|a\/n\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-04\.js|a\/n\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-05\.js|a\/n\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-06\.js|a\/n\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-07\.js|a\/n\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-08\.js|a\/n\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-09\.js|a\/n\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-10\.js|a\/o\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-01\.js|a\/o\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-02\.js|a\/o\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-03\.js|a\/o\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-04\.js|a\/o\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-05\.js|a\/o\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-06\.js|a\/o\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-07\.js|a\/o\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-08\.js|a\/o\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-09\.js|a\/o\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-10\.js|a\/p\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-01\.js|a\/p\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-02\.js|a\/p\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-03\.js|a\/p\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-04\.js|a\/p\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-05\.js|a\/p\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-06\.js|a\/p\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-07\.js|a\/p\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-08\.js|a\/p\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-09\.js|a\/p\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-10\.js|a\/q\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-01\.js|a\/q\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-02\.js|a\/q\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-03\.js|a\/q\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-04\.js|a\/q\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-05\.js|a\/q\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-06\.js|a\/q\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-07\.js|a\/q\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-08\.js|a\/q\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-09\.js|a\/q\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-10\.js|a\/r\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-01\.js|a\/r\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-02\.js|a\/r\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-03\.js|a\/r\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-04\.js|a\/r\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-05\.js|a\/r\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-06\.js|a\/r\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-07\.js|a\/r\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-08\.js|a\/r\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-09\.js|a\/r\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-10\.js|a\/s\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-01\.js|a\/s\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-02\.js|a\/s\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-03\.js|a\/s\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-04\.js|a\/s\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-05\.js|a\/s\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-06\.js|a\/s\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-07\.js|a\/s\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-08\.js|a\/s\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-09\.js|a\/s\/xyz\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?-10\.js)$/);

var actual = fn("a");
actual.should.eql(/^(?:a)$/);

var actual = fn("a/");
actual.should.eql(/^(?:a\/)$/);

var actual = fn("a/*");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?)$/);

var actual = fn(".*");
actual.should.eql(/^(?:(?=.)\.[^/]*?)$/);

var actual = fn("**/**/.*");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/(?=.)\.[^/]*?)$/);

var actual = fn("**/**/.*");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/(?=.)\.[^/]*?)$/);

var actual = fn("**/.*/.*");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/(?=.)\.[^/]*?\/(?=.)\.[^/]*?)$/);

var actual = fn("**/.*");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/(?=.)\.[^/]*?)$/);

var actual = fn("**/*.*");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.[^/]*?)$/);

var actual = fn("**/*.");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.)$/);

var actual = fn("**/*.a");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.a)$/);

var actual = fn("**/*.js");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js)$/);

var actual = fn("**/*.md");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.md)$/);

var actual = fn("**/.*");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/(?=.)\.[^/]*?)$/);

var actual = fn("**/.*.js");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/(?=.)\.[^/]*?\.js)$/);

var actual = fn("**/.*.md");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/(?=.)\.[^/]*?\.md)$/);

var actual = fn("**/.a");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/\.a)$/);

var actual = fn("**/.a.js");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/\.a\.js)$/);

var actual = fn("**/.gitignore");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/\.gitignore)$/);

var actual = fn("*.*");
actual.should.eql(/^(?:(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.[^/]*?)$/);

var actual = fn("*.a");
actual.should.eql(/^(?:(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.a)$/);

var actual = fn("*.gitignore");
actual.should.eql(/^(?:(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.gitignore)$/);

var actual = fn("*.{gitignore,*}");
actual.should.eql(/^(?:(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.gitignore|(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.[^/]*?)$/);

var actual = fn("*.{*,gitignore,js}");
actual.should.eql(/^(?:(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.[^/]*?|(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.gitignore|(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js)$/);

var actual = fn("*.{*,gitignore}");
actual.should.eql(/^(?:(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.[^/]*?|(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.gitignore)$/);

var actual = fn(".{*,gitignore}");
actual.should.eql(/^(?:(?=.)\.[^/]*?|\.gitignore)$/);

var actual = fn("**/.{*,gitignore}");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/(?=.)\.[^/]*?|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/\.gitignore)$/);

var actual = fn("**/.{js,gitignore}");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/\.gitignore)$/);

var actual = fn("**/.{js,md}");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/\.md)$/);

var actual = fn("**/*.{js,md}");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.md)$/);

var actual = fn("**/(a|b)/*.{js,md}");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/\(a\|b\)\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/\(a\|b\)\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.md)$/);

var actual = fn("**/[a-z]/*.{js,md}");
actual.should.eql(/^(?:(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[a-z]\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[a-z]\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.md)$/);

var actual = fn("*.js");
actual.should.eql(/^(?:(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js)$/);

var actual = fn("*.md");
actual.should.eql(/^(?:(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.md)$/);

var actual = fn("*.{js,txt}");
actual.should.eql(/^(?:(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.txt)$/);

var actual = fn("*/*.gitignore");
actual.should.eql(/^(?:(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.gitignore)$/);

var actual = fn("*/.gitignore");
actual.should.eql(/^(?:(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\/\.gitignore)$/);

var actual = fn(".a");
actual.should.eql(/^(?:\.a)$/);

var actual = fn(".gitignore");
actual.should.eql(/^(?:\.gitignore)$/);

var actual = fn(".js");
actual.should.eql(/^(?:\.js)$/);

var actual = fn(".md");
actual.should.eql(/^(?:\.md)$/);

var actual = fn("a/**/c/*.js");
actual.should.eql(/^(?:a\/(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/c\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js)$/);

var actual = fn("a/**/c/*.md");
actual.should.eql(/^(?:a\/(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/c\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.md)$/);

var actual = fn("a/**/j/**/z/*.js");
actual.should.eql(/^(?:a\/(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/j\/(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/z\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js)$/);

var actual = fn("a/**/j/**/z/*.md");
actual.should.eql(/^(?:a\/(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/j\/(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/z\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.md)$/);

var actual = fn("a/**/z/*.js");
actual.should.eql(/^(?:a\/(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/z\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js)$/);

var actual = fn("a/**/z/*.md");
actual.should.eql(/^(?:a\/(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/z\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.md)$/);

var actual = fn("a/*.js");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js)$/);

var actual = fn("a/*.md");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.md)$/);

var actual = fn("a/*.txt");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.txt)$/);

var actual = fn("a/*/.b");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\/\.b)$/);

var actual = fn("a/*/.b.a");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\/\.b\.a)$/);

var actual = fn("a/*/?/**/e.js");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]\/(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/e\.js)$/);

var actual = fn("a/*/?/**/e.md");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]\/(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/e\.md)$/);

var actual = fn("a/*/b");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\/b)$/);

var actual = fn("a/*/c/*.js");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\/c\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js)$/);

var actual = fn("a/*/c/*.md");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\/c\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.md)$/);

var actual = fn("a/.*/b");
actual.should.eql(/^(?:a\/(?=.)\.[^/]*?\/b)$/);

var actual = fn("a/?/**/e.js");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]\/(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/e\.js)$/);

var actual = fn("a/?/**/e.md");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]\/(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/e\.md)$/);

var actual = fn("a/?/c.js");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]\/c\.js)$/);

var actual = fn("a/?/c.md");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]\/c\.md)$/);

var actual = fn("a/?/c/?/*/e.js");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]\/c\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\/e\.js)$/);

var actual = fn("a/?/c/?/*/e.md");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]\/c\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\/e\.md)$/);

var actual = fn("a/?/c/?/e.js");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]\/c\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]\/e\.js)$/);

var actual = fn("a/?/c/?/e.md");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]\/c\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]\/e\.md)$/);

var actual = fn("a/?/c/???/e.js");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]\/c\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/][^/][^/]\/e\.js)$/);

var actual = fn("a/?/c/???/e.md");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]\/c\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/][^/][^/]\/e\.md)$/);

var actual = fn("a/??/c.js");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/][^/]\/c\.js)$/);

var actual = fn("a/??/c.md");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/][^/]\/c\.md)$/);

var actual = fn("a/???/c.js");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/][^/][^/]\/c\.js)$/);

var actual = fn("a/???/c.md");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/][^/][^/]\/c\.md)$/);

var actual = fn("a/????/c.js");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/][^/][^/][^/]\/c\.js)$/);

var actual = fn("a/????/c.md");
actual.should.eql(/^(?:a\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/][^/][^/][^/]\/c\.md)$/);

var actual = fn("a/b/**/c{d,e}/**/xyz.js");
actual.should.eql(/^(?:a\/b\/(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/cd\/(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/xyz\.js|a\/b\/(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/ce\/(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/xyz\.js)$/);

var actual = fn("a/b/**/c{d,e}/**/xyz.md");
actual.should.eql(/^(?:a\/b\/(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/cd\/(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/xyz\.md|a\/b\/(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/ce\/(?:(?!(?:\/|^)(?:\.{1,2})($|\/)).)*?\/xyz\.md)$/);

var actual = fn("a/b/c/*.js");
actual.should.eql(/^(?:a\/b\/c\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js)$/);

var actual = fn("A/b/C/*.js");
actual.should.eql(/^(?:A\/b\/C\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js)$/);

var actual = fn("a/b/c/*.md");
actual.should.eql(/^(?:a\/b\/c\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.md)$/);

var actual = fn("A/b/C/*.md");
actual.should.eql(/^(?:A\/b\/C\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.md)$/);

var actual = fn("A/b/C/*.MD");
actual.should.eql(/^(?:A\/b\/C\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.MD)$/);

var actual = fn("a/b/c{d,e{f,g}}/*.js");
actual.should.eql(/^(?:a\/b\/cd\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|a\/b\/cef\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|a\/b\/ceg\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js)$/);

var actual = fn("a/b/c{d,e{f,g}}/*.md");
actual.should.eql(/^(?:a\/b\/cd\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.md|a\/b\/cef\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.md|a\/b\/ceg\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.md)$/);

var actual = fn("a/b/c{d,e}/*.js");
actual.should.eql(/^(?:a\/b\/cd\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js|a\/b\/ce\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js)$/);

var actual = fn("a/b/c{d,e}/*.md");
actual.should.eql(/^(?:a\/b\/cd\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.md|a\/b\/ce\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.md)$/);

var actual = fn("a/b/c{d,e}/xyz.js");
actual.should.eql(/^(?:a\/b\/cd\/xyz\.js|a\/b\/ce\/xyz\.js)$/);

var actual = fn("a/b/c{d,e}/xyz.md");
actual.should.eql(/^(?:a\/b\/cd\/xyz\.md|a\/b\/ce\/xyz\.md)$/);

var actual = fn("a/{c..e}.js");
actual.should.eql(/^(?:a\/c\.js|a\/d\.js|a\/e\.js)$/);

var actual = fn("E:**/*.js");
actual.should.eql(/^(?:(?=.)E:[^/]*?[^/]*?\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js)$/);

var actual = fn("E:**/*.md");
actual.should.eql(/^(?:(?=.)E:[^/]*?[^/]*?\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.md)$/);

var actual = fn("E:\\**/*.js");
actual.should.eql(/^(?:(?=.)E:\\[^/]*?[^/]*?\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.js)$/);

var actual = fn("E:\\**/*.md");
actual.should.eql(/^(?:(?=.)E:\\[^/]*?[^/]*?\/(?!(?:^|\/)\.{1,2}(?:$|\/))(?=.)[^/]*?\.md)$/);
