# Contributing :star: :star2: :dizzy:

So, you want to contribute to this project? That's awesome! However, before doing so, please read the following simple steps on how to contribute. This will make life easier and avoid wasting time on things that are not requested. ✨

## Discuss the changes before making them
To begin, open an issue in the repository using the [bug tracker][1]. Describe the contribution you'd like to make, the bug you've found, or any other ideas you have. This step will help us get you started on the right track.

If it is relevant, include platform and software information (e.g., operating system, Node.JS version, etc.) and screenshots to help us understand what you're experiencing.

We recommend waiting for feedback before proceeding to the next steps. However, if the issue is clear, such as a typo, and the fix is simple, you can go ahead and fix it.

## Fixing Issues
Begin by forking the project to your own account, and create a branch for your fix, naming it either `some-great-feature` or `some-issue-fix`.

Commit your changes to that branch, adhering to the [code style][2]. If the project includes tests (usually located in the `test` directory), we encourage you to add a test as well. :memo:

If the project includes a `package.json` or a `bower.json` file, add yourself to the `contributors` array (or `authors` in the case of `bower.json`). If the array doesn't exist, create it as shown below:

```json
{
   "contributors": [
      "Your Name <your@email.address> (http://your.website)"
   ]
}
```

## Creating a Pull Request
Start by opening a pull request and make sure to reference the initial issue in the pull request message (e.g., *fixes #<your-issue-number>*). Provide a clear and descriptive title to help everyone understand what is being fixed or improved.

If applicable, consider adding screenshots, gifs, or any other visual aids that can make it easier to understand the changes you've made.

## Wait for Feedback
Before accepting your contributions, we will review them. You may receive feedback regarding what needs to be addressed in your modified code. If so, simply continue making commits to your branch, and the pull request will be automatically updated.

## Everyone Is Happy!
Ultimately, your contributions will be merged, and everyone will be delighted! 😄 Contributions are more than welcome!

Thanks! :sweat_smile:

[1]: /issues
[2]: https://github.com/IonicaBizau/code-style
