/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2009 Sun Microsystems, Inc.
 */
package org.netbeans.modules.cnd.completion.options;

import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cnd.completion.cplusplus.CsmCompletionUtils;
import org.netbeans.modules.options.editor.spi.PreferencesCustomizer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/**
 *
 * @author Vladimir Voskresensky
 */
public class CodeCompletionPanel extends javax.swing.JPanel implements DocumentListener {

    private final Preferences preferences;
    private final Map<String, Object> id2Saved = new HashMap<String, Object>();

    /** Creates new form CodeCompletionPanel */
    public CodeCompletionPanel(Preferences preferences) {
        this.preferences = preferences;
        initComponents();
        autoInsertIncludeDirectives.setSelected(preferences.getBoolean(CsmCompletionUtils.CPP_AUTO_INSERT_INCLUDE_DIRECTIVES, true));
        autoCompletionTriggersField.setText(preferences.get(CsmCompletionUtils.CPP_AUTO_COMPLETION_TRIGGERS, CsmCompletionUtils.CPP_AUTO_COMPLETION_TRIGGERS_DEFAULT));
        autoCompletionTriggersPreprocField.setText(preferences.get(CsmCompletionUtils.PREPRPOC_AUTO_COMPLETION_TRIGGERS, CsmCompletionUtils.PREPRPOC_AUTO_COMPLETION_TRIGGERS_DEFAULT));
        autoCompletionTriggersField.getDocument().addDocumentListener(this);
        autoCompletionTriggersPreprocField.getDocument().addDocumentListener(this);
        id2Saved.put(CsmCompletionUtils.CPP_AUTO_INSERT_INCLUDE_DIRECTIVES, autoInsertIncludeDirectives.isSelected());
        id2Saved.put(CsmCompletionUtils.CPP_AUTO_COMPLETION_TRIGGERS, autoCompletionTriggersField.getText());
        id2Saved.put(CsmCompletionUtils.PREPRPOC_AUTO_COMPLETION_TRIGGERS, autoCompletionTriggersPreprocField.getText());
    }

    public static PreferencesCustomizer.Factory getCustomizerFactory() {
        return new PreferencesCustomizer.Factory() {

            @Override
            public PreferencesCustomizer create(Preferences preferences) {
                return new CodeCompletionPreferencesCusromizer(preferences);
            }
        };
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        autoCompletionTriggersLabel = new javax.swing.JLabel();
        autoCompletionTriggersField = new javax.swing.JTextField();
        autoInsertIncludeDirectives = new javax.swing.JCheckBox();
        autoCompletionTriggersPreprocLabel = new javax.swing.JLabel();
        autoCompletionTriggersPreprocField = new javax.swing.JTextField();
        jSeparator1 = new javax.swing.JSeparator();

        autoCompletionTriggersLabel.setLabelFor(autoCompletionTriggersField);
        org.openide.awt.Mnemonics.setLocalizedText(autoCompletionTriggersLabel, org.openide.util.NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanel.autoCompletionTriggersLabel.text")); // NOI18N

        autoCompletionTriggersField.setAlignmentX(1.0F);

        autoInsertIncludeDirectives.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(autoInsertIncludeDirectives, org.openide.util.NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanel.autoInclude.text")); // NOI18N
        autoInsertIncludeDirectives.setBorder(null);
        autoInsertIncludeDirectives.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                autoInsertIncludeDirectivesActionPerformed(evt);
            }
        });

        autoCompletionTriggersPreprocLabel.setLabelFor(autoCompletionTriggersPreprocField);
        org.openide.awt.Mnemonics.setLocalizedText(autoCompletionTriggersPreprocLabel, org.openide.util.NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanel.autoCompletionTriggersPreprocLabel.text")); // NOI18N

        autoCompletionTriggersPreprocField.setAlignmentX(1.0F);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jSeparator1, javax.swing.GroupLayout.DEFAULT_SIZE, 377, Short.MAX_VALUE))
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(autoCompletionTriggersLabel)
                            .addComponent(autoCompletionTriggersPreprocLabel))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(autoCompletionTriggersField, javax.swing.GroupLayout.DEFAULT_SIZE, 122, Short.MAX_VALUE)
                            .addComponent(autoCompletionTriggersPreprocField)))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(12, 12, 12)
                        .addComponent(autoInsertIncludeDirectives)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(autoCompletionTriggersLabel)
                    .addComponent(autoCompletionTriggersField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(autoInsertIncludeDirectives)
                .addGap(24, 24, 24)
                .addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(23, 23, 23)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(autoCompletionTriggersPreprocLabel)
                    .addComponent(autoCompletionTriggersPreprocField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(168, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void autoInsertIncludeDirectivesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_autoInsertIncludeDirectivesActionPerformed
        preferences.putBoolean(CsmCompletionUtils.CPP_AUTO_INSERT_INCLUDE_DIRECTIVES, autoInsertIncludeDirectives.isSelected());
}//GEN-LAST:event_autoInsertIncludeDirectivesActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField autoCompletionTriggersField;
    private javax.swing.JLabel autoCompletionTriggersLabel;
    private javax.swing.JTextField autoCompletionTriggersPreprocField;
    private javax.swing.JLabel autoCompletionTriggersPreprocLabel;
    private javax.swing.JCheckBox autoInsertIncludeDirectives;
    private javax.swing.JSeparator jSeparator1;
    // End of variables declaration//GEN-END:variables

    @Override
    public void insertUpdate(DocumentEvent e) {
        update(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        update(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        update(e);
    }

    private void update(DocumentEvent e) {
        if (e.getDocument() == autoCompletionTriggersField.getDocument()) {
            preferences.put(CsmCompletionUtils.CPP_AUTO_COMPLETION_TRIGGERS, autoCompletionTriggersField.getText());
        } else if (e.getDocument() == autoCompletionTriggersPreprocField.getDocument()) {
            preferences.put(CsmCompletionUtils.PREPRPOC_AUTO_COMPLETION_TRIGGERS, autoCompletionTriggersPreprocField.getText());
        }
    }

    private static class CodeCompletionPreferencesCusromizer implements PreferencesCustomizer {

        private Preferences preferences;
        private CodeCompletionPanel component;

        private CodeCompletionPreferencesCusromizer(Preferences p) {
            preferences = p;
        }

        @Override
        public String getId() {
            return "org.netbeans.modules.cnd.completion.options"; //NOI18N
        }

        @Override
        public String getDisplayName() {
            return NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanelName"); // NOI18N
        }

        @Override
        public HelpCtx getHelpCtx() {
            return new HelpCtx("netbeans.optionsDialog.editor.codeCompletion.cpp"); //NOI18N
        }

        @Override
        public JComponent getComponent() {
            if (component == null) {
                component = new CodeCompletionPanel(preferences);
            }
            return component;
        }
    }

    String getSavedValue(String key) {
        return id2Saved.get(key).toString();
    }

    public static final class CustomCustomizerImpl extends PreferencesCustomizer.CustomCustomizer {

        @Override
        public String getSavedValue(PreferencesCustomizer customCustomizer, String key) {
            if (customCustomizer instanceof CodeCompletionPreferencesCusromizer) {
                return ((CodeCompletionPanel) customCustomizer.getComponent()).getSavedValue(key);
            }
            return null;
        }
    }
}
