/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.upgrade;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.openide.util.NbBundle;


/**
 * @author Jiri Rechtacek
 */
final class AutoUpgradePanel extends JPanel {

    private String source;
    private String note;

    /** Creates new form UpgradePanel */
    public AutoUpgradePanel (String directory, String note) {
        this.source = directory;
        this.note = note;
        initComponents();
        initAccessibility();
    }

    /** Remove a listener to changes of the panel's validity.
     * @param l the listener to remove
     */
    void removeChangeListener(ChangeListener l) {
        changeListeners.remove(l);
    }

    /** Add a listener to changes of the panel's validity.
     * @param l the listener to add
     * @see #isValid
     */
    void addChangeListener(ChangeListener l) {
        if (!changeListeners.contains(l)) {
            changeListeners.add(l);
        }
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("MSG_Confirmation")); // NOI18N
    }
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        txtVersions = new javax.swing.JTextArea();

        setPreferredSize(new java.awt.Dimension(550, source != null && ! note.isEmpty() ? 120 : 60));

        txtVersions.setBackground(getBackground());
        txtVersions.setColumns(50);
        txtVersions.setEditable(false);
        txtVersions.setFont(new java.awt.Font("Dialog", 0, 12));
        txtVersions.setLineWrap(true);
        txtVersions.setRows(source != null && ! note.isEmpty() ? 6 : 3);
        if (source != null) {
            txtVersions.setText(NbBundle.getMessage (AutoUpgradePanel.class, "MSG_Confirmation", source, note)); // NOI18N
        } else {
            txtVersions.setText(note);
        }
        txtVersions.setWrapStyleWord(true);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(txtVersions, javax.swing.GroupLayout.DEFAULT_SIZE, 583, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(txtVersions, javax.swing.GroupLayout.DEFAULT_SIZE, 60, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextArea txtVersions;
    // End of variables declaration//GEN-END:variables

    private static final ResourceBundle bundle = NbBundle.getBundle(AutoUpgradePanel.class);
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>(1);
    
}
