#!/bin/bash
# Copyright (C) 2019 by Pedro Mendes, Rector and Visitors of the 
# University of Virginia, University of Heidelberg, and University 
# of Connecticut School of Medicine. 
# All rights reserved. 


set -e
set -x

if [[ "$(uname -s)" == 'Darwin' ]]; then
    brew update || brew update
    brew outdated pyenv || brew upgrade pyenv
    brew install pyenv-virtualenv
    brew install check
    brew install cmake || true

    if which pyenv > /dev/null; then
        eval "$(pyenv init -)"
    fi

    pyenv install 3.7.1
    pyenv virtualenv 3.7.1 conan
    pyenv rehash
    pyenv activate conan
else
    sudo apt-get update
    sudo apt-get -y install check libexpat-dev libbz2-dev zlib1g-dev
fi

pip install conan_package_tools
pip install conan
conan user
conan remote add fbergmann "https://api.bintray.com/conan/fbergmann/conan"
