/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.prefs.Preferences;

/**
 *
 * @author Ondrej Brejla <obrejla@netbeans.org>
 */
public class NestedHintsCustomizer extends javax.swing.JPanel {
    private final Preferences preferences;
    private final NestedBlocksHint nestedBlocksHint;

    public NestedHintsCustomizer(Preferences preferences, NestedBlocksHint nestedBlocksHint) {
        this.preferences = preferences;
        this.nestedBlocksHint = nestedBlocksHint;
        initComponents();
        numberOfAllowedNestedBlocksSpinner.getModel().setValue(nestedBlocksHint.getNumberOfAllowedNestedBlocks(preferences));
        allowConditionBlockCheckBox.setSelected(nestedBlocksHint.allowConditionBlock(preferences));
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        numberOfAllowedNestedBlocksSpinner = new javax.swing.JSpinner();
        allowConditionBlockCheckBox = new javax.swing.JCheckBox();

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(NestedHintsCustomizer.class, "NestedHintsCustomizer.jLabel1.text")); // NOI18N

        numberOfAllowedNestedBlocksSpinner.setModel(new javax.swing.SpinnerNumberModel(1, 1, 20, 1));
        numberOfAllowedNestedBlocksSpinner.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                numberOfAllowedNestedBlocksSpinnerStateChanged(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(allowConditionBlockCheckBox, org.openide.util.NbBundle.getMessage(NestedHintsCustomizer.class, "NestedHintsCustomizer.allowConditionBlockCheckBox.text")); // NOI18N
        allowConditionBlockCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                allowConditionBlockCheckBoxActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(numberOfAllowedNestedBlocksSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(allowConditionBlockCheckBox))
                .addContainerGap(51, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(numberOfAllowedNestedBlocksSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(allowConditionBlockCheckBox)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void numberOfAllowedNestedBlocksSpinnerStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_numberOfAllowedNestedBlocksSpinnerStateChanged
        nestedBlocksHint.setNumberOfAllowedNestedBlocks(preferences, (Integer) numberOfAllowedNestedBlocksSpinner.getValue());
    }//GEN-LAST:event_numberOfAllowedNestedBlocksSpinnerStateChanged

    private void allowConditionBlockCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_allowConditionBlockCheckBoxActionPerformed
        nestedBlocksHint.setAllowConditionBlock(preferences, allowConditionBlockCheckBox.isSelected());
    }//GEN-LAST:event_allowConditionBlockCheckBoxActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox allowConditionBlockCheckBox;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JSpinner numberOfAllowedNestedBlocksSpinner;
    // End of variables declaration//GEN-END:variables
}
