package Locales::DB::Language::bo;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::bo::VERSION = '0.09';

$Locales::DB::Language::bo::cldr_version = '2.0';

%Locales::DB::Language::bo::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Language\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ and\ \{1\}",
            'end'    => "\{0\}\,\ and\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => "\â\\",
        'alternate_quotation_start' => "\â\\",
        'quotation_end'             => "\â\\",
        'quotation_start'           => "\â\\"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list'  => ['other'],
        'category_rules' => {}
    },
    'posix' => {
        'nostr' => {
            'content' => "མེད།\:N",
            'draft'   => 'unconfirmed'
        },
        'yesstr' => {
            'content' => "ཡིན།\:Y",
            'draft'   => 'unconfirmed'
        }
    },
);

%Locales::DB::Language::bo::code_to_name = (
    'aa'     => 'Afar',
    'ab'     => 'Abkhazian',
    'ace'    => 'Achinese',
    'ach'    => 'Acoli',
    'ada'    => 'Adangme',
    'ady'    => 'Adyghe',
    'ae'     => 'Avestan',
    'af'     => 'Afrikaans',
    'afa'    => "Afro\-Asiatic\ Language",
    'afh'    => 'Afrihili',
    'agq'    => 'Aghem',
    'ain'    => 'Ainu',
    'ak'     => 'Akan',
    'akk'    => 'Akkadian',
    'ale'    => 'Aleut',
    'alg'    => "Algonquian\ Language",
    'alt'    => "Southern\ Altai",
    'am'     => 'Amharic',
    'an'     => 'Aragonese',
    'ang'    => "Old\ English",
    'anp'    => 'Angika',
    'apa'    => "Apache\ Language",
    'ar'     => 'Arabic',
    'arc'    => 'Aramaic',
    'arn'    => 'Araucanian',
    'arp'    => 'Arapaho',
    'art'    => "Artificial\ Language",
    'arw'    => 'Arawak',
    'as'     => 'Assamese',
    'asa'    => 'Asu',
    'ast'    => 'Asturian',
    'ath'    => "Athapascan\ Language",
    'aus'    => "Australian\ Language",
    'av'     => 'Avaric',
    'awa'    => 'Awadhi',
    'ay'     => 'Aymara',
    'az'     => 'Azeri',
    'ba'     => 'Bashkir',
    'bad'    => 'Banda',
    'bai'    => "Bamileke\ Language",
    'bal'    => 'Baluchi',
    'ban'    => 'Balinese',
    'bas'    => 'Basaa',
    'bat'    => "Baltic\ Language",
    'be'     => 'Belarusian',
    'bej'    => 'Beja',
    'bem'    => 'Bemba',
    'ber'    => 'Berber',
    'bez'    => 'Bena',
    'bg'     => 'Bulgarian',
    'bh'     => 'Bihari',
    'bho'    => 'Bhojpuri',
    'bi'     => 'Bislama',
    'bik'    => 'Bikol',
    'bin'    => 'Bini',
    'bla'    => 'Siksika',
    'bm'     => 'Bambara',
    'bn'     => 'བྷང་ག་ལའི་སྐད།',
    'bnt'    => 'Bantu',
    'bo'     => 'པོད་སྐད་',
    'br'     => 'Breton',
    'bra'    => 'Braj',
    'brx'    => 'Bodo',
    'bs'     => 'Bosnian',
    'btk'    => 'Batak',
    'bua'    => 'Buriat',
    'bug'    => 'Buginese',
    'byn'    => 'Blin',
    'ca'     => 'Catalan',
    'cad'    => 'Caddo',
    'cai'    => "Central\ American\ Indian\ Language",
    'car'    => 'Carib',
    'cau'    => "Caucasian\ Language",
    'cay'    => 'Cayuga',
    'cch'    => 'Atsam',
    'ce'     => 'Chechen',
    'ceb'    => 'Cebuano',
    'cel'    => "Celtic\ Language",
    'cgg'    => 'Chiga',
    'ch'     => 'Chamorro',
    'chb'    => 'Chibcha',
    'chg'    => 'Chagatai',
    'chk'    => 'Chuukese',
    'chm'    => 'Mari',
    'chn'    => "Chinook\ Jargon",
    'cho'    => 'Choctaw',
    'chp'    => 'Chipewyan',
    'chr'    => 'Cherokee',
    'chy'    => 'Cheyenne',
    'cmc'    => "Chamic\ Language",
    'co'     => 'Corsican',
    'cop'    => 'Coptic',
    'cpe'    => "English\-based\ Creole\ or\ Pidgin",
    'cpf'    => "French\-based\ Creole\ or\ Pidgin",
    'cpp'    => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'     => 'Cree',
    'crh'    => "Crimean\ Turkish",
    'crp'    => "Creole\ or\ Pidgin",
    'cs'     => 'Czech',
    'csb'    => 'Kashubian',
    'cu'     => "Church\ Slavic",
    'cus'    => "Cushitic\ Language",
    'cv'     => 'Chuvash',
    'cy'     => 'Welsh',
    'da'     => 'ཏེན་མག་གི་སྐད།',
    'dak'    => 'Dakota',
    'dar'    => 'Dargwa',
    'dav'    => 'Taita',
    'day'    => 'Dayak',
    'de'     => 'འཇར་མན་གྱི།',
    'de_at'  => "Austrian\ German",
    'de_ch'  => "Swiss\ High\ German",
    'del'    => 'Delaware',
    'den'    => 'Slave',
    'dgr'    => 'Dogrib',
    'din'    => 'Dinka',
    'dje'    => 'Zarma',
    'doi'    => 'Dogri',
    'dra'    => "Dravidian\ Language",
    'dsb'    => "Lower\ Sorbian",
    'dua'    => 'Duala',
    'dum'    => "Middle\ Dutch",
    'dv'     => 'Divehi',
    'dyo'    => "Jola\-Fonyi",
    'dyu'    => 'Dyula',
    'dz'     => 'རྫོང་ཁ',
    'ebu'    => 'Embu',
    'ee'     => 'Ewe',
    'efi'    => 'Efik',
    'egy'    => "Ancient\ Egyptian",
    'eka'    => 'Ekajuk',
    'el'     => 'Greek',
    'elx'    => 'Elamite',
    'en'     => 'དབིན་ཇིའི་སྐད།',
    'en_au'  => "Australian\ English",
    'en_ca'  => "དབིན་ཇིའི་སྐད།\ \(ཁེ་ན་ཌ་\)",
    'en_gb'  => "དབིན་ཇིའི་སྐད།\ \(དབིན་ཇིའི་རྒྱལ་ཁབ་\)",
    'en_us'  => "དབིན་ཇིའི་སྐད།\ \(ཨ་རི་\)",
    'enm'    => "Middle\ English",
    'eo'     => 'Esperanto',
    'es'     => 'ཞི་པན་ཡའི།',
    'es_419' => "Latin\ American\ Spanish",
    'es_es'  => "Iberian\ Spanish",
    'et'     => 'Estonian',
    'eu'     => 'Basque',
    'ewo'    => 'Ewondo',
    'fa'     => 'Persian',
    'fan'    => 'Fang',
    'fat'    => 'Fanti',
    'ff'     => 'Fulah',
    'fi'     => 'Finnish',
    'fil'    => 'Filipino',
    'fiu'    => "Finno\-Ugrian\ Language",
    'fj'     => 'Fijian',
    'fo'     => 'Faroese',
    'fon'    => 'Fon',
    'fr'     => 'ཧྥ་རན་སིའི་།',
    'fr_ca'  => "Canadian\ French",
    'fr_ch'  => "Swiss\ French",
    'frm'    => "Middle\ French",
    'fro'    => "Old\ French",
    'frr'    => "Northern\ Frisian",
    'frs'    => "Eastern\ Frisian",
    'fur'    => 'Friulian',
    'fy'     => "Western\ Frisian",
    'ga'     => 'Irish',
    'gaa'    => 'གཱ་སྐད།',
    'gay'    => 'Gayo',
    'gba'    => 'Gbaya',
    'gd'     => "Scottish\ Gaelic",
    'gem'    => "Germanic\ Language",
    'gez'    => 'Geez',
    'gil'    => 'Gilbertese',
    'gl'     => 'Galician',
    'gmh'    => "Middle\ High\ German",
    'gn'     => 'Guarani',
    'goh'    => "Old\ High\ German",
    'gon'    => 'Gondi',
    'gor'    => 'Gorontalo',
    'got'    => 'Gothic',
    'grb'    => 'Grebo',
    'grc'    => "Ancient\ Greek",
    'gsw'    => "Swiss\ German",
    'gu'     => 'གུཇ་རཱཏི་སྐད།',
    'guz'    => 'Gusii',
    'gv'     => 'Manx',
    'gwi'    => "Gwich\Ê\¼in",
    'ha'     => 'Hausa',
    'hai'    => 'Haida',
    'haw'    => 'Hawaiian',
    'he'     => 'Hebrew',
    'hi'     => 'ཧིན་དི',
    'hil'    => 'Hiligaynon',
    'him'    => 'Himachali',
    'hit'    => 'Hittite',
    'hmn'    => 'Hmong',
    'ho'     => "Hiri\ Motu",
    'hr'     => 'Croatian',
    'hsb'    => "Upper\ Sorbian",
    'ht'     => 'Haitian',
    'hu'     => 'Hungarian',
    'hup'    => 'Hupa',
    'hy'     => 'Armenian',
    'hz'     => 'Herero',
    'ia'     => 'Interlingua',
    'iba'    => 'Iban',
    'id'     => 'ཨིན་དོ་ནི་སི་སྐད།',
    'ie'     => 'Interlingue',
    'ig'     => 'Igbo',
    'ii'     => "Sichuan\ Yi",
    'ijo'    => 'Ijo',
    'ik'     => 'Inupiaq',
    'ilo'    => 'Iloko',
    'inc'    => "Indic\ Language",
    'ine'    => "Indo\-European\ Language",
    'inh'    => 'Ingush',
    'io'     => 'Ido',
    'ira'    => "Iranian\ Language",
    'iro'    => "Iroquoian\ Language",
    'is'     => 'Icelandic',
    'it'     => 'དབྱི་ཏ་་ལའི་མི།',
    'iu'     => 'Inuktitut',
    'ja'     => 'རི་པིན་སྐད་',
    'jbo'    => 'Lojban',
    'jmc'    => 'Machame',
    'jpr'    => "Judeo\-Persian",
    'jrb'    => "Judeo\-Arabic",
    'jv'     => 'Javanese',
    'ka'     => 'Georgian',
    'kaa'    => "Kara\-Kalpak",
    'kab'    => 'Kabyle',
    'kac'    => 'Kachin',
    'kaj'    => 'Jju',
    'kam'    => 'Kamba',
    'kar'    => 'Karen',
    'kaw'    => 'Kawi',
    'kbd'    => 'Kabardian',
    'kcg'    => 'Tyap',
    'kde'    => 'Makonde',
    'kea'    => 'Kabuverdianu',
    'kfo'    => 'Koro',
    'kg'     => 'Kongo',
    'kha'    => 'Khasi',
    'khi'    => "Khoisan\ Language",
    'kho'    => 'Khotanese',
    'khq'    => "Koyra\ Chiini",
    'ki'     => 'Kikuyu',
    'kj'     => 'Kuanyama',
    'kk'     => 'Kazakh',
    'kl'     => 'Kalaallisut',
    'kln'    => 'Kalenjin',
    'km'     => 'Khmer',
    'kmb'    => 'Kimbundu',
    'kn'     => 'ཀནྣ་ཌ་སྐད།',
    'ko'     => 'ཁོ་རེ་ཡའི་སྐད།',
    'kok'    => 'Konkani',
    'kos'    => 'Kosraean',
    'kpe'    => 'Kpelle',
    'kr'     => 'Kanuri',
    'krc'    => "Karachay\-Balkar",
    'krl'    => 'Karelian',
    'kro'    => 'Kru',
    'kru'    => 'Kurukh',
    'ks'     => 'Kashmiri',
    'ksb'    => 'Shambala',
    'ksf'    => 'Bafia',
    'ksh'    => 'Colognian',
    'ku'     => 'Kurdish',
    'kum'    => 'Kumyk',
    'kut'    => 'Kutenai',
    'kv'     => 'Komi',
    'kw'     => 'Cornish',
    'ky'     => 'Kirghiz',
    'la'     => 'ལཱ་ཏིན་སྐད།',
    'lad'    => 'Ladino',
    'lag'    => 'Langi',
    'lah'    => 'Lahnda',
    'lam'    => 'Lamba',
    'lb'     => 'Luxembourgish',
    'lez'    => 'Lezghian',
    'lg'     => 'Ganda',
    'li'     => 'Limburgish',
    'ln'     => 'Lingala',
    'lo'     => 'Lao',
    'lol'    => 'Mongo',
    'loz'    => 'Lozi',
    'lt'     => 'Lithuanian',
    'lu'     => "Luba\-Katanga",
    'lua'    => "Luba\-Lulua",
    'lui'    => 'Luiseno',
    'lun'    => 'Lunda',
    'luo'    => 'Luo',
    'lus'    => 'Lushai',
    'luy'    => 'Luyia',
    'lv'     => 'Latvian',
    'mad'    => 'Madurese',
    'mag'    => 'Magahi',
    'mai'    => 'Maithili',
    'mak'    => 'Makasar',
    'man'    => 'Mandingo',
    'map'    => "Austronesian\ Language",
    'mas'    => 'Masai',
    'mdf'    => 'Moksha',
    'mdr'    => 'Mandar',
    'men'    => 'Mende',
    'mer'    => 'Meru',
    'mfe'    => 'Morisyen',
    'mg'     => 'Malagasy',
    'mga'    => "Middle\ Irish",
    'mgh'    => "Makhuwa\-Meetto",
    'mh'     => 'Marshallese',
    'mi'     => 'Maori',
    'mic'    => 'Micmac',
    'min'    => 'Minangkabau',
    'mis'    => "Miscellaneous\ Language",
    'mk'     => 'Macedonian',
    'mkh'    => "Mon\-Khmer\ Language",
    'ml'     => 'Malayalam',
    'mn'     => 'སོག་སྐད།',
    'mnc'    => 'Manchu',
    'mni'    => 'Manipuri',
    'mno'    => "Manobo\ Language",
    'mo'     => 'Moldavian',
    'moh'    => 'Mohawk',
    'mos'    => 'Mossi',
    'mr'     => 'མ་ར་ཐི་སྐད།',
    'ms'     => 'མ་ལ་ཡ་སྐད།',
    'mt'     => 'Maltese',
    'mua'    => 'Mundang',
    'mul'    => "Multiple\ Languages",
    'mun'    => "Munda\ Language",
    'mus'    => 'Creek',
    'mwl'    => 'Mirandese',
    'mwr'    => 'Marwari',
    'my'     => 'འབར་མའི་སྐད།',
    'myn'    => "Mayan\ Language",
    'myv'    => 'Erzya',
    'na'     => 'Nauru',
    'nah'    => 'Nahuatl',
    'nai'    => "North\ American\ Indian\ Language",
    'nap'    => 'Neapolitan',
    'naq'    => 'Nama',
    'nb'     => "Norwegian\ Bokm\Ã\¥l",
    'nd'     => "North\ Ndebele",
    'nds'    => "Low\ German",
    'ne'     => 'ནེ་པ་ལི',
    'new'    => 'Newari',
    'ng'     => 'Ndonga',
    'nia'    => 'Nias',
    'nic'    => "Niger\-Kordofanian\ Language",
    'niu'    => 'Niuean',
    'nl'     => 'ཧའོ་ལན་སྐད།',
    'nl_be'  => 'Flemish',
    'nmg'    => 'Kwasio',
    'nn'     => 'ནོ་ཝེ་སྐད།',
    'no'     => 'Norwegian',
    'nog'    => 'Nogai',
    'non'    => "Old\ Norse",
    'nqo'    => "N\â\\Ko",
    'nr'     => "South\ Ndebele",
    'nso'    => "Northern\ Sotho",
    'nub'    => "Nubian\ Language",
    'nus'    => 'Nuer',
    'nv'     => 'Navajo',
    'nwc'    => "Classical\ Newari",
    'ny'     => 'Nyanja',
    'nym'    => 'Nyamwezi',
    'nyn'    => 'Nyankole',
    'nyo'    => 'Nyoro',
    'nzi'    => 'Nzima',
    'oc'     => 'Occitan',
    'oj'     => 'Ojibwa',
    'om'     => 'Oromo',
    'or'     => 'ཨཽ་རི་ཡ་སྐད།',
    'os'     => 'Ossetic',
    'osa'    => 'Osage',
    'ota'    => "Ottoman\ Turkish",
    'oto'    => "Otomian\ Language",
    'pa'     => 'Punjabi',
    'paa'    => "Papuan\ Language",
    'pag'    => 'Pangasinan',
    'pal'    => 'Pahlavi',
    'pam'    => 'Pampanga',
    'pap'    => 'Papiamento',
    'pau'    => 'Palauan',
    'peo'    => "Old\ Persian",
    'phi'    => "Philippine\ Language",
    'phn'    => 'Phoenician',
    'pi'     => 'Pali',
    'pl'     => 'པོ་ལན་སྐད།',
    'pon'    => 'Pohnpeian',
    'pra'    => "Prakrit\ Language",
    'pro'    => "Old\ Proven\Ã\§al",
    'ps'     => 'Pushto',
    'pt'     => 'ཕི་ཐོ་ཡའི།',
    'pt_br'  => "པ་ཞའི་མི།\ ཕི་ཐོ་ཡའི་མི།",
    'pt_pt'  => "Iberian\ Portuguese",
    'qu'     => 'Quechua',
    'raj'    => 'Rajasthani',
    'rap'    => 'Rapanui',
    'rar'    => 'Rarotongan',
    'rm'     => 'Romansh',
    'rn'     => 'Rundi',
    'ro'     => 'Romanian',
    'roa'    => "Romance\ Language",
    'rof'    => 'Rombo',
    'rom'    => 'Romany',
    'ru'     => 'ཨུ་རུ་སུ་སྐད་',
    'rup'    => 'Aromanian',
    'rw'     => 'Kinyarwanda',
    'rwk'    => 'Rwa',
    'sa'     => 'སཾ་སྐྲྀ་ཏ།',
    'sad'    => 'Sandawe',
    'sah'    => 'Sakha',
    'sai'    => "South\ American\ Indian\ Language",
    'sal'    => "Salishan\ Language",
    'sam'    => "Samaritan\ Aramaic",
    'saq'    => 'Samburu',
    'sas'    => 'Sasak',
    'sat'    => 'Santali',
    'sbp'    => 'Sangu',
    'sc'     => 'Sardinian',
    'scn'    => 'Sicilian',
    'sco'    => 'Scots',
    'sd'     => 'Sindhi',
    'se'     => "Northern\ Sami",
    'see'    => 'Seneca',
    'seh'    => 'Sena',
    'sel'    => 'Selkup',
    'sem'    => "Semitic\ Language",
    'ses'    => "Koyraboro\ Senni",
    'sg'     => 'Sango',
    'sga'    => "Old\ Irish",
    'sgn'    => "Sign\ Language",
    'sh'     => "Serbo\-Croatian",
    'shi'    => 'Tachelhit',
    'shn'    => 'Shan',
    'si'     => 'ཞི་ལན་སྐད།',
    'sid'    => 'Sidamo',
    'sio'    => "Siouan\ Language",
    'sit'    => "Sino\-Tibetan\ Language",
    'sk'     => 'Slovak',
    'sl'     => 'Slovenian',
    'sla'    => "Slavic\ Language",
    'sm'     => 'Samoan',
    'sma'    => "Southern\ Sami",
    'smi'    => "Sami\ Language",
    'smj'    => "Lule\ Sami",
    'smn'    => "Inari\ Sami",
    'sms'    => "Skolt\ Sami",
    'sn'     => 'Shona',
    'snk'    => 'Soninke',
    'so'     => 'Somali',
    'sog'    => 'Sogdien',
    'son'    => 'Songhai',
    'sq'     => 'Albanian',
    'sr'     => 'Serbian',
    'srn'    => "Sranan\ Tongo",
    'srr'    => 'Serer',
    'ss'     => 'Swati',
    'ssa'    => "Nilo\-Saharan\ Language",
    'ssy'    => 'Saho',
    'st'     => "Southern\ Sotho",
    'su'     => 'Sundanese',
    'suk'    => 'Sukuma',
    'sus'    => 'Susu',
    'sux'    => 'Sumerian',
    'sv'     => 'ཧྲུའི་ཏན་སྐད།',
    'sw'     => 'Swahili',
    'swb'    => 'Comorian',
    'swc'    => "Congo\ Swahili",
    'syc'    => "Classical\ Syriac",
    'syr'    => 'Syriac',
    'ta'     => 'ཏཱ་མིལ་སྐད།',
    'tai'    => "Tai\ Language",
    'te'     => 'ཏེ་ལུ་གུ་སྐད།',
    'tem'    => 'Timne',
    'teo'    => 'Teso',
    'ter'    => 'Tereno',
    'tet'    => 'Tetum',
    'tg'     => 'Tajik',
    'th'     => 'ཐའའི་ཡུལ་སྐད།',
    'ti'     => 'Tigrinya',
    'tig'    => 'Tigre',
    'tiv'    => 'Tiv',
    'tk'     => 'Turkmen',
    'tkl'    => 'Tokelau',
    'tl'     => 'Tagalog',
    'tlh'    => 'Klingon',
    'tli'    => 'Tlingit',
    'tmh'    => 'Tamashek',
    'tn'     => 'Tswana',
    'to'     => 'Tonga',
    'tog'    => "Nyasa\ Tonga",
    'tpi'    => "Tok\ Pisin",
    'tr'     => 'ཐུར་ཁེའི་སྐད།',
    'trv'    => 'Taroko',
    'ts'     => 'Tsonga',
    'tsi'    => 'Tsimshian',
    'tt'     => 'Tatar',
    'tum'    => 'Tumbuka',
    'tup'    => "Tupi\ Language",
    'tut'    => "Altaic\ Language",
    'tvl'    => 'Tuvalu',
    'tw'     => 'Twi',
    'twq'    => 'Tasawaq',
    'ty'     => 'Tahitian',
    'tyv'    => 'Tuvinian',
    'tzm'    => "Central\ Morocco\ Tamazight",
    'udm'    => 'Udmurt',
    'ug'     => 'ཡུ་གུར་སྐད།',
    'uga'    => 'Ugaritic',
    'uk'     => 'ཡུ་ཀྲ་ནི་སྐད།',
    'umb'    => 'Umbundu',
    'und'    => "མིའི་ཤེས་རྟོགས་མ་བྱུང་བ།\ ཡང་ན་ཆད་ལྷག་ཅན་གྱི་སྐད་བརྡ།",
    'ur'     => 'ཝུའུ་ཏུའུ་སྐད།',
    'uz'     => 'Uzbek',
    'vai'    => 'Vai',
    've'     => 'Venda',
    'vi'     => 'ཡོ་ནན་སྐད།',
    'vo'     => "Volap\Ã\¼k",
    'vot'    => 'Votic',
    'vun'    => 'Vunjo',
    'wa'     => 'Walloon',
    'wae'    => 'Walser',
    'wak'    => "Wakashan\ Language",
    'wal'    => 'Walamo',
    'war'    => 'Waray',
    'was'    => 'Washo',
    'wen'    => "Sorbian\ Language",
    'wo'     => 'Wolof',
    'xal'    => 'Kalmyk',
    'xh'     => 'Xhosa',
    'xog'    => 'Soga',
    'yao'    => 'Yao',
    'yap'    => 'Yapese',
    'yav'    => 'Yangben',
    'yi'     => 'Yiddish',
    'yo'     => 'Yoruba',
    'ypk'    => "Yupik\ Language",
    'yue'    => 'Cantonese',
    'za'     => 'Zhuang',
    'zap'    => 'Zapotec',
    'zbl'    => 'Blissymbols',
    'zen'    => 'ཟེ་ན་གཱ་སྐད།',
    'zh'     => 'རྒྱ་སྐད་',
    'znd'    => 'Zande',
    'zu'     => 'ཟུ་ལུ་སྐད།',
    'zun'    => 'ཟུ་ནི་སྐད།',
    'zxx'    => "No\ linguistic\ content",
    'zza'    => 'ཟ་ཟཱ་སྐད།',
);

%Locales::DB::Language::bo::name_to_code = (
    'abkhazian'                                                                                                                                                 => 'ab',
    'achinese'                                                                                                                                                  => 'ace',
    'acoli'                                                                                                                                                     => 'ach',
    'adangme'                                                                                                                                                   => 'ada',
    'adyghe'                                                                                                                                                    => 'ady',
    'afar'                                                                                                                                                      => 'aa',
    'afrihili'                                                                                                                                                  => 'afh',
    'afrikaans'                                                                                                                                                 => 'af',
    'afroasiaticlanguage'                                                                                                                                       => 'afa',
    'aghem'                                                                                                                                                     => 'agq',
    'ainu'                                                                                                                                                      => 'ain',
    'akan'                                                                                                                                                      => 'ak',
    'akkadian'                                                                                                                                                  => 'akk',
    'albanian'                                                                                                                                                  => 'sq',
    'aleut'                                                                                                                                                     => 'ale',
    'algonquianlanguage'                                                                                                                                        => 'alg',
    'altaiclanguage'                                                                                                                                            => 'tut',
    'amharic'                                                                                                                                                   => 'am',
    'ancientegyptian'                                                                                                                                           => 'egy',
    'ancientgreek'                                                                                                                                              => 'grc',
    'angika'                                                                                                                                                    => 'anp',
    'apachelanguage'                                                                                                                                            => 'apa',
    'arabic'                                                                                                                                                    => 'ar',
    'aragonese'                                                                                                                                                 => 'an',
    'aramaic'                                                                                                                                                   => 'arc',
    'arapaho'                                                                                                                                                   => 'arp',
    'araucanian'                                                                                                                                                => 'arn',
    'arawak'                                                                                                                                                    => 'arw',
    'armenian'                                                                                                                                                  => 'hy',
    'aromanian'                                                                                                                                                 => 'rup',
    'artificiallanguage'                                                                                                                                        => 'art',
    'assamese'                                                                                                                                                  => 'as',
    'asturian'                                                                                                                                                  => 'ast',
    'asu'                                                                                                                                                       => 'asa',
    'athapascanlanguage'                                                                                                                                        => 'ath',
    'atsam'                                                                                                                                                     => 'cch',
    'australianenglish'                                                                                                                                         => 'en_au',
    'australianlanguage'                                                                                                                                        => 'aus',
    'austriangerman'                                                                                                                                            => 'de_at',
    'austronesianlanguage'                                                                                                                                      => 'map',
    'avaric'                                                                                                                                                    => 'av',
    'avestan'                                                                                                                                                   => 'ae',
    'awadhi'                                                                                                                                                    => 'awa',
    'aymara'                                                                                                                                                    => 'ay',
    'azeri'                                                                                                                                                     => 'az',
    'bafia'                                                                                                                                                     => 'ksf',
    'balinese'                                                                                                                                                  => 'ban',
    'balticlanguage'                                                                                                                                            => 'bat',
    'baluchi'                                                                                                                                                   => 'bal',
    'bambara'                                                                                                                                                   => 'bm',
    'bamilekelanguage'                                                                                                                                          => 'bai',
    'banda'                                                                                                                                                     => 'bad',
    'bantu'                                                                                                                                                     => 'bnt',
    'basaa'                                                                                                                                                     => 'bas',
    'bashkir'                                                                                                                                                   => 'ba',
    'basque'                                                                                                                                                    => 'eu',
    'batak'                                                                                                                                                     => 'btk',
    'beja'                                                                                                                                                      => 'bej',
    'belarusian'                                                                                                                                                => 'be',
    'bemba'                                                                                                                                                     => 'bem',
    'bena'                                                                                                                                                      => 'bez',
    'berber'                                                                                                                                                    => 'ber',
    'bhojpuri'                                                                                                                                                  => 'bho',
    'bihari'                                                                                                                                                    => 'bh',
    'bikol'                                                                                                                                                     => 'bik',
    'bini'                                                                                                                                                      => 'bin',
    'bislama'                                                                                                                                                   => 'bi',
    'blin'                                                                                                                                                      => 'byn',
    'blissymbols'                                                                                                                                               => 'zbl',
    'bodo'                                                                                                                                                      => 'brx',
    'bosnian'                                                                                                                                                   => 'bs',
    'braj'                                                                                                                                                      => 'bra',
    'breton'                                                                                                                                                    => 'br',
    'buginese'                                                                                                                                                  => 'bug',
    'bulgarian'                                                                                                                                                 => 'bg',
    'buriat'                                                                                                                                                    => 'bua',
    'caddo'                                                                                                                                                     => 'cad',
    'canadianfrench'                                                                                                                                            => 'fr_ca',
    'cantonese'                                                                                                                                                 => 'yue',
    'carib'                                                                                                                                                     => 'car',
    'catalan'                                                                                                                                                   => 'ca',
    'caucasianlanguage'                                                                                                                                         => 'cau',
    'cayuga'                                                                                                                                                    => 'cay',
    'cebuano'                                                                                                                                                   => 'ceb',
    'celticlanguage'                                                                                                                                            => 'cel',
    'centralamericanindianlanguage'                                                                                                                             => 'cai',
    'centralmoroccotamazight'                                                                                                                                   => 'tzm',
    'chagatai'                                                                                                                                                  => 'chg',
    'chamiclanguage'                                                                                                                                            => 'cmc',
    'chamorro'                                                                                                                                                  => 'ch',
    'chechen'                                                                                                                                                   => 'ce',
    'cherokee'                                                                                                                                                  => 'chr',
    'cheyenne'                                                                                                                                                  => 'chy',
    'chibcha'                                                                                                                                                   => 'chb',
    'chiga'                                                                                                                                                     => 'cgg',
    'chinookjargon'                                                                                                                                             => 'chn',
    'chipewyan'                                                                                                                                                 => 'chp',
    'choctaw'                                                                                                                                                   => 'cho',
    'churchslavic'                                                                                                                                              => 'cu',
    'chuukese'                                                                                                                                                  => 'chk',
    'chuvash'                                                                                                                                                   => 'cv',
    'classicalnewari'                                                                                                                                           => 'nwc',
    'classicalsyriac'                                                                                                                                           => 'syc',
    'colognian'                                                                                                                                                 => 'ksh',
    'comorian'                                                                                                                                                  => 'swb',
    'congoswahili'                                                                                                                                              => 'swc',
    'coptic'                                                                                                                                                    => 'cop',
    'cornish'                                                                                                                                                   => 'kw',
    'corsican'                                                                                                                                                  => 'co',
    'cree'                                                                                                                                                      => 'cr',
    'creek'                                                                                                                                                     => 'mus',
    'creoleorpidgin'                                                                                                                                            => 'crp',
    'crimeanturkish'                                                                                                                                            => 'crh',
    'croatian'                                                                                                                                                  => 'hr',
    'cushiticlanguage'                                                                                                                                          => 'cus',
    'czech'                                                                                                                                                     => 'cs',
    'dakota'                                                                                                                                                    => 'dak',
    'dargwa'                                                                                                                                                    => 'dar',
    'dayak'                                                                                                                                                     => 'day',
    'delaware'                                                                                                                                                  => 'del',
    'dinka'                                                                                                                                                     => 'din',
    'divehi'                                                                                                                                                    => 'dv',
    'dogri'                                                                                                                                                     => 'doi',
    'dogrib'                                                                                                                                                    => 'dgr',
    'dravidianlanguage'                                                                                                                                         => 'dra',
    'duala'                                                                                                                                                     => 'dua',
    'dyula'                                                                                                                                                     => 'dyu',
    'easternfrisian'                                                                                                                                            => 'frs',
    'efik'                                                                                                                                                      => 'efi',
    'ekajuk'                                                                                                                                                    => 'eka',
    'elamite'                                                                                                                                                   => 'elx',
    'embu'                                                                                                                                                      => 'ebu',
    'englishbasedcreoleorpidgin'                                                                                                                                => 'cpe',
    'erzya'                                                                                                                                                     => 'myv',
    'esperanto'                                                                                                                                                 => 'eo',
    'estonian'                                                                                                                                                  => 'et',
    'ewe'                                                                                                                                                       => 'ee',
    'ewondo'                                                                                                                                                    => 'ewo',
    'fang'                                                                                                                                                      => 'fan',
    'fanti'                                                                                                                                                     => 'fat',
    'faroese'                                                                                                                                                   => 'fo',
    'fijian'                                                                                                                                                    => 'fj',
    'filipino'                                                                                                                                                  => 'fil',
    'finnish'                                                                                                                                                   => 'fi',
    'finnougrianlanguage'                                                                                                                                       => 'fiu',
    'flemish'                                                                                                                                                   => 'nl_be',
    'fon'                                                                                                                                                       => 'fon',
    'frenchbasedcreoleorpidgin'                                                                                                                                 => 'cpf',
    'friulian'                                                                                                                                                  => 'fur',
    'fulah'                                                                                                                                                     => 'ff',
    'galician'                                                                                                                                                  => 'gl',
    'ganda'                                                                                                                                                     => 'lg',
    'gayo'                                                                                                                                                      => 'gay',
    'gbaya'                                                                                                                                                     => 'gba',
    'geez'                                                                                                                                                      => 'gez',
    'georgian'                                                                                                                                                  => 'ka',
    'germaniclanguage'                                                                                                                                          => 'gem',
    'gilbertese'                                                                                                                                                => 'gil',
    'gondi'                                                                                                                                                     => 'gon',
    'gorontalo'                                                                                                                                                 => 'gor',
    'gothic'                                                                                                                                                    => 'got',
    'grebo'                                                                                                                                                     => 'grb',
    'greek'                                                                                                                                                     => 'el',
    'guarani'                                                                                                                                                   => 'gn',
    'gusii'                                                                                                                                                     => 'guz',
    "gwich\Ê\¼in"                                                                                                                                             => 'gwi',
    'haida'                                                                                                                                                     => 'hai',
    'haitian'                                                                                                                                                   => 'ht',
    'hausa'                                                                                                                                                     => 'ha',
    'hawaiian'                                                                                                                                                  => 'haw',
    'hebrew'                                                                                                                                                    => 'he',
    'herero'                                                                                                                                                    => 'hz',
    'hiligaynon'                                                                                                                                                => 'hil',
    'himachali'                                                                                                                                                 => 'him',
    'hirimotu'                                                                                                                                                  => 'ho',
    'hittite'                                                                                                                                                   => 'hit',
    'hmong'                                                                                                                                                     => 'hmn',
    'hungarian'                                                                                                                                                 => 'hu',
    'hupa'                                                                                                                                                      => 'hup',
    'iban'                                                                                                                                                      => 'iba',
    'iberianportuguese'                                                                                                                                         => 'pt_pt',
    'iberianspanish'                                                                                                                                            => 'es_es',
    'icelandic'                                                                                                                                                 => 'is',
    'ido'                                                                                                                                                       => 'io',
    'igbo'                                                                                                                                                      => 'ig',
    'ijo'                                                                                                                                                       => 'ijo',
    'iloko'                                                                                                                                                     => 'ilo',
    'inarisami'                                                                                                                                                 => 'smn',
    'indiclanguage'                                                                                                                                             => 'inc',
    'indoeuropeanlanguage'                                                                                                                                      => 'ine',
    'ingush'                                                                                                                                                    => 'inh',
    'interlingua'                                                                                                                                               => 'ia',
    'interlingue'                                                                                                                                               => 'ie',
    'inuktitut'                                                                                                                                                 => 'iu',
    'inupiaq'                                                                                                                                                   => 'ik',
    'iranianlanguage'                                                                                                                                           => 'ira',
    'irish'                                                                                                                                                     => 'ga',
    'iroquoianlanguage'                                                                                                                                         => 'iro',
    'javanese'                                                                                                                                                  => 'jv',
    'jju'                                                                                                                                                       => 'kaj',
    'jolafonyi'                                                                                                                                                 => 'dyo',
    'judeoarabic'                                                                                                                                               => 'jrb',
    'judeopersian'                                                                                                                                              => 'jpr',
    'kabardian'                                                                                                                                                 => 'kbd',
    'kabuverdianu'                                                                                                                                              => 'kea',
    'kabyle'                                                                                                                                                    => 'kab',
    'kachin'                                                                                                                                                    => 'kac',
    'kalaallisut'                                                                                                                                               => 'kl',
    'kalenjin'                                                                                                                                                  => 'kln',
    'kalmyk'                                                                                                                                                    => 'xal',
    'kamba'                                                                                                                                                     => 'kam',
    'kanuri'                                                                                                                                                    => 'kr',
    'karachaybalkar'                                                                                                                                            => 'krc',
    'karakalpak'                                                                                                                                                => 'kaa',
    'karelian'                                                                                                                                                  => 'krl',
    'karen'                                                                                                                                                     => 'kar',
    'kashmiri'                                                                                                                                                  => 'ks',
    'kashubian'                                                                                                                                                 => 'csb',
    'kawi'                                                                                                                                                      => 'kaw',
    'kazakh'                                                                                                                                                    => 'kk',
    'khasi'                                                                                                                                                     => 'kha',
    'khmer'                                                                                                                                                     => 'km',
    'khoisanlanguage'                                                                                                                                           => 'khi',
    'khotanese'                                                                                                                                                 => 'kho',
    'kikuyu'                                                                                                                                                    => 'ki',
    'kimbundu'                                                                                                                                                  => 'kmb',
    'kinyarwanda'                                                                                                                                               => 'rw',
    'kirghiz'                                                                                                                                                   => 'ky',
    'klingon'                                                                                                                                                   => 'tlh',
    'komi'                                                                                                                                                      => 'kv',
    'kongo'                                                                                                                                                     => 'kg',
    'konkani'                                                                                                                                                   => 'kok',
    'koro'                                                                                                                                                      => 'kfo',
    'kosraean'                                                                                                                                                  => 'kos',
    'koyraborosenni'                                                                                                                                            => 'ses',
    'koyrachiini'                                                                                                                                               => 'khq',
    'kpelle'                                                                                                                                                    => 'kpe',
    'kru'                                                                                                                                                       => 'kro',
    'kuanyama'                                                                                                                                                  => 'kj',
    'kumyk'                                                                                                                                                     => 'kum',
    'kurdish'                                                                                                                                                   => 'ku',
    'kurukh'                                                                                                                                                    => 'kru',
    'kutenai'                                                                                                                                                   => 'kut',
    'kwasio'                                                                                                                                                    => 'nmg',
    'ladino'                                                                                                                                                    => 'lad',
    'lahnda'                                                                                                                                                    => 'lah',
    'lamba'                                                                                                                                                     => 'lam',
    'langi'                                                                                                                                                     => 'lag',
    'lao'                                                                                                                                                       => 'lo',
    'latinamericanspanish'                                                                                                                                      => 'es_419',
    'latvian'                                                                                                                                                   => 'lv',
    'lezghian'                                                                                                                                                  => 'lez',
    'limburgish'                                                                                                                                                => 'li',
    'lingala'                                                                                                                                                   => 'ln',
    'lithuanian'                                                                                                                                                => 'lt',
    'lojban'                                                                                                                                                    => 'jbo',
    'lowersorbian'                                                                                                                                              => 'dsb',
    'lowgerman'                                                                                                                                                 => 'nds',
    'lozi'                                                                                                                                                      => 'loz',
    'lubakatanga'                                                                                                                                               => 'lu',
    'lubalulua'                                                                                                                                                 => 'lua',
    'luiseno'                                                                                                                                                   => 'lui',
    'lulesami'                                                                                                                                                  => 'smj',
    'lunda'                                                                                                                                                     => 'lun',
    'luo'                                                                                                                                                       => 'luo',
    'lushai'                                                                                                                                                    => 'lus',
    'luxembourgish'                                                                                                                                             => 'lb',
    'luyia'                                                                                                                                                     => 'luy',
    'macedonian'                                                                                                                                                => 'mk',
    'machame'                                                                                                                                                   => 'jmc',
    'madurese'                                                                                                                                                  => 'mad',
    'magahi'                                                                                                                                                    => 'mag',
    'maithili'                                                                                                                                                  => 'mai',
    'makasar'                                                                                                                                                   => 'mak',
    'makhuwameetto'                                                                                                                                             => 'mgh',
    'makonde'                                                                                                                                                   => 'kde',
    'malagasy'                                                                                                                                                  => 'mg',
    'malayalam'                                                                                                                                                 => 'ml',
    'maltese'                                                                                                                                                   => 'mt',
    'manchu'                                                                                                                                                    => 'mnc',
    'mandar'                                                                                                                                                    => 'mdr',
    'mandingo'                                                                                                                                                  => 'man',
    'manipuri'                                                                                                                                                  => 'mni',
    'manobolanguage'                                                                                                                                            => 'mno',
    'manx'                                                                                                                                                      => 'gv',
    'maori'                                                                                                                                                     => 'mi',
    'mari'                                                                                                                                                      => 'chm',
    'marshallese'                                                                                                                                               => 'mh',
    'marwari'                                                                                                                                                   => 'mwr',
    'masai'                                                                                                                                                     => 'mas',
    'mayanlanguage'                                                                                                                                             => 'myn',
    'mende'                                                                                                                                                     => 'men',
    'meru'                                                                                                                                                      => 'mer',
    'micmac'                                                                                                                                                    => 'mic',
    'middledutch'                                                                                                                                               => 'dum',
    'middleenglish'                                                                                                                                             => 'enm',
    'middlefrench'                                                                                                                                              => 'frm',
    'middlehighgerman'                                                                                                                                          => 'gmh',
    'middleirish'                                                                                                                                               => 'mga',
    'minangkabau'                                                                                                                                               => 'min',
    'mirandese'                                                                                                                                                 => 'mwl',
    'miscellaneouslanguage'                                                                                                                                     => 'mis',
    'mohawk'                                                                                                                                                    => 'moh',
    'moksha'                                                                                                                                                    => 'mdf',
    'moldavian'                                                                                                                                                 => 'mo',
    'mongo'                                                                                                                                                     => 'lol',
    'monkhmerlanguage'                                                                                                                                          => 'mkh',
    'morisyen'                                                                                                                                                  => 'mfe',
    'mossi'                                                                                                                                                     => 'mos',
    'multiplelanguages'                                                                                                                                         => 'mul',
    'mundalanguage'                                                                                                                                             => 'mun',
    'mundang'                                                                                                                                                   => 'mua',
    'nahuatl'                                                                                                                                                   => 'nah',
    'nama'                                                                                                                                                      => 'naq',
    'nauru'                                                                                                                                                     => 'na',
    'navajo'                                                                                                                                                    => 'nv',
    'ndonga'                                                                                                                                                    => 'ng',
    'neapolitan'                                                                                                                                                => 'nap',
    'newari'                                                                                                                                                    => 'new',
    'nias'                                                                                                                                                      => 'nia',
    'nigerkordofanianlanguage'                                                                                                                                  => 'nic',
    'nilosaharanlanguage'                                                                                                                                       => 'ssa',
    'niuean'                                                                                                                                                    => 'niu',
    'nogai'                                                                                                                                                     => 'nog',
    'nolinguisticcontent'                                                                                                                                       => 'zxx',
    'northamericanindianlanguage'                                                                                                                               => 'nai',
    'northernfrisian'                                                                                                                                           => 'frr',
    'northernsami'                                                                                                                                              => 'se',
    'northernsotho'                                                                                                                                             => 'nso',
    'northndebele'                                                                                                                                              => 'nd',
    'norwegian'                                                                                                                                                 => 'no',
    "norwegianbokm\Ã\¥l"                                                                                                                                      => 'nb',
    'nubianlanguage'                                                                                                                                            => 'nub',
    'nuer'                                                                                                                                                      => 'nus',
    'nyamwezi'                                                                                                                                                  => 'nym',
    'nyanja'                                                                                                                                                    => 'ny',
    'nyankole'                                                                                                                                                  => 'nyn',
    'nyasatonga'                                                                                                                                                => 'tog',
    'nyoro'                                                                                                                                                     => 'nyo',
    'nzima'                                                                                                                                                     => 'nzi',
    "n\â\\ko"                                                                                                                                              => 'nqo',
    'occitan'                                                                                                                                                   => 'oc',
    'ojibwa'                                                                                                                                                    => 'oj',
    'oldenglish'                                                                                                                                                => 'ang',
    'oldfrench'                                                                                                                                                 => 'fro',
    'oldhighgerman'                                                                                                                                             => 'goh',
    'oldirish'                                                                                                                                                  => 'sga',
    'oldnorse'                                                                                                                                                  => 'non',
    'oldpersian'                                                                                                                                                => 'peo',
    "oldproven\Ã\§al"                                                                                                                                         => 'pro',
    'oromo'                                                                                                                                                     => 'om',
    'osage'                                                                                                                                                     => 'osa',
    'ossetic'                                                                                                                                                   => 'os',
    'otomianlanguage'                                                                                                                                           => 'oto',
    'ottomanturkish'                                                                                                                                            => 'ota',
    'pahlavi'                                                                                                                                                   => 'pal',
    'palauan'                                                                                                                                                   => 'pau',
    'pali'                                                                                                                                                      => 'pi',
    'pampanga'                                                                                                                                                  => 'pam',
    'pangasinan'                                                                                                                                                => 'pag',
    'papiamento'                                                                                                                                                => 'pap',
    'papuanlanguage'                                                                                                                                            => 'paa',
    'persian'                                                                                                                                                   => 'fa',
    'philippinelanguage'                                                                                                                                        => 'phi',
    'phoenician'                                                                                                                                                => 'phn',
    'pohnpeian'                                                                                                                                                 => 'pon',
    'portuguesebasedcreoleorpidgin'                                                                                                                             => 'cpp',
    'prakritlanguage'                                                                                                                                           => 'pra',
    'punjabi'                                                                                                                                                   => 'pa',
    'pushto'                                                                                                                                                    => 'ps',
    'quechua'                                                                                                                                                   => 'qu',
    'rajasthani'                                                                                                                                                => 'raj',
    'rapanui'                                                                                                                                                   => 'rap',
    'rarotongan'                                                                                                                                                => 'rar',
    'romancelanguage'                                                                                                                                           => 'roa',
    'romanian'                                                                                                                                                  => 'ro',
    'romansh'                                                                                                                                                   => 'rm',
    'romany'                                                                                                                                                    => 'rom',
    'rombo'                                                                                                                                                     => 'rof',
    'rundi'                                                                                                                                                     => 'rn',
    'rwa'                                                                                                                                                       => 'rwk',
    'saho'                                                                                                                                                      => 'ssy',
    'sakha'                                                                                                                                                     => 'sah',
    'salishanlanguage'                                                                                                                                          => 'sal',
    'samaritanaramaic'                                                                                                                                          => 'sam',
    'samburu'                                                                                                                                                   => 'saq',
    'samilanguage'                                                                                                                                              => 'smi',
    'samoan'                                                                                                                                                    => 'sm',
    'sandawe'                                                                                                                                                   => 'sad',
    'sango'                                                                                                                                                     => 'sg',
    'sangu'                                                                                                                                                     => 'sbp',
    'santali'                                                                                                                                                   => 'sat',
    'sardinian'                                                                                                                                                 => 'sc',
    'sasak'                                                                                                                                                     => 'sas',
    'scots'                                                                                                                                                     => 'sco',
    'scottishgaelic'                                                                                                                                            => 'gd',
    'selkup'                                                                                                                                                    => 'sel',
    'semiticlanguage'                                                                                                                                           => 'sem',
    'sena'                                                                                                                                                      => 'seh',
    'seneca'                                                                                                                                                    => 'see',
    'serbian'                                                                                                                                                   => 'sr',
    'serbocroatian'                                                                                                                                             => 'sh',
    'serer'                                                                                                                                                     => 'srr',
    'shambala'                                                                                                                                                  => 'ksb',
    'shan'                                                                                                                                                      => 'shn',
    'shona'                                                                                                                                                     => 'sn',
    'sichuanyi'                                                                                                                                                 => 'ii',
    'sicilian'                                                                                                                                                  => 'scn',
    'sidamo'                                                                                                                                                    => 'sid',
    'signlanguage'                                                                                                                                              => 'sgn',
    'siksika'                                                                                                                                                   => 'bla',
    'sindhi'                                                                                                                                                    => 'sd',
    'sinotibetanlanguage'                                                                                                                                       => 'sit',
    'siouanlanguage'                                                                                                                                            => 'sio',
    'skoltsami'                                                                                                                                                 => 'sms',
    'slave'                                                                                                                                                     => 'den',
    'slaviclanguage'                                                                                                                                            => 'sla',
    'slovak'                                                                                                                                                    => 'sk',
    'slovenian'                                                                                                                                                 => 'sl',
    'soga'                                                                                                                                                      => 'xog',
    'sogdien'                                                                                                                                                   => 'sog',
    'somali'                                                                                                                                                    => 'so',
    'songhai'                                                                                                                                                   => 'son',
    'soninke'                                                                                                                                                   => 'snk',
    'sorbianlanguage'                                                                                                                                           => 'wen',
    'southamericanindianlanguage'                                                                                                                               => 'sai',
    'southernaltai'                                                                                                                                             => 'alt',
    'southernsami'                                                                                                                                              => 'sma',
    'southernsotho'                                                                                                                                             => 'st',
    'southndebele'                                                                                                                                              => 'nr',
    'sranantongo'                                                                                                                                               => 'srn',
    'sukuma'                                                                                                                                                    => 'suk',
    'sumerian'                                                                                                                                                  => 'sux',
    'sundanese'                                                                                                                                                 => 'su',
    'susu'                                                                                                                                                      => 'sus',
    'swahili'                                                                                                                                                   => 'sw',
    'swati'                                                                                                                                                     => 'ss',
    'swissfrench'                                                                                                                                               => 'fr_ch',
    'swissgerman'                                                                                                                                               => 'gsw',
    'swisshighgerman'                                                                                                                                           => 'de_ch',
    'syriac'                                                                                                                                                    => 'syr',
    'tachelhit'                                                                                                                                                 => 'shi',
    'tagalog'                                                                                                                                                   => 'tl',
    'tahitian'                                                                                                                                                  => 'ty',
    'tailanguage'                                                                                                                                               => 'tai',
    'taita'                                                                                                                                                     => 'dav',
    'tajik'                                                                                                                                                     => 'tg',
    'tamashek'                                                                                                                                                  => 'tmh',
    'taroko'                                                                                                                                                    => 'trv',
    'tasawaq'                                                                                                                                                   => 'twq',
    'tatar'                                                                                                                                                     => 'tt',
    'tereno'                                                                                                                                                    => 'ter',
    'teso'                                                                                                                                                      => 'teo',
    'tetum'                                                                                                                                                     => 'tet',
    'tigre'                                                                                                                                                     => 'tig',
    'tigrinya'                                                                                                                                                  => 'ti',
    'timne'                                                                                                                                                     => 'tem',
    'tiv'                                                                                                                                                       => 'tiv',
    'tlingit'                                                                                                                                                   => 'tli',
    'tokelau'                                                                                                                                                   => 'tkl',
    'tokpisin'                                                                                                                                                  => 'tpi',
    'tonga'                                                                                                                                                     => 'to',
    'tsimshian'                                                                                                                                                 => 'tsi',
    'tsonga'                                                                                                                                                    => 'ts',
    'tswana'                                                                                                                                                    => 'tn',
    'tumbuka'                                                                                                                                                   => 'tum',
    'tupilanguage'                                                                                                                                              => 'tup',
    'turkmen'                                                                                                                                                   => 'tk',
    'tuvalu'                                                                                                                                                    => 'tvl',
    'tuvinian'                                                                                                                                                  => 'tyv',
    'twi'                                                                                                                                                       => 'tw',
    'tyap'                                                                                                                                                      => 'kcg',
    'udmurt'                                                                                                                                                    => 'udm',
    'ugaritic'                                                                                                                                                  => 'uga',
    'umbundu'                                                                                                                                                   => 'umb',
    'uppersorbian'                                                                                                                                              => 'hsb',
    'uzbek'                                                                                                                                                     => 'uz',
    'vai'                                                                                                                                                       => 'vai',
    'venda'                                                                                                                                                     => 've',
    "volap\Ã\¼k"                                                                                                                                              => 'vo',
    'votic'                                                                                                                                                     => 'vot',
    'vunjo'                                                                                                                                                     => 'vun',
    'wakashanlanguage'                                                                                                                                          => 'wak',
    'walamo'                                                                                                                                                    => 'wal',
    'walloon'                                                                                                                                                   => 'wa',
    'walser'                                                                                                                                                    => 'wae',
    'waray'                                                                                                                                                     => 'war',
    'washo'                                                                                                                                                     => 'was',
    'welsh'                                                                                                                                                     => 'cy',
    'westernfrisian'                                                                                                                                            => 'fy',
    'wolof'                                                                                                                                                     => 'wo',
    'xhosa'                                                                                                                                                     => 'xh',
    'yangben'                                                                                                                                                   => 'yav',
    'yao'                                                                                                                                                       => 'yao',
    'yapese'                                                                                                                                                    => 'yap',
    'yiddish'                                                                                                                                                   => 'yi',
    'yoruba'                                                                                                                                                    => 'yo',
    'yupiklanguage'                                                                                                                                             => 'ypk',
    'zande'                                                                                                                                                     => 'znd',
    'zapotec'                                                                                                                                                   => 'zap',
    'zarma'                                                                                                                                                     => 'dje',
    'zhuang'                                                                                                                                                    => 'za',
    'ཀནྣ་ཌ་སྐད།'                                                                                                                            => 'kn',
    'ཁོ་རེ་ཡའི་སྐད།'                                                                                                                => 'ko',
    'གཱ་སྐད།'                                                                                                                                     => 'gaa',
    'གུཇ་རཱཏི་སྐད།'                                                                                                                   => 'gu',
    'ཏཱ་མིལ་སྐད།'                                                                                                                         => 'ta',
    'ཏེ་ལུ་གུ་སྐད།'                                                                                                                   => 'te',
    'ཏེན་མག་གི་སྐད།'                                                                                                                => 'da',
    'ཐའའི་ཡུལ་སྐད།'                                                                                                                   => 'th',
    'ཐུར་ཁེའི་སྐད།'                                                                                                                   => 'tr',
    'དབིན་ཇིའི་སྐད།'                                                                                                                => 'en',
    'དབིན་ཇིའི་སྐད།ཁེ་ན་ཌ་'                                                                                           => 'en_ca',
    'དབིན་ཇིའི་སྐད།དབིན་ཇིའི་རྒྱལ་ཁབ་'                                                          => 'en_gb',
    'དབིན་ཇིའི་སྐད།ཨ་རི་'                                                                                                 => 'en_us',
    'དབྱི་ཏ་་ལའི་མི།'                                                                                                             => 'it',
    'ནེ་པ་ལི'                                                                                                                                     => 'ne',
    'ནོ་ཝེ་སྐད།'                                                                                                                            => 'nn',
    'པ་ཞའི་མི།ཕི་ཐོ་ཡའི་མི།'                                                                                        => 'pt_br',
    'པོ་ལན་སྐད།'                                                                                                                            => 'pl',
    'པོད་སྐད་'                                                                                                                                  => 'bo',
    'ཕི་ཐོ་ཡའི།'                                                                                                                            => 'pt',
    'བྷང་ག་ལའི་སྐད།'                                                                                                                => 'bn',
    'མ་ར་ཐི་སྐད།'                                                                                                                         => 'mr',
    'མ་ལ་ཡ་སྐད།'                                                                                                                            => 'ms',
    'མིའི་ཤེས་རྟོགས་མ་བྱུང་བ།ཡང་ན་ཆད་ལྷག་ཅན་གྱི་སྐད་བརྡ།' => 'und',
    'ཝུའུ་ཏུའུ་སྐད།'                                                                                                                => 'ur',
    'ཞི་པན་ཡའི།'                                                                                                                            => 'es',
    'ཞི་ལན་སྐད།'                                                                                                                            => 'si',
    'ཟ་ཟཱ་སྐད།'                                                                                                                               => 'zza',
    'ཟུ་ནི་སྐད།'                                                                                                                            => 'zun',
    'ཟུ་ལུ་སྐད།'                                                                                                                            => 'zu',
    'ཟེ་ན་གཱ་སྐད།'                                                                                                                      => 'zen',
    'འཇར་མན་གྱི།'                                                                                                                         => 'de',
    'འབར་མའི་སྐད།'                                                                                                                      => 'my',
    'ཡུ་ཀྲ་ནི་སྐད།'                                                                                                                   => 'uk',
    'ཡུ་གུར་སྐད།'                                                                                                                         => 'ug',
    'ཡོ་ནན་སྐད།'                                                                                                                            => 'vi',
    'རི་པིན་སྐད་'                                                                                                                         => 'ja',
    'རྒྱ་སྐད་'                                                                                                                                  => 'zh',
    'རྫོང་ཁ'                                                                                                                                        => 'dz',
    'ལཱ་ཏིན་སྐད།'                                                                                                                         => 'la',
    'སོག་སྐད།'                                                                                                                                  => 'mn',
    'སཾ་སྐྲྀ་ཏ།'                                                                                                                            => 'sa',
    'ཧའོ་ལན་སྐད།'                                                                                                                         => 'nl',
    'ཧིན་དི'                                                                                                                                        => 'hi',
    'ཧྥ་རན་སིའི་།'                                                                                                                      => 'fr',
    'ཧྲུའི་ཏན་སྐད།'                                                                                                                   => 'sv',
    'ཨིན་དོ་ནི་སི་སྐད།'                                                                                                       => 'id',
    'ཨུ་རུ་སུ་སྐད་'                                                                                                                   => 'ru',
    'ཨཽ་རི་ཡ་སྐད།'                                                                                                                      => 'or',
);

1;
