/*
 *
 *
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Zhen Sun <sunzhen1@kylinos.cn>
 *
 */

#include "widget.h"
#include <QWindow>
#include <QBoxLayout>
#include <QDebug>

using namespace kdk;

Widget::Widget(QWidget *parent)
    : QWidget(parent),
      m_subWidget1(nullptr),
      m_subWidget2(nullptr)
{
    m_manager = new kdk::WindowManager();
    m_timer = new QTimer(this);
    m_timer->setInterval(2000);

    initUI();
    initConnection();
}

Widget::~Widget()
{

}

void Widget::initUI()
{
    QVBoxLayout* mainLayout = new QVBoxLayout(this);

    QHBoxLayout* hLayout1 = new QHBoxLayout();
    m_btnMinimize = new QPushButton("minimize",this);
    m_btnMaximum = new QPushButton("maximum",this);
    m_btnActivate = new QPushButton("activate",this);
    m_btnStayOnTop = new QPushButton("stayOnTop",this);
    m_btnClose = new QPushButton("close",this);
    m_btnShowDesktop = new QPushButton("shwDsktp",this);
    m_shwWindowTitle = new QPushButton("shwTitle",this);
    m_shwWindowIcon = new QPushButton("shwIcon",this);
    hLayout1->addWidget(m_btnMinimize);
    hLayout1->addWidget(m_btnMaximum);
    hLayout1->addWidget(m_btnActivate);
    hLayout1->addWidget(m_btnStayOnTop);
    hLayout1->addWidget(m_btnClose);
    hLayout1->addWidget(m_btnShowDesktop);
    hLayout1->addWidget(m_shwWindowTitle);
    hLayout1->addWidget(m_shwWindowIcon);

    QHBoxLayout* hLayout2 = new QHBoxLayout();
    m_shwWdg1btn1 = new QPushButton("showWg1",this);
    m_shwWdg1btn2 = new QPushButton("showWg2",this);
    hLayout2->addWidget(m_shwWdg1btn1);
    hLayout2->addWidget(m_shwWdg1btn2);

    QHBoxLayout* hLayout3 = new QHBoxLayout();
    m_btnChangeIcon = new QPushButton("changeIcon",this);
    m_btnChangeTitle = new QPushButton("changeTitle",this);
    hLayout3->addWidget(m_btnChangeIcon);
    hLayout3->addWidget(m_btnChangeTitle);

    mainLayout->addLayout(hLayout1);
    mainLayout->addLayout(hLayout2);
    mainLayout->addLayout(hLayout3);
    this->setWindowIcon(QIcon::fromTheme("kylin-music"));
}

void Widget::initConnection()
{
    connect(m_manager,&WindowManager::activeWindowChanged,this,[=](const WindowId&wid){
        qDebug()<<"activeWindowChanged:"<<wid;
        qDebug()<<"currentActiveWindow:"<<m_manager->currentActiveWindow();
    });
    connect(m_manager,&WindowManager::windowAdded,this,[=](const WindowId& windowId){
        m_lastestWindowId = windowId;
        qDebug()<<"windowAdded:"<<m_lastestWindowId;
    });
    connect(m_manager,&WindowManager::windowRemoved,this,[=](const WindowId& windowId){
        qDebug()<<"windowRemoved:"<<windowId;
    });
//    connect(m_manager,&WindowManager::windowChanged,this,[=](const WindowId& windowId){
//        qDebug()<<"windowchaned:"<<windowId;
//    });
    connect(m_btnMinimize,&QPushButton::clicked,this,[=](){
        if(m_subWidget1)
        {
           m_manager->minimizeWindow(m_subWidget1->winId());
        }
    });

    connect(m_btnMaximum,&QPushButton::clicked,this,[=](){
        if(m_subWidget1)
        {
           m_manager->maximizeWindow(m_subWidget1->winId());
        }
    });

    connect(m_btnActivate,&QPushButton::clicked,this,[=](){
        if(m_subWidget1)
        {
           m_manager->activateWindow(m_subWidget1->winId());
        }
    });

    connect(m_btnStayOnTop,&QPushButton::clicked,this,[=](){
        if(!m_subWidget1)
        {
            m_subWidget1 = new QWidget();
            m_subWidget1->setWindowTitle("widget1");
        }
            m_manager->keepWindowAbove(m_subWidget1->winId());
    });

    connect(m_btnClose,&QPushButton::clicked,this,[=](){
        if(m_subWidget1)
        {
           m_manager->closeWindow(m_subWidget1->winId());
        }
    });

    connect(m_btnShowDesktop,&QPushButton::clicked,this,[=](){
            m_manager->showDesktop();
            m_timer->start();
            connect(m_timer,&QTimer::timeout,this,[=](){
                m_manager->hideDesktop();
            });
    });

    connect(m_shwWdg1btn1,&QPushButton::clicked,this,[=](){
        if(m_subWidget1)
        {
            m_subWidget1->show();
        }
        else
        {
            m_subWidget1 = new QWidget();
            m_subWidget1->setWindowTitle("widget1");
            m_subWidget1->show();
        }
    });
    connect(m_shwWdg1btn2,&QPushButton::clicked,this,[=](){
        if(m_subWidget2)
        {
            m_subWidget2->show();
        }
        else
        {
            m_subWidget2 = new QWidget();
            m_subWidget2->setWindowTitle("widget2");
            m_subWidget2->show();
        }
    });

    connect(m_btnChangeTitle,&QPushButton::clicked,this,[=](){
        if(m_subWidget1)
        {
            if(m_subWidget1->windowTitle()!= QString("originTitle"))
                m_subWidget1->setWindowTitle("originTitle");
            else
                m_subWidget1->setWindowTitle("changedTitle");
        }
    });

    connect(m_btnChangeIcon,&QPushButton::clicked,this,[=](){
        if(m_subWidget1)
        {
            if(!m_subWidget1->windowIcon().name().contains("kylin-music"))
                m_subWidget1->setWindowIcon(QIcon::fromTheme("kylin-music"));
            else
                m_subWidget1->setWindowIcon(QIcon::fromTheme("kylin-network"));
        }
    });

    connect(m_shwWindowTitle,&QPushButton::clicked,this,[=](){
        if(m_subWidget1)
            qDebug() << m_manager->getWindowTitle(m_subWidget1->winId());
    });

    connect(m_shwWindowIcon,&QPushButton::clicked,this,[=](){
        if(m_subWidget1)
        {
            WindowId nb = m_manager->currentActiveWindow();
            qDebug() << m_manager->getWindowIcon(nb);
        }
    });

}

