/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;
import sun.io.Converters;
import sun.misc.CVM;

class StringCoding {
    private static ThreadLocal decoder = new ThreadLocal();
    private static ThreadLocal encoder = new ThreadLocal();
    private static boolean warnUnsupportedCharset = true;

    private StringCoding() {
    }

    private static Object deref(ThreadLocal threadLocal) {
        SoftReference softReference = (SoftReference)threadLocal.get();
        if (softReference == null) {
            return null;
        }
        return softReference.get();
    }

    private static void set(ThreadLocal threadLocal, Object object) {
        threadLocal.set(new SoftReference(object));
    }

    private static byte[] trim(byte[] byArray, int n) {
        if (n == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        CVM.copyByteArray(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    private static char[] trim(char[] cArray, int n) {
        if (n == cArray.length) {
            return cArray;
        }
        char[] cArray2 = new char[n];
        CVM.copyCharArray(cArray, 0, cArray2, 0, n);
        return cArray2;
    }

    private static void warnUnsupportedCharset(String string) {
        if (warnUnsupportedCharset) {
            warnUnsupportedCharset = false;
        }
    }

    static char[] decode(String string, byte[] byArray, int n, int n2) throws UnsupportedEncodingException {
        String string2;
        StringDecoder stringDecoder = (StringDecoder)StringCoding.deref(decoder);
        String string3 = string2 = string == null ? "ISO-8859-1" : string;
        if (stringDecoder == null || !string2.equals(stringDecoder.requestedCharsetName()) && !string2.equals(stringDecoder.charsetName())) {
            stringDecoder = new ConverterSD(ByteToCharConverter.getConverter(string2), string2);
            StringCoding.set(decoder, stringDecoder);
        }
        return stringDecoder.decode(byArray, n, n2);
    }

    static char[] decode(byte[] byArray, int n, int n2) {
        String string = Converters.getDefaultEncodingName();
        try {
            return StringCoding.decode(string, byArray, n, n2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Converters.resetDefaultEncodingName();
            StringCoding.warnUnsupportedCharset(string);
            try {
                return StringCoding.decode("ISO-8859-1", byArray, n, n2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                System.exit(1);
                return null;
            }
        }
    }

    static byte[] encode(String string, char[] cArray, int n, int n2) throws UnsupportedEncodingException {
        String string2;
        StringEncoder stringEncoder = (StringEncoder)StringCoding.deref(encoder);
        String string3 = string2 = string == null ? "ISO-8859-1" : string;
        if (stringEncoder == null || !string2.equals(stringEncoder.requestedCharsetName()) && !string2.equals(stringEncoder.charsetName())) {
            stringEncoder = new ConverterSE(CharToByteConverter.getConverter(string2), string2);
            StringCoding.set(encoder, stringEncoder);
        }
        return stringEncoder.encode(cArray, n, n2);
    }

    static byte[] encode(char[] cArray, int n, int n2) {
        String string = Converters.getDefaultEncodingName();
        try {
            return StringCoding.encode(string, cArray, n, n2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Converters.resetDefaultEncodingName();
            StringCoding.warnUnsupportedCharset(string);
            try {
                return StringCoding.encode("ISO-8859-1", cArray, n, n2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                System.exit(1);
                return null;
            }
        }
    }

    private static class ConverterSE
    extends StringEncoder {
        private CharToByteConverter ctb;

        private ConverterSE(CharToByteConverter charToByteConverter, String string) {
            super(string);
            this.ctb = charToByteConverter;
        }

        String charsetName() {
            return this.ctb.getCharacterEncoding();
        }

        byte[] encode(char[] cArray, int n, int n2) {
            int n3 = this.ctb.getMaxBytesPerChar() * n2;
            byte[] byArray = new byte[n3];
            if (n2 == 0) {
                return byArray;
            }
            this.ctb.reset();
            try {
                int n4 = this.ctb.convertAny(cArray, n, n + n2, byArray, 0, n3);
            }
            catch (CharConversionException charConversionException) {
                throw new Error("Converter malfunction: " + this.ctb.getClass().getName(), charConversionException);
            }
            return StringCoding.trim(byArray, n4 += this.ctb.flushAny(byArray, this.ctb.nextByteIndex(), n3));
        }
    }

    private static abstract class StringEncoder {
        private final String requestedCharsetName;

        protected StringEncoder(String string) {
            this.requestedCharsetName = string;
        }

        final String requestedCharsetName() {
            return this.requestedCharsetName;
        }

        abstract String charsetName();

        abstract byte[] encode(char[] var1, int var2, int var3);
    }

    private static class ConverterSD
    extends StringDecoder {
        private ByteToCharConverter btc;

        private ConverterSD(ByteToCharConverter byteToCharConverter, String string) {
            super(string);
            this.btc = byteToCharConverter;
        }

        String charsetName() {
            return this.btc.getCharacterEncoding();
        }

        char[] decode(byte[] byArray, int n, int n2) {
            int n3 = this.btc.getMaxCharsPerByte() * n2;
            char[] cArray = new char[n3];
            if (n2 == 0) {
                return cArray;
            }
            this.btc.reset();
            int n4 = 0;
            try {
                n4 = this.btc.convert(byArray, n, n + n2, cArray, 0, n3);
                n4 += this.btc.flush(cArray, this.btc.nextCharIndex(), n3);
            }
            catch (CharConversionException charConversionException) {
                n4 = this.btc.nextCharIndex();
            }
            return StringCoding.trim(cArray, n4);
        }
    }

    private static abstract class StringDecoder {
        private final String requestedCharsetName;

        protected StringDecoder(String string) {
            this.requestedCharsetName = string;
        }

        final String requestedCharsetName() {
            return this.requestedCharsetName;
        }

        abstract String charsetName();

        abstract char[] decode(byte[] var1, int var2, int var3);
    }
}

