package org.jboss.cache.buddyreplication;

import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.stack.IpAddress;

import java.net.InetAddress;

/**
 * Address locator that has no knowledge of the new JGroups PhysicalAddress interface
 *
 * @author Manik Surtani
 * @since 3.2.0
 */
public class JGroups26AddressLocator implements AddressLocator
{
   public InetAddress locate(Channel c, Address a)
   {
      if (a instanceof IpAddress)
      {
         return ((IpAddress) a).getIpAddress();
      }
      else
      {
         throw new RuntimeException("Expected Address to be of type IpAddress.  Instead, was " + a.getClass() + "!  Don't know how to handle, giving up!");
      }
   }
}
