/*
 *  Copyright (C) 2004-2019 Edward F. Valeev
 *
 *  This file is part of Libint.
 *
 *  Libint is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Libint is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Libint.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef _libint2_include_libint2_deriviter_h_
#define _libint2_include_libint2_deriviter_h_

#include <libint2/util/intpart_iter.h>

namespace libint2 {

  /// Iterates over unique derivative indices
  template <unsigned int NCenters> using CartesianDerivIterator =
		  FixedOrderedIntegerPartitionIterator<std::array<unsigned int, NCenters*3>>;

}

#endif /* header guard */
