/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libepubgen project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef INCLUDED_EPUBTEXTSINK_H
#define INCLUDED_EPUBTEXTSINK_H

#include <vector>

#include <librevenge/librevenge.h>

#include <libepubgen/libepubgen.h>

namespace libepubgen
{

class EPUBTextSink
{
public:
  EPUBTextSink();

  void insertText(const librevenge::RVNGString &text);

  void insertLineBreak();

  void writeTo(EPUBPackage &package, const char *name);

private:
  std::vector<librevenge::RVNGString> m_lines;
};

}

#endif // INCLUDED_EPUBTEXTSINK_H

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
