/*
 * $Id$
 *
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.sun.javatest.services;

import java.io.InputStream;

import com.sun.javatest.services.Message.MessageType;

public class ThreadExecutor implements ServiceExecutor {
    private StoppableRunnable runner;
    private Thread worker;
    
    public ThreadExecutor(StoppableRunnable r) {
        runner = r;
        worker = new Thread(runner);
        worker.setDaemon(true);
    }

    public Message startService(Message startMsg) {
        if (startMsg.getType() != MessageType.START) {
            return new Message(MessageType.ERROR, "Bad Start Message");
        }
        
        worker.start();
        
        return new Message(MessageType.STARTED, "Execution Thread Started");
    }

    public Message stopService(Message stopMsg) {
        if (stopMsg.getType() != MessageType.START) {
            return new Message(MessageType.ERROR, "Bad Start Message");
        }
        
        runner.stop();
        if (worker.isAlive()) {
            return new Message(MessageType.ERROR, "Thread Wasn't Stopped");
        }
        
        return new Message(MessageType.STOPPED, "Thread Was Stopped Successfully");
    }

    public Message isAlive(Message isAlive) {
        if (isAlive.getType() != MessageType.IS_ALIVE) {
            return new Message(MessageType.ERROR, "Bad isAlive Message");
        }
        
        if (worker.isAlive()) {
            return new Message(MessageType.ALIVE, "Service is alive");
        }
        else {
            return new Message(MessageType.NOT_ALIVE, "Service is not alive");
        }
    }

    public InputStream getServiceErrorStream() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public InputStream getServiceOutputStream() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}
