/*
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do
 * so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package org.joni.test;

import org.joni.Option;
import org.joni.Syntax;
import org.jcodings.Config;
import org.jcodings.Encoding;
import org.jcodings.specific.EUCJPEncoding;

public class TestC extends Test {

    public int option() {
        return Option.DEFAULT;
    }

    public Encoding encoding() {
        return EUCJPEncoding.INSTANCE;
    }

    public String testEncoding() {
        return "cp1250";
    }

    public Syntax syntax() {
        return Syntax.DEFAULT;
    }

    public void test() throws InterruptedException {
        x2s("", "", 0, 0);
        x2s("^", "", 0, 0);
        x2s("$", "", 0, 0);
        x2s("\\G", "", 0, 0);
        x2s("\\A", "", 0, 0);
        x2s("\\Z", "", 0, 0);
        x2s("\\z", "", 0, 0);
        x2s("^$", "", 0, 0);
        x2s("\\ca", "\001", 0, 1);
        x2s("\\C-b", "\002", 0, 1);
        x2s("\\c\\\\", "\034", 0, 1);
        x2s("q[\\c\\\\]", "q\034", 0, 2);
        x2s("", "a", 0, 0);
        x2s("a", "a", 0, 1);
        x2s("\\x61", "a", 0, 1);
        x2s("aa", "aa", 0, 2);
        x2s("aaa", "aaa", 0, 3);
        x2s("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", 0, 35);
        x2s("ab", "ab", 0, 2);
        x2s("b", "ab", 1, 2);
        x2s("bc", "abc", 1, 3);
        x2s("(?i:#RET#)", "#INS##RET#", 5, 10);
        x2s("\\17", "\017", 0, 1);
        x2s("\\x1f", "\u001f", 0, 1);
        x2s("a(?#....\\\\JJJJ)b", "ab", 0, 2);
        x2s("(?x)  G (o O(?-x)oO) g L", "GoOoOgLe", 0, 7);
        x2s(".", "a", 0, 1);
        ns(".", "");
        x2s("..", "ab", 0, 2);
        x2s("\\w", "e", 0, 1);
        ns("\\W", "e");
        x2s("\\s", " ", 0, 1);
        x2s("\\S", "b", 0, 1);
        x2s("\\d", "4", 0, 1);
        ns("\\D", "4");
        x2s("\\b", "z ", 0, 0);
        x2s("\\b", " z", 1, 1);
        x2s("\\B", "zz ", 1, 1);
        x2s("\\B", "z ", 2, 2);
        x2s("\\B", " z", 0, 0);
        x2s("[ab]", "b", 0, 1);
        ns("[ab]", "c");
        x2s("[a-z]", "t", 0, 1);
        ns("[^a]", "a");
        x2s("[^a]", "\n", 0, 1);
        x2s("[]]", "]", 0, 1);
        ns("[^]]", "]");
        x2s("[\\^]+", "0^^1", 1, 3);
        x2s("[b-]", "b", 0, 1);
        x2s("[b-]", "-", 0, 1);
        x2s("[\\w]", "z", 0, 1);
        ns("[\\w]", " ");
        x2s("[\\W]", "b$", 1, 2);
        x2s("[\\d]", "5", 0, 1);
        ns("[\\d]", "e");
        x2s("[\\D]", "t", 0, 1);
        ns("[\\D]", "3");
        x2s("[\\s]", " ", 0, 1);
        ns("[\\s]", "a");
        x2s("[\\S]", "b", 0, 1);
        ns("[\\S]", " ");
        x2s("[\\w\\d]", "2", 0, 1);
        ns("[\\w\\d]", " ");
        x2s("[[:upper:]]", "B", 0, 1);
        x2s("[*[:xdigit:]+]", "+", 0, 1);
        x2s("[*[:xdigit:]+]", "GHIKK-9+*", 6, 7);
        x2s("[*[:xdigit:]+]", "-@^+", 3, 4);
        ns("[[:upper]]", "A");
        x2s("[[:upper]]", ":", 0, 1);
        x2s("[\\044-\\047]", "\046", 0, 1);
        x2s("[\\x5a-\\x5c]", "\u005b", 0, 1);
        x2s("[\\x6A-\\x6D]", "\u006c", 0, 1);
        ns("[\\x6A-\\x6D]", "\u006e");
        ns("^[0-9A-F]+ 0+ UNDEF ", "75F 00000000 SECT14A notype ()    External    | _rb_apply");
        x2s("[\\[]", "[", 0, 1);
        x2s("[\\]]", "]", 0, 1);
        x2s("[&]", "&", 0, 1);
        x2s("[[ab]]", "b", 0, 1);
        x2s("[[ab]c]", "c", 0, 1);
        ns("[[^a]]", "a");
        ns("[^[a]]", "a");
        x2s("[[ab]&&bc]", "b", 0, 1);
        ns("[[ab]&&bc]", "a");
        ns("[[ab]&&bc]", "c");
        x2s("[a-z&&b-y&&c-x]", "w", 0, 1);
        ns("[^a-z&&b-y&&c-x]", "w");
        x2s("[[^a&&a]&&a-z]", "b", 0, 1);
        ns("[[^a&&a]&&a-z]", "a");
        x2s("[[^a-z&&bcdef]&&[^c-g]]", "h", 0, 1);
        ns("[[^a-z&&bcdef]&&[^c-g]]", "c");
        x2s("[^[^abc]&&[^cde]]", "c", 0, 1);
        x2s("[^[^abc]&&[^cde]]", "e", 0, 1);
        ns("[^[^abc]&&[^cde]]", "f");
        x2s("[a-&&-a]", "-", 0, 1);
        ns("[a\\-&&\\-a]", "&");
        ns("\\wabc", " abc");
        x2s("a\\Wbc", "a bc", 0, 4);
        x2s("a.b.c", "aabbc", 0, 5);
        x2s(".\\wb\\W..c", "abb bcc", 0, 7);
        x2s("\\s\\wzzz", " zzzz", 0, 5);
        x2s("aa.b", "aabb", 0, 4);
        ns(".a", "ab");
        x2s(".a", "aa", 0, 2);
        x2s("^a", "a", 0, 1);
        x2s("^a$", "a", 0, 1);
        x2s("^\\w$", "a", 0, 1);
        ns("^\\w$", " ");
        x2s("^\\wab$", "zab", 0, 3);
        x2s("^\\wabcdef$", "zabcdef", 0, 7);
        x2s("^\\w...def$", "zabcdef", 0, 7);
        x2s("\\w\\w\\s\\Waaa\\d", "aa  aaa4", 0, 8);
        x2s("\\A\\Z", "", 0, 0);
        x2s("\\Axyz", "xyz", 0, 3);
        x2s("xyz\\Z", "xyz", 0, 3);
        x2s("xyz\\z", "xyz", 0, 3);
        x2s("a\\Z", "a", 0, 1);
        x2s("\\Gaz", "az", 0, 2);
        ns("\\Gz", "bza");
        ns("az\\G", "az");
        ns("az\\A", "az");
        ns("a\\Az", "az");
        x2s("\\^\\$", "^$", 0, 2);
        x2s("^x?y", "xy", 0, 2);
        x2s("^(x?y)", "xy", 0, 2);
        x2s("\\w", "_", 0, 1);
        ns("\\W", "_");
        x2s("(?=z)z", "z", 0, 1);
        ns("(?=z).", "a");
        x2s("(?!z)a", "a", 0, 1);
        ns("(?!z)a", "z");
        x2s("(?i:a)", "a", 0, 1);
        x2s("(?i:a)", "A", 0, 1);
        x2s("(?i:A)", "a", 0, 1);
        ns("(?i:A)", "b");
        x2s("(?i:[A-Z])", "a", 0, 1);
        x2s("(?i:[f-m])", "H", 0, 1);
        x2s("(?i:[f-m])", "h", 0, 1);
        ns("(?i:[f-m])", "e");
        x2s("(?i:[A-c])", "D", 0, 1);
        ns("(?i:[^a-z])", "A");
        ns("(?i:[^a-z])", "a");
        x2s("(?i:[!-k])", "Z", 0, 1);
        x2s("(?i:[!-k])", "7", 0, 1);
        x2s("(?i:[T-}])", "b", 0, 1);
        x2s("(?i:[T-}])", "{", 0, 1);
        x2s("(?i:\\?a)", "?A", 0, 2);
        x2s("(?i:\\*A)", "*a", 0, 2);
        ns(".", "\n");
        x2s("(?m:.)", "\n", 0, 1);
        x2s("(?m:a.)", "a\n", 0, 2);
        x2s("(?m:.b)", "a\nb", 1, 3);
        x2s(".*abc", "dddabdd\nddabc", 8, 13);
        x2s("(?m:.*abc)", "dddabddabc", 0, 10);
        ns("(?i)(?-i)a", "A");
        ns("(?i)(?-i:a)", "A");
        x2s("a?", "", 0, 0);
        x2s("a?", "b", 0, 0);
        x2s("a?", "a", 0, 1);
        x2s("a*", "", 0, 0);
        x2s("a*", "a", 0, 1);
        x2s("a*", "aaa", 0, 3);
        x2s("a*", "baaaa", 0, 0);
        ns("a+", "");
        x2s("a+", "a", 0, 1);
        x2s("a+", "aaaa", 0, 4);
        x2s("a+", "aabbb", 0, 2);
        x2s("a+", "baaaa", 1, 5);
        x2s(".?", "", 0, 0);
        x2s(".?", "f", 0, 1);
        x2s(".?", "\n", 0, 0);
        x2s(".*", "", 0, 0);
        x2s(".*", "abcde", 0, 5);
        x2s(".+", "z", 0, 1);
        x2s(".+", "zdswer\n", 0, 6);
        x2s("(.*)a\\1f", "babfbac", 0, 4);
        x2s("(.*)a\\1f", "bacbabf", 3, 7);
        x2s("((.*)a\\2f)", "bacbabf", 3, 7);
        x2s("(.*)a\\1f", "baczzzzzz\nbazz\nzzzzbabf", 19, 23);
        x2s("a|b", "a", 0, 1);
        x2s("a|b", "b", 0, 1);
        x2s("|a", "a", 0, 0);
        x2s("(|a)", "a", 0, 0);
        x2s("ab|bc", "ab", 0, 2);
        x2s("ab|bc", "bc", 0, 2);
        x2s("z(?:ab|bc)", "zbc", 0, 3);
        x2s("a(?:ab|bc)c", "aabc", 0, 4);
        x2s("ab|(?:ac|az)", "az", 0, 2);
        x2s("a|b|c", "dc", 1, 2);
        x2s("a|b|cd|efg|h|ijk|lmn|o|pq|rstuvwx|yz", "pqr", 0, 2);
        ns("a|b|cd|efg|h|ijk|lmn|o|pq|rstuvwx|yz", "mn");
        x2s("a|^z", "ba", 1, 2);
        x2s("a|^z", "za", 0, 1);
        x2s("a|\\Gz", "bza", 2, 3);
        x2s("a|\\Gz", "za", 0, 1);
        x2s("a|\\Az", "bza", 2, 3);
        x2s("a|\\Az", "za", 0, 1);
        x2s("a|b\\Z", "ba", 1, 2);
        x2s("a|b\\Z", "b", 0, 1);
        x2s("a|b\\z", "ba", 1, 2);
        x2s("a|b\\z", "b", 0, 1);
        x2s("\\w|\\s", " ", 0, 1);
        ns("\\w|\\w", " ");
        x2s("\\w|%", "%", 0, 1);
        x2s("\\w|[&$]", "&", 0, 1);
        x2s("[b-d]|[^e-z]", "a", 0, 1);
        x2s("(?:a|[c-f])|bz", "dz", 0, 1);
        x2s("(?:a|[c-f])|bz", "bz", 0, 2);
        x2s("abc|(?=zz)..f", "zzf", 0, 3);
        x2s("abc|(?!zz)..f", "abf", 0, 3);
        x2s("(?=za)..a|(?=zz)..a", "zza", 0, 3);
        ns("(?>a|abd)c", "abdc");
        x2s("(?>abd|a)c", "abdc", 0, 4);
        x2s("a?|b", "a", 0, 1);
        x2s("a?|b", "b", 0, 0);
        x2s("a?|b", "", 0, 0);
        x2s("a*|b", "aa", 0, 2);
        x2s("a*|b*", "ba", 0, 0);
        x2s("a*|b*", "ab", 0, 1);
        x2s("a+|b*", "", 0, 0);
        x2s("a+|b*", "bbb", 0, 3);
        x2s("a+|b*", "abbb", 0, 1);
        ns("a+|b+", "");
        x2s("(a|b)?", "b", 0, 1);
        x2s("(a|b)*", "ba", 0, 2);
        x2s("(a|b)+", "bab", 0, 3);
        x2s("(ab|ca)+", "caabbc", 0, 4);
        x2s("(ab|ca)+", "aabca", 1, 5);
        x2s("(ab|ca)+", "abzca", 0, 2);
        x2s("(a|bab)+", "ababa", 0, 5);
        x2s("(a|bab)+", "ba", 1, 2);
        x2s("(a|bab)+", "baaaba", 1, 4);
        x2s("(?:a|b)(?:a|b)", "ab", 0, 2);
        x2s("(?:a*|b*)(?:a*|b*)", "aaabbb", 0, 3);
        x2s("(?:a*|b*)(?:a+|b+)", "aaabbb", 0, 6);
        x2s("(?:a+|b+){2}", "aaabbb", 0, 6);
        x2s("h{0,}", "hhhh", 0, 4);
        x2s("(?:a+|b+){1,2}", "aaabbb", 0, 6);
        ns("ax{2}*a", "0axxxa1");
        ns("a.{0,2}a", "0aXXXa0");
        ns("a.{0,2}?a", "0aXXXa0");
        ns("a.{0,2}?a", "0aXXXXa0");
        x2s("^a{2,}?a$", "aaa", 0, 3);
        x2s("^[a-z]{2,}?$", "aaa", 0, 3);
        x2s("(?:a+|\\Ab*)cc", "cc", 0, 2);
        ns("(?:a+|\\Ab*)cc", "abcc");
        x2s("(?:^a+|b+)*c", "aabbbabc", 6, 8);
        x2s("(?:^a+|b+)*c", "aabbbbc", 0, 7);
        x2s("a|(?i)c", "C", 0, 1);
        x2s("(?i)c|a", "C", 0, 1);
        x2s("(?i)c|a", "A", 0, 1);
        x2s("(?i:c)|a", "C", 0, 1);
        ns("(?i:c)|a", "A");
        x2s("[abc]?", "abc", 0, 1);
        x2s("[abc]*", "abc", 0, 3);
        x2s("[^abc]*", "abc", 0, 0);
        ns("[^abc]+", "abc");
        x2s("a??", "aaa", 0, 0);
        x2s("ba??b", "bab", 0, 3);
        x2s("a*?", "aaa", 0, 0);
        x2s("ba*?", "baa", 0, 1);
        x2s("ba*?b", "baab", 0, 4);
        x2s("a+?", "aaa", 0, 1);
        x2s("ba+?", "baa", 0, 2);
        x2s("ba+?b", "baab", 0, 4);
        x2s("(?:a?)??", "a", 0, 0);
        x2s("(?:a??)?", "a", 0, 0);
        x2s("(?:a?)+?", "aaa", 0, 1);
        x2s("(?:a+)??", "aaa", 0, 0);
        x2s("(?:a+)??b", "aaab", 0, 4);
        x2s("(?:ab)?{2}", "", 0, 0);
        x2s("(?:ab)?{2}", "ababa", 0, 4);
        x2s("(?:ab)*{0}", "ababa", 0, 0);
        x2s("(?:ab){3,}", "abababab", 0, 8);
        ns("(?:ab){3,}", "abab");
        x2s("(?:ab){2,4}", "ababab", 0, 6);
        x2s("(?:ab){2,4}", "ababababab", 0, 8);
        x2s("(?:ab){2,4}?", "ababababab", 0, 4);
        x2s("(?:ab){,}", "ab{,}", 0, 5);
        x2s("(?:abc)+?{2}", "abcabcabc", 0, 6);
        x2s("(?:X*)(?i:xa)", "XXXa", 0, 4);
        x2s("(d+)([^abc]z)", "dddz", 0, 4);
        x2s("([^abc]*)([^abc]z)", "dddz", 0, 4);
        x2s("(\\w+)(\\wz)", "dddz", 0, 4);
        x3s("(a)", "a", 0, 1, 1);
        x3s("(ab)", "ab", 0, 2, 1);
        x2s("((ab))", "ab", 0, 2);
        x3s("((ab))", "ab", 0, 2, 1);
        x3s("((ab))", "ab", 0, 2, 2);
        x3s("((((((((((((((((((((ab))))))))))))))))))))", "ab", 0, 2, 20);
        x3s("(ab)(cd)", "abcd", 0, 2, 1);
        x3s("(ab)(cd)", "abcd", 2, 4, 2);
        x3s("()(a)bc(def)ghijk", "abcdefghijk", 3, 6, 3);
        x3s("(()(a)bc(def)ghijk)", "abcdefghijk", 3, 6, 4);
        x2s("(^a)", "a", 0, 1);
        x3s("(a)|(a)", "ba", 1, 2, 1);
        x3s("(^a)|(a)", "ba", 1, 2, 2);
        x3s("(a?)", "aaa", 0, 1, 1);
        x3s("(a*)", "aaa", 0, 3, 1);
        x3s("(a*)", "", 0, 0, 1);
        x3s("(a+)", "aaaaaaa", 0, 7, 1);
        x3s("(a+|b*)", "bbbaa", 0, 3, 1);
        x3s("(a+|b?)", "bbbaa", 0, 1, 1);
        x3s("(abc)?", "abc", 0, 3, 1);
        x3s("(abc)*", "abc", 0, 3, 1);
        x3s("(abc)+", "abc", 0, 3, 1);
        x3s("(xyz|abc)+", "abc", 0, 3, 1);
        x3s("([xyz][abc]|abc)+", "abc", 0, 3, 1);
        x3s("((?i:abc))", "AbC", 0, 3, 1);
        x2s("(abc)(?i:\\1)", "abcABC", 0, 6);
        x3s("((?m:a.c))", "a\nc", 0, 3, 1);
        x3s("((?=az)a)", "azb", 0, 1, 1);
        x3s("abc|(.abd)", "zabd", 0, 4, 1);
        x2s("(?:abc)|(ABC)", "abc", 0, 3);
        x3s("(?i:(abc))|(zzz)", "ABC", 0, 3, 1);
        x3s("a*(.)", "aaaaz", 4, 5, 1);
        x3s("a*?(.)", "aaaaz", 0, 1, 1);
        x3s("a*?(c)", "aaaac", 4, 5, 1);
        x3s("[bcd]a*(.)", "caaaaz", 5, 6, 1);
        x3s("(\\Abb)cc", "bbcc", 0, 2, 1);
        ns("(\\Abb)cc", "zbbcc");
        x3s("(^bb)cc", "bbcc", 0, 2, 1);
        ns("(^bb)cc", "zbbcc");
        x3s("cc(bb$)", "ccbb", 2, 4, 1);
        ns("cc(bb$)", "ccbbb");
        ns("(\\1)", "");
        ns("\\1(a)", "aa");
        ns("(a(b)\\1)\\2+", "ababb");
        ns("(?:(?:\\1|z)(a))+$", "zaa");
        x2s("(?:(?:\\1|z)(a))+$", "zaaa", 0, 4);
        x2s("(a)(?=\\1)", "aa", 0, 1);
        ns("(a)$|\\1", "az");
        x2s("(a)\\1", "aa", 0, 2);
        ns("(a)\\1", "ab");
        x2s("(a?)\\1", "aa", 0, 2);
        x2s("(a??)\\1", "aa", 0, 0);
        x2s("(a*)\\1", "aaaaa", 0, 4);
        x3s("(a*)\\1", "aaaaa", 0, 2, 1);
        x2s("a(b*)\\1", "abbbb", 0, 5);
        x2s("a(b*)\\1", "ab", 0, 1);
        x2s("(a*)(b*)\\1\\2", "aaabbaaabb", 0, 10);
        x2s("(a*)(b*)\\2", "aaabbbb", 0, 7);
        x2s("(((((((a*)b))))))c\\7", "aaabcaaa", 0, 8);
        x3s("(((((((a*)b))))))c\\7", "aaabcaaa", 0, 3, 7);
        x2s("(a)(b)(c)\\2\\1\\3", "abcbac", 0, 6);
        x2s("([a-d])\\1", "cc", 0, 2);
        x2s("(\\w\\d\\s)\\1", "f5 f5 ", 0, 6);
        ns("(\\w\\d\\s)\\1", "f5 f5");
        x2s("(who|[a-c]{3})\\1", "whowho", 0, 6);
        x2s("...(who|[a-c]{3})\\1", "abcwhowho", 0, 9);
        x2s("(who|[a-c]{3})\\1", "cbccbc", 0, 6);
        x2s("(^a)\\1", "aa", 0, 2);
        ns("(^a)\\1", "baa");
        ns("(a$)\\1", "aa");
        ns("(ab\\Z)\\1", "ab");
        x2s("(a*\\Z)\\1", "a", 1, 1);
        x2s(".(a*\\Z)\\1", "ba", 1, 2);
        x3s("(.(abc)\\2)", "zabcabc", 0, 7, 1);
        x3s("(.(..\\d.)\\2)", "z12341234", 0, 9, 1);
        x2s("((?i:az))\\1", "AzAz", 0, 4);
        ns("((?i:az))\\1", "Azaz");
        x2s("(?<=a)b", "ab", 1, 2);
        ns("(?<=a)b", "bb");
        x2s("(?<=a|b)b", "bb", 1, 2);
        x2s("(?<=a|bc)b", "bcb", 2, 3);
        x2s("(?<=a|bc)b", "ab", 1, 2);
        x2s("(?<=a|bc||defghij|klmnopq|r)z", "rz", 1, 2);
        x2s("(a)\\g<1>", "aa", 0, 2);
        x2s("(?<!a)b", "cb", 1, 2);
        ns("(?<!a)b", "ab");
        x2s("(?<!a|bc)b", "bbb", 0, 1);
        ns("(?<!a|bc)z", "bcz");
        x2s("(?<name1>a)", "a", 0, 1);
        x2s("(?<name_2>ab)\\g<name_2>", "abab", 0, 4);
        x2s("(?<name_3>.zv.)\\k<name_3>", "azvbazvb", 0, 8);
        x2s("(?<=\\g<ab>)|-\\zEND (?<ab>XyZ)", "XyZ", 3, 3);
        x2s("(?<n>|a\\g<n>)+", "", 0, 0);
        x2s("(?<n>|\\(\\g<n>\\))+$", "()(())", 0, 6);
        x3s("\\g<n>(?<n>.){0}", "X", 0, 1, 1);
        x2s("\\g<n>(abc|df(?<n>.YZ){2,8}){0}", "XYZ", 0, 3);
        x2s("\\A(?<n>(a\\g<n>)|)\\z", "aaaa", 0, 4);
        x2s("(?<n>|\\g<m>\\g<n>)\\z|\\zEND (?<m>a|(b)\\g<m>)", "bbbbabba", 0, 8);
        x2s("(?<name1240>\\w+\\sx)a+\\k<name1240>", "  fg xaaaaaaaafg x", 2, 18);
        x3s("(z)()()(?<_9>a)\\g<_9>", "zaa", 2, 3, 1);
        x2s("(.)(((?<_>a)))\\k<_>", "zaa", 0, 3);
        x2s("((?<name1>\\d)|(?<name2>\\w))(\\k<name1>|\\k<name2>)", "ff", 0, 2);
        x2s("(?:(?<x>)|(?<x>efg))\\k<x>", "", 0, 0);
        x2s("(?:(?<x>abc)|(?<x>efg))\\k<x>", "abcefgefg", 3, 9);
        ns("(?:(?<x>abc)|(?<x>efg))\\k<x>", "abcefg");
        x2s("(?:(?<n1>.)|(?<n1>..)|(?<n1>...)|(?<n1>....)|(?<n1>.....)|(?<n1>......)|(?<n1>.......)|(?<n1>........)|(?<n1>.........)|(?<n1>..........)|(?<n1>...........)|(?<n1>............)|(?<n1>.............)|(?<n1>..............))\\k<n1>$", "a-pyumpyum", 2, 10);
        x3s("(?:(?<n1>.)|(?<n1>..)|(?<n1>...)|(?<n1>....)|(?<n1>.....)|(?<n1>......)|(?<n1>.......)|(?<n1>........)|(?<n1>.........)|(?<n1>..........)|(?<n1>...........)|(?<n1>............)|(?<n1>.............)|(?<n1>..............))\\k<n1>$", "xxxxabcdefghijklmnabcdefghijklmn", 4, 18, 14);
        x3s("(?<name1>)(?<name2>)(?<name3>)(?<name4>)(?<name5>)(?<name6>)(?<name7>)(?<name8>)(?<name9>)(?<name10>)(?<name11>)(?<name12>)(?<name13>)(?<name14>)(?<name15>)(?<name16>aaa)(?<name17>)$", "aaa", 0, 3, 16);
        x2s("(?<foo>a|\\(\\g<foo>\\))", "a", 0, 1);
        x2s("(?<foo>a|\\(\\g<foo>\\))", "((((((a))))))", 0, 13);
        x3s("(?<foo>a|\\(\\g<foo>\\))", "((((((((a))))))))", 0, 17, 1);
        x2s("\\g<bar>|\\zEND(?<bar>.*abc$)", "abcxxxabc", 0, 9);
        x2s("\\g<1>|\\zEND(.a.)", "bac", 0, 3);
        x3s("\\g<_A>\\g<_A>|\\zEND(.a.)(?<_A>.b.)", "xbxyby", 3, 6, 1);
        x2s("\\A(?:\\g<pon>|\\g<pan>|\\zEND  (?<pan>a|c\\g<pon>c)(?<pon>b|d\\g<pan>d))$", "cdcbcdc", 0, 7);
        x2s("\\A(?<n>|a\\g<m>)\\z|\\zEND (?<m>\\g<n>)", "aaaa", 0, 4);
        x2s("(?<n>(a|b\\g<n>c){3,5})", "baaaaca", 1, 5);
        x2s("(?<n>(a|b\\g<n>c){3,5})", "baaaacaaaaa", 0, 10);
        x2s("(?<pare>\\(([^\\(\\)]++|\\g<pare>)*+\\))", "((a))", 0, 5);
        x2s("()*\\1", "", 0, 0);
        x2s("(?:()|())*\\1\\2", "", 0, 0);
        x3s("(?:\\1a|())*", "a", 0, 0, 1);
        x2s("x((.)*)*x", "0x1x2x3", 1, 6);
        x2s("x((.)*)*x(?i:\\1)\\Z", "0x1x2x1X2", 1, 9);
        x2s("(?:()|()|()|()|()|())*\\2\\5", "", 0, 0);
        x2s("(?:()|()|()|(x)|()|())*\\2b\\5", "b", 0, 1);
        if (Config.VANILLA) x2s("\\xED\\xF2", "\u00ed\u0148", 0, 2);
        x2s("", "\u00a4\u02d8", 0, 0);
        x2s("\u00a4\u02d8", "\u00a4\u02d8", 0, 2);
        ns("\u00a4\u00a4", "\u00a4\u02d8");
        x2s("\u00a4\u00a6\u00a4\u00a6", "\u00a4\u00a6\u00a4\u00a6", 0, 4);
        x2s("\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6", "\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6", 0, 6);
        x2s("\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142", "\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142", 0, 70);
        x2s("\u00a4\u02d8", "\u00a4\u00a4\u00a4\u02d8", 2, 4);
        x2s("\u00a4\u00a4\u00a4\u00a6", "\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6", 2, 6);
        if (Config.VANILLA) x2s("\\xca\\xb8", "\u0118\u00b8", 0, 2);
        x2s(".", "\u00a4\u02d8", 0, 2);
        x2s("..", "\u00a4\u00ab\u00a4\u00ad", 0, 4);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\\w", "\u00a4\u015e", 0, 2);
        if (!org.joni.Config.NON_UNICODE_SDW) ns("\\W", "\u00a4\u02d8");
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("[\\W]", "\u00a4\u00a6$", 2, 3);
        x2s("\\S", "\u00a4\u02dd", 0, 2);
        x2s("\\S", "\u00b4\u00c1", 0, 2);
        x2s("\\b", "\u00b5\u00a4 ", 0, 0);
        x2s("\\b", " \u00a4\u0170", 1, 1);
        x2s("\\B", "\u00a4\u00bb\u00a4\u02dd ", 2, 2);
        x2s("\\B", "\u00a4\u00a6 ", 3, 3);
        x2s("\\B", " \u00a4\u00a4", 0, 0);
        x2s("[\u00a4\u017c\u00a4\u00c1]", "\u00a4\u00c1", 0, 2);
        ns("[\u00a4\u0118\u00a4\u00cb]", "\u00a4\u011a");
        x2s("[\u00a4\u00a6-\u00a4\u015e]", "\u00a4\u00a8", 0, 2);
        ns("[^\u00a4\u00b1]", "\u00a4\u00b1");
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("[\\w]", "\u00a4\u00cd", 0, 2);
        ns("[\\d]", "\u00a4\u0150");
        x2s("[\\D]", "\u00a4\u010e", 0, 2);
        ns("[\\s]", "\u00a4\u017b");
        x2s("[\\S]", "\u00a4\u0158", 0, 2);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("[\\w\\d]", "\u00a4\u010d", 0, 2);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("[\\w\\d]", "   \u00a4\u010d", 3, 5);
        ns("\\w\u00b5\u00b4\u013d\u00d6", " \u00b5\u00b4\u013d\u00d6");
        x2s("\u00b5\u00b4\\W\u013d\u00d6", "\u00b5\u00b4 \u013d\u00d6", 0, 5);
        x2s("\u00a4\u02d8.\u00a4\u00a4.\u00a4\u00a6", "\u00a4\u02d8\u00a4\u02d8\u00a4\u00a4\u00a4\u00a4\u00a4\u00a6", 0, 10);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s(".\\w\u00a4\u00a6\\W..\u00a4\u013e", "\u00a4\u00a8\u00a4\u00a6\u00a4\u00a6 \u00a4\u00a6\u00a4\u013e\u00a4\u013e", 0, 13);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\\s\\w\u00a4\u0142\u00a4\u0142\u00a4\u0142", " \u00a4\u0142\u00a4\u0142\u00a4\u0142\u00a4\u0142", 0, 9);
        x2s("\u00a4\u02d8\u00a4\u02d8.\u00a4\u00b1", "\u00a4\u02d8\u00a4\u02d8\u00a4\u00b1\u00a4\u00b1", 0, 8);
        ns(".\u00a4\u00a4", "\u00a4\u00a4\u00a4\u00a8");
        x2s(".\u00a4\u015e", "\u00a4\u015e\u00a4\u015e", 0, 4);
        x2s("^\u00a4\u02d8", "\u00a4\u02d8", 0, 2);
        x2s("^\u00a4\u0155$", "\u00a4\u0155", 0, 2);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("^\\w$", "\u00a4\u00cb", 0, 2);
        x2s("^\\w\u00a4\u00ab\u00a4\u00ad\u00a4\u017b\u00a4\u00b1\u00a4\u0142$", "z\u00a4\u00ab\u00a4\u00ad\u00a4\u017b\u00a4\u00b1\u00a4\u0142", 0, 11);
        x2s("^\\w...\u00a4\u00a6\u00a4\u00a8\u00a4\u015e$", "z\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6\u00a4\u00a6\u00a4\u00a8\u00a4\u015e", 0, 13);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\\w\\w\\s\\W\u00a4\u015e\u00a4\u015e\u00a4\u015e\\d", "a\u00a4\u015e  \u00a4\u015e\u00a4\u015e\u00a4\u015e4", 0, 12);
        x2s("\\A\u00a4\u017c\u00a4\u00c1\u00a4\u00c4", "\u00a4\u017c\u00a4\u00c1\u00a4\u00c4", 0, 6);
        x2s("\u00a4\u0155\u00a4\u00e1\u00a4\u00e2\\Z", "\u00a4\u0155\u00a4\u00e1\u00a4\u00e2", 0, 6);
        x2s("\u00a4\u00ab\u00a4\u00ad\u00a4\u017b\\z", "\u00a4\u00ab\u00a4\u00ad\u00a4\u017b", 0, 6);
        x2s("\u00a4\u00ab\u00a4\u00ad\u00a4\u017b\\Z", "\u00a4\u00ab\u00a4\u00ad\u00a4\u017b\n", 0, 6);
        x2s("\\G\u00a4\u00dd\u00a4\u00d4", "\u00a4\u00dd\u00a4\u00d4", 0, 4);
        ns("\\G\u00a4\u00a8", "\u00a4\u00a6\u00a4\u00a8\u00a4\u015e");
        ns("\u00a4\u010c\u00a4\u0106\\G", "\u00a4\u010c\u00a4\u0106");
        ns("\u00a4\u0162\u00a4\u00df\\A", "\u00a4\u0162\u00a4\u00df");
        ns("\u00a4\u0162\\A\u00a4\u00df", "\u00a4\u0162\u00a4\u00df");
        x2s("(?=\u00a4\u00bb)\u00a4\u00bb", "\u00a4\u00bb", 0, 2);
        ns("(?=\u00a4\u00a6).", "\u00a4\u00a4");
        x2s("(?!\u00a4\u00a6)\u00a4\u00ab", "\u00a4\u00ab", 0, 2);
        ns("(?!\u00a4\u010c)\u00a4\u02d8", "\u00a4\u010c");
        x2s("(?i:\u00a4\u02d8)", "\u00a4\u02d8", 0, 2);
        x2s("(?i:\u00a4\u00d6\u00a4\u016e)", "\u00a4\u00d6\u00a4\u016e", 0, 4);
        ns("(?i:\u00a4\u00a4)", "\u00a4\u00a6");
        x2s("(?m:\u00a4\u010d.)", "\u00a4\u010d\n", 0, 3);
        x2s("(?m:.\u00a4\u00e1)", "\u00a4\u0162\n\u00a4\u00e1", 2, 5);
        x2s("\u00a4\u02d8?", "", 0, 0);
        x2s("\u0118\u0143?", "\u02db\u02dd", 0, 0);
        x2s("\u0118\u0143?", "\u0118\u0143", 0, 2);
        x2s("\u00ce\u011a*", "", 0, 0);
        x2s("\u00ce\u011a*", "\u00ce\u011a", 0, 2);
        x2s("\u00bb\u0147*", "\u00bb\u0147\u00bb\u0147\u00bb\u0147", 0, 6);
        x2s("\u00c7\u010e*", "\u013d\u017b\u00c7\u010e\u00c7\u010e\u00c7\u010e\u00c7\u010e", 0, 0);
        ns("\u00bb\u0142+", "");
        x2s("\u02db\u010e+", "\u02db\u010e", 0, 2);
        x2s("\u00bb\u0163+", "\u00bb\u0163\u00bb\u0163\u00bb\u0163\u00bb\u0163", 0, 8);
        x2s("\u00a4\u00a8+", "\u00a4\u00a8\u00a4\u00a8\u00a4\u00a6\u00a4\u00a6\u00a4\u00a6", 0, 4);
        x2s("\u00a4\u00a6+", "\u00a4\u015e\u00a4\u00a6\u00a4\u00a6\u00a4\u00a6\u00a4\u00a6", 2, 10);
        x2s(".?", "\u00a4\u017c", 0, 2);
        x2s(".*", "\u00a4\u0143\u00a4\u00d4\u00a4\u00d7\u00a4\u00da", 0, 8);
        x2s(".+", "\u00a4\u00ed", 0, 2);
        x2s(".+", "\u00a4\u00a4\u00a4\u00a6\u00a4\u00a8\u00a4\u00ab\n", 0, 8);
        x2s("\u00a4\u02d8|\u00a4\u00a4", "\u00a4\u02d8", 0, 2);
        x2s("\u00a4\u02d8|\u00a4\u00a4", "\u00a4\u00a4", 0, 2);
        x2s("\u00a4\u02d8\u00a4\u00a4|\u00a4\u00a4\u00a4\u00a6", "\u00a4\u02d8\u00a4\u00a4", 0, 4);
        x2s("\u00a4\u02d8\u00a4\u00a4|\u00a4\u00a4\u00a4\u00a6", "\u00a4\u00a4\u00a4\u00a6", 0, 4);
        x2s("\u00a4\u0148(?:\u00a4\u00ab\u00a4\u00ad|\u00a4\u00ad\u00a4\u017b)", "\u00a4\u0148\u00a4\u00ab\u00a4\u00ad", 0, 6);
        x2s("\u00a4\u0148(?:\u00a4\u00ab\u00a4\u00ad|\u00a4\u00ad\u00a4\u017b)\u00a4\u00b1", "\u00a4\u0148\u00a4\u00ad\u00a4\u017b\u00a4\u00b1", 0, 8);
        x2s("\u00a4\u02d8\u00a4\u00a4|(?:\u00a4\u02d8\u00a4\u00a6|\u00a4\u02d8\u00a4\u0148)", "\u00a4\u02d8\u00a4\u0148", 0, 4);
        x2s("\u00a4\u02d8|\u00a4\u00a4|\u00a4\u00a6", "\u00a4\u00a8\u00a4\u00a6", 2, 4);
        x2s("\u00a4\u02d8|\u00a4\u00a4|\u00a4\u00a6\u00a4\u00a8|\u00a4\u015e\u00a4\u00ab\u00a4\u00ad|\u00a4\u017b|\u00a4\u00b1\u00a4\u0142\u00a4\u00b5|\u00a4\u00b7\u00a4\u0105\u00a4\u00bb|\u00a4\u02dd|\u00a4\u017c\u00a4\u00c1|\u00a4\u00c4\u00a4\u0106\u00a4\u010c\u00a4\u0118\u00a4\u00cb|\u00a4\u011a\u00a4\u00cd", "\u00a4\u00b7\u00a4\u0105\u00a4\u00bb", 0, 6);
        ns("\u00a4\u02d8|\u00a4\u00a4|\u00a4\u00a6\u00a4\u00a8|\u00a4\u015e\u00a4\u00ab\u00a4\u00ad|\u00a4\u017b|\u00a4\u00b1\u00a4\u0142\u00a4\u00b5|\u00a4\u00b7\u00a4\u0105\u00a4\u00bb|\u00a4\u02dd|\u00a4\u017c\u00a4\u00c1|\u00a4\u00c4\u00a4\u0106\u00a4\u010c\u00a4\u0118\u00a4\u00cb|\u00a4\u011a\u00a4\u00cd", "\u00a4\u0105\u00a4\u00bb");
        x2s("\u00a4\u02d8|^\u00a4\u010f", "\u00a4\u00d6\u00a4\u02d8", 2, 4);
        x2s("\u00a4\u02d8|^\u00a4\u0148", "\u00a4\u0148\u00a4\u02d8", 0, 2);
        x2s("\u00b5\u00b4|\\G\u013d\u00d6", "\u00a4\u00b1\u013d\u00d6\u00b5\u00b4", 4, 6);
        x2s("\u00b5\u00b4|\\G\u013d\u00d6", "\u013d\u00d6\u00b5\u00b4", 0, 2);
        x2s("\u00b5\u00b4|\\A\u013d\u00d6", "b\u013d\u00d6\u00b5\u00b4", 3, 5);
        x2s("\u00b5\u00b4|\\A\u013d\u00d6", "\u013d\u00d6", 0, 2);
        x2s("\u00b5\u00b4|\u013d\u00d6\\Z", "\u013d\u00d6\u00b5\u00b4", 2, 4);
        x2s("\u00b5\u00b4|\u013d\u00d6\\Z", "\u013d\u00d6", 0, 2);
        x2s("\u00b5\u00b4|\u013d\u00d6\\Z", "\u013d\u00d6\n", 0, 2);
        x2s("\u00b5\u00b4|\u013d\u00d6\\z", "\u013d\u00d6\u00b5\u00b4", 2, 4);
        x2s("\u00b5\u00b4|\u013d\u00d6\\z", "\u013d\u00d6", 0, 2);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\\w|\\s", "\u00a4\u015e", 0, 2);
        x2s("\\w|%", "%\u00a4\u015e", 0, 1);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\\w|[&$]", "\u00a4\u00a6&", 0, 2);
        x2s("[\u00a4\u00a4-\u00a4\u00b1]", "\u00a4\u00a6", 0, 2);
        x2s("[\u00a4\u00a4-\u00a4\u00b1]|[^\u00a4\u00ab-\u00a4\u0142]", "\u00a4\u02d8", 0, 2);
        x2s("[\u00a4\u00a4-\u00a4\u00b1]|[^\u00a4\u00ab-\u00a4\u0142]", "\u00a4\u00ab", 0, 2);
        x2s("[^\u00a4\u02d8]", "\n", 0, 1);
        x2s("(?:\u00a4\u02d8|[\u00a4\u00a6-\u00a4\u00ad])|\u00a4\u00a4\u00a4\u0148", "\u00a4\u00a6\u00a4\u0148", 0, 2);
        x2s("(?:\u00a4\u02d8|[\u00a4\u00a6-\u00a4\u00ad])|\u00a4\u00a4\u00a4\u0148", "\u00a4\u00a4\u00a4\u0148", 0, 4);
        x2s("\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6|(?=\u00a4\u00b1\u00a4\u00b1)..\u00a4\u0170", "\u00a4\u00b1\u00a4\u00b1\u00a4\u0170", 0, 6);
        x2s("\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6|(?!\u00a4\u00b1\u00a4\u00b1)..\u00a4\u0170", "\u00a4\u02d8\u00a4\u00a4\u00a4\u0170", 0, 6);
        if (Config.VANILLA) x2s("(?=\u00a4\u0148\u00a4\u02d8)..\u00a4\u02d8|(?=\u00a4\u0148\u00a4\u0148)..\u00a4\u02d8", "\u00a4\u0148\u00a4\u0148\u00a4\u02d8", 0, 6);
        x2s("(?<=\u00a4\u02d8|\u00a4\u00a4\u00a4\u00a6)\u00a4\u00a4", "\u00a4\u00a4\u00a4\u00a6\u00a4\u00a4", 4, 6);
        ns("(?>\u00a4\u02d8|\u00a4\u02d8\u00a4\u00a4\u00a4\u00a8)\u00a4\u00a6", "\u00a4\u02d8\u00a4\u00a4\u00a4\u00a8\u00a4\u00a6");
        x2s("(?>\u00a4\u02d8\u00a4\u00a4\u00a4\u00a8|\u00a4\u02d8)\u00a4\u00a6", "\u00a4\u02d8\u00a4\u00a4\u00a4\u00a8\u00a4\u00a6", 0, 8);
        x2s("\u00a4\u02d8?|\u00a4\u00a4", "\u00a4\u02d8", 0, 2);
        x2s("\u00a4\u02d8?|\u00a4\u00a4", "\u00a4\u00a4", 0, 0);
        x2s("\u00a4\u02d8?|\u00a4\u00a4", "", 0, 0);
        x2s("\u00a4\u02d8*|\u00a4\u00a4", "\u00a4\u02d8\u00a4\u02d8", 0, 4);
        x2s("\u00a4\u02d8*|\u00a4\u00a4*", "\u00a4\u00a4\u00a4\u02d8", 0, 0);
        x2s("\u00a4\u02d8*|\u00a4\u00a4*", "\u00a4\u02d8\u00a4\u00a4", 0, 2);
        x2s("[a\u00a4\u02d8]*|\u00a4\u00a4*", "a\u00a4\u02d8\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4", 0, 3);
        x2s("\u00a4\u02d8+|\u00a4\u00a4*", "", 0, 0);
        x2s("\u00a4\u02d8+|\u00a4\u00a4*", "\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4", 0, 6);
        x2s("\u00a4\u02d8+|\u00a4\u00a4*", "\u00a4\u02d8\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4", 0, 2);
        x2s("\u00a4\u02d8+|\u00a4\u00a4*", "a\u00a4\u02d8\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4", 0, 0);
        ns("\u00a4\u02d8+|\u00a4\u00a4+", "");
        x2s("(\u00a4\u02d8|\u00a4\u00a4)?", "\u00a4\u00a4", 0, 2);
        x2s("(\u00a4\u02d8|\u00a4\u00a4)*", "\u00a4\u00a4\u00a4\u02d8", 0, 4);
        x2s("(\u00a4\u02d8|\u00a4\u00a4)+", "\u00a4\u00a4\u00a4\u02d8\u00a4\u00a4", 0, 6);
        x2s("(\u00a4\u02d8\u00a4\u00a4|\u00a4\u00a6\u00a4\u02d8)+", "\u00a4\u00a6\u00a4\u02d8\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6\u00a4\u00a8", 0, 8);
        x2s("(\u00a4\u02d8\u00a4\u00a4|\u00a4\u00a6\u00a4\u00a8)+", "\u00a4\u00a6\u00a4\u02d8\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6\u00a4\u00a8", 4, 12);
        x2s("(\u00a4\u02d8\u00a4\u00a4|\u00a4\u00a6\u00a4\u02d8)+", "\u00a4\u02d8\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6\u00a4\u02d8", 2, 10);
        x2s("(\u00a4\u02d8\u00a4\u00a4|\u00a4\u00a6\u00a4\u02d8)+", "\u00a4\u02d8\u00a4\u00a4\u00a4\u0148\u00a4\u00a6\u00a4\u02d8", 0, 4);
        x2s("(\u00a4\u02d8\u00a4\u00a4|\u00a4\u00a6\u00a4\u02d8)+", "$$zzzz\u00a4\u02d8\u00a4\u00a4\u00a4\u0148\u00a4\u00a6\u00a4\u02d8", 6, 10);
        x2s("(\u00a4\u02d8|\u00a4\u00a4\u00a4\u02d8\u00a4\u00a4)+", "\u00a4\u02d8\u00a4\u00a4\u00a4\u02d8\u00a4\u00a4\u00a4\u02d8", 0, 10);
        x2s("(\u00a4\u02d8|\u00a4\u00a4\u00a4\u02d8\u00a4\u00a4)+", "\u00a4\u00a4\u00a4\u02d8", 2, 4);
        x2s("(\u00a4\u02d8|\u00a4\u00a4\u00a4\u02d8\u00a4\u00a4)+", "\u00a4\u00a4\u00a4\u02d8\u00a4\u02d8\u00a4\u02d8\u00a4\u00a4\u00a4\u02d8", 2, 8);
        x2s("(?:\u00a4\u02d8|\u00a4\u00a4)(?:\u00a4\u02d8|\u00a4\u00a4)", "\u00a4\u02d8\u00a4\u00a4", 0, 4);
        x2s("(?:\u00a4\u02d8*|\u00a4\u00a4*)(?:\u00a4\u02d8*|\u00a4\u00a4*)", "\u00a4\u02d8\u00a4\u02d8\u00a4\u02d8\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4", 0, 6);
        x2s("(?:\u00a4\u02d8*|\u00a4\u00a4*)(?:\u00a4\u02d8+|\u00a4\u00a4+)", "\u00a4\u02d8\u00a4\u02d8\u00a4\u02d8\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4", 0, 12);
        x2s("(?:\u00a4\u02d8+|\u00a4\u00a4+){2}", "\u00a4\u02d8\u00a4\u02d8\u00a4\u02d8\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4", 0, 12);
        x2s("(?:\u00a4\u02d8+|\u00a4\u00a4+){1,2}", "\u00a4\u02d8\u00a4\u02d8\u00a4\u02d8\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4", 0, 12);
        x2s("(?:\u00a4\u02d8+|\\A\u00a4\u00a4*)\u00a4\u00a6\u00a4\u00a6", "\u00a4\u00a6\u00a4\u00a6", 0, 4);
        ns("(?:\u00a4\u02d8+|\\A\u00a4\u00a4*)\u00a4\u00a6\u00a4\u00a6", "\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6\u00a4\u00a6");
        x2s("(?:^\u00a4\u02d8+|\u00a4\u00a4+)*\u00a4\u00a6", "\u00a4\u02d8\u00a4\u02d8\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6", 12, 16);
        x2s("(?:^\u00a4\u02d8+|\u00a4\u00a4+)*\u00a4\u00a6", "\u00a4\u02d8\u00a4\u02d8\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a6", 0, 14);
        x2s("\u00a4\u00a6{0,}", "\u00a4\u00a6\u00a4\u00a6\u00a4\u00a6\u00a4\u00a6", 0, 8);
        x2s("\u00a4\u02d8|(?i)c", "C", 0, 1);
        x2s("(?i)c|\u00a4\u02d8", "C", 0, 1);
        x2s("(?i:\u00a4\u02d8)|a", "a", 0, 1);
        ns("(?i:\u00a4\u02d8)|a", "A");
        x2s("[\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6]?", "\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6", 0, 2);
        x2s("[\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6]*", "\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6", 0, 6);
        x2s("[^\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6]*", "\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6", 0, 0);
        ns("[^\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6]+", "\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6");
        x2s("\u00a4\u02d8??", "\u00a4\u02d8\u00a4\u02d8\u00a4\u02d8", 0, 0);
        x2s("\u00a4\u00a4\u00a4\u02d8??\u00a4\u00a4", "\u00a4\u00a4\u00a4\u02d8\u00a4\u00a4", 0, 6);
        x2s("\u00a4\u02d8*?", "\u00a4\u02d8\u00a4\u02d8\u00a4\u02d8", 0, 0);
        x2s("\u00a4\u00a4\u00a4\u02d8*?", "\u00a4\u00a4\u00a4\u02d8\u00a4\u02d8", 0, 2);
        x2s("\u00a4\u00a4\u00a4\u02d8*?\u00a4\u00a4", "\u00a4\u00a4\u00a4\u02d8\u00a4\u02d8\u00a4\u00a4", 0, 8);
        x2s("\u00a4\u02d8+?", "\u00a4\u02d8\u00a4\u02d8\u00a4\u02d8", 0, 2);
        x2s("\u00a4\u00a4\u00a4\u02d8+?", "\u00a4\u00a4\u00a4\u02d8\u00a4\u02d8", 0, 4);
        x2s("\u00a4\u00a4\u00a4\u02d8+?\u00a4\u00a4", "\u00a4\u00a4\u00a4\u02d8\u00a4\u02d8\u00a4\u00a4", 0, 8);
        x2s("(?:\u0139\u00b7?)??", "\u0139\u00b7", 0, 0);
        x2s("(?:\u0139\u00b7??)?", "\u0139\u00b7", 0, 0);
        x2s("(?:\u011a\u00b4?)+?", "\u011a\u00b4\u011a\u00b4\u011a\u00b4", 0, 2);
        x2s("(?:\u00c9\u00f7+)??", "\u00c9\u00f7\u00c9\u00f7\u00c9\u00f7", 0, 0);
        x2s("(?:\u0154\u0103+)??\u00c1\u00fa", "\u0154\u0103\u0154\u0103\u0154\u0103\u00c1\u00fa", 0, 8);
        x2s("(?:\u00a4\u02d8\u00a4\u00a4)?{2}", "", 0, 0);
        x2s("(?:\u00b5\u00b4\u013d\u00d6)?{2}", "\u00b5\u00b4\u013d\u00d6\u00b5\u00b4\u013d\u00d6\u00b5\u00b4", 0, 8);
        x2s("(?:\u00b5\u00b4\u013d\u00d6)*{0}", "\u00b5\u00b4\u013d\u00d6\u00b5\u00b4\u013d\u00d6\u00b5\u00b4", 0, 0);
        x2s("(?:\u00b5\u00b4\u013d\u00d6){3,}", "\u00b5\u00b4\u013d\u00d6\u00b5\u00b4\u013d\u00d6\u00b5\u00b4\u013d\u00d6\u00b5\u00b4\u013d\u00d6", 0, 16);
        ns("(?:\u00b5\u00b4\u013d\u00d6){3,}", "\u00b5\u00b4\u013d\u00d6\u00b5\u00b4\u013d\u00d6");
        x2s("(?:\u00b5\u00b4\u013d\u00d6){2,4}", "\u00b5\u00b4\u013d\u00d6\u00b5\u00b4\u013d\u00d6\u00b5\u00b4\u013d\u00d6", 0, 12);
        x2s("(?:\u00b5\u00b4\u013d\u00d6){2,4}", "\u00b5\u00b4\u013d\u00d6\u00b5\u00b4\u013d\u00d6\u00b5\u00b4\u013d\u00d6\u00b5\u00b4\u013d\u00d6\u00b5\u00b4\u013d\u00d6", 0, 16);
        x2s("(?:\u00b5\u00b4\u013d\u00d6){2,4}?", "\u00b5\u00b4\u013d\u00d6\u00b5\u00b4\u013d\u00d6\u00b5\u00b4\u013d\u00d6\u00b5\u00b4\u013d\u00d6\u00b5\u00b4\u013d\u00d6", 0, 8);
        x2s("(?:\u00b5\u00b4\u013d\u00d6){,}", "\u00b5\u00b4\u013d\u00d6{,}", 0, 7);
        x2s("(?:\u00a4\u00ab\u00a4\u00ad\u00a4\u017b)+?{2}", "\u00a4\u00ab\u00a4\u00ad\u00a4\u017b\u00a4\u00ab\u00a4\u00ad\u00a4\u017b\u00a4\u00ab\u00a4\u00ad\u00a4\u017b", 0, 12);
        x3s("(\u02db\u0110)", "\u02db\u0110", 0, 2, 1);
        x3s("(\u02db\u0110\u017c\u013a)", "\u02db\u0110\u017c\u013a", 0, 4, 1);
        x2s("((\u00bb\u0163\u00b4\u00d6))", "\u00bb\u0163\u00b4\u00d6", 0, 4);
        x3s("((\u00c9\u00f7\u017c\u013a))", "\u00c9\u00f7\u017c\u013a", 0, 4, 1);
        x3s("((\u015f\u0148\u0106\u00fc))", "\u015f\u0148\u0106\u00fc", 0, 4, 2);
        x3s("((((((((((((((((((((\u00ce\u011a\u00bb\u0147))))))))))))))))))))", "\u00ce\u011a\u00bb\u0147", 0, 4, 20);
        x3s("(\u00a4\u02d8\u00a4\u00a4)(\u00a4\u00a6\u00a4\u00a8)", "\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6\u00a4\u00a8", 0, 4, 1);
        x3s("(\u00a4\u02d8\u00a4\u00a4)(\u00a4\u00a6\u00a4\u00a8)", "\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6\u00a4\u00a8", 4, 8, 2);
        x3s("()(\u00a4\u02d8)\u00a4\u00a4\u00a4\u00a6(\u00a4\u00a8\u00a4\u015e\u00a4\u00ab)\u00a4\u00ad\u00a4\u017b\u00a4\u00b1\u00a4\u0142", "\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6\u00a4\u00a8\u00a4\u015e\u00a4\u00ab\u00a4\u00ad\u00a4\u017b\u00a4\u00b1\u00a4\u0142", 6, 12, 3);
        x3s("(()(\u00a4\u02d8)\u00a4\u00a4\u00a4\u00a6(\u00a4\u00a8\u00a4\u015e\u00a4\u00ab)\u00a4\u00ad\u00a4\u017b\u00a4\u00b1\u00a4\u0142)", "\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6\u00a4\u00a8\u00a4\u015e\u00a4\u00ab\u00a4\u00ad\u00a4\u017b\u00a4\u00b1\u00a4\u0142", 6, 12, 4);
        x3s(".*(\u0104\u0150\u0104\u00a9)\u0104\u00f3\u02c7\u00a6\u0104\u0162(\u0104\u00f3()\u0104\u00b7\u0104\u013a\u0104\u017c)\u0104\u00a4\u0104\u00f3", "\u0104\u0150\u0104\u00a9\u0104\u00f3\u02c7\u00a6\u0104\u0162\u0104\u00f3\u0104\u00b7\u0104\u013a\u0104\u017c\u0104\u00a4\u0104\u00f3", 10, 18, 2);
        x2s("(^\u00a4\u02d8)", "\u00a4\u02d8", 0, 2);
        x3s("(\u00a4\u02d8)|(\u00a4\u02d8)", "\u00a4\u00a4\u00a4\u02d8", 2, 4, 1);
        x3s("(^\u00a4\u02d8)|(\u00a4\u02d8)", "\u00a4\u00a4\u00a4\u02d8", 2, 4, 2);
        x3s("(\u00a4\u02d8?)", "\u00a4\u02d8\u00a4\u02d8\u00a4\u02d8", 0, 2, 1);
        x3s("(\u00a4\u0162*)", "\u00a4\u0162\u00a4\u0162\u00a4\u0162", 0, 6, 1);
        x3s("(\u00a4\u010c*)", "", 0, 0, 1);
        x3s("(\u00a4\u00eb+)", "\u00a4\u00eb\u00a4\u00eb\u00a4\u00eb\u00a4\u00eb\u00a4\u00eb\u00a4\u00eb\u00a4\u00eb", 0, 14, 1);
        x3s("(\u00a4\u0150+|\u00a4\u0158*)", "\u00a4\u0150\u00a4\u0150\u00a4\u0150\u00a4\u0158\u00a4\u0158", 0, 6, 1);
        x3s("(\u00a4\u02d8+|\u00a4\u00a4?)", "\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u02d8\u00a4\u02d8", 0, 2, 1);
        x3s("(\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6)?", "\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6", 0, 6, 1);
        x3s("(\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6)*", "\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6", 0, 6, 1);
        x3s("(\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6)+", "\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6", 0, 6, 1);
        x3s("(\u00a4\u00b5\u00a4\u00b7\u00a4\u0105|\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6)+", "\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6", 0, 6, 1);
        x3s("([\u00a4\u0118\u00a4\u00cb\u00a4\u011a][\u00a4\u00ab\u00a4\u00ad\u00a4\u017b]|\u00a4\u00ab\u00a4\u00ad\u00a4\u017b)+", "\u00a4\u00ab\u00a4\u00ad\u00a4\u017b", 0, 6, 1);
        x3s("((?i:\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6))", "\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6", 0, 6, 1);
        x3s("((?m:\u00a4\u02d8.\u00a4\u00a6))", "\u00a4\u02d8\n\u00a4\u00a6", 0, 5, 1);
        x3s("((?=\u00a4\u02d8\u00a4\u00f3)\u00a4\u02d8)", "\u00a4\u02d8\u00a4\u00f3\u00a4\u00a4", 0, 2, 1);
        x3s("\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6|(.\u00a4\u02d8\u00a4\u00a4\u00a4\u00a8)", "\u00a4\u00f3\u00a4\u02d8\u00a4\u00a4\u00a4\u00a8", 0, 8, 1);
        x3s("\u00a4\u02d8*(.)", "\u00a4\u02d8\u00a4\u02d8\u00a4\u02d8\u00a4\u02d8\u00a4\u00f3", 8, 10, 1);
        x3s("\u00a4\u02d8*?(.)", "\u00a4\u02d8\u00a4\u02d8\u00a4\u02d8\u00a4\u02d8\u00a4\u00f3", 0, 2, 1);
        x3s("\u00a4\u02d8*?(\u00a4\u00f3)", "\u00a4\u02d8\u00a4\u02d8\u00a4\u02d8\u00a4\u02d8\u00a4\u00f3", 8, 10, 1);
        x3s("[\u00a4\u00a4\u00a4\u00a6\u00a4\u00a8]\u00a4\u02d8*(.)", "\u00a4\u00a8\u00a4\u02d8\u00a4\u02d8\u00a4\u02d8\u00a4\u02d8\u00a4\u00f3", 10, 12, 1);
        x3s("(\\A\u00a4\u00a4\u00a4\u00a4)\u00a4\u00a6\u00a4\u00a6", "\u00a4\u00a4\u00a4\u00a4\u00a4\u00a6\u00a4\u00a6", 0, 4, 1);
        ns("(\\A\u00a4\u00a4\u00a4\u00a4)\u00a4\u00a6\u00a4\u00a6", "\u00a4\u00f3\u00a4\u00a4\u00a4\u00a4\u00a4\u00a6\u00a4\u00a6");
        x3s("(^\u00a4\u00a4\u00a4\u00a4)\u00a4\u00a6\u00a4\u00a6", "\u00a4\u00a4\u00a4\u00a4\u00a4\u00a6\u00a4\u00a6", 0, 4, 1);
        ns("(^\u00a4\u00a4\u00a4\u00a4)\u00a4\u00a6\u00a4\u00a6", "\u00a4\u00f3\u00a4\u00a4\u00a4\u00a4\u00a4\u00a6\u00a4\u00a6");
        x3s("\u00a4\u00ed\u00a4\u00ed(\u00a4\u00eb\u00a4\u00eb$)", "\u00a4\u00ed\u00a4\u00ed\u00a4\u00eb\u00a4\u00eb", 4, 8, 1);
        ns("\u00a4\u00ed\u00a4\u00ed(\u00a4\u00eb\u00a4\u00eb$)", "\u00a4\u00ed\u00a4\u00ed\u00a4\u00eb\u00a4\u00eb\u00a4\u00eb");
        x2s("(\u011a\u00b5)\\1", "\u011a\u00b5\u011a\u00b5", 0, 4);
        ns("(\u011a\u00b5)\\1", "\u011a\u00b5\u00c9\u0111");
        x2s("(\u00b6\u0151?)\\1", "\u00b6\u0151\u00b6\u0151", 0, 4);
        x2s("(\u00b6\u0151??)\\1", "\u00b6\u0151\u00b6\u0151", 0, 0);
        x2s("(\u00b6\u0151*)\\1", "\u00b6\u0151\u00b6\u0151\u00b6\u0151\u00b6\u0151\u00b6\u0151", 0, 8);
        x3s("(\u00b6\u0151*)\\1", "\u00b6\u0151\u00b6\u0151\u00b6\u0151\u00b6\u0151\u00b6\u0151", 0, 4, 1);
        x2s("\u00a4\u02d8(\u00a4\u00a4*)\\1", "\u00a4\u02d8\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4", 0, 10);
        x2s("\u00a4\u02d8(\u00a4\u00a4*)\\1", "\u00a4\u02d8\u00a4\u00a4", 0, 2);
        x2s("(\u00a4\u02d8*)(\u00a4\u00a4*)\\1\\2", "\u00a4\u02d8\u00a4\u02d8\u00a4\u02d8\u00a4\u00a4\u00a4\u00a4\u00a4\u02d8\u00a4\u02d8\u00a4\u02d8\u00a4\u00a4\u00a4\u00a4", 0, 20);
        x2s("(\u00a4\u02d8*)(\u00a4\u00a4*)\\2", "\u00a4\u02d8\u00a4\u02d8\u00a4\u02d8\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4", 0, 14);
        x3s("(\u00a4\u02d8*)(\u00a4\u00a4*)\\2", "\u00a4\u02d8\u00a4\u02d8\u00a4\u02d8\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4", 6, 10, 2);
        x2s("(((((((\u00a4\u00dd*)\u00a4\u00da))))))\u00a4\u00d4\\7", "\u00a4\u00dd\u00a4\u00dd\u00a4\u00dd\u00a4\u00da\u00a4\u00d4\u00a4\u00dd\u00a4\u00dd\u00a4\u00dd", 0, 16);
        x3s("(((((((\u00a4\u00dd*)\u00a4\u00da))))))\u00a4\u00d4\\7", "\u00a4\u00dd\u00a4\u00dd\u00a4\u00dd\u00a4\u00da\u00a4\u00d4\u00a4\u00dd\u00a4\u00dd\u00a4\u00dd", 0, 6, 7);
        x2s("(\u00a4\u010e)(\u00a4\u0147)(\u00a4\u0150)\\2\\1\\3", "\u00a4\u010e\u00a4\u0147\u00a4\u0150\u00a4\u0147\u00a4\u010e\u00a4\u0150", 0, 12);
        x2s("([\u00a4\u00ad-\u00a4\u00b1])\\1", "\u00a4\u017b\u00a4\u017b", 0, 4);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("(\\w\\d\\s)\\1", "\u00a4\u02d85 \u00a4\u02d85 ", 0, 8);
        ns("(\\w\\d\\s)\\1", "\u00a4\u02d85 \u00a4\u02d85");
        x2s("(\u0102\u017b\u02c7\u00a9|[\u00a4\u02d8-\u00a4\u00a6]{3})\\1", "\u0102\u017b\u02c7\u00a9\u0102\u017b\u02c7\u00a9", 0, 8);
        x2s("...(\u0102\u017b\u02c7\u00a9|[\u00a4\u02d8-\u00a4\u00a6]{3})\\1", "\u00a4\u02d8a\u00a4\u02d8\u0102\u017b\u02c7\u00a9\u0102\u017b\u02c7\u00a9", 0, 13);
        x2s("(\u0102\u017b\u02c7\u00a9|[\u00a4\u02d8-\u00a4\u00a6]{3})\\1", "\u00a4\u00a6\u00a4\u00a4\u00a4\u00a6\u00a4\u00a6\u00a4\u00a4\u00a4\u00a6", 0, 12);
        x2s("(^\u00a4\u0142)\\1", "\u00a4\u0142\u00a4\u0142", 0, 4);
        ns("(^\u00a4\u0155)\\1", "\u00a4\u00e1\u00a4\u0155\u00a4\u0155");
        ns("(\u00a4\u02d8$)\\1", "\u00a4\u02d8\u00a4\u02d8");
        ns("(\u00a4\u02d8\u00a4\u00a4\\Z)\\1", "\u00a4\u02d8\u00a4\u00a4");
        x2s("(\u00a4\u02d8*\\Z)\\1", "\u00a4\u02d8", 2, 2);
        x2s(".(\u00a4\u02d8*\\Z)\\1", "\u00a4\u00a4\u00a4\u02d8", 2, 4);
        x3s("(.(\u00a4\u00e4\u00a4\u00a4\u00a4\u0107)\\2)", "z\u00a4\u00e4\u00a4\u00a4\u00a4\u0107\u00a4\u00e4\u00a4\u00a4\u00a4\u0107", 0, 13, 1);
        x3s("(.(..\\d.)\\2)", "\u00a4\u02d812341234", 0, 10, 1);
        x2s("((?i:\u00a4\u02d8v\u00a4\u015f))\\1", "\u00a4\u02d8v\u00a4\u015f\u00a4\u02d8v\u00a4\u015f", 0, 10);
        x2s("(?<\u00b6\u0148\u00a4\u00ab>\u0118\u0143|\\(\\g<\u00b6\u0148\u00a4\u00ab>\\))", "((((((\u0118\u0143))))))", 0, 14);
        x2s("\\A(?:\\g<\u00b0\u00a4_1>|\\g<\u00b1\u013e_2>|\\z\u02dd\u015e\u00ce\u00bb  (?<\u00b0\u00a4_1>\u00b4\u0143|\u013d\u00ab\\g<\u00b1\u013e_2>\u013d\u00ab)(?<\u00b1\u013e_2>\u015f\u00df|\u0118\u00ee\u00bb\u00a7\\g<\u00b0\u00a4_1>\u0118\u00ee\u00bb\u00a7))$", "\u0118\u00ee\u00bb\u00a7\u013d\u00ab\u0118\u00ee\u00bb\u00a7\u013d\u00ab\u015f\u00df\u013d\u00ab\u0118\u00ee\u00bb\u00a7\u013d\u00ab\u0118\u00ee\u00bb\u00a7", 0, 26);
        x2s("[[\u00a4\u0147\u00a4\u0150]]", "\u00a4\u0150", 0, 2);
        x2s("[[\u00a4\u00a4\u00a4\u015e\u00a4\u00a6]\u00a4\u00ab]", "\u00a4\u00ab", 0, 2);
        ns("[[^\u00a4\u02d8]]", "\u00a4\u02d8");
        ns("[^[\u00a4\u02d8]]", "\u00a4\u02d8");
        x2s("[^[^\u00a4\u02d8]]", "\u00a4\u02d8", 0, 2);
        x2s("[[\u00a4\u00ab\u00a4\u00ad\u00a4\u017b]&&\u00a4\u00ad\u00a4\u017b]", "\u00a4\u017b", 0, 2);
        ns("[[\u00a4\u00ab\u00a4\u00ad\u00a4\u017b]&&\u00a4\u00ad\u00a4\u017b]", "\u00a4\u00ab");
        ns("[[\u00a4\u00ab\u00a4\u00ad\u00a4\u017b]&&\u00a4\u00ad\u00a4\u017b]", "\u00a4\u00b1");
        x2s("[\u00a4\u02d8-\u00a4\u00f3&&\u00a4\u00a4-\u00a4\u0148&&\u00a4\u00a6-\u00a4\u0144]", "\u00a4\u0144", 0, 2);
        ns("[^\u00a4\u02d8-\u00a4\u00f3&&\u00a4\u00a4-\u00a4\u0148&&\u00a4\u00a6-\u00a4\u0144]", "\u00a4\u0144");
        x2s("[[^\u00a4\u02d8&&\u00a4\u02d8]&&\u00a4\u02d8-\u00a4\u00f3]", "\u00a4\u00a4", 0, 2);
        ns("[[^\u00a4\u02d8&&\u00a4\u02d8]&&\u00a4\u02d8-\u00a4\u00f3]", "\u00a4\u02d8");
        x2s("[[^\u00a4\u02d8-\u00a4\u00f3&&\u00a4\u00a4\u00a4\u00a6\u00a4\u00a8\u00a4\u015e]&&[^\u00a4\u00a6-\u00a4\u00ab]]", "\u00a4\u00ad", 0, 2);
        ns("[[^\u00a4\u02d8-\u00a4\u00f3&&\u00a4\u00a4\u00a4\u00a6\u00a4\u00a8\u00a4\u015e]&&[^\u00a4\u00a6-\u00a4\u00ab]]", "\u00a4\u00a4");
        x2s("[^[^\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6]&&[^\u00a4\u00a6\u00a4\u00a8\u00a4\u015e]]", "\u00a4\u00a6", 0, 2);
        x2s("[^[^\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6]&&[^\u00a4\u00a6\u00a4\u00a8\u00a4\u015e]]", "\u00a4\u00a8", 0, 2);
        ns("[^[^\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6]&&[^\u00a4\u00a6\u00a4\u00a8\u00a4\u015e]]", "\u00a4\u00ab");
        x2s("[\u00a4\u02d8-&&-\u00a4\u02d8]", "-", 0, 1);
        x2s("[^[^a-z\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6]&&[^bcdefg\u00a4\u00a6\u00a4\u00a8\u00a4\u015e]q-w]", "\u00a4\u00a8", 0, 2);
        x2s("[^[^a-z\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6]&&[^bcdefg\u00a4\u00a6\u00a4\u00a8\u00a4\u015e]g-w]", "f", 0, 1);
        x2s("[^[^a-z\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6]&&[^bcdefg\u00a4\u00a6\u00a4\u00a8\u00a4\u015e]g-w]", "g", 0, 1);
        ns("[^[^a-z\u00a4\u02d8\u00a4\u00a4\u00a4\u00a6]&&[^bcdefg\u00a4\u00a6\u00a4\u00a8\u00a4\u015e]g-w]", "2");
        x2s("a<b>\u0104\u0110\u02c7\u013d\u0104\u00b8\u0104\u00e7\u0104\u00f3\u00a4\u00ce\u0104\u0154\u0104\u00a6\u0104\u00f3\u0104\u00ed\u02c7\u013d\u0104\u00c9<\\/b>", "a<b>\u0104\u0110\u02c7\u013d\u0104\u00b8\u0104\u00e7\u0104\u00f3\u00a4\u00ce\u0104\u0154\u0104\u00a6\u0104\u00f3\u0104\u00ed\u02c7\u013d\u0104\u00c9</b>", 0, 32);
        x2s(".<b>\u0104\u0110\u02c7\u013d\u0104\u00b8\u0104\u00e7\u0104\u00f3\u00a4\u00ce\u0104\u0154\u0104\u00a6\u0104\u00f3\u0104\u00ed\u02c7\u013d\u0104\u00c9<\\/b>", "a<b>\u0104\u0110\u02c7\u013d\u0104\u00b8\u0104\u00e7\u0104\u00f3\u00a4\u00ce\u0104\u0154\u0104\u00a6\u0104\u00f3\u0104\u00ed\u02c7\u013d\u0104\u00c9</b>", 0, 32);
    }

    public static void main(String[] args) throws Throwable{
        new TestC().run();
    }
}
