/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.ha.farm.test;

import java.io.File;
import java.io.Reader;
import java.io.FileReader;
import java.io.FileOutputStream;

import org.jboss.logging.Logger;

import junit.framework.TestCase;

/**
 * Units tests of the Farm service.
 *
 * @author Scott Marlow <smarlow@novell.com>
 * @author Brian Stansberry
 */
public class ClusterFileTransferTestCase extends TestCase
{
   private static final Logger log = Logger.getLogger(ClusterFileTransferTestCase.class);
   
   // NODExSERVERSTR properties are defined in the testsuite/build.xml
   private static String NODE0SERVERSTR = System.getProperty( "jbosstest.cluster.node0.serverroot" );
   private static String NODE1SERVERSTR = System.getProperty( "jbosstest.cluster.node1.serverroot" );
   
   private static final File NODE0SERVERFOLDER = new File(NODE0SERVERSTR);
   private static final File NODE0FARMFOLDER = new File(NODE0SERVERFOLDER, "farm");
   private static final File NODE1SERVERFOLDER = new File(NODE1SERVERSTR);
   private static final File NODE1FARMFOLDER = new File(NODE1SERVERFOLDER, "farm");

   // Processing file /home/smarlow/apps/CrimePortalBeans.jar
   int [] fileAsBunchaIntValues = {80,75,3,4,10,0,0,0,0,0,241,74,213,48,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,77,69,84,65,45,73,78,70,47,80,75,3,4,20,0,8,0,8,0,240,74,213,48,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,77,69,84,65,45,73,78,70,47,77,65,78,73,70,69,83,84,46,77,70,243,77,204,203,76,75,45,46,209,13,75,45,42,206,204,207,179,82,48,212,51,224,229,114,204,67,18,113,44,72,76,206,72,85,0,138,1,37,77,245,140,21,120,185,156,139,82,19,75,82,83,116,157,42,65,26,76,244,140,116,147,140,44,20,52,130,75,243,20,124,51,147,139,242,139,43,139,75,82,115,139,21,60,243,146,245,52,121,185,120,185,0,80,75,7,8,64,231,109,35,92,0,0,0,104,0,0,0,80,75,3,4,10,0,0,0,0,0,188,82,212,48,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,99,114,105,109,101,112,111,114,116,97,108,47,80,75,3,4,10,0,0,0,0,0,188,82,212,48,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,99,114,105,109,101,112,111,114,116,97,108,47,98,101,97,110,115,47,80,75,3,4,10,0,0,0,0,0,188,82,212,48,0,0,0,0,0,0,0,0,0,0,0,0,27,0,0,0,99,114,105,109,101,112,111,114,116,97,108,47,98,101,97,110,115,47,102,97,105,108,111,118,101,114,47,80,75,3,4,10,0,0,0,0,0,188,82,212,48,0,0,0,0,0,0,0,0,0,0,0,0,42,0,0,0,99,114,105,109,101,112,111,114,116,97,108,47,98,101,97,110,115,47,102,97,105,108,111,118,101,114,47,105,109,112,108,101,109,101,110,116,97,116,105,111,110,47,80,75,3,4,10,0,0,0,0,0,188,82,212,48,0,0,0,0,0,0,0,0,0,0,0,0,38,0,0,0,99,114,105,109,101,112,111,114,116,97,108,47,98,101,97,110,115,47,102,97,105,108,111,118,101,114,47,105,110,116,101,114,102,97,99,101,115,47,80,75,3,4,20,0,8,0,8,0,241,74,213,48,0,0,0,0,0,0,0,0,0,0,0,0,63,0,0,0,99,114,105,109,101,112,111,114,116,97,108,47,98,101,97,110,115,47,102,97,105,108,111,118,101,114,47,105,109,112,108,101,109,101,110,116,97,116,105,111,110,47,71,97,110,103,68,105,115,112,117,116,101,66,101,97,110,46,99,108,97,115,115,157,84,105,111,211,64,16,125,155,166,117,18,76,122,64,203,93,194,157,163,212,220,87,185,218,0,133,170,2,68,81,37,62,110,194,54,184,36,118,228,108,74,249,81,124,0,65,145,64,226,7,240,163,16,111,109,227,38,105,17,18,138,236,221,157,157,121,243,230,205,56,63,127,125,251,1,96,22,75,57,140,97,38,139,81,156,207,242,232,88,184,144,67,26,51,25,92,52,235,37,243,186,108,94,87,114,184,138,107,25,92,207,224,70,6,55,77,196,45,11,115,22,110,91,184,35,96,213,125,79,171,77,45,112,120,121,93,110,200,77,71,173,215,156,21,213,233,184,190,87,141,238,230,4,108,25,4,170,163,213,235,197,238,251,142,128,88,18,24,185,237,122,174,190,43,48,84,44,173,10,164,171,254,107,37,48,186,236,122,234,105,183,85,83,193,75,89,107,210,50,177,236,215,101,115,85,6,174,57,199,198,180,126,227,18,103,110,185,30,184,45,213,246,3,45,155,78,77,73,175,227,172,73,183,233,111,168,192,113,91,237,166,106,41,79,75,77,46,206,162,244,26,15,220,78,187,171,213,2,29,73,106,212,83,239,12,159,249,152,27,97,139,75,37,82,203,241,34,50,50,199,120,67,233,167,181,249,62,254,164,76,183,44,75,173,6,74,106,18,202,61,220,172,171,182,73,212,177,112,55,186,123,161,90,36,34,176,135,251,249,186,118,55,66,79,155,167,231,146,250,68,199,241,142,210,253,114,9,28,43,254,93,75,163,85,110,197,239,6,117,245,200,53,82,236,31,40,108,214,132,218,152,194,1,27,251,49,105,225,158,141,251,152,23,152,50,23,78,147,222,206,138,14,92,175,177,208,93,91,83,129,192,228,75,159,242,21,254,180,168,208,96,141,183,10,54,22,80,53,175,7,54,30,226,145,133,69,27,143,241,68,160,208,147,112,54,145,160,80,44,148,10,108,84,211,232,56,61,224,18,41,81,220,118,56,183,224,251,111,171,50,208,33,227,29,18,36,158,54,38,176,79,224,230,127,183,89,96,108,187,236,103,181,117,85,167,190,147,59,212,141,92,15,109,219,163,162,146,166,246,193,172,188,167,76,45,78,129,223,53,96,97,175,28,215,119,158,83,84,77,105,149,108,113,186,70,100,187,173,60,214,58,19,117,179,87,249,185,210,14,83,212,12,198,29,225,12,254,253,54,163,253,200,194,198,23,119,250,209,99,223,46,116,248,157,182,205,169,201,66,38,119,163,179,138,19,252,176,199,192,121,68,138,63,170,206,191,137,148,25,32,174,25,218,57,79,124,31,228,233,6,134,184,3,114,229,175,16,229,236,23,164,62,134,190,135,140,141,171,241,79,195,198,97,238,236,200,19,71,112,148,43,39,27,211,49,74,3,195,196,1,42,229,87,159,145,58,46,9,243,9,67,223,145,126,245,21,195,19,35,91,176,202,180,111,33,179,133,236,22,115,241,240,33,73,147,15,67,199,8,60,142,179,36,107,82,77,133,169,43,113,42,179,59,78,242,252,175,65,129,197,69,73,29,250,24,66,195,253,112,35,161,241,64,15,227,225,132,241,73,218,83,97,240,253,184,238,60,121,78,236,49,156,250,107,143,72,29,101,245,211,216,203,228,219,104,249,24,237,20,159,52,45,167,249,156,73,244,188,30,147,202,26,92,155,184,131,114,158,34,228,233,30,184,108,66,238,108,2,82,9,207,124,62,14,84,85,236,9,20,73,224,185,127,7,206,236,26,88,68,41,14,92,10,7,37,150,99,175,145,163,242,5,249,65,57,46,144,251,37,202,113,185,167,71,249,164,71,249,112,208,76,143,202,97,92,229,55,80,75,7,8,88,200,183,43,60,3,0,0,160,6,0,0,80,75,3,4,20,0,8,0,8,0,188,82,212,48,0,0,0,0,0,0,0,0,0,0,0,0,55,0,0,0,99,114,105,109,101,112,111,114,116,97,108,47,98,101,97,110,115,47,102,97,105,108,111,118,101,114,47,105,110,116,101,114,102,97,99,101,115,47,71,97,110,103,68,105,115,112,117,116,101,46,99,108,97,115,115,77,143,77,78,195,48,16,133,223,180,161,134,242,211,34,54,28,161,108,106,113,4,16,165,82,22,69,130,19,56,97,90,57,74,236,200,118,74,185,26,11,14,192,161,16,147,74,69,93,140,70,239,211,123,163,121,63,191,95,223,0,230,152,42,92,40,92,42,92,17,38,142,63,150,221,103,124,8,129,99,226,119,66,54,203,239,114,194,120,177,43,185,77,214,187,168,48,33,92,111,56,173,138,131,173,143,16,134,179,189,243,205,119,161,228,103,91,51,97,186,52,110,243,100,99,219,37,158,87,102,107,8,247,101,176,13,183,62,36,83,235,130,141,139,122,109,108,237,183,28,180,117,137,195,218,148,28,245,81,80,206,244,81,93,11,210,47,69,197,101,34,220,244,104,167,185,42,244,34,127,60,208,219,189,49,52,86,191,114,227,19,255,127,61,34,16,6,50,67,233,60,200,164,23,78,68,141,68,101,178,149,144,83,156,29,19,153,113,239,197,249,31,80,75,7,8,114,234,130,39,222,0,0,0,42,1,0,0,80,75,3,4,20,0,8,0,8,0,188,82,212,48,0,0,0,0,0,0,0,0,0,0,0,0,59,0,0,0,99,114,105,109,101,112,111,114,116,97,108,47,98,101,97,110,115,47,102,97,105,108,111,118,101,114,47,105,110,116,101,114,102,97,99,101,115,47,71,97,110,103,68,105,115,112,117,116,101,72,111,109,101,46,99,108,97,115,115,149,80,187,78,3,65,12,28,135,112,11,9,143,32,81,192,31,36,77,92,81,209,1,1,20,69,66,130,47,216,91,57,209,158,238,110,79,123,155,40,223,70,193,7,240,81,8,95,144,2,45,133,139,25,207,120,108,127,126,189,127,0,152,98,100,48,52,56,49,56,37,100,46,138,77,66,184,25,79,22,46,250,74,154,16,147,45,57,23,91,183,188,180,190,12,27,137,236,235,36,113,105,157,180,252,100,235,213,131,111,155,117,146,91,194,96,182,117,210,36,31,234,214,224,204,224,92,169,183,176,142,78,30,125,169,115,47,255,200,159,67,37,211,194,110,172,198,253,59,171,51,19,70,157,157,75,165,249,37,47,196,37,194,69,71,109,89,138,156,103,243,187,31,217,213,78,22,43,207,175,82,133,36,251,37,9,215,191,242,251,221,237,251,94,70,32,244,180,14,244,77,212,39,244,113,168,40,83,148,41,111,112,164,232,88,81,15,131,111,80,75,7,8,41,67,208,147,219,0,0,0,77,1,0,0,80,75,3,4,20,0,8,0,8,0,123,130,120,48,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,77,69,84,65,45,73,78,70,47,101,106,98,45,106,97,114,46,120,109,108,157,82,201,110,194,48,16,189,243,21,174,207,141,7,144,42,209,202,4,137,69,45,85,23,36,232,161,39,100,146,1,140,18,59,242,56,85,249,251,58,64,83,34,212,30,154,131,165,204,248,45,243,198,114,240,153,103,236,3,29,105,107,250,188,35,218,156,161,73,108,170,205,166,207,167,243,215,168,215,187,185,141,58,156,145,87,38,85,153,53,216,231,123,36,62,136,91,242,106,252,58,90,188,207,38,12,119,171,104,167,28,155,189,13,159,166,35,198,35,128,121,105,216,179,78,156,165,61,121,204,233,154,77,77,34,0,198,139,49,155,24,143,174,112,154,144,61,170,15,53,68,101,136,117,69,27,96,242,194,89,139,253,246,241,173,247,197,29,192,46,128,4,149,70,36,54,135,212,167,112,210,95,118,151,109,17,254,121,240,118,42,197,7,182,195,33,177,150,141,86,149,100,92,43,73,66,170,18,136,27,218,50,69,74,156,46,124,213,25,101,101,152,195,133,92,216,90,233,204,134,204,152,71,242,18,206,111,53,241,149,7,163,114,140,239,149,217,140,53,21,165,71,9,117,181,121,121,107,67,41,16,229,88,88,231,85,38,14,30,197,183,152,208,149,251,181,74,144,196,25,221,67,64,73,56,96,155,116,14,115,235,255,65,40,225,132,188,28,37,201,20,209,159,140,121,145,97,30,98,86,85,24,231,172,213,138,143,147,31,73,154,228,167,244,35,191,47,48,158,7,52,174,203,76,66,163,220,68,120,23,132,85,226,235,246,200,6,85,109,208,73,184,232,253,172,25,26,123,14,134,46,94,68,75,66,253,114,190,0,80,75,7,8,136,247,178,11,113,1,0,0,29,3,0,0,80,75,3,4,20,0,8,0,8,0,17,114,211,48,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,77,69,84,65,45,73,78,70,47,106,98,111,115,115,46,120,109,108,205,82,193,82,194,48,16,189,247,43,98,239,105,20,46,142,19,202,8,5,71,198,17,70,202,193,19,147,182,219,18,12,73,39,73,169,126,155,7,63,201,95,48,20,168,138,227,197,147,199,125,251,222,102,223,230,189,191,190,209,254,243,70,160,45,104,195,149,236,249,23,193,185,143,64,166,42,227,178,232,249,139,120,140,47,253,126,232,209,179,104,58,140,31,103,35,180,78,148,49,104,182,24,220,221,14,61,132,144,143,9,153,12,28,70,72,20,71,104,50,152,206,231,168,27,116,8,25,221,251,13,97,101,109,121,69,72,93,215,65,35,14,148,46,200,186,3,64,50,155,145,6,90,118,151,157,192,85,126,232,121,180,65,66,39,165,32,45,232,82,115,3,56,1,38,27,16,81,3,102,183,108,83,236,106,88,39,88,178,13,132,55,76,22,17,55,101,101,129,146,22,61,210,82,81,25,55,14,178,48,214,149,35,124,214,7,70,75,193,169,146,57,47,90,188,233,149,76,91,110,221,187,251,169,17,228,172,18,118,118,68,41,57,33,124,19,239,182,199,66,177,12,39,76,48,153,2,46,149,224,233,75,232,78,113,56,202,138,5,185,118,194,90,233,167,128,239,140,231,44,5,19,140,185,54,246,122,203,184,96,137,112,107,255,58,170,117,65,78,109,184,223,195,248,95,155,124,80,149,204,30,84,194,229,159,12,98,236,76,238,91,95,194,225,50,240,35,63,148,28,210,245,1,80,75,7,8,178,77,114,2,77,1,0,0,251,2,0,0,80,75,1,2,20,3,10,0,0,0,0,0,241,74,213,48,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,16,0,237,65,0,0,0,0,77,69,84,65,45,73,78,70,47,80,75,1,2,20,3,20,0,8,0,8,0,240,74,213,48,64,231,109,35,92,0,0,0,104,0,0,0,20,0,0,0,0,0,0,0,0,0,0,0,164,129,39,0,0,0,77,69,84,65,45,73,78,70,47,77,65,78,73,70,69,83,84,46,77,70,80,75,1,2,20,3,10,0,0,0,0,0,188,82,212,48,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,16,0,237,65,197,0,0,0,99,114,105,109,101,112,111,114,116,97,108,47,80,75,1,2,20,3,10,0,0,0,0,0,188,82,212,48,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,0,0,0,0,0,0,16,0,237,65,239,0,0,0,99,114,105,109,101,112,111,114,116,97,108,47,98,101,97,110,115,47,80,75,1,2,20,3,10,0,0,0,0,0,188,82,212,48,0,0,0,0,0,0,0,0,0,0,0,0,27,0,0,0,0,0,0,0,0,0,16,0,237,65,31,1,0,0,99,114,105,109,101,112,111,114,116,97,108,47,98,101,97,110,115,47,102,97,105,108,111,118,101,114,47,80,75,1,2,20,3,10,0,0,0,0,0,188,82,212,48,0,0,0,0,0,0,0,0,0,0,0,0,42,0,0,0,0,0,0,0,0,0,16,0,237,65,88,1,0,0,99,114,105,109,101,112,111,114,116,97,108,47,98,101,97,110,115,47,102,97,105,108,111,118,101,114,47,105,109,112,108,101,109,101,110,116,97,116,105,111,110,47,80,75,1,2,20,3,10,0,0,0,0,0,188,82,212,48,0,0,0,0,0,0,0,0,0,0,0,0,38,0,0,0,0,0,0,0,0,0,16,0,237,65,160,1,0,0,99,114,105,109,101,112,111,114,116,97,108,47,98,101,97,110,115,47,102,97,105,108,111,118,101,114,47,105,110,116,101,114,102,97,99,101,115,47,80,75,1,2,20,3,20,0,8,0,8,0,241,74,213,48,88,200,183,43,60,3,0,0,160,6,0,0,63,0,0,0,0,0,0,0,0,0,0,0,164,129,228,1,0,0,99,114,105,109,101,112,111,114,116,97,108,47,98,101,97,110,115,47,102,97,105,108,111,118,101,114,47,105,109,112,108,101,109,101,110,116,97,116,105,111,110,47,71,97,110,103,68,105,115,112,117,116,101,66,101,97,110,46,99,108,97,115,115,80,75,1,2,20,3,20,0,8,0,8,0,188,82,212,48,114,234,130,39,222,0,0,0,42,1,0,0,55,0,0,0,0,0,0,0,0,0,0,0,164,129,141,5,0,0,99,114,105,109,101,112,111,114,116,97,108,47,98,101,97,110,115,47,102,97,105,108,111,118,101,114,47,105,110,116,101,114,102,97,99,101,115,47,71,97,110,103,68,105,115,112,117,116,101,46,99,108,97,115,115,80,75,1,2,20,3,20,0,8,0,8,0,188,82,212,48,41,67,208,147,219,0,0,0,77,1,0,0,59,0,0,0,0,0,0,0,0,0,0,0,164,129,208,6,0,0,99,114,105,109,101,112,111,114,116,97,108,47,98,101,97,110,115,47,102,97,105,108,111,118,101,114,47,105,110,116,101,114,102,97,99,101,115,47,71,97,110,103,68,105,115,112,117,116,101,72,111,109,101,46,99,108,97,115,115,80,75,1,2,20,3,20,0,8,0,8,0,123,130,120,48,136,247,178,11,113,1,0,0,29,3,0,0,20,0,0,0,0,0,0,0,0,0,0,0,164,129,20,8,0,0,77,69,84,65,45,73,78,70,47,101,106,98,45,106,97,114,46,120,109,108,80,75,1,2,20,3,20,0,8,0,8,0,17,114,211,48,178,77,114,2,77,1,0,0,251,2,0,0,18,0,0,0,0,0,0,0,0,0,0,0,164,129,199,9,0,0,77,69,84,65,45,73,78,70,47,106,98,111,115,115,46,120,109,108,80,75,5,6,0,0,0,0,12,0,12,0,165,3,0,0,84,11,0,0,0,0
   };


   public ClusterFileTransferTestCase(String testCaseName)
   {
      super(testCaseName);
   }

   public void setUp()
   {

   }

   public void tearDown()
   {
   }

   public void testFarmDeploy() throws Exception
   {

      File node1File = new File(NODE1FARMFOLDER,"farmtestfile.jar");
      File node0File = new File(NODE0FARMFOLDER,"farmtestfile.jar");
      log.info("node0File is " + node0File);
      log.info("node1File is " + node1File);
      if(node1File.delete() ||              // ensure target of farm deploy doesn't exist
         node0File.delete())
         Thread.sleep(3000);                // wait for app to undeploy
      // generate test file to be farm deployed (note the file cannot be deployed but should be propagated across farm)
      generateTestArchive(node0File, fileAsBunchaIntValues);

      int retry = 15;
      while (!node1File.exists() && (retry-- > 0)  ) {
         Thread.sleep(1000);
      }

      Thread.sleep(3000);                   // give the scanner time to pick up the app

      assertTrue("farm deployment test file "+node0File +" did not propagate to " + node1File,node1File.exists());
      verifyFilesAreEqual(node0File, node1File);

      // delete app
      assertTrue(node1File.delete());
      retry = 15;
      while (node0File.exists() && (retry-- > 0)  ) {
         Thread.sleep(1000);
      }
      assertFalse(node0File.exists());

      generateTestArchive(node1File, fileAsBunchaIntValues);
      retry = 15;
      while (!node0File.exists() && (retry-- > 0)  ) {
         Thread.sleep(1000);
      }
      Thread.sleep(3000);                   // give the scanner time to pick up the app
      assertTrue("farm deployment test file "+node1File +" did not propagate to " + node0File,node0File.exists());
      verifyFilesAreEqual(node0File, node1File);
   }

   public void generateTestArchive(File outputFile, int[] pattern) throws Exception
   {
      outputFile.delete();
      outputFile.createNewFile();
      FileOutputStream writer = new FileOutputStream(outputFile);
      for (int looper = 0; looper < pattern.length; looper++ )
         writer.write(pattern[looper]);
      writer.close();
   }


   public void verifyFilesAreEqual(File file1, File file2) throws Exception
   {
      assertTrue("farm deployment test file1 length ("+file1.length()+") not equal to file2 length("+file2.length()+")", file1.length() == file2.length());
      Reader reader1 = new FileReader(file1);
      Reader reader2 = new FileReader(file2);
      int val1, val2;
      while((val1 = reader1.read()) > -1)
      {
         val2 = reader2.read();
         assertTrue( "farm deployment test ("+val1+") not equal to ("+val2+")",val1 == val2);
      }
      
      reader1.close();
      reader2.close();
   }

}
