/* utils.c generated by valac 0.14.2, the Vala compiler
 * generated from utils.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <gdk/gdk.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))


extern gchar* utils_uifile;
gchar* utils_uifile = NULL;
extern gboolean utils_enabledebugmessages;
gboolean utils_enabledebugmessages = FALSE;

void utils_initdebug (void);
void utils_debugloghandler (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message);
static void _utils_debugloghandler_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
gdouble utils_max (gdouble* data, int data_length1);
gdouble utils_mean (gdouble* data, int data_length1);
gchar* utils_format_size (gdouble val);
gchar* utils_format_speed (gdouble val);
GObject* utils_get_ui (const gchar* objectid, GObject* signalhandlers, gchar** additional, int additional_length1, GtkBuilder** builder);
static gchar** _vala_array_dup27 (gchar** self, int length);
static void _vala_array_add13 (gchar*** array, int* length, int* size, gchar* value);
gboolean utils_get_settings_color (GValue* value, GVariant* variant, void* user_data);
GVariant* utils_set_settings_color (GValue* value, const GVariantType* expected_type, void* user_data);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _utils_debugloghandler_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
	utils_debugloghandler (log_domain, log_levels, message);
}


void utils_initdebug (void) {
	g_log_set_handler (NULL, G_LOG_LEVEL_DEBUG, _utils_debugloghandler_glog_func, NULL);
}


void utils_debugloghandler (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message) {
	gboolean _tmp0_;
	g_return_if_fail (message != NULL);
	_tmp0_ = utils_enabledebugmessages;
	if (_tmp0_) {
		GLogFunc _tmp1_;
		void* _tmp1__target;
		const gchar* _tmp2_;
		GLogLevelFlags _tmp3_;
		const gchar* _tmp4_;
		_tmp1_ = g_log_default_handler;
		_tmp1__target = NULL;
		_tmp2_ = log_domain;
		_tmp3_ = log_levels;
		_tmp4_ = message;
		_tmp1_ (_tmp2_, _tmp3_, _tmp4_, _tmp1__target);
	}
}


gdouble utils_max (gdouble* data, int data_length1) {
	gdouble result = 0.0;
	gdouble* _tmp0_;
	gint _tmp0__length1;
	gdouble* _tmp1_;
	gint _tmp1__length1;
	gdouble _tmp2_;
	gdouble _result_;
	gdouble* _tmp3_;
	gint _tmp3__length1;
	_tmp0_ = data;
	_tmp0__length1 = data_length1;
	if (_tmp0__length1 == 0) {
		result = (gdouble) 0;
		return result;
	}
	_tmp1_ = data;
	_tmp1__length1 = data_length1;
	_tmp2_ = _tmp1_[0];
	_result_ = _tmp2_;
	_tmp3_ = data;
	_tmp3__length1 = data_length1;
	{
		gdouble* v_collection = NULL;
		gint v_collection_length1 = 0;
		gint _v_collection_size_ = 0;
		gint v_it = 0;
		v_collection = _tmp3_;
		v_collection_length1 = _tmp3__length1;
		for (v_it = 0; v_it < _tmp3__length1; v_it = v_it + 1) {
			gdouble v = 0.0;
			v = v_collection[v_it];
			{
				gdouble _tmp4_;
				gdouble _tmp5_;
				_tmp4_ = _result_;
				_tmp5_ = v;
				if (_tmp4_ < _tmp5_) {
					gdouble _tmp6_;
					_tmp6_ = v;
					_result_ = _tmp6_;
				}
			}
		}
	}
	result = _result_;
	return result;
}


gdouble utils_mean (gdouble* data, int data_length1) {
	gdouble result = 0.0;
	gdouble* _tmp0_;
	gint _tmp0__length1;
	gdouble _result_;
	gdouble* _tmp1_;
	gint _tmp1__length1;
	gdouble _tmp4_;
	gdouble* _tmp5_;
	gint _tmp5__length1;
	_tmp0_ = data;
	_tmp0__length1 = data_length1;
	if (_tmp0__length1 == 0) {
		result = (gdouble) 0;
		return result;
	}
	_result_ = (gdouble) 0;
	_tmp1_ = data;
	_tmp1__length1 = data_length1;
	{
		gdouble* v_collection = NULL;
		gint v_collection_length1 = 0;
		gint _v_collection_size_ = 0;
		gint v_it = 0;
		v_collection = _tmp1_;
		v_collection_length1 = _tmp1__length1;
		for (v_it = 0; v_it < _tmp1__length1; v_it = v_it + 1) {
			gdouble v = 0.0;
			v = v_collection[v_it];
			{
				gdouble _tmp2_;
				gdouble _tmp3_;
				_tmp2_ = _result_;
				_tmp3_ = v;
				_result_ = _tmp2_ + _tmp3_;
			}
		}
	}
	_tmp4_ = _result_;
	_tmp5_ = data;
	_tmp5__length1 = data_length1;
	result = _tmp4_ / _tmp5__length1;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch13_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch13_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally13;
	__catch13_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* utils_format_size (gdouble val) {
	gchar* result = NULL;
	static const gchar* units[] = {"{} kB", "{} MB", "{} GB"};
	gint index;
	gint _tmp9_;
	const gchar* _tmp14_ = NULL;
	gdouble _tmp15_;
	gint _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* pattern;
	const gchar* _tmp27_;
	gdouble _tmp28_;
	gchar* _tmp29_ = NULL;
	index = -1;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gint _tmp1_;
		gboolean _tmp6_;
		gdouble _tmp7_;
		gint _tmp8_;
		_tmp1_ = index;
		if ((_tmp1_ + 1) < G_N_ELEMENTS (units)) {
			gboolean _tmp2_ = FALSE;
			gdouble _tmp3_;
			gboolean _tmp5_;
			_tmp3_ = val;
			if (_tmp3_ >= ((gdouble) 1000)) {
				_tmp2_ = TRUE;
			} else {
				gint _tmp4_;
				_tmp4_ = index;
				_tmp2_ = _tmp4_ < 0;
			}
			_tmp5_ = _tmp2_;
			_tmp0_ = _tmp5_;
		} else {
			_tmp0_ = FALSE;
		}
		_tmp6_ = _tmp0_;
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = val;
		val = _tmp7_ / 1000;
		_tmp8_ = index;
		index = _tmp8_ + 1;
	}
	_tmp9_ = index;
	if (_tmp9_ < 0) {
		gdouble _tmp10_;
		const gchar* _tmp11_ = NULL;
		gdouble _tmp12_;
		gchar* _tmp13_ = NULL;
		_tmp10_ = val;
		_tmp11_ = ngettext ("%u B", "%u B", (gulong) _tmp10_);
		_tmp12_ = val;
		_tmp13_ = g_strdup_printf (_tmp11_, (guint) _tmp12_);
		result = _tmp13_;
		return result;
	}
	_tmp15_ = val;
	if (_tmp15_ < 9.95) {
		_tmp14_ = "%.1f";
	} else {
		const gchar* _tmp16_ = NULL;
		gdouble _tmp17_;
		const gchar* _tmp21_;
		_tmp17_ = val;
		if (_tmp17_ < 99.5) {
			_tmp16_ = "%.0f";
		} else {
			const gchar* _tmp18_ = NULL;
			gdouble _tmp19_;
			const gchar* _tmp20_;
			_tmp19_ = val;
			if (_tmp19_ < 999.5) {
				_tmp18_ = "%.0f";
			} else {
				_tmp18_ = "%.0f";
			}
			_tmp20_ = _tmp18_;
			_tmp16_ = _tmp20_;
		}
		_tmp21_ = _tmp16_;
		_tmp14_ = _tmp21_;
	}
	_tmp22_ = index;
	_tmp23_ = units[_tmp22_];
	_tmp24_ = _ (_tmp23_);
	_tmp25_ = _tmp14_;
	_tmp26_ = string_replace (_tmp24_, "{}", _tmp25_);
	pattern = _tmp26_;
	_tmp27_ = pattern;
	_tmp28_ = val;
	_tmp29_ = g_strdup_printf (_tmp27_, _tmp28_);
	result = _tmp29_;
	_g_free0 (pattern);
	return result;
}


gchar* utils_format_speed (gdouble val) {
	gchar* result = NULL;
	static const gchar* units[] = {"{} kB/s", "{} MB/s", "{} GB/s", "{} TB/s"};
	gint index;
	gint _tmp9_;
	const gchar* _tmp14_ = NULL;
	gdouble _tmp15_;
	gint _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* pattern;
	const gchar* _tmp27_;
	gdouble _tmp28_;
	gchar* _tmp29_ = NULL;
	index = -1;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gint _tmp1_;
		gboolean _tmp6_;
		gdouble _tmp7_;
		gint _tmp8_;
		_tmp1_ = index;
		if ((_tmp1_ + 1) < G_N_ELEMENTS (units)) {
			gboolean _tmp2_ = FALSE;
			gdouble _tmp3_;
			gboolean _tmp5_;
			_tmp3_ = val;
			if (_tmp3_ >= ((gdouble) 1000)) {
				_tmp2_ = TRUE;
			} else {
				gint _tmp4_;
				_tmp4_ = index;
				_tmp2_ = _tmp4_ < 0;
			}
			_tmp5_ = _tmp2_;
			_tmp0_ = _tmp5_;
		} else {
			_tmp0_ = FALSE;
		}
		_tmp6_ = _tmp0_;
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = val;
		val = _tmp7_ / 1000;
		_tmp8_ = index;
		index = _tmp8_ + 1;
	}
	_tmp9_ = index;
	if (_tmp9_ < 0) {
		gdouble _tmp10_;
		const gchar* _tmp11_ = NULL;
		gdouble _tmp12_;
		gchar* _tmp13_ = NULL;
		_tmp10_ = val;
		_tmp11_ = ngettext ("%u B/s", "%u B/s", (gulong) _tmp10_);
		_tmp12_ = val;
		_tmp13_ = g_strdup_printf (_tmp11_, (guint) _tmp12_);
		result = _tmp13_;
		return result;
	}
	_tmp15_ = val;
	if (_tmp15_ < 9.95) {
		_tmp14_ = "%.1f";
	} else {
		const gchar* _tmp16_ = NULL;
		gdouble _tmp17_;
		const gchar* _tmp21_;
		_tmp17_ = val;
		if (_tmp17_ < 99.5) {
			_tmp16_ = "%.0f";
		} else {
			const gchar* _tmp18_ = NULL;
			gdouble _tmp19_;
			const gchar* _tmp20_;
			_tmp19_ = val;
			if (_tmp19_ < 999.5) {
				_tmp18_ = "%.0f";
			} else {
				_tmp18_ = "%.0f";
			}
			_tmp20_ = _tmp18_;
			_tmp16_ = _tmp20_;
		}
		_tmp21_ = _tmp16_;
		_tmp14_ = _tmp21_;
	}
	_tmp22_ = index;
	_tmp23_ = units[_tmp22_];
	_tmp24_ = _ (_tmp23_);
	_tmp25_ = _tmp14_;
	_tmp26_ = string_replace (_tmp24_, "{}", _tmp25_);
	pattern = _tmp26_;
	_tmp27_ = pattern;
	_tmp28_ = val;
	_tmp29_ = g_strdup_printf (_tmp27_, _tmp28_);
	result = _tmp29_;
	_g_free0 (pattern);
	return result;
}


static gchar** _vala_array_dup27 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add13 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GObject* utils_get_ui (const gchar* objectid, GObject* signalhandlers, gchar** additional, int additional_length1, GtkBuilder** builder) {
	GtkBuilder* _vala_builder = NULL;
	GObject* result = NULL;
	GtkBuilder* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** ids;
	gint ids_length1;
	gint _ids_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GObject* _tmp13_;
	const gchar* _tmp14_;
	GObject* _tmp15_ = NULL;
	GObject* _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (objectid != NULL, NULL);
	g_return_val_if_fail (G_IS_OBJECT (signalhandlers), NULL);
	_tmp0_ = gtk_builder_new ();
	_g_object_unref0 (_vala_builder);
	_vala_builder = _tmp0_;
	_tmp1_ = additional;
	_tmp1__length1 = additional_length1;
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup27 (_tmp1_, _tmp1__length1) : ((gpointer) _tmp1_);
	_tmp2__length1 = _tmp1__length1;
	ids = _tmp2_;
	ids_length1 = _tmp2__length1;
	_ids_size_ = ids_length1;
	_tmp3_ = ids;
	_tmp3__length1 = ids_length1;
	_tmp4_ = objectid;
	_tmp5_ = g_strdup (_tmp4_);
	_vala_array_add13 (&ids, &ids_length1, &_ids_size_, _tmp5_);
	{
		const gchar* _tmp6_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		_tmp6_ = utils_uifile;
		_tmp7_ = ids;
		_tmp7__length1 = ids_length1;
		gtk_builder_add_objects_from_file (_vala_builder, _tmp6_, _tmp7_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch14_g_error;
		}
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError* e = NULL;
		FILE* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = stderr;
		_tmp9_ = objectid;
		_tmp10_ = utils_uifile;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		fprintf (_tmp8_, "Could not load indicator ui %s from %s: %s\n", _tmp9_, _tmp10_, _tmp12_);
		_g_error_free0 (e);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		ids = (_vala_array_free (ids, ids_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp13_ = signalhandlers;
	gtk_builder_connect_signals (_vala_builder, _tmp13_);
	_tmp14_ = objectid;
	_tmp15_ = gtk_builder_get_object (_vala_builder, _tmp14_);
	_tmp16_ = _g_object_ref0 (_tmp15_);
	result = _tmp16_;
	ids = (_vala_array_free (ids, ids_length1, (GDestroyNotify) g_free), NULL);
	if (builder) {
		*builder = _vala_builder;
	} else {
		_g_object_unref0 (_vala_builder);
	}
	return result;
}


gboolean utils_get_settings_color (GValue* value, GVariant* variant, void* user_data) {
	gboolean result = FALSE;
	GdkColor color = {0};
	GVariant* _tmp0_;
	const gchar* _tmp1_ = NULL;
	GdkColor _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (value != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	_tmp0_ = variant;
	_tmp1_ = g_variant_get_string (_tmp0_, NULL);
	_tmp3_ = gdk_color_parse (_tmp1_, &_tmp2_);
	color = _tmp2_;
	if (_tmp3_) {
		g_value_set_boxed (value, &color);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


GVariant* utils_set_settings_color (GValue* value, const GVariantType* expected_type, void* user_data) {
	GVariant* result = NULL;
	void* _tmp0_ = NULL;
	GdkColor color;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	g_return_val_if_fail (value != NULL, NULL);
	g_return_val_if_fail (expected_type != NULL, NULL);
	_tmp0_ = g_value_get_boxed (value);
	color = *((GdkColor*) _tmp0_);
	_tmp1_ = gdk_color_to_string (&color);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_new_string (_tmp2_);
	_tmp4_ = g_variant_ref_sink (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	result = _tmp5_;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



