/*
    ettercap -- GTK+ GUI

    Copyright (C) ALoR & NaGA

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#include <ec.h>
#include <ec_gtk3.h>

/* protos */


/* globals */

#if defined GTK_SHORTCUTS_WINDOW
static const gchar* dialog_xml = 
   "<?xml version='1.0' encoding='UTF-8'?>"
   "<interface>"
   "  <!-- interface-requires gtk+ 3.17 -->"
   "  <object class='GtkShortcutsWindow' id='setup-shortcuts'>"
   "    <property name='modal'>1</property>"
   "    <child>"
   "      <object class='GtkShortcutsSection'>"
   "        <property name='visible'>1</property>"
   "        <property name='section-name' translatable='yes'>Ettercap Shortcuts</property>"
   "        <property name='max-height'>12</property>"
   "        <child>"
   "          <object class='GtkShortcutsGroup'>"
   "            <property name='visible'>1</property>"
   "            <property name='title' translatable='yes' context='shortcut window'>General</property>"
   "            <child>"
   "              <object class='GtkShortcutsShortcut'>"
   "                <property name='visible'>1</property>"
   "                <property name='accelerator'>F1</property>"
   "                <property name='title' translatable='yes' context='shortcut window'>Help</property>"
   "              </object>"
   "            </child>"
   "            <child>"
   "              <object class='GtkShortcutsShortcut'>"
   "                <property name='visible'>1</property>"
   "                <property name='accelerator'>&lt;primary&gt;Q</property>"
   "                <property name='title' translatable='yes' context='shortcut window'>Quit</property>"
   "              </object>"
   "            </child>"
   "          </object>"
   "        </child>"
   "        <child>"
   "          <object class='GtkShortcutsGroup'>"
   "            <property name='visible'>1</property>"
   "            <property name='title' translatable='yes' context='shortcut window'>Setup</property>"
   "            <child>"
   "              <object class='GtkShortcutsShortcut'>"
   "                <property name='visible'>1</property>"
   "                <property name='accelerator'>&lt;primary&gt;o</property>"

   "                <property name='title' translatable='yes' context='shortcut window'>Open PCAP file (offline sniffing)</property>"
   "              </object>"
   "            </child>"
   "            <child>"
   "              <object class='GtkShortcutsShortcut'>"
   "                <property name='visible'>1</property>"
   "                <property name='accelerator'>&lt;primary&gt;s</property>"
   "                <property name='title' translatable='yes' context='shortcut window'>Save PCAP file</property>"
   "              </object>"
   "            </child>"
   "            <child>"
   "              <object class='GtkShortcutsShortcut'>"
   "                <property name='visible'>1</property>"
   "                <property name='accelerator'>&lt;primary&gt;P</property>"
   "                <property name='title' translatable='yes' context='shortcut window'>Set PCAP filter</property>"
   "              </object>"
   "            </child>"
   "            <child>"
   "              <object class='GtkShortcutsShortcut'>"
   "                <property name='visible'>1</property>"
   "                <property name='accelerator'>&lt;primary&gt;N</property>"
   "                <property name='title' translatable='yes' context='shortcut window'>Set netmask</property>"
   "              </object>"
   "            </child>"
   "          </object>"
   "        </child>"
   "      </object>"
   "    </child>"
   "  </object>"
   "  <object class='GtkShortcutsWindow' id='main-shortcuts'>"
   "    <property name='modal'>1</property>"
   "    <child>"
   "      <object class='GtkShortcutsSection'>"
   "        <property name='visible'>1</property>"
   "        <property name='section-name' translatable='yes'>Ettercap Shortcuts</property>"
   "        <property name='max-height'>12</property>"
   "        <child>"
   "          <object class='GtkShortcutsGroup'>"
   "            <property name='visible'>1</property>"
   "            <property name='title' translatable='yes' context='shortcut window'>General</property>"
   "            <child>"
   "              <object class='GtkShortcutsShortcut'>"
   "                <property name='visible'>1</property>"
   "                <property name='accelerator'>F1</property>"
   "                <property name='title' translatable='yes' context='shortcut window'>Help</property>"
   "              </object>"
   "            </child>"
   "            <child>"
   "              <object class='GtkShortcutsShortcut'>"
   "                <property name='visible'>1</property>"
   "                <property name='accelerator'>&lt;primary&gt;Q</property>"
   "                <property name='title' translatable='yes' context='shortcut window'>Quit</property>"
   "              </object>"
   "            </child>"
   "          </object>"
   "        </child>"
   "        <child>"
   "          <object class='GtkShortcutsGroup'>"
   "            <property name='visible'>1</property>"
   "            <property name='title' translatable='yes' context='shortcut window'>Targets</property>"
   "            <child>"
   "              <object class='GtkShortcutsShortcut'>"
   "                <property name='visible'>1</property>"
   "                <property name='accelerator'>&lt;primary&gt;t</property>"

   "                <property name='title' translatable='yes' context='shortcut window'>Show current targets</property>"
   "              </object>"
   "            </child>"
   "            <child>"
   "              <object class='GtkShortcutsShortcut'>"
   "                <property name='visible'>1</property>"
   "                <property name='accelerator'>&lt;primary&gt;&lt;shift&gt;t</property>"
   "                <property name='title' translatable='yes' context='shortcut window'>Select Targets manually</property>"
   "              </object>"
   "            </child>"
   "            <child>"
   "              <object class='GtkShortcutsShortcut'>"
   "                <property name='visible'>1</property>"
   "                <property name='accelerator'>&lt;primary&gt;P</property>"
   "                <property name='title' translatable='yes' context='shortcut window'>Select Protocol</property>"
   "              </object>"
   "            </child>"
   "            <child>"
   "              <object class='GtkShortcutsShortcut'>"
   "                <property name='visible'>1</property>"
   "                <property name='accelerator'>&lt;primary&gt;W</property>"
   "                <property name='title' translatable='yes' context='shortcut window'>Wipe all targets</property>"
   "              </object>"
   "            </child>"
   "          </object>"
   "        </child>"
   "        <child>"
   "          <object class='GtkShortcutsGroup'>"
   "            <property name='visible'>1</property>"
   "            <property name='title' translatable='yes' context='shortcut window'>Hosts</property>"
   "            <child>"
   "              <object class='GtkShortcutsShortcut'>"
   "                <property name='visible'>1</property>"
   "                <property name='accelerator'>&lt;primary&gt;h</property>"

   "                <property name='title' translatable='yes' context='shortcut window'>Hosts List</property>"
   "              </object>"
   "            </child>"
   "            <child>"
   "              <object class='GtkShortcutsShortcut'>"
   "                <property name='visible'>1</property>"
   "                <property name='accelerator'>&lt;primary&gt;s</property>"
   "                <property name='title' translatable='yes' context='shortcut window'>Scan for Hosts</property>"
   "              </object>"
   "            </child>"
   "          </object>"
   "        </child>"
   "        <child>"
   "          <object class='GtkShortcutsGroup'>"
   "            <property name='visible'>1</property>"
   "            <property name='title' translatable='yes' context='shortcut window'>View</property>"
   "            <child>"
   "              <object class='GtkShortcutsShortcut'>"
   "                <property name='visible'>1</property>"
   "                <property name='accelerator'>&lt;primary&gt;&lt;shift&gt;c</property>"

   "                <property name='title' translatable='yes' context='shortcut window'>View Connections</property>"
   "              </object>"
   "            </child>"
   "            <child>"
   "              <object class='GtkShortcutsShortcut'>"
   "                <property name='visible'>1</property>"
   "                <property name='accelerator'>&lt;primary&gt;o</property>"
   "                <property name='title' translatable='yes' context='shortcut window'>View Profiles</property>"
   "              </object>"
   "            </child>"
   "            <child>"
   "              <object class='GtkShortcutsShortcut'>"
   "                <property name='visible'>1</property>"
   "                <property name='accelerator'>&lt;primary&gt;&lt;shift&gt;v</property>"
   "                <property name='title' translatable='yes' context='shortcut window'>Set visualization method</property>"
   "              </object>"
   "            </child>"
   "            <child>"
   "              <object class='GtkShortcutsShortcut'>"
   "                <property name='visible'>1</property>"
   "                <property name='accelerator'>&lt;primary&gt;r</property>"
   "                <property name='title' translatable='yes' context='shortcut window'>Set visualization RegEx</property>"
   "              </object>"
   "            </child>"
   "          </object>"
   "        </child>"
   "        <child>"
   "          <object class='GtkShortcutsGroup'>"
   "            <property name='visible'>1</property>"
   "            <property name='title' translatable='yes' context='shortcut window'>Filters</property>"
   "            <child>"
   "              <object class='GtkShortcutsShortcut'>"
   "                <property name='visible'>1</property>"
   "                <property name='accelerator'>&lt;primary&gt;f</property>"

   "                <property name='title' translatable='yes' context='shortcut window'>Load Filter</property>"
   "              </object>"
   "            </child>"
   "            <child>"
   "              <object class='GtkShortcutsShortcut'>"
   "                <property name='visible'>1</property>"
   "                <property name='accelerator'>&lt;primary&gt;&lt;shift&gt;f</property>"
   "                <property name='title' translatable='yes' context='shortcut window'>Stop Filter</property>"
   "              </object>"
   "            </child>"
   "          </object>"
   "        </child>"
   "        <child>"
   "          <object class='GtkShortcutsGroup'>"
   "            <property name='visible'>1</property>"
   "            <property name='title' translatable='yes' context='shortcut window'>Logging</property>"
   "            <child>"
   "              <object class='GtkShortcutsShortcut'>"
   "                <property name='visible'>1</property>"
   "                <property name='accelerator'>&lt;primary&gt;&lt;shift&gt;i</property>"
   "                <property name='title' translatable='yes' context='shortcut window'>Log all packets and infos</property>"
   "              </object>"
   "            </child>"
   "            <child>"
   "              <object class='GtkShortcutsShortcut'>"
   "                <property name='visible'>1</property>"
   "                <property name='accelerator'>&lt;primary&gt;i</property>"

   "                <property name='title' translatable='yes' context='shortcut window'>Log only infos</property>"
   "              </object>"
   "            </child>"
   "            <child>"
   "              <object class='GtkShortcutsShortcut'>"
   "                <property name='visible'>1</property>"
   "                <property name='accelerator'>&lt;primary&gt;m</property>"

   "                <property name='title' translatable='yes' context='shortcut window'>Log user messages</property>"
   "              </object>"
   "            </child>"
   "          </object>"
   "        </child>"
   "        <child>"
   "          <object class='GtkShortcutsGroup'>"
   "            <property name='visible'>1</property>"
   "            <property name='title' translatable='yes' context='shortcut window'>Plugins</property>"
   "            <child>"
   "              <object class='GtkShortcutsShortcut'>"
   "                <property name='visible'>1</property>"
   "                <property name='accelerator'>&lt;primary&gt;p</property>"

   "                <property name='title' translatable='yes' context='shortcut window'>Plugins List</property>"
   "              </object>"
   "            </child>"
   "          </object>"
   "        </child>"
   "      </object>"
   "    </child>"
   "  </object>"
   "</interface>";

#else
// gtk+ < 3.17
static const gchar* dialog_xml = 
   "<interface>"
   "  <object class='GtkDialog' id='main-shortcuts'>"
   "    <property name='can_focus'>False</property>"
   "    <property name='title' translatable='yes'>Shortcuts</property>"
   "    <property name='modal'>True</property>"
   "    <property name='destroy_with_parent'>True</property>"
   "    <property name='type_hint'>dialog</property>"
   "    <child internal-child='vbox'>"
   "      <object class='GtkBox'>"
   "        <property name='can_focus'>False</property>"
   "        <property name='orientation'>vertical</property>"
   "        <property name='spacing'>2</property>"
   "        <child internal-child='action_area'>"
   "          <object class='GtkButtonBox'>"
   "            <property name='can_focus'>False</property>"
   "            <property name='layout_style'>end</property>"
   "            <child>"
   "              <placeholder/>"
   "            </child>"
   "            <child>"
   "              <placeholder/>"
   "            </child>"
   "          </object>"
   "          <packing>"
   "            <property name='expand'>False</property>"
   "            <property name='fill'>False</property>"
   "            <property name='position'>0</property>"
   "          </packing>"
   "        </child>"
   "        <child>"
   "          <object class='GtkBox'>"
   "            <property name='visible'>True</property>"
   "            <property name='can_focus'>False</property>"
   "            <child>"
   "              <object class='GtkBox'>"
   "                <property name='visible'>True</property>"
   "                <property name='can_focus'>False</property>"
   "                <property name='orientation'>vertical</property>"
   "                <child>"
   "                  <object class='GtkFrame'>"
   "                    <property name='visible'>True</property>"
   "                    <property name='can_focus'>False</property>"
   "                    <property name='border_width'>5</property>"
   "                    <property name='label_xalign'>0</property>"
   "                    <child>"
   "                      <object class='GtkAlignment'>"
   "                        <property name='visible'>True</property>"
   "                        <property name='can_focus'>False</property>"
   "                        <property name='left_padding'>12</property>"
   "                        <child>"
   "                          <object class='GtkGrid'>"
   "                            <property name='visible'>True</property>"
   "                            <property name='can_focus'>False</property>"
   "                            <property name='row_spacing'>2</property>"
   "                            <property name='column_spacing'>8</property>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>F1</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>0</property>"
   "                                <property name='top_attach'>0</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Help</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>1</property>"
   "                                <property name='top_attach'>0</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Ctrl + Q</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>0</property>"
   "                                <property name='top_attach'>1</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Quit</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>1</property>"
   "                                <property name='top_attach'>1</property>"
   "                              </packing>"
   "                            </child>"
   "                          </object>"
   "                        </child>"
   "                      </object>"
   "                    </child>"
   "                    <child type='label'>"
   "                      <object class='GtkLabel'>"
   "                        <property name='visible'>True</property>"
   "                        <property name='can_focus'>False</property>"
   "                        <property name='label' translatable='yes'>General</property>"
   "                        <attributes>"
   "                          <attribute name='weight' value='bold'/>"
   "                          <attribute name='scale' value='1'/>"
   "                        </attributes>"
   "                      </object>"
   "                    </child>"
   "                  </object>"
   "                  <packing>"
   "                    <property name='expand'>False</property>"
   "                    <property name='fill'>True</property>"
   "                    <property name='position'>0</property>"
   "                  </packing>"
   "                </child>"
   "                <child>"
   "                  <object class='GtkFrame'>"
   "                    <property name='visible'>True</property>"
   "                    <property name='can_focus'>False</property>"
   "                    <property name='border_width'>5</property>"
   "                    <property name='label_xalign'>0</property>"
   "                    <property name='shadow_type'>none</property>"
   "                    <child>"
   "                      <object class='GtkAlignment'>"
   "                        <property name='visible'>True</property>"
   "                        <property name='can_focus'>False</property>"
   "                        <property name='left_padding'>12</property>"
   "                        <child>"
   "                          <object class='GtkGrid'>"
   "                            <property name='visible'>True</property>"
   "                            <property name='can_focus'>False</property>"
   "                            <property name='row_spacing'>2</property>"
   "                            <property name='column_spacing'>8</property>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Ctrl + T</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>0</property>"
   "                                <property name='top_attach'>0</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Show current targets</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>1</property>"
   "                                <property name='top_attach'>0</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Ctrl + Shift + T</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>0</property>"
   "                                <property name='top_attach'>1</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Select targets manually</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>1</property>"
   "                                <property name='top_attach'>1</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Ctrl + P</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>0</property>"
   "                                <property name='top_attach'>2</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Set Protocol</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>1</property>"
   "                                <property name='top_attach'>2</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Ctrl + W</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>0</property>"
   "                                <property name='top_attach'>3</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Wipe all targets</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>1</property>"
   "                                <property name='top_attach'>3</property>"
   "                              </packing>"
   "                            </child>"
   "                          </object>"
   "                        </child>"
   "                      </object>"
   "                    </child>"
   "                    <child type='label'>"
   "                      <object class='GtkLabel'>"
   "                        <property name='visible'>True</property>"
   "                        <property name='can_focus'>False</property>"
   "                        <property name='label' translatable='yes'>Targets</property>"
   "                        <attributes>"
   "                          <attribute name='weight' value='bold'/>"
   "                          <attribute name='scale' value='1'/>"
   "                        </attributes>"
   "                      </object>"
   "                    </child>"
   "                  </object>"
   "                  <packing>"
   "                    <property name='expand'>False</property>"
   "                    <property name='fill'>True</property>"
   "                    <property name='position'>1</property>"
   "                  </packing>"
   "                </child>"
   "                <child>"
   "                  <object class='GtkFrame'>"
   "                    <property name='visible'>True</property>"
   "                    <property name='can_focus'>False</property>"
   "                    <property name='border_width'>5</property>"
   "                    <property name='label_xalign'>0</property>"
   "                    <property name='shadow_type'>none</property>"
   "                    <child>"
   "                      <object class='GtkAlignment'>"
   "                        <property name='visible'>True</property>"
   "                        <property name='can_focus'>False</property>"
   "                        <property name='left_padding'>12</property>"
   "                        <child>"
   "                          <object class='GtkGrid'>"
   "                            <property name='visible'>True</property>"
   "                            <property name='can_focus'>False</property>"
   "                            <property name='row_spacing'>2</property>"
   "                            <property name='column_spacing'>8</property>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Ctrl + H</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>0</property>"
   "                                <property name='top_attach'>0</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Hosts List</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>1</property>"
   "                                <property name='top_attach'>0</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Ctrl + S</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>0</property>"
   "                                <property name='top_attach'>1</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Scan for Hosts</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>1</property>"
   "                                <property name='top_attach'>1</property>"
   "                              </packing>"
   "                            </child>"
   "                          </object>"
   "                        </child>"
   "                      </object>"
   "                    </child>"
   "                    <child type='label'>"
   "                      <object class='GtkLabel'>"
   "                        <property name='visible'>True</property>"
   "                        <property name='can_focus'>False</property>"
   "                        <property name='label' translatable='yes'>Hosts</property>"
   "                        <attributes>"
   "                          <attribute name='weight' value='bold'/>"
   "                          <attribute name='scale' value='1'/>"
   "                        </attributes>"
   "                      </object>"
   "                    </child>"
   "                  </object>"
   "                  <packing>"
   "                    <property name='expand'>False</property>"
   "                    <property name='fill'>True</property>"
   "                    <property name='position'>2</property>"
   "                  </packing>"
   "                </child>"
   "                <child>"
   "                  <object class='GtkFrame'>"
   "                    <property name='visible'>True</property>"
   "                    <property name='can_focus'>False</property>"
   "                    <property name='border_width'>5</property>"
   "                    <property name='label_xalign'>0</property>"
   "                    <property name='shadow_type'>none</property>"
   "                    <child>"
   "                      <object class='GtkAlignment'>"
   "                        <property name='visible'>True</property>"
   "                        <property name='can_focus'>False</property>"
   "                        <property name='left_padding'>12</property>"
   "                        <child>"
   "                          <object class='GtkGrid'>"
   "                            <property name='visible'>True</property>"
   "                            <property name='can_focus'>False</property>"
   "                            <property name='row_spacing'>2</property>"
   "                            <property name='column_spacing'>8</property>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Ctrl + P</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>0</property>"
   "                                <property name='top_attach'>0</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Plugins List</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>1</property>"
   "                                <property name='top_attach'>0</property>"
   "                              </packing>"
   "                            </child>"
   "                          </object>"
   "                        </child>"
   "                      </object>"
   "                    </child>"
   "                    <child type='label'>"
   "                      <object class='GtkLabel'>"
   "                        <property name='visible'>True</property>"
   "                        <property name='can_focus'>False</property>"
   "                        <property name='label' translatable='yes'>Plugins</property>"
   "                        <attributes>"
   "                          <attribute name='weight' value='bold'/>"
   "                          <attribute name='scale' value='1'/>"
   "                        </attributes>"
   "                      </object>"
   "                    </child>"
   "                  </object>"
   "                  <packing>"
   "                    <property name='expand'>False</property>"
   "                    <property name='fill'>True</property>"
   "                    <property name='position'>3</property>"
   "                  </packing>"
   "                </child>"
   "              </object>"
   "              <packing>"
   "                <property name='expand'>False</property>"
   "                <property name='fill'>True</property>"
   "                <property name='position'>0</property>"
   "              </packing>"
   "            </child>"
   "            <child>"
   "              <object class='GtkBox'>"
   "                <property name='visible'>True</property>"
   "                <property name='can_focus'>False</property>"
   "                <property name='orientation'>vertical</property>"
   "                <child>"
   "                  <object class='GtkFrame'>"
   "                    <property name='visible'>True</property>"
   "                    <property name='can_focus'>False</property>"
   "                    <property name='border_width'>5</property>"
   "                    <property name='label_xalign'>0</property>"
   "                    <child>"
   "                      <object class='GtkAlignment'>"
   "                        <property name='visible'>True</property>"
   "                        <property name='can_focus'>False</property>"
   "                        <property name='left_padding'>12</property>"
   "                        <child>"
   "                          <object class='GtkGrid'>"
   "                            <property name='visible'>True</property>"
   "                            <property name='can_focus'>False</property>"
   "                            <property name='row_spacing'>2</property>"
   "                            <property name='column_spacing'>8</property>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Ctrl + Shift + C</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>0</property>"
   "                                <property name='top_attach'>0</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>View Connections</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>1</property>"
   "                                <property name='top_attach'>0</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Ctrl + O</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>0</property>"
   "                                <property name='top_attach'>1</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>View Profiles</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>1</property>"
   "                                <property name='top_attach'>1</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Ctrl + R</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>0</property>"
   "                                <property name='top_attach'>3</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Ctrl + Shift + V</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>0</property>"
   "                                <property name='top_attach'>2</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Set visualization method</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>1</property>"
   "                                <property name='top_attach'>2</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Set visualization RegEx</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>1</property>"
   "                                <property name='top_attach'>3</property>"
   "                              </packing>"
   "                            </child>"
   "                          </object>"
   "                        </child>"
   "                      </object>"
   "                    </child>"
   "                    <child type='label'>"
   "                      <object class='GtkLabel'>"
   "                        <property name='visible'>True</property>"
   "                        <property name='can_focus'>False</property>"
   "                        <property name='label' translatable='yes'>View</property>"
   "                        <attributes>"
   "                          <attribute name='weight' value='bold'/>"
   "                          <attribute name='scale' value='1'/>"
   "                        </attributes>"
   "                      </object>"
   "                    </child>"
   "                  </object>"
   "                  <packing>"
   "                    <property name='expand'>False</property>"
   "                    <property name='fill'>True</property>"
   "                    <property name='position'>0</property>"
   "                  </packing>"
   "                </child>"
   "                <child>"
   "                  <object class='GtkFrame'>"
   "                    <property name='visible'>True</property>"
   "                    <property name='can_focus'>False</property>"
   "                    <property name='border_width'>5</property>"
   "                    <property name='label_xalign'>0</property>"
   "                    <property name='shadow_type'>none</property>"
   "                    <child>"
   "                      <object class='GtkAlignment'>"
   "                        <property name='visible'>True</property>"
   "                        <property name='can_focus'>False</property>"
   "                        <property name='left_padding'>12</property>"
   "                        <child>"
   "                          <object class='GtkGrid'>"
   "                            <property name='visible'>True</property>"
   "                            <property name='can_focus'>False</property>"
   "                            <property name='row_spacing'>2</property>"
   "                            <property name='column_spacing'>8</property>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Ctrl + F</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>0</property>"
   "                                <property name='top_attach'>0</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Load Filter</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>1</property>"
   "                                <property name='top_attach'>0</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Ctrl + Shift + F</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>0</property>"
   "                                <property name='top_attach'>1</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Stop Filter</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>1</property>"
   "                                <property name='top_attach'>1</property>"
   "                              </packing>"
   "                            </child>"
   "                          </object>"
   "                        </child>"
   "                      </object>"
   "                    </child>"
   "                    <child type='label'>"
   "                      <object class='GtkLabel'>"
   "                        <property name='visible'>True</property>"
   "                        <property name='can_focus'>False</property>"
   "                        <property name='label' translatable='yes'>Filters</property>"
   "                        <attributes>"
   "                          <attribute name='weight' value='bold'/>"
   "                          <attribute name='scale' value='1'/>"
   "                        </attributes>"
   "                      </object>"
   "                    </child>"
   "                  </object>"
   "                  <packing>"
   "                    <property name='expand'>False</property>"
   "                    <property name='fill'>True</property>"
   "                    <property name='position'>1</property>"
   "                  </packing>"
   "                </child>"
   "                <child>"
   "                  <object class='GtkFrame'>"
   "                    <property name='visible'>True</property>"
   "                    <property name='can_focus'>False</property>"
   "                    <property name='border_width'>5</property>"
   "                    <property name='label_xalign'>0</property>"
   "                    <property name='shadow_type'>none</property>"
   "                    <child>"
   "                      <object class='GtkAlignment'>"
   "                        <property name='visible'>True</property>"
   "                        <property name='can_focus'>False</property>"
   "                        <property name='left_padding'>12</property>"
   "                        <child>"
   "                          <object class='GtkGrid'>"
   "                            <property name='visible'>True</property>"
   "                            <property name='can_focus'>False</property>"
   "                            <property name='row_spacing'>2</property>"
   "                            <property name='column_spacing'>8</property>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Ctrl + Shift + I</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>0</property>"
   "                                <property name='top_attach'>0</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Log all packets and infos</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>1</property>"
   "                                <property name='top_attach'>0</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Ctrl + I</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>0</property>"
   "                                <property name='top_attach'>1</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Log only infos</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>1</property>"
   "                                <property name='top_attach'>1</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Ctrl + M</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>0</property>"
   "                                <property name='top_attach'>2</property>"
   "                              </packing>"
   "                            </child>"
   "                            <child>"
   "                              <object class='GtkLabel'>"
   "                                <property name='visible'>True</property>"
   "                                <property name='can_focus'>False</property>"
   "                                <property name='halign'>start</property>"
   "                                <property name='label' translatable='yes'>Log user messages</property>"
   "                              </object>"
   "                              <packing>"
   "                                <property name='left_attach'>1</property>"
   "                                <property name='top_attach'>2</property>"
   "                              </packing>"
   "                            </child>"
   "                          </object>"
   "                        </child>"
   "                      </object>"
   "                    </child>"
   "                    <child type='label'>"
   "                      <object class='GtkLabel'>"
   "                        <property name='visible'>True</property>"
   "                        <property name='can_focus'>False</property>"
   "                        <property name='label' translatable='yes'>Logging</property>"
   "                        <attributes>"
   "                          <attribute name='weight' value='bold'/>"
   "                          <attribute name='scale' value='1'/>"
   "                        </attributes>"
   "                      </object>"
   "                    </child>"
   "                  </object>"
   "                  <packing>"
   "                    <property name='expand'>False</property>"
   "                    <property name='fill'>True</property>"
   "                    <property name='position'>2</property>"
   "                  </packing>"
   "                </child>"
   "              </object>"
   "              <packing>"
   "                <property name='expand'>False</property>"
   "                <property name='fill'>True</property>"
   "                <property name='position'>1</property>"
   "              </packing>"
   "            </child>"
   "          </object>"
   "          <packing>"
   "            <property name='expand'>False</property>"
   "            <property name='fill'>True</property>"
   "            <property name='position'>1</property>"
   "          </packing>"
   "        </child>"
   "      </object>"
   "    </child>"
   "  </object>"
   "  <object class='GtkDialog' id='setup-shortcuts'>"
   "    <property name='can_focus'>False</property>"
   "    <property name='title' translatable='yes'>Shortcuts</property>"
   "    <property name='modal'>True</property>"
   "    <property name='destroy_with_parent'>True</property>"
   "    <property name='type_hint'>dialog</property>"
   "    <child internal-child='vbox'>"
   "      <object class='GtkBox'>"
   "        <property name='can_focus'>False</property>"
   "        <property name='orientation'>vertical</property>"
   "        <property name='spacing'>2</property>"
   "        <child internal-child='action_area'>"
   "          <object class='GtkButtonBox'>"
   "            <property name='can_focus'>False</property>"
   "            <property name='layout_style'>end</property>"
   "            <child>"
   "              <placeholder/>"
   "            </child>"
   "            <child>"
   "              <placeholder/>"
   "            </child>"
   "          </object>"
   "          <packing>"
   "            <property name='expand'>False</property>"
   "            <property name='fill'>False</property>"
   "            <property name='position'>0</property>"
   "          </packing>"
   "        </child>"
   "        <child>"
   "          <object class='GtkBox'>"
   "            <property name='visible'>True</property>"
   "            <property name='can_focus'>False</property>"
   "            <property name='orientation'>vertical</property>"
   "            <child>"
   "              <object class='GtkFrame'>"
   "                <property name='visible'>True</property>"
   "                <property name='can_focus'>False</property>"
   "                <property name='border_width'>5</property>"
   "                <property name='label_xalign'>0</property>"
   "                <child>"
   "                  <object class='GtkAlignment'>"
   "                    <property name='visible'>True</property>"
   "                    <property name='can_focus'>False</property>"
   "                    <property name='left_padding'>12</property>"
   "                    <child>"
   "                      <object class='GtkGrid'>"
   "                        <property name='visible'>True</property>"
   "                        <property name='can_focus'>False</property>"
   "                        <property name='row_spacing'>2</property>"
   "                        <property name='column_spacing'>8</property>"
   "                        <child>"
   "                          <object class='GtkLabel'>"
   "                            <property name='visible'>True</property>"
   "                            <property name='can_focus'>False</property>"
   "                            <property name='halign'>start</property>"
   "                            <property name='label' translatable='yes'>F1</property>"
   "                          </object>"
   "                          <packing>"
   "                            <property name='left_attach'>0</property>"
   "                            <property name='top_attach'>0</property>"
   "                          </packing>"
   "                        </child>"
   "                        <child>"
   "                          <object class='GtkLabel'>"
   "                            <property name='visible'>True</property>"
   "                            <property name='can_focus'>False</property>"
   "                            <property name='halign'>start</property>"
   "                            <property name='label' translatable='yes'>Help</property>"
   "                          </object>"
   "                          <packing>"
   "                            <property name='left_attach'>1</property>"
   "                            <property name='top_attach'>0</property>"
   "                          </packing>"
   "                        </child>"
   "                        <child>"
   "                          <object class='GtkLabel'>"
   "                            <property name='visible'>True</property>"
   "                            <property name='can_focus'>False</property>"
   "                            <property name='halign'>start</property>"
   "                            <property name='label' translatable='yes'>Ctrl + Q</property>"
   "                          </object>"
   "                          <packing>"
   "                            <property name='left_attach'>0</property>"
   "                            <property name='top_attach'>1</property>"
   "                          </packing>"
   "                        </child>"
   "                        <child>"
   "                          <object class='GtkLabel'>"
   "                            <property name='visible'>True</property>"
   "                            <property name='can_focus'>False</property>"
   "                            <property name='halign'>start</property>"
   "                            <property name='label' translatable='yes'>Quit</property>"
   "                          </object>"
   "                          <packing>"
   "                            <property name='left_attach'>1</property>"
   "                            <property name='top_attach'>1</property>"
   "                          </packing>"
   "                        </child>"
   "                      </object>"
   "                    </child>"
   "                  </object>"
   "                </child>"
   "                <child type='label'>"
   "                  <object class='GtkLabel'>"
   "                    <property name='visible'>True</property>"
   "                    <property name='can_focus'>False</property>"
   "                    <property name='label' translatable='yes'>General</property>"
   "                    <attributes>"
   "                      <attribute name='weight' value='bold'/>"
   "                      <attribute name='scale' value='1'/>"
   "                    </attributes>"
   "                  </object>"
   "                </child>"
   "              </object>"
   "              <packing>"
   "                <property name='expand'>False</property>"
   "                <property name='fill'>True</property>"
   "                <property name='position'>0</property>"
   "              </packing>"
   "            </child>"
   "            <child>"
   "              <object class='GtkFrame'>"
   "                <property name='visible'>True</property>"
   "                <property name='can_focus'>False</property>"
   "                <property name='border_width'>5</property>"
   "                <property name='label_xalign'>0</property>"
   "                <property name='shadow_type'>none</property>"
   "                <child>"
   "                  <object class='GtkAlignment'>"
   "                    <property name='visible'>True</property>"
   "                    <property name='can_focus'>False</property>"
   "                    <property name='left_padding'>12</property>"
   "                    <child>"
   "                      <object class='GtkGrid'>"
   "                        <property name='visible'>True</property>"
   "                        <property name='can_focus'>False</property>"
   "                        <property name='row_spacing'>2</property>"
   "                        <property name='column_spacing'>8</property>"
   "                        <child>"
   "                          <object class='GtkLabel'>"
   "                            <property name='visible'>True</property>"
   "                            <property name='can_focus'>False</property>"
   "                            <property name='halign'>start</property>"
   "                            <property name='label' translatable='yes'>Ctrl + O</property>"
   "                          </object>"
   "                          <packing>"
   "                            <property name='left_attach'>0</property>"
   "                            <property name='top_attach'>0</property>"
   "                          </packing>"
   "                        </child>"
   "                        <child>"
   "                          <object class='GtkLabel'>"
   "                            <property name='visible'>True</property>"
   "                            <property name='can_focus'>False</property>"
   "                            <property name='halign'>start</property>"
   "                            <property name='label' translatable='yes'>Open PCAP file (offline sniffing)</property>"
   "                          </object>"
   "                          <packing>"
   "                            <property name='left_attach'>1</property>"
   "                            <property name='top_attach'>0</property>"
   "                          </packing>"
   "                        </child>"
   "                        <child>"
   "                          <object class='GtkLabel'>"
   "                            <property name='visible'>True</property>"
   "                            <property name='can_focus'>False</property>"
   "                            <property name='halign'>start</property>"
   "                            <property name='label' translatable='yes'>Ctrl + S</property>"
   "                          </object>"
   "                          <packing>"
   "                            <property name='left_attach'>0</property>"
   "                            <property name='top_attach'>1</property>"
   "                          </packing>"
   "                        </child>"
   "                        <child>"
   "                          <object class='GtkLabel'>"
   "                            <property name='visible'>True</property>"
   "                            <property name='can_focus'>False</property>"
   "                            <property name='halign'>start</property>"
   "                            <property name='label' translatable='yes'>Save PCAP file</property>"
   "                          </object>"
   "                          <packing>"
   "                            <property name='left_attach'>1</property>"
   "                            <property name='top_attach'>1</property>"
   "                          </packing>"
   "                        </child>"
   "                        <child>"
   "                          <object class='GtkLabel'>"
   "                            <property name='visible'>True</property>"
   "                            <property name='can_focus'>False</property>"
   "                            <property name='halign'>start</property>"
   "                            <property name='label' translatable='yes'>Ctrl + P</property>"
   "                          </object>"
   "                          <packing>"
   "                            <property name='left_attach'>0</property>"
   "                            <property name='top_attach'>2</property>"
   "                          </packing>"
   "                        </child>"
   "                        <child>"
   "                          <object class='GtkLabel'>"
   "                            <property name='visible'>True</property>"
   "                            <property name='can_focus'>False</property>"
   "                            <property name='halign'>start</property>"
   "                            <property name='label' translatable='yes'>Set PCAP Filter</property>"
   "                          </object>"
   "                          <packing>"
   "                            <property name='left_attach'>1</property>"
   "                            <property name='top_attach'>2</property>"
   "                          </packing>"
   "                        </child>"
   "                        <child>"
   "                          <object class='GtkLabel'>"
   "                            <property name='visible'>True</property>"
   "                            <property name='can_focus'>False</property>"
   "                            <property name='halign'>start</property>"
   "                            <property name='label' translatable='yes'>Ctrl + N</property>"
   "                          </object>"
   "                          <packing>"
   "                            <property name='left_attach'>0</property>"
   "                            <property name='top_attach'>3</property>"
   "                          </packing>"
   "                        </child>"
   "                        <child>"
   "                          <object class='GtkLabel'>"
   "                            <property name='visible'>True</property>"
   "                            <property name='can_focus'>False</property>"
   "                            <property name='halign'>start</property>"
   "                            <property name='label' translatable='yes'>Set Netmask</property>"
   "                          </object>"
   "                          <packing>"
   "                            <property name='left_attach'>1</property>"
   "                            <property name='top_attach'>3</property>"
   "                          </packing>"
   "                        </child>"
   "                      </object>"
   "                    </child>"
   "                  </object>"
   "                </child>"
   "                <child type='label'>"
   "                  <object class='GtkLabel'>"
   "                    <property name='visible'>True</property>"
   "                    <property name='can_focus'>False</property>"
   "                    <property name='label' translatable='yes'>Setup</property>"
   "                    <attributes>"
   "                      <attribute name='weight' value='bold'/>"
   "                      <attribute name='scale' value='1'/>"
   "                    </attributes>"
   "                  </object>"
   "                </child>"
   "              </object>"
   "              <packing>"
   "                <property name='expand'>False</property>"
   "                <property name='fill'>True</property>"
   "                <property name='position'>1</property>"
   "              </packing>"
   "            </child>"
   "          </object>"
   "          <packing>"
   "            <property name='expand'>False</property>"
   "            <property name='fill'>True</property>"
   "            <property name='position'>1</property>"
   "          </packing>"
   "        </child>"
   "      </object>"
   "    </child>"
   "  </object>"
   "</interface>";

#endif


/***************************************************/

/*
 * Since GMenu doesn't show accelerators in the menu, it became
 * popular to introduce an dedicated window for that
 * since gtk+3.17, the library even provides an own window-type
 * for this use case
 */
void gtkui_show_shortcuts(GSimpleAction *action, GVariant *value, gpointer data)
{
   GtkWidget *shortcut_window;
   GtkBuilder *builder;

   (void) action;
   (void) data;

   builder = gtk_builder_new();
   gtk_builder_add_from_string(builder, dialog_xml, -1, NULL);

   shortcut_window = GTK_WIDGET(gtk_builder_get_object(builder, 
            g_variant_get_string(value, NULL)));
   gtk_window_set_transient_for(GTK_WINDOW(shortcut_window), 
         GTK_WINDOW(window));
   gtk_window_set_position(GTK_WINDOW(shortcut_window), 
         GTK_WIN_POS_CENTER_ON_PARENT);

   gtk_widget_show_all(shortcut_window);

   g_object_unref(builder);
}

/* EOF */

// vim:ts=3:expandtab

