# ESOREX_SET_PREFIX(PREFIX)
#---------------------------
AC_DEFUN([ESOREX_SET_PREFIX],
[
    unset CDPATH
    # make $PIPE_HOME the default for the installation
    AC_PREFIX_DEFAULT($1)

    if test "x$prefix" = "xNONE"; then
        prefix=$ac_default_prefix
        ac_configure_args="$ac_configure_args --prefix $prefix"
    fi

    if test "x$exec_prefix" = "xNONE"; then
        exec_prefix=$prefix
    fi

])


# ESOREX_SET_PATHS
#------------------
# Define auxiliary directories of the installed directory tree.
AC_DEFUN([ESOREX_SET_PATHS],
[

   if test -z "$apidocdir"; then
        apidocdir='${datadir}/doc/${PACKAGE}/html'
    fi
    AC_SUBST(apidocdir)

    if test -z "$configdir"; then
       configdir='${datadir}/${PACKAGE}/config'
    fi
    AC_SUBST(configdir)

    if test -z "$recipedir"; then
	    recipedir="`eval echo $libdir`"
	fi
	AC_SUBST(recipedir)

])


# ESOREX_FUNC_GETOPT
#--------------------
# Checks for GNU getopt_long declaration and function.
AC_DEFUN([ESOREX_FUNC_GETOPT],
[

    AH_TEMPLATE([HAVE_GETOPT_LONG_ONLY],
                [Define if you have the `getopt_long_only' function])

    ESO_CHECK_FUNC(getopt_long_only, [#include <getopt.h>],
                   HAVE_GETOPT_LONG_ONLY)

    if test x"$ac_cv_func_getopt_long_only" = xno ||
       test x"$eso_cv_have_decl_getopt_long_only" = xno; then
        if test -n "$LIBTOOL"; then
            GETOPT="getopt.lo getopt1.lo"
        else
            GETOPT="getopt.$ac_objext getopt1.$ac_objext"
        fi
    fi

    AC_SUBST(GETOPT)

])
