This page collects links to all prebuilt Elvish binaries. The URLs follow the
same pattern of `https://dl.elv.sh/{os}-{arch}/elvish-{version}.{ext}`, where
`{ext}` is `.zip` for Windows and `.tar.gz` for all other OSes.

These binaries are also available on the
<a href="https://mirrors.tuna.tsinghua.edu.cn/elvish/" target="_blank">TUNA
mirror site</a>.

# Current versions

<table class="extra-wide">
  <tr>
    <th>Version</th>
    <th>amd64</th>
    <th>386</th>
    <th>arm64</th>
  </tr>
  <tr>
    <td>HEAD (<a href="https://github.com/elves/elvish/blob/master/0.21.0-release-notes.md">draft release notes</a>)</td>
    <td>
      @dl Linux linux-amd64/elvish-HEAD.tar.gz
      @dl macOS darwin-amd64/elvish-HEAD.tar.gz
      @dl FreeBSD freebsd-amd64/elvish-HEAD.tar.gz
      @dl NetBSD netbsd-amd64/elvish-HEAD.tar.gz
      @dl OpenBSD openbsd-amd64/elvish-HEAD.tar.gz
      @dl Windows windows-amd64/elvish-HEAD.zip
    </td>
    <td>
      @dl Linux linux-386/elvish-HEAD.tar.gz
      @dl Windows windows-386/elvish-HEAD.zip
    </td>
    <td>
      @dl Linux linux-arm64/elvish-HEAD.tar.gz
      @dl macOS darwin-arm64/elvish-HEAD.tar.gz
    </td>
  </tr>
  <tr>
    <td>
      0.20.1 (<a href="../blog/0.20.1-release-notes.html">release notes</a>)
    </td>
    <td>
      @dl Linux linux-amd64/elvish-v0.20.1.tar.gz
      @dl macOS darwin-amd64/elvish-v0.20.1.tar.gz
      @dl FreeBSD freebsd-amd64/elvish-v0.20.1.tar.gz
      @dl NetBSD netbsd-amd64/elvish-v0.20.1.tar.gz
      @dl OpenBSD openbsd-amd64/elvish-v0.20.1.tar.gz
      @dl Windows windows-amd64/elvish-v0.20.1.zip
    </td>
    <td>
      @dl Linux linux-386/elvish-v0.20.1.tar.gz
      @dl Windows windows-386/elvish-v0.20.1.zip
    </td>
    <td>
      @dl Linux linux-arm64/elvish-v0.20.1.tar.gz
      @dl macOS darwin-arm64/elvish-v0.20.1.tar.gz
    </td>
  </tr>
</table>

# Old versions

The following old versions are no longer supported. They are only listed here
for historical interest.

<table class="extra-wide">
  <tr>
    <th>Version</th>
    <th>amd64</th>
    <th>386</th>
    <th>arm64</th>
  </tr>
  <tr>
    <td>
      0.20.0 (<a href="../blog/0.20.0-release-notes.html">release notes</a>)
    </td>
    <td>
      @dl Linux linux-amd64/elvish-v0.20.0.tar.gz
      @dl macOS darwin-amd64/elvish-v0.20.0.tar.gz
      @dl FreeBSD freebsd-amd64/elvish-v0.20.0.tar.gz
      @dl NetBSD netbsd-amd64/elvish-v0.20.0.tar.gz
      @dl OpenBSD openbsd-amd64/elvish-v0.20.0.tar.gz
      @dl Windows windows-amd64/elvish-v0.20.0.zip
    </td>
    <td>
      @dl Linux linux-386/elvish-v0.20.0.tar.gz
      @dl Windows windows-386/elvish-v0.20.0.zip
    </td>
    <td>
      @dl Linux linux-arm64/elvish-v0.20.0.tar.gz
      @dl macOS darwin-arm64/elvish-v0.20.0.tar.gz
    </td>
  </tr>
  <tr>
    <td>
      0.19.2 (<a href="../blog/0.19.1-release-notes.html">release notes</a>)
    </td>
    <td>
      @dl Linux linux-amd64/elvish-v0.19.2.tar.gz
      @dl macOS darwin-amd64/elvish-v0.19.2.tar.gz
      @dl FreeBSD freebsd-amd64/elvish-v0.19.2.tar.gz
      @dl NetBSD netbsd-amd64/elvish-v0.19.2.tar.gz
      @dl OpenBSD openbsd-amd64/elvish-v0.19.2.tar.gz
      @dl Windows windows-amd64/elvish-v0.19.2.zip
    </td>
    <td>
      @dl Linux linux-386/elvish-v0.19.2.tar.gz
      @dl Windows windows-386/elvish-v0.19.2.zip
    </td>
    <td>
      @dl Linux linux-arm64/elvish-v0.19.2.tar.gz
      @dl macOS darwin-arm64/elvish-v0.19.2.tar.gz
    </td>
  </tr>
  <tr>
    <td>
      0.19.1 (<a href="../blog/0.19.1-release-notes.html">release notes</a>)
    </td>
    <td>
      @dl Linux linux-amd64/elvish-v0.19.1.tar.gz
      @dl macOS darwin-amd64/elvish-v0.19.1.tar.gz
      @dl FreeBSD freebsd-amd64/elvish-v0.19.1.tar.gz
      @dl NetBSD netbsd-amd64/elvish-v0.19.1.tar.gz
      @dl OpenBSD openbsd-amd64/elvish-v0.19.1.tar.gz
      @dl Windows windows-amd64/elvish-v0.19.1.zip
    </td>
    <td>
      @dl Linux linux-386/elvish-v0.19.1.tar.gz
      @dl Windows windows-386/elvish-v0.19.1.zip
    </td>
    <td>
      @dl Linux linux-arm64/elvish-v0.19.1.tar.gz
      @dl macOS darwin-arm64/elvish-v0.19.1.tar.gz
    </td>
  </tr>
  <tr>
    <td>
      0.18.0 (<a href="../blog/0.18.0-release-notes.html">release notes</a>)
    </td>
    <td>
      @dl Linux linux-amd64/elvish-v0.18.0.tar.gz
      @dl macOS darwin-amd64/elvish-v0.18.0.tar.gz
      @dl FreeBSD freebsd-amd64/elvish-v0.18.0.tar.gz
      @dl NetBSD netbsd-amd64/elvish-v0.18.0.tar.gz
      @dl OpenBSD openbsd-amd64/elvish-v0.18.0.tar.gz
      @dl Windows windows-amd64/elvish-v0.18.0.zip
    </td>
    <td>
      @dl Linux linux-386/elvish-v0.18.0.tar.gz
      @dl Windows windows-386/elvish-v0.18.0.zip
    </td>
    <td>
      @dl Linux linux-arm64/elvish-v0.18.0.tar.gz
      @dl macOS darwin-arm64/elvish-v0.18.0.tar.gz
    </td>
  </tr>
  <tr>
    <td>
      0.17.0 (<a href="../blog/0.17.0-release-notes.html">release notes</a>)
    </td>
    <td>
      @dl Linux linux-amd64/elvish-v0.17.0.tar.gz
      @dl macOS darwin-amd64/elvish-v0.17.0.tar.gz
      @dl FreeBSD freebsd-amd64/elvish-v0.17.0.tar.gz
      @dl NetBSD netbsd-amd64/elvish-v0.17.0.tar.gz
      @dl OpenBSD openbsd-amd64/elvish-v0.17.0.tar.gz
      @dl Windows windows-amd64/elvish-v0.17.0.zip
    </td>
    <td>
      @dl Linux linux-386/elvish-v0.17.0.tar.gz
      @dl Windows windows-386/elvish-v0.17.0.zip
    </td>
    <td>
      @dl Linux linux-arm64/elvish-v0.17.0.tar.gz
      @dl macOS darwin-arm64/elvish-v0.17.0.tar.gz
    </td>
  </tr>
  <tr>
    <td>
      0.16.3 (<a href="../blog/0.16.0-release-notes.html">release notes</a>)
    </td>
    <td>
      @dl Linux linux-amd64/elvish-v0.16.3.tar.gz
      @dl macOS darwin-amd64/elvish-v0.16.3.tar.gz
      @dl FreeBSD freebsd-amd64/elvish-v0.16.3.tar.gz
      @dl NetBSD netbsd-amd64/elvish-v0.16.3.tar.gz
      @dl OpenBSD openbsd-amd64/elvish-v0.16.3.tar.gz
      @dl Windows windows-amd64/elvish-v0.16.3.zip
    </td>
    <td>
      @dl Linux linux-386/elvish-v0.16.3.tar.gz
      @dl Windows windows-386/elvish-v0.16.3.zip
    </td>
    <td>
      @dl Linux linux-arm64/elvish-v0.16.3.tar.gz
      @dl macOS darwin-arm64/elvish-v0.16.3.tar.gz
    </td>
  </tr>
  <tr>
    <td>
      0.16.2 (<a href="../blog/0.16.0-release-notes.html">release notes</a>)
    </td>
    <td>
      @dl Linux linux-amd64/elvish-v0.16.2.tar.gz
      @dl macOS darwin-amd64/elvish-v0.16.2.tar.gz
      @dl FreeBSD freebsd-amd64/elvish-v0.16.2.tar.gz
      @dl NetBSD netbsd-amd64/elvish-v0.16.2.tar.gz
      @dl OpenBSD openbsd-amd64/elvish-v0.16.2.tar.gz
      @dl Windows windows-amd64/elvish-v0.16.2.zip
    </td>
    <td>
      @dl Linux linux-386/elvish-v0.16.2.tar.gz
      @dl Windows windows-386/elvish-v0.16.2.zip
    </td>
    <td>
      @dl Linux linux-arm64/elvish-v0.16.2.tar.gz
      @dl macOS darwin-arm64/elvish-v0.16.2.tar.gz
    </td>
  </tr>
  <tr>
    <td>
      0.16.1 (<a href="../blog/0.16.0-release-notes.html">release notes</a>)
    </td>
    <td>
      @dl Linux linux-amd64/elvish-v0.16.1.tar.gz
      @dl macOS darwin-amd64/elvish-v0.16.1.tar.gz
      @dl FreeBSD freebsd-amd64/elvish-v0.16.1.tar.gz
      @dl NetBSD netbsd-amd64/elvish-v0.16.1.tar.gz
      @dl OpenBSD openbsd-amd64/elvish-v0.16.1.tar.gz
      @dl Windows windows-amd64/elvish-v0.16.1.zip
    </td>
    <td>
      @dl Linux linux-386/elvish-v0.16.1.tar.gz
      @dl Windows windows-386/elvish-v0.16.1.zip
    </td>
    <td>
      @dl Linux linux-arm64/elvish-v0.16.1.tar.gz
      @dl macOS darwin-arm64/elvish-v0.16.1.tar.gz
    </td>
  </tr>
  <tr>
    <td>
      0.16.0 (<a href="../blog/0.16.0-release-notes.html">release notes</a>)
    </td>
    <td>
      @dl Linux linux-amd64/elvish-v0.16.0.tar.gz
      @dl macOS darwin-amd64/elvish-v0.16.0.tar.gz
      @dl FreeBSD freebsd-amd64/elvish-v0.16.0.tar.gz
      @dl NetBSD netbsd-amd64/elvish-v0.16.0.tar.gz
      @dl OpenBSD openbsd-amd64/elvish-v0.16.0.tar.gz
      @dl Windows windows-amd64/elvish-v0.16.0.zip
    </td>
    <td>
      @dl Linux linux-386/elvish-v0.16.0.tar.gz
      @dl Windows windows-386/elvish-v0.16.0.zip
    </td>
    <td>
      @dl Linux linux-arm64/elvish-v0.16.0.tar.gz
      @dl macOS darwin-arm64/elvish-v0.16.0.tar.gz
    </td>
  </tr>
  <tr>
    <td>
      0.15.0 (<a href="../blog/0.15.0-release-notes.html">release notes</a>)
    </td>
    <td>
      @dl Linux linux-amd64/elvish-v0.15.0.tar.gz
      @dl macOS darwin-amd64/elvish-v0.15.0.tar.gz
      @dl FreeBSD freebsd-amd64/elvish-v0.15.0.tar.gz
      @dl NetBSD netbsd-amd64/elvish-v0.15.0.tar.gz
      @dl OpenBSD openbsd-amd64/elvish-v0.15.0.tar.gz
      @dl Windows windows-amd64/elvish-v0.15.0.zip
    </td>
    <td>
      @dl Linux linux-386/elvish-v0.15.0.tar.gz
      @dl Windows windows-386/elvish-v0.15.0.zip
    </td>
    <td>
      @dl Linux linux-arm64/elvish-v0.15.0.tar.gz
    </td>
  </tr>
  <tr>
    <td>
      0.14.1 (<a href="../blog/0.14.1-release-notes.html">release notes</a>)
    </td>
    <td>
      @dl Linux linux-amd64/elvish-v0.14.1.tar.gz
      @dl macOS darwin-amd64/elvish-v0.14.1.tar.gz
      @dl FreeBSD freebsd-amd64/elvish-v0.14.1.tar.gz
      @dl NetBSD netbsd-amd64/elvish-v0.14.1.tar.gz
      @dl OpenBSD openbsd-amd64/elvish-v0.14.1.tar.gz
      @dl Windows windows-amd64/elvish-v0.14.1.zip
    </td>
    <td>
      @dl Linux linux-386/elvish-v0.14.1.tar.gz
      @dl Windows windows-386/elvish-v0.14.1.zip
    </td>
    <td>
      @dl Linux linux-arm64/elvish-v0.14.1.tar.gz
    </td>
  </tr>
  <tr>
    <td>
      0.14.0 (<a href="../blog/0.14.0-release-notes.html">release notes</a>)
    </td>
    <td>
      @dl Linux linux-amd64/elvish-v0.14.0.tar.gz
      @dl macOS darwin-amd64/elvish-v0.14.0.tar.gz
      @dl FreeBSD freebsd-amd64/elvish-v0.14.0.tar.gz
      @dl NetBSD netbsd-amd64/elvish-v0.14.0.tar.gz
      @dl OpenBSD openbsd-amd64/elvish-v0.14.0.tar.gz
      @dl Windows windows-amd64/elvish-v0.14.0.zip
    </td>
    <td>
      @dl Linux linux-386/elvish-v0.14.0.tar.gz
      @dl Windows windows-386/elvish-v0.14.0.zip
    </td>
    <td>
      @dl Linux linux-arm64/elvish-v0.14.0.tar.gz
    </td>
  </tr>
  <tr>
    <td>
      0.13.1 (<a href="../blog/0.13.1-release-notes.html">release notes</a>)
    </td>
    <td>
      @dl Linux linux-amd64/elvish-v0.13.1.tar.gz
      @dl macOS darwin-amd64/elvish-v0.13.1.tar.gz
      @dl FreeBSD freebsd-amd64/elvish-v0.13.1.tar.gz
      @dl NetBSD netbsd-amd64/elvish-v0.13.1.tar.gz
      @dl OpenBSD openbsd-amd64/elvish-v0.13.1.tar.gz
      @dl Windows windows-amd64/elvish-v0.13.1.zip
    </td>
    <td>
      @dl Linux linux-386/elvish-v0.13.1.tar.gz
      @dl Windows windows-386/elvish-v0.13.1.zip
    </td>
    <td>
      @dl Linux linux-arm64/elvish-v0.13.1.tar.gz
    </td>
  </tr>
  <tr>
    <td>
      0.13 (<a href="../blog/0.13-release-notes.html">release notes</a>)
    </td>
    <td>
      @dl Linux linux-amd64/elvish-v0.13.tar.gz
      @dl macOS darwin-amd64/elvish-v0.13.tar.gz
      @dl Windows windows-amd64/elvish-v0.13.zip
    </td>
    <td>
      @dl Linux linux-386/elvish-v0.13.tar.gz
      @dl Windows windows-386/elvish-v0.13.zip
    </td>
    <td>
      @dl Linux linux-arm64/elvish-v0.13.tar.gz
    </td>
  </tr>
  <tr>
    <td>
      0.12 (<a href="../blog/0.12-release-notes.html">release notes</a>)
    </td>
    <td>
      @dl Linux linux-amd64/elvish-v0.12.tar.gz
      @dl macOS darwin-amd64/elvish-v0.12.tar.gz
      @dl Windows windows-amd64/elvish-v0.12.zip
    </td>
    <td>
      @dl Linux linux-386/elvish-v0.12.tar.gz
      @dl Windows windows-386/elvish-v0.12.zip
    </td>
    <td>
      @dl Linux linux-arm64/elvish-v0.12.tar.gz
    </td>
  </tr>
  <tr>
    <td>
      0.11 (<a href="../blog/0.11-release-notes.html">release notes</a>)
    </td>
    <td>
      @dl Linux linux-amd64/elvish-v0.11.tar.gz
      @dl macOS darwin-amd64/elvish-v0.11.tar.gz
      @dl Windows windows-amd64/elvish-v0.11.zip
    </td>
    <td>
      @dl Linux linux-386/elvish-v0.11.tar.gz
      @dl Windows windows-386/elvish-v0.11.zip
    </td>
    <td>
      @dl Linux linux-arm64/elvish-v0.11.tar.gz
    </td>
  </tr>
  <tr>
    <td colspan="4" class="notice">
      Versions before 0.11 do not build on Windows
    </td>
  </tr>
  <tr>
    <td>0.10 (<a href="../blog/0.10-release-notes.html">release notes</a>)</td>
    <td>
      @dl Linux linux-amd64/elvish-v0.10.tar.gz
      @dl macOS darwin-amd64/elvish-v0.10.tar.gz
    </td>
    <td>
      @dl Linux linux-386/elvish-v0.10.tar.gz
    </td>
    <td>
      @dl Linux linux-arm64/elvish-v0.10.tar.gz
    </td>
  </tr>
  <tr>
    <td colspan="4" class="notice">
      Versions before 0.10 require cgo
    </td>
  </tr>
  <tr>
    <td>0.9 (<a href="../blog/0.9-release-notes.html">release notes</a>)</td>
    <td>
      @dl Linux linux-amd64/elvish-v0.9.tar.gz
      @dl macOS darwin-amd64/elvish-v0.9.tar.gz
    </td>
    <td>N/A</td>
    <td>N/A</td>
  </tr>
  <tr>
    <td>0.8 (<a href="https://github.com/elves/elvish/releases/tag/v0.8">release notes</a>)</td>
    <td>
      @dl Linux linux-amd64/elvish-v0.8.tar.gz
      @dl macOS darwin-amd64/elvish-v0.8.tar.gz
    </td>
    <td>N/A</td>
    <td>N/A</td>
  </tr>
  <tr>
    <td>0.7 (<a href="https://github.com/elves/elvish/releases/tag/v0.7">release notes</a>)</td>
    <td>
      @dl Linux linux-amd64/elvish-v0.7.tar.gz
      @dl macOS darwin-amd64/elvish-v0.7.tar.gz
    </td>
    <td>N/A</td>
    <td>N/A</td>
  </tr>
  <tr>
    <td>0.6 (<a href="https://github.com/elves/elvish/releases/tag/v0.6">release notes</a>)</td>
    <td>
      @dl Linux linux-amd64/elvish-v0.6.tar.gz
      @dl macOS darwin-amd64/elvish-v0.6.tar.gz
    </td>
    <td>N/A</td>
    <td>N/A</td>
  </tr>
  <tr>
    <td>0.5 (<a href="https://github.com/elves/elvish/releases/tag/v0.5">release notes</a>)</td>
    <td>
      @dl Linux linux-amd64/elvish-v0.5.tar.gz
      @dl macOS darwin-amd64/elvish-v0.5.tar.gz
    </td>
    <td>N/A</td>
    <td>N/A</td>
  </tr>
  <tr>
    <td>0.4</td>
    <td>
      @dl Linux linux-amd64/elvish-v0.4.tar.gz
      @dl macOS darwin-amd64/elvish-v0.4.tar.gz
    </td>
    <td>N/A</td>
    <td>N/A</td>
  </tr>
  <tr>
    <td colspan="4" class="notice">
      Versions before 0.4 do not use vendoring and cannot be reproduced
    </td>
  </tr>
  <tr>
    <td>0.3</td>
    <td>
      @dl Linux linux-amd64/elvish-v0.3.tar.gz
      @dl macOS darwin-amd64/elvish-v0.3.tar.gz
    </td>
    <td>N/A</td>
    <td>N/A</td>
  </tr>
  <tr>
    <td>0.2</td>
    <td>
      @dl Linux linux-amd64/elvish-v0.2.tar.gz
      @dl macOS darwin-amd64/elvish-v0.2.tar.gz
    </td>
    <td>N/A</td>
    <td>N/A</td>
  </tr>
  <tr>
    <td>0.1</td>
    <td>
      @dl Linux linux-amd64/elvish-v0.1.tar.gz
      @dl macOS darwin-amd64/elvish-v0.1.tar.gz
    </td>
    <td>N/A</td>
    <td>N/A</td>
  </tr>
</table>
