(ert-deftest elpy-rpc--process-buffer-p-should-handle-nil ()
  (elpy-testcase ()
    (should-not (elpy-rpc--process-buffer-p nil))))

(ert-deftest elpy-rpc--process-buffer-p-should-handle-dead-buffer ()
  (elpy-testcase ()
    (let ((buf (generate-new-buffer "*test*")))
      (kill-buffer buf)
      (should-not (elpy-rpc--process-buffer-p buf)))))

(ert-deftest elpy-rpc--process-buffer-p-should-handle-unrelated-buffer ()
  (elpy-testcase ()
    (let ((buf (generate-new-buffer "*test*")))
      (should-not (elpy-rpc--process-buffer-p buf))
      (should (buffer-live-p buf)))))

(ert-deftest elpy-rpc--process-buffer-p-should-identify-buffer-with-process ()
  (elpy-testcase ()
    (setq elpy-rpc--buffer-p t)
    (mletf* ((get-buffer-process
              (buf)
              (when (equal buf (current-buffer))
                'process))
             (process-live-p (proc) (eq proc 'process)))
      (should (elpy-rpc--process-buffer-p (current-buffer))))))

(ert-deftest elpy-rpc--process-buffer-p-should-kill-bad-process-and-buffer ()
  (elpy-testcase ()
    (setq elpy-rpc--buffer-p t)
    (mletf* ((get-buffer-process (buf) 'process)
             (process-live-p (proc) nil)
             (process-killed nil)
             (buffer-killed nil)
             (kill-process (proc) (setq process-killed proc))
             (kill-buffer (buf) (setq buffer-killed buf)))

      (should-not (elpy-rpc--process-buffer-p (current-buffer)))
      (should (equal process-killed 'process))
      (should (equal buffer-killed (current-buffer))))))
