/*******************************************************************************
 * Copyright (c) 2013 Tasktop Technologies and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tasktop Technologies - initial API and implementation
 *******************************************************************************/

package org.eclipse.mylyn.team.tests;

import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.team.ui.AbstractCommitTemplateVariable;

public class TestCommitTemplateVariable extends AbstractCommitTemplateVariable {

	@Override
	public String getValue(ITask task) {
		StringBuilder sb = new StringBuilder();
		for (String arg : arguments) {
			sb.append(arg);
			sb.append("-");
		}
		return sb.substring(0, sb.length() - 1);
	}

}
