#!/usr/bin/env bats

load helpers

function setup() {
  teardown_busybox
  setup_busybox
}

function teardown() {
  teardown_busybox
}

@test "runc run detached" {
  # run busybox detached
  runc run -d --console /dev/pts/ptmx test_busybox
  [ "$status" -eq 0 ]

  # check state
  wait_for_container 15 1 test_busybox

  testcontainer test_busybox running
}

@test "runc run detached ({u,g}id != 0)" {
  # replace "uid": 0 with "uid": 1000
  # and do a similar thing for gid.
  sed -i 's;"uid": 0;"uid": 1000;g' config.json
  sed -i 's;"gid": 0;"gid": 100;g' config.json

  # run busybox detached
  runc run -d --console /dev/pts/ptmx test_busybox
  [ "$status" -eq 0 ]

  # check state
  wait_for_container 15 1 test_busybox

  testcontainer test_busybox running
}

@test "runc run detached --pid-file" {
  # run busybox detached
  runc run --pid-file pid.txt -d --console /dev/pts/ptmx test_busybox
  [ "$status" -eq 0 ]

  # check state
  wait_for_container 15 1 test_busybox

  testcontainer test_busybox running

  # check pid.txt was generated
  [ -e pid.txt ]

  run cat pid.txt
  [ "$status" -eq 0 ]
  [[ ${lines[0]} == $(__runc state test_busybox | jq '.pid') ]]
}
