package diStorm3;

import java.util.HashMap;
import java.util.Map;

public class Opcodes {
	private static Map<Integer, OpcodeEnum> mOpcodes;
	
	public static OpcodeEnum lookup(int op)
	{
		return mOpcodes.get(op);
	}
	
	static {
		mOpcodes.put(0, OpcodeEnum.UNDEFINED);
		mOpcodes.put(0xb, OpcodeEnum.ADD);
		mOpcodes.put(0x10, OpcodeEnum.PUSH);
		mOpcodes.put(0x16, OpcodeEnum.POP);
		mOpcodes.put(0x1b, OpcodeEnum.OR);
		mOpcodes.put(0x1f, OpcodeEnum.ADC);
		mOpcodes.put(0x24, OpcodeEnum.SBB);
		mOpcodes.put(0x29, OpcodeEnum.AND);
		mOpcodes.put(0x2e, OpcodeEnum.DAA);
		mOpcodes.put(0x33, OpcodeEnum.SUB);
		mOpcodes.put(0x38, OpcodeEnum.DAS);
		mOpcodes.put(0x3d, OpcodeEnum.XOR);
		mOpcodes.put(0x42, OpcodeEnum.AAA);
		mOpcodes.put(0x47, OpcodeEnum.CMP);
		mOpcodes.put(0x4c, OpcodeEnum.AAS);
		mOpcodes.put(0x51, OpcodeEnum.INC);
		mOpcodes.put(0x56, OpcodeEnum.DEC);
		mOpcodes.put(0x5b, OpcodeEnum.PUSHA);
		mOpcodes.put(0x62, OpcodeEnum.POPA);
		mOpcodes.put(0x68, OpcodeEnum.BOUND);
		mOpcodes.put(0x6f, OpcodeEnum.ARPL);
		mOpcodes.put(0x75, OpcodeEnum.IMUL);
		mOpcodes.put(0x7b, OpcodeEnum.INS);
		mOpcodes.put(0x80, OpcodeEnum.OUTS);
		mOpcodes.put(0x86, OpcodeEnum.JO);
		mOpcodes.put(0x8a, OpcodeEnum.JNO);
		mOpcodes.put(0x8f, OpcodeEnum.JB);
		mOpcodes.put(0x93, OpcodeEnum.JAE);
		mOpcodes.put(0x98, OpcodeEnum.JZ);
		mOpcodes.put(0x9c, OpcodeEnum.JNZ);
		mOpcodes.put(0xa1, OpcodeEnum.JBE);
		mOpcodes.put(0xa6, OpcodeEnum.JA);
		mOpcodes.put(0xaa, OpcodeEnum.JS);
		mOpcodes.put(0xae, OpcodeEnum.JNS);
		mOpcodes.put(0xb3, OpcodeEnum.JP);
		mOpcodes.put(0xb7, OpcodeEnum.JNP);
		mOpcodes.put(0xbc, OpcodeEnum.JL);
		mOpcodes.put(0xc0, OpcodeEnum.JGE);
		mOpcodes.put(0xc5, OpcodeEnum.JLE);
		mOpcodes.put(0xca, OpcodeEnum.JG);
		mOpcodes.put(0xce, OpcodeEnum.TEST);
		mOpcodes.put(0xd4, OpcodeEnum.XCHG);
		mOpcodes.put(0xda, OpcodeEnum.MOV);
		mOpcodes.put(0xdf, OpcodeEnum.LEA);
		mOpcodes.put(0xe4, OpcodeEnum.CBW);
		mOpcodes.put(0xe9, OpcodeEnum.CWDE);
		mOpcodes.put(0xef, OpcodeEnum.CDQE);
		mOpcodes.put(0xf5, OpcodeEnum.CWD);
		mOpcodes.put(0xfa, OpcodeEnum.CDQ);
		mOpcodes.put(0xff, OpcodeEnum.CQO);
		mOpcodes.put(0x104, OpcodeEnum.CALL_FAR);
		mOpcodes.put(0x10e, OpcodeEnum.PUSHF);
		mOpcodes.put(0x115, OpcodeEnum.POPF);
		mOpcodes.put(0x11b, OpcodeEnum.SAHF);
		mOpcodes.put(0x121, OpcodeEnum.LAHF);
		mOpcodes.put(0x127, OpcodeEnum.MOVS);
		mOpcodes.put(0x12d, OpcodeEnum.CMPS);
		mOpcodes.put(0x133, OpcodeEnum.STOS);
		mOpcodes.put(0x139, OpcodeEnum.LODS);
		mOpcodes.put(0x13f, OpcodeEnum.SCAS);
		mOpcodes.put(0x145, OpcodeEnum.RET);
		mOpcodes.put(0x14a, OpcodeEnum.LES);
		mOpcodes.put(0x14f, OpcodeEnum.LDS);
		mOpcodes.put(0x154, OpcodeEnum.ENTER);
		mOpcodes.put(0x15b, OpcodeEnum.LEAVE);
		mOpcodes.put(0x162, OpcodeEnum.RETF);
		mOpcodes.put(0x168, OpcodeEnum.INT_3);
		mOpcodes.put(0x16f, OpcodeEnum.INT);
		mOpcodes.put(0x174, OpcodeEnum.INTO);
		mOpcodes.put(0x17a, OpcodeEnum.IRET);
		mOpcodes.put(0x180, OpcodeEnum.AAM);
		mOpcodes.put(0x185, OpcodeEnum.AAD);
		mOpcodes.put(0x18a, OpcodeEnum.SALC);
		mOpcodes.put(0x190, OpcodeEnum.XLAT);
		mOpcodes.put(0x196, OpcodeEnum.LOOPNZ);
		mOpcodes.put(0x19e, OpcodeEnum.LOOPZ);
		mOpcodes.put(0x1a5, OpcodeEnum.LOOP);
		mOpcodes.put(0x1ab, OpcodeEnum.JCXZ);
		mOpcodes.put(0x1b1, OpcodeEnum.JECXZ);
		mOpcodes.put(0x1b8, OpcodeEnum.JRCXZ);
		mOpcodes.put(0x1bf, OpcodeEnum.IN);
		mOpcodes.put(0x1c3, OpcodeEnum.OUT);
		mOpcodes.put(0x1c8, OpcodeEnum.CALL);
		mOpcodes.put(0x1ce, OpcodeEnum.JMP);
		mOpcodes.put(0x1d3, OpcodeEnum.JMP_FAR);
		mOpcodes.put(0x1dc, OpcodeEnum.INT1);
		mOpcodes.put(0x1e2, OpcodeEnum.HLT);
		mOpcodes.put(0x1e7, OpcodeEnum.CMC);
		mOpcodes.put(0x1ec, OpcodeEnum.CLC);
		mOpcodes.put(0x1f1, OpcodeEnum.STC);
		mOpcodes.put(0x1f6, OpcodeEnum.CLI);
		mOpcodes.put(0x1fb, OpcodeEnum.STI);
		mOpcodes.put(0x200, OpcodeEnum.CLD);
		mOpcodes.put(0x205, OpcodeEnum.STD);
		mOpcodes.put(0x20a, OpcodeEnum.LAR);
		mOpcodes.put(0x20f, OpcodeEnum.LSL);
		mOpcodes.put(0x214, OpcodeEnum.SYSCALL);
		mOpcodes.put(0x21d, OpcodeEnum.CLTS);
		mOpcodes.put(0x223, OpcodeEnum.SYSRET);
		mOpcodes.put(0x22b, OpcodeEnum.INVD);
		mOpcodes.put(0x231, OpcodeEnum.WBINVD);
		mOpcodes.put(0x239, OpcodeEnum.UD2);
		mOpcodes.put(0x23e, OpcodeEnum.FEMMS);
		mOpcodes.put(0x245, OpcodeEnum.NOP);
		mOpcodes.put(0x24a, OpcodeEnum.WRMSR);
		mOpcodes.put(0x251, OpcodeEnum.RDTSC);
		mOpcodes.put(0x258, OpcodeEnum.RDMSR);
		mOpcodes.put(0x25f, OpcodeEnum.RDPMC);
		mOpcodes.put(0x266, OpcodeEnum.SYSENTER);
		mOpcodes.put(0x270, OpcodeEnum.SYSEXIT);
		mOpcodes.put(0x279, OpcodeEnum.GETSEC);
		mOpcodes.put(0x281, OpcodeEnum.CMOVO);
		mOpcodes.put(0x288, OpcodeEnum.CMOVNO);
		mOpcodes.put(0x290, OpcodeEnum.CMOVB);
		mOpcodes.put(0x297, OpcodeEnum.CMOVAE);
		mOpcodes.put(0x29f, OpcodeEnum.CMOVZ);
		mOpcodes.put(0x2a6, OpcodeEnum.CMOVNZ);
		mOpcodes.put(0x2ae, OpcodeEnum.CMOVBE);
		mOpcodes.put(0x2b6, OpcodeEnum.CMOVA);
		mOpcodes.put(0x2bd, OpcodeEnum.CMOVS);
		mOpcodes.put(0x2c4, OpcodeEnum.CMOVNS);
		mOpcodes.put(0x2cc, OpcodeEnum.CMOVP);
		mOpcodes.put(0x2d3, OpcodeEnum.CMOVNP);
		mOpcodes.put(0x2db, OpcodeEnum.CMOVL);
		mOpcodes.put(0x2e2, OpcodeEnum.CMOVGE);
		mOpcodes.put(0x2ea, OpcodeEnum.CMOVLE);
		mOpcodes.put(0x2f2, OpcodeEnum.CMOVG);
		mOpcodes.put(0x2f9, OpcodeEnum.SETO);
		mOpcodes.put(0x2ff, OpcodeEnum.SETNO);
		mOpcodes.put(0x306, OpcodeEnum.SETB);
		mOpcodes.put(0x30c, OpcodeEnum.SETAE);
		mOpcodes.put(0x313, OpcodeEnum.SETZ);
		mOpcodes.put(0x319, OpcodeEnum.SETNZ);
		mOpcodes.put(0x320, OpcodeEnum.SETBE);
		mOpcodes.put(0x327, OpcodeEnum.SETA);
		mOpcodes.put(0x32d, OpcodeEnum.SETS);
		mOpcodes.put(0x333, OpcodeEnum.SETNS);
		mOpcodes.put(0x33a, OpcodeEnum.SETP);
		mOpcodes.put(0x340, OpcodeEnum.SETNP);
		mOpcodes.put(0x347, OpcodeEnum.SETL);
		mOpcodes.put(0x34d, OpcodeEnum.SETGE);
		mOpcodes.put(0x354, OpcodeEnum.SETLE);
		mOpcodes.put(0x35b, OpcodeEnum.SETG);
		mOpcodes.put(0x361, OpcodeEnum.CPUID);
		mOpcodes.put(0x368, OpcodeEnum.BT);
		mOpcodes.put(0x36c, OpcodeEnum.SHLD);
		mOpcodes.put(0x372, OpcodeEnum.RSM);
		mOpcodes.put(0x377, OpcodeEnum.BTS);
		mOpcodes.put(0x37c, OpcodeEnum.SHRD);
		mOpcodes.put(0x382, OpcodeEnum.CMPXCHG);
		mOpcodes.put(0x38b, OpcodeEnum.LSS);
		mOpcodes.put(0x390, OpcodeEnum.BTR);
		mOpcodes.put(0x395, OpcodeEnum.LFS);
		mOpcodes.put(0x39a, OpcodeEnum.LGS);
		mOpcodes.put(0x39f, OpcodeEnum.MOVZX);
		mOpcodes.put(0x3a6, OpcodeEnum.BTC);
		mOpcodes.put(0x3ab, OpcodeEnum.MOVSX);
		mOpcodes.put(0x3b2, OpcodeEnum.XADD);
		mOpcodes.put(0x3b8, OpcodeEnum.MOVNTI);
		mOpcodes.put(0x3c0, OpcodeEnum.BSWAP);
		mOpcodes.put(0x3c7, OpcodeEnum.ROL);
		mOpcodes.put(0x3cc, OpcodeEnum.ROR);
		mOpcodes.put(0x3d1, OpcodeEnum.RCL);
		mOpcodes.put(0x3d6, OpcodeEnum.RCR);
		mOpcodes.put(0x3db, OpcodeEnum.SHL);
		mOpcodes.put(0x3e0, OpcodeEnum.SHR);
		mOpcodes.put(0x3e5, OpcodeEnum.SAL);
		mOpcodes.put(0x3ea, OpcodeEnum.SAR);
		mOpcodes.put(0x3ef, OpcodeEnum.XABORT);
		mOpcodes.put(0x3f7, OpcodeEnum.XBEGIN);
		mOpcodes.put(0x3ff, OpcodeEnum.FADD);
		mOpcodes.put(0x405, OpcodeEnum.FMUL);
		mOpcodes.put(0x40b, OpcodeEnum.FCOM);
		mOpcodes.put(0x411, OpcodeEnum.FCOMP);
		mOpcodes.put(0x418, OpcodeEnum.FSUB);
		mOpcodes.put(0x41e, OpcodeEnum.FSUBR);
		mOpcodes.put(0x425, OpcodeEnum.FDIV);
		mOpcodes.put(0x42b, OpcodeEnum.FDIVR);
		mOpcodes.put(0x432, OpcodeEnum.FLD);
		mOpcodes.put(0x437, OpcodeEnum.FST);
		mOpcodes.put(0x43c, OpcodeEnum.FSTP);
		mOpcodes.put(0x442, OpcodeEnum.FLDENV);
		mOpcodes.put(0x44a, OpcodeEnum.FLDCW);
		mOpcodes.put(0x451, OpcodeEnum.FXCH);
		mOpcodes.put(0x457, OpcodeEnum.FNOP);
		mOpcodes.put(0x45d, OpcodeEnum.FCHS);
		mOpcodes.put(0x463, OpcodeEnum.FABS);
		mOpcodes.put(0x469, OpcodeEnum.FTST);
		mOpcodes.put(0x46f, OpcodeEnum.FXAM);
		mOpcodes.put(0x475, OpcodeEnum.FLD1);
		mOpcodes.put(0x47b, OpcodeEnum.FLDL2T);
		mOpcodes.put(0x483, OpcodeEnum.FLDL2E);
		mOpcodes.put(0x48b, OpcodeEnum.FLDPI);
		mOpcodes.put(0x492, OpcodeEnum.FLDLG2);
		mOpcodes.put(0x49a, OpcodeEnum.FLDLN2);
		mOpcodes.put(0x4a2, OpcodeEnum.FLDZ);
		mOpcodes.put(0x4a8, OpcodeEnum.F2XM1);
		mOpcodes.put(0x4af, OpcodeEnum.FYL2X);
		mOpcodes.put(0x4b6, OpcodeEnum.FPTAN);
		mOpcodes.put(0x4bd, OpcodeEnum.FPATAN);
		mOpcodes.put(0x4c5, OpcodeEnum.FXTRACT);
		mOpcodes.put(0x4ce, OpcodeEnum.FPREM1);
		mOpcodes.put(0x4d6, OpcodeEnum.FDECSTP);
		mOpcodes.put(0x4df, OpcodeEnum.FINCSTP);
		mOpcodes.put(0x4e8, OpcodeEnum.FPREM);
		mOpcodes.put(0x4ef, OpcodeEnum.FYL2XP1);
		mOpcodes.put(0x4f8, OpcodeEnum.FSQRT);
		mOpcodes.put(0x4ff, OpcodeEnum.FSINCOS);
		mOpcodes.put(0x508, OpcodeEnum.FRNDINT);
		mOpcodes.put(0x511, OpcodeEnum.FSCALE);
		mOpcodes.put(0x519, OpcodeEnum.FSIN);
		mOpcodes.put(0x51f, OpcodeEnum.FCOS);
		mOpcodes.put(0x525, OpcodeEnum.FIADD);
		mOpcodes.put(0x52c, OpcodeEnum.FIMUL);
		mOpcodes.put(0x533, OpcodeEnum.FICOM);
		mOpcodes.put(0x53a, OpcodeEnum.FICOMP);
		mOpcodes.put(0x542, OpcodeEnum.FISUB);
		mOpcodes.put(0x549, OpcodeEnum.FISUBR);
		mOpcodes.put(0x551, OpcodeEnum.FIDIV);
		mOpcodes.put(0x558, OpcodeEnum.FIDIVR);
		mOpcodes.put(0x560, OpcodeEnum.FCMOVB);
		mOpcodes.put(0x568, OpcodeEnum.FCMOVE);
		mOpcodes.put(0x570, OpcodeEnum.FCMOVBE);
		mOpcodes.put(0x579, OpcodeEnum.FCMOVU);
		mOpcodes.put(0x581, OpcodeEnum.FUCOMPP);
		mOpcodes.put(0x58a, OpcodeEnum.FILD);
		mOpcodes.put(0x590, OpcodeEnum.FISTTP);
		mOpcodes.put(0x598, OpcodeEnum.FIST);
		mOpcodes.put(0x59e, OpcodeEnum.FISTP);
		mOpcodes.put(0x5a5, OpcodeEnum.FCMOVNB);
		mOpcodes.put(0x5ae, OpcodeEnum.FCMOVNE);
		mOpcodes.put(0x5b7, OpcodeEnum.FCMOVNBE);
		mOpcodes.put(0x5c1, OpcodeEnum.FCMOVNU);
		mOpcodes.put(0x5ca, OpcodeEnum.FENI);
		mOpcodes.put(0x5d0, OpcodeEnum.FEDISI);
		mOpcodes.put(0x5d8, OpcodeEnum.FSETPM);
		mOpcodes.put(0x5e0, OpcodeEnum.FUCOMI);
		mOpcodes.put(0x5e8, OpcodeEnum.FCOMI);
		mOpcodes.put(0x5ef, OpcodeEnum.FRSTOR);
		mOpcodes.put(0x5f7, OpcodeEnum.FFREE);
		mOpcodes.put(0x5fe, OpcodeEnum.FUCOM);
		mOpcodes.put(0x605, OpcodeEnum.FUCOMP);
		mOpcodes.put(0x60d, OpcodeEnum.FADDP);
		mOpcodes.put(0x614, OpcodeEnum.FMULP);
		mOpcodes.put(0x61b, OpcodeEnum.FCOMPP);
		mOpcodes.put(0x623, OpcodeEnum.FSUBRP);
		mOpcodes.put(0x62b, OpcodeEnum.FSUBP);
		mOpcodes.put(0x632, OpcodeEnum.FDIVRP);
		mOpcodes.put(0x63a, OpcodeEnum.FDIVP);
		mOpcodes.put(0x641, OpcodeEnum.FBLD);
		mOpcodes.put(0x647, OpcodeEnum.FBSTP);
		mOpcodes.put(0x64e, OpcodeEnum.FUCOMIP);
		mOpcodes.put(0x657, OpcodeEnum.FCOMIP);
		mOpcodes.put(0x65f, OpcodeEnum.NOT);
		mOpcodes.put(0x664, OpcodeEnum.NEG);
		mOpcodes.put(0x669, OpcodeEnum.MUL);
		mOpcodes.put(0x66e, OpcodeEnum.DIV);
		mOpcodes.put(0x673, OpcodeEnum.IDIV);
		mOpcodes.put(0x679, OpcodeEnum.SLDT);
		mOpcodes.put(0x67f, OpcodeEnum.STR);
		mOpcodes.put(0x684, OpcodeEnum.LLDT);
		mOpcodes.put(0x68a, OpcodeEnum.LTR);
		mOpcodes.put(0x68f, OpcodeEnum.VERR);
		mOpcodes.put(0x695, OpcodeEnum.VERW);
		mOpcodes.put(0x69b, OpcodeEnum.SGDT);
		mOpcodes.put(0x6a1, OpcodeEnum.SIDT);
		mOpcodes.put(0x6a7, OpcodeEnum.LGDT);
		mOpcodes.put(0x6ad, OpcodeEnum.LIDT);
		mOpcodes.put(0x6b3, OpcodeEnum.SMSW);
		mOpcodes.put(0x6b9, OpcodeEnum.LMSW);
		mOpcodes.put(0x6bf, OpcodeEnum.INVLPG);
		mOpcodes.put(0x6c7, OpcodeEnum.VMCALL);
		mOpcodes.put(0x6cf, OpcodeEnum.VMLAUNCH);
		mOpcodes.put(0x6d9, OpcodeEnum.VMRESUME);
		mOpcodes.put(0x6e3, OpcodeEnum.VMXOFF);
		mOpcodes.put(0x6eb, OpcodeEnum.MONITOR);
		mOpcodes.put(0x6f4, OpcodeEnum.MWAIT);
		mOpcodes.put(0x6fb, OpcodeEnum.XGETBV);
		mOpcodes.put(0x703, OpcodeEnum.XSETBV);
		mOpcodes.put(0x70b, OpcodeEnum.VMFUNC);
		mOpcodes.put(0x713, OpcodeEnum.XEND);
		mOpcodes.put(0x719, OpcodeEnum.VMRUN);
		mOpcodes.put(0x720, OpcodeEnum.VMMCALL);
		mOpcodes.put(0x729, OpcodeEnum.VMLOAD);
		mOpcodes.put(0x731, OpcodeEnum.VMSAVE);
		mOpcodes.put(0x739, OpcodeEnum.STGI);
		mOpcodes.put(0x73f, OpcodeEnum.CLGI);
		mOpcodes.put(0x745, OpcodeEnum.SKINIT);
		mOpcodes.put(0x74d, OpcodeEnum.INVLPGA);
		mOpcodes.put(0x756, OpcodeEnum.SWAPGS);
		mOpcodes.put(0x75e, OpcodeEnum.RDTSCP);
		mOpcodes.put(0x766, OpcodeEnum.PREFETCH);
		mOpcodes.put(0x770, OpcodeEnum.PREFETCHW);
		mOpcodes.put(0x77b, OpcodeEnum.PI2FW);
		mOpcodes.put(0x782, OpcodeEnum.PI2FD);
		mOpcodes.put(0x789, OpcodeEnum.PF2IW);
		mOpcodes.put(0x790, OpcodeEnum.PF2ID);
		mOpcodes.put(0x797, OpcodeEnum.PFNACC);
		mOpcodes.put(0x79f, OpcodeEnum.PFPNACC);
		mOpcodes.put(0x7a8, OpcodeEnum.PFCMPGE);
		mOpcodes.put(0x7b1, OpcodeEnum.PFMIN);
		mOpcodes.put(0x7b8, OpcodeEnum.PFRCP);
		mOpcodes.put(0x7bf, OpcodeEnum.PFRSQRT);
		mOpcodes.put(0x7c8, OpcodeEnum.PFSUB);
		mOpcodes.put(0x7cf, OpcodeEnum.PFADD);
		mOpcodes.put(0x7d6, OpcodeEnum.PFCMPGT);
		mOpcodes.put(0x7df, OpcodeEnum.PFMAX);
		mOpcodes.put(0x7e6, OpcodeEnum.PFRCPIT1);
		mOpcodes.put(0x7f0, OpcodeEnum.PFRSQIT1);
		mOpcodes.put(0x7fa, OpcodeEnum.PFSUBR);
		mOpcodes.put(0x802, OpcodeEnum.PFACC);
		mOpcodes.put(0x809, OpcodeEnum.PFCMPEQ);
		mOpcodes.put(0x812, OpcodeEnum.PFMUL);
		mOpcodes.put(0x819, OpcodeEnum.PFRCPIT2);
		mOpcodes.put(0x823, OpcodeEnum.PMULHRW);
		mOpcodes.put(0x82c, OpcodeEnum.PSWAPD);
		mOpcodes.put(0x834, OpcodeEnum.PAVGUSB);
		mOpcodes.put(0x83d, OpcodeEnum.MOVUPS);
		mOpcodes.put(0x845, OpcodeEnum.MOVUPD);
		mOpcodes.put(0x84d, OpcodeEnum.MOVSS);
		mOpcodes.put(0x854, OpcodeEnum.MOVSD);
		mOpcodes.put(0x85b, OpcodeEnum.VMOVUPS);
		mOpcodes.put(0x864, OpcodeEnum.VMOVUPD);
		mOpcodes.put(0x86d, OpcodeEnum.VMOVSS);
		mOpcodes.put(0x875, OpcodeEnum.VMOVSD);
		mOpcodes.put(0x87d, OpcodeEnum.MOVHLPS);
		mOpcodes.put(0x886, OpcodeEnum.MOVLPS);
		mOpcodes.put(0x88e, OpcodeEnum.MOVLPD);
		mOpcodes.put(0x896, OpcodeEnum.MOVSLDUP);
		mOpcodes.put(0x8a0, OpcodeEnum.MOVDDUP);
		mOpcodes.put(0x8a9, OpcodeEnum.VMOVHLPS);
		mOpcodes.put(0x8b3, OpcodeEnum.VMOVLPS);
		mOpcodes.put(0x8bc, OpcodeEnum.VMOVLPD);
		mOpcodes.put(0x8c5, OpcodeEnum.VMOVSLDUP);
		mOpcodes.put(0x8d0, OpcodeEnum.VMOVDDUP);
		mOpcodes.put(0x8da, OpcodeEnum.UNPCKLPS);
		mOpcodes.put(0x8e4, OpcodeEnum.UNPCKLPD);
		mOpcodes.put(0x8ee, OpcodeEnum.VUNPCKLPS);
		mOpcodes.put(0x8f9, OpcodeEnum.VUNPCKLPD);
		mOpcodes.put(0x904, OpcodeEnum.UNPCKHPS);
		mOpcodes.put(0x90e, OpcodeEnum.UNPCKHPD);
		mOpcodes.put(0x918, OpcodeEnum.VUNPCKHPS);
		mOpcodes.put(0x923, OpcodeEnum.VUNPCKHPD);
		mOpcodes.put(0x92e, OpcodeEnum.MOVLHPS);
		mOpcodes.put(0x937, OpcodeEnum.MOVHPS);
		mOpcodes.put(0x93f, OpcodeEnum.MOVHPD);
		mOpcodes.put(0x947, OpcodeEnum.MOVSHDUP);
		mOpcodes.put(0x951, OpcodeEnum.VMOVLHPS);
		mOpcodes.put(0x95b, OpcodeEnum.VMOVHPS);
		mOpcodes.put(0x964, OpcodeEnum.VMOVHPD);
		mOpcodes.put(0x96d, OpcodeEnum.VMOVSHDUP);
		mOpcodes.put(0x978, OpcodeEnum.PREFETCHNTA);
		mOpcodes.put(0x985, OpcodeEnum.PREFETCHT0);
		mOpcodes.put(0x991, OpcodeEnum.PREFETCHT1);
		mOpcodes.put(0x99d, OpcodeEnum.PREFETCHT2);
		mOpcodes.put(0x9a9, OpcodeEnum.MOVAPS);
		mOpcodes.put(0x9b1, OpcodeEnum.MOVAPD);
		mOpcodes.put(0x9b9, OpcodeEnum.VMOVAPS);
		mOpcodes.put(0x9c2, OpcodeEnum.VMOVAPD);
		mOpcodes.put(0x9cb, OpcodeEnum.CVTPI2PS);
		mOpcodes.put(0x9d5, OpcodeEnum.CVTPI2PD);
		mOpcodes.put(0x9df, OpcodeEnum.CVTSI2SS);
		mOpcodes.put(0x9e9, OpcodeEnum.CVTSI2SD);
		mOpcodes.put(0x9f3, OpcodeEnum.VCVTSI2SS);
		mOpcodes.put(0x9fe, OpcodeEnum.VCVTSI2SD);
		mOpcodes.put(0xa09, OpcodeEnum.MOVNTPS);
		mOpcodes.put(0xa12, OpcodeEnum.MOVNTPD);
		mOpcodes.put(0xa1b, OpcodeEnum.MOVNTSS);
		mOpcodes.put(0xa24, OpcodeEnum.MOVNTSD);
		mOpcodes.put(0xa2d, OpcodeEnum.VMOVNTPS);
		mOpcodes.put(0xa37, OpcodeEnum.VMOVNTPD);
		mOpcodes.put(0xa41, OpcodeEnum.CVTTPS2PI);
		mOpcodes.put(0xa4c, OpcodeEnum.CVTTPD2PI);
		mOpcodes.put(0xa57, OpcodeEnum.CVTTSS2SI);
		mOpcodes.put(0xa62, OpcodeEnum.CVTTSD2SI);
		mOpcodes.put(0xa6d, OpcodeEnum.VCVTTSS2SI);
		mOpcodes.put(0xa79, OpcodeEnum.VCVTTSD2SI);
		mOpcodes.put(0xa85, OpcodeEnum.CVTPS2PI);
		mOpcodes.put(0xa8f, OpcodeEnum.CVTPD2PI);
		mOpcodes.put(0xa99, OpcodeEnum.CVTSS2SI);
		mOpcodes.put(0xaa3, OpcodeEnum.CVTSD2SI);
		mOpcodes.put(0xaad, OpcodeEnum.VCVTSS2SI);
		mOpcodes.put(0xab8, OpcodeEnum.VCVTSD2SI);
		mOpcodes.put(0xac3, OpcodeEnum.UCOMISS);
		mOpcodes.put(0xacc, OpcodeEnum.UCOMISD);
		mOpcodes.put(0xad5, OpcodeEnum.VUCOMISS);
		mOpcodes.put(0xadf, OpcodeEnum.VUCOMISD);
		mOpcodes.put(0xae9, OpcodeEnum.COMISS);
		mOpcodes.put(0xaf1, OpcodeEnum.COMISD);
		mOpcodes.put(0xaf9, OpcodeEnum.VCOMISS);
		mOpcodes.put(0xb02, OpcodeEnum.VCOMISD);
		mOpcodes.put(0xb0b, OpcodeEnum.MOVMSKPS);
		mOpcodes.put(0xb15, OpcodeEnum.MOVMSKPD);
		mOpcodes.put(0xb1f, OpcodeEnum.VMOVMSKPS);
		mOpcodes.put(0xb2a, OpcodeEnum.VMOVMSKPD);
		mOpcodes.put(0xb35, OpcodeEnum.SQRTPS);
		mOpcodes.put(0xb3d, OpcodeEnum.SQRTPD);
		mOpcodes.put(0xb45, OpcodeEnum.SQRTSS);
		mOpcodes.put(0xb4d, OpcodeEnum.SQRTSD);
		mOpcodes.put(0xb55, OpcodeEnum.VSQRTPS);
		mOpcodes.put(0xb5e, OpcodeEnum.VSQRTPD);
		mOpcodes.put(0xb67, OpcodeEnum.VSQRTSS);
		mOpcodes.put(0xb70, OpcodeEnum.VSQRTSD);
		mOpcodes.put(0xb79, OpcodeEnum.RSQRTPS);
		mOpcodes.put(0xb82, OpcodeEnum.RSQRTSS);
		mOpcodes.put(0xb8b, OpcodeEnum.VRSQRTPS);
		mOpcodes.put(0xb95, OpcodeEnum.VRSQRTSS);
		mOpcodes.put(0xb9f, OpcodeEnum.RCPPS);
		mOpcodes.put(0xba6, OpcodeEnum.RCPSS);
		mOpcodes.put(0xbad, OpcodeEnum.VRCPPS);
		mOpcodes.put(0xbb5, OpcodeEnum.VRCPSS);
		mOpcodes.put(0xbbd, OpcodeEnum.ANDPS);
		mOpcodes.put(0xbc4, OpcodeEnum.ANDPD);
		mOpcodes.put(0xbcb, OpcodeEnum.VANDPS);
		mOpcodes.put(0xbd3, OpcodeEnum.VANDPD);
		mOpcodes.put(0xbdb, OpcodeEnum.ANDNPS);
		mOpcodes.put(0xbe3, OpcodeEnum.ANDNPD);
		mOpcodes.put(0xbeb, OpcodeEnum.VANDNPS);
		mOpcodes.put(0xbf4, OpcodeEnum.VANDNPD);
		mOpcodes.put(0xbfd, OpcodeEnum.ORPS);
		mOpcodes.put(0xc03, OpcodeEnum.ORPD);
		mOpcodes.put(0xc09, OpcodeEnum.VORPS);
		mOpcodes.put(0xc10, OpcodeEnum.VORPD);
		mOpcodes.put(0xc17, OpcodeEnum.XORPS);
		mOpcodes.put(0xc1e, OpcodeEnum.XORPD);
		mOpcodes.put(0xc25, OpcodeEnum.VXORPS);
		mOpcodes.put(0xc2d, OpcodeEnum.VXORPD);
		mOpcodes.put(0xc35, OpcodeEnum.ADDPS);
		mOpcodes.put(0xc3c, OpcodeEnum.ADDPD);
		mOpcodes.put(0xc43, OpcodeEnum.ADDSS);
		mOpcodes.put(0xc4a, OpcodeEnum.ADDSD);
		mOpcodes.put(0xc51, OpcodeEnum.VADDPS);
		mOpcodes.put(0xc59, OpcodeEnum.VADDPD);
		mOpcodes.put(0xc61, OpcodeEnum.VADDSS);
		mOpcodes.put(0xc69, OpcodeEnum.VADDSD);
		mOpcodes.put(0xc71, OpcodeEnum.MULPS);
		mOpcodes.put(0xc78, OpcodeEnum.MULPD);
		mOpcodes.put(0xc7f, OpcodeEnum.MULSS);
		mOpcodes.put(0xc86, OpcodeEnum.MULSD);
		mOpcodes.put(0xc8d, OpcodeEnum.VMULPS);
		mOpcodes.put(0xc95, OpcodeEnum.VMULPD);
		mOpcodes.put(0xc9d, OpcodeEnum.VMULSS);
		mOpcodes.put(0xca5, OpcodeEnum.VMULSD);
		mOpcodes.put(0xcad, OpcodeEnum.CVTPS2PD);
		mOpcodes.put(0xcb7, OpcodeEnum.CVTPD2PS);
		mOpcodes.put(0xcc1, OpcodeEnum.CVTSS2SD);
		mOpcodes.put(0xccb, OpcodeEnum.CVTSD2SS);
		mOpcodes.put(0xcd5, OpcodeEnum.VCVTPS2PD);
		mOpcodes.put(0xce0, OpcodeEnum.VCVTPD2PS);
		mOpcodes.put(0xceb, OpcodeEnum.VCVTSS2SD);
		mOpcodes.put(0xcf6, OpcodeEnum.VCVTSD2SS);
		mOpcodes.put(0xd01, OpcodeEnum.CVTDQ2PS);
		mOpcodes.put(0xd0b, OpcodeEnum.CVTPS2DQ);
		mOpcodes.put(0xd15, OpcodeEnum.CVTTPS2DQ);
		mOpcodes.put(0xd20, OpcodeEnum.VCVTDQ2PS);
		mOpcodes.put(0xd2b, OpcodeEnum.VCVTPS2DQ);
		mOpcodes.put(0xd36, OpcodeEnum.VCVTTPS2DQ);
		mOpcodes.put(0xd42, OpcodeEnum.SUBPS);
		mOpcodes.put(0xd49, OpcodeEnum.SUBPD);
		mOpcodes.put(0xd50, OpcodeEnum.SUBSS);
		mOpcodes.put(0xd57, OpcodeEnum.SUBSD);
		mOpcodes.put(0xd5e, OpcodeEnum.VSUBPS);
		mOpcodes.put(0xd66, OpcodeEnum.VSUBPD);
		mOpcodes.put(0xd6e, OpcodeEnum.VSUBSS);
		mOpcodes.put(0xd76, OpcodeEnum.VSUBSD);
		mOpcodes.put(0xd7e, OpcodeEnum.MINPS);
		mOpcodes.put(0xd85, OpcodeEnum.MINPD);
		mOpcodes.put(0xd8c, OpcodeEnum.MINSS);
		mOpcodes.put(0xd93, OpcodeEnum.MINSD);
		mOpcodes.put(0xd9a, OpcodeEnum.VMINPS);
		mOpcodes.put(0xda2, OpcodeEnum.VMINPD);
		mOpcodes.put(0xdaa, OpcodeEnum.VMINSS);
		mOpcodes.put(0xdb2, OpcodeEnum.VMINSD);
		mOpcodes.put(0xdba, OpcodeEnum.DIVPS);
		mOpcodes.put(0xdc1, OpcodeEnum.DIVPD);
		mOpcodes.put(0xdc8, OpcodeEnum.DIVSS);
		mOpcodes.put(0xdcf, OpcodeEnum.DIVSD);
		mOpcodes.put(0xdd6, OpcodeEnum.VDIVPS);
		mOpcodes.put(0xdde, OpcodeEnum.VDIVPD);
		mOpcodes.put(0xde6, OpcodeEnum.VDIVSS);
		mOpcodes.put(0xdee, OpcodeEnum.VDIVSD);
		mOpcodes.put(0xdf6, OpcodeEnum.MAXPS);
		mOpcodes.put(0xdfd, OpcodeEnum.MAXPD);
		mOpcodes.put(0xe04, OpcodeEnum.MAXSS);
		mOpcodes.put(0xe0b, OpcodeEnum.MAXSD);
		mOpcodes.put(0xe12, OpcodeEnum.VMAXPS);
		mOpcodes.put(0xe1a, OpcodeEnum.VMAXPD);
		mOpcodes.put(0xe22, OpcodeEnum.VMAXSS);
		mOpcodes.put(0xe2a, OpcodeEnum.VMAXSD);
		mOpcodes.put(0xe32, OpcodeEnum.PUNPCKLBW);
		mOpcodes.put(0xe3d, OpcodeEnum.VPUNPCKLBW);
		mOpcodes.put(0xe49, OpcodeEnum.PUNPCKLWD);
		mOpcodes.put(0xe54, OpcodeEnum.VPUNPCKLWD);
		mOpcodes.put(0xe60, OpcodeEnum.PUNPCKLDQ);
		mOpcodes.put(0xe6b, OpcodeEnum.VPUNPCKLDQ);
		mOpcodes.put(0xe77, OpcodeEnum.PACKSSWB);
		mOpcodes.put(0xe81, OpcodeEnum.VPACKSSWB);
		mOpcodes.put(0xe8c, OpcodeEnum.PCMPGTB);
		mOpcodes.put(0xe95, OpcodeEnum.VPCMPGTB);
		mOpcodes.put(0xe9f, OpcodeEnum.PCMPGTW);
		mOpcodes.put(0xea8, OpcodeEnum.VPCMPGTW);
		mOpcodes.put(0xeb2, OpcodeEnum.PCMPGTD);
		mOpcodes.put(0xebb, OpcodeEnum.VPCMPGTD);
		mOpcodes.put(0xec5, OpcodeEnum.PACKUSWB);
		mOpcodes.put(0xecf, OpcodeEnum.VPACKUSWB);
		mOpcodes.put(0xeda, OpcodeEnum.PUNPCKHBW);
		mOpcodes.put(0xee5, OpcodeEnum.VPUNPCKHBW);
		mOpcodes.put(0xef1, OpcodeEnum.PUNPCKHWD);
		mOpcodes.put(0xefc, OpcodeEnum.VPUNPCKHWD);
		mOpcodes.put(0xf08, OpcodeEnum.PUNPCKHDQ);
		mOpcodes.put(0xf13, OpcodeEnum.VPUNPCKHDQ);
		mOpcodes.put(0xf1f, OpcodeEnum.PACKSSDW);
		mOpcodes.put(0xf29, OpcodeEnum.VPACKSSDW);
		mOpcodes.put(0xf34, OpcodeEnum.PUNPCKLQDQ);
		mOpcodes.put(0xf40, OpcodeEnum.VPUNPCKLQDQ);
		mOpcodes.put(0xf4d, OpcodeEnum.PUNPCKHQDQ);
		mOpcodes.put(0xf59, OpcodeEnum.VPUNPCKHQDQ);
		mOpcodes.put(0xf66, OpcodeEnum.MOVD);
		mOpcodes.put(0xf6c, OpcodeEnum.MOVQ);
		mOpcodes.put(0xf72, OpcodeEnum.VMOVD);
		mOpcodes.put(0xf79, OpcodeEnum.VMOVQ);
		mOpcodes.put(0xf80, OpcodeEnum.MOVDQA);
		mOpcodes.put(0xf88, OpcodeEnum.MOVDQU);
		mOpcodes.put(0xf90, OpcodeEnum.VMOVDQA);
		mOpcodes.put(0xf99, OpcodeEnum.VMOVDQU);
		mOpcodes.put(0xfa2, OpcodeEnum.PSHUFW);
		mOpcodes.put(0xfaa, OpcodeEnum.PSHUFD);
		mOpcodes.put(0xfb2, OpcodeEnum.PSHUFHW);
		mOpcodes.put(0xfbb, OpcodeEnum.PSHUFLW);
		mOpcodes.put(0xfc4, OpcodeEnum.VPSHUFD);
		mOpcodes.put(0xfcd, OpcodeEnum.VPSHUFHW);
		mOpcodes.put(0xfd7, OpcodeEnum.VPSHUFLW);
		mOpcodes.put(0xfe1, OpcodeEnum.PCMPEQB);
		mOpcodes.put(0xfea, OpcodeEnum.VPCMPEQB);
		mOpcodes.put(0xff4, OpcodeEnum.PCMPEQW);
		mOpcodes.put(0xffd, OpcodeEnum.VPCMPEQW);
		mOpcodes.put(0x1007, OpcodeEnum.PCMPEQD);
		mOpcodes.put(0x1010, OpcodeEnum.VPCMPEQD);
		mOpcodes.put(0x101a, OpcodeEnum.EMMS);
		mOpcodes.put(0x1020, OpcodeEnum.VZEROUPPER);
		mOpcodes.put(0x102c, OpcodeEnum.VZEROALL);
		mOpcodes.put(0x1036, OpcodeEnum.VMREAD);
		mOpcodes.put(0x103e, OpcodeEnum.EXTRQ);
		mOpcodes.put(0x1045, OpcodeEnum.INSERTQ);
		mOpcodes.put(0x104e, OpcodeEnum.VMWRITE);
		mOpcodes.put(0x1057, OpcodeEnum.CVTPH2PS);
		mOpcodes.put(0x1061, OpcodeEnum.CVTPS2PH);
		mOpcodes.put(0x106b, OpcodeEnum.HADDPD);
		mOpcodes.put(0x1073, OpcodeEnum.HADDPS);
		mOpcodes.put(0x107b, OpcodeEnum.VHADDPD);
		mOpcodes.put(0x1084, OpcodeEnum.VHADDPS);
		mOpcodes.put(0x108d, OpcodeEnum.HSUBPD);
		mOpcodes.put(0x1095, OpcodeEnum.HSUBPS);
		mOpcodes.put(0x109d, OpcodeEnum.VHSUBPD);
		mOpcodes.put(0x10a6, OpcodeEnum.VHSUBPS);
		mOpcodes.put(0x10af, OpcodeEnum.XSAVE);
		mOpcodes.put(0x10b6, OpcodeEnum.XSAVE64);
		mOpcodes.put(0x10bf, OpcodeEnum.LFENCE);
		mOpcodes.put(0x10c7, OpcodeEnum.XRSTOR);
		mOpcodes.put(0x10cf, OpcodeEnum.XRSTOR64);
		mOpcodes.put(0x10d9, OpcodeEnum.MFENCE);
		mOpcodes.put(0x10e1, OpcodeEnum.XSAVEOPT);
		mOpcodes.put(0x10eb, OpcodeEnum.XSAVEOPT64);
		mOpcodes.put(0x10f7, OpcodeEnum.SFENCE);
		mOpcodes.put(0x10ff, OpcodeEnum.CLFLUSH);
		mOpcodes.put(0x1108, OpcodeEnum.POPCNT);
		mOpcodes.put(0x1110, OpcodeEnum.BSF);
		mOpcodes.put(0x1115, OpcodeEnum.TZCNT);
		mOpcodes.put(0x111c, OpcodeEnum.BSR);
		mOpcodes.put(0x1121, OpcodeEnum.LZCNT);
		mOpcodes.put(0x1128, OpcodeEnum.CMPEQPS);
		mOpcodes.put(0x1131, OpcodeEnum.CMPLTPS);
		mOpcodes.put(0x113a, OpcodeEnum.CMPLEPS);
		mOpcodes.put(0x1143, OpcodeEnum.CMPUNORDPS);
		mOpcodes.put(0x114f, OpcodeEnum.CMPNEQPS);
		mOpcodes.put(0x1159, OpcodeEnum.CMPNLTPS);
		mOpcodes.put(0x1163, OpcodeEnum.CMPNLEPS);
		mOpcodes.put(0x116d, OpcodeEnum.CMPORDPS);
		mOpcodes.put(0x1177, OpcodeEnum.CMPEQPD);
		mOpcodes.put(0x1180, OpcodeEnum.CMPLTPD);
		mOpcodes.put(0x1189, OpcodeEnum.CMPLEPD);
		mOpcodes.put(0x1192, OpcodeEnum.CMPUNORDPD);
		mOpcodes.put(0x119e, OpcodeEnum.CMPNEQPD);
		mOpcodes.put(0x11a8, OpcodeEnum.CMPNLTPD);
		mOpcodes.put(0x11b2, OpcodeEnum.CMPNLEPD);
		mOpcodes.put(0x11bc, OpcodeEnum.CMPORDPD);
		mOpcodes.put(0x11c6, OpcodeEnum.CMPEQSS);
		mOpcodes.put(0x11cf, OpcodeEnum.CMPLTSS);
		mOpcodes.put(0x11d8, OpcodeEnum.CMPLESS);
		mOpcodes.put(0x11e1, OpcodeEnum.CMPUNORDSS);
		mOpcodes.put(0x11ed, OpcodeEnum.CMPNEQSS);
		mOpcodes.put(0x11f7, OpcodeEnum.CMPNLTSS);
		mOpcodes.put(0x1201, OpcodeEnum.CMPNLESS);
		mOpcodes.put(0x120b, OpcodeEnum.CMPORDSS);
		mOpcodes.put(0x1215, OpcodeEnum.CMPEQSD);
		mOpcodes.put(0x121e, OpcodeEnum.CMPLTSD);
		mOpcodes.put(0x1227, OpcodeEnum.CMPLESD);
		mOpcodes.put(0x1230, OpcodeEnum.CMPUNORDSD);
		mOpcodes.put(0x123c, OpcodeEnum.CMPNEQSD);
		mOpcodes.put(0x1246, OpcodeEnum.CMPNLTSD);
		mOpcodes.put(0x1250, OpcodeEnum.CMPNLESD);
		mOpcodes.put(0x125a, OpcodeEnum.CMPORDSD);
		mOpcodes.put(0x1264, OpcodeEnum.VCMPEQPS);
		mOpcodes.put(0x126e, OpcodeEnum.VCMPLTPS);
		mOpcodes.put(0x1278, OpcodeEnum.VCMPLEPS);
		mOpcodes.put(0x1282, OpcodeEnum.VCMPUNORDPS);
		mOpcodes.put(0x128f, OpcodeEnum.VCMPNEQPS);
		mOpcodes.put(0x129a, OpcodeEnum.VCMPNLTPS);
		mOpcodes.put(0x12a5, OpcodeEnum.VCMPNLEPS);
		mOpcodes.put(0x12b0, OpcodeEnum.VCMPORDPS);
		mOpcodes.put(0x12bb, OpcodeEnum.VCMPEQ_UQPS);
		mOpcodes.put(0x12c8, OpcodeEnum.VCMPNGEPS);
		mOpcodes.put(0x12d3, OpcodeEnum.VCMPNGTPS);
		mOpcodes.put(0x12de, OpcodeEnum.VCMPFALSEPS);
		mOpcodes.put(0x12eb, OpcodeEnum.VCMPNEQ_OQPS);
		mOpcodes.put(0x12f9, OpcodeEnum.VCMPGEPS);
		mOpcodes.put(0x1303, OpcodeEnum.VCMPGTPS);
		mOpcodes.put(0x130d, OpcodeEnum.VCMPTRUEPS);
		mOpcodes.put(0x1319, OpcodeEnum.VCMPEQ_OSPS);
		mOpcodes.put(0x1326, OpcodeEnum.VCMPLT_OQPS);
		mOpcodes.put(0x1333, OpcodeEnum.VCMPLE_OQPS);
		mOpcodes.put(0x1340, OpcodeEnum.VCMPUNORD_SPS);
		mOpcodes.put(0x134f, OpcodeEnum.VCMPNEQ_USPS);
		mOpcodes.put(0x135d, OpcodeEnum.VCMPNLT_UQPS);
		mOpcodes.put(0x136b, OpcodeEnum.VCMPNLE_UQPS);
		mOpcodes.put(0x1379, OpcodeEnum.VCMPORD_SPS);
		mOpcodes.put(0x1386, OpcodeEnum.VCMPEQ_USPS);
		mOpcodes.put(0x1393, OpcodeEnum.VCMPNGE_UQPS);
		mOpcodes.put(0x13a1, OpcodeEnum.VCMPNGT_UQPS);
		mOpcodes.put(0x13af, OpcodeEnum.VCMPFALSE_OSPS);
		mOpcodes.put(0x13bf, OpcodeEnum.VCMPNEQ_OSPS);
		mOpcodes.put(0x13cd, OpcodeEnum.VCMPGE_OQPS);
		mOpcodes.put(0x13da, OpcodeEnum.VCMPGT_OQPS);
		mOpcodes.put(0x13e7, OpcodeEnum.VCMPTRUE_USPS);
		mOpcodes.put(0x13f6, OpcodeEnum.VCMPEQPD);
		mOpcodes.put(0x1400, OpcodeEnum.VCMPLTPD);
		mOpcodes.put(0x140a, OpcodeEnum.VCMPLEPD);
		mOpcodes.put(0x1414, OpcodeEnum.VCMPUNORDPD);
		mOpcodes.put(0x1421, OpcodeEnum.VCMPNEQPD);
		mOpcodes.put(0x142c, OpcodeEnum.VCMPNLTPD);
		mOpcodes.put(0x1437, OpcodeEnum.VCMPNLEPD);
		mOpcodes.put(0x1442, OpcodeEnum.VCMPORDPD);
		mOpcodes.put(0x144d, OpcodeEnum.VCMPEQ_UQPD);
		mOpcodes.put(0x145a, OpcodeEnum.VCMPNGEPD);
		mOpcodes.put(0x1465, OpcodeEnum.VCMPNGTPD);
		mOpcodes.put(0x1470, OpcodeEnum.VCMPFALSEPD);
		mOpcodes.put(0x147d, OpcodeEnum.VCMPNEQ_OQPD);
		mOpcodes.put(0x148b, OpcodeEnum.VCMPGEPD);
		mOpcodes.put(0x1495, OpcodeEnum.VCMPGTPD);
		mOpcodes.put(0x149f, OpcodeEnum.VCMPTRUEPD);
		mOpcodes.put(0x14ab, OpcodeEnum.VCMPEQ_OSPD);
		mOpcodes.put(0x14b8, OpcodeEnum.VCMPLT_OQPD);
		mOpcodes.put(0x14c5, OpcodeEnum.VCMPLE_OQPD);
		mOpcodes.put(0x14d2, OpcodeEnum.VCMPUNORD_SPD);
		mOpcodes.put(0x14e1, OpcodeEnum.VCMPNEQ_USPD);
		mOpcodes.put(0x14ef, OpcodeEnum.VCMPNLT_UQPD);
		mOpcodes.put(0x14fd, OpcodeEnum.VCMPNLE_UQPD);
		mOpcodes.put(0x150b, OpcodeEnum.VCMPORD_SPD);
		mOpcodes.put(0x1518, OpcodeEnum.VCMPEQ_USPD);
		mOpcodes.put(0x1525, OpcodeEnum.VCMPNGE_UQPD);
		mOpcodes.put(0x1533, OpcodeEnum.VCMPNGT_UQPD);
		mOpcodes.put(0x1541, OpcodeEnum.VCMPFALSE_OSPD);
		mOpcodes.put(0x1551, OpcodeEnum.VCMPNEQ_OSPD);
		mOpcodes.put(0x155f, OpcodeEnum.VCMPGE_OQPD);
		mOpcodes.put(0x156c, OpcodeEnum.VCMPGT_OQPD);
		mOpcodes.put(0x1579, OpcodeEnum.VCMPTRUE_USPD);
		mOpcodes.put(0x1588, OpcodeEnum.VCMPEQSS);
		mOpcodes.put(0x1592, OpcodeEnum.VCMPLTSS);
		mOpcodes.put(0x159c, OpcodeEnum.VCMPLESS);
		mOpcodes.put(0x15a6, OpcodeEnum.VCMPUNORDSS);
		mOpcodes.put(0x15b3, OpcodeEnum.VCMPNEQSS);
		mOpcodes.put(0x15be, OpcodeEnum.VCMPNLTSS);
		mOpcodes.put(0x15c9, OpcodeEnum.VCMPNLESS);
		mOpcodes.put(0x15d4, OpcodeEnum.VCMPORDSS);
		mOpcodes.put(0x15df, OpcodeEnum.VCMPEQ_UQSS);
		mOpcodes.put(0x15ec, OpcodeEnum.VCMPNGESS);
		mOpcodes.put(0x15f7, OpcodeEnum.VCMPNGTSS);
		mOpcodes.put(0x1602, OpcodeEnum.VCMPFALSESS);
		mOpcodes.put(0x160f, OpcodeEnum.VCMPNEQ_OQSS);
		mOpcodes.put(0x161d, OpcodeEnum.VCMPGESS);
		mOpcodes.put(0x1627, OpcodeEnum.VCMPGTSS);
		mOpcodes.put(0x1631, OpcodeEnum.VCMPTRUESS);
		mOpcodes.put(0x163d, OpcodeEnum.VCMPEQ_OSSS);
		mOpcodes.put(0x164a, OpcodeEnum.VCMPLT_OQSS);
		mOpcodes.put(0x1657, OpcodeEnum.VCMPLE_OQSS);
		mOpcodes.put(0x1664, OpcodeEnum.VCMPUNORD_SSS);
		mOpcodes.put(0x1673, OpcodeEnum.VCMPNEQ_USSS);
		mOpcodes.put(0x1681, OpcodeEnum.VCMPNLT_UQSS);
		mOpcodes.put(0x168f, OpcodeEnum.VCMPNLE_UQSS);
		mOpcodes.put(0x169d, OpcodeEnum.VCMPORD_SSS);
		mOpcodes.put(0x16aa, OpcodeEnum.VCMPEQ_USSS);
		mOpcodes.put(0x16b7, OpcodeEnum.VCMPNGE_UQSS);
		mOpcodes.put(0x16c5, OpcodeEnum.VCMPNGT_UQSS);
		mOpcodes.put(0x16d3, OpcodeEnum.VCMPFALSE_OSSS);
		mOpcodes.put(0x16e3, OpcodeEnum.VCMPNEQ_OSSS);
		mOpcodes.put(0x16f1, OpcodeEnum.VCMPGE_OQSS);
		mOpcodes.put(0x16fe, OpcodeEnum.VCMPGT_OQSS);
		mOpcodes.put(0x170b, OpcodeEnum.VCMPTRUE_USSS);
		mOpcodes.put(0x171a, OpcodeEnum.VCMPEQSD);
		mOpcodes.put(0x1724, OpcodeEnum.VCMPLTSD);
		mOpcodes.put(0x172e, OpcodeEnum.VCMPLESD);
		mOpcodes.put(0x1738, OpcodeEnum.VCMPUNORDSD);
		mOpcodes.put(0x1745, OpcodeEnum.VCMPNEQSD);
		mOpcodes.put(0x1750, OpcodeEnum.VCMPNLTSD);
		mOpcodes.put(0x175b, OpcodeEnum.VCMPNLESD);
		mOpcodes.put(0x1766, OpcodeEnum.VCMPORDSD);
		mOpcodes.put(0x1771, OpcodeEnum.VCMPEQ_UQSD);
		mOpcodes.put(0x177e, OpcodeEnum.VCMPNGESD);
		mOpcodes.put(0x1789, OpcodeEnum.VCMPNGTSD);
		mOpcodes.put(0x1794, OpcodeEnum.VCMPFALSESD);
		mOpcodes.put(0x17a1, OpcodeEnum.VCMPNEQ_OQSD);
		mOpcodes.put(0x17af, OpcodeEnum.VCMPGESD);
		mOpcodes.put(0x17b9, OpcodeEnum.VCMPGTSD);
		mOpcodes.put(0x17c3, OpcodeEnum.VCMPTRUESD);
		mOpcodes.put(0x17cf, OpcodeEnum.VCMPEQ_OSSD);
		mOpcodes.put(0x17dc, OpcodeEnum.VCMPLT_OQSD);
		mOpcodes.put(0x17e9, OpcodeEnum.VCMPLE_OQSD);
		mOpcodes.put(0x17f6, OpcodeEnum.VCMPUNORD_SSD);
		mOpcodes.put(0x1805, OpcodeEnum.VCMPNEQ_USSD);
		mOpcodes.put(0x1813, OpcodeEnum.VCMPNLT_UQSD);
		mOpcodes.put(0x1821, OpcodeEnum.VCMPNLE_UQSD);
		mOpcodes.put(0x182f, OpcodeEnum.VCMPORD_SSD);
		mOpcodes.put(0x183c, OpcodeEnum.VCMPEQ_USSD);
		mOpcodes.put(0x1849, OpcodeEnum.VCMPNGE_UQSD);
		mOpcodes.put(0x1857, OpcodeEnum.VCMPNGT_UQSD);
		mOpcodes.put(0x1865, OpcodeEnum.VCMPFALSE_OSSD);
		mOpcodes.put(0x1875, OpcodeEnum.VCMPNEQ_OSSD);
		mOpcodes.put(0x1883, OpcodeEnum.VCMPGE_OQSD);
		mOpcodes.put(0x1890, OpcodeEnum.VCMPGT_OQSD);
		mOpcodes.put(0x189d, OpcodeEnum.VCMPTRUE_USSD);
		mOpcodes.put(0x18ac, OpcodeEnum.PINSRW);
		mOpcodes.put(0x18b4, OpcodeEnum.VPINSRW);
		mOpcodes.put(0x18bd, OpcodeEnum.PEXTRW);
		mOpcodes.put(0x18c5, OpcodeEnum.VPEXTRW);
		mOpcodes.put(0x18ce, OpcodeEnum.SHUFPS);
		mOpcodes.put(0x18d6, OpcodeEnum.SHUFPD);
		mOpcodes.put(0x18de, OpcodeEnum.VSHUFPS);
		mOpcodes.put(0x18e7, OpcodeEnum.VSHUFPD);
		mOpcodes.put(0x18f0, OpcodeEnum.CMPXCHG8B);
		mOpcodes.put(0x18fb, OpcodeEnum.CMPXCHG16B);
		mOpcodes.put(0x1907, OpcodeEnum.VMPTRST);
		mOpcodes.put(0x1910, OpcodeEnum.ADDSUBPD);
		mOpcodes.put(0x191a, OpcodeEnum.ADDSUBPS);
		mOpcodes.put(0x1924, OpcodeEnum.VADDSUBPD);
		mOpcodes.put(0x192f, OpcodeEnum.VADDSUBPS);
		mOpcodes.put(0x193a, OpcodeEnum.PSRLW);
		mOpcodes.put(0x1941, OpcodeEnum.VPSRLW);
		mOpcodes.put(0x1949, OpcodeEnum.PSRLD);
		mOpcodes.put(0x1950, OpcodeEnum.VPSRLD);
		mOpcodes.put(0x1958, OpcodeEnum.PSRLQ);
		mOpcodes.put(0x195f, OpcodeEnum.VPSRLQ);
		mOpcodes.put(0x1967, OpcodeEnum.PADDQ);
		mOpcodes.put(0x196e, OpcodeEnum.VPADDQ);
		mOpcodes.put(0x1976, OpcodeEnum.PMULLW);
		mOpcodes.put(0x197e, OpcodeEnum.VPMULLW);
		mOpcodes.put(0x1987, OpcodeEnum.MOVQ2DQ);
		mOpcodes.put(0x1990, OpcodeEnum.MOVDQ2Q);
		mOpcodes.put(0x1999, OpcodeEnum.PMOVMSKB);
		mOpcodes.put(0x19a3, OpcodeEnum.VPMOVMSKB);
		mOpcodes.put(0x19ae, OpcodeEnum.PSUBUSB);
		mOpcodes.put(0x19b7, OpcodeEnum.VPSUBUSB);
		mOpcodes.put(0x19c1, OpcodeEnum.PSUBUSW);
		mOpcodes.put(0x19ca, OpcodeEnum.VPSUBUSW);
		mOpcodes.put(0x19d4, OpcodeEnum.PMINUB);
		mOpcodes.put(0x19dc, OpcodeEnum.VPMINUB);
		mOpcodes.put(0x19e5, OpcodeEnum.PAND);
		mOpcodes.put(0x19eb, OpcodeEnum.VPAND);
		mOpcodes.put(0x19f2, OpcodeEnum.PADDUSB);
		mOpcodes.put(0x19fb, OpcodeEnum.VPADDUSW);
		mOpcodes.put(0x1a05, OpcodeEnum.PADDUSW);
		mOpcodes.put(0x1a0e, OpcodeEnum.PMAXUB);
		mOpcodes.put(0x1a16, OpcodeEnum.VPMAXUB);
		mOpcodes.put(0x1a1f, OpcodeEnum.PANDN);
		mOpcodes.put(0x1a26, OpcodeEnum.VPANDN);
		mOpcodes.put(0x1a2e, OpcodeEnum.PAVGB);
		mOpcodes.put(0x1a35, OpcodeEnum.VPAVGB);
		mOpcodes.put(0x1a3d, OpcodeEnum.PSRAW);
		mOpcodes.put(0x1a44, OpcodeEnum.VPSRAW);
		mOpcodes.put(0x1a4c, OpcodeEnum.PSRAD);
		mOpcodes.put(0x1a53, OpcodeEnum.VPSRAD);
		mOpcodes.put(0x1a5b, OpcodeEnum.PAVGW);
		mOpcodes.put(0x1a62, OpcodeEnum.VPAVGW);
		mOpcodes.put(0x1a6a, OpcodeEnum.PMULHUW);
		mOpcodes.put(0x1a73, OpcodeEnum.VPMULHUW);
		mOpcodes.put(0x1a7d, OpcodeEnum.PMULHW);
		mOpcodes.put(0x1a85, OpcodeEnum.VPMULHW);
		mOpcodes.put(0x1a8e, OpcodeEnum.CVTTPD2DQ);
		mOpcodes.put(0x1a99, OpcodeEnum.CVTDQ2PD);
		mOpcodes.put(0x1aa3, OpcodeEnum.CVTPD2DQ);
		mOpcodes.put(0x1aad, OpcodeEnum.VCVTTPD2DQ);
		mOpcodes.put(0x1ab9, OpcodeEnum.VCVTDQ2PD);
		mOpcodes.put(0x1ac4, OpcodeEnum.VCVTPD2DQ);
		mOpcodes.put(0x1acf, OpcodeEnum.MOVNTQ);
		mOpcodes.put(0x1ad7, OpcodeEnum.MOVNTDQ);
		mOpcodes.put(0x1ae0, OpcodeEnum.VMOVNTDQ);
		mOpcodes.put(0x1aea, OpcodeEnum.PSUBSB);
		mOpcodes.put(0x1af2, OpcodeEnum.VPSUBSB);
		mOpcodes.put(0x1afb, OpcodeEnum.PSUBSW);
		mOpcodes.put(0x1b03, OpcodeEnum.VPSUBSW);
		mOpcodes.put(0x1b0c, OpcodeEnum.PMINSW);
		mOpcodes.put(0x1b14, OpcodeEnum.VPMINSW);
		mOpcodes.put(0x1b1d, OpcodeEnum.POR);
		mOpcodes.put(0x1b22, OpcodeEnum.VPOR);
		mOpcodes.put(0x1b28, OpcodeEnum.PADDSB);
		mOpcodes.put(0x1b30, OpcodeEnum.VPADDSB);
		mOpcodes.put(0x1b39, OpcodeEnum.PADDSW);
		mOpcodes.put(0x1b41, OpcodeEnum.VPADDSW);
		mOpcodes.put(0x1b4a, OpcodeEnum.PMAXSW);
		mOpcodes.put(0x1b52, OpcodeEnum.VPMAXSW);
		mOpcodes.put(0x1b5b, OpcodeEnum.PXOR);
		mOpcodes.put(0x1b61, OpcodeEnum.VPXOR);
		mOpcodes.put(0x1b68, OpcodeEnum.LDDQU);
		mOpcodes.put(0x1b6f, OpcodeEnum.VLDDQU);
		mOpcodes.put(0x1b77, OpcodeEnum.PSLLW);
		mOpcodes.put(0x1b7e, OpcodeEnum.VPSLLW);
		mOpcodes.put(0x1b86, OpcodeEnum.PSLLD);
		mOpcodes.put(0x1b8d, OpcodeEnum.VPSLLD);
		mOpcodes.put(0x1b95, OpcodeEnum.PSLLQ);
		mOpcodes.put(0x1b9c, OpcodeEnum.VPSLLQ);
		mOpcodes.put(0x1ba4, OpcodeEnum.PMULUDQ);
		mOpcodes.put(0x1bad, OpcodeEnum.VPMULUDQ);
		mOpcodes.put(0x1bb7, OpcodeEnum.PMADDWD);
		mOpcodes.put(0x1bc0, OpcodeEnum.VPMADDWD);
		mOpcodes.put(0x1bca, OpcodeEnum.PSADBW);
		mOpcodes.put(0x1bd2, OpcodeEnum.VPSADBW);
		mOpcodes.put(0x1bdb, OpcodeEnum.MASKMOVQ);
		mOpcodes.put(0x1be5, OpcodeEnum.MASKMOVDQU);
		mOpcodes.put(0x1bf1, OpcodeEnum.VMASKMOVDQU);
		mOpcodes.put(0x1bfe, OpcodeEnum.PSUBB);
		mOpcodes.put(0x1c05, OpcodeEnum.VPSUBB);
		mOpcodes.put(0x1c0d, OpcodeEnum.PSUBW);
		mOpcodes.put(0x1c14, OpcodeEnum.VPSUBW);
		mOpcodes.put(0x1c1c, OpcodeEnum.PSUBD);
		mOpcodes.put(0x1c23, OpcodeEnum.VPSUBD);
		mOpcodes.put(0x1c2b, OpcodeEnum.PSUBQ);
		mOpcodes.put(0x1c32, OpcodeEnum.VPSUBQ);
		mOpcodes.put(0x1c3a, OpcodeEnum.PADDB);
		mOpcodes.put(0x1c41, OpcodeEnum.VPADDB);
		mOpcodes.put(0x1c49, OpcodeEnum.PADDW);
		mOpcodes.put(0x1c50, OpcodeEnum.VPADDW);
		mOpcodes.put(0x1c58, OpcodeEnum.PADDD);
		mOpcodes.put(0x1c5f, OpcodeEnum.VPADDD);
		mOpcodes.put(0x1c67, OpcodeEnum.FNSTENV);
		mOpcodes.put(0x1c70, OpcodeEnum.FSTENV);
		mOpcodes.put(0x1c78, OpcodeEnum.FNSTCW);
		mOpcodes.put(0x1c80, OpcodeEnum.FSTCW);
		mOpcodes.put(0x1c87, OpcodeEnum.FNCLEX);
		mOpcodes.put(0x1c8f, OpcodeEnum.FCLEX);
		mOpcodes.put(0x1c96, OpcodeEnum.FNINIT);
		mOpcodes.put(0x1c9e, OpcodeEnum.FINIT);
		mOpcodes.put(0x1ca5, OpcodeEnum.FNSAVE);
		mOpcodes.put(0x1cad, OpcodeEnum.FSAVE);
		mOpcodes.put(0x1cb4, OpcodeEnum.FNSTSW);
		mOpcodes.put(0x1cbc, OpcodeEnum.FSTSW);
		mOpcodes.put(0x1cc3, OpcodeEnum.PSHUFB);
		mOpcodes.put(0x1ccb, OpcodeEnum.VPSHUFB);
		mOpcodes.put(0x1cd4, OpcodeEnum.PHADDW);
		mOpcodes.put(0x1cdc, OpcodeEnum.VPHADDW);
		mOpcodes.put(0x1ce5, OpcodeEnum.PHADDD);
		mOpcodes.put(0x1ced, OpcodeEnum.VPHADDD);
		mOpcodes.put(0x1cf6, OpcodeEnum.PHADDSW);
		mOpcodes.put(0x1cff, OpcodeEnum.VPHADDSW);
		mOpcodes.put(0x1d09, OpcodeEnum.PMADDUBSW);
		mOpcodes.put(0x1d14, OpcodeEnum.VPMADDUBSW);
		mOpcodes.put(0x1d20, OpcodeEnum.PHSUBW);
		mOpcodes.put(0x1d28, OpcodeEnum.VPHSUBW);
		mOpcodes.put(0x1d31, OpcodeEnum.PHSUBD);
		mOpcodes.put(0x1d39, OpcodeEnum.VPHSUBD);
		mOpcodes.put(0x1d42, OpcodeEnum.PHSUBSW);
		mOpcodes.put(0x1d4b, OpcodeEnum.VPHSUBSW);
		mOpcodes.put(0x1d55, OpcodeEnum.PSIGNB);
		mOpcodes.put(0x1d5d, OpcodeEnum.VPSIGNB);
		mOpcodes.put(0x1d66, OpcodeEnum.PSIGNW);
		mOpcodes.put(0x1d6e, OpcodeEnum.VPSIGNW);
		mOpcodes.put(0x1d77, OpcodeEnum.PSIGND);
		mOpcodes.put(0x1d7f, OpcodeEnum.VPSIGND);
		mOpcodes.put(0x1d88, OpcodeEnum.PMULHRSW);
		mOpcodes.put(0x1d92, OpcodeEnum.VPMULHRSW);
		mOpcodes.put(0x1d9d, OpcodeEnum.VPERMILPS);
		mOpcodes.put(0x1da8, OpcodeEnum.VPERMILPD);
		mOpcodes.put(0x1db3, OpcodeEnum.VTESTPS);
		mOpcodes.put(0x1dbc, OpcodeEnum.VTESTPD);
		mOpcodes.put(0x1dc5, OpcodeEnum.PBLENDVB);
		mOpcodes.put(0x1dcf, OpcodeEnum.BLENDVPS);
		mOpcodes.put(0x1dd9, OpcodeEnum.BLENDVPD);
		mOpcodes.put(0x1de3, OpcodeEnum.PTEST);
		mOpcodes.put(0x1dea, OpcodeEnum.VPTEST);
		mOpcodes.put(0x1df2, OpcodeEnum.VBROADCASTSS);
		mOpcodes.put(0x1e00, OpcodeEnum.VBROADCASTSD);
		mOpcodes.put(0x1e0e, OpcodeEnum.VBROADCASTF128);
		mOpcodes.put(0x1e1e, OpcodeEnum.PABSB);
		mOpcodes.put(0x1e25, OpcodeEnum.VPABSB);
		mOpcodes.put(0x1e2d, OpcodeEnum.PABSW);
		mOpcodes.put(0x1e34, OpcodeEnum.VPABSW);
		mOpcodes.put(0x1e3c, OpcodeEnum.PABSD);
		mOpcodes.put(0x1e43, OpcodeEnum.VPABSD);
		mOpcodes.put(0x1e4b, OpcodeEnum.PMOVSXBW);
		mOpcodes.put(0x1e55, OpcodeEnum.VPMOVSXBW);
		mOpcodes.put(0x1e60, OpcodeEnum.PMOVSXBD);
		mOpcodes.put(0x1e6a, OpcodeEnum.VPMOVSXBD);
		mOpcodes.put(0x1e75, OpcodeEnum.PMOVSXBQ);
		mOpcodes.put(0x1e7f, OpcodeEnum.VPMOVSXBQ);
		mOpcodes.put(0x1e8a, OpcodeEnum.PMOVSXWD);
		mOpcodes.put(0x1e94, OpcodeEnum.VPMOVSXWD);
		mOpcodes.put(0x1e9f, OpcodeEnum.PMOVSXWQ);
		mOpcodes.put(0x1ea9, OpcodeEnum.VPMOVSXWQ);
		mOpcodes.put(0x1eb4, OpcodeEnum.PMOVSXDQ);
		mOpcodes.put(0x1ebe, OpcodeEnum.VPMOVSXDQ);
		mOpcodes.put(0x1ec9, OpcodeEnum.PMULDQ);
		mOpcodes.put(0x1ed1, OpcodeEnum.VPMULDQ);
		mOpcodes.put(0x1eda, OpcodeEnum.PCMPEQQ);
		mOpcodes.put(0x1ee3, OpcodeEnum.VPCMPEQQ);
		mOpcodes.put(0x1eed, OpcodeEnum.MOVNTDQA);
		mOpcodes.put(0x1ef7, OpcodeEnum.VMOVNTDQA);
		mOpcodes.put(0x1f02, OpcodeEnum.PACKUSDW);
		mOpcodes.put(0x1f0c, OpcodeEnum.VPACKUSDW);
		mOpcodes.put(0x1f17, OpcodeEnum.VMASKMOVPS);
		mOpcodes.put(0x1f23, OpcodeEnum.VMASKMOVPD);
		mOpcodes.put(0x1f2f, OpcodeEnum.PMOVZXBW);
		mOpcodes.put(0x1f39, OpcodeEnum.VPMOVZXBW);
		mOpcodes.put(0x1f44, OpcodeEnum.PMOVZXBD);
		mOpcodes.put(0x1f4e, OpcodeEnum.VPMOVZXBD);
		mOpcodes.put(0x1f59, OpcodeEnum.PMOVZXBQ);
		mOpcodes.put(0x1f63, OpcodeEnum.VPMOVZXBQ);
		mOpcodes.put(0x1f6e, OpcodeEnum.PMOVZXWD);
		mOpcodes.put(0x1f78, OpcodeEnum.VPMOVZXWD);
		mOpcodes.put(0x1f83, OpcodeEnum.PMOVZXWQ);
		mOpcodes.put(0x1f8d, OpcodeEnum.VPMOVZXWQ);
		mOpcodes.put(0x1f98, OpcodeEnum.PMOVZXDQ);
		mOpcodes.put(0x1fa2, OpcodeEnum.VPMOVZXDQ);
		mOpcodes.put(0x1fad, OpcodeEnum.PCMPGTQ);
		mOpcodes.put(0x1fb6, OpcodeEnum.VPCMPGTQ);
		mOpcodes.put(0x1fc0, OpcodeEnum.PMINSB);
		mOpcodes.put(0x1fc8, OpcodeEnum.VPMINSB);
		mOpcodes.put(0x1fd1, OpcodeEnum.PMINSD);
		mOpcodes.put(0x1fd9, OpcodeEnum.VPMINSD);
		mOpcodes.put(0x1fe2, OpcodeEnum.PMINUW);
		mOpcodes.put(0x1fea, OpcodeEnum.VPMINUW);
		mOpcodes.put(0x1ff3, OpcodeEnum.PMINUD);
		mOpcodes.put(0x1ffb, OpcodeEnum.VPMINUD);
		mOpcodes.put(0x2004, OpcodeEnum.PMAXSB);
		mOpcodes.put(0x200c, OpcodeEnum.VPMAXSB);
		mOpcodes.put(0x2015, OpcodeEnum.PMAXSD);
		mOpcodes.put(0x201d, OpcodeEnum.VPMAXSD);
		mOpcodes.put(0x2026, OpcodeEnum.PMAXUW);
		mOpcodes.put(0x202e, OpcodeEnum.VPMAXUW);
		mOpcodes.put(0x2037, OpcodeEnum.PMAXUD);
		mOpcodes.put(0x203f, OpcodeEnum.VPMAXUD);
		mOpcodes.put(0x2048, OpcodeEnum.PMULLD);
		mOpcodes.put(0x2050, OpcodeEnum.VPMULLD);
		mOpcodes.put(0x2059, OpcodeEnum.PHMINPOSUW);
		mOpcodes.put(0x2065, OpcodeEnum.VPHMINPOSUW);
		mOpcodes.put(0x2072, OpcodeEnum.INVEPT);
		mOpcodes.put(0x207a, OpcodeEnum.INVVPID);
		mOpcodes.put(0x2083, OpcodeEnum.INVPCID);
		mOpcodes.put(0x208c, OpcodeEnum.VFMADDSUB132PS);
		mOpcodes.put(0x209c, OpcodeEnum.VFMADDSUB132PD);
		mOpcodes.put(0x20ac, OpcodeEnum.VFMSUBADD132PS);
		mOpcodes.put(0x20bc, OpcodeEnum.VFMSUBADD132PD);
		mOpcodes.put(0x20cc, OpcodeEnum.VFMADD132PS);
		mOpcodes.put(0x20d9, OpcodeEnum.VFMADD132PD);
		mOpcodes.put(0x20e6, OpcodeEnum.VFMADD132SS);
		mOpcodes.put(0x20f3, OpcodeEnum.VFMADD132SD);
		mOpcodes.put(0x2100, OpcodeEnum.VFMSUB132PS);
		mOpcodes.put(0x210d, OpcodeEnum.VFMSUB132PD);
		mOpcodes.put(0x211a, OpcodeEnum.VFMSUB132SS);
		mOpcodes.put(0x2127, OpcodeEnum.VFMSUB132SD);
		mOpcodes.put(0x2134, OpcodeEnum.VFNMADD132PS);
		mOpcodes.put(0x2142, OpcodeEnum.VFNMADD132PD);
		mOpcodes.put(0x2150, OpcodeEnum.VFNMADD132SS);
		mOpcodes.put(0x215e, OpcodeEnum.VFNMADD132SD);
		mOpcodes.put(0x216c, OpcodeEnum.VFNMSUB132PS);
		mOpcodes.put(0x217a, OpcodeEnum.VFNMSUB132PD);
		mOpcodes.put(0x2188, OpcodeEnum.VFNMSUB132SS);
		mOpcodes.put(0x2196, OpcodeEnum.VFNMSUB132SD);
		mOpcodes.put(0x21a4, OpcodeEnum.VFMADDSUB213PS);
		mOpcodes.put(0x21b4, OpcodeEnum.VFMADDSUB213PD);
		mOpcodes.put(0x21c4, OpcodeEnum.VFMSUBADD213PS);
		mOpcodes.put(0x21d4, OpcodeEnum.VFMSUBADD213PD);
		mOpcodes.put(0x21e4, OpcodeEnum.VFMADD213PS);
		mOpcodes.put(0x21f1, OpcodeEnum.VFMADD213PD);
		mOpcodes.put(0x21fe, OpcodeEnum.VFMADD213SS);
		mOpcodes.put(0x220b, OpcodeEnum.VFMADD213SD);
		mOpcodes.put(0x2218, OpcodeEnum.VFMSUB213PS);
		mOpcodes.put(0x2225, OpcodeEnum.VFMSUB213PD);
		mOpcodes.put(0x2232, OpcodeEnum.VFMSUB213SS);
		mOpcodes.put(0x223f, OpcodeEnum.VFMSUB213SD);
		mOpcodes.put(0x224c, OpcodeEnum.VFNMADD213PS);
		mOpcodes.put(0x225a, OpcodeEnum.VFNMADD213PD);
		mOpcodes.put(0x2268, OpcodeEnum.VFNMADD213SS);
		mOpcodes.put(0x2276, OpcodeEnum.VFNMADD213SD);
		mOpcodes.put(0x2284, OpcodeEnum.VFNMSUB213PS);
		mOpcodes.put(0x2292, OpcodeEnum.VFNMSUB213PD);
		mOpcodes.put(0x22a0, OpcodeEnum.VFNMSUB213SS);
		mOpcodes.put(0x22ae, OpcodeEnum.VFNMSUB213SD);
		mOpcodes.put(0x22bc, OpcodeEnum.VFMADDSUB231PS);
		mOpcodes.put(0x22cc, OpcodeEnum.VFMADDSUB231PD);
		mOpcodes.put(0x22dc, OpcodeEnum.VFMSUBADD231PS);
		mOpcodes.put(0x22ec, OpcodeEnum.VFMSUBADD231PD);
		mOpcodes.put(0x22fc, OpcodeEnum.VFMADD231PS);
		mOpcodes.put(0x2309, OpcodeEnum.VFMADD231PD);
		mOpcodes.put(0x2316, OpcodeEnum.VFMADD231SS);
		mOpcodes.put(0x2323, OpcodeEnum.VFMADD231SD);
		mOpcodes.put(0x2330, OpcodeEnum.VFMSUB231PS);
		mOpcodes.put(0x233d, OpcodeEnum.VFMSUB231PD);
		mOpcodes.put(0x234a, OpcodeEnum.VFMSUB231SS);
		mOpcodes.put(0x2357, OpcodeEnum.VFMSUB231SD);
		mOpcodes.put(0x2364, OpcodeEnum.VFNMADD231PS);
		mOpcodes.put(0x2372, OpcodeEnum.VFNMADD231PD);
		mOpcodes.put(0x2380, OpcodeEnum.VFNMADD231SS);
		mOpcodes.put(0x238e, OpcodeEnum.VFNMADD231SD);
		mOpcodes.put(0x239c, OpcodeEnum.VFNMSUB231PS);
		mOpcodes.put(0x23aa, OpcodeEnum.VFNMSUB231PD);
		mOpcodes.put(0x23b8, OpcodeEnum.VFNMSUB231SS);
		mOpcodes.put(0x23c6, OpcodeEnum.VFNMSUB231SD);
		mOpcodes.put(0x23d4, OpcodeEnum.AESIMC);
		mOpcodes.put(0x23dc, OpcodeEnum.VAESIMC);
		mOpcodes.put(0x23e5, OpcodeEnum.AESENC);
		mOpcodes.put(0x23ed, OpcodeEnum.VAESENC);
		mOpcodes.put(0x23f6, OpcodeEnum.AESENCLAST);
		mOpcodes.put(0x2402, OpcodeEnum.VAESENCLAST);
		mOpcodes.put(0x240f, OpcodeEnum.AESDEC);
		mOpcodes.put(0x2417, OpcodeEnum.VAESDEC);
		mOpcodes.put(0x2420, OpcodeEnum.AESDECLAST);
		mOpcodes.put(0x242c, OpcodeEnum.VAESDECLAST);
		mOpcodes.put(0x2439, OpcodeEnum.MOVBE);
		mOpcodes.put(0x2440, OpcodeEnum.CRC32);
		mOpcodes.put(0x2447, OpcodeEnum.VPERM2F128);
		mOpcodes.put(0x2453, OpcodeEnum.ROUNDPS);
		mOpcodes.put(0x245c, OpcodeEnum.VROUNDPS);
		mOpcodes.put(0x2466, OpcodeEnum.ROUNDPD);
		mOpcodes.put(0x246f, OpcodeEnum.VROUNDPD);
		mOpcodes.put(0x2479, OpcodeEnum.ROUNDSS);
		mOpcodes.put(0x2482, OpcodeEnum.VROUNDSS);
		mOpcodes.put(0x248c, OpcodeEnum.ROUNDSD);
		mOpcodes.put(0x2495, OpcodeEnum.VROUNDSD);
		mOpcodes.put(0x249f, OpcodeEnum.BLENDPS);
		mOpcodes.put(0x24a8, OpcodeEnum.VBLENDPS);
		mOpcodes.put(0x24b2, OpcodeEnum.BLENDPD);
		mOpcodes.put(0x24bb, OpcodeEnum.VBLENDPD);
		mOpcodes.put(0x24c5, OpcodeEnum.PBLENDW);
		mOpcodes.put(0x24ce, OpcodeEnum.VPBLENDW);
		mOpcodes.put(0x24d8, OpcodeEnum.PALIGNR);
		mOpcodes.put(0x24e1, OpcodeEnum.VPALIGNR);
		mOpcodes.put(0x24eb, OpcodeEnum.PEXTRB);
		mOpcodes.put(0x24f3, OpcodeEnum.VPEXTRB);
		mOpcodes.put(0x24fc, OpcodeEnum.PEXTRD);
		mOpcodes.put(0x2504, OpcodeEnum.PEXTRQ);
		mOpcodes.put(0x250c, OpcodeEnum.VPEXTRD);
		mOpcodes.put(0x2515, OpcodeEnum.VPEXTRQ);
		mOpcodes.put(0x251e, OpcodeEnum.EXTRACTPS);
		mOpcodes.put(0x2529, OpcodeEnum.VEXTRACTPS);
		mOpcodes.put(0x2535, OpcodeEnum.VINSERTF128);
		mOpcodes.put(0x2542, OpcodeEnum.VEXTRACTF128);
		mOpcodes.put(0x2550, OpcodeEnum.PINSRB);
		mOpcodes.put(0x2558, OpcodeEnum.VPINSRB);
		mOpcodes.put(0x2561, OpcodeEnum.INSERTPS);
		mOpcodes.put(0x256b, OpcodeEnum.VINSERTPS);
		mOpcodes.put(0x2576, OpcodeEnum.PINSRD);
		mOpcodes.put(0x257e, OpcodeEnum.PINSRQ);
		mOpcodes.put(0x2586, OpcodeEnum.VPINSRD);
		mOpcodes.put(0x258f, OpcodeEnum.VPINSRQ);
		mOpcodes.put(0x2598, OpcodeEnum.DPPS);
		mOpcodes.put(0x259e, OpcodeEnum.VDPPS);
		mOpcodes.put(0x25a5, OpcodeEnum.DPPD);
		mOpcodes.put(0x25ab, OpcodeEnum.VDPPD);
		mOpcodes.put(0x25b2, OpcodeEnum.MPSADBW);
		mOpcodes.put(0x25bb, OpcodeEnum.VMPSADBW);
		mOpcodes.put(0x25c5, OpcodeEnum.PCLMULQDQ);
		mOpcodes.put(0x25d0, OpcodeEnum.VPCLMULQDQ);
		mOpcodes.put(0x25dc, OpcodeEnum.VBLENDVPS);
		mOpcodes.put(0x25e7, OpcodeEnum.VBLENDVPD);
		mOpcodes.put(0x25f2, OpcodeEnum.VPBLENDVB);
		mOpcodes.put(0x25fd, OpcodeEnum.PCMPESTRM);
		mOpcodes.put(0x2608, OpcodeEnum.VPCMPESTRM);
		mOpcodes.put(0x2614, OpcodeEnum.PCMPESTRI);
		mOpcodes.put(0x261f, OpcodeEnum.VPCMPESTRI);
		mOpcodes.put(0x262b, OpcodeEnum.PCMPISTRM);
		mOpcodes.put(0x2636, OpcodeEnum.VPCMPISTRM);
		mOpcodes.put(0x2642, OpcodeEnum.PCMPISTRI);
		mOpcodes.put(0x264d, OpcodeEnum.VPCMPISTRI);
		mOpcodes.put(0x2659, OpcodeEnum.AESKEYGENASSIST);
		mOpcodes.put(0x266a, OpcodeEnum.VAESKEYGENASSIST);
		mOpcodes.put(0x267c, OpcodeEnum.PSRLDQ);
		mOpcodes.put(0x2684, OpcodeEnum.VPSRLDQ);
		mOpcodes.put(0x268d, OpcodeEnum.PSLLDQ);
		mOpcodes.put(0x2695, OpcodeEnum.VPSLLDQ);
		mOpcodes.put(0x269e, OpcodeEnum.FXSAVE);
		mOpcodes.put(0x26a6, OpcodeEnum.FXSAVE64);
		mOpcodes.put(0x26b0, OpcodeEnum.RDFSBASE);
		mOpcodes.put(0x26ba, OpcodeEnum.FXRSTOR);
		mOpcodes.put(0x26c3, OpcodeEnum.FXRSTOR64);
		mOpcodes.put(0x26ce, OpcodeEnum.RDGSBASE);
		mOpcodes.put(0x26d8, OpcodeEnum.LDMXCSR);
		mOpcodes.put(0x26e1, OpcodeEnum.WRFSBASE);
		mOpcodes.put(0x26eb, OpcodeEnum.VLDMXCSR);
		mOpcodes.put(0x26f5, OpcodeEnum.STMXCSR);
		mOpcodes.put(0x26fe, OpcodeEnum.WRGSBASE);
		mOpcodes.put(0x2708, OpcodeEnum.VSTMXCSR);
		mOpcodes.put(0x2712, OpcodeEnum.VMPTRLD);
		mOpcodes.put(0x271b, OpcodeEnum.VMCLEAR);
		mOpcodes.put(0x2724, OpcodeEnum.VMXON);
		mOpcodes.put(0x272b, OpcodeEnum.MOVSXD);
		mOpcodes.put(0x2733, OpcodeEnum.PAUSE);
		mOpcodes.put(0x273a, OpcodeEnum.WAIT);
		mOpcodes.put(0x2740, OpcodeEnum.RDRAND);
		mOpcodes.put(0x2748, OpcodeEnum._3DNOW);
	}
}
